/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-app-subapp.h,v 1.12 2003/12/10 23:16:45 hoa Exp $
 */

#ifndef ETPAN_APP_SUBAPP_H

#define ETPAN_APP_SUBAPP_H

#include "etpan-app-types.h"
#include "etpan-subapp-types.h"

void etpan_app_set_color(struct etpan_app * app,
    char * name, int * attr, int default_attr);

void etpan_app_run(struct etpan_app * app, struct etpan_subapp * subapp);

void etpan_app_switch_subapp(struct etpan_subapp * subapp, int leave_last);

int etpan_app_add_subapp(struct etpan_app * app,
    struct etpan_subapp * subapp);

void etpan_app_remove_subapp(struct etpan_app * app,
    struct etpan_subapp * subapp);

void etpan_app_stop(struct etpan_app * app);

struct etpan_subapp *
etpan_app_find_subapp(struct etpan_app * app, char * drivername,
    int enabled,
    int (* compare)(struct etpan_subapp *, void *), void * data);

struct etpan_subapp *
etpan_app_find_child_subapp(struct etpan_subapp * app, int enabled);

int etpan_app_subapp_display_init(struct etpan_subapp * app);

void etpan_app_display_init(struct etpan_app * app);

void etpan_app_display_done(struct etpan_app * app);

void etpan_app_set_colors(struct etpan_app * app);

#if 0
int etpan_ref_message(struct etpan_subapp * app,
    struct mailfolder * folder, mailmessage * msg);

void etpan_unref_message(struct etpan_subapp * app,
    struct mailfolder * folder, mailmessage * msg);
#endif

void etpan_app_quit_subapp(struct etpan_subapp * app);

void etpan_app_leave_subapp(struct etpan_subapp * subapp,
    struct etpan_subapp * new_subapp);

#if 0
int etpan_app_ref_message(struct etpan_subapp * app, mailmessage * msg);

void etpan_app_unref_message(struct etpan_subapp * app, mailmessage * msg);
#endif

mailmessage * etpan_app_get_message(struct etpan_subapp * app);

#endif
