#include "etpan-3paned.h"

#include <stdlib.h>

#include "etpan-subapp.h"
#include "etpan-app-subapp.h"
#include "etpan-3paned-types.h"
#include "etpan-folder-list-app.h"
#include "etpan-msg-list-app.h"
#include "etpan-msg-viewer-app.h"

struct etpan_3paned * etpan_3paned_new(struct etpan_app * app)
{
  struct etpan_3paned * state;
  struct etpan_subapp * msglist_app;
  struct etpan_subapp * msgviewer_app;
  struct etpan_subapp * folderlist_app;
  int r;
  
  folderlist_app = etpan_folder_list_app_new(app);
  if (folderlist_app == NULL)
    goto err;
  
  r = etpan_folder_list_set_root_folder(folderlist_app,
      app->config.vfolder_config->root);
  
  msglist_app = etpan_msg_list_app_new(app);
  if (msglist_app == NULL)
    goto free_folderlist;
  etpan_subapp_set_parent(msglist_app, folderlist_app);
  
  if (app->config.vfolder_config->default_folder != NULL) {
    etpan_msg_list_app_set_folder(msglist_app,
        app->config.vfolder_config->default_folder);
  }
  
  msgviewer_app = etpan_msg_viewer_app_new(app);
  if (msgviewer_app == NULL)
    goto free_msglist;
  etpan_subapp_set_parent(msgviewer_app, msglist_app);
  
  state = malloc(sizeof(* state));
  if (state == NULL)
    goto free_msgview;
  
  state->folderlist = folderlist_app;
  state->msglist = msglist_app;
  state->msgview = msgviewer_app;
  
  return state;
  
 free_msgview:
#if 0
  etpan_subapp_free(msgviewer_app);
#endif
 free_msglist:
#if 0
  etpan_subapp_free(msglist_app);
#endif
 free_folderlist:
#if 0
  etpan_subapp_free(folderlist_app);
#endif
 err:
  return NULL;
}

void etpan_3paned_free(struct etpan_3paned * state)
{
  state->msgview = NULL;
  state->msglist = NULL;
  state->folderlist = NULL;
  free(state);
}

int etpan_3paned(struct etpan_app * app)
{
  return (app->config.global_config->ui_style == ETPAN_UI_STYLE_3PANED);
}

struct etpan_subapp * etpan_3paned_get_msglist(struct etpan_app * app)
{
#if 0
  return etpan_app_find_subapp(app, "msg-list",
      1, NULL, NULL);
#endif
  return app->state_3paned->msglist;
}

struct etpan_subapp * etpan_3paned_get_folderlist(struct etpan_app * app)
{
#if 0
  return etpan_app_find_subapp(app, "folder-list",
      1, NULL, NULL);
#endif
  return app->state_3paned->folderlist;
}

struct etpan_subapp * etpan_3paned_get_msgview(struct etpan_app * app)
{
#if 0
  return etpan_app_find_subapp(app, "msg-viewer",
      1, NULL, NULL);
#endif
  return app->state_3paned->msgview;
}

void etpan_3paned_resize(struct etpan_app * app)
{
  struct etpan_subapp * subapp;
  
  subapp = etpan_3paned_get_msglist(app);
  subapp->left = app->config.global_config->ui_3paned_folderlist_width;
  subapp->top = 0;
  subapp->width = app->width -
    app->config.global_config->ui_3paned_folderlist_width;
  subapp->height = app->config.global_config->ui_3paned_msglist_height;
  etpan_subapp_set_relative_coord(subapp);
  etpan_subapp_handle_resize(subapp);
  
  subapp = etpan_3paned_get_folderlist(app);
  subapp->left = 0;
  subapp->top = 0;
  subapp->width = app->config.global_config->ui_3paned_folderlist_width;
  subapp->height = (app->height - 1);
  etpan_subapp_set_relative_coord(subapp);
  etpan_subapp_handle_resize(subapp);
  
  subapp = etpan_3paned_get_msgview(app);
  subapp->left = app->config.global_config->ui_3paned_folderlist_width;
  subapp->top = app->config.global_config->ui_3paned_msglist_height;
  subapp->width = app->width -
    app->config.global_config->ui_3paned_folderlist_width;
  subapp->height = (app->height - 1) -
    app->config.global_config->ui_3paned_msglist_height;
  etpan_subapp_set_relative_coord(subapp);
  etpan_subapp_handle_resize(subapp);
}

void etpan_3paned_setup(struct etpan_app * app)
{
    etpan_app_switch_subapp(app->state_3paned->folderlist, 0);
    etpan_app_switch_subapp(app->state_3paned->msglist, 0);
    etpan_app_switch_subapp(app->state_3paned->msgview, 0);
    
    if (app->config.vfolder_config->default_folder != NULL)
      etpan_app_switch_subapp(app->state_3paned->msglist, 0);
    else
      etpan_app_switch_subapp(app->state_3paned->folderlist, 0);
}

void etpan_3paned_check_switch(struct etpan_app * app)
{
  int is_3paned_app;
  struct etpan_subapp * subapp;
  
  is_3paned_app = 0;
  
  subapp = app->current_subapp;
  if (subapp == etpan_3paned_get_msglist(app))
    is_3paned_app = 1;
  
  if (subapp == etpan_3paned_get_folderlist(app))
    is_3paned_app = 1;
  
  if (subapp == etpan_3paned_get_msgview(app))
    is_3paned_app = 1;
  
  if (is_3paned_app) {
    etpan_app_switch_subapp(etpan_3paned_get_folderlist(app), 0);
    etpan_app_switch_subapp(etpan_3paned_get_msglist(app), 0);
    etpan_app_switch_subapp(etpan_3paned_get_msgview(app), 0);
    
    etpan_app_switch_subapp(subapp, 0);
  }
}

