#############################################################
##                                                         ##
## Copyright (c) 2003-2011 by The University of Queensland ##
## Earth Systems Science Computational Centre (ESSCC)      ##
## http://www.uq.edu.au/esscc                              ##
##                                                         ##
## Primary Business: Brisbane, Queensland, Australia       ##
## Licensed under the Open Software License version 3.0    ##
## http://www.opensource.org/licenses/osl-3.0.php          ##
##                                                         ##
#############################################################

import os
import os.path

def removeDirs(dir):
    """
        Recursively removes directory and (ie all contents and
        all subdirectories).
    """
    for f in os.listdir(dir):
        absFile = os.path.join(dir, f)
        if (os.path.isdir(absFile)):
            removeDirs(absFile)
        else:
            os.remove(absFile)
    os.rmdir(dir)
