/* $Id: er_pluginlist.h,v 1.9 2007/06/04 15:45:49 kbanse Exp $
 *
 *   This file is part of the ESO Common Pipeline Library
 *   Copyright (C) 2001-2004 European Southern Observatory
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: kbanse $
 * $Date: 2007/06/04 15:45:49 $
 * $Revision: 1.9 $
 * $Name: esorex-3_9_0 $
 */


#ifndef ER_PLUGINLIST_H
#define ER_PLUGINLIST_H


CPL_BEGIN_DECLS

extern er_stringarray_t *er_pluginlist_create_list
(
  char ** listname
);

extern int er_pluginlist_get_libpath
(
  er_stringarray_t *list_of_pllibs,
  const char     *plugin_name,
  char  *libpath
);

# ifndef S_SPLINT_S
extern cpl_plugin *er_pluginlist_get_plugin
(
  const char     *library_name,
  const char     *plugin_name,
  lt_dlhandle    *module
);
#endif


extern void er_pluginlist_create_cache
(
  er_stringarray_t *nama,
  er_stringarray_t *namb
);


extern void er_pluginlist_print_list
(
  er_stringarray_t *list_of_pllibs
);


/* extern int er_pluginlist_check_duplicates			not used ...
  (
  er_stringarray_t *list_of_pllibs,
  char           *plugin_name
  );
*/


CPL_END_DECLS

#endif


/* End of file */

