""" A drag drawn line. """


from enthought.enable import Line



class DragLine(Line):
    """ A drag drawn line. """


    ###########################################################################
    # Trait definitions.
    ###########################################################################

    # Override the vertex color so as to not draw it.
    vertex_color = (0.0, 0.0, 0.0, 0.0)

    ###########################################################################
    # 'Component' interface.
    ###########################################################################

    #### 'complete' state #####################################################

    def complete_draw(self, gc):
        """ Draw the completed line. """

        self.line_dash = None

        gc.save_state()
        self._draw(gc)
        gc.restore_state()

        return

    #### 'drawing' state ######################################################

    def drawing_draw(self, gc):

        self.line_dash = (4.0, 2.0)
        
        gc.save_state()
        self._draw(gc)
        gc.restore_state()

        return

    def drawing_left_up(self, event):
        """ Handle the left mouse button coming up in the 'drawing' state. """

        self.event_state = 'complete'
        self.pointer = 'arrow'

        self.redraw()

        self.complete = True

        return

    def drawing_mouse_move(self, event):
        """ Handle the mouse moving in 'drawing' state. """

        last_point = self.points[-1]

        # If we have moved, we need to add a point.
        if last_point != (event.x + self.x, event.y - self.y):
            self.points.append((event.x + self.x, event.y - self.y))
            self.redraw()

        return

    #### 'normal' state #######################################################

    def normal_left_down(self, event):
        """ Handle the left button down in the 'normal' state. """

        self.points.append((event.x + self.x, event.y - self.y))

        self.event_state = 'drawing'

        self.redraw()

        return

    def normal_mouse_move(self, event):

        self.pointer = 'pencil'

        return

#### EOF ######################################################################
        
