""" Test app for the Polygon class. """

from enthought.enable import Component, FilledContainer, Polygon
from enthought.enable.wx import Window
from enthought.pyface.api import ApplicationWindow, GUI

class PolygonTestWindow(ApplicationWindow):
    """ The application window. """

    ###########################################################################
    # 'Window' interface.
    ###########################################################################

    def _create_contents(self, parent):
        filled_container = FilledContainer()
        filled_container.add( self._create_polygon() )
        window = Window(parent, component=filled_container)

        return window.control

    ###########################################################################
    # Private interface.
    ###########################################################################

    def _create_polygon(self):
        polygon = Polygon(background_color = (1.0, 0.5, 0.2, 0.6))

        polygon.points.append((30.0, 10.0))
        polygon.points.append((20.0, 10.0))
        polygon.points.append((20.0, 90.0))
        polygon.points.append((10.0, 10.0))

        return polygon

    
def main():
    # Create the GUI (this does NOT start the GUI event loop).
    gui = GUI()

    # Screen size:
    screen_width = gui.system_metrics.screen_width or 1024
    screen_height = gui.system_metrics.screen_height or 768

    # Create and open the main window.
    window = PolygonTestWindow( title = "Polygon Test" )
    window.size = ( screen_width / 3, screen_height / 3 )
    window.open()
    
    # Start the GUI event loop.
    gui.event_loop()


##########################################################################
# Program start-up:
##########################################################################

if __name__ == '__main__':
    main()
