import os.path
import sys
import unittest

class FileFormatTestCase( unittest.TestCase ):
    
    def setUp(self):
        try:
            name = sys.modules[self.__class__.__module__].__file__
            self.data_dir = os.path.join(os.path.dirname(name), "images")
        except Exception, ex:
            print ex
            self.data_dir = None
            
    def _load_file(self, filename):
        self.assert_(self.data_dir != None)
        import enthought.enable.base
        enthought.enable.base.gc_image_for(filename)
        
    def test_png(self):
        self._load_file(os.path.join(self.data_dir, "apple.png"))
        
    def test_jpeg(self):
        self._load_file(os.path.join(self.data_dir, "splash.jpg"))

    def test_gif(self):
        self._load_file(os.path.join(self.data_dir, "component.gif"))
        