#-------------------------------------------------------------------------------
#  
#  Defines the OMComponentController class of the Enable 'om' (Object Model) 
#  package. 
#
#  The OMComponentController class defines the base class for creating 
#  controllers used to connect and control the relationship between a canvas 
#  component (i.e. OMComponent object) and an object in the underlying object 
#  model. The controller mediates all interaction between events that occur on 
#  the canvas component and the object model object.
#  
#  Written by: David C. Morrill
#  
#  Date: 01/27/2005
#  
#  (c) Copyright 2005 by Enthought, Inc.
#  
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
#  Imports:  
#-------------------------------------------------------------------------------

from om_canvas_controller \
    import OMCanvasController

from om_menu_controller \
    import menu_controller

from enthought.traits.api \
    import HasPrivateTraits, Instance

#-------------------------------------------------------------------------------
#  'OMComponentController' class:
#-------------------------------------------------------------------------------

class OMComponentController ( HasPrivateTraits ):
    
    #---------------------------------------------------------------------------
    #  Trait definitions:  
    #---------------------------------------------------------------------------
        
    # The associated canvas controller:
    canvas_controller = Instance( OMCanvasController )
    
    #---------------------------------------------------------------------------
    #  Returns whether or not a specified component can be dragged:  
    #---------------------------------------------------------------------------
        
    def can_drag_component ( self, component ):
        return True
        
    #---------------------------------------------------------------------------
    #  Returns whether or not a specified component can be selected/unselected:  
    #---------------------------------------------------------------------------
    
    def can_select_component ( self, component ):
        return True
        
    #---------------------------------------------------------------------------
    #  Edit the traits of the specified component:  
    #---------------------------------------------------------------------------
    
    def edit_component ( self, component ):
        component.edit()
        
    #---------------------------------------------------------------------------
    #  Process the user clicking a component's label:  
    #---------------------------------------------------------------------------
    
    def label_clicked ( self, component, event ):
        pass
        
    #---------------------------------------------------------------------------
    #  Begins a drag operation when the 'control' key is pressed:  
    #---------------------------------------------------------------------------
                
    def begin_control_drag ( self, component, event ):
        """ Begins a drag operation when the 'control' key is pressed.
        """
        return False
        
    #---------------------------------------------------------------------------
    #  Begins a drag operation when the 'shift' key is pressed:  
    #---------------------------------------------------------------------------
                
    def begin_shift_drag ( self, component, event ):
        """ Begins a drag operation when the 'shift' key is pressed.
        """
        return False
        
    #---------------------------------------------------------------------------
    #  Begins a drag operation when the 'alt' key is pressed:  
    #---------------------------------------------------------------------------
                
    def begin_alt_drag ( self, component, event ):
        """ Begins a drag operation when the 'alt' key is pressed.
        """
        return False
        
    #---------------------------------------------------------------------------
    #  Display the component's context menu:
    #
    #  Note: The 'GetSizeTuple/PopupMenuXY' calls make this code wxPython
    #        specific
    #---------------------------------------------------------------------------
    
    def popup_menu ( self, component, event ):
        menu = component.menu
        if menu is not None:
            self._component            = component
            self._event                = event
            menu_controller.controller = self
            window                     = component.window.control
            dx, dy                     = window.GetSizeTuple()
            window.PopupMenuXY( menu.create_menu( window, menu_controller ),
                                event.x - 10, dy - event.y - 10 )
            self._component = self._event = None
                
