#include <gtk/gtk.h>
#include "../cdialog.h"

int main(int argc, char *argv[])
{
	gint i, response, dialog_style = CDIALOG_ICON_INFO;
	guint	btn_flags = CDIALOG_BTNFLAG_OK,
		def_btn = CDIALOG_BTNFLAG_OK;
	const gchar *arg;
	const gchar *message = NULL;

	if(argc < 2)
	{
	    /* Print usage if no arguments are given but do not
	     * exit
	     */
	    g_print(
"Usage: %s [dialog_style] [message]\n\
\n\
    Where [dialog_style] can be any of the following:\n\
\n\
	-i                      - Info.\n\
	-q                      - Question.\n\
	-qa                     - Question (includes yes to all)\n\
	-w                      - Warning.\n\
	-e                      - Error.\n\
	-h                      - Help.\n\
\n\
    Where [message] is the message that you want to display.\n\
\n\
    Returns:\n\
\n\
        %i                       - No.\n\
        %i                       - Yes.\n\
        %i                       - Yes to all.\n\
        %i                       - Cancel.\n\
        %i                       - OK.\n\
\n",
		argv[0],
		CDIALOG_RESPONSE_NO,
		CDIALOG_RESPONSE_YES,
		CDIALOG_RESPONSE_YES_TO_ALL,
		CDIALOG_RESPONSE_CANCEL,
		CDIALOG_RESPONSE_OK
	    );
	}

	for(i = 1; i < argc; i++)
	{
	    arg = argv[i];
	    if(arg == NULL)
		continue;

	    if(!g_strcasecmp(arg, "-i"))
	    {
		dialog_style = CDIALOG_ICON_INFO;
		btn_flags = CDIALOG_BTNFLAG_OK;
		def_btn = CDIALOG_BTNFLAG_OK;
	    }
	    else if(!g_strcasecmp(arg, "-q"))
	    {
		dialog_style = CDIALOG_ICON_QUESTION;
		btn_flags = CDIALOG_BTNFLAG_YES | CDIALOG_BTNFLAG_NO;
		def_btn = CDIALOG_BTNFLAG_YES;
	    }
	    else if(!g_strcasecmp(arg, "-qa"))
	    {
		dialog_style = CDIALOG_ICON_QUESTION;
		btn_flags = CDIALOG_BTNFLAG_YES | CDIALOG_BTNFLAG_YES_TO_ALL |
		    CDIALOG_BTNFLAG_NO;
		def_btn = CDIALOG_BTNFLAG_YES;
	    }
	    else if(!g_strcasecmp(arg, "-w"))
	    {
		dialog_style = CDIALOG_ICON_WARNING;
		btn_flags = CDIALOG_BTNFLAG_OK;
		def_btn = CDIALOG_BTNFLAG_OK;
	    }
	    else if(!g_strcasecmp(arg, "-e"))
	    {
		dialog_style = CDIALOG_ICON_ERROR;
		btn_flags = CDIALOG_BTNFLAG_OK;
		def_btn = CDIALOG_BTNFLAG_OK;
	    }
	    else if(!g_strcasecmp(arg, "--help") ||
		    !g_strcasecmp(arg, "-help") ||
		    !g_strcasecmp(arg, "--h") ||
		    !g_strcasecmp(arg, "-h")
	    )
	    {
		dialog_style = CDIALOG_ICON_HELP;
		btn_flags = CDIALOG_BTNFLAG_OK;
		def_btn = CDIALOG_BTNFLAG_OK;
	    }
	    else if(arg[0] != '-')
	    {
		message = arg;
	    }
	}

	/* Use default message? */
	if(message == NULL)
	    message = "No message available";


	gtk_init(&argc, &argv);

	CDialogInit();

	/* Map confirmation dialog */
	response = CDialogGetResponse(
	    "Confirmation Dialog",
	    message,
	    NULL,
	    dialog_style,
	    btn_flags,
	    def_btn
	);

	CDialogShutdown();

	return(response);
}
