/*
                 Endeavour TEdit Compile Time Configuration
 */

#ifndef CONFIG_TEDIT_H
#define CONFIG_TEDIT_H

#include "../config.h"


/*
 *      Program name and version:
 */
#undef PROG_NAME
#define PROG_NAME			"TEdit"

#undef PROG_NAME_FULL
#define PROG_NAME_FULL			"Text Editor"


/*
 *	Standard output help message:
 */
#ifdef PROG_HELP_MESG
# undef PROG_HELP_MESG
#endif

#ifdef PROG_LANGUAGE_ENGLISH
#define PROG_HELP_MESG  "\
Usage: tedit [path] [options] [GUI_options]\n\
\n\
    The [path] pecifies the path to the file to open at startup.\n\
\n\
    The [options] can be any of the following:\n\
\n\
        --line <n>              Sets the cursor position to line <n>\n\
                                at startup, <n> must be a positive\n\
                                integer value or -1 for the last line.\n\
        -l                      Same as --line.\n\
\n\
        --text-font-name <s>    Sets the text font.\n\
        --tab-width <i>         Sets the tab width to <i> characters.\n\
        -t                      Same as --tab-width.\n\
\n\
        --help                  Prints (this) help screen and exits.\n\
        --version               Prints version information and exits.\n\
\n\
    The [GUI_options] can be any options standard to your GUI,\n\
    consult your GUI's manual for available options.\n\
\n"
#endif
#ifdef PROG_LANGUAGE_SPANISH
#define PROG_HELP_MESG	"\
El uso: tedit <file> [options] [GUI_options]\n\
\n\
    <file> specifies the file to edit.\n\
\n\
    [options] puede ser cualquiera de lo Siguiente:\n\
\n\
        --line <n>              La posicin fija de la direccin en inicio.\n\
\n\
        --help                  Pantalla de ayuda de Impresiones (esto) de ayuda y salidas.\n\
        --version               Versin Imprime informacin de versin y salidas.\n\
\n\
    [GUI_options] puede ser cualquier estndar de las opcin a su GUI,\n\
    consulta su manual de GUI para opciones disponibles.\n\
\n"
#endif
#ifdef PROG_LANGUAGE_FRENCH
#define PROG_HELP_MESG  "\
Usage: tedit <file> [options] [GUI_options]\n\
\n\
    <file> specifies the file to edit.\n\
\n\
    [options] peut tre n'importe quel du suivre:\n\
\n\
        --line <n>              L'adresse initiale au dmarrage.\n\
\n\
        --help                  Affiche (ceci) cran d'aide et sort.\n\
        --version               Affiche information de version et sort.\n\
\n\
    [GUI_options] peut tre n'importe quelle norme d'options  votre\n\
    GUI, consulter le manuel de votre GUI pour les options disponibles.\n\
\n"
#endif


/*
 *	Widget Names:
 */   
#define TEDIT_TOPLEVEL_WIDGET_NAME	"tedit"
#define TEDIT_GTK_TEXT_WIDGET_NAME	"tedit-gtk-text"


/*
 *      Drag and drop target type names and info values:
 */
#define TEDIT_DND_TYPE_INFO_TEXT_PLAIN		0	/* "text/plain" */
#define TEDIT_DND_TYPE_INFO_TEXT_URI_LIST	1	/* "text/uri-list" */
#define TEDIT_DND_TYPE_INFO_STRING		2	/* "STRING" */


/*
 *	Default Print Spooler:
 */
#define TEDIT_DEF_PRINT_SPOOLER		"/usr/bin/lpr"


#endif	/* CONFIG_TEDIT_H */
