/*
			    History Event Logging
 */

#ifndef EDV_HISTORY_H
#define EDV_HISTORY_H

#include <glib.h>
#include "edv_context.h"


/*
 *	Appends a new History Event to Endeavour's history list.
 */
extern void EDVHistoryAppend(
	edv_context_struct *ctx,
	edv_history_type type,  /* One of EDV_HISTORY_* */
	gulong time_start,      /* Time the operation first started */
	gulong time_end,        /* Time the operation ended */
	gint status,            /* Result of operation */
	const gchar *source,    /* Source Object/Operation/Value */
	const gchar *target,    /* Target Object/Operation/Value */
	const gchar *comments   /* Comments */
);


#endif	/* EDV_HISTORY_H */
