/*
	    Recycled Object Renaming, ChMod, ChOwn, ChTime, etc

	See edv_recbin_purge.h and edv_recbin_recover.h for recycled
	object purge and recover.
 */

#ifndef EDV_RECYCLED_OBJ_OP_H
#define EDV_RECYCLED_OBJ_OP_H

#include <gtk/gtk.h>
#include "edv_types.h"


extern const gchar *EDVRecycledObjectOPGetError(edv_core_struct *core);

extern gint EDVRecycledObjectOPRelink(
	edv_core_struct *core,
	const guint index,
	const gchar *new_target,
	GList **modified_indicies_list,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVRecycledObjectOPRename(
	edv_core_struct *core,
	const guint index,
	const gchar *new_name,
	GList **modified_indicies_list,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVRecycledObjectOPChMod(
	edv_core_struct *core,
	GList *indices_list,
	const edv_permission_flags permissions,
	GList **modified_indicies_list,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVRecycledObjectOPChOwn(
	edv_core_struct *core,
	GList *indicies_list,
	const gint owner_id, const gint group_id,
	GList **modified_indicies_list,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVRecycledObjectOPChTime(
	edv_core_struct *core,
	GList *indicies_list,
	const gulong atime, const gulong mtime, const gulong dtime,
	GList **modified_indicies_list,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);


#endif	/* EDV_RECYCLED_OBJ_OP_H */
