/*
			    Endeavour Operations
 */

#ifndef EDVOP_H
#define EDVOP_H

#include <gtk/gtk.h>

#include "url.h"
#include "edv_types.h"
#include "edv_obj.h"
#include "edv_recycled_obj.h"
#include "edv_archive_obj.h"
#include "browser.h"
#include "imbr.h"
#include "archiver.h"
#include "recbin.h"
#include "prop_dlg.h"


/* New/Map Window Nexus */
extern gint EDVNewWindow(
	edv_core_struct *core,
	const gchar *name,		/* Name of window */
	const gchar *path,		/* Initial object path */
	const gchar *extra,
	GtkWidget *toplevel
);


/* New Windows */
extern gint EDVNewBrowser(
	edv_core_struct *core,
	const gchar *path
);
extern gint EDVNewImbr(
	edv_core_struct *core,
	const gchar *path
);
extern gint EDVNewArchiver(
	edv_core_struct *core,
	const gchar *path,
	const gchar *password
);

extern gint EDVNewPropertiesDialogVFSPage(
	edv_core_struct *core,
	edv_object_struct *obj,
	const gchar *page_name,
	GtkWidget *toplevel
);
extern gint EDVNewPropertiesDialogVFS(
	edv_core_struct *core,
	edv_object_struct *obj,
	GtkWidget *toplevel
);
extern gint EDVNewPropertiesDialogRecycledPage(
	edv_core_struct *core,
	edv_recycled_object_struct *obj,
	const gchar *page_name,
	GtkWidget *toplevel
);
extern gint EDVNewPropertiesDialogArchivePage(
	edv_core_struct *core,
	edv_archive_object_struct *obj,
	const gchar *arch_path,
	const gchar *page_name,
	GtkWidget *toplevel
);


/* Running */
extern void EDVRunDeviceCheck(
	edv_core_struct *core, edv_device_struct *dev,
	GtkWidget *toplevel
);
extern void EDVRunDeviceTools(
	edv_core_struct *core, edv_device_struct *dev,
	GtkWidget *toplevel
);
extern void EDVRunDeviceFormat(
	edv_core_struct *core, edv_device_struct *dev,
	GtkWidget *toplevel
);

extern void EDVRunTerminal(
	edv_core_struct *core,
	const gchar *cmd,
	const gchar *wd,
	GtkWidget *toplevel
);


/* Object Operations Dialog */
extern edv_obj_op_dlg_struct *EDVGetObjOpDlg(edv_core_struct *core);


/* Window Mapping */
extern void EDVMapRecBinDeskIcon(edv_core_struct *core);
extern void EDVMapRecBin(edv_core_struct *core);

extern void EDVMapHistoryListWin(
	edv_core_struct *core, GtkWidget *toplevel
);

extern void EDVMapOptionsWinPage(
	edv_core_struct *core,
	const gchar *page_name,
	GtkWidget *toplevel
);
extern void EDVMapOptionsWin(
	edv_core_struct *core, GtkWidget *toplevel
);

extern void EDVMapCustomizeWin(
	edv_core_struct *core, GtkWidget *toplevel
);

extern void EDVMapDevicesListWin(
	edv_core_struct *core, GtkWidget *toplevel
);

extern void EDVMapMIMETypesListWin(
	edv_core_struct *core,
	const gchar *type,
	GtkWidget *toplevel
);

extern void EDVMapRunDialogCommand(
	edv_core_struct *core,
	const gchar *command,
	const gchar *working_dir,
	GtkWidget *toplevel
);
extern void EDVMapRunDialog(
	edv_core_struct *core, GtkWidget *toplevel
);

extern void EDVMapFindWin(
	edv_core_struct *core, const gchar *location
);
extern void EDVMapBrowserFindWin(
	edv_core_struct *core, edv_browser_struct *browser
);
extern void EDVMapImbrFindWin(
	edv_core_struct *core, edv_imbr_struct *imbr
);
extern void EDVMapArchiverFindWin(
	edv_core_struct *core, edv_archiver_struct *archiver
);
extern void EDVMapRecBinFindWin(
	edv_core_struct *core, edv_recbin_struct *recbin
);


/* About */
extern void EDVAboutPage(
	edv_core_struct *core,
	const gchar *page_name,
	GtkWidget *toplevel
);
extern void EDVAbout(
	edv_core_struct *core, GtkWidget *toplevel
);


/* Update Resources & Widgets */
extern void EDVUpdateRCStyles(edv_core_struct *core);
extern void EDVUpdateIDPULists(edv_core_struct *core);
extern void EDVUpdateDevicesPUList(edv_core_struct *core);
extern void EDVUpdateMIMETypeHintIndices(edv_core_struct *core);
extern void EDVUpdateOpenWithPUList(edv_core_struct *core);


/* Refresh & Reset */
extern void EDVRefresh(edv_core_struct *core);
extern void EDVReset(edv_core_struct *core);


/* Sync */
extern void EDVSyncDisks(edv_core_struct *core);


/* Clearing */
extern void EDVClearErrorMessages(edv_core_struct *core);
extern void EDVClearHistoryEvents(
	edv_core_struct *core,
	const gboolean confirm,
	GtkWidget *toplevel
);
extern void EDVClearLocationsHistory(
	edv_core_struct *core,
	const gboolean confirm,
	GtkWidget *toplevel
);
extern void EDVClearRunHistory(
	edv_core_struct *core,
	const gboolean confirm,
	GtkWidget *toplevel
);

/* Recycle Bin Size Check */
extern void EDVRecycleBinSizeCheck(
	edv_core_struct *core, GtkWidget *toplevel
);

/* Purge Recycle Bin */
extern void EDVPurgeAllRecycledObjects(
        edv_core_struct *core,
        const gboolean map_recbin,
        const gboolean show_progress,
        const gboolean interactive,
        GtkWidget *toplevel
);

/* Network */
extern void EDVInternetDownloadObject(
	edv_core_struct *core,
	const url_struct *url,
	const gchar *target_path,
	GtkWidget *toplevel
);


#endif	/* EDVOP_H */
