/*
                          Object Creating

	See edv_obj_op.h for object operations such as copy, move,
	link, rename, etc
 */

#ifndef EDV_OBJ_CREATE_H
#define EDV_OBJ_CREATE_H

#include <gtk/gtk.h>
#include "edv_types.h"


extern const gchar *EDVObjCreateGetError(edv_core_struct *core);

extern gint EDVObjCreateFileQueryName(
        edv_core_struct *core,
        const gchar *parent_path,
	const gchar *suggested_name,
        gchar **new_path_rtn,
        GtkWidget *toplevel,
        const gboolean show_progress,
        gboolean *yes_to_all
);

extern gint EDVObjCreateFile(
	edv_core_struct *core,
	const gchar *path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVObjCreateDirectory(
	edv_core_struct *core,
	const gchar *path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVObjCreateLink(
	edv_core_struct *core,
	const gchar *path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVObjCreateFifo(
	edv_core_struct *core,
	const gchar *path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVObjCreateDeviceBlock(
	edv_core_struct *core,
	const gchar *path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVObjCreateDeviceCharacter(
	edv_core_struct *core,
	const gchar *path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVObjCreateSocket(
	edv_core_struct *core,
	const gchar *path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);


#endif	/* EDV_OBJ_CREATE_H */
