/*
			      Endeavour Find Bar
 */

#ifndef EDV_FIND_BAR_H
#define EDV_FIND_BAR_H

#include <sys/stat.h>
#include <gtk/gtk.h>
#include "pulist.h"
#include "edv_types.h"


typedef struct _edv_find_bar_struct	edv_find_bar_struct;
#define EDV_FIND_BAR(p)			((edv_find_bar_struct *)(p))


/*
 *	Find Bar Operations:
 */
typedef enum {
	EDV_FIND_BAR_FIND_BY_NAME,
	EDV_FIND_BAR_FIND_BY_CONTENT,
	EDV_FIND_BAR_FIND_BY_SIZE_EQUAL_TO,
	EDV_FIND_BAR_FIND_BY_SIZE_NOT_EQUAL_TO,
	EDV_FIND_BAR_FIND_BY_SIZE_LESS_THAN,
	EDV_FIND_BAR_FIND_BY_SIZE_GREATER_THAN,
	EDV_FIND_BAR_FIND_BY_MODIFY_TIME_EQUAL_TO,
	EDV_FIND_BAR_FIND_BY_MODIFY_TIME_NOT_EQUAL_TO,
	EDV_FIND_BAR_FIND_BY_MODIFY_TIME_LESS_THAN,
	EDV_FIND_BAR_FIND_BY_MODIFY_TIME_GREATER_THAN
} edv_find_bar_find_by;


/*
 *	Find Bar:
 */
struct _edv_find_bar_struct {

	GtkWidget	*toplevel;
	gboolean	processing;
	gint		freeze_count,
			stop_count;
	edv_core_struct	*core;

	pulistbox_struct	*find_by_pulistbox;
	GtkWidget	*search_combo,
			*case_sensitive_check,
			*stop_btn;

	edv_location_type	location_type;

	/* Get current location callback */
	const gchar	*(*get_location_cb)(
		edv_find_bar_struct *,		/* Find Bar */
		gpointer			/* Data */
	);

	/* Find start callback */
	void	(*start_cb)(
		edv_find_bar_struct *,		/* Find Bar */
		gpointer			/* Data */
	);
	/* Find end callback */
	void	(*end_cb)(
		edv_find_bar_struct *,		/* Find Bar */
		const gint,			/* Total Matches */
		gpointer			/* Data */
	);

	/* Matched path callback
	 *
	 * Note, if the role is set to EDV_LOCATION_TYPE_RECBIN
	 * then the path is a string describing the index of the
	 * recycled object
	 */
	void	(*match_cb)(
		const gchar *,			/* Path */
		struct stat *,		/* Local Stats */
		const gchar *,			/* Excerpt */
		const gint,			/* Line Index */
		gpointer			/* Data */
	);

	/* Status message callback */
	void    (*status_message_cb)(
		const gchar *,			/* Message */
		gpointer			/* Data */
	);
	/* Status progress callback */
	void    (*status_progress_cb)(
		const gfloat,			/* Progress */
		gpointer			/* Data */
	);

	gpointer	data;

};


extern void EDVFindBarSetSearch(
	edv_find_bar_struct *fb,
	const gchar *s,
	const gboolean record_history
);
extern edv_find_bar_find_by EDVFindBarCurrentFindBy(edv_find_bar_struct *fb);

extern edv_find_bar_struct *EDVFindBarNew(
	edv_core_struct *core, GtkWidget *parent,
	const edv_location_type location_type,
	const gchar *(*get_location_cb)(
		edv_find_bar_struct *, gpointer
	),
	void (*start_cb)(
		edv_find_bar_struct *, gpointer
	),
	void (*end_cb)(
		edv_find_bar_struct *, const gint, gpointer
	),
	void (*match_cb)(
	    const gchar *, struct stat *,
	    const gchar *, const gint,
	    gpointer
	),
	void (*status_message_cb)(const gchar *, gpointer),
	void (*status_progress_cb)(const gfloat, gpointer),
	gpointer data
);
extern void EDVFindBarUpdateMenus(edv_find_bar_struct *fb);
extern void EDVFindBarMap(edv_find_bar_struct *fb);
extern void EDVFindBarUnmap(edv_find_bar_struct *fb);
extern void EDVFindBarDelete(edv_find_bar_struct *fb);


#endif	/* EDV_FIND_BAR_H */
