/*
		  Endeavour Browser Contents List
 */

#ifndef BROWSER_CONTENTS_LIST_H
#define BROWSER_CONTENTS_LIST_H

#include <gtk/gtk.h>
#include "browser.h"


/* Columns */
extern void EDVBrowserContentsResizeColumnOptimul(
	edv_browser_struct *browser,
	const gint column_num
);
extern void EDVBrowserContentsResizeColumnsOptimul(edv_browser_struct *browser);

/* Selection */
extern GList *EDVBrowserContentsGetSelectedPaths(edv_browser_struct *browser);

/* Finding */
extern gint EDVBrowserContentsFindRowByIndex(
	edv_browser_struct *browser,
	const gulong device_index, const gulong index
);
extern gint EDVBrowserContentsFindRowByPath(
	edv_browser_struct *browser, const gchar *path
);

/* Realize Listing */
extern void EDVBrowserContentsRealizeListing(edv_browser_struct *browser);

/* Get Listing */
extern void EDVBrowserContentsGetListing(
	edv_browser_struct *browser, const gchar *path,
	const gboolean update_status_bar
);
extern void EDVBrowserContentsClear(edv_browser_struct *browser);

/* Opening */
extern void EDVBrowserContentsOpen(
	edv_browser_struct *browser,
	const gint row, const gint column,
	const guint state
);
extern void EDVBrowserContentsOpenWith(
	edv_browser_struct *browser,
	const gint row, const gint column
);

/* Renaming */
extern void EDVBrowserContentsPromptRename(
	edv_browser_struct *browser,
	const gint row, const gint column
);

/* Object Callbacks */
extern void EDVBrowserContentsObjectAddedNotify(
	edv_browser_struct *browser, const gchar *path,
	struct stat *lstat_buf
);
extern void EDVBrowserContentsObjectModifiedNotify(
	edv_browser_struct *browser, const gchar *path,
	const gchar *new_path,
	struct stat *lstat_buf
);
extern void EDVBrowserContentsObjectRemovedNotify(
	edv_browser_struct *browser, const gchar *path
);

/* Mount Callbacks */
extern void EDVBrowserContentsMountNotify(
	edv_browser_struct *browser, edv_device_struct *dev,
	const gboolean is_mounted
);


#endif	/* BROWSER_CONTENTS_LIST_H */
