/*
                        Endeavour Archiver Callbacks
 */

#ifndef ARCHIVER_CB_H
#define ARCHIVER_CB_H

#include <gtk/gtk.h>
#include "edv_types.h"
#include "edv_mime_type.h"
#include "edv_archive_obj.h"
#include "archiver.h"


/* GTK+ Signal Callbacks */
extern void EDVArchiverContentsItemDestroyCB(gpointer data);

extern gint EDVArchiverDeleteEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
extern gint EDVArchiverKeyEventCB(
	 GtkWidget *widget, GdkEventKey *key, gpointer data
);
extern gint EDVArchiverEnterNotifyEventCB(
	 GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVArchiverLeaveNotifyEventCB(
	 GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVArchiverButtonPressEventCB(
	GtkWidget *widget, GdkEventButton *button, gpointer data
);

extern void EDVArchiverHandleChildAttachedCB(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);
extern void EDVArchiverHandleChildDetachedCB(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);

extern void EDVArchiverResizeColumnCB(
	GtkCList *clist, gint column, gint width, gpointer data
);
extern void EDVArchiverClickColumnCB(
	GtkCList *clist, gint column, gpointer data
);
extern void EDVArchiverSelectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);
extern void EDVArchiverUnselectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);

extern void EDVArchiverComboActivateCB(GtkWidget *widget, gpointer data);

/* Menu Item Callbacks */
extern void EDVArchiverMenuItemCB(GtkWidget *widget, gpointer data);
extern gint EDVArchiverMenuItemEnterCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVArchiverMenuItemLeaveCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);

/* Find Bar Callbacks */
extern const gchar *EDVArchiverFindBarLocationCB(
	edv_find_bar_struct *fb,
	gpointer data
);
extern void EDVArchiverFindBarStartCB(
	edv_find_bar_struct *fb,
	gpointer data
);
extern void EDVArchiverFindBarEndCB(
	edv_find_bar_struct *fb,
	const gint nmatches,
	gpointer data
);
extern void EDVArchiverFindBarMatchCB(
	const gchar *path,
	struct stat *lstat_buf,
	const gchar *excerpt,
	const gint line_index,
	gpointer data
);

/* Status Bar Callbacks */
extern void EDVArchiverStatusMessageCB(const gchar *message, gpointer data);
extern void EDVArchiverStatusProgressCB(const gfloat progress, gpointer data);

/* Write Protect Changed Callback */
extern void EDVArchiverWriteProtectChangedCB(
	edv_archiver_struct *archiver, const gboolean state
);

/* Object Callbacks */
extern void EDVArchiverObjectAddedNotifyCB(
	edv_archiver_struct *archiver, const gchar *path,
	struct stat *lstat_buf
);
extern void EDVArchiverObjectModifiedNotifyCB(
	edv_archiver_struct *archiver, const gchar *path,
	const gchar *new_path, struct stat *lstat_buf
);
extern void EDVArchiverObjectRemovedNotifyCB(
	edv_archiver_struct *archiver, const gchar *path
);

/* Archive Object Callbacks */
extern void EDVArchiverArchiveObjectAddedNotifyCB(
	edv_archiver_struct *archiver, const gchar *arch_path,
	const gchar *path, edv_archive_object_struct *obj
);
extern void EDVArchiverArchiveObjectModifiedNotifyCB(
	edv_archiver_struct *archiver, const gchar *arch_path,
	const gchar *path, const gchar *new_path,
	edv_archive_object_struct *obj
);
extern void EDVArchiverArchiveObjectRemovedNotifyCB(
	edv_archiver_struct *archiver, const gchar *arch_path,
	const gchar *path
);

/* Recycled Object Callback */
extern void EDVArchiverRecycledObjectAddedNotifyCB(
	edv_archiver_struct *archiver, const guint index
);
extern void EDVArchiverRecycledObjectModifiedNotifyCB(
	edv_archiver_struct *archiver, const guint index
);
extern void EDVArchiverRecycledObjectRemovedNotifyCB(
	edv_archiver_struct *archiver, const guint index
);

/* Reconfigured Callback */
extern void EDVArchiverReconfiguredNotifyCB(edv_archiver_struct *archiver);

/* MIME Type Callbacks */
extern void EDVArchiverMimeTypeAddedCB(
	edv_archiver_struct *archiver,
	const gint mt_num, edv_mime_type_struct *mt
);
extern void EDVArchiverMimeTypeModifiedCB(
	edv_archiver_struct *archiver,
	const gint mt_num, edv_mime_type_struct *mt
);
extern void EDVArchiverMimeTypeRemovedCB(
	edv_archiver_struct *archiver,
	const gint mt_num
);


#endif	/* ARCHIVER_CB_H */
