/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include <stdio.h>
#include <stdlib.h>
#include "fortint.h"
#include "fileRead.h"

#define BUFFLEN 4096

void lwsize_(
  fortint ** unit,
  fortint * plen) {
/*
//  Returns the size in bytes of the next GRIB, BUFR, TIDE, BUDG, DIAG
//  product.
//
//  Called from C:
//      LWSIZE((fortint **) &unit, &plen);
//
//  unit  = file id returned from C fopen64.
//  plen  = size in bytes of the next product.
//        = 0 if no product found
//
//  The input file is left positioned where it started.
*/
fortint iret;
char statbuff[BUFFLEN];
long offset;

/*
//  Record the current position of the file
*/
    offset = (fortint) fileTell(*unit);
    if( offset < 0 ) {
      perror("LWSIZE: fileTell error");
      exit(1);
    }
/*
//  Use a smallish buffer for processing; this should suffice for all cases
//  except versions -1 and 0 of GRIB and large BUFR products
*/
    *plen = BUFFLEN;

    iret = readprod(NULL,statbuff,plen,fileRead,fileSeek,fileTell,*unit);
    if( (iret < 0) && (iret != -3) && (iret != -1) ) {
      *plen = 0;
      return;
    }
/*
//  Put the file pointer back where it started
*/
    offset = (fortint) fileSeek( *unit, offset, SEEK_SET);

    return ;
}

void lwsize(fortint** unit,fortint* plen) {

  lwsize_(unit,plen);
}
