/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>

#include "fortdefs.h"

/*
// NB. Don't need the versions without underscore, they exist in
//     standard libraries (?!).
*/
#define RENAME rename_
#define UNLINK unlink_
#define GETPID getpid_

fortint GETPID(void) {
    return (fortint) getpid();
}

fortint RENAME( char * oldname, char * newname, int lold, int lnew) {
char * old, * new;
fortint status;

    old = (char *) malloc(lold+1);
    if( old == NULL ) {
      perror("RENAME: malloc failed for old");
      return (fortint) -1;
    }
    new = (char *) malloc(lnew+1);
    if( new == NULL ) {
      perror("RENAME: malloc failed for new");
      free(old);
      return (fortint) -1;
    }

    strncpy(old,oldname,lold);
    strncpy(new,newname,lnew);

    old[lold] = '\0';
    new[lold] = '\0';

    status = (fortint) rename(old,new);

    free(old);
    free(new);

    return status;
}

fortint UNLINK( char * oldname, int lold) {
char * old;
fortint status;

    old = (char *) malloc(lold+1);
    if( old == NULL ) {
      perror("UNLINK: malloc failed for old");
      return (fortint) -1;
    }

    strncpy(old,oldname,lold);
    old[lold] = '\0';

    status = (fortint) unlink(old);

    free(old);

    return status;
}
