C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      INTEGER FUNCTION AURESOL(NS,EW)
C
C---->
C**** AURESOL
C
C     Purpose
C     -------
C
C     Returns the default truncation for a given
C     latitude--longitude grid resolution.
C
C
C     Interface
C     ---------
C
C     KTRUNC = AURESOL(NS,EW)
C
C     Input
C     -----
C
C     NS     = north-south grid increment in degrees
C     EW     = east-west   grid increment in degrees
C
C     Output
C     ------
C
C     KTRUNC = Triangular truncation (e.g. 106 for T106)
C
C
C     Method
C     ------
C
C       Grid increment           Truncation
C       --------------           ----------
C
C       [2.5 and greater          T63
C
C       [1.5 to 2.5[              T106
C
C       [0.6 to 1.5[              T213
C
C       [0.4 to 0.6[              T319
C
C       [0.3 to 0.4[              T511
C
C       [0.15 to 0.3[             T799
C
C       [0   to 0.15[             T1023
C
C
C     Externals
C     ---------
C
C     None.
C
C     Author
C     ------
C
C     J.D.Chambers ECMWF Mar 1998
C
C
C     Reference.
C     ----------
C
C     None.
C
C     Modifications
C     -------------
C
C     S.Curic     ECMWF        April 2005
C     Add T799 and T1023
C
C ------------------------------------------------------------------
C----<
C
      IMPLICIT NONE
C
#include "parim.h"
#include "nifld.common"
#include "nofld.common"
C
C     Function arguments
C
      REAL NS, EW
C
C     Local variables
C
C     Function statement(s)
C
      REAL STEP
C
      STEP = MIN(ABS(NS),ABS(EW))
C
C     -----------------------------------------------------------------|
C*    Section 1.   Initialise
C     -----------------------------------------------------------------|
C
  100 CONTINUE
C
C     2.5 and greater -> T63
C
      IF( STEP.GE.2.5 ) THEN
        AURESOL = 63
        GOTO 900
      ENDIF
C
C     1.5 to 2.5      -> T106
C
      IF( STEP.GE.1.5 ) THEN
        AURESOL = 106
        GOTO 900
      ENDIF
C
C     0.6 to 1.5      -> T213
C
      IF( STEP.GE.0.6 ) THEN
        AURESOL = 213
        GOTO 900
      ENDIF
C
C     0.4 to 0.6      -> T319
C
      IF( STEP.GE.0.4 ) THEN
        AURESOL = 319
        GOTO 900
      ENDIF
C
C     0.3 to 0.4      -> T511
C
      IF( STEP.GE.0.3 ) THEN
        AURESOL = 511
        GOTO 900
      ENDIF
C
C     0.15 to 0.3      -> T799
C
      IF( STEP.GE.0.15 ) THEN
        AURESOL = 799
        GOTO 900
      ENDIF

C
C     0.09 to 0.15      -> T1279
C
      IF( STEP.GE.0.09 ) THEN
        AURESOL = 1279
        GOTO 900
      ENDIF
C
C     less than 0.09   -> T2047
C
      AURESOL = 2047

C
  900 CONTINUE
C
      END
