C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C


      INTEGER FUNCTION RTB (CHAR)
C
C---->
C*
C*    NAME      : RTB
C*
C*    FUNCTION  : COUNT THE NUMBER OF CHARACTERS IN A CHARACTER
C*                STRING, EXCLUDING TRAILING SPACES.
C*
C*    INPUT     : CHAR - CHARACTER STRING
C*
C*    OUTPUT    : RTB  - NO OF CHARACTERS
C*
C*    GENERAL   : RTB CALLS  -----
C*
C*    AUTHOR    : J.HENNESSY  15.4.85
C*
C     ---------------------------------------------------------------
C----<
C
      CHARACTER*(*) CHAR
C
      J = LEN (CHAR)
C
C     No trailing blanks.
C
      IF (CHAR(J:J).NE.' ')
     C     THEN
               RTB = J
               RETURN
           ENDIF
C
C     String with trailing blanks.
C
      DO 100 I = J,1,-1
         IF (CHAR(I:I).NE.' ')
     C          THEN
                    RTB = I
                    RETURN
                ENDIF
  100 CONTINUE
C
C     String consists of only blanks.
C
      RTB = 0
C
      RETURN
      END
