C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      SUBROUTINE GRSDBG (KDBG)
C
C---->
C**** GRSDBG - Debug print switch setting for routine GRIBEX.
C
C     Purpose.
C     --------
C
C           Switch debug printout on or off for routine GRIBEX.
C
C**   Interface.
C     ----------
C
C     CALL GRSDBG (KDBG)
C
C     Input Parameters.
C     -----------------
C
C     KDGB        - Debug print switch.
C                   0 , No printout.
C                   Non-zero , Debug printout.
C
C     Output Parameters.
C     ------------------
C
C     None.
C
C     Method.
C     -------
C
C     The variable NDBG is set in the common area. All other
C     parameters are also set to default values, if they have
C     not already been set by the user.
C
C     Externals.
C     ----------
C
C     GRSDEF - Default setting of global variables.
C
C     Reference.
C     ----------
C
C     See subroutine GRIBEX.
C
C     Comments.
C     ---------
C
C     None
C
C     Author.
C     -------
C
C     J. Hennessy      ECMWF      25.06.91
C
C     Modifications.
C     --------------
C
C     J. Hennessy      ECMWF      25.06.91
C     Changes to some comments only.
C
C     J. Hennessy      ECMWF      14.11.91
C     Common areas changed.
C
C     J. Hennessy      ECMWF      07.01.92
C     Input parameter returned unchanged.
C
C     J.D.Chambers     ECMWF      13.09.94
C     Add NONOFF and NOABORT, use grbcom.h
C
C     J. Clochard, Meteo France, for ECMWF - January 1998.
C     Use GRSDEF routine for default setting.
C
C     J. Clochard, Meteo France, for ECMWF - June 1999.
C     Use a static variable to determine if initialisation of
C     default values has already been done for common area
C     variables.
C
C----<
C     ----------------------------------------------------------------
C*    Section 0 . Definition of variables.
C     ----------------------------------------------------------------
C
      IMPLICIT NONE
C
#include "grbcom.h"
C
      INTEGER KDBG
C
      LOGICAL LFIRST
      SAVE LFIRST
C
      DATA LFIRST / .TRUE. /
C
C     ----------------------------------------------------------------
C*    Section 1 . Set values.
C     ----------------------------------------------------------------
C
  100 CONTINUE
C
      IF (LFIRST) THEN
C
C       Common area variables may have not been set, so start by
C       trying to set default values.
C
        CALL GRSDEF
        LFIRST=.FALSE.
C
      ENDIF
C
C     Set debug print to required value.
C
      NDBG   = KDBG
C
C     ----------------------------------------------------------------
C*    Section 9 . Return to calling routine.
C     ----------------------------------------------------------------
C
  900 CONTINUE
C
      RETURN
C
      END
