/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include <assert.h>
#include <stdio.h>
#include <unistd.h>

#include "grib_api.h"
#include "emos.h"

char outgrib[1000000];
char buffer[1024*1024*10];

fortint intf2(char* grib_in, fortint* length_in, char* grib_out, fortint* length_out);

#define intout intout_

long edition = 2;

int main(int argc, char** argv) {

	int err = 0;

	size_t length = sizeof(buffer);
	long outlen = sizeof(outgrib);
	/* size_t outlen = sizeof(outgrib); */

	size_t mesg_len;
	const void* mesg;

	FILE* in  = NULL;
	FILE* out = NULL;

	grib_handle *h = NULL;

	fortint   intv[4] = {0,};
	double realv[4] = {0,};
	char*  text = "dissemination";
	long version;
	double resol;
	int count = 1;

    if( argc < 3 )
	{
	  printf("\n Usage: ./example inputgrib outputgrib resol \n");
	  exit(1);
	}

	in = fopen(argv[1],"r");
	if(!in)
	{
		perror( argv[1] );
		exit(10);
	}

	out = fopen(argv[2],"w");
	if(!out) {
		perror(argv[2]);
		exit(10);
	}

	resol = atof(argv[3]);

	version = grib_get_api_version();


	/* printf("--- grib_api version %d \n",version); */


	while((err = readany(in,buffer,&length)) == 0)
	{
		printf(" ===================  %d  ==============================  \n", count++);

		/* INTOUT settings */

/* Area */
		/* north */
		   /* realv[0] =  69.5; */
		/* west */
		   /* realv[1] = 345.5; */
		/* south */
		   /* realv[2] =  34.5; */
		/* east */
		   /* realv[3] =  34.5; */
/*
			if(err = int2_intout("area", intv, realv, text))
			{
			     fprintf(stderr,"Area setup INTOUT failed %d\n",err);
			     return err;
			}
*/

/* Lat-Lon resolution */
		   realv[0] = resol;
		   realv[1] = resol;
		
		   if( err = int2_intout("grid",intv,realv,text))
		   {
			   fprintf(stderr,"Grid setup INTOUT failed %d\n",err);
			   exit(err);
		   }
/* Accuracy */
			/*
           intv[0] = 16;
           if(err = int2_intout("accuracy",intv,realv,text))
           {
               fprintf(stderr,"Reduced Gaussian setup failed %d\n",err);
			   return err;
           }

			*/
/* Reduced gaussian */
		   /*
           intv[0] = 200;
           if(err = int2_intout("reduced",intv,realv,text))
           {
               fprintf(stderr,"Reduced Gaussian setup failed %d\n",err);
			   return err;
           }
		   */
/* Regular gaussian */
		   /*
           intv[0] = 200;
           if(err = int2_intout("regular",intv,realv,text))
           {
               fprintf(stderr,"Regular Gaussian setup failed %d\n",err);
			   return err;
           }
		   */
/* Spectral */
		   /*
           intv[0] = 63;
           if(err = int2_intout("truncation",intv,realv,text))
           {
               fprintf(stderr,"Spherical setup failed %d\n",err);
			   return err;
           }
		  */
/* Rotation */
		/*
		   realv[0] =  0.0;
		   realv[1] = 80.0;
		   if( err = int2_intout("rotation",intv,realv,text))
		   {
			   fprintf(stderr,"Rotation setup INTOUT failed %d\n",err);
			   exit(err);
		   }
		*/

		if(err = intf2(buffer,&length,outgrib,&outlen))
		{
			fprintf(stderr,"INTF2 failed %d\n",err);
			exit(err);
		}

		if(fwrite(outgrib,1,outlen,out) != outlen)
		{
			perror(argv[4]);
			exit(1);
		}
	}
		if(fclose(in))
		{
			perror(argv[3]);
			exit(1);
		}

		if(fclose(out))
		{
			perror(argv[4]);
			exit(1);
		}

	return 0;
}

