/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include "bitmap.h"

fortint GMAPBIT(
  char ** bitmap,
  fortint * columnCount,
  fortint * row,
  fortint * column) {
/*
// Returns the bit at position (row,column) of bitmap.
//
// Called from FORTRAN:
//
// VALUE = GMAPBIT(BITMAP,COLCNT,N,M)
//
// where:
//
// BITMAP is an array containing the bitmap.
// COLCNT is the number of values per row.
// N is the row number (starting from 1)
// M is the column number (starting from 1)
//
*/
int bitNumber, byte, bit;
char value;

  bitNumber = ((*row)-1)*(*columnCount) + ((*column)-1);
  byte = bitNumber / 8;
  bit  = bitNumber % 8;
  value = ((*bitmap)[byte] >> (7-bit)) & 0x01;

  return (fortint) value;
}
