/* $Id: e2_task.h 563 2007-07-24 21:48:26Z tpgww $

Copyright (C) 2003-2007 tooar <tooar@gmx.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef _E2_TASK_H
#define _E2_TASK_H

#include "emelfm2.h"
#include "e2_permissions_dialog.h"

#ifndef ALLPERMS
#define ALLPERMS (S_ISUID|S_ISGID|S_ISVTX|S_IRWXU|S_IRWXG|S_IRWXO)
#endif

//flags for special treatment of copy (and move, link?) actions
typedef enum
{
	E2_FTM_NORMAL   = 0,	  //this must have no bits set
	E2_FTM_BACKUP   = 1,      //backup overwritten items
	E2_FTM_TRASH    = 1 << 1, //trash overwritten items
	E2_FTM_MERGE    = 1 << 2, //merge (not replace) the contents of processed directories
	E2_FTM_RENAME   = 1 << 3, //copy-as UNUSED
	E2_FTM_CHECK    = 1 << 4, //perform backend overwrite checking (used when merging)
	E2_FTM_PAUSABLE = 1 << 5, //UNUSED check for pause requests during file copy
	E2_FTM_SAMETIME = 1 << 8, //preserve times of processed items
	E2_FTM_SAMEACL  = 1 << 9, //preserve ACL's of processed items
} E2_FileTaskMode;

//code to facilitate undoing (not implemented yet)
typedef enum
{
	E2_TASK_COPY,
	E2_TASK_COPYAS,
	E2_TASK_MOVE,
	E2_TASK_MOVEAS,
	E2_TASK_LINK,
	E2_TASK_LINKAS,
	E2_TASK_DELETE,
	E2_TASK_RENAME,
	E2_TASK_TRASH,
	E2_TASK_TRASHEMPTY,
	E2_TASK_CHMOD,
	E2_TASK_CHOWN,
	E2_TASK_INFO,
	E2_TASK_VIEW,
	E2_TASK_EDIT,
	E2_TASK_OPEN,
	E2_TASK_OPENWITH,
	E2_TASK_DROP,
	E2_TASK_MKDIR,
	//plugin tasks
	E2_TASK_CLONE,
	E2_TASK_TIMESET,
	E2_TASK_PACK,
	E2_TASK_UNPACK,
	E2_TASK_FOREACH,
	E2_TASK_CHACL,
	E2_TASK_CRYPT,
	E2_TASK_LAST	//this is just a code for other plugins etc
} E2_TaskType;

//the order here matters - some code checks for > E2_TASK_RUNNING
//or > E2_TASK_COMPLETED or <= E2_TASK_QUEUED
typedef enum
{
	E2_TASK_NONE,	//not yet specified
	E2_TASK_QUEUED,	//waiting to be processed
	E2_TASK_PAUSED, //a running action is paused, eg while waiting for user input
	E2_TASK_RUNNING,	//task function has been called
	E2_TASK_COMPLETED,	//task function has returned (any completion status)
	E2_TASK_INCOMPLETE,	//the task has timed out
	E2_TASK_ABORTED,	//the task was stopped by the user
	E2_TASK_DONE,	//UNUSED
	E2_TASK_FAILED	//command execution failed for some reason
} E2_TaskStatus;

typedef enum
{
	E2_TASKTYPE_ASYNC,
	E2_TASKTYPE_SYNC,
	E2_TASKTYPE_ACTION
} E2_TaskDataType;

typedef struct _E2_ActionTaskData
{
	E2_TaskType tasktype;	//what type of task
	gboolean result;	//result from the function performing the task
	gchar *currdir;	//the active dir when action initiated, localised string with trailer
	gchar *othrdir;	//the inactive dir when action initiated, localised string with trailer
#ifdef E2_VFSTMP
	//FIXME need "fstab" data or signatures for 1 pane or 2 panes when copying/moving
#endif
	GPtrArray *names;	//selected items array
	E2_Action *action;	//action (hence, name and setup data)
	gpointer rt_data;	//action runtime data (usually string or NULL, maybe flags)
	GtkWidget *initiator;	//the widget which was activated to initiate the task
	gpointer taskfunc;	//the function to perform the task
	gpointer callback;	//the function to call upon completion (maybe NULL)
	//to prevent races, only 1 actioner and 1 monitor at any time - hence static ID's
//	pthread_t athreadID;	//id of the action-thread assigned to run the task
//	pthread_t mthreadID;	//id of the monitor-thread assigned to run the task
	time_t timelimit;	//if not finished by this, abort the task
	E2_TaskStatus *status;	//pointer to status in E2_TaskRuntime (for changes)
} E2_ActionTaskData;

//task-queue data for commands and actions
typedef struct _E2_TaskRuntime
{
	gboolean action;	//TRUE when this data applies to an internal command
	glong pid;	//id assigned to the child (process or thread, real or fake, unsigned for a thread)
	gchar *pidstr;	//string form of pid (any leading "-" replaced by "a" or "s")
	//ordinal enumerator of the task's position in the (possibly-queued) execution sequence
	E2_TaskStatus status;
	union _E2_TaskTypeExtra
	{
		E2_CommandTaskData command;	//for a command
		E2_ActionTaskData action;	//for an action
	} ex;

	//=background_tab or &app.tab if this command is currently running in the focused tab
	E2_OutputTabRuntime *current_tab;
	//the output data to use for this command when running in a non-focused tab
	E2_OutputTabRuntime *background_tab;
	GtkWidget *dialog;	//timeout dialog, or NULL;
} E2_TaskRuntime;

typedef struct _E2_DirEnt
{
	gchar *path;
	mode_t mode;
	time_t modtime;
	time_t axstime;
} E2_DirEnt;

typedef struct _E2_CopyData
{
#ifdef E2_VFS
	GError **operr;
#endif
	E2_FileTaskMode taskmode;	//flags to guide the features of the copying
	gboolean continued_after_problem;	//TRUE when a problem is found, but the walk is not aborted
	gint oldroot_len;	//length of source item path, less its last element
	gchar *newroot;	//destination item path, less its last element, no trailing /, localised string
	GList *dirdata;	//list of directories copied
} E2_CopyData;

typedef struct _E2_ChmodData
{
#ifdef E2_VFS
	GError **operr;
#endif
	gboolean continued_after_problem;
	E2_RecurseType scope;
	mode_t setmask;
	mode_t clearmask;
	GList *dirdata;
} E2_ChmodData;

typedef struct _E2_ChownData
{
#ifdef E2_VFS
	GError **operr;
#endif
	gboolean continued_after_problem;
	uid_t new_uid;
	gid_t new_gid;
	GList *dirdata;
} E2_ChownData;

E2_TaskRuntime *e2_task_find_running_task (glong pid);
E2_TaskRuntime *e2_task_find_last_running_child (gboolean anytab);
E2_TaskRuntime *e2_task_set_data (glong pid, E2_TaskDataType mode, gchar *command);

void e2_task_abort (gboolean all);

#define e2_task_do_task(type,art,from,taskfunc,callback) \
	e2_task_run_task (type, art, from, taskfunc, callback, TRUE, TRUE)
#define e2_task_enqueue_task(type,art,from,taskfunc,callback) \
	e2_task_run_task (type, art, from, taskfunc, callback, FALSE, TRUE)

gboolean e2_task_run_task (E2_TaskType type, E2_ActionRuntime *art,
	gpointer from, gpointer taskfunc, gpointer callback, gboolean immediate,
	gboolean pane_data);
void e2_task_refresh_lists (E2_ActionTaskData *qed);
void e2_task_advise (void);

gchar *e2_task_tempname (gchar *path);
gboolean e2_task_sync_dirs (gpointer from, E2_ActionRuntime *art);
gboolean e2_task_view (gpointer from, E2_ActionRuntime *art);
gboolean e2_task_drop (E2_TaskType type, gchar *srcdir_local,
	gchar *destdir_local, GPtrArray *names_array);
gboolean e2_task_refresh (gpointer from, E2_ActionRuntime *art);
//gboolean e2_task_open (gpointer from, E2_ActionRuntime *art);
gboolean e2_task_open_with (gpointer from, E2_ActionRuntime *art);
//gboolean e2_task_open_in_other_pane (gpointer from, E2_ActionRuntime *art);

gboolean e2_task_configure (gpointer from, E2_ActionRuntime *art);
gboolean e2_task_configure_default (gpointer from, E2_ActionRuntime *art);
//gboolean e2_task_find (gpointer from, E2_ActionRuntime *art);

gboolean e2_task_backend_copy (gchar *src, gchar *dest, E2_FileTaskMode mode);
gboolean e2_task_backend_move (gchar *src, gchar *dest);
gboolean e2_task_backend_link (gchar *target, gchar *name);
gboolean e2_task_backend_rename (gchar *oldsrc, gchar *newsrc);
gboolean e2_task_backend_delete (gchar *path);
gboolean e2_task_backend_chmod (gchar *path, gchar *mode, E2_RecurseType recurse);
gboolean e2_task_backend_chown (gchar *path, uid_t owner_id, gid_t group_id,
	gboolean recurse);
gboolean e2_task_backend_open (gchar *path, gboolean ask);
gboolean e2_task_backend_view (gchar *filename);
void e2_task_actions_register (void);

#endif //ndef _E2_TASK_H
