/* $Id: e2p_find.h 555 2007-07-23 09:39:52Z tpgww $

Copyright (C) 2005-2007 tooar <tooar@gmx.net>
Portions copyright (C) 1999 Matthew Grossman <mattg@oz.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/
// this code was originally sourced from gtkfind 1.1 by Matthew Grossman
/**
@file plugins/e2p_find.h
@brief header for file-find plugin
*/

#ifndef E2P_FIND_H
#define E2P_FIND_H

#include "emelfm2.h"

//support mime-type search criteria
#define MIMEFIND

typedef enum
{
	SEARCH_ALL_P = 0, SEARCH_CURRENT_P, SEARCH_OTHER_P, SEARCH_THIS_P,
	SEARCH_SUBDIRS_P,

	STRING_FILENAME_P, WILDCARD_FILENAME_P, REGEXP_FILENAME_P, ANYCASE_FILENAME_P,

	STRING_CONTENT_P, WILDCARD_CONTENT_P, REGEXP_CONTENT_P, ANYCASE_CONTENT_P,

	MODE_IS_P, MODE_OR_P, MODE_NOT_P,
//for decoding, these need to be in the same order as the flags in the permissions dialog
//"u+s", "g+s", "o+t", "u+r", "u+w", "u+x", "g+r", "g+w", "g+x", "o+r", "o+w", "o+x"
	SETUID_P, SETGID_P, STICKY_P,
	OWNER_READ_P, OWNER_WRITE_P, OWNER_EXEC_P,
	GROUP_READ_P, GROUP_WRITE_P, GROUP_EXEC_P,
	WORLD_READ_P, WORLD_WRITE_P, WORLD_EXEC_P,

	REGULAR_P, DIRECTORY_P, RAW_DEVICE_P, BLOCK_DEVICE_P,
	SYMLINK_P, SOCKET_P, FIFO_P,

	UID_ANY_P, UID_SPECIFIC_P, UID_NONE_P, UID_LOGIN_P, UID_NOT_LOGIN_P,
	GID_ANY_P, GID_SPECIFIC_P, GID_NONE_P, GID_LOGIN_P, GID_NOT_LOGIN_P,

	FSIZE_LT_P, FSIZE_EQ_P, FSIZE_GT_P,
	FSIZE_B_P, FSIZE_KB_P, FSIZE_MB_P,

	MTIME_ET_P, MTIME_EQ_P, MTIME_LT_P,
	ATIME_ET_P, ATIME_EQ_P, ATIME_LT_P,
	CTIME_ET_P, CTIME_EQ_P, CTIME_LT_P,

	MAX_FLAGS	//no. of entries in the array
} findflag_t;
//this is the value which starts the permissions flags
//used for decoding the flags to a mode number
#define PERMISSIONS1 SETUID_P

//we don't bother to cache the start-directory entry
enum
{
	NAME_ENTRY,
	CONTENT_ENTRY,
	MIME_ENTRY,
	SIZE_ENTRY,
	UID_ENTRY,
	GID_ENTRY,
	MAX_ENTRIES
};

typedef struct _E2P_Spinners
{
	GtkWidget *day_spin;
	GtkWidget *month_spin;
	GtkWidget *year_spin;
	GtkWidget *hour_spin;
	GtkWidget *minute_spin;
} spinners;

typedef struct _E2_FindDialogRuntime
{
	GtkWidget *dialog;
	GtkWidget *notebook; //notebook, gui for the various search criteria
	GtkWidget *active_button;//radio-button for searching in current directory
	GtkWidget *thisdir_button; //radio-button for searching in directory-entry path
	GtkWidget *directory; //entry with text for directory to search in/from
	GtkWidget *pattern;  //entry with text for file name to search for
#ifdef MIMEFIND
	GtkWidget *mime_entry;	//entry with user-specified mimetype
#endif
	GtkWidget *content_pattern; //entry with text for file content
	GtkWidget *curr_user;
	GtkWidget *choose_user;
	GtkWidget *user_entry;	//entry with user-specified uid
	GtkWidget *curr_group;
	GtkWidget *choose_group;
	GtkWidget *group_entry;	//entry with user-specified uid
	GtkWidget *size_entry;	//entry with user-specified filesize
	//spin buttons for file date/time parameters
	spinners mtime;
	spinners atime;
	spinners ctime;
//	GtkWidget *stop_button;  //button widget, remebered for changing sensitivity
//	GtkWidget *start_button; //ditto
//	GtkWidget *help_button;  //ditto
//	gboolean stop_flag;	//TRUE when stop button clicked
	GSList *groups;  //list of lists of grouped toggle btns
	glong find_pid;
//now static	gboolean flags[MAX_FLAGS];	//cache for toggle values
} E2_FindDialogRuntime;

typedef struct _E2P_TimeOffset
{
	glong days;
	gint minutes;
} offset;

typedef struct _E2P_DateTime
{
	gfloat day;
	gfloat month;
	gfloat year;
	gfloat hour;
	gfloat minute;
//	gfloat second;
} local_dt;

#endif //ndef E2P_FIND_H
