/* accelerator.c
 *
 * $Id: accelerator.c 93 2003-09-04 15:30:04Z sam $
 *
 * Copyright 1990, 1991, 1992, 1993, 1994, 1995, Oliver Laumann, Berlin
 * Copyright 2002, 2003 Sam Hocevar <sam@zoy.org>, Paris
 *
 * This software was derived from Elk 1.2, which was Copyright 1987, 1988,
 * 1989, Nixdorf Computer AG and TELES GmbH, Berlin (Elk 1.2 has been written
 * by Oliver Laumann for TELES Telematic Services, Berlin, in a joint project
 * between TELES and Nixdorf Microprocessor Engineering, Berlin).
 *
 * Oliver Laumann, TELES GmbH, Nixdorf Computer AG and Sam Hocevar, as co-
 * owners or individual owners of copyright in this software, grant to any
 * person or company a worldwide, royalty free, license to
 *
 *    i) copy this software,
 *   ii) prepare derivative works based on this software,
 *  iii) distribute copies of this software or derivative works,
 *   iv) perform this software, or
 *    v) display this software,
 *
 * provided that this notice is not removed and that neither Oliver Laumann
 * nor Teles nor Nixdorf are deemed to have made any representations as to
 * the suitability of this software for any purpose nor are held responsible
 * for any defects of this software.
 *
 * THERE IS ABSOLUTELY NO WARRANTY FOR THIS SOFTWARE.
 */

#include "xt.h"

XtAccelerators Get_Accelerators (Object a) {
    register char *s;
    XtAccelerators ret;
    Alloca_Begin;

    Get_Strsym_Stack (a, s);
    if ((ret = XtParseAcceleratorTable (s)) == 0)
        Primitive_Error ("bad accelerator table: ~s", a);
    Alloca_End;
    return ret;
}

static Object P_Install_Accelerators (Object dst, Object src) {
    Check_Widget (dst);
    Check_Widget (src);
    XtInstallAccelerators (WIDGET(dst)->widget, WIDGET(src)->widget);
    return Void;
}

static Object P_Install_All_Accelerators (Object dst, Object src) {
    Check_Widget (dst);
    Check_Widget (src);
    XtInstallAllAccelerators (WIDGET(dst)->widget, WIDGET(src)->widget);
    return Void;

}

void elk_init_xt_accelerator () {
    Define_Primitive (P_Install_Accelerators,
                        "install-accelerators",       2, 2, EVAL);
    Define_Primitive (P_Install_All_Accelerators,
                        "install-all-accelerators",   2, 2, EVAL);
}
