/*
    Eiciel - GNOME editor of ACL file permissions.
    Copyright (C) 2004-2005 Roger Ferrer Ibez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef GESTOR_XATTR_HPP
#define GESTOR_XATTR_HPP

#include <config.hpp>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <attr/xattr.h>

#include <string>
#include <cstring>
#include <vector>
#include <map>
#include <glibmm.h>
#include <iostream>

#include <gettext.h>


class GestorXAttrException
{
	public:
		GestorXAttrException(Glib::ustring missatge) : missatge(missatge) 
		{
		}

		Glib::ustring getMessage() const
		{ 
			return missatge; 
		}
	private:
		Glib::ustring missatge;
};

class GestorXAttr {

	public:
		typedef std::map<std::string, std::string> atributs_t;

		GestorXAttr(const Glib::ustring& nomFitxer) throw (GestorXAttrException);

		atributs_t donarLlistaAtributs();
		void eliminarAtribut(std::string nomAtr);
		void establirAtributs(atributs_t atributs);
		void afegirAtribut(std::string nomAtr, std::string valor);
		void canviarNomAtribut(std::string anticNomAttr, std::string nouNomAttr);

		uid_t donarUidPropietari()
		{
			return this->propietari;
		}

	private:
		std::vector<std::string> obtenirLlistaXAttr() throw (GestorXAttrException);
        std::string recuperarValorAtribut(const std::string& nomAtr) throw (GestorXAttrException);

		void testLectura() throw (GestorXAttrException);

		Glib::ustring nomFitxer;

		uid_t propietari;
}
;

#endif
