/*
    Eiciel - GNOME editor of ACL file permissions.
    Copyright (C) 2004-2005 Roger Ferrer Ibez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "cellrenderer_acl.hpp"


CellRendererACL::CellRendererACL()
	: Glib::ObjectBase (typeid(CellRendererACL)),
	Gtk::CellRendererToggle(),
	property_marca_fons_(*this, "marcar_fons", false)
{
}

void CellRendererACL::render_vfunc (const Glib::RefPtr<Gdk::Drawable>& window,
		Gtk::Widget& widget,
		const Gdk::Rectangle& background_area,
		const Gdk::Rectangle& cell_area,
		const Gdk::Rectangle& expose_area,
		Gtk::CellRendererState flags
		)
{
	Gtk::CellRendererToggle::render_vfunc(window, widget, background_area, cell_area, expose_area, flags);

	// Pintem una admiraci
	if (property_marca_fons_.get_value() && property_active())
	{
	 	Glib::RefPtr<Pango::Layout> pango = Pango::Layout::create(widget.get_pango_context());
	 	pango->set_markup("<span foreground=\"#cc0000\" weight=\"bold\">!</span>");

	 	Pango::Rectangle ink_rect = pango->get_pixel_ink_extents();

	 	// A GTK els checkboxes sempre son de 12x12 
	 	// per tant -> hardcode 6
	 	int posicioX = cell_area.get_x() + (cell_area.get_width() / 2) - 6;
	 	int posicioY = cell_area.get_y() + (cell_area.get_height() / 2) - 6;

		Glib::RefPtr<Gdk::GC> context_grafic = Gdk::GC::create(window);

		window->draw_layout(context_grafic, 
				posicioX - ink_rect.get_width() - 4,
				posicioY - ink_rect.get_height() / 2,
				pango);
		
		// estil->paint_layout ( window,
		// 		Gtk::STATE_NORMAL,
		// 		false,
		// 		cell_area,
		// 		widget,
		// 		"",
		// 		posicioX - ink_rect.get_width() - 4, 
		// 		posicioY - ink_rect.get_height() / 2,
		// 		pango);
	}
}


Glib::PropertyProxy<bool> CellRendererACL::property_marcar_fons()
{
	return Glib::PropertyProxy<bool>(this, "marcar_fons");
}

