#ifndef _EGOBOOTYPEDEF_H_
#define _EGOBOOTYPEDEF_H_

#pragma warning(disable : 4305)                     // Turn off silly warnings
#pragma warning(disable : 4244)                     //

/* Make sure that _MACOS is defined in MetroWerks compilers */
#if defined( __MWERKS__ ) && defined( macintosh )
#define	_MACOS
#define _BIG_ENDIAN
// use SDL type 
#include <SDL.h>
#include <Endian.h>

typedef Uint32			BOOL;
typedef Sint32			LONG;
typedef Uint32			DWORD;

typedef struct lin_RECT { LONG left; LONG right; LONG top; LONG bottom; } RECT;

#define LE32bitToHost( pData, pNumByte ) pData
#define BE32bitToHost( pData, pNumByte ) pData
#define LE16bitToHost( pData, pNumByte ) pData
#define BE16bitToHost( pData, pNumByte ) pData
#define EndianChange32bit( pData, pNumByte ) pData
#define EndianChange16bit( pData, pNumByte ) pData

float LoadFloatByteswapped( float *ptr );
inline float LoadFloatByteswapped( float *ptr )
{
	union {
		float f;
		long l;
	} data;

	/*Load byteswapped and store to the stack*/
	data.l = __lwbrx( ptr, 0 ); 

	/*Return the result*/
	return data.f;
}

#endif

// Windows typedef
#ifdef _WIN32  // (I.E. Visual C)
#define WIN32_LEAN_AND_MEAN
#pragma warning(disable : 4554)
#pragma warning(disable : 4761)

// VisualC does not support the non-standard inline in C (they do it their way)
#define inline __inline

#include <windows.h>
#include <SDL.h>
#define _LITTLE_ENDIAN
// use SDL type 
#define LE32bitToHost( pData, pNumByte ) pData
#define BE32bitToHost( pData, pNumByte ) pData
#define LE16bitToHost( pData, pNumByte ) pData
#define BE16bitToHost( pData, pNumByte ) _swab( (char *)(pData ), (char *)(pData ), (pNumByte) )
#define EndianChange32bit( pData, pNumByte ) pData
#define EndianChange16bit( pData, pNumByte ) _swab( (char *)(pData ), (char *)(pData ), (pNumByte) )
#endif

// LINUX typedef
#ifdef _LINUX
#include "SDL.h"
// use SDL type 
typedef Uint32			BOOL;
typedef Sint32			LONG;
typedef Uint32			DWORD;
typedef struct lin_RECT { LONG left; LONG right; LONG top; LONG bottom; } RECT;
#define _LITTLE_ENDIAN
#define LE32bitToHost( pData, pNumByte ) pData
#define BE32bitToHost( pData, pNumByte ) pData
#define LE16bitToHost( pData, pNumByte ) pData
#define BE16bitToHost( pData, pNumByte ) pData
#define EndianChange32bit( pData, pNumByte ) pData
#define EndianChange16bit( pData, pNumByte ) pData
#endif


#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE (!FALSE)	// nv20001128 -- standard definition. This may save us grief later on
#endif




#endif // #ifndef _EGOBOOTYPEDEF_H_

