/*
 * Eee Applet 
 * Copyright (C) 2008 Olivier Rolland <billl@users.sourceforge.net>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __EEE_MONITOR_PROCFS_H__
#define __EEE_MONITOR_PROCFS_H__

#include <glib-object.h>

#include "eee-monitor.h"

G_BEGIN_DECLS

typedef enum
{
  EEE_PROCFS_ASUS,
  EEE_PROCFS_EEE
} EeeProcfsType;

#define EEE_TYPE_MONITOR_PROCFS            (eee_monitor_procfs_get_type ())
#define EEE_MONITOR_PROCFS(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), EEE_TYPE_MONITOR_PROCFS, EeeMonitorProcfs))
#define EEE_MONITOR_PROCFS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), EEE_TYPE_MONITOR_PROCFS, EeeMonitorProcfsClass))
#define EEE_IS_MONITOR_PROCFS(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EEE_TYPE_MONITOR_PROCFS))
#define EEE_IS_MONITOR_PROCFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EEE_TYPE_MONITOR_PROCFS))
#define EEE_MONITOR_PROCFS_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), EEE_TYPE_MONITOR_PROCFS, EeeMonitorProcfsClass))

typedef struct _EeeMonitorProcfs      EeeMonitorProcfs;
typedef struct _EeeMonitorProcfsClass EeeMonitorProcfsClass;
typedef struct _EeeMonitorProcfsPriv  EeeMonitorProcfsPriv;

struct _EeeMonitorProcfs
{
  EeeMonitor parent;
  EeeMonitorProcfsPriv *priv;
};

struct _EeeMonitorProcfsClass
{
  EeeMonitorClass parent_class;

  void (* online) (EeeMonitorProcfs *monitor);
};

GType        eee_monitor_procfs_get_type (void) G_GNUC_CONST;
EeeMonitor * eee_monitor_procfs_new      (void);

gint         eee_monitor_procfs_get_fsb_speed   (EeeMonitorProcfs *monitor);
gboolean     eee_monitor_procfs_get_fan_manual  (EeeMonitorProcfs *monitor);
gint         eee_monitor_procfs_get_fan_speed   (EeeMonitorProcfs *monitor);
gint         eee_monitor_procfs_get_fan_rpm     (EeeMonitorProcfs *monitor);
gint         eee_monitor_procfs_get_temperature (EeeMonitorProcfs *monitor);

gint         eee_monitor_procfs_get_brightness  (EeeMonitorProcfs *monitor);
gboolean     eee_monitor_procfs_get_card_reader (EeeMonitorProcfs *monitor);
gboolean     eee_monitor_procfs_get_camera      (EeeMonitorProcfs *monitor);
gboolean     eee_monitor_procfs_get_wlan        (EeeMonitorProcfs *monitor);

gboolean     eee_monitor_procfs_is_online       (EeeProcfsType    type);

G_END_DECLS

#endif /* __EEE_MONITOR_PROCFS_H__ */

