/*
***************************************************************************
*
* Author: Teunis van Beelen
*
* Copyright (C) 2010 Teunis van Beelen
*
* teuniz@gmail.com
*
***************************************************************************
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation version 2 of the License.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
***************************************************************************
*
* This version of GPL is at http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
*
***************************************************************************
*/



#include "header_editor.h"



#if defined(__APPLE__) || defined(__MACH__) || defined(__APPLE_CC__)

#define fseeko fseek
#define ftello ftell
#define fopeno fopen

#else

#define fseeko fseeko64
#define ftello ftello64
#define fopeno fopen64

#endif





UI_headerEditorWindow::UI_headerEditorWindow(QWidget *parent)
{
  mainwindow = (UI_Mainwindow *)parent;

  setWindowTitle("EDF+/BDF+ header editor");

  edf = 0;
  bdf = 0;
  edfplus = 0;
  bdfplus = 0;
  edfsignals = 0;

  file = NULL;

  setMinimumSize(690, 490);
  setMaximumSize(690, 490);

  tabholder = new QTabWidget(this);
  tabholder->setGeometry(0, 0, 690, 420);

  tab1 = new QWidget;
  tab2 = new QWidget;

  fileNameLabel = new QLabel(tab1);
  fileNameLabel->setGeometry(10, 10, 670, 25);

  label1 = new QLabel(tab1);
  label1->setGeometry(10, 45, 80, 25);
  label1->setText("Subject");
  label1->setVisible(FALSE);

  lineEdit1 = new QLineEdit(tab1);
  lineEdit1->setGeometry(100, 45, 580, 25);
  lineEdit1->setMaxLength(80);
  lineEdit1->setVisible(FALSE);

  label2 = new QLabel(tab1);
  label2->setGeometry(10, 80, 80, 25);
  label2->setText("Recording");
  label2->setVisible(FALSE);

  lineEdit2 = new QLineEdit(tab1);
  lineEdit2->setGeometry(100, 80, 580, 25);
  lineEdit2->setMaxLength(80);
  lineEdit2->setVisible(FALSE);

  label3 = new QLabel(tab1);
  label3->setGeometry(10, 45, 80, 25);
  label3->setText("Subject code");
  label3->setVisible(FALSE);

  lineEdit3 = new QLineEdit(tab1);
  lineEdit3->setGeometry(100, 45, 580, 25);
  lineEdit3->setMaxLength(80);
  lineEdit3->setVisible(FALSE);

  label4 = new QLabel(tab1);
  label4->setGeometry(10, 80, 80, 25);
  label4->setText("Subject name");
  label4->setVisible(FALSE);

  lineEdit4 = new QLineEdit(tab1);
  lineEdit4->setGeometry(100, 80, 580, 25);
  lineEdit4->setMaxLength(80);
  lineEdit4->setVisible(FALSE);

  label11 = new QLabel(tab1);
  label11->setGeometry(10, 115, 80, 25);
  label11->setText("Gender");
  label11->setVisible(FALSE);

  comboBox1 = new QComboBox(tab1);
  comboBox1->setGeometry(100, 115, 125, 25);
  comboBox1->addItem("unknown");
  comboBox1->addItem("male");
  comboBox1->addItem("female");
  comboBox1->setVisible(FALSE);

  charsleft1Label = new QLabel(tab1);
  charsleft1Label->setGeometry(500, 115, 120, 25);
  charsleft1Label->setVisible(FALSE);

  label12 = new QLabel(tab1);
  label12->setGeometry(10, 150, 80, 25);
  label12->setText("Birthdate");
  label12->setVisible(FALSE);

  dateEdit1 = new QDateEdit(tab1);
  dateEdit1->setGeometry(100, 150, 125, 25);
  dateEdit1->setDisplayFormat("d MMM yyyy");
  dateEdit1->setVisible(FALSE);

  checkBox1 = new QCheckBox("No birthdate", tab1);
  checkBox1->setGeometry(245, 150, 125, 25);
  checkBox1->setTristate(FALSE);
  checkBox1->setCheckState(Qt::Unchecked);
  checkBox1->setVisible(FALSE);

  label5 = new QLabel(tab1);
  label5->setGeometry(10, 185, 80, 25);
  label5->setText("Additional info");
  label5->setVisible(FALSE);

  lineEdit5 = new QLineEdit(tab1);
  lineEdit5->setGeometry(100, 185, 580, 25);
  lineEdit5->setMaxLength(80);
  lineEdit5->setVisible(FALSE);

  label6 = new QLabel(tab1);
  label6->setGeometry(10, 220, 80, 25);
  label6->setText("Admin. code");
  label6->setVisible(FALSE);

  lineEdit6 = new QLineEdit(tab1);
  lineEdit6->setGeometry(100, 220, 580, 25);
  lineEdit6->setMaxLength(80);
  lineEdit6->setVisible(FALSE);

  label7 = new QLabel(tab1);
  label7->setGeometry(10, 255, 80, 25);
  label7->setText("Technician");
  label7->setVisible(FALSE);

  lineEdit7 = new QLineEdit(tab1);
  lineEdit7->setGeometry(100, 255, 580, 25);
  lineEdit7->setMaxLength(80);
  lineEdit7->setVisible(FALSE);

  label8 = new QLabel(tab1);
  label8->setGeometry(10, 290, 80, 25);
  label8->setText("Device");
  label8->setVisible(FALSE);

  lineEdit8 = new QLineEdit(tab1);
  lineEdit8->setGeometry(100, 290, 580, 25);
  lineEdit8->setMaxLength(80);
  lineEdit8->setVisible(FALSE);

  label9 = new QLabel(tab1);
  label9->setGeometry(10, 325, 80, 25);
  label9->setText("Additional info");
  label9->setVisible(FALSE);

  lineEdit9 = new QLineEdit(tab1);
  lineEdit9->setGeometry(100, 325, 580, 25);
  lineEdit9->setMaxLength(80);
  lineEdit9->setVisible(FALSE);

  charsleft2Label = new QLabel(tab1);
  charsleft2Label->setGeometry(500, 360, 120, 25);
  charsleft2Label->setVisible(FALSE);

  signallist = new QTableWidget(tab2);
  signallist->setGeometry(10, 10, 670, 375);
  signallist->setSelectionMode(QAbstractItemView::NoSelection);
  signallist->setEditTriggers(QAbstractItemView::NoEditTriggers);
  signallist->setColumnCount(4);
  signallist->setSelectionMode(QAbstractItemView::NoSelection);
  signallist->setColumnWidth(0, 180);
  signallist->setColumnWidth(1, 120);
  signallist->setColumnWidth(2, 520);
  signallist->setColumnWidth(3, 520);
  QStringList horizontallabels;
  horizontallabels += "Label";
  horizontallabels += "Physical dimension";
  horizontallabels += "Prefilter";
  horizontallabels += "Transducer";
  signallist->setHorizontalHeaderLabels(horizontallabels);

  pushButton1 = new QPushButton(this);
  pushButton1->setGeometry(580, 440, 100, 25);
  pushButton1->setText("Close");

  pushButton2 = new QPushButton(this);
  pushButton2->setGeometry(200, 440, 100, 25);
  pushButton2->setText("Save");

  pushButton3 = new QPushButton(this);
  pushButton3->setGeometry(10, 440, 100, 25);
  pushButton3->setText("Select file");

  connect(pushButton1, SIGNAL(clicked()), this, SLOT(close()));
  connect(pushButton2, SIGNAL(clicked()), this, SLOT(save_hdr()));
  connect(pushButton3, SIGNAL(clicked()), this, SLOT(open_file()));

  tabholder->addTab(tab1, "Header");
  tabholder->addTab(tab2, "Signals");

  hdr = (char *)malloc(66048);

  UI_Messagewindow popuperror("Warning", "Always make a backup copy of your file before using this tool!", "OK");

  exec();
}


void UI_headerEditorWindow::closeEvent(QCloseEvent *event)
{
  if(file != NULL)
  {
    fclose(file);
  }

  if(hdr != NULL)
  {
    free(hdr);
  }

  event->accept();
}


void UI_headerEditorWindow::open_file()
{
  if(file != NULL)
  {
    fclose(file);
    file = NULL;
  }

  edf = 0;
  bdf = 0;
  edfplus = 0;
  bdfplus = 0;
  edfsignals = 0;

  disconnect(lineEdit3,   SIGNAL(textEdited(const QString &)), this, SLOT(calculate_chars_left_name(const QString &)));
  disconnect(lineEdit4,   SIGNAL(textEdited(const QString &)), this, SLOT(calculate_chars_left_name(const QString &)));
  disconnect(lineEdit5,   SIGNAL(textEdited(const QString &)), this, SLOT(calculate_chars_left_name(const QString &)));
  disconnect(lineEdit6,   SIGNAL(textEdited(const QString &)), this, SLOT(calculate_chars_left_recording(const QString &)));
  disconnect(lineEdit7,   SIGNAL(textEdited(const QString &)), this, SLOT(calculate_chars_left_recording(const QString &)));
  disconnect(lineEdit8,   SIGNAL(textEdited(const QString &)), this, SLOT(calculate_chars_left_recording(const QString &)));
  disconnect(lineEdit9,   SIGNAL(textEdited(const QString &)), this, SLOT(calculate_chars_left_recording(const QString &)));

  lineEdit3->setMaxLength(80);
  lineEdit4->setMaxLength(80);
  lineEdit5->setMaxLength(80);
  lineEdit6->setMaxLength(80);
  lineEdit7->setMaxLength(80);
  lineEdit8->setMaxLength(80);
  lineEdit9->setMaxLength(80);

  lineEdit1->clear();
  lineEdit2->clear();
  lineEdit3->clear();
  lineEdit4->clear();
  lineEdit5->clear();
  lineEdit6->clear();
  lineEdit7->clear();
  lineEdit8->clear();
  lineEdit9->clear();

  signallist->setRowCount(0);

  fileNameLabel->clear();

  if(hdr==NULL)
  {
    UI_Messagewindow popuperror("Error", "Malloc error");
    return;
  }

  strcpy(path, QFileDialog::getOpenFileName(0, "Open file", mainwindow->recent_opendir, "EDF/BDF files (*.edf *.EDF *.bdf *.BDF)").toLatin1().data());

  if(!strcmp(path, ""))
  {
    return;
  }

  get_directory_from_path(mainwindow->recent_opendir, path, 1024);

  if(mainwindow->file_is_opened(path))
  {
    UI_Messagewindow popuperror("Failure", "Selected file is in use.");
    return;
  }

  file = fopeno(path, "r+b");
  if(file==NULL)
  {
    UI_Messagewindow popuperror("Error", "Can not open file.");
    return;
  }

  rewind(file);

  if(fread(hdr, 256, 1, file) != 1)
  {
    UI_Messagewindow popuperror("Error", "Can not read from file.");
    fclose(file);
    file = NULL;
    return;
  }

  if(!(strncmp(hdr, "0       ", 8)))  edf = 1;

  if((!(strncmp(hdr + 1, "BIOSEMI", 7))) && (((unsigned char *)hdr)[0] == 255))
  {
    bdf = 1;
  }

  if((!edf) && (!bdf))
  {
    UI_Messagewindow popuperror("Error", "File is not a valid EDF or BDF file");
    fclose(file);
    file = NULL;
    return;
  }

  edfsignals = antoi(hdr + 252, 4);

  if((edfsignals < 0) || (edfsignals > 256))
  {
    UI_Messagewindow popuperror("Error", "Invalid number of signals in header");
    fclose(file);
    file = NULL;
    return;
  }

  if((!(strncmp(hdr + 192, "EDF+C", 5))) || (!(strncmp(hdr + 192, "EDF+D", 5))))
  {
    edfplus = 1;
  }

  if((!(strncmp(hdr + 192, "BDF+C", 5))) || (!(strncmp(hdr + 192, "BDF+D", 5))))
  {
    bdfplus = 1;
  }

  read_header();
}


void UI_headerEditorWindow::read_header()
{
  int i, j, p, r;

  char scratchpad[256],
       str[256];


  fileNameLabel->setText(path);

  rewind(file);

  if(fread(hdr, (256 * edfsignals) + 256, 1, file) != 1)
  {
    UI_Messagewindow popuperror("Error", "Can not read from file.");
    fclose(file);
    file = NULL;
    return;
  }

  if(edfplus || bdfplus)
  {
    label1->setVisible(FALSE);
    label2->setVisible(FALSE);

    lineEdit1->setVisible(FALSE);
    lineEdit2->setVisible(FALSE);

    label3->setVisible(TRUE);
    label4->setVisible(TRUE);
    label5->setVisible(TRUE);
    label6->setVisible(TRUE);
    label7->setVisible(TRUE);
    label8->setVisible(TRUE);
    label9->setVisible(TRUE);
    label11->setVisible(TRUE);
    label12->setVisible(TRUE);
    charsleft1Label->setVisible(TRUE);
    charsleft2Label->setVisible(TRUE);

    lineEdit3->setVisible(TRUE);
    lineEdit4->setVisible(TRUE);
    lineEdit5->setVisible(TRUE);
    lineEdit6->setVisible(TRUE);
    lineEdit7->setVisible(TRUE);
    lineEdit8->setVisible(TRUE);
    lineEdit9->setVisible(TRUE);

    comboBox1->setVisible(TRUE);

    checkBox1->setVisible(TRUE);

    dateEdit1->setVisible(TRUE);

    strncpy(scratchpad, hdr + 8, 80);
    scratchpad[80] = 0;
    strcat(scratchpad, "    ");

    p = 0;

    for(i=0; i<80; i++)
    {
      if(scratchpad[i] == ' ')  break;
    }
    if(strncmp(scratchpad, "X ", 2))
    {
      scratchpad[i] = 0;
      for(j=p; j<i; j++)
      {
        if(scratchpad[j] == '_')  scratchpad[j] = ' ';
      }
      strcpy(str, scratchpad);
      remove_trailing_spaces(str);
      lineEdit3->setText(str);
    }
    else
    {
      lineEdit3->clear();
    }

    p = ++i;

    for(; i<80; i++)
    {
      if(scratchpad[i] == ' ')  break;
    }
    comboBox1->setCurrentIndex(0);
    if(!(strncmp(scratchpad + p, "M ", 2)))
    {
      comboBox1->setCurrentIndex(1);
    }
    if(!(strncmp(scratchpad + p, "F ", 2)))
    {
      comboBox1->setCurrentIndex(2);
    }

    p = ++i;

    for(; i<80; i++)
    {
      if(scratchpad[i] == ' ')  break;
    }
    dateEdit1->setDate(QDate(1800, 1, 1));
    if(strncmp(scratchpad + p, "X ", 2))
    {
      scratchpad[i] = 0;

      r = 0;
      if(!strncmp(scratchpad + p + 3, "JAN", 3))  r = 1;
        else if(!strncmp(scratchpad + p + 3, "FEB", 3))  r = 2;
          else if(!strncmp(scratchpad + p + 3, "MAR", 3))  r = 3;
            else if(!strncmp(scratchpad + p + 3, "APR", 3))  r = 4;
              else if(!strncmp(scratchpad + p + 3, "MAY", 3))  r = 5;
                else if(!strncmp(scratchpad + p + 3, "JUN", 3))  r = 6;
                  else if(!strncmp(scratchpad + p + 3, "JUL", 3))  r = 7;
                    else if(!strncmp(scratchpad + p + 3, "AUG", 3))  r = 8;
                      else if(!strncmp(scratchpad + p + 3, "SEP", 3))  r = 9;
                        else if(!strncmp(scratchpad + p + 3, "OCT", 3))  r = 10;
                          else if(!strncmp(scratchpad + p + 3, "NOV", 3))  r = 11;
                            else if(!strncmp(scratchpad + p + 3, "DEC", 3))  r = 12;

      if(r)
      {
        dateEdit1->setDate(QDate(atoi(scratchpad + p + 7), r, atoi(scratchpad + p)));

        checkBox1->setCheckState(Qt::Unchecked);
      }

      p += 10;
    }
    else
    {
      checkBox1->setCheckState(Qt::Checked);
    }

    p = ++i;

    for(; i<80; i++)
    {
      if(scratchpad[i] == ' ')  break;
    }
    if(strncmp(scratchpad + p, "X ", 2))
    {
      scratchpad[i] = 0;
      for(j=p; j<i; j++)
      {
        if(scratchpad[j] == '_')  scratchpad[j] = ' ';
      }
      strcpy(str, scratchpad + p);
      remove_trailing_spaces(str);
      lineEdit4->setText(str);
    }
    else
    {
      lineEdit4->clear();
    }

    p = ++i;

    scratchpad[80] = 0;
    strcpy(str, scratchpad + p);
    remove_trailing_spaces(str);
    lineEdit5->setText(str);

    strncpy(scratchpad, hdr + 88, 80);
    scratchpad[80] = 0;
    strcat(scratchpad, "    ");

    p = 10;

    for(i=10; i<80; i++)
    {
      if(scratchpad[i] == ' ')  break;
    }
    if(strncmp(scratchpad + p, "X ", 2))
    {
      scratchpad[i] = 0;

      has_startdate = 1;

      p += 10;
    }
    else
    {
      has_startdate = 0;
    }

    p = ++i;

    for(; i<80; i++)
    {
      if(scratchpad[i] == ' ')  break;
    }
    if(strncmp(scratchpad + p, "X ", 2))
    {
      scratchpad[i] = 0;
      for(j=p; j<i; j++)
      {
        if(scratchpad[j] == '_')  scratchpad[j] = ' ';
      }
      strcpy(str, scratchpad + p);
      remove_trailing_spaces(str);
      lineEdit6->setText(str);
    }
    else
    {
      lineEdit6->clear();
    }

    p = ++i;

    for(; i<80; i++)
    {
      if(scratchpad[i] == ' ')  break;
    }
    if(strncmp(scratchpad + p, "X ", 2))
    {
      scratchpad[i] = 0;
      for(j=p; j<i; j++)
      {
        if(scratchpad[j] == '_')  scratchpad[j] = ' ';
      }
      strcpy(str, scratchpad + p);
      remove_trailing_spaces(str);
      lineEdit7->setText(str);
    }
    else
    {
      lineEdit7->clear();
    }

    p = ++i;

    for(; i<80; i++)
    {
      if(scratchpad[i] == ' ')  break;
    }
    if(strncmp(scratchpad + p, "X ", 2))
    {
      scratchpad[i] = 0;
      for(j=p; j<i; j++)
      {
        if(scratchpad[j] == '_')  scratchpad[j] = ' ';
      }
      strcpy(str, scratchpad + p);
      remove_trailing_spaces(str);
      lineEdit8->setText(str);
    }
    else
    {
      lineEdit8->clear();
    }

    p = ++i;

    scratchpad[80] = 0;
    strcpy(str, scratchpad + p);
    remove_trailing_spaces(str);
    lineEdit9->setText(str);

    calculate_chars_left_name("");
    calculate_chars_left_recording("");

    connect(lineEdit3,   SIGNAL(textEdited(const QString &)), this, SLOT(calculate_chars_left_name(const QString &)));
    connect(lineEdit4,   SIGNAL(textEdited(const QString &)), this, SLOT(calculate_chars_left_name(const QString &)));
    connect(lineEdit5,   SIGNAL(textEdited(const QString &)), this, SLOT(calculate_chars_left_name(const QString &)));
    connect(lineEdit6,   SIGNAL(textEdited(const QString &)), this, SLOT(calculate_chars_left_recording(const QString &)));
    connect(lineEdit7,   SIGNAL(textEdited(const QString &)), this, SLOT(calculate_chars_left_recording(const QString &)));
    connect(lineEdit8,   SIGNAL(textEdited(const QString &)), this, SLOT(calculate_chars_left_recording(const QString &)));
    connect(lineEdit9,   SIGNAL(textEdited(const QString &)), this, SLOT(calculate_chars_left_recording(const QString &)));
  }
  else
  {
    label3->setVisible(FALSE);
    label4->setVisible(FALSE);
    label5->setVisible(FALSE);
    label6->setVisible(FALSE);
    label7->setVisible(FALSE);
    label8->setVisible(FALSE);
    label9->setVisible(FALSE);
    label11->setVisible(FALSE);
    label12->setVisible(FALSE);
    charsleft1Label->setVisible(FALSE);
    charsleft2Label->setVisible(FALSE);

    lineEdit3->setVisible(FALSE);
    lineEdit4->setVisible(FALSE);
    lineEdit5->setVisible(FALSE);
    lineEdit6->setVisible(FALSE);
    lineEdit7->setVisible(FALSE);
    lineEdit8->setVisible(FALSE);
    lineEdit9->setVisible(FALSE);

    comboBox1->setVisible(FALSE);

    checkBox1->setVisible(FALSE);

    dateEdit1->setVisible(FALSE);

    label1->setVisible(TRUE);
    label2->setVisible(TRUE);

    lineEdit1->setVisible(TRUE);
    lineEdit2->setVisible(TRUE);

    strncpy(scratchpad, hdr + 8, 80);
    scratchpad[80] = 0;
    remove_trailing_spaces(scratchpad);
    lineEdit1->setText(scratchpad);

    strncpy(scratchpad, hdr + 88, 80);
    scratchpad[80] = 0;
    remove_trailing_spaces(scratchpad);
    lineEdit2->setText(scratchpad);
  }

  signallist->setRowCount(edfsignals);

  for(i=0; i<edfsignals; i++)
  {
    signallist->setRowHeight(i, 25);

    strncpy(scratchpad, hdr + 256 + (i * 16), 16);
    scratchpad[16] = 0;
    remove_trailing_spaces(scratchpad);
    signallist->setCellWidget(i, 0, new QLineEdit(scratchpad));
    ((QLineEdit *)(signallist->cellWidget(i, 0)))->setMaxLength(16);
    ((QLineEdit *)(signallist->cellWidget(i, 0)))->setText(scratchpad);

    strncpy(scratchpad, hdr + 256 + (edfsignals * 96) + (i * 8), 8);
    scratchpad[8] = 0;
    remove_trailing_spaces(scratchpad);
    signallist->setCellWidget(i, 1, new QLineEdit(scratchpad));
    ((QLineEdit *)(signallist->cellWidget(i, 1)))->setMaxLength(8);
    ((QLineEdit *)(signallist->cellWidget(i, 1)))->setText(scratchpad);

    strncpy(scratchpad, hdr + 256 + (edfsignals * 136) + (i * 80), 80);
    scratchpad[80] = 0;
    remove_trailing_spaces(scratchpad);
    signallist->setCellWidget(i, 2, new QLineEdit(scratchpad));
    ((QLineEdit *)(signallist->cellWidget(i, 2)))->setMaxLength(80);
    ((QLineEdit *)(signallist->cellWidget(i, 2)))->setText(scratchpad);

    strncpy(scratchpad, hdr + 256 + (edfsignals * 16) + (i * 80), 80);
    scratchpad[80] = 0;
    remove_trailing_spaces(scratchpad);
    signallist->setCellWidget(i, 3, new QLineEdit(scratchpad));
    ((QLineEdit *)(signallist->cellWidget(i, 3)))->setMaxLength(80);
    ((QLineEdit *)(signallist->cellWidget(i, 3)))->setText(scratchpad);

    if(edfplus)
    {
      if(!(strncmp(((QLineEdit *)(signallist->cellWidget(i, 0)))->text().toLatin1().data(), "EDF Annotations", 15)))
      {
        ((QLineEdit *)(signallist->cellWidget(i, 0)))->setEnabled(FALSE);
        ((QLineEdit *)(signallist->cellWidget(i, 1)))->setEnabled(FALSE);
        ((QLineEdit *)(signallist->cellWidget(i, 2)))->setEnabled(FALSE);
        ((QLineEdit *)(signallist->cellWidget(i, 3)))->setEnabled(FALSE);
      }
    }

    if(bdfplus)
    {
      if(!(strncmp(((QLineEdit *)(signallist->cellWidget(i, 0)))->text().toLatin1().data(), "BDF Annotations", 15)))
      {
        ((QLineEdit *)(signallist->cellWidget(i, 0)))->setEnabled(FALSE);
        ((QLineEdit *)(signallist->cellWidget(i, 1)))->setEnabled(FALSE);
        ((QLineEdit *)(signallist->cellWidget(i, 2)))->setEnabled(FALSE);
        ((QLineEdit *)(signallist->cellWidget(i, 3)))->setEnabled(FALSE);
      }
    }
  }
}


void UI_headerEditorWindow::save_hdr()
{
  int i, j, len;

  char scratchpad[256],
       str[256];

  if(file == NULL)
  {
    return;
  }

  if(edfplus || bdfplus)
  {
    str[0] = 0;

    len = strlen(lineEdit3->text().toLatin1().data());  // patient code
    if(len)
    {
      strcpy(scratchpad, lineEdit3->text().toLatin1().data());
      latin1_to_ascii(scratchpad, len);
      remove_trailing_spaces(scratchpad);
      for(i=0; i<len; i++)
      {
        if(scratchpad[i] == ' ')  scratchpad[i] = '_';
      }
      if(!strlen(scratchpad))
      {
        strcpy(scratchpad, "X");
      }
      strcat(scratchpad, " ");
      strcat(str, scratchpad);
    }
    else
    {
      strcat(str, "X ");
    }

    if(comboBox1->currentIndex() == 0)  // gender
    {
      strcat(str, "X ");
    }
    if(comboBox1->currentIndex() == 1)
    {
      strcat(str, "M ");
    }
    if(comboBox1->currentIndex() == 2)
    {
      strcat(str, "F ");
    }

    if(checkBox1->checkState() == Qt::Checked)  // birthdate
    {
      strcat(str, "X ");
    }
    else
    {
      i = dateEdit1->date().month();

      switch(i)
      {
        case  1 : sprintf(scratchpad, "%02i-JAN-%04i ", dateEdit1->date().day(), dateEdit1->date().year());
                  break;
        case  2 : sprintf(scratchpad, "%02i-FEB-%04i ", dateEdit1->date().day(), dateEdit1->date().year());
                  break;
        case  3 : sprintf(scratchpad, "%02i-MAR-%04i ", dateEdit1->date().day(), dateEdit1->date().year());
                  break;
        case  4 : sprintf(scratchpad, "%02i-APR-%04i ", dateEdit1->date().day(), dateEdit1->date().year());
                  break;
        case  5 : sprintf(scratchpad, "%02i-MAY-%04i ", dateEdit1->date().day(), dateEdit1->date().year());
                  break;
        case  6 : sprintf(scratchpad, "%02i-JUN-%04i ", dateEdit1->date().day(), dateEdit1->date().year());
                  break;
        case  7 : sprintf(scratchpad, "%02i-JUL-%04i ", dateEdit1->date().day(), dateEdit1->date().year());
                  break;
        case  8 : sprintf(scratchpad, "%02i-AUG-%04i ", dateEdit1->date().day(), dateEdit1->date().year());
                  break;
        case  9 : sprintf(scratchpad, "%02i-SEP-%04i ", dateEdit1->date().day(), dateEdit1->date().year());
                  break;
        case 10 : sprintf(scratchpad, "%02i-OCT-%04i ", dateEdit1->date().day(), dateEdit1->date().year());
                  break;
        case 11 : sprintf(scratchpad, "%02i-NOV-%04i ", dateEdit1->date().day(), dateEdit1->date().year());
                  break;
        case 12 : sprintf(scratchpad, "%02i-DEC-%04i ", dateEdit1->date().day(), dateEdit1->date().year());
                  break;
      }

      strcat(str, scratchpad);
    }

    len = strlen(lineEdit4->text().toLatin1().data());  // patient name
    if(len)
    {
      strcpy(scratchpad, lineEdit4->text().toLatin1().data());
      latin1_to_ascii(scratchpad, len);
      remove_trailing_spaces(scratchpad);
      for(i=0; i<len; i++)
      {
        if(scratchpad[i] == ' ')  scratchpad[i] = '_';
      }
      if(!strlen(scratchpad))
      {
        strcpy(scratchpad, "X");
      }
      strcat(scratchpad, " ");
      strcat(str, scratchpad);
    }
    else
    {
      strcat(str, "X ");
    }

    len = strlen(lineEdit5->text().toLatin1().data());  // additional info
    if(len)
    {
      strcpy(scratchpad, lineEdit5->text().toLatin1().data());
      latin1_to_ascii(scratchpad, len);
      remove_trailing_spaces(scratchpad);
      strcat(str, scratchpad);
    }

    for(i=0; i<8; i++)
    {
      strcat(str, "          ");
    }

    str[80] = 0;

    fseeko(file, 8LL, SEEK_SET);
    fprintf(file, "%s", str);

    if(has_startdate)
    {
      strncpy(str, hdr + 88, 22);
      str[22] = 0;
    }
    else
    {
      strcpy(str, "Startdate X ");
    }

    len = strlen(lineEdit6->text().toLatin1().data());  // administration code
    if(len)
    {
      strcpy(scratchpad, lineEdit6->text().toLatin1().data());
      latin1_to_ascii(scratchpad, len);
      remove_trailing_spaces(scratchpad);
      for(i=0; i<len; i++)
      {
        if(scratchpad[i] == ' ')  scratchpad[i] = '_';
      }
      if(!strlen(scratchpad))
      {
        strcpy(scratchpad, "X");
      }
      strcat(scratchpad, " ");
      strcat(str, scratchpad);
    }
    else
    {
      strcat(str, "X ");
    }

    len = strlen(lineEdit7->text().toLatin1().data());  // technician
    if(len)
    {
      strcpy(scratchpad, lineEdit7->text().toLatin1().data());
      latin1_to_ascii(scratchpad, len);
      remove_trailing_spaces(scratchpad);
      for(i=0; i<len; i++)
      {
        if(scratchpad[i] == ' ')  scratchpad[i] = '_';
      }
      if(!strlen(scratchpad))
      {
        strcpy(scratchpad, "X");
      }
      strcat(scratchpad, " ");
      strcat(str, scratchpad);
    }
    else
    {
      strcat(str, "X ");
    }

    len = strlen(lineEdit8->text().toLatin1().data());  // device
    if(len)
    {
      strcpy(scratchpad, lineEdit8->text().toLatin1().data());
      latin1_to_ascii(scratchpad, len);
      remove_trailing_spaces(scratchpad);
      for(i=0; i<len; i++)
      {
        if(scratchpad[i] == ' ')  scratchpad[i] = '_';
      }
      if(!strlen(scratchpad))
      {
        strcpy(scratchpad, "X");
      }
      strcat(scratchpad, " ");
      strcat(str, scratchpad);
    }
    else
    {
      strcat(str, "X ");
    }

    len = strlen(lineEdit9->text().toLatin1().data());  // additional info
    if(len)
    {
      strcpy(scratchpad, lineEdit9->text().toLatin1().data());
      latin1_to_ascii(scratchpad, len);
      remove_trailing_spaces(scratchpad);
      strcat(str, scratchpad);
    }

    for(i=0; i<8; i++)
    {
      strcat(str, "          ");
    }

    str[80] = 0;

    fseeko(file, 88LL, SEEK_SET);
    fprintf(file, "%s", str);
  }
  else
  {
    strcpy(scratchpad, lineEdit1->text().toLatin1().data());
    for(j=strlen(scratchpad); j<80; j++)
    {
      scratchpad[j] = ' ';
    }
    latin1_to_ascii(scratchpad, 80);
    scratchpad[80] = 0;
    fseeko(file, 8LL, SEEK_SET);
    fprintf(file, "%s", scratchpad);

    strcpy(scratchpad, lineEdit2->text().toLatin1().data());
    for(j=strlen(scratchpad); j<80; j++)
    {
      scratchpad[j] = ' ';
    }
    latin1_to_ascii(scratchpad, 80);
    scratchpad[80] = 0;
    fseeko(file, 88LL, SEEK_SET);
    fprintf(file, "%s", scratchpad);
  }

  for(i=0; i<edfsignals; i++)
  {
    if(((QLineEdit *)(signallist->cellWidget(i, 0)))->isEnabled() == FALSE)
    {
      continue;
    }

    strcpy(scratchpad, ((QLineEdit *)(signallist->cellWidget(i, 0)))->text().toLatin1().data());
    for(j=strlen(scratchpad); j<16; j++)
    {
      scratchpad[j] = ' ';
    }
    latin1_to_ascii(scratchpad, 16);
    scratchpad[16] = 0;
    fseeko(file, (long long)(256 + (i * 16)), SEEK_SET);
    fprintf(file, "%s", scratchpad);

    strcpy(scratchpad, ((QLineEdit *)(signallist->cellWidget(i, 1)))->text().toLatin1().data());
    for(j=strlen(scratchpad); j<8; j++)
    {
      scratchpad[j] = ' ';
    }
    latin1_to_ascii(scratchpad, 8);
    scratchpad[8] = 0;
    fseeko(file, (long long)(256 + (edfsignals * 96) + (i * 8)), SEEK_SET);
    fprintf(file, "%s", scratchpad);

    strcpy(scratchpad, ((QLineEdit *)(signallist->cellWidget(i, 2)))->text().toLatin1().data());
    for(j=strlen(scratchpad); j<80; j++)
    {
      scratchpad[j] = ' ';
    }
    latin1_to_ascii(scratchpad, 80);
    scratchpad[80] = 0;
    fseeko(file, (long long)(256 + (edfsignals * 136) + (i * 80)), SEEK_SET);
    fprintf(file, "%s", scratchpad);

    strcpy(scratchpad, ((QLineEdit *)(signallist->cellWidget(i, 3)))->text().toLatin1().data());
    for(j=strlen(scratchpad); j<80; j++)
    {
      scratchpad[j] = ' ';
    }
    latin1_to_ascii(scratchpad, 80);
    scratchpad[80] = 0;
    fseeko(file, (long long)(256 + (edfsignals * 16) + (i * 80)), SEEK_SET);
    fprintf(file, "%s", scratchpad);
  }

  fflush(file);

  read_header();
}


void UI_headerEditorWindow::calculate_chars_left_name(const QString &)
{
  int n = 61;

  int len;

  int cursorposition[3];

  char str[128];


  cursorposition[0] = lineEdit3->cursorPosition();
  cursorposition[1] = lineEdit4->cursorPosition();
  cursorposition[2] = lineEdit5->cursorPosition();

  len = strlen(lineEdit3->text().toLatin1().data());
  if(len>1)
  {
    n -= (len - 1);
  }

  len = strlen(lineEdit4->text().toLatin1().data());
  if(len>1)
  {
    n -= (len - 1);
  }

  len = strlen(lineEdit5->text().toLatin1().data());
  if(len>1)
  {
    n -= (len - 1);
  }

  if(n<1)
  {
    lineEdit3->setMaxLength(strlen(lineEdit3->text().toLatin1().data()));
    lineEdit4->setMaxLength(strlen(lineEdit4->text().toLatin1().data()));
    lineEdit5->setMaxLength(strlen(lineEdit5->text().toLatin1().data()));
  }
  else
  {
    lineEdit3->setMaxLength(80);
    lineEdit4->setMaxLength(80);
    lineEdit5->setMaxLength(80);
  }

  lineEdit3->setCursorPosition(cursorposition[0]);
  lineEdit4->setCursorPosition(cursorposition[1]);
  lineEdit5->setCursorPosition(cursorposition[2]);

  sprintf(str, "Characters left:  %i", n);

  charsleft1Label->setText(str);
}


void UI_headerEditorWindow::calculate_chars_left_recording(const QString &)
{
  int n = 42;

  int len;

  int cursorposition[4];

  char str[128];


  cursorposition[0] = lineEdit6->cursorPosition();
  cursorposition[1] = lineEdit7->cursorPosition();
  cursorposition[2] = lineEdit8->cursorPosition();
  cursorposition[3] = lineEdit9->cursorPosition();

  len = strlen(lineEdit6->text().toLatin1().data());
  if(len>1)
  {
    n -= (len - 1);
  }

  len = strlen(lineEdit7->text().toLatin1().data());
  if(len>1)
  {
    n -= (len - 1);
  }

  len = strlen(lineEdit8->text().toLatin1().data());
  if(len>1)
  {
    n -= (len - 1);
  }

  len = strlen(lineEdit9->text().toLatin1().data());
  if(len>1)
  {
    n -= (len - 1);
  }

  if(n<1)
  {
    lineEdit6->setMaxLength(strlen(lineEdit6->text().toLatin1().data()));
    lineEdit7->setMaxLength(strlen(lineEdit7->text().toLatin1().data()));
    lineEdit8->setMaxLength(strlen(lineEdit8->text().toLatin1().data()));
    lineEdit9->setMaxLength(strlen(lineEdit9->text().toLatin1().data()));
  }
  else
  {
    lineEdit6->setMaxLength(80);
    lineEdit7->setMaxLength(80);
    lineEdit8->setMaxLength(80);
    lineEdit9->setMaxLength(80);
  }

  lineEdit6->setCursorPosition(cursorposition[0]);
  lineEdit7->setCursorPosition(cursorposition[1]);
  lineEdit8->setCursorPosition(cursorposition[2]);
  lineEdit9->setCursorPosition(cursorposition[3]);

  sprintf(str, "Characters left:  %i", n);

  charsleft2Label->setText(str);
}




















