#ifndef _ECS_VEC_INT_TRI_H_
#define _ECS_VEC_INT_TRI_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associées à la structure `ecs_vec_int_t' décrivant un vecteur indéxe entier
 *   et réalisant des fonctionnalités de tri
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilité
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_vec_int.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui trie un vecteur d'entiers en renvoyant :
 *  - le vecteur trié ;
 *  - le vecteur de renumérotation qui permet de passer
 *     du vecteur trié au vecteur initial
 *----------------------------------------------------------------------------*/

void ecs_vec_int__trie_et_renvoie
(
 const ecs_vec_int_t *const this_vec       , /* --> Entiers à trier           */
       ecs_vec_int_t *const vec_trie       , /* <-- Entiers triés             */
       ecs_tab_int_t *const vect_renum_pos   /* <-> Renumérotation positions  */
) ;


#endif /* _ECS_VEC_INT_TRI_H_ */
