#ifndef         ECORE_SDL_KEYS_H__
# define        ECORE_SDL_KEYS_H__

struct _ecore_sdl_keys_s
{
   int          code;
   const char*  name;
   const char*  compose;
};

static const struct _ecore_sdl_keys_s  keystable[] =
{
   { SDLK_UNKNOWN,      "0x00",         "" },
   { SDLK_FIRST,        "First",        "First" },
   { SDLK_BACKSPACE,    "BackSpace",    "\010" },
   { SDLK_TAB,          "Tab",          "\011" },
   { SDLK_CLEAR,        "Clear",        "Clear" },
   { SDLK_RETURN,       "Return",       "\015" },
   { SDLK_PAUSE,        "Pause",        "Pause" },
   { SDLK_ESCAPE,       "Escape",       "\033" },
   { SDLK_SPACE,        "space",        " " },
   { SDLK_EXCLAIM,      "exclam",       "!" },
   { SDLK_QUOTEDBL,     "quotedbl",     "\"" },
   { SDLK_HASH,         "numbersign",   "#" },
   { SDLK_DOLLAR,       "dollar",       "$" },
   { SDLK_AMPERSAND,    "ampersand",    "&" },
   { SDLK_QUOTE,        "apostrophe",   "'" },
   { SDLK_LEFTPAREN,    "parenleft",    "(" },
   { SDLK_RIGHTPAREN,   "parenright",   ")" },
   { SDLK_ASTERISK,     "asterik",      "*" },
   { SDLK_PLUS,         "plus",         "+" },
   { SDLK_COMMA,        "comma",        "," },
   { SDLK_MINUS,        "minus",        "-" },
   { SDLK_PERIOD,       "period",       "." },
   { SDLK_SLASH,        "slash",        "/" },
   { SDLK_0,            "0",            "0" },
   { SDLK_1,            "1",            "1" },
   { SDLK_2,            "2",            "2" },
   { SDLK_3,            "3",            "3" },
   { SDLK_4,            "4",            "4" },
   { SDLK_5,            "5",            "5" },
   { SDLK_6,            "6",            "6" },
   { SDLK_7,            "7",            "7" },
   { SDLK_8,            "8",            "8" },
   { SDLK_9,            "9",            "9" },
   { SDLK_COLON,        "colon",        ":" },
   { SDLK_SEMICOLON,    "semicolon",    ";" },
   { SDLK_LESS,         "less",         "<" },
   { SDLK_EQUALS,       "equal",        "=" },
   { SDLK_GREATER,      "greater",      ">" },
   { SDLK_QUESTION,     "question",     "?" },
   { SDLK_AT,           "at",           "@" },

   /* Skip uppercase letters */
   { SDLK_LEFTBRACKET,  "bracketleft",  "[" },
   { SDLK_BACKSLASH,    "backslash",    "\\" },
   { SDLK_RIGHTBRACKET, "bracketright", "]" },
   { SDLK_CARET,        "asciicircumm", "^" },
   { SDLK_UNDERSCORE,   "underscore",   "_" },
   { SDLK_BACKQUOTE,    "asciitilde",   "`" },
   { SDLK_a,            "a",            "a" },
   { SDLK_b,            "b",            "b" },
   { SDLK_c,            "c",            "c" },
   { SDLK_d,            "d",            "d" },
   { SDLK_e,            "e",            "e" },
   { SDLK_f,            "f",            "f" },
   { SDLK_g,            "g",            "g" },
   { SDLK_h,            "h",            "h" },
   { SDLK_i,            "i",            "i" },
   { SDLK_j,            "j",            "j" },
   { SDLK_k,            "k",            "k" },
   { SDLK_l,            "l",            "l" },
   { SDLK_m,            "m",            "m" },
   { SDLK_n,            "n",            "n" },
   { SDLK_o,            "o",            "o" },
   { SDLK_p,            "p",            "p" },
   { SDLK_q,            "q",            "q" },
   { SDLK_r,            "r",            "r" },
   { SDLK_s,            "s",            "s" },
   { SDLK_t,            "t",            "t" },
   { SDLK_u,            "u",            "u" },
   { SDLK_v,            "v",            "v" },
   { SDLK_w,            "w",            "w" },
   { SDLK_x,            "x",            "x" },
   { SDLK_y,            "y",            "y" },
   { SDLK_z,            "z",            "z" },
   { SDLK_DELETE,       "Delete",       "\177" },
   /* End of ASCII mapped keysyms */

   /* International keyboard syms */
   { SDLK_WORLD_0,      "w0",           "" }, /* 0xA0 */
   { SDLK_WORLD_1,      "w1",           "" },
   { SDLK_WORLD_2,      "w2",           "" },
   { SDLK_WORLD_3,      "w3",           "" },
   { SDLK_WORLD_4,      "w4",           "" },
   { SDLK_WORLD_5,      "w5",           "" },
   { SDLK_WORLD_6,      "w6",           "" },
   { SDLK_WORLD_7,      "w7",           "" },
   { SDLK_WORLD_8,      "w8",           "" },
   { SDLK_WORLD_9,      "w9",           "" },
   { SDLK_WORLD_10,     "w10",          "" },
   { SDLK_WORLD_11,     "w11",          "" },
   { SDLK_WORLD_12,     "w12",          "" },
   { SDLK_WORLD_13,     "w13",          "" },
   { SDLK_WORLD_14,     "w14",          "" },
   { SDLK_WORLD_15,     "w15",          "" },
   { SDLK_WORLD_16,     "w16",          "" },
   { SDLK_WORLD_17,     "w17",          "" },
   { SDLK_WORLD_18,     "w18",          "" },
   { SDLK_WORLD_19,     "w19",          "" },
   { SDLK_WORLD_20,     "w20",          "" },
   { SDLK_WORLD_21,     "w21",          "" },
   { SDLK_WORLD_22,     "w22",          "" },
   { SDLK_WORLD_23,     "w23",          "" },
   { SDLK_WORLD_24,     "w24",          "" },
   { SDLK_WORLD_25,     "w25",          "" },
   { SDLK_WORLD_26,     "w26",          "" },
   { SDLK_WORLD_27,     "w27",          "" },
   { SDLK_WORLD_28,     "w28",          "" },
   { SDLK_WORLD_29,     "w29",          "" },
   { SDLK_WORLD_30,     "w30",          "" },
   { SDLK_WORLD_31,     "w31",          "" },
   { SDLK_WORLD_32,     "w32",          "" },
   { SDLK_WORLD_33,     "w33",          "" },
   { SDLK_WORLD_34,     "w34",          "" },
   { SDLK_WORLD_35,     "w35",          "" },
   { SDLK_WORLD_36,     "w36",          "" },
   { SDLK_WORLD_37,     "w37",          "" },
   { SDLK_WORLD_38,     "w38",          "" },
   { SDLK_WORLD_39,     "w39",          "" },
   { SDLK_WORLD_40,     "w40",          "" },
   { SDLK_WORLD_41,     "w41",          "" },
   { SDLK_WORLD_42,     "w42",          "" },
   { SDLK_WORLD_43,     "w43",          "" },
   { SDLK_WORLD_44,     "w44",          "" },
   { SDLK_WORLD_45,     "w45",          "" },
   { SDLK_WORLD_46,     "w46",          "" },
   { SDLK_WORLD_47,     "w47",          "" },
   { SDLK_WORLD_48,     "w48",          "" },
   { SDLK_WORLD_49,     "w49",          "" },
   { SDLK_WORLD_50,     "w50",          "" },
   { SDLK_WORLD_51,     "w51",          "" },
   { SDLK_WORLD_52,     "w52",          "" },
   { SDLK_WORLD_53,     "w53",          "" },
   { SDLK_WORLD_54,     "w54",          "" },
   { SDLK_WORLD_55,     "w55",          "" },
   { SDLK_WORLD_56,     "w56",          "" },
   { SDLK_WORLD_57,     "w57",          "" },
   { SDLK_WORLD_58,     "w58",          "" },
   { SDLK_WORLD_59,     "w59",          "" },
   { SDLK_WORLD_60,     "w60",          "" },
   { SDLK_WORLD_61,     "w61",          "" },
   { SDLK_WORLD_62,     "w62",          "" },
   { SDLK_WORLD_63,     "w63",          "" },
   { SDLK_WORLD_64,     "w64",          "" },
   { SDLK_WORLD_65,     "w65",          "" },
   { SDLK_WORLD_66,     "w66",          "" },
   { SDLK_WORLD_67,     "w67",          "" },
   { SDLK_WORLD_68,     "w68",          "" },
   { SDLK_WORLD_69,     "w69",          "" },
   { SDLK_WORLD_70,     "w70",          "" },
   { SDLK_WORLD_71,     "w71",          "" },
   { SDLK_WORLD_72,     "w72",          "" },
   { SDLK_WORLD_73,     "w73",          "" },
   { SDLK_WORLD_74,     "w74",          "" },
   { SDLK_WORLD_75,     "w75",          "" },
   { SDLK_WORLD_76,     "w76",          "" },
   { SDLK_WORLD_77,     "w77",          "" },
   { SDLK_WORLD_78,     "w78",          "" },
   { SDLK_WORLD_79,     "w79",          "" },
   { SDLK_WORLD_80,     "w80",          "" },
   { SDLK_WORLD_81,     "w81",          "" },
   { SDLK_WORLD_82,     "w82",          "" },
   { SDLK_WORLD_83,     "w83",          "" },
   { SDLK_WORLD_84,     "w84",          "" },
   { SDLK_WORLD_85,     "w85",          "" },
   { SDLK_WORLD_86,     "w86",          "" },
   { SDLK_WORLD_87,     "w87",          "" },
   { SDLK_WORLD_88,     "w88",          "" },
   { SDLK_WORLD_89,     "w89",          "" },
   { SDLK_WORLD_90,     "w90",          "" },
   { SDLK_WORLD_91,     "w91",          "" },
   { SDLK_WORLD_92,     "w92",          "" },
   { SDLK_WORLD_93,     "w93",          "" },
   { SDLK_WORLD_94,     "w94",          "" },
   { SDLK_WORLD_95,     "w95",          "" },

   /* Numeric keypad */
   { SDLK_KP0,          "KP0",          "0" },
   { SDLK_KP1,          "KP1",          "1" },
   { SDLK_KP2,          "KP2",          "2" },
   { SDLK_KP3,          "KP3",          "3" },
   { SDLK_KP4,          "KP4",          "4" },
   { SDLK_KP5,          "KP5",          "5" },
   { SDLK_KP6,          "KP6",          "6" },
   { SDLK_KP7,          "KP7",          "7" },
   { SDLK_KP8,          "KP8",          "8" },
   { SDLK_KP9,          "KP9",          "9" },
   { SDLK_KP_PERIOD,    "period",       "." },
   { SDLK_KP_DIVIDE,    "KP_Divide",    "/" },
   { SDLK_KP_MULTIPLY,  "KP_Multiply",  "*" },
   { SDLK_KP_MINUS,     "KP_Minus",     "-" },
   { SDLK_KP_PLUS,      "KP_Plus",      "+" },
   { SDLK_KP_ENTER,     "KP_Enter",     "\015" },
   { SDLK_KP_EQUALS,    "KP_Equals",    "=" },

   /* Arrows + Home/End pad */
   { SDLK_UP,           "Up",           "Up" },
   { SDLK_DOWN,         "Down",         "Down" },
   { SDLK_RIGHT,        "Right",        "Right" },
   { SDLK_LEFT,         "Left",         "Left" },
   { SDLK_INSERT,       "Insert",       "Insert" },
   { SDLK_HOME,         "Home",         "Home" },
   { SDLK_END,          "End",          "End" },
   { SDLK_PAGEUP,       "Page_Up",      "Page_Up" },
   { SDLK_PAGEDOWN,     "Page_Down",    "Page_Down" },

   /* Function keys */
   { SDLK_F1,           "F1",           "F1" },
   { SDLK_F2,           "F2",           "F2" },
   { SDLK_F3,           "F3",           "F3" },
   { SDLK_F4,           "F4",           "F4" },
   { SDLK_F5,           "F5",           "F5" },
   { SDLK_F6,           "F6",           "F6" },
   { SDLK_F7,           "F7",           "F7" },
   { SDLK_F8,           "F8",           "F8" },
   { SDLK_F9,           "F9",           "F9" },
   { SDLK_F10,          "F10",          "F10" },
   { SDLK_F11,          "F11",          "F11" },
   { SDLK_F12,          "F12",          "F12" },
   { SDLK_F13,          "F13",          "F13" },
   { SDLK_F14,          "F14",          "F14" },
   { SDLK_F15,          "F15",          "F15" },

   /* Key state modifier keys */
   { SDLK_NUMLOCK,      "Num_Lock",     "Num_Lock" },
   { SDLK_CAPSLOCK,     "Caps_Lock",    "Caps_Lock" },
   { SDLK_SCROLLOCK,    "Scroll_Lock",  "Scroll_Lock" },
   { SDLK_RSHIFT,       "Shift_R",      "Shift_R" },
   { SDLK_LSHIFT,       "Shift_L",      "Shift_L" },
   { SDLK_RCTRL,        "Control_R",    "Control_R" },
   { SDLK_LCTRL,        "Control_L",    "Control_L" },
   { SDLK_RALT,         "Alt_R",        "Alt_R" },
   { SDLK_LALT,         "Alt_L",        "Alt_L" },
   { SDLK_RMETA,        "Meta_R",       "Meta_R" },
   { SDLK_LMETA,        "Meta_L",       "Meta_L" },
   { SDLK_LSUPER,       "Super_L",      "Super_L" },   /* Left "Windows" key */
   { SDLK_RSUPER,       "Super_R",      "Super_R" },   /* Right "Windows" key */
   { SDLK_MODE,         "Mode",         "Mode" },   /* "Alt Gr" key */
   { SDLK_COMPOSE,      "Compose",      "Compose" },   /* Multi-key compose key */

   /* Miscellaneous function keys */
   { SDLK_HELP,         "Help",         "Help" },
   { SDLK_PRINT,        "Print",        "Print" },
   { SDLK_SYSREQ,       "SysReq",       "SysReq" },
   { SDLK_BREAK,        "Break",        "Break" },
   { SDLK_MENU,         "Menu",         "Menu" },
   { SDLK_POWER,        "Power",        "Power" },   /* Power Macintosh power key */
   { SDLK_EURO,         "Euro",         "\200" },   /* Some european keyboards */
   { SDLK_UNDO,         "Undo",         "Undo" }    /* Atari keyboard has Undo */
};

#endif  /* ECORE_SDL_KEYS_H__ */
