# Ear Candy - Pulseaduio sound managment tool
# Copyright (C) 2008 Jason Taylor
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import re
import time
import datetime
from xml.dom.minidom import *

class Client():
    def __init__(self, core, name, pid=0):
        self.core = core

        self.name = name
        self.description = self.clean_client_name(name)
        self.pid = pid
        self.role = "" # music | video | phone
        self.icon = None

        self.volume_max = 100
        self.volume_min = 0
        self.volume_target = 100
        self.volume_step = 2   

        self.rule_re_window_title = re.compile("")
        self.rule_re_command = re.compile("")
        self.rule_re_application = re.compile("")
        
        self.apply_volume_meter_hack = True
        self.fade_volume = True
        self.prefer_sink = ""


        self.dbus_name = ""
        self.__pause_status = 0       
        self.application = None
        self.sinks = {}
        self.generate_rules()

        self.__status = False

        self.icon_name = None

        self.iter = None
        self.gtk = None

    def clean_client_name(self, name):
        name = name.strip()
        alsa_plugin = "ALSA plug-in ["
        if name.startswith(alsa_plugin):
            self.apply_volume_meter_hack = True
            name = name[len(alsa_plugin): -1]
        return name

    def get_sink(self):
        for sink_input in self.sinks.values():
            return sink_input.sink
        return -1

    def get_volume(self):
        v = 0
        count = 0
        for sink in self.sinks.values():
            v = v + sink.volume_meter_level
            count = count + 1
        if count > 0: return v / count
        return v

    def get_volume_meter(self):
        v = 0
        count = 0
        for sink in self.sinks.values():
            v = v + sink.volume_meter
            count = count + 1
        if count > 0: return v / count
        return v

    def is_active(self):
        for sink in self.sinks.values():
            if sink.is_active():
                return True
        return False



    def has_rule(self):
        return self.rule_re_command.pattern or self.rule_re_window_title.pattern or self.rule_re_application.pattern

    def generate_rules(self, app=None):
        if not app:
            app = self.clean_client_name(self.name).lower()
        else:
            app = app.lower()

        self.rule_re_application = re.compile(app, re.IGNORECASE)
        self.rule_re_command = re.compile(".*\/" + app , re.IGNORECASE)

    def test_focus_window(self, pid, title, command, app):

        # This should work by matching the clint pid to the window pid works 95% of the time
        # It will fail for things like gstreamer preview and nautilus that have no process link
        # until thats fixed at a lower level we have our trusty regular expressions
        if pid and self.pid and pid == self.pid:
            return True

        # Fall back rules if pid matching fails
        if  (self.rule_re_window_title.pattern and self.rule_re_window_title.match( title )):
            self.has_focus = True
            #print "Match 1",self.rule_re_window_title.pattern, title
            return True
        elif(self.rule_re_command.pattern and self.rule_re_command.match( command )):
            self.has_focus = True
            #print "Match 2",self.rule_re_command.pattern, command
            return True
        elif(self.rule_re_application.pattern and self.rule_re_application.match( app )):
            self.has_focus = True
            #print "Match 3",self.rule_re_application.pattern, app
            return True
        elif(self.rule_re_application.pattern and self.rule_re_application.match( command )):
            self.has_focus = True
            #print "Match 4",self.rule_re_application.pattern, command
            return True
        return False

    def __fade_in(self):
        self.volume_target = self.volume_max

    def __fade_out(self):
        if self.volume_min == -1:
            self.volume_target = self.core.mute_level
        else:
            self.volume_target = self.volume_min

    def __fade_mute(self):

        if self.volume_min == -1:
            self.volume_target = self.core.mute_level
        else:
            self.volume_target = self.volume_min

        # if we goto 0 than our volume meter will never register a value
        if self.volume_target < self.volume_step:
            self.volume_target = self.volume_step
    
    def set_status(self, value):
        if value or self.role == "default":
            self.__fade_in()
            #if self.__pause_status > 0:
            #    for plugin in self.plugins:
            #        if plugin.enabled and not plugin.is_playing():
            #            if plugin.set_pause(False): 
            #                self.__pause_status = 0
        else:
            self.__fade_mute()
            #if self.is_active() and self.__pause_status == 0:                 
            #    self.__pause_status = 1
        self.__status = value

    def get_status(self):
        for sink in self.sinks.values():
            if sink.get_status():
                return True
        return False


    # called by sink, check if all sinks are at correct volume
    def check_volume(self):
        result = True
        for sink in self.sinks.values():
            result = result and sink.volume_check

        if result and self.__pause_status == 1:
           #for plugin in self.plugins:
           #     if plugin.enabled and plugin.is_playing():
           #         plugin.set_pause(True)
           self.__pause_status = 2

    def to_xml(self, el):

        # Set attributes to user element
        el.setAttribute("name", self.name)
        el.setAttribute("description", str(self.description))
        el.setAttribute("volume_max", str(self.volume_max))
        el.setAttribute("volume_min", str(self.volume_min))
        el.setAttribute("rule_re_window_title",self.rule_re_window_title.pattern)
        el.setAttribute("rule_re_command",self.rule_re_command.pattern)
        el.setAttribute("rule_re_application",self.rule_re_application.pattern)
        el.setAttribute("role",self.role)
        el.setAttribute("icon_name", str(self.icon_name))
        el.setAttribute("apply_volume_meter_hack", str(self.apply_volume_meter_hack))
        el.setAttribute("fade_volume", str(self.fade_volume))
        el.setAttribute("prefer_sink", self.prefer_sink)

        if self.role == "default":
            self.role = "event"

    def from_xml(self, el):
        if(el.hasAttribute("name")) :                   self.name = el.getAttribute("name")
        if(el.hasAttribute("description")) :            self.description = el.getAttribute("description")
        if(el.hasAttribute("icon_name")) :              self.icon_name = el.getAttribute("icon_name")
        if(el.hasAttribute("volume_max")) :         self.volume_max = int(el.getAttribute("volume_max"))
        if(el.hasAttribute("volume_min")) :         self.volume_min = int(el.getAttribute("volume_min"))
        if(el.hasAttribute("rule_re_window_title")) :   self.rule_re_window_title = re.compile(el.getAttribute("rule_re_window_title"), re.IGNORECASE)
        if(el.hasAttribute("rule_re_command")) :        self.rule_re_command = re.compile(el.getAttribute("rule_re_command"), re.IGNORECASE)
        if(el.hasAttribute("rule_re_application")) :    self.rule_re_application = re.compile(el.getAttribute("rule_re_application"), re.IGNORECASE)
        if(el.hasAttribute("role")) :               self.role = el.getAttribute("role")
        if(el.hasAttribute("window_position_fade")) :   self.window_position_fade = el.getAttribute("window_position_fade") == "True"
        if(el.hasAttribute("apply_volume_meter_hack")): self.apply_volume_meter_hack = el.getAttribute("apply_volume_meter_hack") == "True"
        if(el.hasAttribute("fade_volume")):             self.fade_volume = el.getAttribute("fade_volume") == "True"
        if(el.hasAttribute("prefer_sink")):                  self.prefer_sink = el.getAttribute("prefer_sink")


