/*1:*/
#line 6 "./vector_function.cweb"


#include "vector_function.h"

#include <dynlapack.h> 

#include <cmath> 

#include <cstring> 
#include <algorithm> 

/*2:*/
#line 33 "./vector_function.cweb"

ParameterSignal::ParameterSignal(int n)
:data(new bool[n]),num(n)
{
for(int i= 0;i<num;i++)
data[i]= true;
}

/*:2*/
#line 17 "./vector_function.cweb"
;
/*3:*/
#line 42 "./vector_function.cweb"

ParameterSignal::ParameterSignal(const ParameterSignal&sig)
:data(new bool[sig.num]),num(sig.num)
{
memcpy(data,sig.data,num);
}

/*:3*/
#line 18 "./vector_function.cweb"
;
/*4:*/
#line 52 "./vector_function.cweb"

void ParameterSignal::signalAfter(int l)
{
for(int i= 0;i<std::min(l,num);i++)
data[i]= false;
for(int i= l;i<num;i++)
data[i]= true;
}

/*:4*/
#line 19 "./vector_function.cweb"
;
/*5:*/
#line 62 "./vector_function.cweb"

VectorFunctionSet::VectorFunctionSet(const VectorFunction&f,int n)
:funcs(n),first_shallow(false)
{
for(int i= 0;i<n;i++)
funcs[i]= f.clone();
}

/*:5*/
#line 20 "./vector_function.cweb"
;
/*6:*/
#line 73 "./vector_function.cweb"

VectorFunctionSet::VectorFunctionSet(VectorFunction&f,int n)
:funcs(n),first_shallow(true)
{
if(n> 0)
funcs[0]= &f;
for(int i= 1;i<n;i++)
funcs[i]= f.clone();
}

/*:6*/
#line 21 "./vector_function.cweb"
;
/*7:*/
#line 86 "./vector_function.cweb"

VectorFunctionSet::~VectorFunctionSet()
{
unsigned int start= first_shallow?1:0;
for(unsigned int i= start;i<funcs.size();i++)
delete funcs[i];
}

/*:7*/
#line 22 "./vector_function.cweb"
;
/*8:*/
#line 98 "./vector_function.cweb"

GaussConverterFunction::GaussConverterFunction(VectorFunction&f,const GeneralMatrix&vcov)
:VectorFunction(f),func(&f),delete_flag(false),A(vcov.numRows(),vcov.numRows()),
multiplier(calcMultiplier())
{

calcCholeskyFactor(vcov);
}

/*:8*/
#line 23 "./vector_function.cweb"
;
/*9:*/
#line 110 "./vector_function.cweb"

GaussConverterFunction::GaussConverterFunction(VectorFunction*f,const GeneralMatrix&vcov)
:VectorFunction(*f),func(f),delete_flag(true),A(vcov.numRows(),vcov.numRows()),
multiplier(calcMultiplier())
{

calcCholeskyFactor(vcov);
}


/*:9*/
#line 24 "./vector_function.cweb"
;
/*10:*/
#line 121 "./vector_function.cweb"

GaussConverterFunction::GaussConverterFunction(const GaussConverterFunction&f)
:VectorFunction(f),func(f.func->clone()),delete_flag(true),A(f.A),
multiplier(f.multiplier)
{
}

/*:10*/
#line 25 "./vector_function.cweb"
;
/*11:*/
#line 135 "./vector_function.cweb"

void GaussConverterFunction::eval(const Vector&point,const ParameterSignal&sig,Vector&out)
{
ParameterSignal s(sig);
int i= 0;
while(i<indim()&&!sig[i])
i++;
s.signalAfter(i);

Vector x(indim());
x.zeros();
A.multaVec(x,point);
x.mult(sqrt(2.0));

func->eval(x,s,out);

out.mult(multiplier);
}

/*:11*/
#line 26 "./vector_function.cweb"
;
/*12:*/
#line 155 "./vector_function.cweb"

double GaussConverterFunction::calcMultiplier()const
{
#ifndef _MSC_VER
return sqrt(pow(M_PI,-1*indim()));
#else
return sqrt(pow(3.14159265358979323846,-1*indim()));
#endif
}

/*:12*/
#line 27 "./vector_function.cweb"
;
/*13:*/
#line 166 "./vector_function.cweb"

void GaussConverterFunction::calcCholeskyFactor(const GeneralMatrix&vcov)
{
A= vcov;

lapack_int rows= A.numRows();
for(int i= 0;i<rows;i++)
for(int j= i+1;j<rows;j++)
A.get(i,j)= 0.0;

lapack_int info;
dpotrf("L",&rows,A.base(),&rows,&info);

}


/*:13*/
#line 28 "./vector_function.cweb"
;

/*:1*/
