/////////////////////////////////////////////////////////////////////////////
// Name:        ChaptersDlg.h
// Purpose:     The chapters dialog
// Author:      Alex Thuering
// Created:     19.04.2010
// RCS-ID:      $Id: ChaptersDlg.h,v 1.1 2011/04/28 21:36:21 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
#ifndef CHAPTERS_DLG_H
#define CHAPTERS_DLG_H

#include "Pgc.h"
#include "mediactrl_ffmpeg.h"
#include "Utils.h"
#include <wx/listctrl.h>

// begin wxGlade: ::dependencies
#include <wx/spinbutt.h>
// end wxGlade

// begin wxGlade: ::extracode

// end wxGlade

class ChaptersCtrl;

class ChaptersDlg: public wxDialog {
public:
    // begin wxGlade: ChaptersDlg::ids
    // end wxGlade
	
	/** Constructor */
	ChaptersDlg(wxWindow* parent, DVD* dvd, int tsi, int pgci, Vob* vob);
	
	/** Destructor */
	virtual ~ChaptersDlg();
    
    /** Displays dialog */
	virtual int ShowModal();
	
private:
    // begin wxGlade: ChaptersDlg::methods
    void set_properties();
    void do_layout();
    // end wxGlade
    
    // begin wxGlade: ChaptersDlg::attributes
    wxStaticText* m_chaptersLabel;
    ChaptersCtrl* m_chaptersCtrl;
    wxBitmapButton* m_addBt;
    wxBitmapButton* m_delBt;
    wxBitmapButton* m_propBt;
    MediaCtrlFF* m_mediaCtrl;
    wxSlider* m_slider;
    wxStaticText* m_timeLabel;
    wxTextCtrl* m_timeCtrl;
    wxSpinButton* m_timeSpinBt;
    wxStaticText* m_durLabel;
    wxStaticText* m_durText;
    wxButton* m_okBt;
    wxButton* m_cancelBt;
    // end wxGlade

    DVD* m_dvd;
    int m_tsi;
    int m_pgci;
    Vob* m_vob;
    vector<Cell*> m_cells;
    int m_selected;
    wxTimer m_unselectTimer;
    void SeekVideo(long pos, bool updateTimeCtrl = true);
    void OnUnselectTimer(wxTimerEvent& event);
	virtual void OnChapterSelect(wxListEvent &event);
    virtual void OnChapterDClick(wxListEvent &event);
	virtual void OnAddBt(wxCommandEvent &event); // wxGlade: <event_handler>
	virtual void OnDelBt(wxCommandEvent &event); // wxGlade: <event_handler>
	virtual void OnPropBt(wxCommandEvent &event); // wxGlade: <event_handler>
	virtual void OnSliderScroll(wxScrollEvent &event); // wxGlade: <event_handler>
	virtual void OnChangeTime(wxCommandEvent &event); // wxGlade: <event_handler>
	virtual void OnTimeSpin(wxSpinEvent &event); // wxGlade: <event_handler>
	virtual void OnOkBt(wxCommandEvent &event); // wxGlade: <event_handler>
	DECLARE_EVENT_TABLE();
}; // wxGlade: end class


#endif // CHAPTERS_DLG_H
