/////////////////////////////////////////////////////////////////////////////
// Name:        AudioPropDlg.h
// Purpose:     The audio properties dialog
// Author:      Alex Thuering
// Created:     23.07.2011
// RCS-ID:      $Id: AudioPropDlg.h,v 1.1 2011/08/01 20:30:08 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef AUDIO_PROP_DLG_H
#define AUDIO_PROP_DLG_H

#include <wx/wx.h>
#include <wx/image.h>
#include "DVD.h"

// begin wxGlade: ::dependencies
#include <wx/spinctrl.h>
// end wxGlade

// begin wxGlade: ::extracode

// end wxGlade

class AudioPropDlg: public wxDialog {
public:
    // begin wxGlade: AudioPropDlg::ids
    // end wxGlade
	
	/**
	 * Constructor
	 */
    AudioPropDlg(wxWindow* parent, Vob* vob, const wxString& audioFile, const wxString& langCode, int streamIdx);
    
    /** Returns selected audio format */
    AudioFormat GetAudioFormat();
    
    /** Returns selected language code */
    wxString GetLangCode();
    
private:
    // begin wxGlade: AudioPropDlg::methods
    void set_properties();
    void do_layout();
    // end wxGlade
    
    // begin wxGlade: AudioPropDlg::attributes
    wxStaticText* m_fileNameLabel;
    wxStaticText* m_fileNameText;
    wxStaticText* m_durLabel;
    wxStaticText* m_durText;
    wxStaticText* m_srcLabel;
    wxStaticText* m_srcText;
    wxStaticText* m_dstLabel;
    wxChoice* m_dstChoice;
    wxStaticText* m_langLabel;
    wxChoice* m_langChoice;
    wxStaticText* m_volumeLabel;
    wxSpinCtrl* m_volumeCtrl;
    wxButton* m_okBt;
    wxButton* m_cancelBt;
    // end wxGlade
    
    Vob* m_vob;
    wxString m_audioFile;
    wxString m_langCode;
    Stream* m_stream;
    virtual void OnOkBt(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnChangeFormat(wxCommandEvent &event); // wxGlade: <event_handler>
    
protected:
    DECLARE_EVENT_TABLE();
}; // wxGlade: end class


#endif // AUDIO_PROP_DLG_H
