#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <getopt.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <errno.h>
#include <string.h>
#include <limits.h>
#include <sys/types.h>
#include <pwd.h>
#include <sys/time.h>

#include "header.h"
#include "sql_query.h"
#include "my_strings.h"
#include "log.h"

// Those membervars need to be filled prior calling:
// headerSize;
// headerNumLines;
// headerLines[MAX_HEADER_LINE];
// headerLinesSize[MAX_HEADER_LINE];

int mini(int a,int b){
	if(b < a)	return b;
	else	return a;
}

tErr header::getHeaderFields(){
	char *p1,*p2,*p3,*p4;
	char* temp_buf;

	char* rcpt_str;
	long rcpt_str_size;

	// make a copy of the header
	m_buffer = (char*)malloc(m_headerSize);
	memcpy(m_buffer,*m_msgbuf,m_headerSize);
	for(unsigned long i=0;i<m_headerNumLines;i++){
		// separate lines into independant strings
		m_buffer[ m_headerLines[i] + m_headerLinesSize[i] - 1 ] = 0;
		// Find interesting header fields...
//		fprintf(stderr,"%ld:%s\n",i,m_buffer+m_headerLines[i]);
		if( !strncmp("From:",m_buffer+m_headerLines[i],mini(m_headerLinesSize[i],strlen("From:")))){
			m_From_feild = m_buffer+m_headerLines[i] + strlen("From:");
			temp_buf = extractMailFromString(m_From_feild);
			m_from_email = str2lower(temp_buf);
//			printf("\n|||%s|||\n", m_from_email);
			if(m_from_email == NULL) return INCONSISTENT_MESSAGE;
			m_from_user = strdup(m_from_email);
			if(m_from_user == NULL) return OUT_OF_MEM;
			m_from_domain = strstr(m_from_user,"@");
			if(m_from_domain == NULL) return INCONSISTENT_MESSAGE;
			*m_from_domain++ = 0;
		}else if( !strncmp("To:",m_buffer+m_headerLines[i],mini(m_headerLinesSize[i],strlen("To:"))) )
			m_To_feild = m_buffer+m_headerLines[i] + strlen("To:");
		else if( !strncmp("Cc:",m_buffer+m_headerLines[i],mini(m_headerLinesSize[i],strlen("Cc:"))) )
			m_Cc_feild = m_buffer+m_headerLines[i] + strlen("Cc:");
		else if( !strncmp("Bcc:",m_buffer+m_headerLines[i],mini(m_headerLinesSize[i],strlen("Bcc:"))) )
			m_Bcc_feild = m_buffer+m_headerLines[i] + strlen("Bcc:");
		else if( !strncmp("Delivered-To:",m_buffer+m_headerLines[i],mini(m_headerLinesSize[i],strlen("Delivered-To:"))) && m_DeliveredTo_feild == NULL)
			m_DeliveredTo_feild = m_buffer+m_headerLines[i] + strlen("Delivered-To:");
		else if( !strncmp("Return-Path:",m_buffer+m_headerLines[i],mini(m_headerLinesSize[i],strlen("Return-Path:"))) && m_ReturnPath_feild == NULL)
			m_ReturnPath_feild = m_buffer+m_headerLines[i] + strlen("Return-Path:");
		else if( !strncmp("Subject:",m_buffer+m_headerLines[i],mini(m_headerLinesSize[i],strlen("Subject:"))) && m_Subject_feild == NULL)
			m_Subject_feild = m_buffer+m_headerLines[i] + strlen("Subject:");
		else if( !strncmp("\tby localhost with POP3 (fetchmail-5.9.11 polling ",m_buffer+m_headerLines[i],mini(m_headerLinesSize[i],strlen("\tby localhost with POP3 (fetchmail-5.9.11 polling ")) )){
			temp_buf = strdup(m_buffer+m_headerLines[i]+strlen("\tby localhost with POP3 (fetchmail-5.9.11 polling "));
			p1 = temp_buf;
			if( (p2 = strstr(p1," account ")) == NULL)	return INCONSISTENT_MESSAGE;
			*p2 = 0;
			p3 = p2 + strlen(" account ");
			if( (p4 = strstr(p3,")")) == NULL)	return INCONSISTENT_MESSAGE;
			*p4 = 0;
			m_fetchmail_server_addr = strdup(p1);
			m_fetchmail_username = strdup(p3);
			free(temp_buf);
// 			fprintf(stderr,"[igw]login:%s/srv:%s/",m_fetchmail_username,m_fetchmail_server_addr);
		}
	}

	// Check there is at least a sender and a recipient
	if(m_From_feild==NULL ||
	(m_To_feild==NULL && m_Cc_feild==NULL && m_Bcc_feild==NULL)){
		fprintf(stderr,"[igw]Field missing in header");
		return INCONSISTENT_MESSAGE;
	}
	if(	strlen(m_From_feild) < 6 ||
		((m_To_feild!=NULL && strlen(m_To_feild) < 6) &&
		(m_Cc_feild!=NULL && strlen(m_Cc_feild) < 6) &&
		(m_Bcc_feild!=NULL && strlen(m_Bcc_feild) < 6))){

		fprintf(stderr,"[igw]Field format wrong in header");
		return INCONSISTENT_MESSAGE;
	}

	// Find all recipients
	rcpt_str_size = 0;
	if( m_To_feild != NULL)		rcpt_str_size += strlen(m_To_feild)+1;
	if( m_Cc_feild != NULL)		rcpt_str_size += strlen(m_Cc_feild)+1;
	if( m_Bcc_feild != NULL)	rcpt_str_size += strlen(m_Bcc_feild);
	rcpt_str = (char*) malloc(rcpt_str_size+1);
	strcpy(rcpt_str,"");
	if( m_To_feild != NULL){
		strcat(rcpt_str,m_To_feild);
		strcat(rcpt_str," ");
	}
	if( m_Cc_feild != NULL){
		strcat(rcpt_str,m_Cc_feild);
		strcat(rcpt_str," ");
	}
	if( m_Bcc_feild != NULL){
		strcat(rcpt_str,m_Bcc_feild);
	}
	m_rcpt = getAllEmailsFromString(rcpt_str,&m_nbr_rcpt);
	free(rcpt_str);
	return noErr;
}
