DPUT(1)
=======
:doctype: manpage


NAME
----
dput - Debian package upload tool

SYNOPSIS
--------
*dput* [-h] [-d] [-c 'FILE'] [-D] [-e 'DAYS'] [-f] [-F] [-l] [-U] [-o]
            [-P] [-s] [-u] [-v] [-V]
            ['HOST'] 'CHANGES-FILE'


DESCRIPTION
-----------

dput-ng is a Debian package upload tool which provides an easy to use interface
to Debian (like) package archive hosting facilities. It allows anyone who works
with Debian packages to upload their work to a remote service, including
Debian's ftp-master, mentors.debian.net, Launchpad or other package hosting
facilities for Debian package maintainers.

'HOST' may optionally specify a target stanza from any configured configured
profile which is selected as a upload target. If 'HOST' is omitted a default
host using the heuristic described below is selected.

The only mandatory argument is a 'CHANGES-FILE' which is interpreted as a
Debian +package.changes+ file denoting the desired package to be uploaded.

Packages being uploaded already, but not processed yet can be removed later
from the destination using *dcut*.

OPTIONS
-------

*-c, --config*=FILE::
	Configuration file to parse. This option will override all other
	configuration files.

*-d, --debug*::
	Enable debug messages. Repeat twice to increase the verbosity level.

*-D, --dinstall*::
	Ignored silently for compatibility with old-style dput command lines.
	Please use a post-upload hook or similar to reproduce this functionality.

*-e, --delayed*=DAYS::
	Upload to the delayed queue, instead of the usual incoming directory.
	This option takes an argument from 0 to 15 corresponding to the respective
	DELAYED queue.

*-F, --full-upload-log*'
	Write more verbose .upload logs. When set to, upload logs will include more
	details. This setting overrides profile defaults when provided. 

*-f, --force*::
	Force an upload, even if the upload log exists already.

*-l, --lintian*::
	Run Lintian before uploading the package. Note, this option is deprecated.
	Profile targets have the ability to properly handle invoking lintian
	before pushing it to the remote host, such as the *run_lintian* key.

*-o, --check-only*::
	Only run pre-upload checks for the package, do not actually upload. This
	is useful to help in testing new checks, or verifying the profile will
	work as expected.

*-P, --passive*::
	Force FTP passive mode when uploading the package through FTP.
	This option is deprecated - please declare this in the target profile.

*-s, --simulate*::
	Simulate the upload only. This runs all pre-upload checks, initializes
	the upload handler but does not actually push any files to the remote
	host.
	
	This argument can be repeated twice in which case also the network
	connection is set-up (for example logging in through the FTP or SFTP
	protocol) and tested for its functionality. 

parser.add_argument('-u', '--unchecked', action='store_true',

*-U, --no-upload-log*::
	Do not write a .upload log file after uploading.

*-u, --unchecked*::
	Do not check GnuPG signature. You may also set this in your profile with
	the *allow_unsigned_uploads* key.

*-v, --version*::
	Ignored silently for compatibility with old-style dput command lines.

*-V, --check-version*::
	Ignored silently for compatibility with old-style dput command lines.

*HOST*::
	Target host to upload a package. This refers to any existing upload site,
	which either can be a section in old-style *dput.cf* files, or
	alternatively any profile in a read *dput.d* directory.
	If *HOST* was not supplied, the (first) profile having the
	+default_host_main+ flag set to a non-empty string will be selected.
	If neither, 'HOST' was present, nor any profile setting the upload host,
	dput-ng scans for a profile called 'ftp-master' which will be used on a
	successful look-up.

*CHANGES-FILE*::
	A Debian +package.changes+ file

PROFILES
--------

Profiles may define upload 'HOST' names, log-in details and their required
upload methods used to upload packages. Moreover, profiles define checks which
are running before and after uploading. Their format is described in *dput(5)*.

Additionally, *dput* reads old-style configuration files from INI style
configuration files. This format is deprecated for use in dput-ng and described
in *dput.cf(5)*. In particular this configuration file format does not support
all configurable settings which are specific to dput-ng. 

It is possible to run *dput* with any combination of new-style and old-style
configuration files. When both types of files are present,  

EXIT STATUS
-----------
*0*::
	Success

*1*::
	A runtime check returned an error

*2*::
	An internal error was detected, for example while loading configuration
	files

*3*::
	An upload error was detected, for example a permission or authentication
	problem while uploading files


BUGS
----

Report bugs to <http://bugs.debian.org/cgi-bin/pkgreport.cgi?pkg=dput-ng>

EXAMPLES
--------

  $ dput ppa:paultag/fluxbox fluxbox_1.3.2-4~ppa1_source.changes

  $ dput ftp-master fbautostart_2.718281828-1_amd64.changes

  $ dput dput-ng_0.9.5_amd64.changes

  $ dput -d -d localhost node-jslint_0.1.8-1~wicked1_amd64.changes

AUTHOR
------
dput-ng was originally written by `Arno Töll <arno(a)debian.org>` and `Paul
Richard I by the Grace of God of the United Kingdom of Debian and Ubuntu and
of his other realms and territories King Head of the Fluxbox Window Manager
Defender of the Faith Tagliamonte <paultag(a)debian.org>`.


RESOURCES
---------

*dput(5)*, *dput.cf(5)*, *dcut(1)*, *dirt(1)*

COPYING
-------
Copyright (C) 2012 dput-ng authors. Free use of this software is
granted under the terms of the GNU General Public License (GPL) Version 2 or
later.

