from re import compile, IGNORECASE, MULTILINE

from dosage.helpers import BasicScraper, PHPScraper, indirectStarter


class FalconTwin(BasicScraper):
    latestUrl = 'http://www.falcontwin.com/'
    imageUrl = 'http://www.falcontwin.com/index.html?strip=%s'
    imageSearch = compile(r'"(strips/.+?)"')
    prevSearch = compile(r'"prev"><a href="(index.+?)"')
    help = 'Index format: nnn'


class FauxPas(BasicScraper):
    latestUrl = 'http://www.ozfoxes.net/cgi/pl-fp1.cgi'
    imageUrl = 'http://www.ozfoxes.net/cgi/pl-fp1.cgi?%s'
    imageSearch = compile(r'<img .*src="(.*fp/fp.*(png|jpg|gif))"')
    prevSearch = compile(r'<a href="(pl-fp1\.cgi\?\d+)">Previous Strip')
    help = 'Index format: nnn'


class FightCastOrEvade(BasicScraper):
    latestUrl = 'http://www.fightcastorevade.net/'
    imageUrl = 'http://www.fightcastorevade.net/d/%s'
    imageSearch = compile(r'"(.+?/comics/.+?)"')
    prevSearch = compile(r'"(.+?/d/.+?)".+?previous')
    help = 'Index format: yyyymmdd.html'


class FilibusterCartoons(BasicScraper):
    latestUrl = 'http://www.filibustercartoons.com/'
    imageUrl = 'http://www.filibustercartoons.com/archive?id=%s'
    imageSearch = compile(r'<img src="(comics/\d{8}\..+?)"')
    prevSearch = compile(r'<a href="(archive.php\?id=\d{8})".+?\'images/comic_nav_prev_2.gif\'')
    help = 'Index format: n (unpadded)'


class FlakyPastry(BasicScraper):
    latestUrl = 'http://flakypastry.runningwithpencils.com/index.php'
    imageUrl = 'http://flakypastry.runningwithpencils.com/comic.php\?strip_id=%s'
    imageSearch = compile(r'<img src="(comics/.+?)"')
    prevSearch = compile(r'<a href="(.+?)".+?btn_back')
    help = 'Index format: nnnn'


class Flipside(BasicScraper):
    latestUrl = 'http://www.flipsidecomics.com/comic.php'
    imageUrl = 'http://www.flipsidecomics.com/comic.php?i=%s'
    imageSearch = compile(r'<IMG SRC="(comic/.+?)"')
    prevSearch = compile(r'<A HREF="(comic.php\?i=\d+?)">&lt')
    help = 'Index format: nnnn'


class FragileGravity(BasicScraper):
    latestUrl = 'http://www.fragilegravity.com/'
    imageUrl = 'http://www.fragilegravity.com/core.php?archive=%s'
    imageSearch = compile(r'<img src="(strips/\d{8}\..+?)"')
    prevSearch = compile(r'<a href="(core.php\?archive=\d{8})"\nonmouseover="window.status=\'Previous Strip.+?\'; return true"')
    help = 'Index format: yyyymmdd'


class Freefall(BasicScraper):
    latestUrl = 'http://freefall.purrsia.com/default.htm'
    imageUrl = 'http://freefall.purrsia.com/ff1100/fv%s.htm'
    imageSearch = compile(r'<img src="(/ff\d{3}\d?/fv\d{5}\..+?)"')
    prevSearch = compile(r'<a href="(/ff\d{3}\d?/fv\d{5}\.htm)">Previous')
    help = 'Index format: nnnnn'


class Frump(PHPScraper):
    basePath = 'http://thm.askee.net/comic/'
    prevSearch = compile(r'<a href="(http://thm\.askee\.net/comic/daily\.php\?date=\d{6})">Previous', IGNORECASE)


class FantasyRealms(BasicScraper):
    # This module may not get the latest comic, since the front page references to
    # the first page of the last update. If an update consists of multiple pages,
    # only the first one is fetched, the others are fetched on the next
    # update...

    imageUrl = 'http://www.fantasyrealmsonline.com/manga/%s.html'
    imageSearch = compile(r'<div align="center"><a href="[^"]+\.html"><img src="(\w+\.jpg)"')
    prevSearch = compile(r'<a href="([^"]+\.html)"><img src="\.\./\.\./images/nav-back')
    help = 'Index format: ii/pp (issue/page)'
    starter = indirectStarter('http://www.fantasyrealmsonline.com/',
                              compile(r'<a href = "(manga/\d+/\w+\.html)"><img src="latest\.jpg"'))


class FullFrontalNerdity(BasicScraper):
    latestUrl = 'http://nodwick.humor.gamespy.com/ffn/index.php'
    imageUrl = None
    imageSearch = compile(r'<img src="(http://nodwick.humor.gamespy.com/ffn/strips/[^"]*)"', IGNORECASE)
    prevSearch = compile(r'<a href="(index.php\?date=[0-9-]*)"><img src="back.jpg"', IGNORECASE)


class Fallen(BasicScraper):
    imageUrl = 'http://www.fallencomic.com/pages/part%s/%s-p%s.htm'
    imageSearch = compile(r'<IMG SRC="(page/\d+-p\d+\..+?)"', IGNORECASE)
    prevSearch = compile(r'<A HREF="(\d+-p\d+.htm)"><FONT FACE="Courier">Back', IGNORECASE)
    help = 'Index format: nn-m (comicNumber-partNumber)'
    starter = indirectStarter('http://www.fallencomic.com/fal-page.htm',
                              compile(r'\(NEW \d{2}/\d{2}/\d{2}\)\s*\n*\s*<a href="(pages/part\d+/\d+-p\d+\.htm)">\d+</a>', MULTILINE))

    def namer(cls, imageUrl, pageUrl):
        return imageUrl.split('/')[-1].split('.')[0]

    def setStrip(self, index):
        index, part = index.split('-')
        self.currentUrl = self.imageUrl % (part, index, part)
