# -*- coding: iso-8859-1 -*-
# Copyright (C) 2004-2005 Tristan Seligmann and Jonathan Jacobs
# Copyright (C) 2012-2013 Bastian Kleineidam
from re import compile
from ..scraper import make_scraper
from ..util import tagre, quote, fetchUrl, case_insensitive_re

_imageSearch = compile(tagre("img", "src", r'([^"]+)', after='id="comic_image"'))
_linkSearch = tagre("a", "href", r'([^>"]*/comics/\d+/[^>"]*)', quote='"?')
_attrs = dict(
    back = case_insensitive_re("back"),
    prev = case_insensitive_re("prev"),
    next = case_insensitive_re("next"),
)
_prevSearch = compile(_linkSearch +
  r'(?:<img[^>]+alt="[^"]*%(prev)s|<img[^>]+(?:button_previous|naviButtons_Previous|nav_prev4|prev|previous|webbuttonback|PrevArrow)\.|[^<]*%(back)s|\s*<<? (?:%(back)s|%(prev)s)|[^<]*%(prev)s)' % _attrs)
_nextSearch = compile(_linkSearch +
  r'(?:<img[^>]+alt="%(next)s|<img[^>]+(?:button_next|naviButtons_Next|nav_next4|next|webbuttonnext-1|NextArrow)\.|\s*<?[^<]*%(next)s)' % _attrs)

def add(name, url, description, adult, bounce):
    classname = 'SmackJeeves_' + name

    def modifier(pageUrl):
        if adult:
            # mature content can be viewed directly with:
            # http://www.smackjeeves.com/mature.php?ref=<percent-encoded-url>
            return 'http://www.smackjeeves.com/mature.php?ref=' + quote(pageUrl)
        return pageUrl

    @classmethod
    def _starter(cls):
        """Get start URL."""
        url1 = fetchUrl(modifier(url), cls.prevSearch, session=cls.session)
        if not url1:
            raise ValueError("could not find prevSearch pattern %r in %s" % (cls.prevSearch.pattern, modifier(url)))
        if bounce:
            url2 = fetchUrl(modifier(url1), _nextSearch, session=cls.session)
            if not url2:
                raise ValueError("could not find nextSearch pattern %r in %s" % (_nextSearch.pattern, modifier(url1)))
            return modifier(url2)
        return modifier(url1)

    @classmethod
    def namer(cls, imageUrl, pageUrl):
        parts = pageUrl.split('/')
        name = parts[-2]
        num = parts[-3]
        return "%s_%s" % (name, num)

    globals()[classname] = make_scraper(classname,
        name = 'SmackJeeves/' + name,
        adult = adult,
        url = url,
        starter = _starter,
        prevUrlModifier = lambda cls, url: modifier(url),
        stripUrl = url + '%s/',
        imageSearch = _imageSearch,
        prevSearch = _prevSearch,
        prevUrlMatchesStripUrl = not adult,
        description = description,
        help = 'Index format: nnnn (some increasing number)',
        namer = namer,
    )


# do not edit anything below since these entries are generated from scripts/update.sh
# DO NOT REMOVE
add('1000', 'http://1000.smackjeeves.com/comics/', u'See 1000 and more of my stuff at http://www.l80comics.com ! 1000 is a non-fiction, autobiographical comic made by me, Jacob Leighty. Unlike many other autobiographical comics, every comic took place in real life exactly as it appears here (save for #18). While this comic focuses on the humorous things in my life, you will also read about drama and action in it, as well. Although the initial goal for this comic is to get to 1000 comics, It will likely go past that number should I ever get there. DISCLAIMER: Unless expressly stated by my in-comic chractacter, none of the opinions expressed in this comic are my own, and there is no malicious intent.', False, True)
add('1009sSpritersVacation', 'http://1009sspritersvacation.smackjeeves.com/comics/', u"Okay, so I have updated the site completely, other than the custom pages which I'll get to later at some later point in time. For now, it has no effect on the continuation of the comic, only thing affecting continuation is Sike who has not yet made a sprite sheet for a certain character that's needed for a future part in the plot. But anyway, comment, fav, and rate! That'd really be appreciated~ NOW ACCEPTING CAMEOS!", False, False)
add('1cek1dsmuseumofreallycrazystuff', 'http://hai.smackjeeves.com/comics/', u'Hai. Hai. Hai. Hai. Hai. Hai. Hai. Hai. Hai. Hai. Hai. Hai. Hai. Hai. Hai. Hai. Hai. Hai. Hai.', False, True)
add('20TimesKirby', 'http://20xkirby.smackjeeves.com/comics/', u"20 kirbies, considered different from all the others by Kirby, go on a journey to find out their past... At least that's what Kirby wants, since he can't stand the fact of knowing nothing about them all. The answers come slowly, the suspense builds, and the question is, are they going to find out everything? Or are they just going to have random adventures, and never know all of it? Updates Mondays, Wednesdays and Fridays.", False, True)
add('255sArtandSprites', 'http://255art-sprites.smackjeeves.com/comics/', u'Just my art and sprites. I like PNGs and Transparent Backgrounds. You will see those a lot.', False, True)
add('2Kingdoms', 'http://2kingdoms.smackjeeves.com/comics/', u'Lost in the middle of the dangerous seaweed forest of Lebanon, Uegon Prince Apollo is searching for the way home. Joined by his cousin Paris, his faithful pet Pyou, and a pair of Uegon sisters named Diane and Juno, the group must face a deceptive maze of seaweed trees, giant flesh eating monsters, the Unknown Dark Lands of the Herse, and the biggest hurdle of all, a war in the royal house of the High Waters! **UPDATES: Tuesdays NEWS>>2Kingdoms now has a group page on dA: http://2kingdoms.deviantart.com/ If you have a dA account, please show your support by joining the group. It has special extras that can only be found on dA :D', False, False)
add('2Masters', 'http://2masters.smackjeeves.com/comics/', u'2Masters is a fantasy warfare series, in a world ruled by two supreme Masters, Masters of Heaven, who represents the spirit of freedom and love, and Master of Earth who is the master of wealth and power. The Two Masters fight one another and provides completely different philosophies for the living, and humans who follow them are granted powers. Thus creating a never ending world war... READ RIGHT TO LEFT - Asian way Update Every Tuesday', False, False)
add('355Days', 'http://355days.smackjeeves.com/comics/', u"This was originally a comic where I attempted to make an homage to Kurt Vonnegut's Timequake, but it slowly evolved into A Dada Humor comic, which has now evolved onto a actual storyline that has gone on since April 1st 2012. This is my experimental comic where I attempt to post a comic daily with anything I can get my hands on, just attempting to get at least one page up! ***ENDED AS OF 9/2/12*** If you liked this comic check out my new comic: Euphemistic Eephus. http://www.smackjeeves.com/comicprofile.php?id=127121", False, True)
add('3DSComic', 'http://3dscomic.smackjeeves.com/comics/', u'All this is made on a 3DS, so expect miis, qr codes, and doodles from the notepad. I also take pictures of my hand-drawn stuff, which usually look better than the notes. All non-contributing co-authors have been reset. I am now more serious about doing this comic, and as such will only allow authors who continually provide regular content.', False, True)
add('4Ply', 'http://4-ply.smackjeeves.com/comics/', u'Four teens who have been friends since grade school enter their first year of High School. Will their friendship survive and if so, what about their sanity? Kamal: As strong as toilet paper we are. Carmen: Oh would you please just shut up! Kamal: XD', False, True)
add('60SecondComics', 'http://6tsc.smackjeeves.com/comics/', u'Every episode is completed within 60 seconds... and it even updates sometimes! http://www.vivianvideo.com', False, True)
add('8seconds', 'http://8seconds.smackjeeves.com/comics/', u"It only takes 8 seconds to change your life forever. Johnny is an average guy, who in just a day will experience events that will make him question the way he has lived. Now he'll have to face his fears in order to achieve the happiness he thought he had. Now with 50% more updates! Spellcheck by David Bradley.", False, True)
add('9ChancesforLove', 'http://9chances.thewebcomic.com/comics/', u'Finding the right person to love is quite a challenge. Approaching the person you love is an even bigger challenge. But the biggest challenge of them all is to keep that person by your side. When two strangers meet, they can decide to become friends, leave the other to be or become enemies, but what if they happen to share something, something they cannot control and not even really are aware of? (My English is not so good, if you find mistakes it would be great if you could point them out. :) Thank you!) (WARNING: 13/15+ BL)', False, True)
add('ADayOut', 'http://adayout.smackjeeves.com/comics/', u'Lizzy is an average soccer playing teen with issues. After distancing from a childhood friend, she must find out what kind of a person she really is, and along the way, discover true potential as a soccer Champion!', False, True)
add('AFairlyTwistedRealitySuper', 'http://aftr.smackjeeves.com/comics/', u"www.AFairlyTwistedReality.com A comic that is finished. It's a noncontinous humor comic with no recurring characters.", True, True)
add('AGirlAndHerShadow', 'http://agirlandhershadow.smackjeeves.com/comics/', u"There's something under the little girl's bed. It likes to play hide-and-seek and it's always hungry. It's also her best friend.", False, True)
add('AGirlontheServer', 'http://girlontheserver.smackjeeves.com/comics/', u"The true and mostly true stories of a girl playing online games and having to deal with all the crap that comes with it. Because apparently, girls don't exist on the Internet!", False, True)
add('AKirbyKomic', 'http://akirbykomic.smackjeeves.com/comics/', u"Join Kirby, Meta, and friends as they travel throughout the Kirby video game series and attempt to stop evil who are trying to destroy this series. It's a daily 4-panel adventure filled with science fiction, humor, and randomness.", False, True)
add('ALaMode', 'http://alamode.smackjeeves.com/comics/', u"Lamode sells talking pretzels to pay the rent. Her apprentice Schulz handles the wilder creations. Her new home Arryn, a college neighborhood pretending to be a town, helps Lamode discover love, acute distaste for movies, and the best way to a customer's stomach. A La Mode updates on Tuesdays and Thursdays.", False, False)
add('ALoonaticsTale', 'http://aloonaticstale.smackjeeves.com/comics/', u"A king needs a team of elite experts to help fight crime and uphold the peace of Mercia. Unfortunately, he hires crazy people for the job. This didn't quite pan out the way he thought it would.", False, True)
add('ALoveBet', 'http://alovebet.smackjeeves.com/comics/', u'A Typical Love Story, Two guys and One girl... Because in the play of love sometimes the things dont go the way you expect... Read: right to left!!! Category: Shoujo, Romance, Comedy, loli, School Life, Slice Of Life. A Long Story!! xD Updates: Every 2 weeks!!!', False, True)
add('APPLESTRENGTH', 'http://apple-strength.smackjeeves.com/comics/', u"Sentenced to death, Naori Ketsueki doesn't expect miracle or redemption. Sure to close his eyes for the very last time, he wakes up yet into a strange world full of apples, where he will have to face his fate again, and the consequences of his actions. But what is the curse of Snow White ? And where will it lead him to ?", False, True)
add('AQuestionOfCharacter', 'http://aqoc.smackjeeves.com/comics/', u"Authors ([23/25]); Aqua Apple Bre ClockworkTH CM Punk Daniel Sokolov DelSoul Doctor_Vile Exerkol Fuzzy Fox Irene Kaizuto Kitsune Fire Nick Cypher Royle McCulloch Scar Shard Slash Segary sonicballzx spark th TouhouShake Z 55DubDub -----PLACES OPEN UP EVERY SUNDAY AT 7PM EST IF ANYONE LEAVES/A PLACE IS MADE AVAILABLE----- THERE ARE CURRENTLY: TWO SLOT(S) AVAILABLE. IF YOU WISH TO APPLY FOR A SPOT, PLEASE SEND IN AN APPLICATION, EITHER VIA THE APP SYSTEM OR VIA PM TO ZMAN OR CM Punk (Who's too busy to constantly check updates but will check for Apps once a day atm). YOUR APP MUST INCLUDE YOUR REASON FOR WANTING TO JOIN AS WELL AS AN EXAMPLE OF (COMIC) WORK YOU'VE DONE IN THE PAST. REMEMBER, WE WORK ON A 'FIRST COME FIRST SERVED' BASIS, SO IF YOU DON'T MAKE IT THIS TIME, FEEL FREE TO TRY AGAIN IN FUTURE!", False, True)
add('ASongforElise', 'http://asongforelise.smackjeeves.com/comics/', u"Andi, Marcus and Elise are best friends since high school. But it hasn't been an easy friendship... And it will get worse. How much change will their relationship be able to deal with, whether it's love or death? A yaoi manga with all the EMO that it requires! ;)", True, True)
add('AStrangeTypeofLove', 'http://strangelove.smackjeeves.com/comics/', u"Dory's life took a whole new turn as an old flame of his ends up living in his house after escaping an insane asylum. As time passes by,Dory tries to (Once again) win Damian's heart. Will he succeed? Or will their 'deal' get in the way? You can find out in ASToL. 18+ Content: Sex (GAY sex ohohoh) Language Nudity I am not English,So my speech may be a little bit off. And the comic itself might be too,At times. (It's my first comic after all)", True, False)
add('AbbyinHell', 'http://abbyinhell.smackjeeves.com/comics/', u'A Girl. Zombies. A Copy Shop. How do you define hell?', False, True)
add('AdaLeeComesOn', 'http://adalee.smackjeeves.com/comics/', u'>> A Faustian tale, or the story of a crazy woman. ___(Warning: this comic contains smoking, drinking, profanity, nudity, and sexual themes. Reader discretion is advised.)', False, False)
add('Adalsysla', 'http://adalsysla.smackjeeves.com/comics/', u"there's a freckly guy who misses his girlfriend a lot and a blue girl who wants to find her brothers. on their way to wherever they're faced with a lot of trouble! drawn and written by piim, also known as Katarina Skott. mostly updates weekends!!", False, True)
add('AdventuresinCollege', 'http://adventuresincollege.smackjeeves.com/comics/', u'These kids are attending college. These comics depict all the crazy things that go on in their lives.', False, True)
add('AdventuresofMitch', 'http://adventuresofmitch.smackjeeves.com/comics/', u'The adventures of a fairly normal teenage boy and his host of crazy companions in a world that gives new meaning to the term "modern fantasy". Updates Fridays.', False, False)
add('AlPoxalips', 'http://www.alpoxalips.com/comics/', u'A story about a man on a mission. A very well-to-do man, very well educated, and yet not very smart. His mission? To convince as many as possible that the globe is facing many man-caused catastrophes that can only be solved by everyone but Al cutting back on their life style. Dedicated to preserving the planet and his lifestyle, but with as little discomfort to himself as possible.', False, True)
add('AloversRule', 'http://aloversrule.smackjeeves.com/comics/', u"SUMMARY.......... Oliver thought moving to America with Alden to peruse his dream as a musician was like a dream come true. He felt like the luckiest guy to meet Alden until one day his attitude began to change, becoming obsessed, abusive and controlling. When Oliver meets Julian, A retired military man, He believes that fate has brought them together through his music as he tries to develop a friendship with him. As a heterosexual man, Julian feels insulted by Oliver's approach and turned him down even though he felt something for oliver. Meanwhile, Jacob who is Alden's ex lover is filled with regrets as he reflects on his Past relationship with Alden. Finally realizing that he's still in love with him, he tries to find a way to break up Oliver and Alden's relationship. -----------------------WARNING------------------------------- This comic has really graphic sexual content. GENRES: Drama - Romance - Shounen Ai - Yaoi- boyxboy-some violence included, bad language. Comic status: Active Updates:Every day or Every other day! :) Reads: Left to Right", True, True)
add('AmorVincitOmnia', 'http://avo.smackjeeves.com/comics/', u"It is said, that on the day I was born an angel descended from the heavens. He delivered unto me a blessing... and a curse. Updates once weekly (Unless I say otherwise) (Oh, and most likely on weekends) Warnings: -This is a Bl comic. That means man on man action. So don't be suprised, 'kay? I may also do het and gl pairings later if I feel like it. -Rating WILL be boosted to mature later on. Also, it can be rated mature for anything. I like to keep my options open.", True, True)
#add('Amya', 'http://amya.smackjeeves.com/comics/', u'Amya is a high-fantasy graphic novel; following the adventures of a mute spell-touched and her unlikely companions as they are dragged into an adventure that is a little beyond them. Ultimately \x96 Amya is a story about self sacrifice for the greater good. It is also a story of how far one will go to obtain unearthly power; even if it includes throwing the world into a mythical war between fate and chaos. Amya updates every Wednesday.', False, True)
add('AnalogueandDigital', 'http://analogueanddigital.smackjeeves.com/comics/', u'A comic about electronic music. With synthesizers.', True, True)
add('Anathemacomics', 'http://anathema-comics.smackjeeves.com/comics/', u'1810 England, the height of the Napoleonic wars. It was thought that humans walked the path of enlightenment leaving monsters and dark things behind. However, those monsters and night stalkers merely hide in the darkness, as a young maid, Bernadette, soon finds out.', False, True)
add('AngelGuardian', 'http://angel-guardian.smackjeeves.com/comics/', u'Kyrsiel is a young apprentice of Guardian Angel. His teacher, Gersiel, is responsible he achieves a successful test mission to graduate. Moreover, Gersiel may not continue his evolution as Angel until Kyrsiel, who is his last student, graduates. And this is not easy! Both will play an important mission on Earth: Protect Midori, a young student girl, from the demons that are chasing her. . Will Kyrsiel do it successfully or will he fail again? Story and drawings: \xa9 Reenave http://reenave.deviantart.com Translated into English by: Louise Brown http://cast-into-the-abyss.deviantart.com/', False, True)
add('Animayhem', 'http://animayhem.smackjeeves.com/comics/', u"Twelve-year-old social reject Vera and her best friend Maggie love anime more than life itself. Too bad they live in a world that's hostile to the magic of Japanese cartoons. And go to a school that contains a portal to the Underworld. And have to fight demons when they could be cosplaying or watching a Princess Neko-chan marathon... Vera and Maggie's adventures with the occult are twisted, gory...and so absurd, they can only result in total Animayhem! Written and illustrated by JoJo, currently set to update every other day until there ain't no more pages!", False, True)
add('Anythingaboutnothing', 'http://www.anythingcomic.com/comics/', u'A collection of random comics about random things :D', False, True)
add('ArchportCityChronicles', 'http://tjs.smackjeeves.com/comics/', u'Archport City is the interdenominational hub and there are always stories to tell... This first one is what happens when you just have to get that picture... Dissatisfied on what was supposed to be a fun trip it was only a matter of time until adventure lured Joe in. Now a group of discredited bounty hunters with a dangerous target have dragged him along for the ride.. updates T and Thr..', False, True)
add('Area9', 'http://area-9.smackjeeves.com/comics/', u"Taishi Iwaska had once dreamed of working in Area 9, a research facility surrounded by a huge wall that finds cures for dangerous viruses. Feeling useless, he has recently given up on his dream, but in a strange turn of events he finds himself trapped in Area 9 as a hostage with a crazy bomber called 'Bomb', who claims to be a terrorist that will blow up Area 9 if they don't give him what he wants. Is there anything Taishi can do before it's too late? Just who is Bomb, and why does he want to destroy Area 9? Taishi will have to overcome his feelings of helplessness if he's going to do anything about it, as well as make a few shocking discoveries along the way. This is a one-shot that has turned into an unusually long one-shot. There will be 3 parts with around 70 pages each. <<Reads from right to left<< Updates on Saturdays.", False, False)
add('AreyougayJohnny', 'http://areyougayjohnny.thewebcomic.com/comics/', u"This is not a BL webcomic, but there might be boys looking for boys. This is not a love webcomic, but there might be people in love. This is not a satirical webcomic, but there might be some satirical situations. This is not a hentai webcomic, but there might... no, there is sex in it. This not a comedy webcomic, but there might be some laughs. This webcomic is my humble homage to the 21st. Century young people. Growing in a world that no longer requires anything from them, grandsons of hippies, sons of punks, living in an ultra modern world where a nickname values more than a real name. Where most people fills their mouth to speech about freedom, but then they are the firsts to prejudice. In this post-apocalyptic world, Johnny finds himself with a big dilemma; he doesn't know who he is. He doesn't have amnesia, he just got the luck to live in a world that moves fast and left him alone with no clues whatsoever of why he was there in the first place. Follow Johnny and Leslie's misadventures to find the answers to the most basic questions about their own identity.", True, True)
add('Arkaedea', 'http://ark.smackjeeves.com/comics/', u'Roxene likes Seth. Seth likes Roxene. Viktoria likes causing trouble. Femslash/yuri/shoujo-ai/romance/fantasy fun ensues. ;)', False, True)
add('AskAltair', 'http://askalty.smackjeeves.com/comics/', u"An Assassin's Creed fan-comic about Altair, Ezio, Desmond, and the crazy fangirl who is intent on keeping them prisoner in her inescapable house.", False, True)
add('AtArmsLength', 'http://atarmslength.smackjeeves.com/comics/', u'The story of three magical ladies and their lives with their husbands, making it in the modern world and dealing with the occasional monster attack. Updated Tuesdays, Thursdays and Saturdays.', False, True)
add('AuraChillandLylaSpamTime', 'http://sontarha.smackjeeves.com/comics/', u'Self-explanatory. Credit to SEGA, CAPCOM and NINTENDO for most edited sprites in here. Alternate title: Aura and his girls~ Doctor Who quote of the week: "Take a hike, Krusty!" ~Some kid, Day of the Clown', False, True)
add('Autophobia', 'http://autophobia.smackjeeves.com/comics/', u"The story of a dude named Louis who tries to accept himself for who he is and to learn to not let others step all over him. It follows him through the course of his life and the relationships he builds with others, particularly with his classmate Daniel. [Updates Sundays] --- Warning: gay ppl, straight ppl, a plethora of dialogue, profanity, sexual themes/content, and an absurd amount of fluff. /Mature content is on for some of the future themes explored, but there's nothing explicit./", True, False)
add('BAKAZOKU', 'http://bakazoku.smackjeeves.com/comics/', u">>>>>>ON HIATUS<<<<<< So many things going on right now.;; please stay tuned!! <3 General Summary: A 4-koma series about a unique family and their ridiculous adventures. Exaggerated Summary: One drunk young perverted male adult, one mother-like genius male teenager, and one non-emotional straight forward female kid make up a small family and try to live the normal life, but due to their pasts and connections, it's prety difficult to accomplish. 8D Summary from Mangabullet: Two best friends and a bizarre, indifferent little girl make up a family in a small room of a Japanese apartment. Due to their pasts, their misadventures are taken in different places, and together, they try to unintentionally defeat their enemies in a comedic way while continuing their daily lives. Updated every 2-3 days! Back-Up Site for: http://www.mangabullet.com/comic/BAKAZOKU [Some pages of BAKAZOKU! on Smackjeeves may have terrible quality compared to BAKAZOKU! on Mangabullet.]", False, True)
add('BITCHSQUAD', 'http://bitchsquad.smackjeeves.com/comics/', u"BIOLOGICAL INDESTRUCTIBLE TACTICAL COMBAT HYBRID SQUAD If you like {sexy,sci-fi,alien,government conspiracy,action}, you'll love BITCH Squad. A group of teen friends expose to the world, the truth about a top secret government project combining alien DNA with human in an attempt to create super soldiers.", True, True)
add('BURNiNation', 'http://burnination.smackjeeves.com/comics/', u'A comic showing how REAL friends communicate: with insults.', False, True)
add('BabysittingFourDemons', 'http://babysitting4demons.smackjeeves.com/comics/', u'Ezz, also known as Ghost the Echidna on her Smackjeeves account, has become a babysitter. She\'s finally on her own, and starting a nice, steady babysitting service at her home. Little does she know is that the children she is to babysit happen to be four demons... Who are these four? Why, none other than Sonic, Amy, Knuckles and Tails! Open Author Spaces: NONE. DON\'T EVEN ASK. Don\'t even request. Don\'t comment "CAN I JOIN LAWLZ" or I\'ll come after you. Thanks! -Hope Status: No one banned. Please start updating more, people. I\'ve made up my mind that I\'m gonna update more, you guys can help out too. -Hope', False, True)
add('BadLucktheQuestfortheCodPipe', 'http://badluckthequest.smackjeeves.com/comics/', u"This is the story about Rade, your everyday average guy. he goes to school, plays sports, the only thing weird about him is his best friend Crimp. Things in his average life take a turn for the bizarre, when a young man with a cat show up at his door. Now all of a sudden Rade is caught up in a quest for a magical pipe that can grant a wish to anyone who asks. Not to mention the demon mercenary's following them. the closer they get to the Pipe, the darker and more entangled things become. what starts as a grand adventure, only seems to lead to Bad Luck. Updates Saturday", False, True)
add('BassLegends', 'http://basslegends.smackjeeves.com/comics/', u"After Bass finally defeated Mega Man, he left Wily and took Zero with to begin a new life. He and Zero join Dr. Light's crew and have one hell of a crazy adventure. Note: This comic is PG-13 and contains strong language, violence, and may contain SC (Sexual Content). Viewer Discretion advised.", False, True)
add('BearlyAbel', 'http://bearlyabel.smackjeeves.com/comics/', u'Abel is a American-Asian boy with an active imagination. He lives with his mom and sister and goes on adventures with his bear, Barry. This webcomic ran from August 2008 until Oct 2010.', False, False)
add('BehindTheObsidianMirror', 'http://obsidian-mirror.smackjeeves.com/comics/', u"If you were to awake in a place unknown to you, without remembering anything... you would be happy to be taken in by someone, right? But what if this someone was a god? Aztec gods and BL. What more could you want? x3x Warnings for homosexual content, blood, violence, and possibly gore and sex in the future. Don't like, don't read. UPDATES EVERY MONDAY!! Although I have read a lot about Aztecs and their culture and mythology, I am hardly an expert on that subject. So forgive everything that might be off, or wrong, since I actually don't bother to get everything right or just change things to my liking. The Aztecs and their religion etc. depicted in this comic are far from realistic, and don't aim to be, although I'm trying to make it all seem plausible. Just so you know. Enjoy. ;) Remember to read from right to left, Japanese reading order. ;) Sketch/WIP tumblr: http://teejaystumbles.tumblr.com/", True, True)
add('Behindtheglasscurtain', 'http://g1ass.smackjeeves.com/comics/', u"Scarlet spent all her life in a dismal, dark prison that just so happens to be located in a dismal, dark realm bereft of all flora and fauna. One night she ignores the frog's rule to never look out the window when darkness approaches. What she sees next will change her life and everything she once knew. It's a comic that delves deep into other character's lives and reflects on their back stories. Even though the main story seems to branch off to smaller stories, there is a basic plot, which the reader has to decide on. updated on weekends, but best to check it on Monday. It's finished! COMPLETELY FINISHED! Don't keep on checking for updates. Yes the first 100 pages looked like crap but mind you I started this when I was 14!", False, True)
add('BettencourtHotel', 'http://www.welcometobettencourt.com/comics/', u'"You are advised not to leave your room from midnight to 2 a.m." A little horror story about pretty boys working in a murderous hotel. Some shounen-ai. ~Updates on Fridays~', False, True)
add('BetweenLightandDark', 'http://bld.smackjeeves.com/comics/', u"bLD Alicia, Alani and Maggie have always had a calm life. If we don't count that episode of Alicia becoming a Demonified, they never had to fight anything big. But everything changes when strange things start to happen and Alicia suddenly disappears. Now Alani, Rick, Maggie and her siblings have to find Alicia and turn her back to normal. Will she come back to their side or join the Evil side? ------------------ bLD2 Ten months after Alani, Alicia and Maggie sealed Cass in the magic jar, everything seemed perfect again. But, as everyone is expecting, is not. Jess is up to something to get her sister back, and will do whatever it takes to get that magic jar. ------------------ Updates every Sunday and Wednesday. (Currently updating Sundays only until March) PG-13 due to language here and there and some themes. There are also short comics updating every Tuesday here -> http://bldshortcomics.smackjeeves.com It is not mandatory to read those to know important things in this, but some strips are intended to be connected to the story!", False, True)
add('BetweenWorlds', 'http://betweenworlds.smackjeeves.com/comics/', u'It is the 80th birthday of the benevolent tyrant, King Bergan. His four loyal knights prepare to march in his honour, but all is not well. The senile ruler, plagued by hallucinations and delirious dreams, begins to cast strange allegations of witchcraft on one of his most loyal servants, the knight named Lynx, the soldier named Juno...', False, True)
add('Betwin', 'http://be-twin.smackjeeves.com/comics/', u"Be twin is an amator comic wich smells powder, shootings and mafia, but which finally cares more about the two destinies that had difficultly found their place there. Two people differents in everything but actually not that much... I'm uploading pages every two weeks, on the sunday. I'm french and I know my english is rather bad, please forgive my mistakes, I really wanted to share this story with my non-french readers. ;-; Thank you so much for reading... >w<", False, True)
add('BeyondTemptation', 'http://beyondtemptation.smackjeeves.com/comics/', u"An accidental meeting turns Reimee's life up and down. She finds herself in the middle of an affair regarding enslaved demons, magical artefacts and many temptations of the modern world. Will she get tempted? Or will she be the one to tempt? And finally, will she find what she's looking for in the Eternal City of Rome? Inspired by eastern folklore, religion, Grimm tales and life itself, set in modern times Rome it's a paranormal action romance in which the borderline between good and evil is very thin. (plus guys don't sparkle and girls can kick your butt :D) NOTE: 1.This comic is fruit of immagination and does not reflect anyone's opinions nor real facts nor people. 2.Not marked mature (I find it annoying when I can't see the preview)but may contain some blood here and there and possibly some erotic scenes. 3.Commens are very appreciated. Reviewable if anyone wanted to attempt at it.", False, True)
add('BigfootTheJamesLewisStory', 'http://bigfoot.smackjeeves.com/comics/', u'James is a man with extraordinary strength, and since childhood James has been gifted with even more extraordinary powers: a powerful connection with nature and a mental enhancement. His goal in life is to prove the existence of Bigfoot. One seemingly ordinary day becomes the adventure of a lifetime as James encounters Bigfoot in the most unexpected way- and it turns out Bigfoot is a bigger deal than anybody could have anticipated.', True, True)
add('BinarySoulsOtherDimensions', 'http://bsodcomic.smackjeeves.com/comics/', u"A heart warming story about a whiny robot, a crazy hologram and a witch determined to rule the world. *** If you'd like to find out more about BS/OD, please visit our website at http://www.bsodcomic.net .", False, True)
add('BiscuitFox', 'http://biscuitfox.smackjeeves.com/comics/', u"There are no rules stipulating that women can't play professional men's hockey. Nikita Stefanova is determined to prove that she can skate with the big boys.", False, True)
add('Bitemeayaoi', 'http://bitemeyaoi.smackjeeves.com/comics/', u"Warning: YAOI, which means man on man action in bed. There will be graphic scenes later on in the story. There are also suggestive scenes as well. Also abuse. Please leave now if any of this bothers you. That's all. (and if you are looking for instant gratification, this probably isn't the story for you) Everything was normal....ish. It was just Kain and his mom against the cold cruel world. That was normal for them. At least, it was until his old friend comes back into Kain's life. Milo abruptly confronts Kain after years of being apart, but Kain doesn't remember his past and turns him away. Even after multiple times of Kain trying to push Milo away, Milo won't let go of his childhood crush. Will Milo finally break down the wall blocking Kain's memories and gain his love? Or will he let his love go because someone else already has taken his place? (art gets better as time goes. 2008-present) (This story is pre-planned from start to finish.) Attempting to update every sunday UPDATES RANDOMLY (deal with it) :D", True, True)
add('BlackFridayRule', 'http://blackfridayrule.smackjeeves.com/comics/', u'', False, True)
add('BlackandBlue', 'http://black-and-blue.smackjeeves.com/comics/', u'A sci-fi fairytale. A boys nightmare. So, this is about an Evil Empire soldier with a few problems... not the least of which is a slight gender issue and a weird entanglement with an astronaut. Awkwardness ensues. D: I thought "The Crying Game" was a comedy, you\'ve been warned. Ha! e_e Also I started this about 200 years ago and the art is pretty rough I\'M SO SORRY! ;_; FORGIVE ME!', False, True)
add('Blackdemon', 'http://blackdemoncomics.smackjeeves.com/comics/', u"everyone has a demon inside them, even the nicest people in the world has a demon. what happens if the demon inside takes total control of you? it could effect your life style, personality, and for artist's; imagination. that's what this comic is about. a girl with poor social skills and a large imagination, how will she fix both problems? (WARNING:some chapters in this comic are based on real events that occurred in the author's life) comic updates:Monday's, Wednesday's, and Friday's(if not updated, that means i got a LOT of HW or my laptop is damaged)", False, True)
add('BladeoftheFreak', 'http://bladeofthefreak.smackjeeves.com/comics/', u"Login is a slacker who owns the legendary Sword of Lode, a sword that cannot cut through anything. In order to not pierce his back when carrying the sword, he will start a quest to find the sword's case which will be the beginning of an epic adventure!", False, True)
add('BleachRedux', 'http://bleachredux.smackjeeves.com/comics/', u"Myself and others were extremely disappointed with Ulquiorra's death in the official Bleach manga, so I've taken it upon myself to draw out what could've possibly happened had Orihime pulled her head out of her ass and saved him. WARNING: UlquiHime. Any negative comments (or futile attempts at validating other ships that make even less sense (ie: IchiHime)) will be deleted. CURRENT: 1/27 Ch26 is online. Ch27 in progress. ETA 02/27. NOTE: READ RIGHT TO LEFT LIKE JAPANESE MANGA.", False, True)
add('BlindandBlue', 'http://blindandblue.smackjeeves.com/comics/', u"Boy's Love! (Gay relationship romance) Caecus (Case) woke up one morning to find that he was completely blind. He's picked on by the school bully, and things aren't so great. Fortunately for Case, he finds a friend - and eventually a boyfriend - in the new kid, Darryl, and together they make it through the things life throws at them. A smackjeeves mirror to the comic on DrunkDuck, which you can read [url=http://www.drunkduck.com/Case_1048_Blind_and_Blue/]here[/url] Comic contains swearing very rarely,so if you don't like it...you'll be fine actually And if you're homophobic...message me with your reasons why as I am very curious on the topic.", False, False)
add('Bloodhunters', 'http://bloodhunters.smackjeeves.com/comics/', u".In a world full of vampires and monsters only the hunters can protect the humans. Their job's to eliminate everything that seem to be dangerous. But really every nonhuman being's evil? The story's following Dren,a young vampire who's different from the other vampires both in nature and abilities ( and eats fruits?) Raised by the hunters he aims to become a hunter Read from left to right", False, True)
add('BloomaPokemonConquestComic', 'http://bloomconquest.smackjeeves.com/comics/', u'According to the Legend of the Ransei region, if all 17 kingdoms of the region are united, the legendary Pokemon that formed the region would appear. Young Saku, along with her stubborn Axew, set off on the road of conquest. However, the warlord Nobunaga is only one kingdom away from uniting the region. Can Saku conquer Ransei before he does? ______________ There is a bit of violence later on, but hey, Pokemon has a certain lack of violence that they need to make up for. Nothing too bad. Updates Wednesdays and Saturdays.', False, True)
add('BlueWell', 'http://www.bluewellcomic.com/comics/', u'Leif Kavanaugh grew up in the country-side and came to the city to attend college. He moves into "The Blue Well" boarding home, which houses several other college students just like himself. While he hopes everything will go smoothly, Leif learns it\'s not the city that makes life crazy, it\'s the people.', False, False)
add('BlueYonder', 'http://www.blueyondercomic.net/comics/', u'Jared Davenport thought he knew what it took to be a hero. He is about to find out otherwise. On the run, Jared takes refuge in the Claremont apartment. There, Jared finds friends and rivals alike amid the bygone superheroes of yesterday. He will need all their help to survive a brutal enemy from his past. But even on the streets, Jared is about to discover the sky is the limit as he becomes . . . Blue Yonder!', False, False)
add('Boo', 'http://boocomic.smackjeeves.com/comics/', u"On a Halloween night a little girl named Kat opens a strange box, releasing hundreds of monsters as well as the Boogeyman (AKA Boo) onto her town. Boo and Kat must work together to protect themselves from these monsters that now lurk in the shadows, but is that what they really should be afraid of? Because little do they know a retired hit-man from Boo's past named Cain is coming to Kat's town to make sure the Boogeyman he locked away years ago is still dormant. As the story unfolds we peek into Boo's past, when he was a child. We follow him on his tragic/strange journey to becoming the Boogeyman and ultimately his imprisonment in a box that Kat eventually opens over 100 years later. Cain is on his way for a head-on confrontation with Boo and poor Kat is stuck in the middle of it all. Are there answers in the past that can save their futures? Or are they all doomed to be eaten by the monsters that continue to be constant threat to everyone? - Updates Mondays, Wednesdays, and Fridays - Can now be bought on Lulu.com (hint-hint, nudge-nudge)", False, True)
add('BoogeyDancingMonkeyPot', 'http://monkeypot.smackjeeves.com/comics/', u"Prince Jean-Patrick finds young Sarah's bedroom to frighten her. But Sarah isn't an eight year old girl running around in her socks. She's a young adult now and it certainly shows! Together, the Boogey man and human girl journey through their lives. One to become king of his kind and the other to find her place. Two roads cross and destiny determined to keep them together. Monsters do not solely exist in the darkness. rated mature for violence, language, partial nudity and some sexual tension", False, True)
add('Border', 'http://border.smackjeeves.com/comics/', u'Its a perfect description of the "Manapunk" genre, its a fantasy world where Mana and magic moves everything, and the Gods walk among Man as the return of Ragnarok draws near.', False, False)
add('BoyLessons', 'http://bilessons.smackjeeves.com/comics/', u'[COMIC ON HOLD] Catman making better people out of 5 young weirdos with their own unique problems. [terrible art at the beginning and more bearable one later on] (read in the normal humane way from left to right)', False, False)
add('Boywithasecret', 'http://www.bwascomic.com/comics/', u'Comic Title: BOY WITH A SECRET (Himitsu no Aru Otoko) Boy with a secret: is a story about a troubled teenage boy who hides his identity from everyone out of fear of being exposed. His family moved after a traumatic incident at their hometown. Haruhi tries to adjust to life at Fujimoto High School (his new school) were he meets the beautiful and compassionate Minako, who comes to trust and befriends him, However bullies threaten that chance at a new start. But things start to change when a friend from the past appears and offers to help. ********************************************************* Updates: Every Wednesday GMT -6(US Central Time) Genres: LGBT, physiological, Romance, Drama, School Life. *warning* some adult situations Rated: 16+ Contain :Violence, Blood,Profanity All pages in FULL COLOR ********************************************************* *READ FROM LEFT TO RIGHT * Comments are always appreciated. :) THANKS!', False, False)
add('BreIshurnasspritesandstuff', 'http://breishurnas.smackjeeves.com/comics/', u'Here, I make fan characters, random Pokemon recolors, custom sprites, and all that other craptastic things a spriter can do! Come on in if you are not scared! Hopefully I do not lose it all! Currently in Version 2!', False, True)
add('BreachofAgency', 'http://breachofagency.smackjeeves.com/comics/', u'Panacea has the gift of healing, which makes her a target for both sides of a civil war. The Minister, leader of the Agency, is determined to have her cure his fatal illness and prolong his life. Forever. But the Gunman and his accomplices want her dead. All Panacea wants is to find her own destiny. When she and her bodyguard, Aegis, stumble upon Traver, who takes them in after they narrowly escape a brush with death, Panacea believes she may have found a real home. But the Agency has eyes everywhere, the Gunman is always waiting in the shadows, and Panacea can never be sure who her allies are.', False, True)
add('BrightStars', 'http://www.brightstarscomic.com/comics/', u'A miscalculation sends Rory into the far reaches of outerspace. WARNING: May contain violence, language, and human-alien relationships.', False, False)
add('BrookeandKirby', 'http://brookeandkirby.smackjeeves.com/comics/', u"A comic about my fan character Brooke and Kirby. This is the first webcomic I ever posted here, so expect some mistakes. And don't expect updates daily. I can sometimes get Author's block.", False, True)
add('Burn', 'http://burn.smackjeeves.com/comics/', u'/ RATED TEEN / Occasional violence, "bad" language (lol), adult situations/themes, yaoi. .:. Spunky young college student Darryn Gainnes has just turned 20, and decided to tone his wild ways down a bit. All he needs in life are his two best friends, their band, his books, and his music! He thinks nothing of it when he literally bumps into a pretty (and gloomy) High-School-boy at the park. But soon, Darryn finds himself swept up in a world he had never even known existed, a world of intrigues and violence and magic! And of course what is sweeping both boys off their feet is their budding romance... and so many incredible obstacles thrown in their way. Where will it all lead? Who is on their side... and who will be left standing? .:. BL: This is a shonen-ai/Boys\' Love comic! If you don\'t like those, don\'t read this one! ^~ DIRECTION: This comic reads right to left, for no other reason than that I like it that way. ALSO: I never have as much time as I would like, so for the most part this comic is pencil sketches and a bit of photoshop. But I hope you enjoy it! ^^', True, True)
add('Buzz', 'http://buzzboys.smackjeeves.com/comics/', u'A short comic about a Spider and a Lady bug.', True, True)
add('ByTheBook', 'http://bythebook.smackjeeves.com/comics/', u"After stumbling across a copy of 'The Adventurers Handbook 3.5' an orc, goblin and kobold decide to leave the dungeon and become mighty adventurers! Updates every Wednesday and Saturday.", False, False)
add('CRACKRPCOMICJOINNOW3', 'http://thehotelrp.smackjeeves.com/comics/', u'Crack RP comic that takes place in a Hotel... Pretty much anyone can join/co author!:D Read the description on Page 1 to learn more! JOIN before all positions are taken, and there is only a few left. :D Please be creative when making your characters and have fun!<3 C: Message me with any questions, ~Skittymitty', False, True)
add('CROWLEY', 'http://crowley.smackjeeves.com/comics/', u'CHRISTIAN D. CROWLEY. Investigador privado. Detective de lo sobrenatural. Hechicero. Cazador de Demonios. Anticristo (eh... espera un momento)', False, True)
add('CafeauLait', 'http://cafeaulait.smackjeeves.com/comics/', u'The comic strip with cat boy flavor! May contain BL and stupid cuteness. (updates saturdays) The illustrations are here! http://nadykun.deviantart.com/gallery/40865689', False, True)
add('CaptiveSoul', 'http://captive-soul.smackjeeves.com/comics/', u'A BL Pirate manga! :P Sai works on the ship "The Liberty", he was taken in at a young age after his town was burned down and he lost his family. The event was traumatizing and Sai lost his ability to speak. He has sworn to hunt down the pirates that destroyed his home and bring them to justice(however that seems a long ways away) However, recently the captain of the ship, Kuragi, has taken an interest in Sai! Will Kuragi\'s advances distract Sai from his goal to avenge his family? A stormy relationship ahead! Will update every tuesday :P', False, True)
add('Carciphona', 'http://carciphona.smackjeeves.com/comics/', u'In an era where magic is forbidden, a sorceress struggles to restore her once peaceful life.', False, True)
add('CarrotandRoper', 'http://carrotandroper.smackjeeves.com/comics/', u'This comic follows the strange and unusual encounters of Carrot (an appropriately named carrot) and Roper (a potato) along with a slew of other odd characters. Updates sporadically.', False, True)
add('Cataclysm', 'http://cataclysm.smackjeeves.com/comics/', u'Set on the last remaining hospitable island on a frozen world, a covert faction known as Militia attempts to overthrow a utopian civilization and their benevolent rulers, The Council.', False, True)
add('CatboyattheCon', 'http://catboyatthecon.smackjeeves.com/comics/', u'Trades is a catboy that goes from convention to convention with his boss, Carl, and his girlfriend, Jedda. Life would be simple... if not for the fangirls, stalkers, psycho ex-girlfriends, fanboys, and of course his family constantly reminding him of his flaws... Oh well what is a catboy to do?', False, True)
add('Catnip', 'http://catnipmanga.smackjeeves.com/comics/', u'Ikita is a young and impressionable noble, who has been bound to a young lady by arranged marraige. Felix is his hired bodyguard; a quick witted and reliable one at that - but who has more to his past than he would like to reveal. As Felix follows Ikita as his bodyguard, they start to have mixed feelings about their positions, and where the future may lead... Based in an 19th centrury-esque alternate history, this tale consists of friendship, compassion, love and regret.', True, True)
add('Cement', 'http://blocksofsherst.smackjeeves.com/comics/', u"We are a legion of awesomeness, bro! >:{C -------------------------------- Welcome to Cement! A boredom webcomic to discuss/review ideas, movies, fanfiction, and other stuff. We also have: - A sprite showcase, - Some tutorials, - Dreams that make sense, - Debates that make no sense, - Lotsa shitty shit bullshit, - Crack, - Heli-kun~ :3 - Anus - Hentai - Steak - Swagga - What Pumpkin And much more... Feel free to apply as author if you'd like! (no wait, don't) Gooby plz. I'm touching the description! Hurrdurr! :B Description pending... Thank you for still reading. Now.. have a nice day and go HoNk yourself. I touched it again - silentdusk c: Heil Helitler. Calm down Stalin' *shoots helitler in da face* :D Now go back to the top and re-read the description. HoNk hOnK Go dunk your head in a bucket, Gamzee - you sexy piece of shit, you. No one cares this desc motherfucking exists anyway. :o( gun in your face big disgrace, kicking your ass all over my place.~ Royle McCulloch", False, True)
add('CerberusCrescendo', 'http://elica.smackjeeves.com/comics/', u'in the decades since superhumans have become a reality, the vast majority of them have chosen to use their abilities wholly for criminal activity and personal gain thousands of active supervillains exist with virtually no opposition from law enforcement and military groups, who are desperately under-equipped to handle them an effort is put forth by a hyperintelligent but almost entirely anonymous man known as insight to attempt to wipe out the supervillain community altogether cerberus is this effort', True, True)
add('ChampionsandHeroesAgeofDragons', 'http://championsandheroes.smackjeeves.com/comics/', u'In a land far away, or possibly in a dimension just next to us, lies the lands of Thedas. The world of Thedas is made up by endless possibilities - a man can be a mage, a rogue, a warrior, even a woman. From the Free Marches to Ferelden we find champions and heroes saving the world... poorly. Updates Mondays. All hail Bioware.', False, True)
add('ChaosAdventuresII', 'http://chaosadventuresii.smackjeeves.com/comics/', u'Creds to: Characters Chaos/Halo - Master Rezz - Nebula Ki - Megablueblastaa Tails - Hypero Sarah \x96 Foxx Etch \x96 No Details Blur - Cylent Nite Thorn/Young Thorn - Cylent Nite Omega - Hypero (customised by me!) The demons - Gardow Styxs - Sakura Courage Solo Backdrops- Wacky Workbench Zone - Shadowbot Green Hill Zone - kinny-man Chemical Plant Zone - Domenico Sky Canyon - kinny-man Emerald Alter - Apocalypse the Hedgehog Angel Island Zone - SkyLights Other Tails\x92 plane - Rogultgot', False, True)
add('ChaosReigns', 'http://chaosreigns.smackjeeves.com/comics/', u'Ten years have passed since the war with Cinos and with the triumphant return of Sonic, peace is had once more. Atril and the Gathering have pretty much returned to life as usual and the tactician and former enemy Lilliana joins back with the Outsiders. But peace is never a certainty and the leader of the Outsiders feels a coming of something that will break that peace. Once again our heroes must discover what it is to fight for what you believe in. Chaos Reigns is inspired by "Normalcy is for Wimps".', False, True)
add('ChaoticNation', 'http://chaoticnation.smackjeeves.com/comics/', u'Karians were first born during the cataclysm. Once human, the race mutated. They became stronger, faster, and changed in physical appearance and magical ability. In a world already devastated, a rebellion rises to defend the dwindling human race from the growing fear of the Karian army. Their one hope may lie in a mysterious mage whose kind heart has the courage to stand against the oppression and torture brought on by the impending war. WEEKLY UPDATES ON TUESDAYS Contents - Nudity, Language, Violence, Blood and Gore, Hentai, Yaoi', True, True)
add('Chatuplines', 'http://chatuplines.smackjeeves.com/comics/', u'Welcome to "Chat-up lines"! A South Park Doujinshi from CraigTucker and me. Pairing: Craig x Stan Story: Stan hates Craig and his friends are fags! They haven\'t time for him.. Bad friends.. But in a chatroom.. he meet a guy.. and he is cool. ..and they will be friends...', False, True)
add('CheckoutLane', 'http://checkout-lane.smackjeeves.com/comics/', u"Ever worked in retail? Then I'm sure you'd remember all the crazy things that happened around your work place. Checkout Lane centers around Mandy, a cashier, and the crazy events that occur around Little Bit of Italy (a grocery store that specializes in Italian goods). Some of them have really happened to me and some I did just for humor's sake. But you never know! They could really happen! Happy reading everyone!", False, True)
add('CheneysGotaGun', 'http://cheney.smackjeeves.com/comics/', u"Cheney's back! Ever wonder what Dick Cheney is doing in his secure undisclosed location? The Hunting \ufffdaccident\ufffd was only the beginning. Dick Cheney has now found his true calling. Tag along as the vice president cleans out his guns, and dusts off the ammo boxes as he fights his way through a world of terrorists from Cidy Sheehan to Osama Bin Laden. This is a graphic novel I did a few years ago and have decided to give it a rerun.", False, True)
add('ChesterandFerdie', 'http://caf.smackjeeves.com/comics/', u'Chester and Ferdie updates once a week, usually on the weekend!', False, True)
add('ChickenScratches', 'http://chickenscratches.smackjeeves.com/comics/', u'A slice of life 4-panel comic. A journal about a young man and his troubles in life. Updates Monday to Friday. Sunday is a Sketchbook entry.', False, True)
add('ChildrenoftheEternalSpring', 'http://offspring.smackjeeves.com/comics/', u'Stories about a world made by a woman named Eternal. first chapter: Door Knocker Pendant "two girls in a quest to retrieve a world legend two children searching for each other one pendant to cross their paths and a door to take the children back to their homeland..." it focuses on the final adventure of Hi and her comrades Atta and Rote in their quest to retrieve the Door Knocker pendant from a man who\'s only will was to open one single door and isolate the power he believes he deserved. note: mild violence, dry humour, updates: every week, if possible...', False, True)
add('ChildrenoftheNight', 'http://cotn.smackjeeves.com/comics/', u'Vampires are at the brink of extinction ruled with a heavy hand by the Hunters, an order of vampire slayers that has existed since the beginning of mankind. The centuries-old law is very clear; a vampire can only feed off criminals whose names are on the lists provided by the Hunters. Any other interaction with humans means punishment and even execution if they are harmed. But when an unlikely friendship between a human girl and a vampire starts to grow into something much deeper, can these laws be obeyed? CotN is a romance webcomic set in the Victorian Era, depicting forbidden love amidst a clash between vampires and the Hunters, an order of vampire slayers. :It updates every Monday:', False, True)
add('ChillysDreamland', 'http://chillysdreamland.smackjeeves.com/comics/', u'After failing to assasinate his target, Kirby, Chilly is beamed back up to N.M.E. just before disolving. Now, considered a traitor, he is imprisoned, but is soon broken out by a star warrior named Burning Leo. After gathering a team of both star warriors and monsters, Chilly, Birdon, Poppy, and all their allies continue their quest to build a resistance to N.M.E., all while uncovering a plan that may threaten the entire galaxy. Based on the anime! Updating: I make chapter long buffer zones, then update the pages daily. If it hasn\'t updated today, then I\'m working on the next chapter. Sprites and backrounds ripped by: Drshnaps, Kung Fu Man, Zephyr_light, Gooniez, A.J. Nitro, HyperGumba, Ultragm2003, TJoe, Jackster, and KUTTER11 This is a fan comic. Kirby and all related characters belong to Nintendo and Hall Laboratory. I do not own these characters, nor do I make any profit of this comic. No copyright infringement intended. If you wanna support the original franchise without making me profit, go buy a copy of "Kirby\'s Return to Dreamland." Seriously, it\'s like, the best action game you\'ll ever play.', False, True)
add('CityFolk', 'http://cityfolk.smackjeeves.com/comics/', u'Tired of a dull life in the wilderness of British Columbia, a beaver and a moose make the trip of a lifetime; into the heart of the city. This is their story. City Folk will not be updating for a while. My computer has finally given up on life and I have no way of scanning/editing/uploading. Life sucks until I can get a new tower.', False, True)
add('ClairetheFlare', 'http://clairetheflare.smackjeeves.com/comics/', u"Claire is new to this whole superhero thing, but she knows what it's all about. Getting famous! But with veteran heroine Bulldozer breathing down her neck its not going to be easy. Updates Three Days a Week! Monday, Wednesday and Friday.", False, False)
add('CleanCure', 'http://cleanpluscure.smackjeeves.com/comics/', u'-A few hundred years into the future, life has changed, but remained relatively the same from a social standpoint. Various government plans to deal with the changing global climate ended in many successes, but many more failures. As a result, certain mutations began to appear in humans as well as animals, and though most were bred out, some remain to the present. -Enter Ezra and Percy; two young men, cat-boys in fact, whom are facing a tough time not only surviving day to day, but making their dreams a reality. After losing their current job, they are offered a new one by a seemingly normal, but secretive man with a lot of money. Their new boss employs them as maids, frilly dresses and all, and makes them clean his and the mansions of others. It quickly becomes apparent that their boss is more interested in the ever mutating rat-like creatures which are making their homes in the dirty world of military cover-ups and powerful family connections. When these two get caught up in the lies and secrecy of their new occupation, will they be able to escape? And what is the connection between mutations and the incident 20 years ago? UPDATES SUNDAYS', False, True)
add('ClockworkAtrium', 'http://www.clockwork-atrium.com/comics/', u'In a misguided attempt to develop their full potential for success, students at a German university are forced to participate in a campus chess "game" in which they are the pieces and the captures could consist of murder. Updates Sundays.', False, True)
add('CloeRemembrance', 'http://cloe.smackjeeves.com/comics/', u"This story is set in the victorian era. Liam is an 11 year-old boy that arrives to a wealthy mansion to work with his father, the gardener. In this place he is asked to be the playmate of the youngest master, Edward, who's about his age. However, Edward turns out to be a spoilt and malicious kid that wants to keep all the attention to himself... What will Liam do to gain his trust and become his friend? ---------------------------------------- This is a young love shounen-ai (boy/boy) Manga format: *Please read from right to left* THIS STORY IS ALREADY FINISHED!", False, False)
add('Codename', 'http://codename.smackjeeves.com/comics/', u'Una historia de drama, acci\xf2n, misterio, y personas con graves problemas psicol\xf2gicos.', False, True)
add('ColorBlind', 'http://cbcomic.smackjeeves.com/comics/', u'Five 13-year olds discover a world that makes theirs seem grey in comparison in a closet at their school. It is a world of magic, and adventure, and a war that the kids might have gotten sucked into accidentally. Main Site: http://colorblindcomic.com/ Updates are Mondays and Fridays.', False, True)
add('ColorfulLifeofanArtMajor', 'http://cloaam.smackjeeves.com/comics/', u'Follow Kyle, a recently graduated Fine Arts Major, throughout his life as he deals with the pressures of being an Art Major. Updates sporadically', False, True)
add('Comatose', 'http://comatosecomic.smackjeeves.com/comics/', u'In this drama sci-fi webcomic, paranoid teenager Jack Phoenix gets entangled with forces far beyond human imagination. Comatose deals with several themes such as coming-of-age issues, love, lost, hopes and dreams, drugs and violence and realization of one\u2019s purpose in life. Updates every Wednesday and Saturday. Official blog: http://comatosecomic.com', False, True)
add('ComedySilver', 'http://comedysilver.smackjeeves.com/comics/', u"There is comedy that surpasses all other comedy. The comedy gold. Many strive for it, only a few ever obtain it. For those many that don't succeed, there's always silver. A Neurotic Thunder comic \xa9Ingrid Doering / Gabu", False, True)
add('ComicFullofSprites', 'http://cfos.smackjeeves.com/comics/', u"Sonicstar4453: im slowly making my way back to spriting dont worry guys ;) TwilightMasterX: alway make a sun to know how to use shades (he gave up on SJ ;-;) Sonicballzx:If you need a friend, I'll be there. Need some help, just call me up, I'll help you in no time. TheProjectCore: IMMA TAKE OVA URE SOUL BRO!!! Smash: Am I supposed to write something here? Senalcoolage: Wait this is not a comic and not a showcase CamTro: Would someone order a Sprite food for me? Guilmon157:So...where i get my freaking cookies? _Accel_The_Hedgehog_:I'M GONNA GET YOU, YOU GERMAN BASTARD! Draven22: Give me a fox and an backstory and i'll give you a sprite Pocket_Ninja: WHO ARE YOU PEOPLE?! Jameswolf100: Spriting is for squares because it is squares. Darkus the Hedgehog: Er, I may not seem good now, but wait till I fully learn edits and customs... Ceviana: Don't be afraid to ask for help >:3\\ Pyrus: (no comment) MR sonicrouge: Decent spriter wants to see peoples happy. I'm always busy but feel free to request rules : 1. No trolling, flaming, or stealing of any kind. 2. Only give positive advice. 3. Don't die on us. lol we died alrdy but were coming back baby!! >:D", False, False)
add('ConplicatedGeodeCornerFinal', 'http://conplicated.smackjeeves.com/comics/', u'When sarcastic but charitable Amber Pennicastle follows a handsome panhandler to his secret hideaway, her life turns upside-down in this action/romantic comedy.', False, True)
add('ContraandtheSpamDump', 'http://kirby-and-friends.smackjeeves.com/comics/', u"Well, this comic is basically my art spam dump, that doesn't really have a place. And also all the old Kirby and Friends comics if you're interested in those.", False, True)
add('Contradiction', 'http://contradiction.smackjeeves.com/comics/', u"THIS MANGA IS READ FROM RIGHT TO LEFT (Updates every FRIDAY) Ruya Saki received an invitation to attend Teiou Gakuen in Setsuyamachi, a town for magic users. Not knowing the reason why she was invited, Ruya headed towards the mysterious town. A choice between Light and Darkness... an enthusiastic president and his rival... 'Contradiction', the story of Light and Darkness magical users, the story of friends, betrayal, hatred, past, loyalty, revenge, endurance and love.", False, True)
add('ConventionalWisdom', 'http://conventionalwisdom.smackjeeves.com/comics/', u'Ever wondered what goes on inside an anime convention, but are too afraid go anywhere near one yourself? Well, wonder no more! Conventional Wisdom is a comic that shows you what this strange, geeky world is really like, based ENTIRELY ON REAL LIFE! ...well, sort of. (Currently moving over from DrunkDuck, so please be patient)', False, True)
add('Cramberries', 'http://cramberries.smackjeeves.com/comics/', u'Lucinda is just a normal girl who lives with her roommate in an apartment... until her childhood friend came back to visit here. Now, she has been cursed with a demonic eye and almost everyone seems to be after her. Could it be her eye that everyone is after or is it there something more to it? Follow Lucinda and her friends as they uncover dark secrets and traverse their way along a perilous journey filled with all manners of action, humour, evil and good, love and stupidity. Updates are now Mondays and (occasionally) Thursdays! KitKatMuffin: Artist and Creator Seranatis: Editor and Assistant', False, True)
add('CrappilyDrawnMinicomics', 'http://cdminicomics.smackjeeves.com/comics/', u'Welcome to see the antics of Rob and Ian in their increasingly derpy day-to-day lives. Takes place in London 1999. Drawing and handwriting quality will range from semi-good to utterly crappy. Enjoy :)', True, False)
add('CrayonComicStory', 'http://crayoncomic.smackjeeves.com/comics/', u'A drawing comic about anything. If you REALLY must swear, censor it please. Violence is allowed, but not nudity or swearing.', False, True)
add('Created', 'http://createdtolife.smackjeeves.com/comics/', u'Mewtwo was created by Dr. Prower as just a first attempt to create a life form, but Dr. Robotnik wants him to be more than just a "Creation." Which path will Mewtwo choose? The good or the evil? >Completed<', False, True)
add('CupidsaMoron', 'http://cupidsamoron.smackjeeves.com/comics/', u"As the legends say, people's lives have always been handled with care by the Greek Gods and Goddnesses. Ever since, Cupid has been in charge of the mortals' Love. But can a 18-years-old-looking boy really deal with other's destiny ? And what will happen when he will have to help Seth, a 23-years-old loser, find his true Love ? Huge problems ahead... Beware. Following this comic would force you to face a twisted and apocalyptic mix of BL, butchered Mythology, crappy humor, cheesy moments, less-cheesy moments, crazy scenes, general weirdness, and unhealthy amounts of cakes. Authors will not be held responsible of any harm caused to you or any thing or person surrounding. Pursue at your own risk. Irregular updates, we'll try twice a week (read right to left <--) Story & Characters - by M-iikado Art - by Sybia French version can be found here : http://cupidsamoron.webcomics.fr/", False, False)
add('CurseLineage', 'http://curselineage.smackjeeves.com/comics/', u'Read from right to left. Ayla Exonuke, A young Yuzcazi is being chased by the Kirimangalou Empire, They think she is the last one of a long-lost lineage. Together with her brother Kokei (not related by blood) They try to survive to the empire attacks and any other things that get in their way. Genre:Action,Adventure,Fantasy. release schedule: Thursday.', False, True)
add('Cybertech', 'http://www.thecybertechproject.com/comics/', u'An epic scale space opera. War, politics and human drama take center stage in an ever expanding story. The culmination leads humanity and its allies to the Andromeda galaxy to end the tyranny of Emperor Dalzhi of the Warcon Empire and his countless millions of warships. Official site www.superzentredi.com', False, True)
add('D00R', 'http://www.storyofthedoor.com/comics/', u'A pug falls into a toilet, thus releasing a rather snarky genie who had up until that point been bound body and soul to the extremely scummy receptacle.', False, False)
add('DBON', 'http://dbondoujin.smackjeeves.com/comics/', u'An 8 issue long crossover manga of Shounen Jump classics, Dragonball Z, Bleach, One Piece and Naruto. that i did a little while back as something iv always wanted to do/see, and also practice for my own original long running manga Ryak-Lo (Reads Right to Left) this is a fan comic, all characters belong to their respective creators.', False, True)
add('DDSR', 'http://ddsr.smackjeeves.com/comics/', u'A sprite comic that has no Sonic sprites! Seriously, all customly done. Join two friends and there crazy adventures involving demons, robots, explosions and shiny things.', False, True)
add('DOUBLEK', 'http://doublek.smackjeeves.com/comics/', u'Miami Vice meets Gurren Lagann in the most explosive, high-octane buddy cop comedy in the HISTORY OF POLICE and/or INTERNET FAN COMICS', False, True)
add('DanielleDark', 'http://danielledark.smackjeeves.com/comics/', u"Danielle Dark is a vampire trying to make it in the mortal world. It isn't easy, and she is discovering that she is different than other vampires in many ways.", False, True)
add('Darkkyosshorts', 'http://darkkyo123-shorts.smackjeeves.com/comics/', u'Just some short stories by me. They very in what there about. The stories are form 2009 to the present.', True, True)
add('Darkoly', 'http://darkoly.smackjeeves.com/comics/', u'The STORY... It all began when a mysterious "Lightstream" enters the world and within a month passed,mysterious portals/gateways started to appear from nowhere.Unknown creatures and beings begins to surface and in just a short period of time the world just turned into a massive hunting ground to the "possessed".', False, True)
add('DavidDoesntGetIt', 'http://daviddoesntgetit.smackjeeves.com/comics/', u'A diary comic of me and my three siblings.', False, True)
add('DaysGoBy', 'http://daysgoby.smackjeeves.com/comics/', u"YAY! my first comic! but i must warn i'm not know for my consistence so this may not get update for lengthy periods.. PLOT: It's a furry comic about Trixxie living her life, hanging with friends, working, and trying to find that special someone... WARNING! Boys Love, Girls love and hetero", True, True)
add('DeadFishComics', 'http://watghosthunter.smackjeeves.com/comics/', u"I just put random comics I draw here. Mostly: Fancomics (Tiger and Bunny, video games etc) Also: a lot of original comic series: Adventures of a Supervillain In Love: Mad scientist meets guy who won't take off his helmet. Love ensues! Moira Adventures: girl get new job, meets crazies. Wat Ghost Hunter: Guy gets stalked by ghost who wants to take him to Tim Hortons. Succubooks: In a videogame world the tale of a man and his succubus/incubus/book. Pretty much anything could end up here. Contains Bl, yaoi, M/M sex, and nudity of both sexes.", True, True)
add('DeadLine', 'http://deadline12.smackjeeves.com/comics/', u'16 year old girl, goes to school, hangs out with friends, two loving parents and works for the department of death. Where all her jobs have a "deadline" Oh, there\'s also some yaoi/yuri in it, but later in the comic, you\'ll see. I also recommend that if your under the age of fifteen that you would discuss this with your parents due to sexual content and graphic violence', False, True)
add('DeathNoteIridescent', 'http://dn-iridescent.smackjeeves.com/comics/', u'Iridescent: Producing a display of lustrous, rainbowlike colors. Completed. Extra chapters in the making~', False, False)
add('Debtsettlement', 'http://debts.smackjeeves.com/comics/', u'Character info and much more can be found at: http://sites.google.com/site/debtsettlementcomic DEBT SETTLEMENT " Samantha is 14-year-old girl with little to no hope for her own future. Her mother is an alcoholic in a debt trap and after getting even Samantha in to trouble because of her own mistakes, the only people who can help the girl now, are on the side of the family Samantha didn\'t even know existed. Problem is, does she really want their help? " DEBT SETTLEMENT:RUNAWAY BROTHERS " 27 pages long spin-off which will reveal you how did Kiran and Deepak, the brothers from a super religious Aditya family ended up working for RSS. "', True, True)
add('DemonEater', 'http://demoneater.smackjeeves.com/comics/', u'A cannibalistic world where the inhabitants only food is each other.', True, False)
add('DenizensAttention', 'http://denizensattention.smackjeeves.com/comics/', u"Alicka and her little brother Winston are sent to Winterkill Boarding School. The number one dumping ground of unwanted troubled teens. A miniature Gormenghast filled with bad seeds and black sheep. +++++++ Winterkill: to kill by or die from exposure to cold winter weather. ++++++ This comic will update when i can. i'm trying for once a week, but not always managing. ++++ Denizens! Attention! how has its very own tumblr http://confessionsofawannabecomicartist.tumblr.com for updates, news and random comic making thoughts and sketches.", False, False)
add('DepthsOfMyEmptySoul', 'http://depthsofmyemptysoul.smackjeeves.com/comics/', u"Zadel, demon prince of Hell 7, struggles to prove himself to his mother and all who he's destined to rule over. The source of his struggles? His arch rival, yet best friend, Angel Abel. The truth is, Zadel rather spend his time enjoying Abel's company than act like the future ruler of Hell 7 and meanwhile other demons have their eyes on the throne. Zadel is being pressured to change his behavior and become a cold and respectable demon prince worthy of inheriting the throne, something that promises to put his friendship with Abel to the test. Will he finally make his final decision and chose his role as demon prince over his friendship with Abel? One night when Zadel's feeling bored and yearning for the company of Abel, he decides to pick on a down on his luck human. He tries and succeeds in persuading the human, Jacob, into making a bet with him wagering his own soul. Soon he realizes that picking on Jacob was not such a good idea. Bickering, jealousy and some romance ensues as Zadel and Abel both battle to doom or save Jacob's soul. But another more threatening battle approaches as well. BL, GL, HL Art improves over time.", True, True)
add('DevilTrainee', 'http://deviltrainee.smackjeeves.com/comics/', u'When devil trainee Dan come to the human world, bored of his life, he decided to have fun with some stupid human, finding Lucy, a 16 years old girl who lives alone and loves MONKEYS! What will happen when both of them meet? Read from right to left!!! Please, comment. That will motivate me to follow drawing the manga ^^', False, True)
add('DevilTraineeSpanish', 'http://deviltraineespanish.smackjeeves.com/comics/', u'Cuando el demonio en pr\xe1cticas Dan viene al mundo humano, aburrido de su vida, decide divertirse con alg\xfan est\xfapido humano, encontrando a Lucy, una chica de 16 a\xf1os que vive sola \xa1y a la que le encantan los MONOS! \xbfQua pasar\xe1 cuando ambos se conozcan? Leer de derecha a izquierda Por favor, comentar. Eso me motivara para seguir dibujando el manga ^^. NOTA: Al ser esta pagina en ingles, los acentos no se ven en los comentarios. Es horrible porque yo siempre los escribo >_< y tendre que acostumbrarme a no hacerlo T_T', False, True)
add('DevilsCake', 'http://devilscake.smackjeeves.com/comics/', u"When Kea finds that her bad luck with boys isn't a 'what' but a 'who', will her sanity survive the IN-sanity that ensues? PG-13 Currently Updates every MONDAY & THURSDAY", False, False)
add('DevotoMusicinHell', 'http://devoto.smackjeeves.com/comics/', u"This is the story of how the now-fallen Principality of Music, formerly an angel of some repute, was given an opportunity to provide inspiration for one working man desperately in need of a muse. Other angels, fallen and not, are further compatriots, such as Devoto's surprisingly sympathetic boss and the armadillo aficionado commonly known as Sloth. Though the divines are great, and in some cases terrible, each is coming to appreciate the value of a uniquely human connection. (Gag, right? The important thing is that Guys Make Out. Guaranteed.) Warnings for: - Explicit gay content - Blood/Gore (but not in sexual contexts) SJ Note: I understand SJ policy, and thus it's worth noting that this comic does not and will not portray sexual situations with minors or individuals who appear to be minors. Furthermore, this comic will not portray non-consensual (or dubiously consensual) sex.", True, True)
add('DigimonSaviors', 'http://digimonsaviors.smackjeeves.com/comics/', u'.:THE ALMOST ORIGINAL:. When 9 children are mysteriously transported to a new world, they come across strange monsters called Digimon. These digimon help them survive the digital world as they try to do anything possible to find an escape from this world... ------------------------------------------------------ After defeating the D-reaper in the Real World, a vision was shown to Neroe and Agumon that the digital world was in danger. Upon returning there, they learn how much trouble they set themselves up for exactly. How will the digidestined fight this ultimate threat? Find out on Arc 5 of Digimon Saviors! Neroe - Agumon Shard - Gaomon AnXjak - Crabmon Ankh - Gotsumon Marly - Impmon Beth - Hawkmon Neo - Guilmon CD - Wormmon Radd - Renamon Van - Veemon anime.... in... space', False, True)
add('DigimonTamersMiraiProject', 'http://digimontamersmiraiproject.smackjeeves.com/comics/', u"Its been 6 years after d-reaper accident. a stable battling system is created by the goverments for digimons and tamers to direct their fighting instinct, and so that the accident didnt happen again. but is it their only purpose? the tamers knew something was wrong, and they want to find out what. thus digging deep into goverments dark secrets... ------------------------------------------------------ A revamp ver. of my doujin at Digimanga.deviantart.com. But as for now they'll all still conceptual... A project for local doujin publishing (hopefully =w=u) but in the meantime, hope you guys can comment on what can be comment on (story, paneling, angle, pacing...)", False, True)
add('DigitalStoryadigimoncomic', 'http://o0digitalstory0o.smackjeeves.com/comics/', u'Four teenagers get transported to the Digital World one day. They were best of friends on Earth, but can their friendship survive in the Digital World? Will they be able to stop an evil army of Tamers? Will one of them even find a partner? This is Digital Story. .:Updates happen Tuesday and Thursday:.', False, True)
add('DiscoveryATransformersAnimatedfancomic', 'http://discoveryiscrescendolls.smackjeeves.com/comics/', u'"It\'s a story about four losers and their cat." "Discovery" is a Transformers Animated fancomic. It is an AU "what if" tale if Prowl took up Lockdown\'s offer in "A Fistful of Energon". Yeah, yeah, it\'s been down, but I want to do one. The comic centers on bounty hunting team Crescendolls (named humorously by Wreck-Gar) composed of leader Lockdown, ninjabot Prowl, team pet Skippy the cat, crazy loon Wreck-Gar, and smart guy Perceptor as they get into misadventures and just discover their personal demons. A good knowledge of the canon TV show is required as I will be referencing it a lot. The genre is romance/drama/comedy.', False, True)
add('DoctorWhoSpamAndDiscussion', 'http://whovianpostingplace.smackjeeves.com/comics/', u'Where the few whovians of Smackjeeves unite to post doctor who stuff. alsospecialweaponsbestdalek', False, True)
add('DoodleBeans', 'http://beans.smackjeeves.com/comics/', u'No arms? No legs? No problem! Superheroes, Tentacle Monsters, Video Games, Violence, and PLOT!? If you like it, please comment and +favs Comic updates Monday-Friday at Midnight (PDT)', True, True)
add('DoodlingAround', 'http://doodlingcomic.smackjeeves.com/comics/', u'', False, True)
add('Dragonet', 'http://dragonet.smackjeeves.com/comics/', u'A wizard tries to raise an orphaned dragon in a world filled with fantasy, magic, war, and adventure. He soon finds out a dragon does what it wants...and he may make all the difference.', False, True)
add('DrawingParty', 'http://drawingparty.smackjeeves.com/comics/', u"** Congrats to our first prize winner of our Mascot contest, GunboyComics! In the banner is our new mascot, Sketchy! ** Are you stuck on ideas for things to draw? Are you just starting out and need practice and want to show the world? Well, no need to look any further! Comic artists gathered together to help eachother battle comic-artist's block! Every month there will be a new theme listed, you can either post a drawing or a comic strip based off of the theme. Since this is my first time putting a group together, the rules may be changed or added if things become out of control or to improve the group so that everyone has fun! :D * REQUIREMENTS * -- Some type of drawing instrument or any computer software! -- No experience necessary! :D * RULES * -- Must be drawn by hand or computer. -- Follow the theme topic for the month. -- The comic can be for anyone at any skill level! Which means any style, manga, american, realism, and anything in between! -- Be supportive! -- Be creative and have fun!", False, True)
add('DreamAboutMe', 'http://dam.smackjeeves.com/comics/', u'One year. That is how long Popuri will be staying at Green Ranch while her parents are away. And in that one short year, her life will change forever! Based on the game Harvest Moon 64', False, True)
add('Dreamcatchers', 'http://dream-catchers.smackjeeves.com/comics/', u"Motsury Sohiru has been suffering from nightmares from long time, but one day fate drives her to a shop, where she finds a dreamcatcher. It would be all nice, but she hasn't got enough money to buy it, so she decides to steal it, but it get soon to an enemy of her, and when Sohiru get it back it is already broken. The next night she gets into a nightmare again, and the dreamcather brings it to the real world with a boy who saved her in the dream. But what can she do with this stranger? And what will happen after dreams and dreams? It will turn out from the manga...", False, False)
add('DressedForSuccessRetro', 'http://dressedforsuccess.smackjeeves.com/comics/', u"Alex Corbett and Walter Andrewkowski, two guys thrown together by chance, now making their way in a crazy universe one adventure at a time. All the while trying to stay one step ahead of the mafia and with the hopes of turning a profit. These are their original adventures, first published in the 1990's as black and white mini-comics.", False, True)
add('DungeonHordes', 'http://dungeonhordes.smackjeeves.com/comics/', u'In 1986 Dungeon Hordes was released on the Playtendo and moved 1 million units world wide which is way more successful than its previous release on the Batari 2200 in 1979. Now in 2011 Dungeon Hordes has returned bigger and better than ever with mind numbing graphics and all new enemies to fight. So how do the characters in game feel about this? Only time will tell. Enter the lives of Tiggz and Tomes, two level 5 bosses tired of being easily killed by player 1 and wanting the glory of finally becoming more than just petty bandits. Will they survive the new creatures that the mighty programmers have added to the game? Will they ever kill player 1 and move up the mob boss ladder? Will they ever get a raise from their uptight dungeon boss Kalakis and finally pay off their ale tabs at the Stinky Dragon Inn? Stay tuned and find out..... Will be updated Every Monday, Wednesday and Friday. Dungeon Hordes Facebook http://www.facebook.com/pages/Dungeon-Hordes#!/pages/Dungeon-Hordes/195568970460655', False, True)
add('EATATAU', 'http://eatatau.smackjeeves.com/comics/', u'', False, True)
add('ECshomeofrandomentertainment', 'http://echore.smackjeeves.com/comics/', u'Kind of like "Sandbox", I post random things here including but not limited to: Photographs Comics Screenshots Storys Advertisements Sprites Drawings', False, True)
add('EDepthAngel', 'http://edepth.smackjeeves.com/comics/', u'In the future, even machines will need an angel, and one girl is there to fill in that job position, her name is Angel Love; and her dream will cause a whole cyborg city to erupt into a massive gang war. Update Every Weekday (M-F)', False, True)
add('ERAConvergence', 'http://convergence.smackjeeves.com/comics/', u"UPDATES MONDAY AND THURSDAY! The Darkwood corporation is in jeapordy if Velias doesn't manage to retrieve evidence stolen by a pesky rebel rat. He decides to hatch a plan to kidnap the rebel's clueless little sister, but finds that more difficult than he thought...", False, True)
add('ERRORERROR', 'http://errorerror.smackjeeves.com/comics/', u'A finnish teenage boy Tomi is a normal nerd. He plays videogames and gets average grades, but also is terribly bored with his life. But one day he accidentally gets inside of his computer and meets there a girl, who calls herself princess Jooda. And there is a profecy about Tomi, sword and Viruses. Warnings: If you are under 13 years old, I do not recommend this comic to you. Contains bad language, blood and somewhat sexual themes. ps. This started out as a test for new tablet, so the start looks like that too. Also, sorry about the style changes, I practice. Updates 2-4 pages a week.', False, False)
add('EVA303', 'http://eva303.smackjeeves.com/comics/', u'Evangelion 303 imagines an alternate-universe where the characters of "Neon Genesis Evangelion" are defending our modern world in a post-September 11th age.', True, True)
add('Eirinngobrach', 'http://eirinn-go-brach.smackjeeves.com/comics/', u'In the lands of the emerald isle lies mythical, fanciful, and sexy creators of folklore; and little sexy Leipreach\xe1n Saoirse and her friends are about to learn not everyone seeking the end of the rainbow is after the same pot-o-gold.', True, True)
add('EmeraldNuzlocke', 'http://giginuzlocke.smackjeeves.com/comics/', u"Yes, another Pokemon Nuzlocke to infest SmackJeeves. Done on Pokemon Emerald (since I haven't played the Hoenn games in forever D: ). I've been meaning to start a Nuzlocke that I'll stick to o3o This Nuzlocke follows the adventures of Gigi, a human who has lost her memory and wound up in Hoenn region. ********** COMPLETED! Part 2: http://giginuzlocke2.smackjeeves.com", False, False)
add('EmeraldNuzlockeAdventures', 'http://emeraldnuzlockeadventures.smackjeeves.com/comics/', u"Jumping on the bandwagon with my first nuzlocke and my first webcomic. For those who are unfamiliar with what a Nuzlocke is, here are the rules: 1.) Pokemon that are KO'd are considered dead and must be permanently placed in a box or released. If all your Pokemon in your party die (aka you whiteout) you lose. 2.) You are only allowed to catch the first Pokemon you find in each route. If you kill it or run away, you are not allowed to catch anymore Pokemon in that route. This includes fishing. (Shiny Pokemon are exempted from this rule because they're cool) 3.) You must nickname every Pokemon you catch. 4.) No legendaries. 5.)No Day Care Center", False, True)
add('EnkeltenKentta', 'http://enkeltenkentta.smackjeeves.com/comics/', u'Enkelten Kentt\xe4 a.k.a Field of Angels YAOI WARNING The gates of hell are open, but there are no angels to fight the demons rising from the core of nightmares. So, artificial "angels" must be created to protect the field that angels no longer watch. Sakari Kauria is one of these unholy creations of the hand of men, but he did not know any of it until one faithful meeting with a demon...', True, True)
add('Entreeuxdeux', 'http://entreuxdeux.smackjeeves.com/comics/', u'"Entre eux deux" est une bande-dessin\xe9e amateur qui sent bon la poudre, les fusillades et la mafia, mais qui en fait se pr\xe9occupe plus des deux destins qui y ont difficilement trouv\xe9e leur place. Deux \xeatres que tout s\xe9pare, mais finalement pas tant que \xe7a... Je poste les pages par quatre (quand j\'y arrive) tous les 15 jour, le dimanche. Merci \xe0 tous ceux qui passent par ici. >w<', False, True)
add('Entuthrie', 'http://entuthrie.smackjeeves.com/comics/', u'A story about personages in turmoil, and the coincidences that follow. Taking steps forward, one (en), two (tu), three (thrie), is the way to reach to a conclusion. or, kitty-eared girls and gay librarians ride together with giant insects to chase a sadomasochistic lesbian pirate, the comic.', True, True)
add('EonsAgo', 'http://eonsago.smackjeeves.com/comics/', u'Eons Ago is a doujinshi to the popular Transformers Prime series, which inflicts the story of how the beloved Master and SIC met, Starscream and Megatron. How did Starscream become Megatrons second-in-command? What made them fall for eachoter? The series was first uploaded on DeviantArt in september 2011, and is still ongoing today. It has reached up till 11 chapters and is still ongoing. Eons Ago contains parental advisory material as well as humor, love and gigantic transforming mech Cybertronians.', False, False)
add('EvilPlan', 'http://evilplan.thewebcomic.com/comics/', u"Evil Plan takes the superhero world and flips it, viewing things from the supervillain's perspective. The story follows Dr. Kinesis' journey on the road to world conquest. On the way, he'll have to deal with a troublesome AI, his unwilling friendship with crazy black-market dealers, and the possibility of romance with his second-in-command. And the superhero. Can't forget that guy. With all this going on, Evil Plan is a comic for people who want to see the bad guy win. If he doesn't blow himself up first. Story and Line Art: Alexis Royce Color: Megan Johnston, Chelsea Capobianco Updates: Every Monday", False, False)
add('ExperimentalMegaman', 'http://ex90081.smackjeeves.com/comics/', u"Distant in the future, a weapon of mass destruction is created to destroy all Megamen- A maverick more powerful than any of them. As the ninth prototype is created, it's creators take it for a test run. Aparently though, there are a few bugs in his system... .:Updates on Mondays and Friday:.", False, True)
add('Exploit', 'http://exploit.smackjeeves.com/comics/', u"Akitsu Yorukishi. Purple hair, glasses and headphones. He's not really interested in catching them all, being the best trainer or being famous. His life would be normal if he just didn't meet...her. Who cares about medals, when you have to SURVIVE. -- Extra tags: pokemon doujinshi manga anime", False, True)
add('EyesofaDigimon', 'http://eoad.smackjeeves.com/comics/', u'A fictional Digimon manga about a boy and a unique Digimon. Based off the series by Akiyoshi Hongo.', False, True)
add('FailureConfetti', 'http://failureconfetti.smackjeeves.com/comics/', u'Failure Confetti is a webcomic about life, words, science, games, and human observations. Updates weekly, on Wednesdays.', False, False)
add('FalconersDailyStrips', 'http://falcdaily.smackjeeves.com/comics/', u'Daily comic strips I throw together with little effort just for funzies.', False, True)
add('FallenAngelslove', 'http://fallen-angels-love.smackjeeves.com/comics/', u"A cute BL story No smex for awhile sorry! :D Hiro and Taisuke have known each other for many years, they have been friends for as long as they can remember. However, Hiro is a demon who is fated to be locked up for all his life and Taisuke is an angel who's a bit of a play boy. What will happen when Hiro begins to long for freedom so much he would do anything to obtain it? When Taisuke realizes that his feelings for Hiro are a bit more than friendship will he run away or embrace those feelings? When heaven and hell clash how could such a love be accepted? Sounds cliche but I promise it will be a enjoyable read XD", False, True)
add('FarOutMantic', 'http://meteorflo.smackjeeves.com/comics/', u'a kinda large comic this time. about love, creativity, music and discos!! just a fun comic really, nothing too perpelxing. have fun!!~', False, True)
add('FarOutThere', 'http://faroutthere.smackjeeves.com/comics/', u'A manga-esque Sci-Fi Comedy. Far Out There is the webcomic where things happen... IN SPACE!!! (currently being transfered over from DrunkDuck, so pardon the mess)', False, True)
add('FarewellFeeling', 'http://farewellfeeling.smackjeeves.com/comics/', u"new page posted every Saturday. reads R-to-L. ----------------- S Y N O P S I S Grief hates her job. She thought it would be romantic to be the human emotion for sadness -- instead it's nothing but heartbreaking. so she quits. and while she thinks she is giving her human, Ellison, a great gift by quitting, it is really just the opposite... ---------------- Farewell Feeling explores what would happen if our emotions....had emotions. the six basic human emotions of Grief, Joy, Anger, Surprise, Fear and Love are all personified, each with their own hopes, dreams and problems. -------------- note: I also take manga/comic sequential page & illustration commissions. Farewell Feeling is not entirely representative of the quality of such work, since it is done just for fun/for myself. please email me if you are interested, and I can provide you with other samples. lilyhanamail@gmail.com -------------- if you're interested in my other work, please visit: http://rain-and-sunshine.deviantart.com thanks for reading!", False, True)
add('FariesSoul', 'http://fariessoul.smackjeeves.com/comics/', u'Kairi is a regular school girl who finds out she is the reincarnation of the farie prince and has to find the four elemental faries in order to restore the farie king and save the farie world! I started this comic a few years ago so the art will improve as the story goes on. Content Warning: There are both bxg and bxb relationships', False, True)
add('FeathersPI', 'http://featherspi.smackjeeves.com/comics/', u'Feather Von Muse was born over 300 years ago and in the last 30 yrs she has been a Private Investigator and an assassin with her partner Diki. They hunt down demons, vampires, and the likes to keep their city safe. GL/BL in this comic. Dont like. Dont read. Enjoy!', True, True)
add('FierceConflict', 'http://fierceconflict.smackjeeves.com/comics/', u"For years, a war devastated the planet called Sapton. The conflict began with a group of rebels who were dissatisfied with the laws of this world attempted a world wide coup d'etat. They slowly gained power and eventually overwhelmed the majority of the opposition and are slowly but surely taking control of the world. Out of this group of rebels 5 have taken full authority and are now attempting to lead the world down the path of darkness.We follow the story of a koopa named Zuke who lost his family and homeland in the war. He travels the world in hopes of finding a way to bring peace. All sprites belong to their respective owners.", False, True)
add('FireEmblemEternalSouls', 'http://eternalsouls.smackjeeves.com/comics/', u'FIRE EMBLEM COLLABORATION! This is a Fire Emblem Collaboration by the people on FE-DA (www.fe-da.com/forum) about an alternate world of Fire Emblem, which we create OCs to conquer the darkness and save their precious homeland of Thalassa. SPOTS ARE CLOSED! I hope you will enjoy our creation! <Vikki>', False, True)
add('FireWire', 'http://firewire.smackjeeves.com/comics/', u"When Kennedy H'naka's cell phone becomes the new home of the dragon FireWire Balisk, she finds herself sucked into a world of battles, secrets, and shadowy organizations. What's a girl to do when she has to save the world and still pass the tenth grade? Updates: Thursdays Reads: left to right. Comments greatly appreciated ^^ Please check out the new FireWire group on dA: http://firewire-connection.deviantart.com/", False, True)
add('FireredLisasReise', 'http://lisasreise.smackjeeves.com/comics/', u'This comic is a Firered Nuzlocke run. Lisa, a young girl from kanto starts her journey to become the Pok\xe9mon master. Updates Sundays! Also visit my tumblr account and ask Leaf questions! http://lisa-leaf.tumblr.com/ Laufente has helped me with the coloring until page 63, but I figured I should learn how to do backgrounds and attacks myself so I will do it alone from now on. Laufente has her own Nuzlocke as well so please look at Road to Glory as well :D', False, True)
add('FiveHouses', 'http://fivehouses.smackjeeves.com/comics/', u"The Houses of the Alliance, led by the Angels of Rosenheim, produce interesting people with even more interesting abilities. When the crown is in a predicament that their heir cannot hope to tackle on his own, it's time to call in the cavalry from the Houses to get the job done. Yet these men are all at odds with each other. Will they be able to find harmony? Will they be successful in aiding the Prince? More than that, will they be able to find love? Rated NC/18 for violence, gore, nudity, sexual situations, baaad Catholic jokes WARNING: Male/Male, Female/Male, Female/Female, People/People relationships are a common theme in Repsychus's comics. If you cannot handle any of these, please go elsewhere. Thank you. Updates: start October 2012, 1/week (Friday or Monday) Art and Story (c) Repsychus Special thanks to blankd and eishiya <3 Check out the ASK/UPDATE blog: http://fhask.tumblr.com/", True, True)
add('Flashback', 'http://flashback.smackjeeves.com/comics/', u"Following the life of some unknown dutch dude in this journal comic. Through the true tales, the less true tales and the made up stories that simply don't make sense. UPDATED 5 DAYS A WEEK Welcome, to FLASHBACK.", False, True)
#add('FootLoose', 'http://footloose.smackjeeves.com/comics/', u'Beware, some strong language! Aki is sick of having fake friends who are only after his money and his looks, so what better to do then start at a new school, with a new personallity... and gender, sort of. Some shoujo-ai and shounen-ai involved. PAIRINGS, phycotic bullies, and gender confused guys, what more could you ask for? Updates Daily Art: Alycia Cover art and story: Me General page colouring and Inking: A joint effort ^^ read left to right', False, True)
add('ForcedSeduction', 'http://forced-seduction.smackjeeves.com/comics/', u'"Can you make the next person walking through this door fall in love with you within a month?" "Sounds easy." BL!!! I apologize for the lack of creativity and the super sketchy outlines. I\'m totally being forced XD (Just kidding) Oh, and English is not my first language. It\'d be lovely if you could help me to improve ;) (meaning correct me please XD) Better read from right to left ;)', False, True)
add('ForestHill', 'http://www.foresthillcomic.org/comics/', u'Life happens.', False, False)
add('ForgettheDistance', 'http://forgetthedistance.smackjeeves.com/comics/', u"(There's a little smidgen of nudity at the beginning but then it's smooth fluff sailing from there until...chapter 4? yeah, i think so.) Includes THEMES of BL/Yaoi/BoyXBoy: Logan's mother hasn't had a good eye for good men since his father went missing so when Brian comes along, he is automatically disliked. Any man who his mother brings home receives the same treatment: sarcasm,pranks and vile language. But unlike the others, Brian doesn't give up. He doesn't leave. Doing so earns him some respect from the teen and even though they begin to get along,the competition continues. They both love her dearly and neither will give up the game. Brian won't lose to a child such as Logan, and Logan won't lose to a man such as Brian. In the end are they really competing for his mother's love or for each others? Who will lose? Joint with my sister: Juli(AUTHOR/CO-ARTIST), Somi(ARTIST) UPDATES: We've gotten it down to about one every week...normally....if not within two. We're back on schedule cause we're free and hopefully drawing more.", True, True)
add('ForgottenPlanet', 'http://forgottenplanet.smackjeeves.com/comics/', u'Lost on the last planet in the galaxy, Gary and Dani try to find themselves on an alien world.', False, True)
add('Fortheloveofabrokenstring', 'http://fortheloveofabrokenstring.smackjeeves.com/comics/', u"while waiting at the park Hyunjin meets a strange man who seems to look like the man in her dream, only to find out later that he's a fox demon?! Now finding she has a connection to this Fox Demon, she sets out to find his story while slowly finding out her own. What is their connection? Why does her grandfather try so hard to not let them interact with each other? What was the meaning to her dream?", False, True)
add('FourTales', 'http://fourtales.smackjeeves.com/comics/', u'A horror/fantasy/whatever comic. Your pick.', False, True)
add('FoxpuffsSpriteandSpamStuff', 'http://spriteandspam.smackjeeves.com/comics/', u"Here's where I post random stuff, like sprites and other things. Because I'm getting better with sprite making, I might do sprite requests, too. I'm getting even better now so I'll be able to do more complicated requests, but only with foxes currently. I can't do hair yet, so don't bother asking for that. Also, when requesting for sprites you have to be specific or I'll get confused. Also, any plots that only involves my characters go here until further notice.", False, True)
add('FramebyFrame', 'http://frame-by-frame.smackjeeves.com/comics/', u'COMIC WILL POTENTIALLY UPDATE ON SUNDAY, TUESDAY, OR THURSDAY. DAYS ARE RANDOM BUT THESE ARE THE MOST LIKELY. "He\'s only as straight as his company. For all we know, he\'s a Slinky right now." The hostility between our two lead comic artists is slowly dissipating but lots of things are changing for our little group in general. Many are moving, some are having revaluations about their life, but nothing is going to stop them from enjoying the Halloween Party at the DVDungeon. Volume 2 of Frame by Frame has it all; ghosts, romance, and angry ex girlfriends to boot. +Alex is at his wits end with Tai, his ex-girlfriend and live-in roommate. Has the time come to move on, both physically and emotionally? Maybe something new would do him wonders. +David continues to work hard in both his work and establishing his life there in Poulsbo. He\'s gaining courage to do something impossible with high hopes of it being possible. However, it\'s unknown if it\'ll be a good idea in the end... --WARNINGS-- +The typical warnings: cursing, nudity, normal looking guys, romance and all its drama', True, True)
add('Frenzy', 'http://theadventuresoffrenzy.smackjeeves.com/comics/', u'Neo Arcadia discovers an ancient reploid of immense power. Could he be their ultimate defense against the inevitable arrival of Zero?', False, True)
add('FriendshipisMagicThePonyPostingPlace', 'http://friendshipismagic.smackjeeves.com/comics/', u"Welcome, one and all to the Pony Posting Place! Here, bronies and pony lovers can all get together to share their art and talk about the show and other pony stuff! We accept all mediums of art, from spriting to drawing to sculpting. We're ALWAYS happy to see new faces, too! If you'd like to join, see our rules and application stuff bellow!", False, True)
add('FrobertTheDemon', 'http://frobby.smackjeeves.com/comics/', u"A gag-a-day comic about one little demon's journey to cause mass chaos and wreak havoc upon the poorly-drawn folk known as stix.", False, False)
add('FruitMachine', 'http://fruitmachine.smackjeeves.com/comics/', u"Jason Fellows is in love. Now the game is on to see how far Jason can string along his beloved Sheridan before his pennies run out. Just how long will Jason keep playing Sheri like a Fruit Machine before he tells him how he feels? -x-x-x-x-x-x-x-x-x-x- Ladies and gents, it'll be my pleasure to comic for you!", False, True)
add('FruitloopAndMrDownbeat', 'http://fruitbeat.smackjeeves.com/comics/', u"After hitting a bump in the road of life, Danny Lawson ended up moving back to the city where he attended college. His next door neighbor, Alan Taylor, is a senior in high school who falls in love with Danny almost immediately. AND THUS THEY BECAME FRUITLOOP & MR. DOWNBEAT. (bad intro, yes.) THIS COMIC IS PRETTY GAY. IT HAS BL AND GL IN IT (and straight people!) But regardless, as it's intended to be a comedy, I don't think you have to be a fan of the whole 'yaoi/yuri' thing to enjoy it. (contains boy/boy, girl/girl, foul language, cartoon violence, some sexual themes) Schedule is being removed for the time being. Updates whenever the author can get her crap together <xD'. (gonna aim for once a week?) (Note: A friend recently brought it up to me that she saw something on tv from the south where 'Fruitloop' was actually being actively used as a derogatory word. This comic means no offense, and the author wasn't aware that it was being used that way.)", False, True)
add('FuneralOfHearts', 'http://funeralofhearts.smackjeeves.com/comics/', u'STATUS: ongoing (Up Wed/Sun W-Europe time) A Pokemon (gijinka) doujinshi. READ RIGHT TO LEFT (Pokemon (c) Nintendo)', False, True)
add('FurtherDowntheRabbitHole', 'http://fdtrh.smackjeeves.com/comics/', u"Wonderland has a dark edge to it. After so many years of being told that Wonderland was all made up in his twisted mind, Alex had about enoungh. He returned the very rabbit hole he first fell down in only to find it wasn't there. Was it true then? Was all his adventures and friends he made in Wonderland all made up? Was he really crazy like his family said? This is a Boy love collab. Don't like? Don't care, you don't have to read or join. Also this comic is gonna be a bit insanity/horror. Rules will be posted on first page. Any questions, pm me. Characters needed: Alice:(taken) Hatter:(taken) Tweedle twins:(taken) March Hare: (taken) White Rabbit:.( taken) Red Queen:(taken) White Queen:(taken) Chesire Cat:(taken) Knave:(taken) Catipiller:(taken) Dormouse:(taken) White Knight: (taken)", True, True)
add('GART', 'http://gart.smackjeeves.com/comics/', u'RELENTLESS, BALLS TO THE WALL, FANTASY-PUNK, GOBLIN FIGHTING ACTION.', False, True)
add('GRACE', 'http://grace-comic.smackjeeves.com/comics/', u'Welcome to Grace, a yaoi webcomic created by two girls, Majo and Miru, also known as M&M Studios! Adult content for sex and occassional violence. HOW WE WORK: Majo: sketching, shading, scriptwriting Miru: inking, flats, scriptwriting Updates: when the page is ready, approximately once a week. Characters & artwork \xa9 M&M Studios. All rights reserved.', True, True)
add('GRASSNEST', 'http://grassnest.smackjeeves.com/comics/', u'a comic by Snakey Ho Ho Tomoki makes the biggest decision of his life when he decides to study abroad in Canada. Struggling to keep up with his courses, Tomoki finds help from the most unexpected place... the campus gardens.', True, True)
add('GTFOff', 'http://gtfoff.smackjeeves.com/comics/', u'EL PRIMER WEBCOMIC EN DEFENSA DE LA COMICSANS', False, True)
add('GamesPeoplePlayUpdatedWeekly', 'http://gamespeopleplay.smackjeeves.com/comics/', u'A webcomic about the little nuances of table-top roleplaying games, and the people who play them. Updated weekly. Feedback and comments at azalin1@lycos.com', False, True)
add('GardenofHearts', 'http://gardenofhearts.smackjeeves.com/comics/', u"Alyn, royal guardsman to the elven Queen of the North leaves for a quest to the far south with his wise-cracking necromancer friend Skylar. They are seeking a long-lost magical talisman that could dispel the eternal winter of the northern lands--and just perhaps elevate Alyn to Queen's Consort after he returns a hero. To journey into the south Alyn will need the help of his childhood friend, Nirin. Only, Nirin is a lot more enchanting than he remembered and every step closer to the mythical Garden of Hearts is a step further from his goals. story specs: light-hearted fantasy romance BOY X GIRL. tech: hand-drawn, b & w, toned.", False, True)
add('GarytheAlchemist', 'http://garythealchemist.smackjeeves.com/comics/', u'A story about the day-to-day life of an alchemist in the modern world. Updates Mondays, Wednesdays, and Fridays.', False, False)
add('GateTournament', 'http://gatetournament.smackjeeves.com/comics/', u'A generic one versus one tournament that you enter sprites in and i make fight each other. Winner is decided by coin flip Updates are sporatic and taste alittle bit like fish', False, True)
add('GeodeCorner', 'http://geodecorner.smackjeeves.com/comics/', u'When sarcastic but charitable Amber Pennicastle follows a handsome panhandler to his secret hideaway, her life turns upside-down in this action-shoujo comedy.', False, True)
add('GetUpandGo', 'http://getupandgo.smackjeeves.com/comics/', u'', True, True)
add('GhostsTaleACrossover', 'http://ghoststory.smackjeeves.com/comics/', u'Willow is taken away from her home and made to look for a special medallion. Supposedly, this amulet has the power to stop a war occurring in a very distant, possibly even other-wordly, land. It sounds simple at first, but it is soon realized that the problem may not lie solely in finding, but retrieving... *This is a story set in a pokemon region, but it does not completely focus on pokemon itself. *Some canons will be included, though they will be much older/more mature than in the anime. *I do not own Pokemon or Pokemon characters. Pokemon is (c) GAME FREAK & co.', False, False)
add('Gloomverse', 'http://gloomverse.smackjeeves.com/comics/', u'She was just a regular, unwanted kid, until she was lucky enough to get a job under the best magician in the world! Unfortunately for her, her new boss is a self absorbed sociopath. Updates are currently Monday, with some sporadic mid-week updates if I have time! Dark/Twisted Comedy!', False, True)
add('GoldenSunGenerationsAftermathVolume1', 'http://gsgbtsyearone.smackjeeves.com/comics/', u"- BEFORE THE STORM SERIES EPISODE I: VOLUME ONE - A fantasy RPG story based from the underrated RPG game series Golden Sun. Three time traveled Adepts granted a second chance at life after living seventeen years in an alternate destroyed reality, must quickly get used to their new surroundings as they are thrown into the fray dealing with new friends, family, emerging enemies and a big sailing adventure they'll never forget. Part 1 of a 4 Year Webcomic Series BEFORE THE STORM, a Golden Sun doushinji. - Rated +13 for slapstick humor, mild language, and fantasy violence VOLUME ONE COMPLETED; VOLUME TWO AVAILABLE HERE: http://gsgaftermathv2.smackjeeves.com/", False, False)
add('GoldenSunGenerationsColossoVolume6', 'http://gsgbtsyearthree.smackjeeves.com/comics/', u'- BEFORE THE STORM: EPISODE III - A fantasy RPG story based from the underrated RPG game series Golden Sun. The main focus is on the character Ethan who has grown up the last two years in terms of height and skill, seeks to win the heart of the werewolf girl Tasha by competing in a tough fighting Tournament. The first round is over and now the festivities truly begin! Part 3 of a 4 Year Webcomic Series BEFORE THE STORM, a Golden Sun Fancomic. - Rated Web +14 for gutter humor, mild language, romantic situations (BxG love) and fantasy violence COMPLETE - SECOND HALF OF COLOSSO BEGINS FEBRUARY 2011: http://gsgcolossov7.smackjeeves.com/', False, False)
add('GoodGame', 'http://goodgame.smackjeeves.com/comics/', u'Three friends want to get some fun and play a computer game in their hi-tech fantasy world. But they got something wrong...', False, True)
add('GoodnightMrsGoose', 'http://goose.smackjeeves.com/comics/', u'Hard working lawyer mom Valerie Clark is letting her work life overcome her family life. However after a magical encounter, she gets the chance to rediscover her childhood and also help cleanse her world of odd creatures.', False, True)
add('GraphPaper', 'http://graphpaper.smackjeeves.com/comics/', u'Talori is an angel that fell from the stars onto Earth. "Desperately" trying to get back home, she has to live with a pair of twins (brother and sister), Asura and Cam. (humor)', False, True)
add('Gravston', 'http://gravston.smackjeeves.com/comics/', u"Three years ago, Samuel Mortimer discovered the truth to his purpose in life. That he was the Death Host, a being born to act as an embodiment of death itself. It is now his duty to fight and destroy any Demons, creatures who violate the laws of life and death by combining their bodies and souls, that come his way. And strangely... they seem to come his way alot. As time passes, we learn that Samuel isn't the only person with strange and magical abilities, and that perhaps there's more to his home town than we thought. Will Samuel and his friends discover the mystery behind Gravston? Gravston is updated Monday to Sunday so check back every day for the newest page!", False, True)
add('GuardiansoftheGalaxialSpaceways', 'http://ggs.smackjeeves.com/comics/', u'Join Captain Taxxi Serbus and the crew of the Artful Dodger as they battle space pirates, giant comic book geeks, and intergalactic viruses in a star-spanning adventure!', False, False)
add('GuildAdventure', 'http://guildadventure.smackjeeves.com/comics/', u'Guild Adventure is an adventure comic which places us in a fantasy world, full of strange creatures, in which the hunters of the different villages compete to obtain the biggest prey. In this world lives Rago, an inexperienced young who have the determination to become the greatest hunter of all. With the help of the twins Reika and Leika he will start his particular adventure to reach the top, but this will be no easy task!, what is the motive of your determination, Rago?, will you become the greatest hunter?, go, Rago, your story begins now!', False, True)
add('HDMTHCOMICS', 'http://hdmthcomics.smackjeeves.com/comics/', u'My sprite comic shows how me and my friends live in the world of Sonic the hedgehog!', False, False)
add('HIPS', 'http://hips.smackjeeves.com/comics/', u'An admittedly done before bl romance. Here is my attempt at a gripping back cover summary: In an effort to get away from his criminal family, Julius Green has turned witness for the city. He is secreted away and hidden in a posh private academy as...a girl?! Suffocated by the charade, will Julius be able to pull off school life as Penny Adams? And will he be able to save himself when the two rulers of the school, Max Lawson and Alex Watch, take particular interest in him?', True, True)
add('HalfAssedChaos', 'http://www.halfassedchaos.com/comics/', u'Leave your maturity at the door, THIS is Half Assed Chaos! Right now we are in the middle of another exciting Half Assed Chaos Adventure, where you get to make suggestions as to where the story goes and then I decide to do whatever the hell I want anyway.', False, True)
add('HaruSari', 'http://haru-sari.smackjeeves.com/comics/', u'June is a young woman dying from a terminal illness. A doctor by the name of Chi-Min Huang offers her free treatment, and the two of them become friends. Everything seems peaceful, if sad... on the surface. Unbeknown to June, the doctor is deeply entangled in a terrible conspiracy against his will. Not wanting to get her involved in the mess, he keeps a lot of things secret from her, but there may be another\u2014less noble\u2014reason behind his secrecy...', False, True)
add('HarvestMoonParadiseFound', 'http://paradisefound.smackjeeves.com/comics/', u'When a single phone call changes your destiny...do you find the strength to embrace it? A Harvest Moon Doujinshi (fan comic) Read RIGHT to LEFT. Updates Thursdays. (Harvest Moon title and concept are copyright of Marveslous Interactive)', False, True)
add('HatShop', 'http://hatshop.smackjeeves.com/comics/', u'You may be thinking this is a comic about hats. It\'s not. A strange comedy about a boy who is fired in the first panel and accidentally sells his soul to an eccentric hat maker. Shenanigans ensue. Note to new readers: The art gets better. Note on the format: I originally drew it vertically because I did it by hand and that\'s how it would fit on the page (It just seemed like a good idea at the time). Three years later, it\'s stuck. It sometimes changes to full pages if the story needs it, but the vertical format is the default and I\'m not planning on changing it. Updates every three days unless otherwise specified. Note: This is a "whatever the author feels like" comic. You have been warned.', False, False)
add('Hatecantlove', 'http://hate-cant-love.smackjeeves.com/comics/', u'Hate can\'t love Status: Ongoing Since: Summer 2009~ Language: English Genres: Romance Story&Art: Kiiroi Thousands and thousands years ago, God created the feelings "Love" and "Hate". They could live happily in the paradise as long as Love didn\'t hate and Hate didn\'t love. One of them broke that rule and they were separated forever. Nowadays, Ai Koizumi is a 15-year-old girl who is in love with a boy that everybody seems to hate. Although she confesses to him her feelings, he refuses her. Will she be able to change his mind? The last battle between Love&Hate! Who\'ll win? Updates every 2-3 days. READ FROM LEFT TO RIGHT! >>>>>>>>>>>>>>>>>>>>>>> THANK YOU SO MUCH ^^', False, True)
add('HauntedHouseSurvivors', 'http://hauntedhouse.smackjeeves.com/comics/', u'Join Ultimate the Hedgehog and his friends as they battle to survive in the haunted mansion of Nightmare, along with other surprising villains. Alright lets do this: Spots: Main (17/20) -Ultimate -Solar -Snaps -Jay-2 -greenblur -jamesthewolf -Leo -Diox -john -Drown -Terra -GMC -Chaos -Kai -Signour -Omega -Helix Villains (6/15) -copafire -metaboo -Starfire -ForteTH -Jake -Kinny Neutral (10/10): -SP3 -mix -abdie -greyouTT -Ms. Kitsune -sonicballzx -Mist The Moonhunter -Felix -Clare -Heli WARNING: spots may vary during the comic Total authors= 37/45 (not counting spear) ONLY 8 SPOTS REMAINING! So... i did some booting so spots are re-opened. You all who want to join better update fast. otherwise wait for the next chapter to introduce yourself. For all those who are leaving, if you were already in the comic make a comic about you either dying or going missing (incase you ever want to join again). ~UTH Co-author applications under new management, sorry ulty had to ~Abdie/Silent dusk', False, True)
add('Head', 'http://head.smackjeeves.com/comics/', u"It's about people trying to capture a floating head. Every Mondays, Wednesdays and Saturdays.", False, True)
add('HeavyMech', 'http://heavymech.smackjeeves.com/comics/', u"In the wake of an alien attack, a virus has wiped out nearly all human males. The only ones left? The Pilots of the LMHUs, diabolical giant mechs made in the haste of war. Deemed too deadly for just men to use, each pilot is a former convict, and they're headed for Dirge City Can Hailey Stinson, pilot of a new generation of Mech, capture them alive, save the human race, and uncover the secrets of the LMHUs? Updates: Sat. at Noon Follow me on twitter at @TH3GADFLY for comic page progress", False, True)
add('HedgehogPieceANewEra', 'http://hedgehogpiece.smackjeeves.com/comics/', u'~This is a revival of the original Hedgehog Piece~ Take an adventure throughout a new world of One Piece, in a new Era of Pirates, following 6 major pirate crews of different species and personalities.', False, True)
add('Helix', 'http://helix.smackjeeves.com/comics/', u"A street rat is given a second chance when he is dragged from the gutter and into a new life. Will he accept his position at the side of royalty, or fight every step of the way? *Rated M for sex (both hetero and homo), violence, nudity, language and dark themes.* If you can handle these subjects, I hope you'll enjoy the comic. :) Thanks for reading!", True, False)
add('HeltonShelton', 'http://heltonshelton.smackjeeves.com/comics/', u'This is a goofy sketch at a party that grew into a two-book saga about a multi-generational battle against the darkness inside us. Shelton1 and Shelton2 set out to fight the Final Boss, but victory carries a cost for Shelton1. A party of heroes begin a quest of vengeance, but can they overcome their rivalries before facing their ultimate foe? A spellcasting musician learns to deal with death, but can she deal with life?', False, True)
add('Hemlock', 'http://hemlock.smackjeeves.com/comics/', u"Hemlock #1 and #2 are now available to buy online! each issue is priced at \xa36 plus postage and packing. they can be bought through lulu.com at my storefront here: http://stores.lulu.com/mildtarantula lulu accepts both card and paypal. since they go straight from lulu to you, they will not be signed or anything like that. if you happen to see me at one of the conventions i will be attending, i will be selling them for \xa35 each and i'll be happy to sign them and do a little sketch for you if you like.", False, True)
add('Hephaestus', 'http://hephaestus.thewebcomic.com/comics/', u'(a retelling of Greek mythology, with more than likely deviation from the original myths) While other gods on Mt. Olympus are known to be beautiful and laid back, Hephaestus is more humble in appearance and works his hands to the bone. However, that is not to say that the god of crafting and fire doesn\'t have any interesting tales about himself... <<Current Chapter>> 6) Origins: Part 3: Our tale of tragedy comes full circle as we learn of the final fate of young Hephaestus, leading to a fateful encounter between him years later with a certain Queen of the Nereids... <<Previous Chapters>> 1)Road to Athens: 2)Origins: Part 1 3)Passive Affection 4) Origins Part 2 5) Hermes\' First Flight Hermes, the last of the Olympian twelve to join, starts his tale as a meek child with weak ankles, unable to live up to the "God of Messengers" name we know him for. It would take the guidance of a certain smith god to change all that soon enough...', False, False)
add('Herpdederp', 'http://herpdederp.smackjeeves.com/comics/', u'A collection of stories and jokes about myself and my boyfriend, an aggresive vegitarian, video-games and T.V. shows, and my life as an awkward klutz.', False, True)
add('HiddenStrengthAWhiteNuzlocke', 'http://hsnuzlocke.smackjeeves.com/comics/', u'Clover, Cheren, and Belle graduate from trainer school, looking forward to finally being able to go on a pokemon journey of their own. Things start out like any other adventure, however soon the trio becomes entangled in the mess that is Team Plasma, finding out secrets that have been hiding in plain sight all their lives. How will their adventure unfold? This is a Nuzlocke story comic. [Updates Whenever]', False, True)
add('HighSchoolHeroes', 'http://highschoolheroes.smackjeeves.com/comics/', u'A group of teenagers desperately want to become superheroes, but high school keeps getting in the way.', False, True)
add('HitandMiss', 'http://hitandmiss.smackjeeves.com/comics/', u"It's a autobiographic comic about, well, me and my daily life! Doesn't it sound like fun? WARNING: Comic may contain a lot of the following; misspelling, weird situations, nerdiness, gaming, horrible puns, cats, and occasionally lovey dovey stuff http://www.drunkduck.com/Hit_and_Miss/ ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ The link to DrunkDuck Hit and Miss!", False, True)
add('Holocrash', 'http://holocrash.smackjeeves.com/comics/', u'Welcome to HoloCrash, the adventures of Commander Teelianna Santo ("Teela") and her Genetically Enhanced Nanotech Android trainer ("G.E.N.A"). Teela, a brilliant science officer and an exceptional athlete, volunteers for a year round trip aboard the cargo freighter Argenta-619 so that she, along with her trainer G.E.N.A, can train for the upcoming Pan System games in heavy gravity conditions. Soon, what seems like a normal freight run to the Cordas System, turns into an adventure like no other! ******************************************* For information on how the comic is put together visit http://www.holocrash.com *******************************************', True, True)
add('HolyBlasphemy', 'http://holyblasphemy.smackjeeves.com/comics/', u'Making fun of religions since 2010. Better stay clear of this comic if you really cannot stand people making fun of Atheism, Buddhism, Christianity, Creationism, Germanic and Greek Polytheism, Hinduism, Islam or Judaism as well as of Abraham, Agni, Aliens, Angels, the Easter Bunny, Great Ctuluh, Isaac, Jahweh, Jesus, John the Baptist, Joseph, Mary, Mohammed, normal humans, Pascal, robots, Santa Claus, Satan, Tantalus, Thor, Vishnu, well-built catholic girls, Zao Jun or Zeus (more religious belief systems and persons may follow). Updates whenever I find the time (on average every 2.4 days or almost three times a week). Comments and voting highly welcome!', False, False)
add('HolyCrap', 'http://holycrap.smackjeeves.com/comics/', u"Hi there! Welcome to what-ma cha' call it? ... Oh that's right Crap Holy. No no... AH! WELCOME TO ME! I AM HOLY CRAP!", False, True)
add('HopeForABreeze', 'http://h4ab.smackjeeves.com/comics/', u"Dedicated to all of the losers and the failures, the freaks and the social outcasts in society; don't give up. This is a story of a girl named Sophia and her journeys through life", False, False)
add('HotelWtf', 'http://crazyhotel.smackjeeves.com/comics/', u'Things are going to get crazy. Why not come and spend the night in the wackiest hotel of all. If you want on the banner PM Darkscarz.', False, True)
add('Houseofsprite', 'http://sac22.smackjeeves.com/comics/', u'A hotel comic where anything can happen! Rules: no inappropriate updates keep it PG-10ish', False, True)
add('HurrocksFardel', 'http://hurrocksfardel.smackjeeves.com/comics/', u'', False, True)
add('INUSITADOONLINE', 'http://www.inusitadoonline.com/comics/', u'Uma simples comedia romantica ;D', False, False)
add('ImminentMoose', 'http://www.imminentmoose.com/comics/', u'"EVERYTHING IS WONDERFUL" :~ UPDATES HAPPEN ON SUNDAYS~: NOW DOING COMMISSIONS!', False, True)
add('InDebt', 'http://indebt.smackjeeves.com/comics/', u"Meet Kid. A teen straight out of high school with his whole life a head of him. Until it ends in a tragic traffic accident. Meet Grimm Death. A Reaper with the power of life and all other sorts of power at his disposal. He's highly respected in the Reaper realm and is seen as a Godly figure. In truth he is an arrogant, narcissistic, selfish, annoying, loud ego filled man that asks for no permission before doing what he wills. He owns the Deadwood Hotel and his goal is to make the hotel grow to multimillion dollar company. Grimm Death brought Kid back to life and informs the boy that he will now be working as a maid in order to pay off the debt of gaining a new life from Death. There will be boylove, girllove and just love in general. But mostly boys crushing on other boys. I'm currently going back and redoing the first chapter. Please bear with me as I replace the older pages with shiny new ones.", False, True)
add('Inhuman', 'http://inhumancomic.smackjeeves.com/comics/', u"1000 years in the future, a schizophrenic has been kidnapped by a group of rebel soldiers. And it seems they've bitten off more than they can chew...", False, True)
add('Insomanywords', 'http://insomanywords.smackjeeves.com/comics/', u'Sam Moore\'s 20 year old world is shifting on its axis, whether he\'s ready for it or not, and his relationship to his best friend Charlie is at the center of it all. But no friendly warnings, social boundaries, disabilities, self denial, Charlie\'s pretty girlfriend, nor the mayor of town can stop Sam\'s growing curiosity towards the quirky, blonde boy he\'s never had to live without. (art improves as you go on) Warnings: Adult Content, Nudity, Profanity, Abuse, and Alcoholism are present in this comic. Slice of Life/Romance/"Dramedy" Uploads: Every Monday and Friday, 2 pages at a time, most often at night, Central Standard Time', True, False)
add('InspiredByADream', 'http://inspiredbyadream.smackjeeves.com/comics/', u'in\xb7spire |in-spahyuhr| ~to fill or affect with a specified feeling, thought, etc ~to prompt or instigate (utterances, acts, etc.) by influence, without avowal of responsibility dream |dreem| ~a succession of images, thoughts, or emotions passing through the mind during sleep ~a vision voluntarily indulged in while awake; daydream; reverie ~a wild or vain fancy Updates: Saturdays 1-2 pages a week.', False, True)
add('Intoxicated', 'http://intoxicated.smackjeeves.com/comics/', u"This is the story of Robert, who tries to manage his relationships in his life of drug abuse, break up's and strong emotions. Contains drugs, sex and profanity. Approximately rated: 15", True, True)
add('IrrationalFearsGirlandotherfineadventures', 'http://ifcomics.smackjeeves.com/comics/', u"Just a series about a girl, her strange phobias and how she doesn't deal with them. Current Chapter: THE MYSTERY OF THE CAVE Updates MON THURS", False, True)
add('ItoshiisCrazyNuzlockeAdventures', 'http://icna.smackjeeves.com/comics/', u"<ICNA Yellow Run: Complete> ICNA: Water's Edge After becoming the Kanto League Champion and facing off against a Mewtwo corrupted by Missingno., Emp finds themself in Hoenn with no way to return home immediately. With the closest possible boat to Kanto being in Lilycove, Emp, and their new partner Ra, have to challenge the Hoenn league in an attempt to return to Kanto. Rules: -If a pokemon faints, you have to throw it into the DEAD box -You have to catch the first pokemon you see in an area (void until first pokeball) -No dupes. You get only ONE chance to find another pokemon if the first you run into is a dupe -Only ONE egg is allowed to be hatched -Nickname all pokemon -if you find a shiny pokemon in a route you've already caught a pokemon in, you are allowed to capture it. However, if you do, you must release the pokemon you previously captured in that route.", False, True)
add('ItsCharacterDevelopment', 'http://characterdevelopment.smackjeeves.com/comics/', u"And now the tale of a party of adventurers who got lost in a dungeon ... and the one Paladin who had no choice but to try and save them. It's Character Development. Daily updated Playmobil toy photo-comic.", False, False)
add('Itsahardlife', 'http://itsahardlife.smackjeeves.com/comics/', u'Robin is ten years old and travels through Kanto with her pok\xe9mon to find a place to call home. This is a story about struggle, survival and friendship in a cruel world. -------------------------- This is a Nuzlocke comic. Contains some swearing and occasionally some gore.', False, True)
add('Itsan8BitWorldBlankWorld', 'http://8bitblankworld.smackjeeves.com/comics/', u'This comic\'s premise is simple. This is the White Space, or "Blank World" of my It\'s an 8-bit World Comicverse. Here all the characters, past, present, and future can interact and do crazy, random, and all-together odd things for your own entertainment. Of course, they have to be careful so as not to piss off the local Rulers of the Universe...', False, True)
add('IwillbenapoSpamDump', 'http://napospamdump.smackjeeves.com/comics/', u'"This is where I, Iwillbenapo will post his or her stuff when I want to upload something." This used to be the description of the comic. Spam Dump description: This is a place where I, Iwillbenapo will post stuff such as memes, banners, or just any random stuff. Napo Playthroughs description: I basically play any game I want to play and make comics about it. The main idea is to race other authors in their sprite playthroughs (without permission of course). The walkthroughs aren\'t really intended to be funny, but that\'s not really working too well. ENJOY MY SPAM AND LPs.', False, True)
add('JackiesStory', 'http://jackiestory.smackjeeves.com/comics/', u"Jackie's Story is an online flash webcomic adventure story about an alien named Jack (Better known as Jackie) who gets talked into participating in something that she hopes will bring back her dead brother. For the animated version: http://sky665.deviantart.com/gallery/26849503", False, True)
add('Japanofail', 'http://japanofail.smackjeeves.com/comics/', u'Do you like anime, manga or video games? Do you often fail? If so, you might like this comic!', True, True)
add('Jointhiscomic', 'http://joinenow.smackjeeves.com/comics/', u"this is like an author comic so come in and make comics or show off your sprites or really anything just join for the hell of it bro open spots: 8939 (i'll seriously allow 9000 authors to be on here) No longer in Technicolor! also including nudity!", False, True)
add('JosPokemonJourney', 'http://jpj.smackjeeves.com/comics/', u"Just about a 17 year old twin with an afro who's going on a journey with a few surprises, friends, and foes. :D Updates when it can. :3", False, True)
add('June', 'http://june.smackjeeves.com/comics/', u'SORRY! NO DOGS ALLOWED (A 100% true autobiographic horror story. @tumblr: http://junecomic.tumblr.com)', False, True)
add('JustAnotherDay', 'http://ravenwing.smackjeeves.com/comics/', u'Shanku has left her home behind to explore the wide world around her. Out of her small forest home she finds more of her own kind and new friends. Love, loss, and adventure await her as she discovers the secrets her clan struggled to hide. But at what cost?', False, False)
add('JustGotta', 'http://justgotta.smackjeeves.com/comics/', u'Your typical story about a girl from our world pulled into the Pok\xe9mon world . . . or is it? Hillaree, known by her friends as the "Mewtwo Queen," is suddenly taken to a world where Pok\xe9mon are real. She is told she will be returned home when she is ready. What could that mean? Well, since she\'s going to be there a while, she might as well catch some Pok\xe9mon! A Pok\xe9mon Fan Comic written and drawn by Vye Brante. Rated Teen for some violence/fighting, blood, and death. Currently updates on Wednesday and Saturday. Please note: This comic does not follow any established canon, but does use characters from the games, anime, and mangas. Histories and personalities may be changed.', False, True)
add('Justmyluck', 'http://justmyluck.smackjeeves.com/comics/', u'Andreia is a normal girl, if you forget the fact that she\x92s the unluckiest girl in the world. Tired of her life, she leaves her home and goes to another town. But of course things don\x92t go as planned. Andreia meets Jason, who is a pain in the ass and very cold to her. She finds herself stuck in the biggest problem of her life, with nowhere to turn.', False, True)
add('KCNO', 'http://kcno.smackjeeves.com/comics/', u"A simple town in love with a simple radio station show. KCNO's Love Me Do, is the most popular show on the airwaves. Its success is owed to the host, Jason who has impeccable advice to give people struggling through love. But when a simple question moves the town to seek out Jason, his attempts at secrecy become the newest talk of the town.", False, True)
add('KaitoShuno', 'http://kaitoshuno.smackjeeves.com/comics/', u"a man named Kaito goes to commit suicide after living a boring, loveless, cubicle job. He meets a strange guy named Shuno...and Shuno immediatly takes a liking to him...almost too fast to be real XD Kaito quickly makes it clear that he isnt gay...but will Shuno's actions toward him make him alittle...'confused'? lol Kaito's been in such a need for love that maybe Shuno's affection doesnt look THAT bad...or does it?:P YAOI!!", False, True)
add('KasaKeira', 'http://kasakeira.smackjeeves.com/comics/', u'<b>The story of a girl, her magic umbrella and the hundreds of demons trying to kill her</b>', False, False)
add('Katran', 'http://katran.smackjeeves.com/comics/', u'This is the Story of Nirrod, an almost normal 14 year old boy. He is living with his Family and his clan in a big village in the north of Katran. Build on a giant cliff, it became one of the safest places in the land, and soon a very precious trading point. Nirrod is living his life well protected and without sorrows in the lap of his clan. he is playing with other kids, playing pranks....a normal life. but all of this is going to change....', False, True)
add('KaxenonSTUFF', 'http://onstuff.smackjeeves.com/comics/', u'A comic about nothing in particular spanning from political opinion to random observations about insignificant things.', False, True)
add('KeepingUpwithThursday', 'http://keepingupwiththursday.smackjeeves.com/comics/', u"An homage, tribute, parody, and nod to animated cartoons of day's past. From Disney or Bluth, 'Keeping Up with Thursday' is intended to be a quarterly monthly series with four issues a year (or bonus side comics, if time permits), about the adventures and lives of Patrick and Vinnie: two mice living in Victorian London. Vinnie, the American, is paired up with Patrick, a notorious thief, and their tales - tails! - herein, lie a grand sequence of events. Created in December 2010, and hopefully, longer.", True, True)
add('KingJamesMoneego', 'http://kingjamesmoneego.smackjeeves.com/comics/', u'An African prince, pirate Jean Lafitte and slave runner James Bowie in the swamps of Louisiana.', False, True)
add('KingdomoftheDinosaurs', 'http://dinosaurkingdom.smackjeeves.com/comics/', u"Kingdom of the Dinosaurs is a theme park ride through the magical world of video game and pop-culture parody. If there's a bright center in the webcomic universe, you're on the comic that's farthest from. Updates sporadically.", False, True)
add('Kirbandfriendsshowcase', 'http://kas.smackjeeves.com/comics/', u'a new kirb and friends!^^', False, True)
add('KirbyAdventure', 'http://kirbysadventure.smackjeeves.com/comics/', u'Meet the Kirby Adventure Squad: a group of Kirbies who take requests from random clients and attempt to complete them! And mostly fail miserably! Huzzah!', False, False)
add('KirbyDreamTeam', 'http://kirbysdreamteam.smackjeeves.com/comics/', u'Join Kirby and his Dream Team as they team up to take down evil!', False, True)
add('KirbyFunfestTheOriginals', 'http://kirbyfunfestold.smackjeeves.com/comics/', u'Kirby and his best friend Dee are minding their own business, when Dedede challenges Kirby to a duel! Since then, Kirby and Dee have to save the world from seemingly unstoppable forces of nature, and all the while they still have time to be funny... NOTE: I am restarting this comic, see it at http://kirbyfunfest.smackjeeves.com/', False, False)
add('KirbyandtheDarkKnight', 'http://kirby-darkknight.smackjeeves.com/comics/', u'This is a comic of a lot of nerdy pop-culture stuff such as internet memes, Naruto, RP characters, Pokemon, and.... Kirby. The whole story is LOOSELY based on Kirby and the Amazing Mirror. IMPORTANT: COMICS ARE READ RIGHT TO LEFT. THAT MEANS THAT "LATEST COMIC" IS ACTUALLY THE FIRST AND "FIRST COMIC" IS ACTUALLY THE LATEST. Kotaru, Kyousuke, and Riki were best friends since childhood and continued to be into high school, until one of their ordinary, normal days goes wrong and changes their life forever... They team up with Kirby and create the S.W.O.R.D to fight against the Dark Knight. Thanks for reading and please feel free to comment. Like our Facebook page! http://www.facebook.com/pages/Kirb-y-and-the-Dark-Knight/191342084279414 Also read Divided By Zero! Our team\'s newest detective story also on smackjeeves! divided-by-zero.smackjeeves.com', False, False)
add('KirbysDreamAdventure', 'http://kirbyda.smackjeeves.com/comics/', u'What\'s better than one Kirby? A whole crew of kirbies! What\'s better than that? THREE crews of kirbies! Throw in a bit of randomness and a lot of just plain good fun, and what you\'ve got is a sprite comic worthy of your praise, insults, or just plain "what the...!" moments.', False, True)
add('KirbysSpritersResort', 'http://ksr.smackjeeves.com/comics/', u'A nother spriters showcase has come to town! what\'s the difference? IT"S KIRBY\'S ONLEH! If you want a place to post your kirby sprites and drawings, spost them here!', False, True)
add('KirbysofTHEVOID', 'http://kotv.smackjeeves.com/comics/', u'May 22,2032 Day 198 The tests have finally come up successful. I, Professor. Wima Deerp has created space. By use of rapid particle acceleration I have managed to create a vast area of artificial space. Such space acts quite like an alternate universe. The expanding communities will benefit greatly from the vastness. -Professor Wima Deerp Welcome to THE VOID!', False, False)
add('KirbysoftheAlternateDimension', 'http://kirbyaltdimension.smackjeeves.com/comics/', u"A delightful comic that may contain mild language about the life of the kirbys that live in the other dimension. It is a story about adventure, suspense, and drama, and of course, comedy. (A comic isn't a comic without comedy.) Current Chapter: The Alternate Dimension Kuzer has a new visitor in his dimension: Meta Knight. With the inter-dimensional portal here, Burey gets ideas. After being captured by King DeDeDe, Burey tells him about the portal and meets a winged Kirby named Carli. Now Burey, Carli, and the rest of the Kirbys must team up to stop King DeDeDe from destroying time and space!", False, True)
add('KissoftheDevil', 'http://kissofthedevil.smackjeeves.com/comics/', u'Vist us at http://www.smackjeeves.com/comicprofile.php?id=110041 Thanks! Shadow Leafeon', False, True)
add('KissoftheDevil20', 'http://kissofthedevil2.smackjeeves.com/comics/', u'This is a remake of the collaboration, "Kiss of the Devil" _____________________ This is a collab for Vampires, Humans,and Werewolves. This has no plot whatsoever so, we are always open to suggestions! This collab is just for fun so do what you want. -------------------------------------------- You may have up to 4 characters!ONLY TWO humans ONE werewolf and ONE Vampire! Extra!The human HAS be a drudge(slave)to a certain vampire or werewolf.Even if you or they dont like it. ----------------------------------------------------- This is NOT a Twlight collab. This has nothing to do with it! -------------------------------------------- Will contain:Blood B/L G/L ------------------------------------------------- Spots open: 0 Sorry guys. I don\'t think we can have anymore characters. We have too many. :( Spots taken: 6 i think.. XD ----------------------------------------- Kissofthedevil(c)Shadow Leafeon', False, True)
add('Knightface', 'http://knightface.smackjeeves.com/comics/', u'A paladin who betrayed abusive people who used to be his friends seeks to rebuild faith in himself and his god.', True, True)
add('Knightserrant', 'http://knights-errant.smackjeeves.com/comics/', u'After war breaks out between Aster-Morgaria and Vetal, Wilfrid joins a Vetalian-aligned group of mercenaries called the Errant Knights. However, in his attempt to reclaim fame and fortune, Wilfrid finds himself intrigued by the mysterious mercenary captain, Oswald Dytel.', False, True)
add('Kranburn', 'http://kranburn.thewebcomic.com/comics/', u'An Australian Post Apocalypse Comic', False, True)
#add('KuroShouri', 'http://kuroshouri.smackjeeves.com/comics/', u'Hisaki and Yasha are an odd pair of friends: Hisaki is quiet, distant, and possibly keeping secrets from everyone, while Yasha is loud, violent, and in serious need of anger management. As they try to deal with each other, they soon find that creatures are after them for something they know nothing about: a demon supposedly hiding within one of them. I have no set schedule; but I tend to update once a week. Please leave comments and ratings! WARNING: Occasionally, pages of this comic will not show up. I am not sure what causes it, but if it happens, leave a comment on the page(s) that are not showing up. I will fix them. ^^ KuroShouri.com', False, False)
add('KuroiHitsuji', 'http://kuroi-hitsuji.smackjeeves.com/comics/', u'Title: \u9ed2\u3044\u7f8a Kuroi Hitsuji Author/Artist: Don G. (kuroi_hitsuji) Rated: [OT] Older Teens 16+ -contains sexual themes, occasional cussing, and sad stuff. Genre: Romance, Comedy, Drama, BL Gayness percentage: 80% (contains hetero) Update Schedule: Mondays 6AM-12PM PST This is the story of what happens when you put a straight man, his secretly gay brother and his secretly gay boyfriend, his wacky gay friends all in one apartment, as one organization: "Kuroi Hitsuji(Black Sheep)". A story of love, secrets and some downright gay humor. As a straight man in a gay world, who is the black sheep? NOTE: THIS IS NOT A COLLAB. kuroi_hitsuji is the author/artist. The other authors are the "characters" (they made them up). They also help compose their respective stories.', False, False)
add('Kyel', 'http://kyel.smackjeeves.com/comics/', u'A cold, reckless, unemotional and a professional killer let a little girl alive even thought he should have killed her. No one knows why. "Please read from right to left! ^^"', False, True)
add('LOGOS', 'http://logoscomic.smackjeeves.com/comics/', u'In the far future, on a distant planet, a man made of plastics discovers what it truly means to be human.', True, False)
add('LOKI', 'http://loki.smackjeeves.com/comics/', u'LOKI is the story of Lochlan and Kian, two down on their luck and only vaguely competent guns for hire, and their adventures. Updates on Tuesdays and Fridays!', False, True)
add('LastLivingSouls', 'http://lastlivingsouls.smackjeeves.com/comics/', u"It's probably safe to assume you know what a zombie is; A living corpse with an insatiable craving for human flesh that mindlessly acts on primal instincts. But, what would happen...if a zombie became able to think? Along side an empty road, a teenager named Eddie awakens, confused and fearful due to his inability to remember anything. He heads towards the nearest city in hopes of getting some help, but realizes it is nearly empty of residents and is instead being slowly consumed by a group of undead. It quickly becomes his purpose to survive and also to understand why these creatures are plaguing the city...and why he is one of them.", False, True)
add('LeCirquedObscure', 'http://cirquedobscure.smackjeeves.com/comics/', u'', False, False)
add('LedbyaMadMan', 'http://ledbyamadman.smackjeeves.com/comics/', u'The country is devoid of life save for five people who try to stay alive the best that they can.', False, True)
add('LegendOfZeldaSwordOfWinds', 'http://swordofwinds.smackjeeves.com/comics/', u'A somewhat loose interpretation of Wind Waker, containing some of the scenes from the game. A pure adventure comic about Ganondorf threatening the World with a sword that can command the Winds. Link must use both the Wind Waker and the Master Sword to counter this Evil! Updates often', False, True)
add('LegendofZeldaStaffofPower', 'http://loz-sop.smackjeeves.com/comics/', u'An ancient weapon created for harmony brought civil war. Shattering it brought tentative peace, until the leader of the Gerudo attempts to slaughter an entire race of people, then turning his hatred upon the monarchy of Hyrule. Defeated by the Hero of Time and the Princess of Destiny, he was sealed away in the Sacred Realm. Years later, he has gained more power, and has broken free. Now it will take the very weapon he seeks to destroy him, and an unlikely wielder to complete the task. Who will win?', False, True)
add('LegendofZeldaTheEdgeandTheLight', 'http://legendofzelda.smackjeeves.com/comics/', u'After years of absence, Link finally returns to Hyrule from his travels abroard. Initially expecting to greet Princess Zelda, he instead finds the kingdom in decline, plagued by all kinds of trouble. Just what is causing these problems, and does it have anything to do with why Link left in the first place? NB: Thanks to its unusual format, this updates every FRIDAY.', False, True)
add('LegendofZeldaTheWindWaker', 'http://zeldawindwaker.smackjeeves.com/comics/', u'The Legend of Zelda: The Wind Waker turned into a webcomic. I hope you enjoy it. Written by Emily-Ann Coons and drawn by Kitty Lyre. Currently updates every Monday at Noon EST.', False, True)
add('LegendsofMobiusBookOne', 'http://legendsofmobius-bookone.smackjeeves.com/comics/', u'It\'s been two years after Sonic the Hedgehogs last adventures. A hedgehog named Crusade travels around planet Mobius and randomly or not, becomes friends with several other mobians. But on his journey dangerous things happen and concerning news spread. And so, Crusade and his comrads, later known as "Team Element", decide to search for the root of everything. Without knowing that they get involved into a war which will decide about the worlds future...', False, True)
add('Lespritedump', 'http://lespritedump.smackjeeves.com/comics/', u'', False, True)
add('LethHate', 'http://leth.smackjeeves.com/comics/', u'A man is cursed to walk the world he hates for all eternity in the company of a cute succubus and a ska loving zombie.', False, True)
add('LethalDose', 'http://lethaldosecomic.smackjeeves.com/comics/', u"WARNING: This comic contains heterosexual AND homosexual relationship, Drug abuse, sexual themes and violence. READ RIGHT TO LEFT - JAPANESE FORMAT Updates every Sun & Wed. ________________________________ Bobby and Raine were wannabe child hood sweet hearts that, due to unfortunate circumstance, had to be torn apart. Now, five years later Raine returns to find a Bobby very unlike the one she once new. Lonely and stuck with an undesirable life, he has turned to drugs and alcohol to mull the days away with. But after a strange encounter in an alleyway one night, Bobby finds himself trapped in a much more 'hardcore' underground world of drugs and abuse; one that's secrets are so dark it's not too easy to leave behind.", True, False)
add('LetsBreakitforReals', 'http://breaktehrecord.smackjeeves.com/comics/', u"C'mon guys, let's break the record of most comic authors this time. We can't fail for the 4th time. NOW WE GOT THIS! I think! Maybe.... I DON'T EVEN KNOW ANYMORE! - Sexy Rule 1: No explicit contents. We can't have that, but you know what humans are like. Rule 2: No getting involved in big advertisements. Rule 3: No alternate accounts. That's just cheating. Rule 4, very important, 4: Don't let me watch Digimon. I HATE Digimon! Aura's a character I made up, but he won't know that! I'll think I AM him and he might go and do something stupid like watch Digimon! I don't want to wake up in the morning with that in my head! - Kurro ---------------------- I'm banning anything to do with rap. - Darkeh Goal:206.7689454 Current: 72", False, True)
add('LifeAsACutOut', 'http://lifeasacutout.smackjeeves.com/comics/', u'The one page and short story comics that star the dense yet smart Rail Machanic, The Hot headed Canadian Opil McKinzy, and the rest of he multinational mottly crew that are their friends.', False, True)
add('LifeAsItWas', 'http://lifeasitwas.smackjeeves.com/comics/', u"It's a web comic, I make it and you read it. Updated daily. Follow LAIW on twitter @LifeAsItWas to get updates on there, as well as bonus content, if you're into that sort of jazz as well. Go ahead, I won't judge you.", False, True)
add('LifeafterDeath', 'http://lifead.thewebcomic.com/comics/', u'Life after Death is about an out of work Grim Reaper navigating current events, new roommates and his new found mortality...', False, True)
add('Lifeonpaper', 'http://lifeonpaper.smackjeeves.com/comics/', u'"Life on Paper". Is a comic strip very loosely based on my life, originally it was titled, "Lil Bastard" It follows me and all my jobs, relationship, and even through marriage. With 2000+ strips. Which will eventually be uploaded here. Please Enjoy my life.', False, True)
add('LifewithVlad', 'http://lifewithvlad.smackjeeves.com/comics/', u'Barry is a 20-something art student. Vlad is a 500-something vampire. Can a mortal and an immortal share an apartment without driving each other batty?', False, True)
add('LilOldOtakuMe', 'http://lilotakume.smackjeeves.com/comics/', u"This is a journal comic! :DD This is about a strange girl somewhere in the magical land of St. Louis MO, her tales of misery and woe, her little bro in tow... I'll stop. Enjoy my tomfoolery and hi jinks!", False, True)
add('LiliBleu', 'http://lilibleu.smackjeeves.com/comics/', u'Webcomic en espa\xf1ol La humanidad ha quedado al borde de la extinci\xf3n por causa de un virus que los muta en superhumanos poderosos, dotados de una gran belleza y poder que han tomado control del planeta. De entre el nuevo orden se alza la \xfaltima esperanza de la humanidad: Espartaco Garc\xeda, armado s\xf3lo con una de las mentes m\xe1s brillantes del mundo en contra de seres que pueden derribar monta\xf1as con su mirada. S\xf3lo hay un problema: Quiere salvar el mundo... para gobernarlo \xe9l.', False, True)
add('LittleLink', 'http://littlelink.smackjeeves.com/comics/', u'A great Evil threatens the worlds of your favorite Nintendo characters and Link is the key to stopping it!', False, True)
add('LivingwithAXEL', 'http://livingwithaxel.smackjeeves.com/comics/', u'After their parents kicked them out, Sora, Riku, Kairi, Namine, and Roxas move into castle oblivion... where a few of the O-13 member live!', False, True)
add('LondonUnderworld', 'http://lunderworld.smackjeeves.com/comics/', u"Miss Ameliea Worton is sick of the rich, upper class, boring world she has been brought up in. She seeks entertainment from London's dark under belly, making friends with crooks and con artists and playing their games against the aristocracy she has grown bitter of. But, when Ameliea decides to join forces with the king of the London Underworld, she discovers how naive she has been, and how dangerous London can really be.", False, True)
add('LongArm', 'http://longarm.smackjeeves.com/comics/', u'A comic about the future and clouds.', False, True)
add('LostLove', 'http://lostlove.smackjeeves.com/comics/', u'Matt has always been neglected by his parents, but he dosn\'t care anymore - he has found the one he love. The only problem is that that \'love\' is his best friend, Joshua - another guy. To make it even worse, Joshua already has a boyfriend, so Matt dosn\'t dare to confess his feelings. But the boyfriend, Daniel, acts like a total jerk towards Matt, who can\'t help but despise the guy - for more than one reason. Nonetheless he decides to hide his feelings, and support Joshua and Daniel as a couple, the best he can. Though one fatefull day, Daniel comes with a strange request, that Matt can\'t refuse; "Come to my house, or I\'ll break it off with your friend." What will Matt do from then on? Can he keep a secret from Joshua, a secret that\'s slowly breaking him apart? Why does Daniel do as he does and why the hell is the strangest thing starting to turn Matt\'s life upside-down?! WARNING!! Contains Yaoi/BL/shounen ai and soooo on - you know the rest ;)', True, False)
add('LoveMe', 'http://loveme.smackjeeves.com/comics/', u':::Comic reads top to botton left to right::: Follow Kajin in a modern dark twisted version of a love story. Kajin is in love with someone, but in this school that someone should not be another boy. Love is not something you can simply choose... it just is. "Love Me" THE OFFICIAL THEME SONG TO LOVE ME (SHOULD OF PUT THIS UP EARLIER...LIKE WHEN I STARTED DRAWING THE COMIC) http://www.youtube.com/watch?v=uzmmh9y0QPs \'Love Me\' Will update at random during the week, atleast 1 or two pages each week. [Gonna really try hard to stick to that] Comic story is written off the top of my head, it\'s a practice comic, nothing fancy or great so please don\'t rant about mistakes I make. this is for fun :D facebook \'Love Me\' page- http://www.facebook.com/pages/Love-Me/150627535019833 Please visit my personal site for cheap quality commissions <3 www.studio-adhd.com Art Tumblr is http://www.tumblr.com/tumblelog/studio-adhd [WARNING HARD CORE YAOI, NO ONE UNDER THE AGE OF 18 SHOULD VISIT THAT TUMBLR BLOG]', True, True)
add('LsEmpire', 'http://l-empire.smackjeeves.com/comics/', u'Your "average" sprite comic about Luigi leaving Mario. Then things try to get silly. Updated 8:00am every day. Specials go up at 12:00am. Check out our TV Tropes page at http://tvtropes.org/pmwiki/pmwiki.php/Webcomic/LsEmpire Also Check out the offical L\'s Empire Youtube Channel at http://www.youtube.com/user/LsEmpireOfficial Or E-mail us at MrLandCo@hotmail.com', False, False)
add('LuffinpuffandEric', 'http://luffinpuff.smackjeeves.com/comics/', u'The magical adventures of a fat kid named Eric and his fanciful imaginary friend, Llewellyn Luffinpuff!', False, True)
add('LumasParadise', 'http://luma.smackjeeves.com/comics/', u"Welcome to Luma's Paradise, the one and only place in the galaxy where you can find sprite comics starring the Lumas!", False, True)
add('MUTE', 'http://muterobot.smackjeeves.com/comics/', u'We fight for what we believe in and for those we care about. With terms and beliefs like these, who is to decide what is right and what is wrong? It is our emotions that fuel our actions, but is allowing them to take over really the right course of action in drastic situations...? Updates Fridays.', False, True)
add('MYth', 'http://myth.smackjeeves.com/comics/', u"MYth is a collection of original short stories inspired by the Greek mythology. Since it's MY version, the storyline differs from the classic mythology. .: MYth: My Seasons :. Demeter's sudden disappearance left Hades nothing but a daughter named Persephone... .: MYth: Eternal Gift :. The story of Poseidon and his true love... .: MYth: A PROMISE :. Before the time of the Olympians. Promises...made and broken... Between two brothers, only regrets remained. ***MATURE CONTENT APPLIES TO MYth: A PROMISE ONLY*** MYth (c) Zelda C. Wang http://zeldacw.idv.st http://zelda994612.deviantart.com", False, False)
add('Mafiagame', 'http://mafia.smackjeeves.com/comics/', u'', False, True)
add('MagicalGirlAlice', 'http://magicalgirlalice.smackjeeves.com/comics/', u'Behold the daily life of Alice Kamelot, a magical girl who is just looking to have fun and excitement.', False, True)
add('MagicalRenegades', 'http://magical-renegades.smackjeeves.com/comics/', u"In The State of Confusion, worlds, time periods, and magical girl wannabe heroes collide and cause a revolution after a megalomaniac's time travel scheme leaves everyone stuck in the past! The 'heroes' must fight against the rival magical girl faction over rewriting the turning point of Confusionite history, and to prevent another collapse of the space-time continuum! Genres: Comedy+Drama (mostly comedy, I'm aiming towards 90% comedy 10% drama, and 120% WTF-is-this-I'm-reading?!), Magical Girl/Mahou Shoujo, Metafiction, Steampunk (starting in chapter 3)", False, True)
add('Magience', 'http://www.magience.co/comics/', u'------------------------------ Updates: M - W - F - Sa - Su at Midnight PST Content Rated PG-14 ------------------------------ "Magience" was a new video game, one you could play while awake OR asleep thanks to an innovative headset. No one was quite sure the exact technology behind it, only that it was top-of-the-line and very mysterious. In a world of fantasy, players get one character to level and adventure with, exploring an infinitely growing and evolving world. However, it\'s not long before people start to notice certain oddities, and certain strange theories and rumors start popping up all over the place, both in game and in real life. Crazy as it sounded, what if "Magience" wasn\'t just a game after all?', False, True)
add('Manifested', 'http://manifested.smackjeeves.com/comics/', u'Hi there my names Stuart and I\'m the main character of Manifested ...and i hate my author...even though hes me. "shut it and describe my comic to all the nice viewers out there." fine, basically its about how i came upon a power to enter other peoples stories(video games movies cartoons all that jazz)and just mess around in them meeting my favorite characters and getting some awesom stuff like more superpowers and new friends. it was awesome till he introduced some assholes who decided to ruin the fun. if ya want a higher quality version my deviantart is http://statrux.deviantart.com/ so far i have gone into many places of those there has been the Spider-Man movie, Devil May Cry, X-man, Legend of Zelda Twilight Princess, and Kingdom hearts 2. there are also many other references . also say hi to the other main characters Tyler and Midna..yes that Midna the one from the game.', False, True)
add('MarXistemthewebcomic', 'http://marxistem.smackjeeves.com/comics/', u'Welcome to one of the slowest-on-knowing comics ever. Games, movies, technology and stuff else, here.', False, True)
add('MarioandLuigiMisadventures', 'http://mandladventures.smackjeeves.com/comics/', u'Cackletta is up to no good and stuff', False, True)
add('MariosDayJob', 'http://mariosjob.smackjeeves.com/comics/', u'A silly comic about Mario and Luigi\'s "real" jobs as Plumbers. Updates weekly', False, True)
add('MariovsSonicvsMegaMan', 'http://mvsvmm.smackjeeves.com/comics/', u"It's a battle of the three main video game mascots of the late 80's and the early 90's, Mario, Sonic, and Mega Man. Who will win this titanic battle worthy of Pay-Per-View?", False, False)
add('Mascara', 'http://mascara.smackjeeves.com/comics/', u"As the smartest boy in school and a prodigy, everyone expects Ian to be a high achiever--\x97a future Nobel Prize winning genius. But he doesn't want to be the next Einstein. He just wants to be a makeup artist.", False, True)
add('MattsUndergroundHotel', 'http://mattsundergroundhotel.smackjeeves.com/comics/', u"When an author joins, you MUST show your character choosing a room, and then edit the hotel rooms page with your character's face on the door you chose. Banner by nyancat6650.", False, True)
add('MaverickDaze', 'http://maverickdaze.smackjeeves.com/comics/', u'A Mega Man X based sprite comic. Set in the year 22XX as the Hunters must face their most challenging threat yet!', False, True)
add('MaytheRainCome', 'http://maytheraincome.smackjeeves.com/comics/', u'William Weasel returns home after seven years of war only to find his hometown deep in a drought, and his life eerily empty and devoid of meaning. ------------ This comic updates every day in full color, so try not to fall too far behind! May the Rain Come is rated PG-13 (for depictions of PTSD and scary moments). Inspirations: Black-and-white movies, cartoon animals, stories passed down through the family about the horrors of war.', False, True)
add('Mazscara', 'http://mazscara.smackjeeves.com/comics/', u'After her tragic suicide, Hollywood celebrity elite Victoria Starfield is ressurected and assigned by a secret supernatural organization called Crowd Control ,to protect five specific children (and her fans) from a slew of demons, serial killers, hellraisers and fallen angels. Her only weapon, 250 feet of razor sharp, flesh splitting barbed wire and an infinite trail of black tears. Call her, Mazscara. WARNING: Mazscara is rated +18 for Graphic Violence, Profanity and Mature Themes.', True, True)
add('McdonaldMishaps', 'http://mcdonaldmishaps.smackjeeves.com/comics/', u"What is Mcdonald Mishaps? MM is a work journal that I draw what happens during my workplace, the characters I draw are real people and all of the things that happen are 99.9% true. I live in the bad part of town and some of the things that happen may seem untrue but really it's just an average day. This is located in Eastern Canada Contains: Curse words and a hell of a lot of bromance. Updates: Mostly everyday as much as I can.", False, True)
add('MedleySoup', 'http://medleysoup.smackjeeves.com/comics/', u'Three teenagers- fun-loving, quirky new girl Alcy, naive, formerly-homeschooled hippie Todd, and antisocial butt monkey vampire Matt- band together in their journey through high school and beyond. Check out the main site at www.medleysoup.com', False, True)
add('MegaMaidenandTheChopChopPrincess', 'http://mega-and-choppy.smackjeeves.com/comics/', u'Two girls who love punching crims become superheroes. Mega maiden is intended for OLDER Teens and adults for crude humor, language & adult situations.', False, True)
add('MegaManBattleNetwork7TheWorldTournament', 'http://mmbn7-twt.smackjeeves.com/comics/', u'The year is 20XX... People are very lazy because they have Net Navis that do everything for them since even desks are controlled through the internet. Some people use these Net Navis for fighting and are called "Net Battlers". But, who is the strongest Net Battler? This tournament will decide that.', False, True)
add('MegaManSpriteExpo', 'http://megaman-sprite-expo.smackjeeves.com/comics/', u'Hello all, this is your host, Alienoid! And this is for all the Mega Man spriters that want to show their greatness! Some rules though: -Keep it family friendly. -Be nice on others. -Have fun. -Mega Man sprites only. -Any Mega Man series allowed! -Memes now allowed! Will accept any author applications, unless previously removed. Fan-characters, conversions, custom, WATEVA!', False, True)
add('MegaManTales', 'http://megamantales.smackjeeves.com/comics/', u'Follow the Adventures of G.B.A, a boy who ended up the MegaMan world and must find a way back home. Status: FINISHED! FOR REALZ NOW!', False, True)
add('MelodyAndMacabre', 'http://melodyandmacabre.smackjeeves.com/comics/', u'A little girl befriends Death and encounters those who seek him. An odd little series about obsession and... you guessed it... death.', False, True)
add('MementoMori', 'http://mementomori.smackjeeves.com/comics/', u"Agus & Karina are a lovely couple of college students enjoying their everyday life, until the day Agus receives a shocking new that will change his life forever. This is a pilot comic I did for publishing in my country, but since local publications aren't successful in here, it got scrapped.", True, False)
add('Metabooandfriends', 'http://metabooandfriends.smackjeeves.com/comics/', u'This is a comic where spriters of all skills and types can post their creations for constructive critisism', False, True)
add('MetalPhoneMouse', 'http://mpm.thewebcomic.com/comics/', u"History Metal Phone Mouse (MPM) is the result of several years of roleplaying forum activity turned into a weekly updated webcomic. MPM deals with everything, Action, Comedy, Drama, Adventure, and Fantasy. Our webcomic slowly grew some popularity on Deviant art where most of our work is put up, but now we feel its time to expand into our own website with the help of Smack jeeves. Story An adventure story of a disbanded group of Mercenaries comprising of Demon hunters, Mythological creatures, and beings of mysterious powers set in the modern world. Although lost loves, betrayals and mistrusts separated their group, they gather again to create a new team including new members. Filled with mythology of all forms: Demons, Angels, Vampires, Gods and Tyrants of heaven and hell, and twisted creatures from nightmares challenge the MPM team with originally created Lore. MPM is a new up and coming webcomic that's well worth a spot on your bookmark menu!", False, True)
add('MetroJack', 'http://metro-jack.smackjeeves.com/comics/', u"A gay ex-lumberjack and a straight metro-sexual room together while attending Boston College. Humorous shounen-ai hijinks and confused sexual orientations abound. BL/Yaoi UPDATES EVERY SUNDAY! Also I just started a Tumblr Blog for the comic, so I can spam you guys on tumblr with sketches and fanart that my friends have done for me, as well as progress reports on the latest updates so you'll know about when to expect the next page! Feel free to check it out here: http://metro-jack.tumblr.com/", True, True)
add('MidnightHunters', 'http://midnighthunters.smackjeeves.com/comics/', u'In the middle of the industrial revolution, magic and science collide. Strange machines, steam powered objects and mechanical devices are fuelled by dark magic. The Midnight Hunters chase and hunt Devils, spectres, vampires and other supernatural beings that lurk in the dark corners of the big cities. If you want to read more go to <b><a href="http://www.mangamagazine.net/manga/12">MangaMagazine.net! =D</a></b>', False, True)
add('MidnightPrince', 'http://midnightprince.smackjeeves.com/comics/', u'Jeremy Locke is just a normal high school student, but his best friend Erik has a secret. He\'s a vampire and not just any vampire, a prince! Alexei Drako is Erik\'s ex-fiance and he\'s the prince of Neutrals, a race mostly like the humans but with the power to use magic and known to live longer than five centuries. Two years after his painful break up with Erik, he\'s back to look for a new "wife" and has set his eyes on Jeremy! Will Erik let this happen and will Cleo Saint, Jeremy\'s stalker friend, allow it as well? *Not really planning to put mature things in it yet but it does contain strong language and sometime in the future partial nudity. It\'s not just Shounen Ai, there\'s hetero love too *UPDATES ON FRIDAY AND/OR SATURDAY*', False, True)
add('MineBlockComic', 'http://mineblock-comic.smackjeeves.com/comics/', u"It's like Minecraft, but it's two dimensional and the sprites are blocky! A story of heroes who try to save the world from hell! Beat evil and more.... Story by: Bluezero12", False, True)
add('Minibot', 'http://minibot.smackjeeves.com/comics/', u'Created from the "Minibot Command" threads on the Smackjeeves forums. People gave suggestions of what Minibot should do next and I drew them! Special thanks to MINIBOT COMMANDERS (listed alphabetically) Afrohawkman, AFStaff, Antitime, avian-reader, Bagpipe, Bat McStar, Beany, Bowserknight, BreakCanyon, Eggie, Gibson Twist, granmastern, Hunterkirizaki, Jake48.2, johlin, MacSimon, neoblade42, Pyroman, The Radical, robybang, skystears, SonicBoom01, SuperBiasedMan, Supertoad, and wendy w. Original threads here: http://www.smackjeeves.com/forum/viewtopic.php?t=10155 http://www.smackjeeves.com/forum/viewtopic.php?f=20&t=2534', False, True)
add('MinorActsofHeroism', 'http://www.minoractsofheroism.com/comics/', u'The adventures of three young superhero sidekicks!', False, True)
add('MixupofallMixups', 'http://mixupofmixups.smackjeeves.com/comics/', u"If you're looking for a good comic with a plot, I suggest not reading this. If you like randomness, Kirby, Tails and author involvement, then this is the place. Arcs are bound to happen, so watch for those. Accepts cameos. All characters and backgrounds used in this belong to their rightful owners, and credit goes to the people who ripped, edited and/or recoloured the sprites used.", False, True)
add('MobianChaos', 'http://mobianchaos.smackjeeves.com/comics/', u'Mobian Chaos: What year did rational thinking go out of style again?', False, True)
add('Mokepon', 'http://mokepon.smackjeeves.com/comics/', u"He wants to be the very best! That no one ever was... uh, no. Scratch that. Adventures and friendship were never something that appealed to Atticus... Shame that it's a pokemon world he lives in, and so teenage boys living in Pallet Town are not expected to sit idly by. But the life of a hero is not one he's about to consider; too much hard work for little reward, and so instead he embarks on his quest not to become the greatest... But at least, the richest. Although the biggest challenge may be ignoring the adventures and friendships which may attempt to ensnare him along the way... Updates Mondays and Thursdays.", False, False)
add('MomthegamestorerippedusoffAGAIN', 'http://crappygames.smackjeeves.com/comics/', u'Here are some game consoles. They are old. They don\'t work very well. They are slightly discolored. Did I mention that they don\'t work well? This comic used to be called "Mommy, my NES crapped out on me AGAIN!!!" but then I started showing some other console glitches.', False, True)
add('MonsterGirl', 'http://monstergirl.smackjeeves.com/comics/', u"An off and on comic first conceived during my elementary school years. The whole thing was pretty much a giant experiment for practice, though it's over now.Hope you like it if you're brave enough to read it! WARNING: This comic is EXTREMELY experimental, so try to ignore the ever changing artwork. Also it's pretty dramatized... Summary: A group of high school students have the ability to transform into animals, but what's the story behind their mysterious powers? Find out on their dangerous search for the answer.", False, True)
add('MoonlightApparition', 'http://moonlightapparition.smackjeeves.com/comics/', u'When Jason and his friends, Toby and Robbie, go out on an adventure to take a look at an old building, they get taken by surprise at the monsters hiding inside! Werewolves! However, it appears there is more to the existence of these creatures than meets the eye. Following along on a bumpy path, Jason and his friends embark on a journey discovering more monsters and their existence as well as the power within themselves. _________ THERE WILL BE STRONG LANGUAGE, SUGGESTIVE SCENES, BLOOD AND GORE, IN THIS COMIC! I RECOMMEND AGES 12 +', False, True)
add('Moonlightelement', 'http://moonlightelement.smackjeeves.com/comics/', u'in the world where elements can be control a simple farmer girl is capture by the fire king. But before he can get her to submit to him, the water kingdom attack takeing over the castle and comming across the poor farm girl.', True, True)
add('MorningtoMoon', 'http://m2m.smackjeeves.com/comics/', u'the humble life is anything but mundane. visit our site @ http://pink-noise.net/morning EDITED: our website is having technical difficulties, so apologies if you reached this site trying to find the comic. The comic here is almost completely up to date. We also have a mirror at http://www.mangamagazine.net/manga-and-comics/Morning-to-Moon/detail-page/122', False, True)
add('Mortifer', 'http://mortifer.smackjeeves.com/comics/', u"This comic has been completed! RATED WEB14 and up for gore and foul language! A mercenary team compiled of three men, Valentine, the asian prostitute obsessed with money, Mathew, a bloodlusting vampire with an anger problem, and Joey, an intellegent, but very odd, mercenary who always smiles. Things go well, until the presidency of the mercenary company is handed over to Joey, after mysterious death's of his competitors. Things slowly begin to get dangerous... and people's secrets begin to get exposed. Is Joey actually planning good things for the company... or something much more horrible?", False, True)
add('MrFactory', 'http://mrfactory.smackjeeves.com/comics/', u"Dee Bananahead is the coolest gangstah in da hood. Burglarizing 50 banks in 1 night? NO PROBLEM. But when she makes an outrageous promise to blow up the factory that everyone in the city hates, things start getting complicated. Updates, like, everyday. Unless it doesn't. But it typically does.", False, True)
add('MrGrimmsCircusofHorrors', 'http://grimms.smackjeeves.com/comics/', u'Lucia has a less than perfect life. One day she decides to run away. But there is one problem with her plan... She has absolutely no where to go. That is, until a strange flyer smacks her in the face. "A freak show huh? I\'ve never been to a circus before." Rated PG 13. Contains: Violence, some crude humor, blood, some romance.... Later.... This comic is boyXgirl. Reads right to left.', False, False)
add('MyFakeHeart', 'http://myfakeheart.smackjeeves.com/comics/', u"A tale of unending confusion, aggravation, adoration, and exclamation. Amanda's best friend just got dumped. How else to win her ex back than by pretending to date Amanda? Meanwhile, playboy of the school Zach has discovered he's rather bored toying with all the girls who fawn over him. After kissing Amanda's brother Leonard on a dare, he decides to do some follow up; he wants to know if he is so hot a guy would fall for him. Luckily for him, Leonard's already interested in his gender. Less work for Zach! In case you can't tell, it's full of gay kids. There's like, three straight kids total. If that doesn't float your boat, don't rock mine. Updates every Monday, Wednesday, and Friday. I'm also offering commissions to help keep myself alive.", False, False)
add('MyFriendScotty', 'http://myfriendscotty.smackjeeves.com/comics/', u"Scotty has always been an... outcast. He's seen as a creepy, mangy, weakling. But not to Nate, who's always been there to help him home with the bruises on his face. Until, one day, Nate finds himself torn between the line of friendship and more-than-friends... Not your average BL. Updates Sporadically. c:", True, False)
add('MyOasis', 'http://myoasis.smackjeeves.com/comics/', u"Includes YAOI(m/m,slash,boy love,shonen-ai) Hazu is the only son of Councilman Yuroba and is already set up to marry into another tribe.Bored of staying in the colony he ventures out one day only to come across a small expedition on their way to the mountain which protects their village.One of the young Archeologists,Johnathan,seems to catch Hazu's eye.A sandstorm blows in and everyone,expedition and Hazu,race to find shelter in a cave.At this close proximity Hazu seems to grow more attached to the young human and has the sudden urge to capture his interest in turn.Surza,his proposed,fights against their relationship entirely.Only more problems arise when Hazu chooses to protect him. Johnathan is merely a normal human.He doesn't talk much,he sticks to his books instead of with people,he has a love for everything made by nature,and is, apparently,Hazu's property.The human is abducted while he and his expedition protect themselves from a sandstorm inside a cave.There isn't anything special about him. But to Hazu he is every bit of everything. Updates: Hopefully Mondays AND/OR Thursdays. Do NOT hold me to it though! I'll try my best though!", True, True)
add('MySins', 'http://mysins.smackjeeves.com/comics/', u"It's story about choise and sin... A choice that can change an entire life... And sin that really is...", False, True)
add('MySistertheDragon', 'http://sisterdragon.smackjeeves.com/comics/', u'A boy finds an egg in the woods, and he and the dragon that hatches from it are raised as brother and sister. Hijinks ensue, including but not limited to the wacky variety.', False, True)
add('MyTwoCentsPlusTax', 'http://mtcpt.smackjeeves.com/comics/', u'In the modern world there are many evils out there. Super villains who want to destroy the world, Evil masterminds with plans for revenge, and bad dudes who go around not paying their taxes. It is up to Sanders, Jock, and Payton, three tax collectors, to bring these evil fiends to justice! Contains: [Cartoon Violence.]', False, True)
add('MyZombieDays', 'http://zdays.smackjeeves.com/comics/', u"Gags about zombie movie's cliche.", False, True)
add('MysticanDreams', 'http://mysticandreams.smackjeeves.com/comics/', u'A story about a war torn country lead by the Golden Raced Echo and her insane father who happen to clash against the Silver Raced queen and her plot to take over the entire country of Mystica. (Yuri)', False, True)
add('MysttheBookofAtrusComic', 'http://mystcomic.smackjeeves.com/comics/', u'An unofficial, fan-made graphic adaptation of "Myst the Book of Atrus" by Rand and Robyn Miller with David Wingrove. Prequel to "Myst" (1993), the best-selling PC game created by Cyan, Inc (now Cyan Worlds, Inc). Characters and story used with permission. Story: Atrus and his grandmother live alone in the middle of the desert. His grandmother excites him with stories about the D\'ni, a race of people who lived long ago. Atrus\' father, Gehn, comes to claim Atrus and share with him the amazing power of the D\'ni. When Atrus starts to question what he\'s been taught, how can he find out the truth?', False, True)
add('NERDALERT', 'http://nerd-alert.smackjeeves.com/comics/', u'The lives of a geek and a nerd - these things really happened. We hit nothing but books! Updates mostly on Sundays and Wednesdays nowadays.', False, True)
add('NIK', 'http://nik.smackjeeves.com/comics/', u"The Character: Nikolai is a young mage who shows great potential. He is able to wield magic without using his hands or chanting words by using the light magic he has webbed around him at all times. The Plot: The world has forever been balanced between good and evil. Each mortal lying somewhere between the two extremes. Now that a new mage has taken over the council, the light beings have a burst of power which breaks the balance they have with the dark beings of the world. And they aren't willing to keep the balance, no, the mage council decides to use this power for all they can and wipe out every ounce of dark-energy in their section of the world... This balance being broken can change many things. The mortals are directly influenced by the energies! But wouldn't a world of pure light magic be a good thing? ... (This is a BL comic.)", False, True)
add('Negligence', 'http://negligence.smackjeeves.com/comics/', u"Two kids, a bottle of mouthwash, and an almost non-existent parental figure. What could possibly go wrong, besides cult families, twisted public television shows, a baby's death, and a pseudo-incestuous relationship? Welcome to Negligence, a crazy journey.", False, True)
add('Nekoi', 'http://nekoi.smackjeeves.com/comics/', u"A university for semes and ukes >w> Warning: Yaoi, BL, BoyxBoy action Don't like, don't read. Author applications closed!", True, True)
#add('NekotheKitty', 'http://www.nekothekitty.net/comics/', u"Comic about a cute little kitty cat who's really quite cheerful about how much he hates everything. Ireland's #1 webcomic, online since 2002!", False, True)
add('NemesisKatharsis', 'http://nemesiskatharsis.smackjeeves.com/comics/', u"Jove is the descendant of the most powerful magical clan in Nokt'ader - the Aerin. She is expected to be a magic user of legend by her parents and clan. Unfortunately, she cannot even learn how to... levitate. With almost no affinity for magic, and considered the black sheep of her family, Jove harbors the ridiculous notion of one day becoming the land's... Arch Mistress of Magic! Updating schedule: heavily variable! :s I'm also working on Sailor Moon: The Enemy Next Door, and that's my priority :) but as this here is MY baby, I'll do my best to post often Genre: fantasy/adventure/romance Edit 10.12.2012: Regarding updating, I've decided to get more regular and update at least ONCE per week. What day of the week that will be is literally dependent on the position of the stars. But at least I'm introducing some structure. Yay!", False, False)
add('Nemutionpobae', 'http://pobae.smackjeeves.com/comics/', u"(loosely translated as: Nemution's jewel; this does not a literal form of jewel) ************** Once every 100 years, Nemution will be formed into a jewel his sould searching for his eternal lover. Once merged they must both accept each other for a complete transformation. However, because the lover is unable to recognize and prepare ones body for the merge, they destroy each other and are once again parted for 100 years; till nemution rises again and his reborn eternal lover is called to him. After many years of separation, Nemution has once again found his eternal lover; a promise and a vow, forever kept. But a new torment awaits the eternal lover. NOTES: (due to a friend wanting to see this comic on here) 1. the comic was re-drawn back in 2009, so the art is a bit wonky till it catches up 2. The comic content does contain yaoi, However, due to smack jeeves rules and regulations: that content WILL NOT be seen on this site, I can however leave a link to the actual page. so certain pages are edit heavily. 3. the prologue DOES NOT contain yaoi. 4. posting will be daily till it's caught up to the latest page: 1 page a day.", False, True)
add('NeoCrystalAdventures', 'http://neocrystaladventures.smackjeeves.com/comics/', u'My best, and longest lasting attempt at a sprite comic! Has a mix of things, ideas, and characters in it! All put into a dramatic/romantic/comedy setting! Currently numbering at 1200+ comics and still going strong, this comic is updated daily if at all possible! Enjoy your stay, and have fun reading!', False, True)
add('NiceKitty', 'http://nicekitty.smackjeeves.com/comics/', u"About Nice Kitty: It is the touching coming of age story of a young boy and his cuddly feline companion, trying to find love and acceptance in a world fraught with peril and harsh realities. Will the mysterious new friend they meet one fateful day be able to answer the call of their lonely hearts, and bring some life and color to their otherwise blue and lonely world? You'll laugh, you'll cry, you'll pray for it to stop, but It won't because you can't stop the rock and why are you still reading this? You came to read the comic so READ already. This drivel certainly won't help you understand the story any better. Get going! And just remember: Be nice to your kitty, and he'll be NICE to you..........", False, False)
add('NighHeavenandHell', 'http://newnighheavenandhell.smackjeeves.com/comics/', u'A grudge as old as mankind. Three travelers entwined by fate. This road, once travelled, can never be undone. Between damnation & salvation, you find the truth hidden by God, Nigh Heaven & Hell. //Updates Every Friday//', False, True)
add('NihilWandasJourney', 'http://nihil.smackjeeves.com/comics/', u'I did this comic in coorperation with a friend of mine. Drawings, idea, characters and translation [The originalversion is in German] are all my fault. Wanda strongly believes she is a princess and wants to prove it, since most people just do not want to pay tribute to her. Together with Avis, a wood imp who accompanies her out of pity, Wanda embarks on a journey to the Garucian Mountains to see the mighty wizard Hon-ar, whom she expects to trace her [as she believes] lost, royal parents. Unfortunately it turns out that the world has other plans for the young woman.', False, True)
add('Ninjad', 'http://ninjad.smackjeeves.com/comics/', u'Ally is a struggling comic artist with two overbearing Ninja characters bent on making her famous so they can become famous.', False, True)
add('NormalcyisforWimps', 'http://normalcyisforwimps.smackjeeves.com/comics/', u"Sonic and Tails have gotten bored of living away from civilazation and have decided to move to Onette, at least that's what Sonic decided. Warning: Contains Demonic landlords, magic, insanity, and something else I can't think of right now.", False, True)
add('OldElastikid', 'http://oldelastikid.smackjeeves.com/comics/', u'These are all of the old Elastikid comics from prior to February, 2011. This was before Joe decided to become a superhero, and consists mostly of gag-a-day jokes with no real overall storyline. The tone of the series was rather different, so rather than continue on this comic, I decided to release all of the new strips as a "sequel" comic continuing in the same continuity. You can read the current Elastikid strips at http://elastikid.smackjeeves.com/ which is still being updated.', False, True)
add('OneFrameGags', 'http://oneframegags.smackjeeves.com/comics/', u'One panel (and occasionally two or more) gag cartoons featuring no main characters.', False, True)
add('OneLastDay', 'http://onelastday.smackjeeves.com/comics/', u'The title "One Last Day" is the basis of all the strips in this series of one page comics. Each page is his "last day". In some vague way or another that is.', True, True)
add('OneRainyDay', 'http://one-rainy-day.smackjeeves.com/comics/', u'Basically a BL story like "the prince and the pauper" No sex scenes (at least not for a hundred pages or so) Mostly a cute story about a developing relationship (may have smexxy scenes depending upon how much courage I have) Aki was abandoned when he was eight, for ten years he\'s lived on the streets with nothing but his wits and strength to support him. Needless to say he is unhappy. But one day he runs into some one who looks exactly like him! This mysterious boy turns out to be the young master of a large corporation who just wants to be free and discover himself. Aki and this mysterious boy trade lives for the summer and Aki\'s doing fine in his new life until his identity is discovered by the mysterious boy\'s intimidating body guard named Kaidou. Can a love bloom between a stoic individual and a street rat? Edit: even though it says "mature content" nothing mature worthy happens for awhile >_> Just something I thought you should know :3', True, True)
add('Onlyonelovesong', 'http://onlyonelovesong.smackjeeves.com/comics/', u"[available as a paperback on Indyplanet with a few extra spicy pages, revamped dialogue and prettier speech bubble arrangement!] A spoiled, frustrated and capricious rock star accidentally meets a common girl seemingly imprevious to his charm. Hiding his true identity from her, he selfishly decides to make her fall in love with him. But as he gets to know her better he finds himself falling instead. Only, there's a secret in her past keeping her heart locked away... [story specs: BOY x GIRL romance, mostly comedy, some heavy drama, censored swearing, occasional gratuitous male fanservice] [tech: b&w pages, color covers,hand-drawn&inked then photoscreentoneshopped to death]", False, True)
add('OntheBrightSide', 'http://onthebrightside.smackjeeves.com/comics/', u"Jacob is a very shy boy who lives a fairly quiet life. But one day, a family moves in next door to him. The oldest daughter, Kaylee, is a very kind and optimistic girl who is the same age as him.... and to his surprise, she is also his old best childhood friend! It's been eight years since they have last seen eachother, but after Kaylee's return, his life is never the same. *Updates: Random for now This is my first comic and I'm always experimenting with new techniques and keep trying to improve, so constructive criticism is always welcome. I'm also in the process of redoing the comic and replacing the old pages. So if you're wondering why my style has changed after a few pages, that's why! Other than that, I hope you enjoy the story!", False, True)
add('OperationTheater', 'http://operation-theater.smackjeeves.com/comics/', u'"It\'s only Paranoia if I\'m wrong. I can handle being wrong, but if I\'m right I\'m screwed!" Bastian Weber is a weird geeky jitterbug, a punching bag for everyone, but his life turned upside down when he met Izrael and Claudius, two strange guys who are living at his attic... [CONTAINS BL/GL, sexual confusions, comedy, drama, gore, horror, blood, some bondage, crazy people and lots of shit XD] So if you like weird people, unprecedented fights, Nerds/Geeks, friendship and a hero who gets mortally injured on a daily basis, get some snacks and look forward to "Operation Theater"! P.s. - I\'m pretty bad at sticking with genres, so this is supposed to be a bloody comedy with added drama and lot\'s of gay jokes :I P.p.s. - It\'s not porn', False, True)
add('Ophir', 'http://ophir.smackjeeves.com/comics/', u'This is a world where stone artifacts are the means of technology... A 16 year old girl named Sapphire, wanted to become the greatest archeologist. But in order to obtain that dream, she needs to find the most powerful stone artifact that can only be found at the edge of the world, Ophir. Genre: Shounen/Comedy/Fantasy/Action updates: 2x a week Monday and Thursday', False, True)
add('OpteisenArcumShowcasium', 'http://opdiskshowcase.smackjeeves.com/comics/', u'My sprite dump because I need one...', False, True)
add('OptimalClutter', 'http://www.optimalclutter.com/comics/', u'Day to day, project to project lives of a group of developers/engineers, and the people that surround them. (Updated Tuesday, Thursday, Saturday, and 1st of the month) (Random once a month strips have moved to the Extra Pages site)', False, False)
add('OrangeJunk', 'http://orangejunk.smackjeeves.com/comics/', u'This is the story of Louise Barton, a former-rich girl that now has to attend a public high school filled with delinquents and weird people. Here, she meets Bruce, a rude and violent ruffian who\'s actually a top student, and Drew, a handsome and cool-looking guy who\'s actually a pretty calm and air-headed otaku. "Never judge a book by its cover", that\'s what she learnt once these 3 teenagers had to team up to save Louise from failing her exams... Genres: shoujo, comedy, school life Reads from left to right -->', False, True)
add('OtherSideoftheBlade', 'http://osotb.smackjeeves.com/comics/', u'All Sergius wants is to be left alone in the Vatican library with the hundreds of tomes he has acquired during his exile. All Garter wants to do is flirt with cute girls, eat great food, live his life, and kill whatever monster of the day the Vatican sends him. The last thing they want to do is deal with each other. Warnings: Blood & gore, some sexy stuff, a pinch of religion, and crabby librarians Currently Updating on FRIDAYS', False, True)
add('OverlordofRavenfell', 'http://ravenfell.smackjeeves.com/comics/', u'Site Mirror: original comic can be found at ravenfell.com Razin wants to be an Evil Overlord and wreak havoc on the world. He just has one problem...his personality.', False, True)
add('PKMNIPOReLux', 'http://reluxplus.smackjeeves.com/comics/', u'This takes place 30 years after the events in the PKMN anime and mangas. Battling and Contests competitions went to the international level letting trainers and coordinators to show their skills to the world. 1) Battles - In order for a trainer to qualify for the world finals, they must defeat 8 ultimate gym leaders. These gym leaders are tougher than all the Elite Four groups and champions in the PKMN world. 2) Contests - A coordinator can only qualify if they have a perfect record and within the 30 years a lot of these kind of people have popped up. Story: One of the IPO gym leaders is stepping down and the successor in currently a gym leader in training in Shinou or so you think...! --- *Disclaimer: This is a fan-comic crossover and the characters that are from other medias belong to their respective owners and not me. *Also any apologies for making you confused...which will be most likely be the case... *Read Right to Left <----------- *And apologies for any inconsistent mass uploading of comics as I am ....very inconsistent... Sorry.', False, True)
add('PMDSkyNuzlocke', 'http://giginuzlocke2.smackjeeves.com/comics/', u"Part 2 of Gigi's Nuzlocke adventures~ This time Gigi loses her memory (again!) when she is mysteriously turned into an Eevee. Joining Kiara the Vulpix, can they solve the mystery of time and space? ~A Pokemon Mystery Dungeon: Sky Nuzlocke", False, True)
add('PMDTeamFireFox', 'http://pmdteamfirefox.smackjeeves.com/comics/', u"What happens when you turn into a pokemon, forget everything, and lay unconsciously on the beach? Go save the world from time freezing, obviously! Well that's just what Team FireFox is going to do! It's a gijinka comics :3 Oh yeah, art gradually gets better. Grammar? Not so much.", False, True)
add('PMDVictoryFire', 'http://victoryfire.smackjeeves.com/comics/', u"Sometimes the most interesting stories come from the strangest places. Victory Fire starts off as most Mystery Dungeon comics do, a human comes to the pokemon world. But THAT'S where the similarities end.... New pages are posted on Tuesdays and Fridays, please check back :)", False, True)
add('PRAGUERACE', 'http://praguerace.smackjeeves.com/comics/', u'PRace is a story about friendship and adventure. Author is Petra Erika Nordlund, also known as LEPPU and her other artwork can be found from tumblr and deviantart with the same nickname. email for contact is petra.nordlund at gmail.com', False, True)
add('PSY', 'http://psywebcomic.smackjeeves.com/comics/', u"If you could have any power, what would it be? The ability to move things with your thoughts? The ability to read people's minds? Or maybe the power to control living things? In a world where psychics must hide their powers from the people around them, specialized psychics called Kinetics must learn to master their powers, while still keeping their powers a secret from the world around them. ------------------------ Volume 1 now on sale! http://psystore.bigcartel.com/", False, False)
add('PTO', 'http://pto.smackjeeves.com/comics/', u'"I just want to feel loved" The year is 2374 in the future. What is going to happen, when a gang of useless men adopt an adorable living doll? Well, a lot of drama and heartbreaks, that\'s for sure. ---- UPDATED EVERY DAY! Includes sex, nudity and a bit of violence. Check out also (http://ptobonus.smackjeeves.com/)', True, False)
add('PagesofLife', 'http://pagesoflife.smackjeeves.com/comics/', u"I'm making a webcomic about my life because someone on the internet told me to.", False, True)
add('Paleglow', 'http://palexglow.smackjeeves.com/comics/', u'Pale*glow is a yaoi series about Murdoc and his lover Ridely and all their mis-adventures. Murdoc is a half-fox demon who works as a bounty hunter to pay the rent, and Ridely is, well, human! Comedy and action ensues while getting laid along the ways! WARNING: THIS COMIC CONTAINS MATURE SEXUAL CONTENT AND ADULT SITUATIONS! THIS IS YAOI, MEANING MALE/MALE!!! 18+', True, True)
add('Panacea', 'http://panacea.smackjeeves.com/comics/', u"Caelen is part shapeshifter but his dual heritage becomes a curse when he learns his unstable body is slowly deteriorating. Life seems pretty miserable and pointless. With no faith in himself and even less faith in others he\x92s very much sunken into pitiful state. After hitting his lowest point, landing in the streets with nowhere to be, he manages to catch the attention of a stranger. Will Sairys' compassion and cheerful attitude be enough to break through the barriers Caelen manage to erect around himself? *~*~*~*~*~*~*~*~*~*~*~*~*~*~ Boy Love Warning! Hopefully I'll manage to update once a week. You can expect new pages on Mondays and Thursdays... usually, unless something comes up and I can't make the deadline.", True, False)
add('PanzerDragonandEnigmaCompleteEdition', 'http://panzerdragonandenigma.smackjeeves.com/comics/', u"As a world reaches its peak of prosperity, instability begins to reveal itself as Dragonenix falls into a period of darkness. Three warriors will rise to the challenge to solve the mystery of their world's instability and set things right. The Complete Edition of Panzer Dragon and Enigma contains the full unabridged story of the entire First Arc series, including the first season of the PDE(+) Saga: Twilight Dawn. The last major update was November 16, 2011, with Twilight Dawn added to the archives as of March 20, 2012.", False, True)
add('PanzerDragonandEnigmaZwei', 'http://pdezwei.smackjeeves.com/comics/', u'Panzer Dragon and Enigma Zwei is the re-telling of the original story on SmackJeeves about protagonists Panzer Dragon, Enigma, and Niavana Avalon as they become involved in protecting their home from the move of a mysterious organization, spiraling into a battle that will decide the fate of so many worlds and reveal to this trio their destiny. Click on "PDE: Complete Edition" to check out the original story, but you do NOT have to read the Complete Edition to understand what\'s going on in PDE Zwei. Nevertheless, it\'s still an awesome read and you should check it out if you want an idea of my past works. Comics available every Monday, Thursday, and Saturday at 12:00PM EST!', False, True)
add('Paradox', 'http://paradoxcomic.smackjeeves.com/comics/', u'Taken as prisoners of war, Dake and Tommy are sold as slaves, one to a wealthy but kind woman, the other to a man of unknown species who has a very bad habit of eating people. Forced to endure the horrors of war, racism, homophobia, and the occasional molestation, can these two opposites somehow attract? Contains sexual situations, violence, drug use and probably many other bad things.', True, True)
add('Parallel', 'http://ll-parallel.smackjeeves.com/comics/', u'Parallel... After the humans died off long ago, used to fighting battles, the Pokemon are on a verge of killing themselves off... one by One by, One... Who are the culprits behind this? What ever happened to a world of peace and beauty? Are they forever gone? "Friends unite... we will find the source, and I swear by my very own soul, we will find the solution to our planet and bring back peace and order to the World Of Pokemon." ~~~~~~~~~~~ Adventure, Some Romance... (don\'t know what else to put, i\'ll add more stuff later) ... but basically SERIOUS stuff - (i don\'t know about funny, whenever i try to make a joke it turns out not to be funny at all... but i will try.) ~~{{ There WILL defenatly be a problem, climax, and "LOL" maybe a solution xDD Jk there\'ll be a solution don\'t worry Xdd }}~~ Warning: Might contain language, violence (blood etc.), NO BL, GL (sorry). -- Updates will be slow-- Read from Left to Right. ~~~~~~~~~~~ Note: My other comics will probably not be updated in a very long time since i\'ll be working on this one the most.', False, True)
add('PastaMonsters', 'http://pastamonsters.smackjeeves.com/comics/', u"this comic is just my idea of what a creepypasta world would be like. no its not meant to be taken too seriously, its mostly a way for people who are severally disturbed by creepypasta to have something to help them gget over their fears. so here is a comic that will make you laugh, giggle, and smile. i know it's hard to be scared guys, this comic is here for you. I hope you enjoy Pastamonsters i know i love making it! i have to put this up here for a slight confusion a few people had. i do not own any of these characters, they belong to whoever made the creepypastas respectively.", True, True)
add('PerplexingMagnoliaDisruption', 'http://smgpmd.smackjeeves.com/comics/', u"Perplexing Magnolia Disruption is a serious comic filled with love, hate, drama, and... Who are we kidding, it's a Team SMG Pokemon Comic. Don't expect this to be serious at all. COMIC COMPLETED. The sequel can be found here: http://www.smackjeeves.com/comicprofile.php?id=118656", False, True)
add('PeterPan', 'http://peterpan.smackjeeves.com/comics/', u"A manga adaptation of the classic children's story Peter Pan. Closely following J.M. Barrie's original story, come follow the adventures of Peter and the Darling children in Neverland! If you've never read the book, here's your chance to experience the real story! If you have, and enjoyed it, then this is the comic for you! If you like the comic, and have Facebook, pop on over to Tria Elf9's Neverland, the FB page for the comic! It updates with the current pages on deviantart. Hope to see you there! https://www.facebook.com/TriaElf9sNeverland Peter Pan is also posted to Deviant art: http://triaelf9.deviantart.com/gallery/32562528 And on Manga Magazine: http://www.mangamagazine.net/manga-and-comics/Peter-Pan/detail-page/798?lang=en", False, True)
add('Phantomland', 'http://phantomland.smackjeeves.com/comics/', u"UPDATES ON THURSDAYS Santa Luison is a large city that employs it's strange minority of subhumans at a crime fighting organization. Introduce Chie: a fresh little rookie who receives her training from the baddest, meanest veteran officer around. Phantomland started as a self-published print comic back in 2009 and is now getting it's online debut at Smackjeeves. To know more about this comic, visit the homepage at: http://amph.nipponfever.net/phantomland", False, True)
add('PiecesofBrokenGlass', 'http://piecesofbrokenglass.smackjeeves.com/comics/', u'COMPLETED: 6/9/11 "Humpty Dumpty sat on a wall, Humpty Dumpty had a great fall; All the King\'s horses and all the King\'s men... Couldn\'t put Humpty together again." Sometimes...even revenge isn\'t enough. UPDATES: On Thursdays MATURE CONTENT WARNING: This comic contains scenes which may be offensive. Proceed with caution!', False, True)
add('PirateCthulhuComics', 'http://pccomics.smackjeeves.com/comics/', u'Needlessly wasting smackjeeves bandwidth since 2009, while in possession of better crab!!', False, True)
add('PixelatedToaster', 'http://pixelatedtoaster.smackjeeves.com/comics/', u'Pixelated Toaster is a "gag-a-day" comic that updates twice per week! Following Cam, Ash, and Norm\'s observations and events!', False, True)
add('PlanetChaser', 'http://planetchaser.smackjeeves.com/comics/', u'In the future when 18 year old Clarissa inherits a spaceship and a robot, little did she expect the trouble that goes with it. Being orphaned, she begins to learn about her parents and an alien who rules over humankind.', False, True)
add('PlayTime', 'http://dollysplaytime.smackjeeves.com/comics/', u'Megumi was just a timid high school girl trying to cope with life until the day a magic ribbon came into her life and a new hero was born!', False, True)
add('Pleasebemyboytoy', 'http://pleasebemyboytoy.smackjeeves.com/comics/', u'Takeshi likes Atsushi. Atsushi accidentally promises the creepy biology teacher a date with Takeshi... Right to left, please <3---', False, True)
add('PokefarmingRiseFromtheAshes', 'http://pokefarming.smackjeeves.com/comics/', u'http://pokefarm.org/ IF YOU HAVE A POKEFARM ACCOUNT YOU CAN JOIN. A second Pokefarming since the old one was deleted by some douchebag. >:I All about Pokefarm. Post your eggs and pokemon, etc. Anything Pokefarm related.', False, True)
add('PokemonBreak', 'http://pokemonbreak.smackjeeves.com/comics/', u'*Main plot starts at chapter three* There is only one Pokemon capable of learning any move, and that\u2019s Mew. Project HM 00 wants to change that. During the project\u2019s test run, a program error occurs and Missingno, an incomplete Pokemon is created. Missingno has no real form and needs oran berries to stay alive. It has no intentions of staying incomplete, though, and it\u2019ll stop at nothing to find what it\u2019s missing. -Pages are now in color (starting with Ch 5, pg15) -Updates: As often as I can!(At least a page a week, hopefully)', False, True)
add('PokemonEdge', 'http://pe-09.smackjeeves.com/comics/', u"A young, ambitious trainer meets Sonic the hedgehog on his journey. But soon chaos takes place and it'll be up to them to stop it to save the world of Pokemon!! Pokemon/Sonic crossover. Rated T+ 2009-2013", False, True)
add('PokemonMysteryDungeonStrikedownChronicles', 'http://pmdsc.smackjeeves.com/comics/', u'A party of Pokemon find themselves on an island and try to get back home. But there is more going on that what it seems. (Question marks will be replaced as actual party members surface)', False, True)
add('PokemonSAKOHJU', 'http://sakohju.smackjeeves.com/comics/', u"Different adventures kick off with different characters in different parts of the Pokemon world! There's darkness in the Pokearth, and it's not just Team Plasma. A group by the name of Team Midnight is on the rise. However, their biggest obstacle appears when the protoganists come together to form SAKOHJU, an organization dedicated to ridding the Pokemon world of evil. As the fight rages, it's unclear how many will make it out alive, as it all comes down to SAKOHJU vs. Team Midnight... ____________________ I started this comic a couple years ago so some parts of it (beginning especially) aren't all that good. It's become more of a sketch comic and it's a learning experience for me, I improve and as my first project I'm seeing this thing to the end no matter what. I also have lots of characters based off real people. I will say that now. Also breaks the fourth wall. A LOT.", False, True)
add('Ponzi', 'http://ponzi.smackjeeves.com/comics/', u"About: It's a new beginning, a new age and a new world where people enjoy advanced industrial games, technology and entertainment. At this moment, after a mysterious broadcast, the world media has launched a new tournament called N.E.O.SIN. The prize for this competition is unlike any other, the winners will receive an evolutionary enhancement of their body. This enhancement will improve their physical and mental capacity as a human being. Ever dream of super speed, super vision or any other kind of supernatural enhancement? Who will win the key to the evolution of the human race? (You can read more info on the official site: www.pigtailstudio.com )", False, True)
add('PrettyUgly', 'http://prettyugly.smackjeeves.com/comics/', u'Katie Smith was recently cheated on by her boyfriend Kyle, with none other than her best friend Sarah! Dejected and alienated because of her plain appearance, she suddenly finds herself surrounded by new friends who turn out to be just as problematic as she is. Will she ever be able to be the girl she knows she is inside? NOTES FOR FIRST-TIME READERS: -Chapters 1, half of 2, and 6 and up, are all colored. Chapters 3-5 will be colored eventually, so please excuse the sketches! (They are still readable, don\'t worry!) -There are lots of characters. At the end of Chapter 1, I have character reference sheets. You may want to refer back to them if you get confused. (Sorry...) -Pretty Ugly updates randomly, but usually once a week/every other week, because I like to have at least 3 pages done before I post them. So definitely take advantage of the "save your place" options (: Thanks for reading!!!! *hugs you*', False, False)
add('Puck', 'http://puck.smackjeeves.com/comics/', u'Puck is a weekly webcomic that, in the words of one fan, is "mostly irreverent humor concerning a pretty girl with freckles and a hot she-devil who wears fan-service costumes." That\'s about right. Surreal fantasy slice-of-life crazy-type stuff about the world\'s funniest redhead! Updates Tuesday.', False, True)
add('PulseandBolt', 'http://pulse-bolt.smackjeeves.com/comics/', u'Two female human batteries become armored superheroes.', False, True)
add('PumpkinFlower', 'http://pumpkinflower.smackjeeves.com/comics/', u"CONTAINS: BL When being stalked by an amnesiatic ghost is the best thing going for you there may be a problem. Now if only the ghost could understand the term 'personal space.'", False, True)
add('Purple', 'http://purple.smackjeeves.com/comics/', u"Red is a 9 year old boy who is on an adventure to visit his dad's house with his best friend Blue. Along the way they fill face many challenges!", False, True)
add('Quickening', 'http://quickening.smackjeeves.com/comics/', u'Quickening: the ability to manifest your soul energy in the form of a weapon. --- Tony Lockhart is a senior student who attends one of the most prestigious schools in the country: Rowan Academy, which is known for its discerning methods of teaching the art of Quickening and combat. Every day he faces giant robots, giant reptiles, rabid fangirls (but not HIS fangirls), sadistic teachers, and anything that can put him in a life-or-death situation. All for the greater cause. Or so they say. But, really, he just wants to graduate with all his limbs intact. -- READ RIGHT TO LEFT', False, True)
add('QuiteNiceComics', 'http://quitenice.smackjeeves.com/comics/', u"Welcome to a world of mysticism, intrigue, and chaos. Where warring powers turn the tides of time itself to their bidding. Where deception is a virtue and the truth an executioner's axe. ... Actually, that's the comic next door. This is Quite Nice Comics.", False, True)
add('ROSIER', 'http://rosier.smackjeeves.com/comics/', u"[COMPLETED WORK] A Dark Fantasy Romance: Vanney is a ditzy acolyte at the Temple of the God of Wealth and spends her days daydreaming about adventures with her best friend Jaelia. When the Temple sends the two of them to escort a caravan to the mysterious, far-off border town of Shadow Charing Vanney's time for adventure has come. But her sunny imaginings have nothing to do with the shadowy world of witches, demons, magic and netherworlds her path takes her to...", False, True)
add('RainLGBT', 'http://rainlgbt.smackjeeves.com/comics/', u'Written by Jocelyn C.D. (aka LittleLynn84) "Rain" is a comedy/drama that follows the daily life of teenage transsexual (who is coincidentally named Rain) attempting to go through her senior year being only identified as a woman. I\u2019d like for it to be very funny and entertaining, but the story will also touch on many rather heavy subjects including acceptance from family and piers, blind hatred and many of the other difficulties faced by members of the LGBT community. This comic contains: - Occasionally strong language - Sexual themes and situations (but no nudity) - Gay, lesbian, bi and transgendered (and straight) characters - Lousy or non-existent backgrounds', False, False)
add('RaisonDetre', 'http://raison-detre.smackjeeves.com/comics/', u"When flamboyant Brit Alastair moved to America, he thought he'd acomplish a little more than setting up a failing pizza take away business after his Harvard education. After being deemed infertile, neither did be beleive his pipe dream of starting a family would ever be possible. However following many odd twists of fate, he finds himself being the legal guardian of 4 children/adolescents each with their own unique quirks and of course, problems. But dispite his best efforts. following a devastating accident, he finds it incredibly difficult to function within the busy New York lifestyle, let alone tackle 4 children alone. After being confronted with his first genuine italian applicant for the new chefs job, could Luca Giovanni be the most complex new addition to this disfunctional family? And what could be the reason behind Alastairs unhealthy attachment to him? Updates Sundays Comedy / Drama / Slice of life / Romance [of whichever nature the plot calls for] >>>>>>>> Read this way >>>>>>>>>", False, True)
add('RandomPokemonGagsandPicsinc', 'http://randompokemongagsandpicsinc.smackjeeves.com/comics/', u"A hilarious comic filled to the brim with gags and laughs galore made by the author and coauthors of this comic! Nine out of ten nurse joy's recommend reading this comic! What are you waiting for? Use click the banner attack and begin reading! click it, I dare ya. FREE TACOS INSIDE!", False, True)
add('Rasputin', 'http://rasputin.smackjeeves.com/comics/', u'Rasputin is a grey haired kid who moves to the big city! Oh what horrors awaits him in this new town!? Angry redheads? Pedo teachers? Closet hookers!? yup. AND MUCH MORE! Hope you enjoy my comic >8D !', False, True)
add('ReidyandFriendsShowcase', 'http://reidynfriends.smackjeeves.com/comics/', u"A general showcase where pretty much anyone can post anything they want, barring porn. Maybe. Probably. We also try to be civil whenever possible, so don't go out of your way to piss people off. Other than that just sit back, relax, and enjoy the showcase. Anyways, you should have at least SOME experience spriting before applying to join, should you want to. We don't accept recolors and are very much against sprite thieves. Send all applications to Reidy. Hah, no. He's dead. Just hit the apply button.", False, False)
add('RemoteAngel', 'http://remoteangel.smackjeeves.com/comics/', u"READ FROM LEFT TO RIGHT. UPDATES: Updates 2-3 times a week! Alice Desangi has been having this obscure dreams lately and leads to this demon, Rose, to attempt to kill her. She discovers that she's an angel of God. One of the children of light who God chooses in the world. Her deceased sister, Becky, gives her hints on dealing with the goodness and evils of the world. The mysteries behind Alice, her friends and enemies begin to unfold as the story goes on. Genre: Action, Comedy, Romance, Slice of life, Supernatural, Drama Please read if you like drama/romance type of things.. :3 Warning: There's some bloody moments later on in the series. And some mild nudity.", False, True)
add('Replica', 'http://replica.smackjeeves.com/comics/', u'Edelric Helgard, a young Marquis, returns to the house of his childhood in order to save his family\u2019s lands from an epidemic. During his research, he encounters a foreign slave who looks disturbingly like his first love, his late half-brother. Thus begins a game of replicas mingling memories and reality. -Read from Left to Right -Boys Love -R-18 from chapter 2 onwards -Updates on Fridays', True, True)
add('Republicanattackmachine', 'http://www.republicanattackmachine.us/comics/', u'Life is about many things. But at this site it is mostly about discussion and observation. Here you can have a discussion with a Republican. Not the National Republican Party, nor a Republican office holder, staffer, or aide. Here you will see what one Republican thinks. An individual. And you will discover, hopefully, that we like to laugh as much as anyone. If its your first time talking to a Republican, welcome.', False, True)
add('RequiemShadowbornPariah', 'http://shadowbornpariah.smackjeeves.com/comics/', u"A bad job, a betrayed assassin. Now she's on the run from the very people with whom she once worked. Locked into the world of the Immortals, Anastasia V\xe3duva has lived in the shadows of Eastern Europe for over two centuries. Forced to flee to the New World with the promises of shelter - she finds no salvation. The New Kingdoms are possibly even more dangerous than anything existing within the Elder Illuminati demesnes. Armies march to the drums of the Requiem, nations rise and fall to the whim of the Illuminati - and they want her dead. Updated Sundays and Thursdays", False, True)
add('ReturntoEden', 'http://rte.smackjeeves.com/comics/', u"When you're the last angel remaining, being mistaken for Satan's lunch is *not* going to make things easier.... (may contain fun stuff like angels, demons, complete disregard for the bible, crazy people and bare butts, sometimes bare-butted crazy people. Add a hint of BL, and you've been warned)", False, True)
add('RevivalPsalm', 'http://revivalpsalm.smackjeeves.com/comics/', u"the story takes a place in the middle of nowhere... it is the place that's been forsaken by time where there is always dark clouds cover the sky but never rain where there is a monster who loves to fed on the broken spirit.... they tear apart the spirit with their sharp tails and enjoy the dying scream which come from these spirit.. these spirit are trying very hard to escape the claw of the monster.. but their ways are hardly working... and then on a rainy day Veritas came... ================ eh..still trying to figure out how this site works.. maybe I should update in a less random manner..", False, True)
add('RiggsHell', 'http://riggs-hell.smackjeeves.com/comics/', u'An unusual noblewoman disguises herself as a man to try to take over the world, one kingdom at a time. With a sour advisor, a stoopid prince, a talking dog, a vengeful archenemy along with some ridiculous events standing in her way, will she be able to accomplish her goal or go crazy trying? Rated Teen for some gore and swearing.', False, True)
add('RockMyWorld', 'http://rockmyworld.smackjeeves.com/comics/', u"The upcoming J-rock band Battle-X balances on the brink of despair. And the cause of all this mess is the vocalist Rin Kawatake, who just can't seem to get a hold of his behaviour. When another bandmember leaves the band for the fifth time this year, the bandmanager puts his last hope into the new guitarist, named Teika Yoshida, the guy who just could be the solution to all of their problems! But not only that.. Because when they meet for the first time, Rin immediately seems to take a very special interest into this cute guy... YAOI/BL!! :3 updates a few times a week (I used to update everyday but... yeah, school's a bitch)", False, True)
add('RoyalAuthorShowcase', 'http://royalshowcase.smackjeeves.com/comics/', u"Here's a place where anyone who wants to post anything at all can. Sprites, drawings, etc. 20 Author Limit. Admin now Daniel Sokolov Rules 1. Everything must be made (or involved in the making some way (Fan-Art of the Authors Characters etc. etc. etc.) by the Author 2. If something is TOOOOOOO distasteful or argument probing, it'll be taken down. (But that's only if it's THAT bad. Other than that, MEH.) Originally (Random Author Stuff)", False, True)
add('RoyalIcing', 'http://royalicing.smackjeeves.com/comics/', u'AVAILABLE IN PRINT AT AMAZON.COM! Look for "Royal Icing Graphic Novel". Synopsis: When little Emily bakes a cake, she gets more than she bargained for. Strange flora and fauna, a cold-hearted prince, and a mystery that must be solved before she can return home from the Sucre Isles. What adventures await her in the land of curious candies?', False, True)
add('RozeFighter', 'http://rozefighter.smackjeeves.com/comics/', u"In the year 2310AD a young man, Apollo (Mitsu) Kurosu, makes a life change decision that could possible change his entire life. Now he has to find nine magical crystals and defend himself from all sorts of baddies- All while fighting along side his best friend's little bratty sister! Join us on Wednesdays and Saturdays!", False, True)
add('RubyNation', 'http://www.therubynation.com/comics/', u"This is the story of Ruby Harrison, former middle-upper-class American high schooler turned nine-foot-tall post-human person of mass destruction. Dragged into a worldwide conspiracy that treats human beings as mere test subjects, Ruby's goal is to create a safe haven for her fellow post-human victims. But their powers are too valuable for the world to let be, and Ruby and her comrades will have to make hard decisions to preserve her new home.", False, True)
add('RubyRed', 'http://rubyred.smackjeeves.com/comics/', u'', False, True)
add('RubysWorld', 'http://rubysworld.smackjeeves.com/comics/', u"Ruby's Harrisons plans for Stanford have been derailed a bit--a natural consequence of the science accident that happened to her during a summer internship, leaving her mutated into a much larger, stronger, and more powerful form. But the accident also made her aware of a conspiracy tied all the way back to her late mother, with human beings being kidnapped and surgically twisted into genetic weapons. Now, with other young people traumatized by this reprehensible use of science, Ruby tries to find justice in a world that prefers power...", False, False)
add('RyakLo', 'http://ryak-lo.smackjeeves.com/comics/', u'', False, True)
add('SAKANA', 'http://sakana.smackjeeves.com/comics/', u'A thrilling tale of two socially dysfunctional brothers working at the largest fish market in the world, and the things they must do to get paid, make friends and date ladies. Also, this comic updates a few days ahead of time on Mangamagazine.net! http://www.mangamagazine.net/manga-and-comics/SAKANA/detail-page/125', False, True)
add('SChIzO', 'http://schizophrenic.smackjeeves.com/comics/', u"Hector never seems to want to leave Ruby alone. He's always there, bugging her and tracking her every move and she can't stand him much longer. Of course...she has to learn to live with it seeing as he isn't going anywhere. Afterall, he IS just that little voice in her head. Join the schizophrenic Ruby, her mute best friend and roommate Kenneth, their eccentric neighbor Lynn and a whole cast of oddball characters as they try to live through the everyday trials of moving out and living on your own...despite being a little messed up in the head.", False, True)
add('SFCForestofDreams', 'http://sfcforestofdreams.smackjeeves.com/comics/', u'A strict, megalomaniacal lioness. A egocentric, muscular vampire. A sarcastic, antisocial eraser. A surprisingly sane blob. A small, mute pikmin. An optimistic, friendly green thing. A stubborn, determined mouse. A curious woman from the future. A meek, brilliant scientist. A calm, fatherly fighter. A serious, taciturn war veteran. A crazy, hyper girl. A confident, eager architect. A savvy, sly chimpanzee. A frustrated, busty teenager. A sad, lonely emo. A fangirlish, lovestruck fairy. A dominant, genius octopus. A loud, grumpy senior citizen. And a sadistic, creepy alien. Who will win the $1,000,000 grand prize?', False, True)
add('SLightlyabOVeavErage', 'http://slightlyaboveaverage.smackjeeves.com/comics/', u'Keiko Tachibana is an average High school girl. Scratch that. She\'s a self proclaimed "Slighty above average" High school girl who has dedicated herself to being only moderately better than the social norm. However one day she gets a visit from someone Way over the top. An inter dimensional cutie whom goes by the name Llla-Elac Ngtholi Cllegogg, also known as "Laila" to humans. She has come to destroy the sanity, and lives of everyone at Daisuke Ryuzaki high school. However, poor Keiko seems to be the only one at school whom has noticed this terrifying beast, and to make matters worse, she\'s staying at her house!! Will Keiko be driven insane by the ramblings of this terrible alien and her Slightly above average lifestyle tossed to the wind? Or will she succeed in defeating this strange alien menace!? Find out in this incredibly odd web comic inspired by the works of H.P. Lovecraft!', True, True)
add('SONOFSAM', 'http://sonofsam.smackjeeves.com/comics/', u"Walter Cohen hates his school, but in the words of the great Dee Snider: He's not gonna take it anymore!", False, True)
add('SOSRadio', 'http://sosradio.smackjeeves.com/comics/', u'WORKERS WARNING, CONTAINS MUSIC PLAYER "Set at very low volume, Lyrics warning" 50.5 The Sounds Of Survival Apocalyptic Radio "Because it\'s never to late to liberate!" A web-comic of sound, music, and a quest for creative freedom from an entertainment starved tyrannical monarchy where anyone with the gift of art and self expression are not only hunted but enslaved. Chainsaw Adam\'s, a lone pirate radio dj travels a post apocalyptic wasteland broadcasting a message of rebellion. Calling to the abstract souls and the free spirits, he inspires those in hiding from the powers that be to rise up and fight back to create a new society built on the stuff that dreams are made of. "CLIFF-NOTES FOR NEW VIEWERS" Currently, Chainsaw has breached the city walls and entered Tulsa. Now hunted by Commonwealth guards he seeks out the "Lady of Fire" who is said to know where to find his true love "The girl with green eyes" UPDATE!!! Getting information on \'The Girl with Green Eyes\' sister "Rokette" at Dante\'s Bar, he heads to a local junkyard. After a brief fight with re-animated robots Chainsaw finds himself rescued and in an underground bunker with Rockette', False, True)
add('SPOON', 'http://spoon.smackjeeves.com/comics/', u'A evil wizard turned Charles\' whole town turned into a kitchen (that\'s right). Cursed with the body of a SPOON, he has embarked on a journey to find the wizard and along the way, he will meet other "cursed" ones. UPDATED MONDAY THROUGH FRIDAY.', False, False)
add('SailorMoontheEnemyNextDoor', 'http://sailormoontheenemynextdoor.smackjeeves.com/comics/', u'A manga version of my Fan Fiction of the same title, art work by Karolina Romanska. The past comes to the present yet again, and the Sailor Scouts shall be called upon once again to put down the latest threat to the safety of Earth, with a new member to the team to help them along! To find the threat, they will not have to look far.', False, True)
add('SaintsCalling', 'http://saintscalling.smackjeeves.com/comics/', u'*Please go to the "About" page for a full description. Thanks :)* An ill-tempered girl gets her life flipped up-side-down when her best friend abducts her in an attempt to straighten her out a bit. Little does she know...her friend is an alien king from another planet?! A Scifi Shoujo! (Rated T for Teen. Read from left-to-right.)', False, True)
add('SakuraMishzo', 'http://sakurazo.smackjeeves.com/comics/', u'An original gekiga set in Sengoku Period and featuring the strange relationship between the warlord Nobunaga, his valet Ranmaru and the ninja Mitsubachi.', True, True)
add('SalemUncommons', 'http://salemuncommons.smackjeeves.com/comics/', u"In a hidden corner of Salem MA stands the Salem Uncommon boarding house...It was purchased years ago by Karl (formerly Dr. Frankenstein's nameless monster), and has since attracted every manner of ghoul, ghost, goblin, and monster (as well as a few odd humans)...If you like your humor a little dark but good natured, like the Addams and Munsters of old, stop by. Salem always has room for more Uncommons...", False, True)
add('SallySprocketAndPistonPete', 'http://ssnpp.smackjeeves.com/comics/', u"A novel-length tale, set in the Steampunk-ified Wild West, that follows the adventures of a daddy-daughter duo (except the daddy's an android inventor and the daughter's a cyborg of his handiwork...)", False, False)
add('Saywhatyoumean', 'http://saywhatyoumean.smackjeeves.com/comics/', u"A comic pulled out of the freaked up author's subconscious. humor and pain, philosophy and non-sense,love and violence and sexy things, based on real events or completely fake, who knows what the next update will bring", False, True)
add('SchoolofRejectsSoRe', 'http://sore.smackjeeves.com/comics/', u"Have you ever wondered what happens to the characters that DON'T make it into the stories? There is a place where rejected, unfinished, and imperfect characters can go to study, play, and talk to each other. A place that an ordinary girl has stumbled upon... This is the School of Rejects.", False, True)
add('ScrappedProject', 'http://scrappedproject.smackjeeves.com/comics/', u'This is a simple tale of what happens when ideas get discarded and go looking for their purpose in life. Told through the eyes of a robot. ~Journey Completed~ (thanks for reading ^.^)', False, True)
add('SecondGeneration', 'http://keepersofthepeace.smackjeeves.com/comics/', u"Two powerful magicians are at war. One's empire is torn apart by internal turmoil. The other has a 19-year old grudge that is about to reach a new generation. Updates Sundays", False, True)
add('SecretPowerbk1', 'http://secretpower1.smackjeeves.com/comics/', u"Since the begining of time... There's been a power to control all... It's been locked away, and kept a secret... Until now. Jump threw time, control magic, and learn from a new world known as Spartelia. -Author's note- I created this book, about three-four years ago. i was younger and my art style isn't the best, but i have more that are better. But i'm sure the story will be better than the artwork. ~ Enjoy", False, True)
add('SecretPowerbk2', 'http://secretpower2.smackjeeves.com/comics/', u"book 2, please enjoy book 1 and 2, and if your reading this for your every first time, I wouldn't if I were you, because nothing would make sence, read book 1 first before reading this book.", False, True)
add('Seppen', 'http://seppen.smackjeeves.com/comics/', u"Yaoi/BL(boy's love) comic first started January 2006 completed April 2011. A Simple love story between a snow spirit servant named Yuki(snow) affectionately nicknamed Seppen (snowflake) by his master/lover Taki. Their simple story of how they met, fall in love and transcend time.", True, True)
add('SeriousTimes', 'http://serioustimes.smackjeeves.com/comics/', u"Let's get serious...", False, True)
add('ShacklesInstallment02', 'http://shackles02.smackjeeves.com/comics/', u'After escaping badly wounded with her target captured, Kas loses conciousness and crashlands on an alien planet. Captured by a tribe of the native aliens, Kas is forced to work together with Otakaog Phimosh, her own prisoner, and she starts to suspect he knows a lot more about her than he should...', False, True)
add('ShamelessAdvertisements', 'http://advertise.smackjeeves.com/comics/', u"Ever made a comic that none notice? But do you think the comic would be very good? Well, you just gotta advertise somewhere, but that'll anger other authors. NOT ANY MORE! In this comic, you can post as much advertisements as you like! Show others your comics, and watch comics from others! that way, everyone will be able to read the latest comics! Please only place advertisements for comics here, so no fillers, no bios, no spritesheets. Don't forget to add a link towards your comic profile in the comments section below the ad! : ) We request that you read the rules & guidelines section if you haven't done so already. Please don't be negative about comics in the comments, no one wants their ad to look bad. For those interested: Last author count: 457 authors (February 2nd 2013)", False, True)
add('Shamrock', 'http://shamrock.smackjeeves.com/comics/', u"**NEWS** Please use the MangaMagazine mirror to read the latest comics. I don't reliably update the Smackjeeves mirror! http://www.mangamagazine.net/manga-and-comics/Shamrock/detail-page/2734?lang=en **SYNOPSIS** Being the new kid in town, Isaac Mathew expected to be pranked and bullied; what he didn't expect was an inevitable encounter with an Irish transfer student with an affinity for destroying ghosts. --- Also available on: MANGAMAGAZINE http://www.mangamagazine.net/manga-and-comics/Shamrock/detail-page/2734?lang=en", False, True)
add('ShotoutofCanon', 'http://akumathfs.smackjeeves.com/comics/', u"Shot out of Canon is the new direction for the former Fallout Shelter Comics. Like the Fallout Shelter Comics, it'll be about the forums (and sometimes comics) I go to. Unlike the former Fallout Shelter Comics, this will deal with things besides there. And unlike that, it won't be Canon with my Main Comics. Formerly: My Fallout Shelter Comics I do for the Fallout Shelter: http://z1.invisionfree.com/forums/The_Fallout_Shelter/index.php?act=idx", False, True)
add('Signifikat', 'http://signifikat.smackjeeves.com/comics/', u"Life's but a walking shadow, a poor player That struts and frets his hour upon the stage And then is heard no more: it is a tale Told by an idiot, full of sound and fury, Signifying nothing.", True, True)
add('SilverLegacy', 'http://silver-legacy.smackjeeves.com/comics/', u"My version of Naoko Takeuchi's untold story of the Silver Millennium. Characters have been changed to fit my personal style and the story is a combination of my own imagination, the manga, and anime. All rights and original characters belong to Naoko and Toei Animation.", False, True)
add('SilverVein', 'http://silvervein.smackjeeves.com/comics/', u'One fateful night a woman and a huge demon-like fox meet. Both are about to die. Yet somehow they survive. Fueled by immense hatred, they set out on a quest to murder everything standing between them and those responsible. Yet things are never that simple, are they?', True, True)
add('SimonSues', 'http://simonsues.smackjeeves.com/comics/', u'Simon, a former law student at the prestigious Haversford campus, has made it his mission to defend the students against demon-like Fiends. Helping him is a mysterious boy named Isaac who has the ability to destroy Fiends that breach their own contracts. But his relationship with Simon is more sinister than it seems... ************************************************* WARNING! Main Comic contains horror, some graphic violence. Bonus Comics contain sexual content/Yaoi. Updates Monday, Wednesday, and Friday! ************************************************* * Check out my tumblr to see process pages and random sketches! http://simonsues.tumblr.com/ You can now read Simon Sues on MangaMagazine.net The comic there will always be a few pages ahead of the updates on SJ. (http://www.mangamagazine.net/manga-and-comics/Simon-Sues/detail-page/221) and on Manga Fox! (http://mangafox.me/manga/simon_sues/)', False, False)
add('SimpleBear', 'http://simplebear.smackjeeves.com/comics/', u"Bear Copenhagen is just a simple bear and nothing else. Spoiler: Not for long. may contain violence, blood, suggestive themes, and BL (bear love) HAHAHAHAHA GET IT??? No I'm sorry this comic is still not very mature Updates every 2 days", False, False)
add('SimplySarah', 'http://simplysarah.smackjeeves.com/comics/', u'This is the story of a young lesbian girls pursuit to follow her heart against all the problems that face her.', False, True)
add('Skeptical', 'http://skeptical.smackjeeves.com/comics/', u'A regular slice of life/death romantic comedy about an unusual family and their relations to a group of creatures that call themselves "skull people". Said human family is not mine. The Clark family(and half the comic itself) was created by and belongs to TyrannicalShipper. Just a warning- there\'s an abundance of foul language, and occasional bloodshed. Constructive critiques are always appreciated! (Updates sporadically due to the fact that we are both now in college)', False, True)
add('SlashMaximum', 'http://slashmanga.smackjeeves.com/comics/', u"SLASH (SOUL LINKED AEGIS SUPPORTING HEGEMEMONY), is a mysterious power that prevents a person from being harmed or killed, an enhancement for combat and is used to enforce authority among the weak. It can determine one's social superiority to one who possesses it. Not all may have it. Alizeti ekilore, a rich innocent girl from Trifang mansion, suddenly discovered she has it since she survived a strong explosion that killed all her family. Now that she had survived and obtained such power, Alizeti decided to pursue the murderer of her family using her SLASH. Clash, a veteran slasher(SLASH user), will help Alizeti use and strengthen her SLASH in order to find the culprits. Will they succeed in getting justice for Alizeti's family if the killers are the government's strongest Slashers? Will Alizeti and Clash be able to fully understand and utilize their SLASH to counteract their pursuers? In a society where SLASH enhancement and slashers are made, Alizeti and Clash will experience the inevitable. latest chapters here>> http://www.mangamagazine.net/manga-and-comics/SLASH/detail-page/75", False, True)
add('SlipstreamSingularity', 'http://slipstreamsingularity.smackjeeves.com/comics/', u'350 years have passed since the first and only mission beyond Human Occupied Space was launched. In search of the alien intelligence that sent such wondrous knowledge back to Earth, the Odyssey mission was lost. Now, denied their own home world by the rebellion of their own children creations, the Synthetics, humanity has become a race of despots and wanderers that meander through the stars, eking out an existence. Updated Tuesdays and Saturdays.', False, True)
add('SmallPressAdventures', 'http://smallpressadventures.smackjeeves.com/comics/', u"Action and adventure from all across the small press! Featuring genres ranging from superhero to horror to who knows? This comic is updated every Wednesday, so come on back! Don't forget to check out all our other strips!!!", False, False)
add('SmashsShowcase', 'http://smashshowcase.smackjeeves.com/comics/', u'This a a showcase in which any spriter can join. Here you can post: Sprites Pixel art Character bios Cool effects Short comics Memes Ads And More! Rules: No flaming, trolling or any of the sort No Porn So Join!!!! And be sure to post often! (If you do not post in like a month or something without reason, you will be taken off) And now, for some quotes from the authors: Smash: sprite! Pocket_Ninja : ......WHO ARE YOU PEOPLE?!?!?!?!?! Luxbot: EFFECTS IS A NECESSITY FOR ME. :< CamTro: No effects for me to sprite and speak as in same time! ~\xe0\xb2\xa0_\xe0\xb2\xa0~ Sspeedo th: I try to sprite but effects and comics work betta under the microscope. Drago: Spritin epic style. A-A-A-A-A-A-AAAAA- *shot*', False, True)
add('SoManyProblems', 'http://somanyproblems.thewebcomic.com/comics/', u"'If Toothpaste For Dinner was less funny' Single panel comics about life, booze, love and... swans(?). Updates 5 times a week.", False, True)
add('SomebodyShootMe', 'http://somebodyshootme.smackjeeves.com/comics/', u'A "real life" comic by Kita about her shitty daily routine. Or other people too. Because it sometimes couldn\'t get any worse. This comic is for ages 16+ because I have a potty mouth and because one day i might talk about grown up things, or something like that. Now Updating Daily <3!', False, True)
add('Somesprites', 'http://tonzofsprites.smackjeeves.com/comics/', u'', False, True)
add('SonicAuthorAdventII', 'http://saa2.smackjeeves.com/comics/', u'TEH CHAT IS BACK. Dont forget to space between your sentences.- Mr. Jack If you\'ve come to SAAII thinking "Oh my god- another author comic!"- Never fear. this one is the ORIGINAL AND FIRST author comic. Well, it\'s prequel, SAA, run by mostly the the same people, was.-Rikco the Robot Random post of death and doom. ~ Ryan We demand cookies! ~ Shin Guess who\'s back and fluffier than ever! ~ Shard Oh Praise the mightly Lords of the Laziness ~Jayh TEAM JINJO PWNZ YOUR SOULS! AND IM BACK! -2021 Run around for all I care! I have me my flying ceiling! HA! ~Slash Beware the newness! ~3000', False, True)
add('SonicAuthorZone', 'http://saz.smackjeeves.com/comics/', u'Quote from Team Renegade: "Saving the world... From Peace~" On an island far out into the sea, there exists a house... A house in which a group of ORIGINAL CHARACTERS (DO NOT STEAL!) lives... On this house, there exists many an adventure, may it range from Zombies, to Noobs, to Magical TVs. This island is forever known, as SAZ Island. There are a new group of SAZians now and we\'re all a little more mature. So please, don\'t judge us until you get to know us.', False, True)
add('SonicBoom', 'http://sonic-boom.smackjeeves.com/comics/', u"Rules: 1. No random images that have nothing to do with the comic. 2. No content over PG-13. 3. Excessive trolling is prohibited. Some minor jokes are fine, but don't take it too far please.", False, True)
add('SonicClub', 'http://sonicclub.smackjeeves.com/comics/', u"****RETIRED/DEAD/COMPLETED**** The Characters: Sonic Shadow Amy Tails Knuckles Rouge Capuchino(me) Nikomy(Capuchino's girlfriend) Lola(Capuchino's little sister) Lanz(Capuchino's older brother) Andry(I made him up... he's just a Shadow android) Xavier (Xevious) Degreenfreak Miles-XD(Just Miles) Stochi The Vampire Chao Crackuchino The Hedgehog Crazy China Crappuchino Ghost the Echidna(inlove with Knuckles.. XD) Green Darkness Flame the demon hedgehog Glandor the hedgehog and his brother cendar the fox", False, True)
add('SonicDASH', 'http://sonicdash.smackjeeves.com/comics/', u"Updates Tuesdays and Thursdays. ------- Eight months have passed since the fight against Knuckles beneath South Island. Merlin and Charles, funded by Robotnik Enterprises, are now beginning their expedition to Angel Island. During the middle of a news conference, the Egg Carrier is attacked by a mysterious foe, but a familiar face. It's a race against time as Sonic and Tails must find a way up to Angel Island before the Egg Carrier is destroyed... and Charles and Merlin along with it! In a world covered by endless water, this is the Digger's Adventure Story in Halcyon days.", False, True)
add('SonicFarsight', 'http://sonicfarsight.smackjeeves.com/comics/', u"Takes place in the Sonic universe(obviously), six years after the current adventures. It's about a romance between Sonic and Amy and how that lead Sonic to face his first romantic and existencial crisis and separation from amy. Hope you like it. Updates every monday.", True, True)
add('SonicSchoolRedo', 'http://sonicschoolredo.smackjeeves.com/comics/', u'THIS COMIC HAS BEEN MOVED TO CRAZY R US.', False, True)
add('SonicWorldAdventures', 'http://sonicworldadventures.smackjeeves.com/comics/', u'Sequel/Spin-Off to Metroid Prime: Altina Through a series of unforunate events, Sonic the Hedgehog has found himself in the past with diminished intelligence and memory, and must complete all his previous adventures to create a Synch Nexus, and fix a space-time rip threatening to destroy... STUFF. Previously called: Sonic World Adventure Created by S of Team Dark Nexus! PG Content!! Daily updates!!!', False, True)
add('SonictheHedgehogGenesis', 'http://sonicgen.smackjeeves.com/comics/', u'A revision of Sonic the Hedgehog using characters both old, new, and ones specifically made for the comic. Enjoy', False, True)
add('SonoftheNothing', 'http://sotn.smackjeeves.com/comics/', u'Son of the Nothing is the epic adventure of Seth Rothida, a young soldier who soon will be immersed in the devastating world of the war, but Seth is confident in his ideals, values \u200b\u200band friends who will support it in finding his sister Beth who has disappeared. Update monday & friday night.', False, True)
add('SonoftheNothingspanish', 'http://sotns.smackjeeves.com/comics/', u'Son of the Nothing es la epica aventura de Seth Rothida, un joven soldado que muy pronto se vera inmerso en el devastador mundo de la guerra, sin embargo Seth confia en sus ideales, valores y amigos que lo apoyaran en la busqueda de su hermana Beth que ha desaparecido. Subo lunes y viernes por la noche.', False, True)
add('SoulEye', 'http://souleye.smackjeeves.com/comics/', u"In the pitch black dead of the night, Make sure that you're tucked in tight. If you aren't, you'll surely be A victim to the demon's teeth... The Reaper swoops down in the dark, Hungry for a child's heart. If you see him, don't you scream, Or he'll rip you from your seams... Most of all, though you are scared, Don't once glance upon his face, For if you see his eye of death, Darcia will devour your soul's breath. ----- UPDATES EVERY SATURDAY. *WARNING: Contains BL. For Mature viewers ;A;", True, True)
add('SoulGuardian', 'http://soulguardian.smackjeeves.com/comics/', u'One day humans will create viruses with the intention of infecting themselves. With a virus strong enough, a person would even be able to travel across space and time...they would have the power to change their destiny, but at what cost? READ: Right to left UPDATES: Wednesday', False, False)
add('SpaceSchool', 'http://spaceschool.smackjeeves.com/comics/', u'UPDATES EVERY TUESDAY Space School is a comic about purple aliens, southern boys, and the love between them. Both make friends with a depressed angel, a seemingly all too excited goat, a rock man with a powerful girlfriend and a dinosaur with a bad attitude. Together they discover the dangers of deep space and explore planets- other cultures are investigated and a lot of space burgers are eaten.', False, True)
add('SparkStory', 'http://sparkstory.smackjeeves.com/comics/', u"An author comic; you must have Kirby sprites to join. Please don't swear or use mature content. INSPIRED BY ABBIMAYS RANDOMNESS Characters w/ quotes: Spark: Hi! Do you like- Sako: . . .is the microphone on? Blue Kirby: Blurf. Make of that what you will. Pixel Reliant: I will be a friend to anyone! (Except those with a disrespect for art.) Hippo: Hippo sits pariently out in the rain, watching. He watches the others carefully, wondering what they are all doing. 'Well' Hippo thinks 'they'd better know I like hippos, for if they don't...' Hippos thoughts are interrupted as he falls off the tree' Doofus: If you don't stop trying to change the radio station on my tank, I swear to Black Mesa I will come over there with an army of pies! Grace: Doofus! *glomp* Flare: I have no Idea what's going on right now. Kuzer: .... I'm hungry. Roberto: DESTROY ALL HUMANS that steal my potatoes Daniel: Cookies! *glomps Spark* Ryan: Hey wierdo, why are you glomping my Girlfriend?", False, True)
add('SpecialCare', 'http://specialcare.smackjeeves.com/comics/', u"This is about two enemies: Kant, the city hero and Jeremiah, the city criminal/villain. They were fighting, until Jeremiah broke his arm. With his kind heart, Kant deiced to take care of him until Jeremiah arm has healed and trying to put up with him for six weeks. Soon enough after living with Kant for a few days, Jeremiah started to fall for Kant. But, Kant still hates him\u2026. or does he? WARNING: Contains Boy Love! If you don't like, you don't have to read if you don't want to^^ And this is my first time doing BL, so be nice =_= I been reading them so I can get the idea^^; Oh, and read the normal way! Updates one page on Mondays, two pages on Wednesdays, and one page on Fridays", False, True)
add('Spellcross', 'http://spellcross.smackjeeves.com/comics/', u"Spellcross takes place in a land of high fantasy, re-imagined through the scope of a classic RPG. It's a world where things such as quests, dungeons, and bosses are commonplace, and magic is abundant! Follow Caldwell the Alchemist as he strives to raise himself up the ranks of adventurers, to gather a party of friends, and to overcome his fears. Updates three times a week on Monday, Wednesday, and Friday!", False, True)
add('Spriterschaos', 'http://spriterschaos.smackjeeves.com/comics/', u'random things happen everyday', False, True)
add('Sprytts', 'http://sprytts.smackjeeves.com/comics/', u'---COMPLETE COMIC--- For the past few hundred years, the two great countrys, Carvia and Gloomland, have been enemies. While Carvia, land of the Sprytts, is full of wonder, delight, and magic, Gloomland, land of the Gools is full of demons, nightmares and violence. Blado, a royal guard to Queen Mellaba, is in search of the mysteries behind his past. Not long after he and three other royal guards encounter the princess, they get caught up in the middle of this international conflict.', False, True)
add('Starman45andFriendsShowcase', 'http://namecomic.smackjeeves.com/comics/', u'Derp.', False, True)
add('Stay', 'http://stay-comic.smackjeeves.com/comics/', u"Stay is a comic I started in 2008 and I'm just now uploading it in 2012 >_>; It is a Yaoi comic Description: Lee is just an ordinary dude, he's very studious, studies on the weekends and does well in school, but then he meets Jude - a punk guy with streaks in his hair, piercings and tattoos -- his total opposite! Jude is a mysterious guy with a mysterious past that for some reason wants to be all over Lee the nerd, and as he makes his moves hy-jinks ensue!", True, False)
add('SteampunkGorgon', 'http://steampunkgorgon.smackjeeves.com/comics/', u"I had to downsize the comic to upload it here, you can find it in a bigger size on http://zodiakoverun.de/Steampunk00.htm. Read the adventures of gorgon-model Medusa and her friends in a 1930ies post-war steam-punk-world, including some magic, villians and of course technology. It's not victoriana or gas-lamp, but real steampunk mixed up with film noire. It's all handlettered and handdrawn with ink on real paper, no digital effects added.", False, True)
add('StellaInChrome', 'http://stellainchrome.smackjeeves.com/comics/', u'Lost in the rubble at a condominium development lies a key that unlocks more than doors. Can Stella unlock the mystery that surrounds the key itself? Updated 8:00 PM CST each Wednesday, every Wednesday.', False, False)
add('StrangersandFriends', 'http://hemu.smackjeeves.com/comics/', u'The small English town of Wootton Bassett begins to be haunted by a series of mysterious and horrific murders! Hemu, a new-comer to the town, becomes an obvious and easy target to the local community- he does have his fair share of secrets! But what secrets are the other locals hiding? A comic about the peculiar prejudices and customs of small communities, with a hint of social commentary on modern Britain, and a sinister splash of horror ;)', False, False)
add('StrayCrayons', 'http://straycrayons.smackjeeves.com/comics/', u'++++Please Read++++ This web manga is a continuation of my published work "Stray Crayons Volume 1" which is available on www.amazon.com. Published in early 2007, it was meant to be a published as a trilogy, however due to complications, the rest will be posted online, here. So fans of Strays Volume 1, here is the rest of the story. For new readers, there will be a synopsis of volume 1 but to get the full story you\'ll have to buy the volume online. Please visit www.yokomolotov.net/indexsc.html for purchasing information. +++Warnings+++ *There will be inclinations of Girl Love, or shoujo-ai. It is not the main focus of the story, but it is still a part of it. * This manga is rated 16+ so if you are not 16, don\'t read it. *There is a lot of heavy drug use. *I drew this manga 2-3 years ago. I am posting this comic as a service to the fans of the first published volume, and to be honest, I am aware that it\'s not the best work I\'ve done. So you are waisting your time posting negative feed back about the quality. Later pages near the end of volume 2 will be recent, and more refined. *I will update this manga weekly. Please see the faq for more information!', True, True)
add('SubjecttoChangeCollegeWoes', 'http://subject-to-change.smackjeeves.com/comics/', u'Erin and her friends are about to embark on the greatest test on life and their friendship, going away to college. The five girls will have to survive the tests of roommates (egads!), college tests, and new relationships. Through it all the girls will find out if their friendship can really outlast the world of College Woes.', False, True)
add('SunmeetsMoon', 'http://sunmeetsmoon.smackjeeves.com/comics/', u"This is a story about a boy and a girl who met in the summer and fell in love. But the end of the summer parted them for a long time. The meeting again wasn't as happy as they expected... Between them stand a lot of differences.She being a loner, attracted by witchcraft and some serious supernatural stuff. He being a sociable fellow with a childish behaviour. But most of all he having a new girlfriend ;) The story has four parts, each one made in a different year: 1. The Riddle ('07) 2. Marg's revenge ('06) 3. Who's that girl? ('07/'08) 4. Passing by Midnight ('08/'09)", False, False)
add('SupaKawaiiSparkleNekoDesuChan', 'http://nekodesuchan.smackjeeves.com/comics/', u'wtefever maannn', False, True)
add('SuperDimensionAfterTheHero', 'http://afterthehero.smackjeeves.com/comics/', u"Updates once every weekend. (Mondays count as weekend.) Super-Dimension comics are just the name I give all my superhero comics. This has no relation to any other Super-Dimension comics. Dennis Lockham was Paladin. A guardian superhero of L.A. But now his powers are gone. He's just a man. And that is the one thing he can't take on. Rated 12+ for *&%$'ed cussing, and violence. Neither of much, though.", False, True)
add('SuperMarioBros3', 'http://smb3.smackjeeves.com/comics/', u'The story of the Super Mario Bros. 3 game.', False, True)
add('SupermassiveBlackHoleA', 'http://smbhax.smackjeeves.com/comics/', u'Stories of a human civilization at the center of the Milky Way galaxy: an area of space dominated by a gigantic black hole, where energy is abundant and life is cheap. Updates M-F, usually multiple times per day.', False, True)
add('SurvivorFanCharacters', 'http://sfc.smackjeeves.com/comics/', u'Fan Characters will be competing for $1,000,000.', False, True)
add('TEN', 'http://ten.smackjeeves.com/comics/', u'Two years ago our two main characters jumped from a cliff to escape from a life of confinement and torture. The life of a human guineapig They jumped into a unknown future, a unknown destiny... and maybe death. But both of them survived and now, two years later, they meet again...', False, False)
add('TH3D3AD5H0WCA53', 'http://thedeadshowcase.smackjeeves.com/comics/', u"In this show case it is our goal to have every kind of comic shown manga, anime, sprite etc for critique. So here you can advertise and show your comic pages for critiquing the art, layout, special effects, and style of the comic. There will be 5 sections to this comic. The Art section. A place to review, critique, to get help, and show off art work. The Comic section. A place to review, critique, show off comic pages, and to get help. (not the whole comic just individual pages for review on layout and such) The Advertisement section. That one is self explanatory. The Special effects section. A place to get help, tips, and critiques on custom special effects. And The sprite section. A place to review, critique, show off and get help on sprite work. Anyone and everyone is welcome to join. And sadly there are a few rules (TALKING TO YOU TROLLS LOL) Inappropriate content in either comments or other posts will be deleted. Swearing is allowed as long is it isn't offensive, and remember. Critique and help, not troll. Anyways that is all so enjoy!", False, True)
add('THISISNOTFICTION', 'http://tinf.smackjeeves.com/comics/', u"THIS IS NOT FICTION is a webcomic about desperation in love--or something like that. What do you do when the person you're in-love with is an anonymous romance novelist? Get your best friend to hire your mortal enemy to help find the novelist's true identity, of course! Cue the neighborhood's Local Fan Boy Julian Drees, his best friend Isaiah Holloway, and his mortal enemy (and neighbor), Landon Addison. The 3 boys set out on countless adventures to find out the true identity of Sydney Morgan: popular romance novelist and the object of Julian's affections*. *he's a freak *mirror site, updated Mondays! *available in Spanish *not up-to-date: MOST RECENT PAGES ARE UPLOADED TO MANGAMAGAZINE.NET.", False, True)
add('TPTruePower', 'http://truepower.smackjeeves.com/comics/', u'A fun comic about friendship, aliens, and flashlights! Updates: Mondays', False, False)
add('TRIPP', 'http://tripp.smackjeeves.com/comics/', u"The story of an ordinary guy stuck in a never-ending acid trip. Tripp must learn to cope with his new psychotropically enhanced existence with the aid of his spirit guide, Edgar Allan Poe. This comic is not an endorsement of drug use, merely one guy's effort to deal with an accidental, perpetual hallucinatory life change. Updates on Mondays (really Sunday night at 11:45) and Thursdays See the official site at http://trippcomic.com", False, True)
add('TaikiTheWebcomic', 'http://taiki.smackjeeves.com/comics/', u"FINISHED! Taiki is a typical shy 16 year old high school student who is starting the 10th grade with her best friend Nikki. Going into the 2nd half of high school, Taiki thinks it\u2019s strange that she has never liked someone or fallen in love. One day she unexpectedly meets someone who changes all of this. However this person turns out to be a girl! Taiki has always wanted to know what it was like to fall in love, but what she didn\u2019t expect was that finding out would also be a journey of self discovery, realizing her sexuality, and maybe even heartbreak. -IMPORTANT!!- This is a mirror of my main webcomic that is on my own website --> http://www.taikiwebcomic.com/ This comic was started in 2006, so the art in the beginning isn't very good compared to what it is now. This story contains GL and HL, it is MOSTLY GIRL LOVE THOUGH.", False, False)
add('TailsAdventureThroughTimeandOtherWorlds', 'http://tailsadventure.smackjeeves.com/comics/', u'Tails unexpectedly goes on an adventure through different worlds and even through different times! It all started from falling through a purple portal. How will his adventures go? Credit goes to those who ripped/edited the sprites used for this. None of the characters used belong to me except for my own.', False, True)
add('TakingPicturesofStrangers', 'http://darrenandkale.smackjeeves.com/comics/', u"Darren lived the charmed life of barhopping before he met Kale. It was a new guy every night, lots of drinking, lots of sex, etc. But when he snagged big, quiet Kale, Darren uncovered Kale's secret and set into motion a series of events that lead them both down a path no one expected. Warnings: first and foremost, very gay. Gay romance, gay sex, gay gay gay. If this isn't your cup of tea, you probably shouldn't bother continuing reading. Second, the occasional bad word. Third, booze. (Does booze require a warning? It's not underage drinking or anything.) Fourth; drama and cheeze out the wazoo. Fifth and final warning; very badly drawn. (And probably badly spelled, too.)", True, True)
add('TalamakGreatAdventure', 'http://talamak.smackjeeves.com/comics/', u'12 people from all walks of life are found in the greatest challenge of their lives. These 12 people were born with a special gift that they must master in order to save the world from the evil corporation of Ysane and Ursula Eckar. They want to harness the power that these people have to enslave mankind and summon the ancient monsters that were once the fall of the 12 in a past life.', False, True)
add('TalesoftheMagicianandthePrincess', 'http://magicianandprincesstales.smackjeeves.com/comics/', u"Here are tales of my own take of Alice in Wonderland/Cinderella. This story takes place with Alfie, literally falling into a crazy show, there he meets a bizarre set of characters, including a servant girl, Mary-Ann(daughter of a famous Magician). Alfie later discovers his dream was no illusion when familiar faces show up causing trouble on and off the stage, and also Alfie and Mary-ann uncover more about each other and their own magic against the 'Red Prince'. Where do you think all this will lead them into...? Follow Alfie and Mary-ann, into a world of magic. May the show begin!!", False, True)
add('Tardaasa', 'http://tardaasa.smackjeeves.com/comics/', u'Tardaasa is about the small things in life. It is about the feeling you get when you watch someone whipe of a bogger on the side of their bed and you happily think: " I do that too." And then you think it is gross...', True, True)
add('TeKscloset', 'http://tekchats.smackjeeves.com/comics/', u"TeK's mind and friends. You're god is now forlorn.", True, True)
add('TeamShapes', 'http://teamshapes.smackjeeves.com/comics/', u"There's a team of MS paint creatures that do random events that include fighting Paint.net, running from a guy who they owe $500 to, doing missions, and simply fooling around. Current chapter: Roup wants to build a time machine, but it gains consious and reverses the comic order of this chaptor, eventually time itself will stop. They must defeat it.", False, True)
add('TechnicolorLondon', 'http://technicolorlondon.smackjeeves.com/comics/', u"Toby Landon's love life is a bloody mess.His on and off girlfriend has once again tossed him aside. His mate Mark gives him some advice: Try something different. With a kiss, the lives of these two friends go from being black and white to being full of vivid color. No longer a checkerboard, This is Technicolor London. //Yaoi/Boylove Plus a little bit of everything else// //Updates are Every Tuesday & Friday//", False, False)
add('Tenwaysbendystrawssavedmylife', 'http://bendystraws.smackjeeves.com/comics/', u'an informal window into the way i saw/see life as a teenager and young adult told though the adventures of two rather ordinary kids', False, True)
add('ThatWasntThereYesterday', 'http://twty.smackjeeves.com/comics/', u'A mysterious stranger meets a mysterious road.', False, False)
add('ThatsMyBoh', 'http://tmb.smackjeeves.com/comics/', u'Updates whenever the hell I feel like updating it.', False, True)
add('The13thWorld', 'http://the13thworld.smackjeeves.com/comics/', u"In the galaxy known as Andromeda ruled by the Goddess Palutena; creatures known as O'phans rule the thirteen worlds and it is up to her chosen followers to save and bring peace to the thirteen planets. This is a mashup of several anime and video game worlds.", False, True)
add('TheAlliance', 'http://alliance.smackjeeves.com/comics/', u'The year is 3010... The earth has become a poisoned shadow of what it once was. The sky has stained red, a symbol of the endless wars that had emerged below. Animals mutated from the toxic atmosphere that own the lands. Mankind itself has even been mutated. For some, their DNA being matched with various animals. And others gaining different attributes from their darkening hearts. Human kind has now fled to giant toxin purified domes. But even this is beginning to become less then what they need to survive. Their minds have been polluted with evil. Darkness surrounds their hearts. Now there is only one hope........ The Alliance. Contains Violence, blood, romance... Eventually... My comic is BOYXGIRL.', False, True)
add('TheAntihero', 'http://antihero.smackjeeves.com/comics/', u"Most stories have good guys and bad. Some have only good guys, but with antagonists. Then some have only dastardly villains trying to do villainous things to decent people while all along screaming at the top of their lungs into the rain. This is one of those comics This is also a very depressing comic. Seriously. Every chapter is 'death' in a different language, and each title page is the Protagonist about to die. ... I told you it was depressing. Anyways, don't let that stop you! It takes place 20 years in the future. The U.S. has deteriorated into a kind of middle-ages scenario, where the government is corrupt, inflation rules, and the Mafia basically control the country. It doesn't get any better than that. But Isaac, the commander of the NY Mafia, notices there's a new gang in town. The Redblades. And there's something familiar about the commander... I'd rate it about 12+. There's mild gore, blood, and violence. Also comic cussing (!@#$%^& it!). And it's basically aimed at an older audiance, but if you're okay with the above, go ahead.", False, False)
add('TheAttackoftheRecoloursSeason1', 'http://mysticalvalley.smackjeeves.com/comics/', u'The Recolours are attacking all of Mobius and the edits will have to eliminate them. Flash, Leeroy and Kedar500 are creating the recolors and sending them out to fight but Sonic, Josephk and the others are preventing them from succeeding. Will they save the world from whatever Flash and Kedar500 are planning. Then read the Seasons and find out. Updates on Saturdays and Wednesdays; During School days I will update randomly on the weekends.', False, True)
add('TheBookofNosferatu', 'http://www.thebookofnosferatu.com/comics/', u'Two unusual sisters strive to survive a post apocalyptic world where supernatural creatures reign supreme.', False, True)
add('TheBrideoftheShark', 'http://sameyome.smackjeeves.com/comics/', u"Toshio is a pearl diver, dealing with his love problems in Onjuku. 'Ehukai is a shark, instantly falling in love with the boy and claiming him his wife in front of his family...", True, False)
add('TheCafedAlizee', 'http://alizee.smackjeeves.com/comics/', u"Eliza Jones always had a dream of opening a cafe, but met a tragic fate before she ever could. Thus, the Caf\xe9 d'Alizee was opened in her honor. This story really isn't about her, though. Instead, this story follows the interesting, strange, and in some cases eccentric staff of the Cafe d'Alizee as they wander through the trials and tribulations of life. They may not know where they are going, but they have the four most important things in the world: love, life, coffee, and cake. *Updates every Monday and Thursday.* P.S. I should also mention that because this comic deals with the lives of various people, there may be situations that include relationships of any gender combination as well as violence or sexual situations, but there will be nothing graphic. So because they are (mostly) all adults, expect adult situations to occur. :)", False, False)
add('TheClass', 'http://www.theclasscomic.com/comics/', u'The Class is a story about high school students learning to deal with growing up while being confronted with the ability to use powers and fight a growing evil. Written by Jaysen Headley and Illustrated by Jessi Jordan. For more news and info, check out our blog at www.theclasscomic.com', False, True)
add('TheColony', 'http://thecolony.smackjeeves.com/comics/', u"In the secluded hills of upstate New York, there is a place known only to few. It is a haven for all things macabre; werewolves, vampires, zombies. If you fear it, chances are it resides there. Every 300 years, a new regent is crowned, and this time you're invited to the ceremony. The Colony is updated every Tuesday, so come on back!", True, True)
add('TheDarkAgeofMobius', 'http://thedarkageofmobius.smackjeeves.com/comics/', u'It was 20 years ago that the Emerald war began. Many died. Sonic, and Eggman are but a few. There were, however, survivers. A mysterious overlord has taken over much of the world. There are those who oppose him. This is the story of one.', False, True)
add('TheDeathPact', 'http://thedeathpact.smackjeeves.com/comics/', u'A dark story about heaven and hell... comments are welcome. thanks to all readers. category: shonen,action, horror, comedy', False, True)
add('TheDemonicAdventuresofAngelWitchPita', 'http://angelwitchpita.smackjeeves.com/comics/', u"Reading a book is innocent enough, right? Except when you're Pita, and reading the book releases hundreds of demons and their leader, and all of them are craving for a bit of...action. Enter a (pig) cherub-in-training named Buhi, who then puts Pita in a contract to take care of each and every one of the demons, add a little bit of Magical Girl bibbity boo, and now you have the start of the story.", True, True)
add('TheDestroyer', 'http://heartless-destroyer.smackjeeves.com/comics/', u"A Shadow-cat demon named Kairo Ventaiga finds his solitude interrupted when he finds out his family isn't dead. However, he's gotten used to his deadly lifestyle and doesn't want to change... In a neighboring kingdom, Princess Nicole, a daughter of Light, doesn't want her father's crown. She is strangely sympathetic toward Shadow demons, her kind's mortal enemy. She's determined to befriend the Destroyer; perhaps she knows something Kairo doesn't... Reilyn Ventaiga only wants to find out what happened to his parents the night Kairo disappeared, but getting any answers out of his brother is looking more and more impossible... TakJak, a former thief, starts to notice that the Heartless Destroyer isn't as heartless as he seems... Updates: every Saturday with one or two pages Warning for minors: contains prevalent cursing, blood and gore, violence, and maaaybe farther down the line, partial nudity or hints at it. Also gay people. If you don't like any of the above, I'd advise against reading my comic.", True, True)
add('TheDragonFistsofSmortySmythe', 'http://thedragonfistsofsmortysmythe.smackjeeves.com/comics/', u'This is the story of a Martial Arts Monk who leaves his Monastery to take up a life in the outside world. Wishing for a peaceful existence, he instead becomes a reluctant hero, bodyguarding his intrepid, trouble-prone friends on their adventures.', False, True)
add('TheDragonandtheLemur', 'http://dal.smackjeeves.com/comics/', u'The Dragon and the Lemur is a web manga drawn by Vilani Vil\xe1 and scripted by the same and CherryVincent. In few words, a RP between the artist and CherryVincent, which Vilani decided to transform into a Manga. D.a.L (for short) tells us the story of two characters, Hakakku (a humanoid, hybrid between Cat and a Lemur) and Chain (a humanoid, dragon). They both met, probably not under the best circumstances and ended up falling in love. The script is currently finished. This comic contains explicit content and homosexual relationships. Bestiality/shota/incest may be often mentioned. May have blood and gore. NC-17 YAOI/HENTAI/YURI Update schedule: Monday, Wednesday and Friday Started: Sept 2005 Status: On going', True, True)
add('TheDrawingDoesntMatter', 'http://thedrawingdoesntmatter.smackjeeves.com/comics/', u'I have a life. Well, not really, which is why I write this comic. People who know me may recognise some of the people in it. There is absolutely no reason for this whatsoever.', False, True)
add('TheEssyaneWarriors', 'http://www.eva-niles.com/comics/', u'Also available on mangamagazine. A heroic fantasy manga, where revenge and lies are the main allies for a resentful queen. And only the Essyane Warriors can provide a proper revenge to her master plan... The trick is to find them and wake them from a very powerful spell. Edit: Updates every Monday to Friday from 11th of Dec. 2012! Paper version available now : visit eva-niles.com/store/', False, False)
add('TheGlassisBroken', 'http://glassisbroken.smackjeeves.com/comics/', u'The glass is not just half empty, it is broken.', False, True)
add('TheGoldRiderofPern', 'http://goldrider.smackjeeves.com/comics/', u"I started this comic a little over a year ago, and it's been going strong ever since. Taking place in the 3rd pass of Pernese history, K'mlar, a young genius Masterweaver was placed at Ista Weyr as his first appointment after being given the station of Master. There he impresses a young Gold hatchling, an event completely unheard of in Pernese history. Despite being aggressively anti-social, he manages to make a place for himself at the Weyr that he never would have dreamed possible.", False, True)
add('TheGrayZone', 'http://thegrayzone.smackjeeves.com/comics/', u'A daily cartoon featuring the lives of extraterrestrial "grays"', False, True)
add('TheHorribles', 'http://thehorribles.smackjeeves.com/comics/', u'Things that go bump in the night! Monkeys that dance and a Creature that rants. Monsters that snap and bite! A comic for kids of all ages. Updates every Tuesday!', False, True)
add('TheJosephComics', 'http://josephcomics.smackjeeves.com/comics/', u'What started out as "Joseph and His Comics" in 2003 became the first minimal comic strip series by amateur cartoonist Joseph Scarbrough. The comic centered around fifteen-year-old Joseph Armstrong - just you\'re typical, average, American teenager who just so happens to get himself in and out of random situations that give way to continuing storylines with serial cliffhangers much like the old "Rocky and Bullwinkle" show (which adopted said format from old movies and westerns of the 50s). In 2004, Scarbrough "revamped" the comic strips, renamed it to simply "Joseph Comics" which carried on until Scarbrough announced his retiring from comic strips, thus making Joseph and his friends find their place in the Old Cartoon Stars Retirement Home permanently come 2008.', False, True)
add('TheKeyHotelEnding', 'http://tekeyhotel.smackjeeves.com/comics/', u'Alright, the Key was fun while it lasted, but due to a lack of updates and interaction, I must shut down the Key Hotel. It now belongs to SteamingBullets Uboa. See ya!', False, True)
add('TheKwiddexProtocol', 'http://kwiddexprotocol.smackjeeves.com/comics/', u'Welcome to Satellite Falls. Starstorm has returned after a 15-year absence. So has the White Rose. Plus there\'s a monster tearing up the city. Now, it\'s up to disgraced cop Jerry Binder to find out just what the hell is going on in his city and just what the hell "The Kwiddex Protocol" means. The Kwiddex Protocol is updated every Monday, so come on back!', False, False)
add('TheLastELement', 'http://thelastelement.smackjeeves.com/comics/', u'Gaelic, a shape shifting guardian with the ability to become a wolf faces long forgotten trouble. Betrayed and wounded, hes cast to earth with his friends Hakune and Odina. With the support of a young earth woman, Maysume and a omega wolf, Abba, Gaelic finds the strength to move on and fight for the sake of his people and his beloved friends', True, True)
add('TheLegendaryQueen', 'http://legendaryqueen.smackjeeves.com/comics/', u"Being drawn, then written out, this comic is about my character Crystal, a normal 15-year old hedgehog who soon finds out she's worth much more than she ever believed she could be. There will be love, fighting, death..friendship..and above all else, family and self importance. Journey along with her, as she becomes what everyone has been waiting for...and stays true to herself! Updates: Whenever I get pages drawn XD", True, True)
add('TheLegendofMushroomKingdom', 'http://lomk.smackjeeves.com/comics/', u"To put it simply, this is a crossover fan-fictional graphic novel featuring the Super Mario Brothers and Legend of Zelda franchise. Mario and Zelda are the two of the most well-known franchises in Nintendo, not to mention my two favorite video game franchises. It's pretty long, so get the popcorn and drinks ready :D Characters in this story are properties of (c) Nintendo", False, True)
add('TheLegendofZeldaMaidenoftheMoon', 'http://lozx.smackjeeves.com/comics/', u"<>Set roughly 20-30 years after Twilight Princess.<> The return of not one, but two villains has a young, unwilling hero scrambling across the land of Hyrule in search of power enough to defeat them. Reluctant at first to accept his fate, tiny steps taken along with a guiding hand (or two) will help mold just the savior Hyrule needs. || Incorporates a little bit of TP, FS, MC?, and... probably a few others I'm forgetting right off the bat. Legend of Zelda belongs to Nintendo, not me.", False, False)
add('TheLifeofMagFlamequill', 'http://lifeofmag.smackjeeves.com/comics/', u"The coming of age ceremony is tomorrow. Participants will take their birth-feathers and soar gracefully into the sky, cheered on by their proud friends and relatives. But what if you're Mag Flamequill, the bird-woman with a fear of heights?", False, True)
add('TheLoneSwordsman', 'http://theloneswordsman.smackjeeves.com/comics/', u"Heaven has fallen, including its Leader, Aven, thanks to the Demon King Shutendoji's new Elite Demons. Now Shutendoji has his eyes set on Earth. Can a Lone Swordsman wielding Aven's sword stand a chance against such hopeless odds? Or will the madness of the souls he must absorb destroy him from the inside? Rated PG-13 due to cartoon violence, blood and mild language. The Lone Swordsman and all related subsidiaries are property of Sol's Dawning Creations. The use of such without permission for the purpose of monetary gain is illegal and will be met with legal action.", False, True)
add('TheMegaManXComic', 'http://megamanxcomic.smackjeeves.com/comics/', u"This is my original Mega Man X comic I created many years ago. It shows the lack of experience in doing anything sprite based, and showed how I learned and developed over time. It's full of cliches, predictable plot twists and copied ideas, lazy effects, bad spelling, and other such stuff. But it is what it is, so ENJOY! :D", False, True)
add('TheMegaManandSonicSpriteShowcase', 'http://megamanshowcase.smackjeeves.com/comics/', u"Credit to all the authors listed for the sprites. We do 8 bit, 16, bit and 32 bit sprites (mostly 8 bit) and Sonic sprites. WE TAKE REQUESTS. no trolling, flaming, cussing (some allowed) and ABSOLUTELY NO STEALING SPRITES AND DON'T CLAIM ANY AS YOUR OWN, unless you actually made them and your part of this showcase. *One new rule: I would like to address the fact that THIS IS NO LONGER A SHOWCASE WHERE WE POST RESOURCE SPRITES OR SPRITES WE DIDN'T MAKE! I'm gonna remove the sheets that aren't ours soon. any body else that posts anything that isn't theirs will be punished, if caught, with the following: 1st offense: a warning. 2nd offense: comment privilege taken away. 3rd offense: uploading privilege taken away Anything past the third offense will result in removal from this comic.", False, True)
add('TheMewExperiment', 'http://themewexperiment.smackjeeves.com/comics/', u'A Tokyo Mew Mew spinoff about a genetically engineered mew and her fight for freedom against the aliens hired for the sole purpose of her capture. The catch? An accident robbed her of her memories and she must relearn her forgotten powers in order to survive. The comic is for practice, so please ignore the bad art! (Especially in the first two chapters.) Read from right to left! Updates about every 4 days!', False, True)
add('TheMitchellEffect', 'http://themitchelleffect.smackjeeves.com/comics/', u'A typical tale of an ordinary teenager who accidentally summons a demon that eats all his snacks and smokes all his good weed. You know.....a classic :) If you like what you see here come friend me on Facebook for more goodies and funny content: Cornelius Goodfellar', False, True)
add('TheNightSurfers', 'http://thenightsurfers.smackjeeves.com/comics/', u'When the coastal city of Costa Nueva is threatened by sand creatures sent by a mysterious evil, four teenagers rise from tragedy to become heroes. They are The Night Surfers. Read it here at Smack Jeeves, or get even more content and the most recent updates at thenightsurfers.com!', False, True)
add('ThePeopleThatMeltinTheRain', 'http://thepeoplethatmeltintherain.smackjeeves.com/comics/', u'A wicked menace lurks in the shadows and a cursed toy from the past offers clues to the mysterious spell that holds the town of Deluge captive by the rain. Does the new girl, Laura, have the power to set them all free? Updates every Thursday Written and colored by Carolyn Watson Dubisch Illustrated by Mike Dubisch for Spanish go to www.SeDerritenEnLaLluvia.SmackJeeves.com', False, True)
add('ThePirateBalthasar', 'http://thepiratebalthasar.smackjeeves.com/comics/', u'Wilson Kane wins a fortune and his future bride at a game of dice from the former pirate Balthasar. When he decides to go and get the girl, the pirate way, by kidnapping her, not only he finds out that she is more than a pirate could ever want from a wife... but that she has 4 identical sisters as well. This discovery hits him when his men, who were supposed to help him out, each kidnaps a different girl... and none of them gets the right one! But Wilson Kane wants the girl he had met and no one else! Luckily for him it will be the girl herself to solve his problem and put an end to his dilemma... a solution that will eventually fling her into a new way of life, aboard the Alidivento, across the Mediterranea sea!', False, False)
add('ThePokemonArtBox', 'http://thepokemonartbox.smackjeeves.com/comics/', u"Go on a virtual art gallery filled with tons and tons of pokemon art! whether it's hand drawn, sprited, or drawn on the computer, any pokemon lover will find something they like! why are you reading this? check it out for yourself! Also note that all artwork here is fan made, we do not own Pokemon, nor do we claim ownership of the Pokemon company, Pokemon belongs to (c)Nintendo Do not steal another person's artwork from this and claim it as your own, ask the artist for permission and state sources if you wish to redistribute or re-post the art anywhere else on the web. Thank you.", False, True)
add('ThePrinceandtheToad', 'http://tpatt.smackjeeves.com/comics/', u"A young boy comes across a rather excited little toad, telling him that it's magical, and is in reality a royalty. But the little amphibian isn't quite what the boy expected it to be.", False, True)
add('ThePrincessandtheGiant', 'http://princess.smackjeeves.com/comics/', u'A silent fairytale about a young princess and another, rather larger individual. Updates Sundays.', False, True)
add('TheProtector', 'http://protectorcomic.smackjeeves.com/comics/', u"A story about a boy and his protector. Set in the country of Senobia, a young boy is set on the path of destiny. His companion is one of the country's most celebrated heroes. What adventures awaits the two of them? Started in 2008 and continued in 2010. This is not a BL, it contains little to no sexual scenes at all, this is an adventure story. If you want porn linked to this story (only between adults of course), then please feel free to read my companion story, Sacrifices. Updates Sundays http://sacrificescomic.smackjeeves.com/", False, True)
add('TheRandomObscureFairyTaleNoOnesEverReallyHeardOf', 'http://tro.smackjeeves.com/comics/', u"Yeah, so I ran out of characters for the title. Trust the banner. 12-year-old girl Wolfgang Rock manages to convince her mom to let her stay with her ex-uncle-in-law-in-law instead of having to move. Soon enough, however, the said uncle, Dieter Jung, starts to have an innocent crush on the girl... This was the first full-length comic I ever did. Don't mind the amateur art and the fact that its unrealistic story could only be written by a child (indeed it was) and the JPEG fuzziness and and and... *COMPLETED! *Reads left to right *Not suitable for impressionable young girls/adult men with developing complexes *Nothing inherently inappropriate, either *The original comic before He Who Has Partners, which apparently takes place in an alternate universe", False, False)
add('TheReborn', 'http://reborn.smackjeeves.com/comics/', u'Every teenage girl looks forward to her sixteenth birthday, and Angela is no exception. But on that day her life turns upside. Angela learns a stunning secret about herself, and finds herself caught up in war between two demon clans. Updated Mondays and Fridays. This comic may not be suitable for younger readers. It may contain violence, gore, occasional bad language and other stuff that may not be appropiate for readers under 13.', False, False)
add('TheSilverLeague', 'http://thesilverleague.smackjeeves.com/comics/', u'The Silver League is a comic based around the members of the site of the same name and placing them in our own interpretation of the Pokemon World. Silver August of Harvestone Town is a teen that never really knew life outside his hometown; however after rescuing his Sister from the hands of Team Reaction, Silver becomes motivated to explore the world as a Pok\xc3\xa9mon Trainer! However on his journey, Silver discovers that behind the battles he\'d watch on TV lies corruption because of devices known as "Modifiers" that allow a Trainer to alter a Pokemon\'s stats by force without having to earn them through training. This leads Silver and the friends he makes along the way to form "The Silver League Movement" which vows to travel the region, collecting badges but also recruiting Gym Leaders and convincing them to join their cause so that they can form a league of their own, take down the Team Reaction organization and bring honour, fun and hard work back to Pokemon Battles! http://www.thesilverleague.com/', False, True)
add('TheSixthBar', 'http://thesixthbar.smackjeeves.com/comics/', u'The war between Del-Naaj and Saam-Sara has ended, but Nero knows otherwise. A false peace has been created by the Del-Naajan fear of the Saam-Saran psychics. Torn by the death of his close companion Lynn, Nero has trained for the past six years, sharpening his skills so that he may better protect his city. But a plot is brewing: a plot that will rekindle hostilities between the two cities.', False, True)
add('TheSoulChaser', 'http://thesoulchaser.smackjeeves.com/comics/', u"Paris, XIXth Century. A little girl disappears under strange circumstances while playing with her doll at her home's garden. The police start searching for her, with no success; they just find her doll, stained with blood. Some time later, Fabrice, a young Parisian from a good family, decides to give his fiancee, Sophie, a doll he's found on an antique shop. Though reluctantly at first, she ends up accepting his gift. Later , that night, the young lady is woken up by some strange noises she can't find out where they come from. She convinces herself they're just her imagination, so she goes back to bed. But she's not alone in her room anymore... If you want to read more, go to http://www.mangamagazine.net ^^", False, True)
add('TheSpritersShowcase30', 'http://thespritersshowcase3.smackjeeves.com/comics/', u"Welcome to the third installment of the spriter's showcase! RULES 1.Give credit for any and all sprite sheets. 2.Treat all other authors with respect. Critique is fine. Flaming isn\u2019t. 3.Stick to a posting schedule. (Whatever works for you. Just don\u2019t post one thing and go missing for a month.) 4.No adult content. 5. No recolors or very easy edits are to be posted, this rule is only in place to keep you from getting flamed/trolled. Recolors are looked down upon in this comic. 6. Spriters must have at least some experience with sprites before applying to join. If they do not, their application will be denied. 7. Flaming, spam, and arguing in the comments will not be tolerated, and will be deleted. If you have any questions, concerns, or suggestions, drop a PM my way. -Noland", False, True)
add('TheSummerofBlakeSinclair', 'http://blake-sinclair.smackjeeves.com/comics/', u"A slice of life comic set in the summer of a student's university life. about hipsters, Punks, and ultimately self reflection and 'honesty'. This comic is Apparently what you would call a 'social comedy' and a sattire on generation Y. loosely based on my recently passed student experiences =) Hopefuly this comic will remind you of summer when you read it; enjoy!", False, True)
add('TheTimeDog', 'http://timedog.smackjeeves.com/comics/', u'Ayaka travels through time with "the time-dog". A strange and weird story :)', False, True)
add('TheTytonNuzlockeChallengeEmeraldEdition', 'http://tytonnuzlockeemerald.smackjeeves.com/comics/', u"[Working on: Page 446] Kids, I'm going to tell you a story. The story of how I... no, wait. Sorry. Welcome to the Tyton Nuzlocke Challenge, a character-driven graphic novel created entirely in Microsoft Paint. It updates daily, including weekends, holidays, and apocalypses (apocalypsi?). In a world overrun with eager trainers, the Pokemon Administration has taken desperate measures to ensure the remaining wild Pokemon survive, while allowing trainers to continue their paths. This has resulted in the limiting of catching wild Pokemon, the banning of certain items, and finally--the closing of Pokemon Resurrection Stations in all Pokemon Centers. Enter Tyton. He's thirteen and has less than a year to get all the way to the Pokemon League. Join him and his team as they follow the road to the Elite Four, get wrapped up in the schemes of Teams Aqua and Magma, and (possibly) uncover the mystery of Scott the poofy-haired stalker. There's also a Latin ladies' man Lombre, a swagalicious Gloom, a Numel that hates everyone he's ever met, a firecracker of a Whismur, and the most lovable Dustox you've ever seen. But we'll get to that.", False, False)
add('TheWinterCampaign', 'http://winterc.smackjeeves.com/comics/', u'Japan, 1919. 16-year-old Akio and his mother move into a new home with the mysterious Kikugawa family: A secretive father, a fragile and reclusive son, and the shadow of a mother whose death years ago may be more than it appears. The lines between truth and fantasy, and friend and enemy begin to blur as winter sets in... Drama/Historical/Coming-Of-Age/Romance? Contains angsty teenagers, Taishou-era geekery on the part of the author, and some BL. Updates once or twice a week. (11/25/12 - Currently in the process of switching fonts for the first 114 pages, so things will look a little inconsistent for just a bit!)', False, True)
add('TheZeroSpriteTestgrounds', 'http://thezerospritetestgrounds.smackjeeves.com/comics/', u'This is where all the magic gets tested.', False, True)
add('Theatrics', 'http://theatrics.smackjeeves.com/comics/', u'A weekly movie review comic, starring two ruthless critics who will bash a different cinematic release, both new blockbusters and obscure classics, every week. By Itamar Katz', False, True)
add('ThehumanBEing', 'http://thehumanbeing.smackjeeves.com/comics/', u'"A story about friends and enemies; love and hate; forgiving and forgetting; holding on and letting go. A story about being human, and being MORE..." Follow the story of ten friends as they survive college, friendship, love, and life in general. No matter who we are, what we know, or what we believe, we are all HUMAN. Updates: About a page a week (hopefully ^^;) Reads left to right', False, False)
add('TheiaMania', 'http://theia-mania.smackjeeves.com/comics/', u"My own take on Greek mythology. It's like the gods would have been ordinary people, i.e. no superheroes, no big action. Rather, it's everyday relation life and philosophical, although sometimes emotionally charged (like real life). Occasionally though, the gods have a magical trick or two up their sleeve. :) Join Hermes, Hades, Persephone, Athena and the others as they try to deal with themselves, their complicated family and those strange humans. NEKYIA: A journey down to the Underworld. A philosopher and a necromantic priestess enter Hades' realm to find the answer to the question what a good life really is. At the same time, the messenger god Hermes arrives with a message to Hades... DADDY'S GIRL: Athena is miraculously born from her father's head. She's stronger and more intelligent than most people, but deep down she is just a confused child who tries to understand herself, her family and the world around her. This story takes place long before the events in NEKYIA. Updates usually once a week.", False, True)
add('Themadman', 'http://themadman.smackjeeves.com/comics/', u'everyday insanity, taking what life throws at you just a notch further to show what could happen^^ updates once a week', False, True)
add('ThetaleofAeria', 'http://aeria.smackjeeves.com/comics/', u'Official website: http://www.Aeria-comic.com A tale of adventure, excitement and danger. Well, most of the time at least. But ever so often Fabraz, our chaotic protagonist, finds himself in rather silly situations. Be prepared to be wowed and get ready to follow Fabraz on his epic adventure. You can also buy the first chapter as a printed comic book, if you want to support us! :) http://www.indyplanet.com/store/product_info.php?products_id=4243', False, True)
add('ThiefCatcherRingTail', 'http://tcringtail.smackjeeves.com/comics/', u"RingTail is the hero name of the main character, Lynia, who is actually formally a thief! After her family is arrested she is hired by her rich, genius classmate Rose to test out her superhero inventions. Together, they stop thieves and uncover the sinister plot of Arcadio, Lynia's former employer. This comic reads Left to Right.", False, True)
add('ThinkBeforeYouThink', 'http://thinkbeforeyouthink.smackjeeves.com/comics/', u'A funny, awkward, and spontaneous comic about a guy who can read minds. Updates Fridays.', False, True)
add('ThisistheWorstIdeaYouveEverHad', 'http://twiyeh.smackjeeves.com/comics/', u'TWIYEH! is a an urban fantasy comic about idiots with magic powers and also there are monsters and stuff. Updates every Wednesday and Friday. This is a mirror of the main site located at http://worstidea.skyscrapersoup.com The comic updates there a couple days earlier than I post it here.', False, True)
add('ThornTopia', 'http://tnt100.smackjeeves.com/comics/', u"Thorn is reknown for her alts. This a showcase of all the ones she's got! This series is now completed! Many thanks to all the contributors and followers for sticking around!", False, True)
add('TimeWastingStuff', 'http://timewastingstuff.smackjeeves.com/comics/', u'Aha just a place to put stuff? Sketches and such, sometimes memories, exaggerated things, whatever I feel like putting. Nothing special, read if you wanna see half assed and random inconsistent art XD', False, True)
add('TinyPinkRobots', 'http://tinypinkrobots.smackjeeves.com/comics/', u'Featuring me, my beatnik lumberjack husband, mild cat torture, dancing and the occasional tiny robot. Updates Monday, Wednesday, Friday!', False, True)
add('TitleUnrelated', 'http://www.titleunrelated.com/comics/', u'The Newest Iteration.', False, True)
add('ToddAllisonAndthePetuniaViolet', 'http://todd-petunia.smackjeeves.com/comics/', u"The first time Petunia Elkwood met Todd Allison was an accident and the next time she met him was also an accident. It was also an accident that they came to live next door to each other in an apartment and it was perhaps an accident still when Petunia Elkwood found out something about Todd Allison that she wasn't quite sure what to make of. Updating at MangaMagazine.net", False, True)
add('TotalDramaSurvivor', 'http://totaldramasurvivor.smackjeeves.com/comics/', u"We're bringing back some of your favorite Total Drama contestants for a chance at another million dollars! Who will win? Who will lose? Find out here... on Total Drama Survivor!", False, True)
add('TotallyCrossover', 'http://totallycrossover.smackjeeves.com/comics/', u'There are a lot of typical generic gaming webcomics out there. This one, however, is not one of them. Where most comics are fully happy to parody the gaming world one game at a time, Totally Crossover will parody them all. At the same time. The gaming stars of 2010 unite to face an unknown enemy which could destroy all of time and space itself. This should be fun.', False, True)
add('TransUMan', 'http://transuman.smackjeeves.com/comics/', u'Mutants. Aliens and Zombies, Oh My! It starts simply enough: another day of survival. But then...', True, True)
add('Transfusions', 'http://transfusions.smackjeeves.com/comics/', u"Boy meets a vampire. What happens when they get to know each other? This comic will have lotsa boylove stuff in it, so if you have a problem with that, get rid of that problem and then come back here and enjoy the comic. If you don't have a problem with BL then... enjoy the comic anyways!<3 Updates every Sunday.", False, True)
add('Troublenextdoor', 'http://troublenextdoor.smackjeeves.com/comics/', u"Ilona hates her new neighbor! Sure he might be a tall, athletic, motorcycle-riding hot model kind of a guy but he's snarky and rude. Just like the jocks in school that used to make fun of Ilona because she was a nerdy tomboy girl. And did he say something about Ilona's panties?! This means war! Ilona wants him gone, right now! Because he's a horrible person...but wait, he actually has a kind side? ...and how come he's always helping her out when she's in a pinch? this is...(you guessed it!) a BOYxGIRL romance sprinkled with a lot of humor and a few tearjerking moments. Hand-drawn, scanned and screentoned.", False, True)
add('TwoKeys', 'http://www.two-keys.net/comics/', u'In a city split between humans and occult, Colin Aston just wants to run his diner and make bad coffee. A peaceful life isn\'t on the menu though, as a mysterious blonde shows up with a job only Colin is capable of performing. If he takes it, Colin will have to face sorcerers, politicians, and little old ladies... not to mention a secret that destroyed nearly half the city and hits a little too close to home. If you would like to read more of this comic, please check out <a href="www.mangamagazine.net/manga-and-comics/Two-Keys/detail-page/">manga magazine</a> thanks!', False, False)
add('TwoStories', 'http://www.two-stories.com/comics/', u'Two Stories is an epic adventure of two young characters, Al and Su, who will travel a world of fantasy together in order to find their destinies. Follow Al and Su in their travels, and find out what they are made of!', False, True)
add('UncaFestasScrapbook', 'http://ufs.smackjeeves.com/comics/', u'This comic is intended to showcase various experiments, as well as act a springboard to other ( future ) projects.', False, True)
add('UranusRings', 'http://uranus-rings.smackjeeves.com/comics/', u'---------Still under construction----------- warming: boy love ,violence, emo, stitches and explicit images Age rating: 18+ Uranus Garth is a 17year old model everyone hates him. He shiver at the thought of going home as in the dark shadows await his worst nightmare...', True, True)
add('Vacan7', 'http://vacan7.smackjeeves.com/comics/', u"Django is living with his younger brother in the heart of the big city named Los Perdidos. He's been stuck in a limbo between being a policeman and being a detective for a while now, and he finds himself falling for his new trainer and partner. On top of that Django starts to see and hear things others can't, and hopes his odd behaviour won't get him in trouble. Six voices seek the seventh, Django. Are they here to help or harm him? Updates Thursdays. Contains m/m. Mature: Occasional swearing and half naked dudes.", True, True)
add('Verboten', 'http://verboten.smackjeeves.com/comics/', u'The universe has always been an enigmatic place to human kind. It is said that eons ago, the only thing that existed was a dark, foreboding void. In time, however the Gods created the stars, the planets, and above all, life. This was their masterpiece work. Each God contributed a portion of their power to the creation of human kind....but....the Gods were betrayed by one of their own; The God of Time. After cursing humanity, and nearly driving the rest of the Gods to extinction, he was eventually sealed, and his powerful weapon was banished to the furthest reaches of the universe. But...there are other fearsome creatures that reside in the darkness. Evil things. Living nightmares that seep into this world from where our dimension meets another...', False, True)
add('VerloreGeleentheid', 'http://verlore.thewebcomic.com/comics/', u'"Verlore Geleentheid" is \'n wetenskapfiksie strokiesprent wat hom deur van die ouer wetenskapfiksie soos "All the Way Back" (Michael Shaara) en "Die Oorlewendes" en "Ruimteskip Celeste" (albei deur Johan Bredell) laat inspireer. "Lost Opportunity" is a sci-fi webcomic which is inspired by older SF like "All the Way Back" (Michael Shaara) and "The Survivors" and "Spaceship Celeste" (both by Johan Bredell). It is in Afrikaans. At the moment no English version is planned, although a translation will be provided on the website.', False, True)
add('Villain', 'http://villain.smackjeeves.com/comics/', u'In popular culture, the line between hero and villain has always been well defined, but what if you got to chance to see what goes on for the other team? This is the story of three \'villains\' as they struggle make sense of why they are where they are today, while dealing with the same problems we do, and some much worse. As Villains and Heroes clash, they have to ask themselves, "Who\'s the true hero and who\'s the true villain?"', False, True)
add('Virus000', 'http://virus000.smackjeeves.com/comics/', u'Rei, a 15 year old student, has to switch to a new school because of an accident that killed another student at his old school. Rei knows there is something wrong with him because everytime he\'s angry, any living thing he touches dies within a week. On Rei\'s first day at his new school, his bad luck lands him a detention and he ends up injuring himself on some equipment not put away properly. Harumi, a girl in Rei\'s class attempts to help him but immediately backs off after seeing his wound completely heal itself before her eyes. Rei, not wanting to have this shocking discovery spread, and not wanting to move schools again decides that his only option is to make a deal and keep a sharp eye on Harumi, even if stalking is necessary. But, even with Rei\'s efforts to keep his ability secret, somehow people find out about it... These people call themselves "viruses" that have the intention to kill Rei for being the "one of immortal blood". Due to the constant attacks, Rei and Harumi search to find answers about Rei\u2019s past and why these "viruses" are after him. *** {READ FROM RIGHT TO LEFT} >Shounen >UPDATED WHENEVER POSSIBLE, SO PLEASE BEAR WITH ME!< OTL', False, True)
add('VirusRISING', 'http://virusrising.smackjeeves.com/comics/', u'INFO A deadly virus that deteriorates the brain is wiping out the city. Armed with enhanced stamina, uncontrollable rage, and insanity, an infected canine turns against its captors and flees to the streets. Left to his own agenda, Katzbalger spreads the infection and builds up a pack bent upon slaughtering humans and \'impure\' dogs alike for the sake of "evolution." A small group of street dogs have banded together in a struggle for survival, and those few with a natural immunity to the virus stand as the only defense against devastation. read all current issues on virusrising.com UPDATES i forget to post the pages here sometimes but i draw a new page usually on the weekends! WARNINGS some blood and violence', False, True)
add('VoidMisadventures', 'http://voidmisadventures.smackjeeves.com/comics/', u'Do you have Skype? Want to be on our chat? Add "lucas.robinson4" as a contact and i\'ll put you on it as soon as possible. Quotes ------------------------------------------------------- Achasai: Burning...Freezing...Burning...Freezing...God, it\'s a pain! Alexini: Ugh. y u guise always deaded? Burey: By the name of Daucaus, I shall EAT those cookies! Carbon: I\'M THE ALMIGHTY (and uber smexy) EATIRALATOR! I am the scroll Dry: I\'m completely useless! Firekitty: Meow. *coughs up burning hairball onto something flammable* Gigi: You\'ve gotta tell me when you turn on the mic, ok? Wait, it\'s already on?! HOW COUL- Jason: You mean the guy from- *shot with a potato for overused joke* Lucas: *has nothing to put here* Plazy: Now comes the time for science to triumph over all! Ryan: Spark, Please don\'t talk about that! We need to take care of Libra you bitter moron! Spark: AAAHH! ZOMBIE CLONES FROM OUTER SPACE! *jumps through dimensional rift and faceplants into the warpstar Ryan is riding* Tater: *Reloading potato gun*', False, True)
add('WantedDeadorDead', 'http://wanteddeadordead.smackjeeves.com/comics/', u'Two greedy undead bandits cause havoc in the wild west until one day a misterious little girl in a weird outfit hires them in order to help her father. Demons, monsters and wild west action! Beware of violence and foul language. Read L-->R Updates: Wednesday and Friday. Comment plz! :3', False, True)
add('WeCanDefeatAnyone', 'http://candefeatanyone.smackjeeves.com/comics/', u"A journey to beat all the Megaman games.... Perhaps. Formerly called: - I Can't Defeat Anyone - I Can Defeat Anyone Updates at odd-numbered dates.", False, True)
add('WelcomeBackToTheLandOfForgottenMemories', 'http://wbttlofm.smackjeeves.com/comics/', u'A surreal comic that takes place in New York city and the dream world of CommonFictura, a world created by a boy named Jacob White.', False, True)
add('WelcometoFreakshow', 'http://welcometofreakshow.smackjeeves.com/comics/', u'The audience roars, the acrobats and performers provide them with a spectacle unrivaled in all of Europe. The lights die, and the audience is now the entertainment for the apathetic circus. As blood and bone rush to the surface, one man leads the troupe downward to the darkest ring of all. Welcome to the Freakshow. //Updates Every Friday//', False, False)
add('WestburyDetectives', 'http://westbury.smackjeeves.com/comics/', u"After his ex-girlfriend's accident, young Manhattan investigator Jack Arthur is transferred to an independent detective agency in Nassau County. At the same time, up-and-coming mob boss Pinhead Miyamoto is determined to avenge the murder of his adopted father. As the violent attacks on detectives and civilians increase, Jack is thrown into a violent rivalry with Miyamoto, finding he may be the only man able to keep the village from falling apart... Updated unevenly. Warnings for violence and mild sexual situations.", False, True)
add('WhatAboutLove', 'http://whataboutlove.smackjeeves.com/comics/', u"Takao has had a secret crush on his classmate, Hisoka, since he first entered high school. Now it's Takao's last year and he figures it's now or never so he does the crazy thing and confesses. Much to his surprise, Hisoka agrees to be his boyfriend. Takao is in pure bliss... until he realizes Hisoka has different aims. While Takao wants an actual relationship all Hisoka seems to be interested in is, well, physical stuff. So now Takao has to figure out a way to make Hisoka see him in a different way, but that's not easy since other men (realizing Hisoka goes that way) have taken an interest. Can Takao fend off potential rivals and get the guy he loves to love him back while facing all the other drama that comes with high school? Probably not, but that won't stop him from trying! Warning: - This is a Yaoi comic. I think that should be self-explanatory, but that means man on man action.", True, True)
add('WhatHappensinCarpediem', 'http://whic.smackjeeves.com/comics/', u'a comic by Piggy Ho Ho Welcome to Carpediem, the world of the massively popular MMORPG. When Naoto and Chris set out to find a strong attacker for their party, Kurogawa is not quite what they expected... *This is a BL story*', True, True)
add('WhenSheWasBad', 'http://whenshewasbad.smackjeeves.com/comics/', u'For every story about a hero, there is a "bad guy". Only, this story isn\'t about the hero. It\'s about the smart-alec, tough-as-nails villain. About her fights, her triumphs, her losses, her lackeys... And maybe her love life. If she can ever get the guts to ask the girl of her dreams out. (contains mostly yuri/GL and a bit of background het...Beware of foul language. It\'s mostly rated "mature" for violence and cursing. Sort of like an extremely f-d up reverse version of a magical girl story.) Read L->R, western style. For now, due to my work schedule, updates will be on either Thursday or Friday, sometimes both. This is subject to change, since my schedule/days off changes every few months. A lot of the shading from Interlude 1 and #13 done by Jovat. <3 Sidenote... This comic is not for horny guys hoping to see "HOTT LESBO ACTION ZOMG!!!11ONE" Yes, the main character happens to be a lesbian. But this story is about the plot, not "porn".', False, True)
add('Whenweweresilent', 'http://silence.smackjeeves.com/comics/', u'Two girls with different pasts, problems and ambitions - one future and one friendship.', False, False)
add('WhiteHeart', 'http://whiteheart.smackjeeves.com/comics/', u'"Lady Love received a magical book of the dark powers to her hands, and summoned a great, divine spirit. The spirit promises that Lady can make one wish, if she catches all the eight special albino souls and brings them to the spirit. Greedy Lady accepts the mission, and so the bloody collecting of albino humans begin... White is a tough and intense young man from the streets. He has been running away from Lady ever since when Love killed his gang and beloved. White is thirsty for revenge, but can do nothing but run away from Love and her henchmen... However, White finally meets Black, a friendly musician, who takes White with him and wants to help him in any way he possibly can. Both of them become good friends, but living in the same apartment makes both of them feel something stronger than just friendship..." WARNING: This comic contains gay relationships, sex, blood, swearing, crying and angsting, confusing scenes, drama and possible grammar mistakes. NOTICE! I started the comic in 2008, so the first four chapters are pretty awful to read... but please bear it, \'cause I\'m saving all the re-drawn pages for the possible-author\'s edition.', True, False)
#add('WhiteNoise', 'http://white-noise.smackjeeves.com/comics/', u'Warning: Shoujo/Shojo Story about the lives of 4 individuals. ~ Romance/Humour ~ Read from left to right >>>>>', False, True)
add('WildWingBoysKoathArc', 'http://wwbka.smackjeeves.com/comics/', u'When a freak dimensional portal sends the five main characters of Gundam Wing into a fantasy world and puts Heero in a coma, the four remaining pilots, accompanied by a young catboy named Toko, must conquer various obstacles in finding a cure...and a way home.', False, True)
add('WintersinLavelle', 'http://wintersinlavelle.smackjeeves.com/comics/', u'Winters in Lavelle follows siblings Kari and Aiden as they discover an old family heirloom is more than it seems. Lost in a strange world, they must find a way to stay together and alive amid strange cloaked men, human/deer hybrids, dragon kings, and magic amber that will change the course of their lives.', False, True)
add('WitchsQuarry', 'http://witchsquarry.smackjeeves.com/comics/', u"For most current pages see Witch's Quarry at Mangamagazine.net. http://www.mangamagazine.net/manga-and-comics/Witchs-Quarry/detail-page/357?lang=en Currently Updating Here Tuesdays and sometimes Thursdays This is the tale of Sir Veolynn Moreshire's greatest and strangest achievement. Fate would have her/him led by the whims of a powerful witch. This is what really happened in the Second Great War for Oladuan; when heroes and villains were neither righteous or evil. There were other hidden creatures that placed high stakes in the outcome of the human's conflict. And there were a great many funny things that just didn't go as planned. All's fair game in love, war and species propagation! Rated PG-13 *warning* some adult situations/humor/GLBT themes Rogue X Knight Intermission short story of Wesyng Reedle meets a man who shares the same face, Sir Deshad Bright. Suggested age +16 for mature themes.", False, True)
add('WithACherryOnTop', 'http://wacot.smackjeeves.com/comics/', u"Started in 2006, currently in Issue 6 Kira Morishita is just your everyday high school student: average grades, many friends and plays on Sakio Highs Boys soccer team. His secret? He\x92s actually a she! After finding out that Sakio High no longer has a girls\x92 team, Kira disguises herself as a boy to play. As the saying goes, \x93Whatever can go wrong, will. Her new best friend fell in love with her at first sight, she likes the boy that sits next to her in class, but he hates her, and on top of that she\x92s a benchwarmer until further notice: is this what she traded her skirt in for? Will Kira be able to become a star on the boys\x92 soccer team, and keep the others from finding out she's a girl? ~READS RIGHT to LEFT~ ^_^ Updates are usually Tuesday, Thursday and Saturday, or every other day~ :) **NOTE**Pages will only be sketches for a few months, until I finish up my other series (aiming for March!)", False, True)
add('Wootlabs', 'http://wootlabs.thewebcomic.com/comics/', u'"Square Woot is the worst supervillain I ever fought. She held her death ray backwards and vaporized half of her robot army." - Riot Girl, superhero "An uplifting story for anyone that loves cute things in hats." - Penguin Parade Weekly "THIS IS THE STORY OF CATBOT 9000. EVERYONE ELSE IN IT IS STUPID AND NOT CATBOT 9000." - Catbot 9000 Square Woot is a genius with robots, weapons, and that funky little thing called science. Joined by her penguin sidekick and her family of creations, all she wants to do is rule the world. At least, that\'s all she used to want. A chance encounter has the group thinking that it might be more fun to be heroes from now on. Is the city ready to be saved through mad science?', False, True)
add('XTINTheDragonsDreamworld', 'http://xtin.smackjeeves.com/comics/', u'The Lord Always Comes for His Sacrifice', True, True)
add('XYZ', 'http://xyz.smackjeeves.com/comics/', u'[COMPLETE] ~~~READS LEFT-TO-RIGHT~~~ Two twin sisters, Tomi and Tori, grew up with the average twin sister life- sharing everything: their faces, their clothes, their grades... And then they hit puberty. Tomi went through the expected changes- filling out in places, and going all out "girly". As for Tori...not so much. What her sister got in chest she got in height, and that was basically it. This unexplainable change makes everyone think Tori is a guy, and more particularly, Tomi\'s brother (which helps Tomi out alot). However, crossing the line can be painful and dangerous, and above all, lonely. {ZOMG, It\'s actually a romance/shoujo *_*} UPDATES Tues, Thurs Saturday and/or Sunday', False, True)
add('Yamase', 'http://yamasemanga.smackjeeves.com/comics/', u'Yamase is the story of a nonchalant young girl who randomly gets super powers. Problem is, these super powers were created with tons of secrets behind them, and now everyone in the world wants her dead. Niiiiicce.', False, True)
add('Yaoishereforareason', 'http://yaoishereforareason.smackjeeves.com/comics/', u"A Yaoi collab. Rules. No furries. (Sorry furry fans) You can have up to four characters. Characters can be anything. (Vampire, demon, fairy. etc.) Pro or Beginners are welcomed. NO trashing on other's work, be nice! Mature or mild things are welcomed and loved. So, if your interested, we are still accepting about.. Five or four more.. Hope to hear from you! <3 Yoai.", True, False)
add('YoshisForever', 'http://yoshi.smackjeeves.com/comics/', u'', False, True)
add('YoungCannibals', 'http://youngcannibals.smackjeeves.com/comics/', u"The story of one girl's battle NOT to kill her friends. Updates every Monday & Friday.", False, True)
add('YuGiOh09', 'http://ygo-09.smackjeeves.com/comics/', u"--Updates Mondays and Thursdays-- Sakima Hirose's tragic past leads him down the path of justice as a part of the Duel Agents--a CIA-style team of ten Duelists made to take on the high crime of Neo Domino City! With the threat of the terror gang Aurora looming over the horizon, can Sakima work with his fellow Duel Agents Azuki Haneaoi and Taisuke Yatsuda to take Aurora down? Follow the story of Sakima and the Duel Agents as Yu-Gi-Oh! 09 presents all new cards, characters, and challenges in the biggest Yu-Gi-Oh! fan comic the internet has to offer!", False, True)
add('ZaenWell', 'http://zaenwell.smackjeeves.com/comics/', u'Thrown into the well of the Gods as part of an initiation, Renee Nathans has fourteen days to find a suitable God to bring back into the world of humanity. Danger lurks behind every corner, however, and when a rogue God decides humanity is no longer necessary, an already difficult task becomes even harder...', False, True)
add('Zodiac', 'http://zodiac.smackjeeves.com/comics/', u"A curse has fallen on the ten students along with their two teachers, and they must work together to find the source and break it, so they can spent their lives like it was before. The story will be, most of the time, stupid. You've been warned :D Updates: !!! When a page is out/Very possibly Sunday and MAYBE tuesday", False, False)
add('ZonowTheHedgehog', 'http://zonow.smackjeeves.com/comics/', u"As an Alien creature from a far away planet lands on Earth he soon calls it home and decides to do anything to keep it safe. This story will not tell the life of one but, The lives of many and will show how each of them intertwine with one another. This is Zonow Story. It's recommended that you read Season 2's section. Not reading season 1 will not make a difference. CAMEO'S ARE WELCOME! PLEASE SEND TO PARRISH_BROADNAX ~thankyou.", False, True)
add('ZosKias', 'http://zoskias.smackjeeves.com/comics/', u"Being a part of the gatekeeper's sepcial clean-up crew is never easy! From vampires to new magick users, there is never any time for breaks! But, the fighting is the easiest part about it... Mizuno Umishin has been a member for a couple years, but he has yet to do any real fieldwork as he's lacking a partner. When he goes to find his...it's not what he bargained for! But now, the real question isn't whethe Light is up to the task...it's whether Umishin and Light can ever get along and become true partners!", False, True)
