// This code conforms with the UFC specification version 1.4
// and was automatically generated by FFC version 0.9.2.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   epsilon:                        1e-14
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   optimize:                       False
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __POISSON3D_4_H
#define __POISSON3D_4_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class poisson3d_4_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  poisson3d_4_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_4_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 4)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 35;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    *values = 0.000000000000000;
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    unsigned int tt = 0;
    double tmp5 = 0.000000000000000;
    double tmp6 = 0.000000000000000;
    double tmp7 = 0.000000000000000;
    double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
    double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
    double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
    double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
    double tmp4 = tmp3*tmp3;
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 1; r < 4; r++)
    {
      rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
      ss = r*(r + 1)*(r + 2)/6;
      tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
      basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 4; r++)
    {
      rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
      ss = r*(r + 1)*(r + 2)/6;
      basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
    }// end loop over 'r'
    for (unsigned int r = 0; r < 3; r++)
    {
      for (unsigned int s = 1; s < 4 - r; s++)
      {
        rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
        tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 0; s < 4 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 3; r++)
    {
      for (unsigned int s = 0; s < 3 - r; s++)
      {
        for (unsigned int t = 1; t < 4 - r - s; t++)
        {
          rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
          ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
          tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 5; r++)
    {
      for (unsigned int s = 0; s < 5 - r; s++)
      {
        for (unsigned int t = 0; t < 5 - r - s; t++)
        {
          rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[35][35] = \
    {{-0.013746434980705, -0.014490014748814, -0.008365813915789, -0.005915523749999, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.006719368409053, -0.005678902799999, -0.004918074090422, -0.004398859193826, -0.003809523809524, -0.003110463165439, -0.002539682539683, -0.002199429596913, -0.001795826745871, -0.001269841269841, 0.013698028951634, 0.012080526019262, 0.010805150953210, 0.010209907964538, 0.009132019301089, 0.007908560702593, 0.007908560702593, 0.007073631734073, 0.006125944778723, 0.005001812966779, 0.004566009650545, 0.004083963185815, 0.003536815867036, 0.002887798062806, 0.002041981592908},
    {-0.013746434980705, 0.014490014748814, -0.008365813915789, -0.005915523749999, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.006719368409053, -0.005678902799999, -0.004918074090422, 0.004398859193826, 0.003809523809524, 0.003110463165439, -0.002539682539683, -0.002199429596913, -0.001795826745871, -0.001269841269841, 0.013698028951634, -0.012080526019262, -0.010805150953210, 0.010209907964538, 0.009132019301089, 0.007908560702593, -0.007908560702593, -0.007073631734073, -0.006125944778723, -0.005001812966779, 0.004566009650545, 0.004083963185815, 0.003536815867036, 0.002887798062806, 0.002041981592908},
    {-0.013746434980705, 0.000000000000000, 0.016731627831579, -0.005915523749999, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.010158730158730, -0.006598288790739, 0.003591653491741, -0.001269841269841, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.022830048252724, -0.016335852743261, 0.010610447601109, -0.005775596125612, 0.002041981592908},
    {-0.013746434980705, 0.000000000000000, 0.000000000000000, 0.017746571249998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.012698412698413, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.030629723893614},
    {0.043988591938257, 0.000000000000000, 0.026770604530526, 0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.058191437396265, -0.031675406448880, 0.011198947348422, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.040634920634921, 0.004398859193826, -0.014366613966965, 0.007619047619048, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.036755668672337, -0.042441790404437, 0.030321879659465, -0.012251889557446},
    {-0.032991443953693, 0.000000000000000, -0.020077953397895, -0.014197256999999, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.009698572899377, 0.071269664509980, -0.050395263067897, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.046188021535170, 0.010774960475224, -0.019047619047619, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.049515422138510, -0.060643759318929, 0.030629723893614},
    {0.043988591938257, 0.000000000000000, 0.026770604530526, 0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.067193684090529, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.035916534917412, 0.025396825396825, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.050536466099108, -0.040839631858152},
    {0.043988591938257, 0.023184023598102, -0.013385302265263, 0.018929675999998, 0.043373336575490, -0.033596842045265, -0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, 0.026877473636212, -0.022715611199998, 0.003278716060281, 0.017595436775303, -0.002539682539683, -0.012441852661756, -0.010158730158730, 0.001466286397942, 0.007183306983482, 0.007619047619048, 0.000000000000000, 0.000000000000000, 0.024311589644723, 0.000000000000000, -0.020547043427451, -0.031634242810373, 0.000000000000000, 0.015915671401664, 0.024503779114891, 0.026259518075591, 0.000000000000000, -0.009188917168084, -0.014147263468146, -0.015160939829732, -0.012251889557446},
    {-0.032991443953693, -0.017388017698577, 0.010038976698947, -0.014197256999999, -0.007228889429248, 0.005599473674211, 0.061721339984837, -0.003232857633126, -0.035634832254990, -0.050395263067897, 0.000000000000000, 0.000000000000000, 0.034426518632955, 0.000000000000000, -0.026666666666667, 0.009331389496317, 0.000000000000000, 0.015396007178390, -0.005387480237612, -0.019047619047619, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.036906616612102, 0.000000000000000, 0.000000000000000, -0.028587742300706, -0.052519036151182, 0.000000000000000, 0.000000000000000, 0.016505140712837, 0.030321879659465, 0.030629723893614},
    {0.043988591938257, 0.023184023598102, -0.013385302265263, 0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.067193684090529, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.031104631654390, 0.000000000000000, 0.000000000000000, -0.017958267458706, 0.025396825396825, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.043765863459318, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.025268233049554, -0.040839631858152},
    {0.043988591938257, 0.023184023598102, 0.013385302265263, -0.018929675999998, 0.043373336575490, -0.033596842045265, -0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, 0.026877473636212, 0.000000000000000, -0.022951012421970, -0.011730291183535, 0.007619047619048, 0.016589136882341, 0.010158730158730, -0.001466286397942, -0.007183306983482, -0.007619047619048, 0.000000000000000, 0.024161052038524, -0.002701287738303, -0.035734677875883, -0.011415024126362, 0.003954280351297, 0.035588523161670, 0.015915671401664, 0.003062972389361, -0.003751359725084, -0.022830048252724, -0.011230898760992, -0.003536815867036, 0.000721949515702, 0.002041981592908},
    {-0.032991443953693, -0.017388017698577, -0.010038976698947, 0.014197256999999, -0.007228889429248, 0.061594210416319, -0.006857926664982, -0.061424295029390, -0.003959425806110, 0.005599473674211, 0.000000000000000, 0.034073416799997, -0.004918074090422, 0.000000000000000, -0.026666666666667, 0.009331389496317, -0.015238095238095, 0.017595436775303, 0.005387480237612, -0.007619047619048, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.035734677875883, -0.009132019301089, 0.001318093450432, -0.059314205269449, 0.000000000000000, 0.007146935575177, -0.002500906483390, 0.045660096505447, 0.004083963185815, -0.004715754489382, -0.001443899031403, 0.002041981592908},
    {0.043988591938257, 0.023184023598102, 0.013385302265263, -0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.058191437396265, -0.031675406448880, 0.011198947348422, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.029325727958838, -0.010158730158730, 0.002073642110293, 0.010158730158730, -0.021994295969129, 0.017958267458706, -0.007619047619048, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.039542803512966, -0.017684079335182, 0.006125944778723, -0.001250453241695, -0.045660096505447, 0.014293871150353, 0.000000000000000, -0.003609747578508, 0.002041981592908},
    {0.043988591938257, -0.023184023598102, -0.013385302265263, 0.018929675999998, 0.043373336575490, 0.033596842045265, 0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, -0.026877473636212, -0.022715611199998, 0.003278716060281, -0.017595436775303, 0.002539682539683, 0.012441852661756, -0.010158730158730, 0.001466286397942, 0.007183306983482, 0.007619047619048, 0.000000000000000, 0.000000000000000, -0.024311589644723, 0.000000000000000, -0.020547043427451, -0.031634242810373, 0.000000000000000, -0.015915671401664, -0.024503779114891, -0.026259518075591, 0.000000000000000, -0.009188917168084, -0.014147263468146, -0.015160939829732, -0.012251889557446},
    {-0.032991443953693, 0.017388017698577, 0.010038976698947, -0.014197256999999, -0.007228889429248, -0.005599473674211, -0.061721339984837, -0.003232857633126, -0.035634832254990, -0.050395263067897, 0.000000000000000, 0.000000000000000, 0.034426518632955, 0.000000000000000, 0.026666666666667, -0.009331389496317, 0.000000000000000, 0.015396007178390, -0.005387480237612, -0.019047619047619, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.036906616612102, 0.000000000000000, 0.000000000000000, 0.028587742300706, 0.052519036151182, 0.000000000000000, 0.000000000000000, 0.016505140712837, 0.030321879659465, 0.030629723893614},
    {0.043988591938257, -0.023184023598102, -0.013385302265263, 0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.067193684090529, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.031104631654390, 0.000000000000000, 0.000000000000000, -0.017958267458706, 0.025396825396825, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.043765863459318, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.025268233049554, -0.040839631858152},
    {0.043988591938257, -0.023184023598102, 0.013385302265263, -0.018929675999998, 0.043373336575490, 0.033596842045265, 0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, -0.026877473636212, 0.000000000000000, -0.022951012421970, 0.011730291183535, -0.007619047619048, -0.016589136882341, 0.010158730158730, -0.001466286397942, -0.007183306983482, -0.007619047619048, 0.000000000000000, -0.024161052038524, 0.002701287738303, -0.035734677875883, -0.011415024126362, 0.003954280351297, -0.035588523161670, -0.015915671401664, -0.003062972389361, 0.003751359725084, -0.022830048252724, -0.011230898760992, -0.003536815867036, 0.000721949515702, 0.002041981592908},
    {-0.032991443953693, 0.017388017698577, -0.010038976698947, 0.014197256999999, -0.007228889429248, -0.061594210416319, 0.006857926664982, -0.061424295029390, -0.003959425806110, 0.005599473674211, 0.000000000000000, 0.034073416799997, -0.004918074090422, 0.000000000000000, 0.026666666666667, -0.009331389496317, -0.015238095238095, 0.017595436775303, 0.005387480237612, -0.007619047619048, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.035734677875883, -0.009132019301089, 0.001318093450432, 0.059314205269449, 0.000000000000000, -0.007146935575177, 0.002500906483390, 0.045660096505447, 0.004083963185815, -0.004715754489382, -0.001443899031403, 0.002041981592908},
    {0.043988591938257, -0.023184023598102, 0.013385302265263, -0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.058191437396265, -0.031675406448880, 0.011198947348422, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.029325727958838, 0.010158730158730, -0.002073642110293, 0.010158730158730, -0.021994295969129, 0.017958267458706, -0.007619047619048, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.039542803512966, 0.017684079335182, -0.006125944778723, 0.001250453241695, -0.045660096505447, 0.014293871150353, 0.000000000000000, -0.003609747578508, 0.002041981592908},
    {0.043988591938257, 0.000000000000000, -0.026770604530526, -0.018929675999998, 0.043373336575490, 0.033596842045265, 0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, 0.013438736818106, -0.011357805599999, -0.009836148180844, -0.020528009571187, -0.017777777777778, -0.014515494772048, -0.015238095238095, -0.013196577581477, -0.010774960475224, -0.007619047619048, -0.054792115806536, -0.024161052038524, -0.021610301906420, -0.005104953982269, -0.004566009650545, -0.003954280351297, 0.003954280351297, 0.003536815867036, 0.003062972389361, 0.002500906483390, 0.004566009650545, 0.004083963185815, 0.003536815867036, 0.002887798062806, 0.002041981592908},
    {-0.032991443953693, 0.000000000000000, 0.020077953397894, 0.014197256999999, -0.086746673150981, 0.000000000000000, 0.000000000000000, 0.009698572899377, 0.007918851612220, 0.005599473674211, 0.000000000000000, 0.034073416799997, 0.029508444542533, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.015238095238095, -0.013196577581477, -0.010774960475224, -0.007619047619048, 0.082188173709805, 0.000000000000000, 0.000000000000000, -0.010209907964538, -0.009132019301089, -0.007908560702593, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.004566009650545, 0.004083963185815, 0.003536815867036, 0.002887798062806, 0.002041981592908},
    {0.043988591938257, 0.000000000000000, -0.026770604530526, -0.018929675999998, 0.043373336575490, -0.033596842045265, -0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, -0.013438736818106, -0.011357805599999, -0.009836148180844, 0.020528009571187, 0.017777777777778, 0.014515494772048, -0.015238095238095, -0.013196577581477, -0.010774960475224, -0.007619047619048, -0.054792115806536, 0.024161052038524, 0.021610301906420, -0.005104953982269, -0.004566009650545, -0.003954280351297, -0.003954280351297, -0.003536815867036, -0.003062972389361, -0.002500906483390, 0.004566009650545, 0.004083963185815, 0.003536815867036, 0.002887798062806, 0.002041981592908},
    {0.043988591938257, 0.139104141588614, -0.080311813591578, -0.056789027999995, 0.057831115433987, 0.033596842045265, 0.027431706659927, -0.042027149230636, -0.047513109673320, -0.016798421022632, 0.000000000000000, 0.045431222399996, 0.039344592723377, -0.058651455917676, 0.002539682539683, -0.060135621198486, 0.040634920634921, -0.010997147984564, 0.017958267458706, 0.039365079365079, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.041094086854902, -0.010544747603458, 0.000000000000000, -0.053052238005546, -0.024503779114891, 0.017506345383727, 0.000000000000000, 0.036755668672337, 0.023578772446909, 0.000000000000000, -0.012251889557446},
    {0.043988591938257, 0.000000000000000, 0.160623627183156, -0.056789027999995, 0.000000000000000, 0.078392631438951, -0.027431706659927, 0.009698572899377, 0.047513109673320, -0.016798421022632, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.058651455917676, 0.033015873015873, -0.014515494772048, -0.060952380952381, 0.024193725566041, -0.061058109359600, 0.039365079365079, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.053052238005546, -0.032671705486522, 0.008753172691864, 0.000000000000000, -0.055133503008505, 0.014147263468146, 0.015160939829732, -0.012251889557446},
    {0.043988591938257, 0.000000000000000, 0.000000000000000, 0.170367083999984, 0.000000000000000, -0.011198947348422, 0.082295119979782, 0.009698572899377, 0.047513109673320, -0.016798421022632, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.053333333333333, 0.043546484316145, 0.000000000000000, -0.046188021535170, 0.025141574442188, -0.082539682539683, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.057175484601413, -0.026259518075591, 0.000000000000000, 0.000000000000000, -0.049515422138510, -0.015160939829732, 0.030629723893614},
    {0.043988591938257, -0.139104141588614, -0.080311813591578, -0.056789027999995, 0.057831115433987, -0.033596842045265, -0.027431706659927, -0.042027149230636, -0.047513109673320, -0.016798421022632, 0.000000000000000, 0.045431222399996, 0.039344592723377, 0.058651455917676, -0.002539682539683, 0.060135621198486, 0.040634920634921, -0.010997147984564, 0.017958267458706, 0.039365079365079, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.041094086854902, -0.010544747603458, 0.000000000000000, 0.053052238005546, 0.024503779114891, -0.017506345383727, 0.000000000000000, 0.036755668672337, 0.023578772446909, 0.000000000000000, -0.012251889557446},
    {0.043988591938257, 0.000000000000000, 0.160623627183156, -0.056789027999995, 0.000000000000000, -0.078392631438951, 0.027431706659927, 0.009698572899377, 0.047513109673320, -0.016798421022632, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.058651455917676, -0.033015873015873, 0.014515494772048, -0.060952380952381, 0.024193725566041, -0.061058109359600, 0.039365079365079, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.053052238005546, 0.032671705486522, -0.008753172691864, 0.000000000000000, -0.055133503008505, 0.014147263468146, 0.015160939829732, -0.012251889557446},
    {0.043988591938257, 0.000000000000000, 0.000000000000000, 0.170367083999984, 0.000000000000000, 0.011198947348422, -0.082295119979782, 0.009698572899377, 0.047513109673320, -0.016798421022632, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.053333333333333, -0.043546484316145, 0.000000000000000, -0.046188021535170, 0.025141574442188, -0.082539682539683, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.057175484601413, 0.026259518075591, 0.000000000000000, 0.000000000000000, -0.049515422138510, -0.015160939829732, 0.030629723893614},
    {0.043988591938257, -0.139104141588614, -0.080311813591578, -0.056789027999995, -0.043373336575490, 0.044795789393686, -0.054863413319855, 0.048492864496887, 0.000000000000000, -0.016798421022632, 0.080632420908635, 0.022715611199998, -0.003278716060281, -0.005865145591768, 0.030476190476190, 0.045620126426438, -0.010158730158730, 0.027126298361925, 0.043099841900894, 0.039365079365079, 0.000000000000000, 0.000000000000000, 0.072934768934168, 0.000000000000000, 0.020547043427451, 0.031634242810373, 0.000000000000000, -0.005305223800555, -0.008167926371630, -0.008753172691864, 0.000000000000000, -0.009188917168084, -0.014147263468146, -0.015160939829732, -0.012251889557446},
    {0.043988591938257, 0.139104141588614, -0.080311813591578, -0.056789027999995, -0.043373336575490, -0.044795789393686, 0.054863413319855, 0.048492864496887, 0.000000000000000, -0.016798421022632, -0.080632420908635, 0.022715611199998, -0.003278716060281, 0.005865145591768, -0.030476190476190, -0.045620126426438, -0.010158730158730, 0.027126298361925, 0.043099841900894, 0.039365079365079, 0.000000000000000, 0.000000000000000, -0.072934768934168, 0.000000000000000, 0.020547043427451, 0.031634242810373, 0.000000000000000, 0.005305223800555, 0.008167926371630, 0.008753172691864, 0.000000000000000, -0.009188917168084, -0.014147263468146, -0.015160939829732, -0.012251889557446},
    {0.043988591938257, 0.000000000000000, 0.000000000000000, 0.170367083999984, 0.014457778858497, 0.000000000000000, 0.000000000000000, -0.003232857633126, -0.095026219346640, -0.016798421022632, 0.000000000000000, 0.000000000000000, -0.068853037265910, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.015396007178390, -0.050283148884377, -0.082539682539683, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.073813233224204, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.016505140712837, 0.030321879659465, 0.030629723893614},
    {0.043988591938257, -0.139104141588614, -0.080311813591578, -0.056789027999995, -0.043373336575490, -0.044795789393686, 0.054863413319855, -0.009698572899377, 0.031675406448880, 0.039196315719475, 0.080632420908635, 0.000000000000000, 0.022951012421970, 0.052786310325909, 0.010158730158730, -0.012441852661756, 0.060952380952381, 0.016862293576332, -0.007183306983482, -0.013968253968254, 0.000000000000000, 0.072483156115573, -0.008103863214908, 0.035734677875883, 0.011415024126362, -0.003954280351297, -0.011862841053890, -0.005305223800555, -0.001020990796454, 0.001250453241695, -0.022830048252724, -0.011230898760992, -0.003536815867036, 0.000721949515702, 0.002041981592908},
    {0.043988591938257, 0.139104141588614, -0.080311813591578, -0.056789027999995, -0.043373336575490, 0.044795789393686, -0.054863413319855, -0.009698572899377, 0.031675406448880, 0.039196315719475, -0.080632420908635, 0.000000000000000, 0.022951012421970, -0.052786310325909, -0.010158730158730, 0.012441852661756, 0.060952380952381, 0.016862293576332, -0.007183306983482, -0.013968253968254, 0.000000000000000, -0.072483156115573, 0.008103863214908, 0.035734677875883, 0.011415024126362, -0.003954280351297, 0.011862841053890, 0.005305223800555, 0.001020990796454, -0.001250453241695, -0.022830048252724, -0.011230898760992, -0.003536815867036, 0.000721949515702, 0.002041981592908},
    {0.043988591938257, 0.000000000000000, 0.160623627183156, -0.056789027999995, 0.014457778858497, 0.000000000000000, 0.000000000000000, -0.061424295029390, -0.063350812897760, 0.039196315719475, 0.000000000000000, -0.068146833599994, 0.009836148180844, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.091428571428571, 0.028592584759867, 0.014366613966965, -0.013968253968254, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.071469355751766, 0.018264038602179, -0.002636186900864, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.045660096505447, 0.004083963185815, -0.004715754489382, -0.001443899031403, 0.002041981592908},
    {0.351908735506058, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.115662230867974, 0.000000000000000, 0.000000000000000, -0.129314305325033, 0.000000000000000, -0.134387368181059, 0.000000000000000, -0.090862444799991, -0.078689185446754, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.040634920634921, -0.087977183876514, 0.000000000000000, 0.071111111111111, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.082188173709805, 0.021089495206915, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.036755668672337, 0.023578772446909, 0.000000000000000, -0.012251889557446}};
    
    // Compute value(s).
    for (unsigned int r = 0; r < 35; r++)
    {
      *values += coefficients0[dof][r]*basisvalues[r];
    }// end loop over 'r'
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.000000000000000;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 35; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    unsigned int tt = 0;
    double tmp5 = 0.000000000000000;
    double tmp6 = 0.000000000000000;
    double tmp7 = 0.000000000000000;
    double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
    double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
    double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
    double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
    double tmp4 = tmp3*tmp3;
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 1; r < 4; r++)
    {
      rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
      ss = r*(r + 1)*(r + 2)/6;
      tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
      basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 4; r++)
    {
      rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
      ss = r*(r + 1)*(r + 2)/6;
      basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
    }// end loop over 'r'
    for (unsigned int r = 0; r < 3; r++)
    {
      for (unsigned int s = 1; s < 4 - r; s++)
      {
        rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
        tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 0; s < 4 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 3; r++)
    {
      for (unsigned int s = 0; s < 3 - r; s++)
      {
        for (unsigned int t = 1; t < 4 - r - s; t++)
        {
          rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
          ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
          tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 5; r++)
    {
      for (unsigned int s = 0; s < 5 - r; s++)
      {
        for (unsigned int t = 0; t < 5 - r - s; t++)
        {
          rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[35][35] = \
    {{-0.013746434980705, -0.014490014748814, -0.008365813915789, -0.005915523749999, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.006719368409053, -0.005678902799999, -0.004918074090422, -0.004398859193826, -0.003809523809524, -0.003110463165439, -0.002539682539683, -0.002199429596913, -0.001795826745871, -0.001269841269841, 0.013698028951634, 0.012080526019262, 0.010805150953210, 0.010209907964538, 0.009132019301089, 0.007908560702593, 0.007908560702593, 0.007073631734073, 0.006125944778723, 0.005001812966779, 0.004566009650545, 0.004083963185815, 0.003536815867036, 0.002887798062806, 0.002041981592908},
    {-0.013746434980705, 0.014490014748814, -0.008365813915789, -0.005915523749999, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.006719368409053, -0.005678902799999, -0.004918074090422, 0.004398859193826, 0.003809523809524, 0.003110463165439, -0.002539682539683, -0.002199429596913, -0.001795826745871, -0.001269841269841, 0.013698028951634, -0.012080526019262, -0.010805150953210, 0.010209907964538, 0.009132019301089, 0.007908560702593, -0.007908560702593, -0.007073631734073, -0.006125944778723, -0.005001812966779, 0.004566009650545, 0.004083963185815, 0.003536815867036, 0.002887798062806, 0.002041981592908},
    {-0.013746434980705, 0.000000000000000, 0.016731627831579, -0.005915523749999, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.010158730158730, -0.006598288790739, 0.003591653491741, -0.001269841269841, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.022830048252724, -0.016335852743261, 0.010610447601109, -0.005775596125612, 0.002041981592908},
    {-0.013746434980705, 0.000000000000000, 0.000000000000000, 0.017746571249998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.012698412698413, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.030629723893614},
    {0.043988591938257, 0.000000000000000, 0.026770604530526, 0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.058191437396265, -0.031675406448880, 0.011198947348422, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.040634920634921, 0.004398859193826, -0.014366613966965, 0.007619047619048, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.036755668672337, -0.042441790404437, 0.030321879659465, -0.012251889557446},
    {-0.032991443953693, 0.000000000000000, -0.020077953397895, -0.014197256999999, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.009698572899377, 0.071269664509980, -0.050395263067897, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.046188021535170, 0.010774960475224, -0.019047619047619, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.049515422138510, -0.060643759318929, 0.030629723893614},
    {0.043988591938257, 0.000000000000000, 0.026770604530526, 0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.067193684090529, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.035916534917412, 0.025396825396825, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.050536466099108, -0.040839631858152},
    {0.043988591938257, 0.023184023598102, -0.013385302265263, 0.018929675999998, 0.043373336575490, -0.033596842045265, -0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, 0.026877473636212, -0.022715611199998, 0.003278716060281, 0.017595436775303, -0.002539682539683, -0.012441852661756, -0.010158730158730, 0.001466286397942, 0.007183306983482, 0.007619047619048, 0.000000000000000, 0.000000000000000, 0.024311589644723, 0.000000000000000, -0.020547043427451, -0.031634242810373, 0.000000000000000, 0.015915671401664, 0.024503779114891, 0.026259518075591, 0.000000000000000, -0.009188917168084, -0.014147263468146, -0.015160939829732, -0.012251889557446},
    {-0.032991443953693, -0.017388017698577, 0.010038976698947, -0.014197256999999, -0.007228889429248, 0.005599473674211, 0.061721339984837, -0.003232857633126, -0.035634832254990, -0.050395263067897, 0.000000000000000, 0.000000000000000, 0.034426518632955, 0.000000000000000, -0.026666666666667, 0.009331389496317, 0.000000000000000, 0.015396007178390, -0.005387480237612, -0.019047619047619, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.036906616612102, 0.000000000000000, 0.000000000000000, -0.028587742300706, -0.052519036151182, 0.000000000000000, 0.000000000000000, 0.016505140712837, 0.030321879659465, 0.030629723893614},
    {0.043988591938257, 0.023184023598102, -0.013385302265263, 0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.067193684090529, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.031104631654390, 0.000000000000000, 0.000000000000000, -0.017958267458706, 0.025396825396825, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.043765863459318, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.025268233049554, -0.040839631858152},
    {0.043988591938257, 0.023184023598102, 0.013385302265263, -0.018929675999998, 0.043373336575490, -0.033596842045265, -0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, 0.026877473636212, 0.000000000000000, -0.022951012421970, -0.011730291183535, 0.007619047619048, 0.016589136882341, 0.010158730158730, -0.001466286397942, -0.007183306983482, -0.007619047619048, 0.000000000000000, 0.024161052038524, -0.002701287738303, -0.035734677875883, -0.011415024126362, 0.003954280351297, 0.035588523161670, 0.015915671401664, 0.003062972389361, -0.003751359725084, -0.022830048252724, -0.011230898760992, -0.003536815867036, 0.000721949515702, 0.002041981592908},
    {-0.032991443953693, -0.017388017698577, -0.010038976698947, 0.014197256999999, -0.007228889429248, 0.061594210416319, -0.006857926664982, -0.061424295029390, -0.003959425806110, 0.005599473674211, 0.000000000000000, 0.034073416799997, -0.004918074090422, 0.000000000000000, -0.026666666666667, 0.009331389496317, -0.015238095238095, 0.017595436775303, 0.005387480237612, -0.007619047619048, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.035734677875883, -0.009132019301089, 0.001318093450432, -0.059314205269449, 0.000000000000000, 0.007146935575177, -0.002500906483390, 0.045660096505447, 0.004083963185815, -0.004715754489382, -0.001443899031403, 0.002041981592908},
    {0.043988591938257, 0.023184023598102, 0.013385302265263, -0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.058191437396265, -0.031675406448880, 0.011198947348422, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.029325727958838, -0.010158730158730, 0.002073642110293, 0.010158730158730, -0.021994295969129, 0.017958267458706, -0.007619047619048, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.039542803512966, -0.017684079335182, 0.006125944778723, -0.001250453241695, -0.045660096505447, 0.014293871150353, 0.000000000000000, -0.003609747578508, 0.002041981592908},
    {0.043988591938257, -0.023184023598102, -0.013385302265263, 0.018929675999998, 0.043373336575490, 0.033596842045265, 0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, -0.026877473636212, -0.022715611199998, 0.003278716060281, -0.017595436775303, 0.002539682539683, 0.012441852661756, -0.010158730158730, 0.001466286397942, 0.007183306983482, 0.007619047619048, 0.000000000000000, 0.000000000000000, -0.024311589644723, 0.000000000000000, -0.020547043427451, -0.031634242810373, 0.000000000000000, -0.015915671401664, -0.024503779114891, -0.026259518075591, 0.000000000000000, -0.009188917168084, -0.014147263468146, -0.015160939829732, -0.012251889557446},
    {-0.032991443953693, 0.017388017698577, 0.010038976698947, -0.014197256999999, -0.007228889429248, -0.005599473674211, -0.061721339984837, -0.003232857633126, -0.035634832254990, -0.050395263067897, 0.000000000000000, 0.000000000000000, 0.034426518632955, 0.000000000000000, 0.026666666666667, -0.009331389496317, 0.000000000000000, 0.015396007178390, -0.005387480237612, -0.019047619047619, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.036906616612102, 0.000000000000000, 0.000000000000000, 0.028587742300706, 0.052519036151182, 0.000000000000000, 0.000000000000000, 0.016505140712837, 0.030321879659465, 0.030629723893614},
    {0.043988591938257, -0.023184023598102, -0.013385302265263, 0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.067193684090529, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.031104631654390, 0.000000000000000, 0.000000000000000, -0.017958267458706, 0.025396825396825, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.043765863459318, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.025268233049554, -0.040839631858152},
    {0.043988591938257, -0.023184023598102, 0.013385302265263, -0.018929675999998, 0.043373336575490, 0.033596842045265, 0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, -0.026877473636212, 0.000000000000000, -0.022951012421970, 0.011730291183535, -0.007619047619048, -0.016589136882341, 0.010158730158730, -0.001466286397942, -0.007183306983482, -0.007619047619048, 0.000000000000000, -0.024161052038524, 0.002701287738303, -0.035734677875883, -0.011415024126362, 0.003954280351297, -0.035588523161670, -0.015915671401664, -0.003062972389361, 0.003751359725084, -0.022830048252724, -0.011230898760992, -0.003536815867036, 0.000721949515702, 0.002041981592908},
    {-0.032991443953693, 0.017388017698577, -0.010038976698947, 0.014197256999999, -0.007228889429248, -0.061594210416319, 0.006857926664982, -0.061424295029390, -0.003959425806110, 0.005599473674211, 0.000000000000000, 0.034073416799997, -0.004918074090422, 0.000000000000000, 0.026666666666667, -0.009331389496317, -0.015238095238095, 0.017595436775303, 0.005387480237612, -0.007619047619048, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.035734677875883, -0.009132019301089, 0.001318093450432, 0.059314205269449, 0.000000000000000, -0.007146935575177, 0.002500906483390, 0.045660096505447, 0.004083963185815, -0.004715754489382, -0.001443899031403, 0.002041981592908},
    {0.043988591938257, -0.023184023598102, 0.013385302265263, -0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.058191437396265, -0.031675406448880, 0.011198947348422, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.029325727958838, 0.010158730158730, -0.002073642110293, 0.010158730158730, -0.021994295969129, 0.017958267458706, -0.007619047619048, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.039542803512966, 0.017684079335182, -0.006125944778723, 0.001250453241695, -0.045660096505447, 0.014293871150353, 0.000000000000000, -0.003609747578508, 0.002041981592908},
    {0.043988591938257, 0.000000000000000, -0.026770604530526, -0.018929675999998, 0.043373336575490, 0.033596842045265, 0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, 0.013438736818106, -0.011357805599999, -0.009836148180844, -0.020528009571187, -0.017777777777778, -0.014515494772048, -0.015238095238095, -0.013196577581477, -0.010774960475224, -0.007619047619048, -0.054792115806536, -0.024161052038524, -0.021610301906420, -0.005104953982269, -0.004566009650545, -0.003954280351297, 0.003954280351297, 0.003536815867036, 0.003062972389361, 0.002500906483390, 0.004566009650545, 0.004083963185815, 0.003536815867036, 0.002887798062806, 0.002041981592908},
    {-0.032991443953693, 0.000000000000000, 0.020077953397894, 0.014197256999999, -0.086746673150981, 0.000000000000000, 0.000000000000000, 0.009698572899377, 0.007918851612220, 0.005599473674211, 0.000000000000000, 0.034073416799997, 0.029508444542533, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.015238095238095, -0.013196577581477, -0.010774960475224, -0.007619047619048, 0.082188173709805, 0.000000000000000, 0.000000000000000, -0.010209907964538, -0.009132019301089, -0.007908560702593, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.004566009650545, 0.004083963185815, 0.003536815867036, 0.002887798062806, 0.002041981592908},
    {0.043988591938257, 0.000000000000000, -0.026770604530526, -0.018929675999998, 0.043373336575490, -0.033596842045265, -0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, -0.013438736818106, -0.011357805599999, -0.009836148180844, 0.020528009571187, 0.017777777777778, 0.014515494772048, -0.015238095238095, -0.013196577581477, -0.010774960475224, -0.007619047619048, -0.054792115806536, 0.024161052038524, 0.021610301906420, -0.005104953982269, -0.004566009650545, -0.003954280351297, -0.003954280351297, -0.003536815867036, -0.003062972389361, -0.002500906483390, 0.004566009650545, 0.004083963185815, 0.003536815867036, 0.002887798062806, 0.002041981592908},
    {0.043988591938257, 0.139104141588614, -0.080311813591578, -0.056789027999995, 0.057831115433987, 0.033596842045265, 0.027431706659927, -0.042027149230636, -0.047513109673320, -0.016798421022632, 0.000000000000000, 0.045431222399996, 0.039344592723377, -0.058651455917676, 0.002539682539683, -0.060135621198486, 0.040634920634921, -0.010997147984564, 0.017958267458706, 0.039365079365079, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.041094086854902, -0.010544747603458, 0.000000000000000, -0.053052238005546, -0.024503779114891, 0.017506345383727, 0.000000000000000, 0.036755668672337, 0.023578772446909, 0.000000000000000, -0.012251889557446},
    {0.043988591938257, 0.000000000000000, 0.160623627183156, -0.056789027999995, 0.000000000000000, 0.078392631438951, -0.027431706659927, 0.009698572899377, 0.047513109673320, -0.016798421022632, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.058651455917676, 0.033015873015873, -0.014515494772048, -0.060952380952381, 0.024193725566041, -0.061058109359600, 0.039365079365079, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.053052238005546, -0.032671705486522, 0.008753172691864, 0.000000000000000, -0.055133503008505, 0.014147263468146, 0.015160939829732, -0.012251889557446},
    {0.043988591938257, 0.000000000000000, 0.000000000000000, 0.170367083999984, 0.000000000000000, -0.011198947348422, 0.082295119979782, 0.009698572899377, 0.047513109673320, -0.016798421022632, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.053333333333333, 0.043546484316145, 0.000000000000000, -0.046188021535170, 0.025141574442188, -0.082539682539683, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.057175484601413, -0.026259518075591, 0.000000000000000, 0.000000000000000, -0.049515422138510, -0.015160939829732, 0.030629723893614},
    {0.043988591938257, -0.139104141588614, -0.080311813591578, -0.056789027999995, 0.057831115433987, -0.033596842045265, -0.027431706659927, -0.042027149230636, -0.047513109673320, -0.016798421022632, 0.000000000000000, 0.045431222399996, 0.039344592723377, 0.058651455917676, -0.002539682539683, 0.060135621198486, 0.040634920634921, -0.010997147984564, 0.017958267458706, 0.039365079365079, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.041094086854902, -0.010544747603458, 0.000000000000000, 0.053052238005546, 0.024503779114891, -0.017506345383727, 0.000000000000000, 0.036755668672337, 0.023578772446909, 0.000000000000000, -0.012251889557446},
    {0.043988591938257, 0.000000000000000, 0.160623627183156, -0.056789027999995, 0.000000000000000, -0.078392631438951, 0.027431706659927, 0.009698572899377, 0.047513109673320, -0.016798421022632, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.058651455917676, -0.033015873015873, 0.014515494772048, -0.060952380952381, 0.024193725566041, -0.061058109359600, 0.039365079365079, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.053052238005546, 0.032671705486522, -0.008753172691864, 0.000000000000000, -0.055133503008505, 0.014147263468146, 0.015160939829732, -0.012251889557446},
    {0.043988591938257, 0.000000000000000, 0.000000000000000, 0.170367083999984, 0.000000000000000, 0.011198947348422, -0.082295119979782, 0.009698572899377, 0.047513109673320, -0.016798421022632, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.053333333333333, -0.043546484316145, 0.000000000000000, -0.046188021535170, 0.025141574442188, -0.082539682539683, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.057175484601413, 0.026259518075591, 0.000000000000000, 0.000000000000000, -0.049515422138510, -0.015160939829732, 0.030629723893614},
    {0.043988591938257, -0.139104141588614, -0.080311813591578, -0.056789027999995, -0.043373336575490, 0.044795789393686, -0.054863413319855, 0.048492864496887, 0.000000000000000, -0.016798421022632, 0.080632420908635, 0.022715611199998, -0.003278716060281, -0.005865145591768, 0.030476190476190, 0.045620126426438, -0.010158730158730, 0.027126298361925, 0.043099841900894, 0.039365079365079, 0.000000000000000, 0.000000000000000, 0.072934768934168, 0.000000000000000, 0.020547043427451, 0.031634242810373, 0.000000000000000, -0.005305223800555, -0.008167926371630, -0.008753172691864, 0.000000000000000, -0.009188917168084, -0.014147263468146, -0.015160939829732, -0.012251889557446},
    {0.043988591938257, 0.139104141588614, -0.080311813591578, -0.056789027999995, -0.043373336575490, -0.044795789393686, 0.054863413319855, 0.048492864496887, 0.000000000000000, -0.016798421022632, -0.080632420908635, 0.022715611199998, -0.003278716060281, 0.005865145591768, -0.030476190476190, -0.045620126426438, -0.010158730158730, 0.027126298361925, 0.043099841900894, 0.039365079365079, 0.000000000000000, 0.000000000000000, -0.072934768934168, 0.000000000000000, 0.020547043427451, 0.031634242810373, 0.000000000000000, 0.005305223800555, 0.008167926371630, 0.008753172691864, 0.000000000000000, -0.009188917168084, -0.014147263468146, -0.015160939829732, -0.012251889557446},
    {0.043988591938257, 0.000000000000000, 0.000000000000000, 0.170367083999984, 0.014457778858497, 0.000000000000000, 0.000000000000000, -0.003232857633126, -0.095026219346640, -0.016798421022632, 0.000000000000000, 0.000000000000000, -0.068853037265910, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.015396007178390, -0.050283148884377, -0.082539682539683, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.073813233224204, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.016505140712837, 0.030321879659465, 0.030629723893614},
    {0.043988591938257, -0.139104141588614, -0.080311813591578, -0.056789027999995, -0.043373336575490, -0.044795789393686, 0.054863413319855, -0.009698572899377, 0.031675406448880, 0.039196315719475, 0.080632420908635, 0.000000000000000, 0.022951012421970, 0.052786310325909, 0.010158730158730, -0.012441852661756, 0.060952380952381, 0.016862293576332, -0.007183306983482, -0.013968253968254, 0.000000000000000, 0.072483156115573, -0.008103863214908, 0.035734677875883, 0.011415024126362, -0.003954280351297, -0.011862841053890, -0.005305223800555, -0.001020990796454, 0.001250453241695, -0.022830048252724, -0.011230898760992, -0.003536815867036, 0.000721949515702, 0.002041981592908},
    {0.043988591938257, 0.139104141588614, -0.080311813591578, -0.056789027999995, -0.043373336575490, 0.044795789393686, -0.054863413319855, -0.009698572899377, 0.031675406448880, 0.039196315719475, -0.080632420908635, 0.000000000000000, 0.022951012421970, -0.052786310325909, -0.010158730158730, 0.012441852661756, 0.060952380952381, 0.016862293576332, -0.007183306983482, -0.013968253968254, 0.000000000000000, -0.072483156115573, 0.008103863214908, 0.035734677875883, 0.011415024126362, -0.003954280351297, 0.011862841053890, 0.005305223800555, 0.001020990796454, -0.001250453241695, -0.022830048252724, -0.011230898760992, -0.003536815867036, 0.000721949515702, 0.002041981592908},
    {0.043988591938257, 0.000000000000000, 0.160623627183156, -0.056789027999995, 0.014457778858497, 0.000000000000000, 0.000000000000000, -0.061424295029390, -0.063350812897760, 0.039196315719475, 0.000000000000000, -0.068146833599994, 0.009836148180844, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.091428571428571, 0.028592584759867, 0.014366613966965, -0.013968253968254, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.071469355751766, 0.018264038602179, -0.002636186900864, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.045660096505447, 0.004083963185815, -0.004715754489382, -0.001443899031403, 0.002041981592908},
    {0.351908735506058, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.115662230867974, 0.000000000000000, 0.000000000000000, -0.129314305325033, 0.000000000000000, -0.134387368181059, 0.000000000000000, -0.090862444799991, -0.078689185446754, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.040634920634921, -0.087977183876514, 0.000000000000000, 0.071111111111111, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.082188173709805, 0.021089495206915, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.036755668672337, 0.023578772446909, 0.000000000000000, -0.012251889557446}};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[35][35] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {6.324555320336763, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 11.224972160321826, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {4.582575694955841, 0.000000000000000, 8.366600265340750, -1.183215956619928, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.741657386773943, 0.000000000000000, 0.000000000000000, 8.694826047713658, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.499090833947014, 0.000000000000000, -3.346640106136305, -2.366431913239847, 15.491933384829672, 0.000000000000000, 0.000000000000000, 0.692820323027555, 0.565685424949234, 0.400000000000004, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 4.898979485566357, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.198591479439079, -0.828078671210829, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 4.242640687119294, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.342743312012697, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.600000000000002, 0.000000000000000, 8.763560920082661, -1.549193338482972, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.524704719832531, -1.481312159636089, 0.261861468283188, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.117691453623976, 0.000000000000000, 3.162277660168376, 4.919349550499530, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.690449676496964, -2.418972627259052, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.545584412271572, 0.000000000000000, 0.000000000000000, 7.668115805072326, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.369185117452577, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 11.605769149479945, 0.000000000000000, 0.000000000000000, 0.000000000000000, -4.204589329360407, -3.433032811627965, 0.000000000000000, 0.000000000000000, 0.000000000000000, 19.621416870348579, 0.000000000000000, 0.000000000000000, 0.611677741841194, 0.529728463363971, 0.432521479156780, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {4.531372124791050, 0.000000000000000, 3.545621041711672, -2.507132682112033, 4.787135538781698, 0.000000000000000, 0.000000000000000, -5.566267450754890, -1.048808848170153, 0.741619848709563, 0.000000000000000, 18.803495115840256, -0.603122387046454, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.681835731744163, 0.701283781217661, 0.132137494528684, -0.093435318430231, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {4.052982440952176, 0.000000000000000, -1.585649934344184, 4.484895284651107, 4.281744192888377, 0.000000000000000, 0.000000000000000, 0.191485421551267, -3.752332607858745, -4.311612227462025, 0.000000000000000, 0.000000000000000, 18.880717186629369, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.844371341865036, 1.181873680570560, 1.044638617546684, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 2.595128874940712, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.028530728448152, -0.767649473578732, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.413036132965797, -1.263476110611585, 0.096714742912329, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 2.321153829895992, 0.000000000000000, 0.000000000000000, 0.000000000000000, 3.924283374069717, 5.492852498604746, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 17.304463136556549, -1.730085916627132, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 2.010178182781475, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 8.919280880686024, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.855856488448861, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.966479394838275, 0.000000000000000, 8.124038404635966, -1.641303613296588, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.772850122209173, -2.403122968139589, 0.485504156227613, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.276186062932107, -1.483239697419136, 0.302765035409749, -0.061167774184121, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.653299832284315, 0.000000000000000, 4.152206199905131, 2.936053160837740, 0.000000000000000, 0.000000000000000, 0.000000000000000, 2.632489316217640, 9.825913261807848, -2.822612771377414, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.608186766243898, -3.094871773194651, 0.683876505540239, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.297825058615209, 0.000000000000000, 1.498298354528789, 5.509176018985348, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 6.648039453209381, 4.136768925484860, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.563613642384187, -3.553526561095073, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.876166303929376, 0.000000000000000, 0.000000000000000, 6.228309299857698, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.054152419533832, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.605769149479940, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
    
    static const double dmats1[35][35] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.162277660168382, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.477225575051666, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.958039891549811, 5.612486080160911, -1.080123449734643, -0.763762615825973, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.291287847477921, 7.245688373094718, 4.183300132670376, -0.591607978309961, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.870828693386972, 0.000000000000000, 0.000000000000000, 4.347413023856829, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-2.645751311064596, 0.000000000000000, 9.660917830792956, 0.683130051063973, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.240370349203931, 0.000000000000000, 0.000000000000000, 7.529940238806675, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.749545416973508, 5.796550698475774, -1.673320053068151, -1.183215956619922, 7.745966692414832, -1.200000000000002, -0.979795897113278, 0.346410161513777, 0.282842712474620, 0.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.323790007724447, 2.449489742783177, 2.828427124746186, -0.999999999999999, 9.165151389911676, 7.099295739719538, -0.414039335605420, -2.049390153191923, -0.478091443733762, 0.169030850945701, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.012461179749816, 2.121320343559648, -0.408248290463864, 3.175426480542940, 0.000000000000000, 0.000000000000000, 7.171371656006349, 0.000000000000000, -1.380131118684709, -1.561440116717646, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.799999999999996, -5.692099788303084, 4.381780460041328, -0.774596669241487, 0.000000000000000, 10.998181667894022, 0.962140470884730, 4.762352359916263, -0.740656079818048, 0.130930734141595, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.558845726811993, 2.738612787525836, 1.581138830084188, 2.459674775249766, 0.000000000000000, 0.000000000000000, 9.258200997725497, 0.000000000000000, 5.345224838248487, -1.209486313629523, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.272792206135786, 0.000000000000000, 0.000000000000000, 3.834057902536163, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.184592558726289, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.196152422706642, 0.000000000000000, -3.162277660168376, -2.236067977499797, 0.000000000000000, 0.000000000000000, 0.000000000000000, 13.747727084867533, 0.534522483824853, 0.377964473009235, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-1.800000000000006, 0.000000000000000, 3.651483716701108, -2.840187787218772, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.344267996967357, 1.396594497510348, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.204540768504861, 0.000000000000000, 0.000000000000000, 6.640783086353597, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 8.979977728257461, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.569046515733031, 5.802884574739971, -2.010178182781470, -1.421410624438028, 8.142152225127141, -2.102294664680203, -1.716516405813986, 0.728256234341423, 0.594618725379067, 0.420458932936044, 9.810708435174289, -1.184508853698355, -1.025814758310360, 0.305838870920597, 0.264864231681986, 0.216260739578391, -0.105945692672795, -0.091751661276179, -0.074914917726439, -0.052972846336397, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.265686062395524, 3.070597894314953, 1.772810520855836, -1.253566341056017, 2.393567769390846, 6.303768714031313, -0.908295106229241, -2.783133725377443, -0.524404424085077, 0.370809924354783, 11.124297730643493, 9.401747557920130, -0.301561193523226, -2.427520781138061, -0.794200206656970, 0.114434427054262, 0.840917865872083, 0.350641890608831, 0.066068747264342, -0.046717659215115, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.026491220476093, 2.746426249302386, -0.792824967172092, 2.242447642325556, 2.140872096444191, -0.331662479035542, 6.499230723708749, 0.095742710775634, -1.876166303929367, -2.155806113731009, 0.000000000000000, 0.000000000000000, 9.440358593314681, 0.000000000000000, -1.462494064565349, -2.047065262876631, 0.000000000000000, 0.422185670932518, 0.590936840285279, 0.522319308773341, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.914854215512670, 1.297564437470354, 3.745745886321973, -1.059456926727951, -8.091735937126872, 5.014265364224078, -0.383824736789361, 1.809367161139358, -1.108006575534898, 0.313391585264002, 0.000000000000000, 12.713483120735422, 1.019462903068663, 8.206518066482898, -0.631738055305794, 0.048357371456162, -2.842821248876059, -0.227958835180077, 0.139595707137603, -0.039483628456610, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.712697677155346, 1.160576914947995, 1.340118788520977, 1.895214165917371, 2.533114025595109, 1.962141687034859, 2.746426249302367, -0.566421515598883, 3.171299868688364, -1.821988709389516, 0.000000000000000, 0.000000000000000, 11.169982923823946, 0.000000000000000, 8.652231568278276, -0.865042958313565, 0.000000000000000, -2.497684112518220, -0.998865569685859, 0.441440386136648, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.483239697419136, 1.005089091390739, -0.193429485824666, 3.556157828809254, 0.000000000000000, 0.000000000000000, 4.459640440343011, 0.000000000000000, -0.858258202906998, 2.670272859251875, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 8.427928244224432, 0.000000000000000, 0.000000000000000, -1.621955546837944, -2.293791531904489, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.483239697419139, 7.035623639735146, 4.062019202317986, -0.820651806648293, 0.000000000000000, -6.797058187186557, -2.081165538826733, 5.886425061104590, -1.201561484069793, 0.242752078113807, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.832396974191321, 0.856348838577670, 0.262202212042535, 5.138093031466053, -0.741619848709567, 0.151382517704876, -0.030583887092061, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.326649916142151, -2.696937038151825, 2.076103099952564, 1.468026580418868, 0.000000000000000, 3.039736830714137, -6.382117875081001, 1.316244658108815, 4.912956630903919, -1.411306385688708, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 13.403979508588732, 2.010178182781468, 0.000000000000000, 5.804093383121953, -1.547435886597326, 0.341938252770122, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.148912529307608, 1.297564437470357, 0.749149177264395, 2.754588009492673, 0.000000000000000, 0.000000000000000, 5.757371051840536, 0.000000000000000, 3.324019726604690, 2.068384462742435, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.880408577637445, 0.000000000000000, 0.000000000000000, 6.281806821192093, -1.776763280547537, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.938083151964688, 0.000000000000000, 0.000000000000000, 3.114154649928849, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.527076209766916, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.802884574739970, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-3.425395354310702, 0.000000000000000, 9.380831519646859, 1.895214165917372, 0.000000000000000, 0.000000000000000, 0.000000000000000, -3.398529093593280, -2.774887385102329, -0.560611910581392, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 17.798876369029596, 0.428174419288834, 0.349602949390054, 0.070630461781861, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.829708431025354, 0.000000000000000, -1.498298354528790, 4.237827706911806, 0.000000000000000, 0.000000000000000, 0.000000000000000, 3.799671038392667, -3.545621041711666, -4.074090608432058, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.754974385735917, 1.116765657100816, 0.987090711415297, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-1.326649916142160, 0.000000000000000, 1.730085916627141, -3.180724257574220, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 7.676494735787389, -2.388364652703956, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.507211436849936, 2.051629516620730, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.624807680927199, 0.000000000000000, 0.000000000000000, 5.393874076303640, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.573176812621524, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.050890913907349, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
    
    static const double dmats2[35][35] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.162277660168382, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.825741858350555, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.163977794943227, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.958039891549811, 5.612486080160911, -1.080123449734643, -0.763762615825973, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.291287847477920, 1.449137674618943, 4.183300132670375, -0.591607978309963, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.870828693386973, 7.099295739719541, 0.000000000000000, 4.347413023856832, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.322875655532294, 0.000000000000000, 3.864367132317181, -0.341565025531988, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.080123449734642, 0.000000000000000, 7.099295739719536, 2.509980079602223, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-3.818813079129870, 0.000000000000000, 0.000000000000000, 8.874119674649425, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.749545416973508, 5.796550698475774, -1.673320053068151, -1.183215956619922, 7.745966692414832, -1.200000000000002, -0.979795897113278, 0.346410161513777, 0.282842712474620, 0.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.323790007724448, 2.449489742783177, 2.828427124746187, -1.000000000000000, 1.309307341415952, 7.099295739719535, -0.414039335605417, -2.049390153191922, -0.478091443733760, 0.169030850945704, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.012461179749815, 2.121320343559647, -0.408248290463866, 3.175426480542940, 9.071147352221455, 0.000000000000000, 7.171371656006345, 0.000000000000000, -1.380131118684711, -1.561440116717651, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.800000000000002, 0.632455532033676, 4.381780460041330, -0.774596669241486, 0.000000000000000, 3.142337619398292, -0.106904496764970, 4.762352359916269, -0.740656079818044, 0.130930734141595, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.558845726811985, 0.547722557505167, 1.581138830084187, 2.459674775249766, 0.000000000000000, 9.071147352221452, 1.851640199545098, 0.000000000000000, 5.345224838248483, -1.209486313629525, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.272792206135791, -6.260990336999407, 0.000000000000000, 3.834057902536162, 0.000000000000000, 0.000000000000000, 10.583005244258354, 0.000000000000000, 0.000000000000000, 5.184592558726294, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.039230484541327, 0.000000000000000, 3.162277660168380, -0.447213595499960, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.891883036371798, -0.534522483824851, 0.075592894601842, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.899999999999999, 0.000000000000000, 1.460593486680445, 1.420093893609383, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.071147352221459, 4.937707198786942, -0.698297248755177, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.734846922834951, 0.000000000000000, -6.260990336999408, 2.213594362117866, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.583005244258361, 2.993325909419159, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.715767664977300, 0.000000000000000, 0.000000000000000, -4.695742752749554, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.699606293110040, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.569046515733031, 5.802884574739971, -2.010178182781470, -1.421410624438028, 8.142152225127141, -2.102294664680203, -1.716516405813986, 0.728256234341423, 0.594618725379067, 0.420458932936044, 9.810708435174289, -1.184508853698355, -1.025814758310360, 0.305838870920597, 0.264864231681986, 0.216260739578391, -0.105945692672795, -0.091751661276179, -0.074914917726439, -0.052972846336397, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.265686062395523, 3.070597894314953, 1.772810520855836, -1.253566341056015, 2.393567769390844, 6.303768714031308, -0.908295106229251, -2.783133725377447, -0.524404424085075, 0.370809924354782, 1.236033081182612, 9.401747557920130, -0.301561193523227, -2.427520781138061, -0.794200206656965, 0.114434427054267, 0.840917865872083, 0.350641890608831, 0.066068747264341, -0.046717659215115, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.026491220476093, 2.746426249302386, -0.792824967172092, 2.242447642325554, 2.140872096444191, -0.331662479035535, 6.499230723708759, 0.095742710775636, -1.876166303929371, -2.155806113731009, 11.055415967851333, 0.000000000000000, 9.440358593314683, 0.000000000000000, -1.462494064565354, -2.047065262876635, 0.000000000000000, 0.422185670932518, 0.590936840285280, 0.522319308773342, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.914854215512672, 1.297564437470353, 3.745745886321968, -1.059456926727952, 0.404586796856342, 5.014265364224076, -0.383824736789365, 1.809367161139363, -1.108006575534902, 0.313391585264002, 0.000000000000000, 2.825218471274540, -0.050973145153431, 8.206518066482895, -0.631738055305791, 0.048357371456165, -2.842821248876056, -0.227958835180081, 0.139595707137603, -0.039483628456611, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.712697677155347, 1.160576914947996, 1.340118788520979, 1.895214165917370, 0.361873432227876, 1.962141687034859, 2.746426249302372, -0.566421515598886, 3.171299868688365, -1.821988709389514, 0.000000000000000, 11.055415967851330, 1.595711846260562, 0.000000000000000, 8.652231568278275, -0.865042958313566, 0.000000000000000, -2.497684112518219, -0.998865569685860, 0.441440386136646, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.483239697419131, 1.005089091390737, -0.193429485824662, 3.556157828809257, -8.461572802128117, 0.000000000000000, 4.459640440343009, 0.000000000000000, -0.858258202906995, 2.670272859251867, 0.000000000000000, 0.000000000000000, 12.437342963832750, 0.000000000000000, 0.000000000000000, 8.427928244224431, 0.000000000000000, 0.000000000000000, -1.621955546837942, -2.293791531904488, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.483239697419136, 0.335029697130246, 4.062019202317983, -0.820651806648294, 0.000000000000000, 1.699264546796648, -0.099103120896509, 5.886425061104586, -1.201561484069795, 0.242752078113807, 0.000000000000000, 0.000000000000000, 0.000000000000000, 4.944132324730440, -0.214087209644420, 0.012485819621072, 5.138093031466055, -0.741619848709568, 0.151382517704875, -0.030583887092060, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.326649916142156, 0.299659670905758, 2.076103099952565, 1.468026580418870, 0.000000000000000, 0.868496237346903, 0.709124208342340, 1.316244658108822, 4.912956630903921, -1.411306385688704, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.055415967851332, 3.829708431025350, -0.223353131420166, 0.000000000000000, 5.804093383121950, -1.547435886597325, 0.341938252770121, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.148912529307608, 0.259512887494072, 0.749149177264394, 2.754588009492672, 0.000000000000000, -8.461572802128114, 1.151474210368108, 0.000000000000000, 3.324019726604690, 2.068384462742431, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.437342963832746, 2.176081715527490, 0.000000000000000, 0.000000000000000, 6.281806821192093, -1.776763280547537, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.938083151964686, 7.628089872441248, 0.000000000000000, 3.114154649928849, 0.000000000000000, 0.000000000000000, -7.521398046336091, 0.000000000000000, 0.000000000000000, 5.527076209766916, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.214106244380279, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.802884574739970, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.856348838577682, 0.000000000000000, 2.680237577041961, -0.473803541479346, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.097793640389942, -0.792824967172092, 0.140152977645351, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 7.910611719568709, -0.642261628933259, 0.099886556968585, -0.017657615445466, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.765941686205071, 0.000000000000000, 1.498298354528792, 0.847565541382361, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.628430445025436, 3.545621041711668, -0.814818121686413, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.055415967851335, 7.180703308172534, -1.116765657100814, 0.197418142283060, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.663324958071075, 0.000000000000000, 0.692034366650854, 1.590362128787115, 0.000000000000000, 0.000000000000000, 0.000000000000000, -8.461572802128124, 3.070597894314957, 1.194182326351979, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.437342963832750, 5.802884574739974, -1.025814758310361, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.541602560309069, 0.000000000000000, 7.628089872441253, 1.797958025434547, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -7.521398046336106, 3.191058937540505, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.214106244380288, 3.350296971302448, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-5.361591803435492, 0.000000000000000, 0.000000000000000, 8.899438184514796, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -5.264978632435276, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.583123951777001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      derivatives[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[35][35] = \
    {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[35][35] = \
    {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 35; t++)
      {
        for (unsigned int u = 0; u < 35; u++)
        {
          dmats[t][u] = 0.000000000000000;
          if (t == u)
          {
          dmats[t][u] = 1.000000000000000;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.000000000000000;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            for (unsigned int tu = 0; tu < 35; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            for (unsigned int tu = 0; tu < 35; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 2)
        {
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            for (unsigned int tu = 0; tu < 35; tu++)
            {
              dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 35; s++)
      {
        for (unsigned int t = 0; t < 35; t++)
        {
          derivatives[r] += coefficients0[dof][s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] combinations[r];
    }// end loop over 'r'
    delete [] combinations;
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 35; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.750000000000000*x[2][0] + 0.250000000000000*x[3][0];
      y[1] = 0.750000000000000*x[2][1] + 0.250000000000000*x[3][1];
      y[2] = 0.750000000000000*x[2][2] + 0.250000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.500000000000000*x[2][0] + 0.500000000000000*x[3][0];
      y[1] = 0.500000000000000*x[2][1] + 0.500000000000000*x[3][1];
      y[2] = 0.500000000000000*x[2][2] + 0.500000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.250000000000000*x[2][0] + 0.750000000000000*x[3][0];
      y[1] = 0.250000000000000*x[2][1] + 0.750000000000000*x[3][1];
      y[2] = 0.250000000000000*x[2][2] + 0.750000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.750000000000000*x[1][0] + 0.250000000000000*x[3][0];
      y[1] = 0.750000000000000*x[1][1] + 0.250000000000000*x[3][1];
      y[2] = 0.750000000000000*x[1][2] + 0.250000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.500000000000000*x[1][0] + 0.500000000000000*x[3][0];
      y[1] = 0.500000000000000*x[1][1] + 0.500000000000000*x[3][1];
      y[2] = 0.500000000000000*x[1][2] + 0.500000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.250000000000000*x[1][0] + 0.750000000000000*x[3][0];
      y[1] = 0.250000000000000*x[1][1] + 0.750000000000000*x[3][1];
      y[2] = 0.250000000000000*x[1][2] + 0.750000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.750000000000000*x[1][0] + 0.250000000000000*x[2][0];
      y[1] = 0.750000000000000*x[1][1] + 0.250000000000000*x[2][1];
      y[2] = 0.750000000000000*x[1][2] + 0.250000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.500000000000000*x[1][0] + 0.500000000000000*x[2][0];
      y[1] = 0.500000000000000*x[1][1] + 0.500000000000000*x[2][1];
      y[2] = 0.500000000000000*x[1][2] + 0.500000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.250000000000000*x[1][0] + 0.750000000000000*x[2][0];
      y[1] = 0.250000000000000*x[1][1] + 0.750000000000000*x[2][1];
      y[2] = 0.250000000000000*x[1][2] + 0.750000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.750000000000000*x[0][0] + 0.250000000000000*x[3][0];
      y[1] = 0.750000000000000*x[0][1] + 0.250000000000000*x[3][1];
      y[2] = 0.750000000000000*x[0][2] + 0.250000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[3][0];
      y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[3][1];
      y[2] = 0.500000000000000*x[0][2] + 0.500000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 15:
      {
        y[0] = 0.250000000000000*x[0][0] + 0.750000000000000*x[3][0];
      y[1] = 0.250000000000000*x[0][1] + 0.750000000000000*x[3][1];
      y[2] = 0.250000000000000*x[0][2] + 0.750000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 16:
      {
        y[0] = 0.750000000000000*x[0][0] + 0.250000000000000*x[2][0];
      y[1] = 0.750000000000000*x[0][1] + 0.250000000000000*x[2][1];
      y[2] = 0.750000000000000*x[0][2] + 0.250000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 17:
      {
        y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[2][0];
      y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[2][1];
      y[2] = 0.500000000000000*x[0][2] + 0.500000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 18:
      {
        y[0] = 0.250000000000000*x[0][0] + 0.750000000000000*x[2][0];
      y[1] = 0.250000000000000*x[0][1] + 0.750000000000000*x[2][1];
      y[2] = 0.250000000000000*x[0][2] + 0.750000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 19:
      {
        y[0] = 0.750000000000000*x[0][0] + 0.250000000000000*x[1][0];
      y[1] = 0.750000000000000*x[0][1] + 0.250000000000000*x[1][1];
      y[2] = 0.750000000000000*x[0][2] + 0.250000000000000*x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 20:
      {
        y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[1][0];
      y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[1][1];
      y[2] = 0.500000000000000*x[0][2] + 0.500000000000000*x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 21:
      {
        y[0] = 0.250000000000000*x[0][0] + 0.750000000000000*x[1][0];
      y[1] = 0.250000000000000*x[0][1] + 0.750000000000000*x[1][1];
      y[2] = 0.250000000000000*x[0][2] + 0.750000000000000*x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 22:
      {
        y[0] = 0.500000000000000*x[1][0] + 0.250000000000000*x[2][0] + 0.250000000000000*x[3][0];
      y[1] = 0.500000000000000*x[1][1] + 0.250000000000000*x[2][1] + 0.250000000000000*x[3][1];
      y[2] = 0.500000000000000*x[1][2] + 0.250000000000000*x[2][2] + 0.250000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 23:
      {
        y[0] = 0.250000000000000*x[1][0] + 0.500000000000000*x[2][0] + 0.250000000000000*x[3][0];
      y[1] = 0.250000000000000*x[1][1] + 0.500000000000000*x[2][1] + 0.250000000000000*x[3][1];
      y[2] = 0.250000000000000*x[1][2] + 0.500000000000000*x[2][2] + 0.250000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 24:
      {
        y[0] = 0.250000000000000*x[1][0] + 0.250000000000000*x[2][0] + 0.500000000000000*x[3][0];
      y[1] = 0.250000000000000*x[1][1] + 0.250000000000000*x[2][1] + 0.500000000000000*x[3][1];
      y[2] = 0.250000000000000*x[1][2] + 0.250000000000000*x[2][2] + 0.500000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 25:
      {
        y[0] = 0.500000000000000*x[0][0] + 0.250000000000000*x[2][0] + 0.250000000000000*x[3][0];
      y[1] = 0.500000000000000*x[0][1] + 0.250000000000000*x[2][1] + 0.250000000000000*x[3][1];
      y[2] = 0.500000000000000*x[0][2] + 0.250000000000000*x[2][2] + 0.250000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 26:
      {
        y[0] = 0.250000000000000*x[0][0] + 0.500000000000000*x[2][0] + 0.250000000000000*x[3][0];
      y[1] = 0.250000000000000*x[0][1] + 0.500000000000000*x[2][1] + 0.250000000000000*x[3][1];
      y[2] = 0.250000000000000*x[0][2] + 0.500000000000000*x[2][2] + 0.250000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 27:
      {
        y[0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[2][0] + 0.500000000000000*x[3][0];
      y[1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[2][1] + 0.500000000000000*x[3][1];
      y[2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[2][2] + 0.500000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 28:
      {
        y[0] = 0.500000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.250000000000000*x[3][0];
      y[1] = 0.500000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.250000000000000*x[3][1];
      y[2] = 0.500000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.250000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 29:
      {
        y[0] = 0.250000000000000*x[0][0] + 0.500000000000000*x[1][0] + 0.250000000000000*x[3][0];
      y[1] = 0.250000000000000*x[0][1] + 0.500000000000000*x[1][1] + 0.250000000000000*x[3][1];
      y[2] = 0.250000000000000*x[0][2] + 0.500000000000000*x[1][2] + 0.250000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 30:
      {
        y[0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.500000000000000*x[3][0];
      y[1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.500000000000000*x[3][1];
      y[2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.500000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 31:
      {
        y[0] = 0.500000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.250000000000000*x[2][0];
      y[1] = 0.500000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.250000000000000*x[2][1];
      y[2] = 0.500000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.250000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 32:
      {
        y[0] = 0.250000000000000*x[0][0] + 0.500000000000000*x[1][0] + 0.250000000000000*x[2][0];
      y[1] = 0.250000000000000*x[0][1] + 0.500000000000000*x[1][1] + 0.250000000000000*x[2][1];
      y[2] = 0.250000000000000*x[0][2] + 0.500000000000000*x[1][2] + 0.250000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 33:
      {
        y[0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.500000000000000*x[2][0];
      y[1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.500000000000000*x[2][1];
      y[2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.500000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 34:
      {
        y[0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.250000000000000*x[2][0] + 0.250000000000000*x[3][0];
      y[1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.250000000000000*x[2][1] + 0.250000000000000*x[3][1];
      y[2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.250000000000000*x[2][2] + 0.250000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.000000000000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.750000000000000*x[2][0] + 0.250000000000000*x[3][0];
    y[1] = 0.750000000000000*x[2][1] + 0.250000000000000*x[3][1];
    y[2] = 0.750000000000000*x[2][2] + 0.250000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.500000000000000*x[2][0] + 0.500000000000000*x[3][0];
    y[1] = 0.500000000000000*x[2][1] + 0.500000000000000*x[3][1];
    y[2] = 0.500000000000000*x[2][2] + 0.500000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.250000000000000*x[2][0] + 0.750000000000000*x[3][0];
    y[1] = 0.250000000000000*x[2][1] + 0.750000000000000*x[3][1];
    y[2] = 0.250000000000000*x[2][2] + 0.750000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.750000000000000*x[1][0] + 0.250000000000000*x[3][0];
    y[1] = 0.750000000000000*x[1][1] + 0.250000000000000*x[3][1];
    y[2] = 0.750000000000000*x[1][2] + 0.250000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.500000000000000*x[1][0] + 0.500000000000000*x[3][0];
    y[1] = 0.500000000000000*x[1][1] + 0.500000000000000*x[3][1];
    y[2] = 0.500000000000000*x[1][2] + 0.500000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.250000000000000*x[1][0] + 0.750000000000000*x[3][0];
    y[1] = 0.250000000000000*x[1][1] + 0.750000000000000*x[3][1];
    y[2] = 0.250000000000000*x[1][2] + 0.750000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.750000000000000*x[1][0] + 0.250000000000000*x[2][0];
    y[1] = 0.750000000000000*x[1][1] + 0.250000000000000*x[2][1];
    y[2] = 0.750000000000000*x[1][2] + 0.250000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.500000000000000*x[1][0] + 0.500000000000000*x[2][0];
    y[1] = 0.500000000000000*x[1][1] + 0.500000000000000*x[2][1];
    y[2] = 0.500000000000000*x[1][2] + 0.500000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.250000000000000*x[1][0] + 0.750000000000000*x[2][0];
    y[1] = 0.250000000000000*x[1][1] + 0.750000000000000*x[2][1];
    y[2] = 0.250000000000000*x[1][2] + 0.750000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.750000000000000*x[0][0] + 0.250000000000000*x[3][0];
    y[1] = 0.750000000000000*x[0][1] + 0.250000000000000*x[3][1];
    y[2] = 0.750000000000000*x[0][2] + 0.250000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[3][0];
    y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[3][1];
    y[2] = 0.500000000000000*x[0][2] + 0.500000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
    y[0] = 0.250000000000000*x[0][0] + 0.750000000000000*x[3][0];
    y[1] = 0.250000000000000*x[0][1] + 0.750000000000000*x[3][1];
    y[2] = 0.250000000000000*x[0][2] + 0.750000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[15] = vals[0];
    y[0] = 0.750000000000000*x[0][0] + 0.250000000000000*x[2][0];
    y[1] = 0.750000000000000*x[0][1] + 0.250000000000000*x[2][1];
    y[2] = 0.750000000000000*x[0][2] + 0.250000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[16] = vals[0];
    y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[2][0];
    y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[2][1];
    y[2] = 0.500000000000000*x[0][2] + 0.500000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[17] = vals[0];
    y[0] = 0.250000000000000*x[0][0] + 0.750000000000000*x[2][0];
    y[1] = 0.250000000000000*x[0][1] + 0.750000000000000*x[2][1];
    y[2] = 0.250000000000000*x[0][2] + 0.750000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[18] = vals[0];
    y[0] = 0.750000000000000*x[0][0] + 0.250000000000000*x[1][0];
    y[1] = 0.750000000000000*x[0][1] + 0.250000000000000*x[1][1];
    y[2] = 0.750000000000000*x[0][2] + 0.250000000000000*x[1][2];
    f.evaluate(vals, y, c);
    values[19] = vals[0];
    y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[1][0];
    y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[1][1];
    y[2] = 0.500000000000000*x[0][2] + 0.500000000000000*x[1][2];
    f.evaluate(vals, y, c);
    values[20] = vals[0];
    y[0] = 0.250000000000000*x[0][0] + 0.750000000000000*x[1][0];
    y[1] = 0.250000000000000*x[0][1] + 0.750000000000000*x[1][1];
    y[2] = 0.250000000000000*x[0][2] + 0.750000000000000*x[1][2];
    f.evaluate(vals, y, c);
    values[21] = vals[0];
    y[0] = 0.500000000000000*x[1][0] + 0.250000000000000*x[2][0] + 0.250000000000000*x[3][0];
    y[1] = 0.500000000000000*x[1][1] + 0.250000000000000*x[2][1] + 0.250000000000000*x[3][1];
    y[2] = 0.500000000000000*x[1][2] + 0.250000000000000*x[2][2] + 0.250000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[22] = vals[0];
    y[0] = 0.250000000000000*x[1][0] + 0.500000000000000*x[2][0] + 0.250000000000000*x[3][0];
    y[1] = 0.250000000000000*x[1][1] + 0.500000000000000*x[2][1] + 0.250000000000000*x[3][1];
    y[2] = 0.250000000000000*x[1][2] + 0.500000000000000*x[2][2] + 0.250000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[23] = vals[0];
    y[0] = 0.250000000000000*x[1][0] + 0.250000000000000*x[2][0] + 0.500000000000000*x[3][0];
    y[1] = 0.250000000000000*x[1][1] + 0.250000000000000*x[2][1] + 0.500000000000000*x[3][1];
    y[2] = 0.250000000000000*x[1][2] + 0.250000000000000*x[2][2] + 0.500000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[24] = vals[0];
    y[0] = 0.500000000000000*x[0][0] + 0.250000000000000*x[2][0] + 0.250000000000000*x[3][0];
    y[1] = 0.500000000000000*x[0][1] + 0.250000000000000*x[2][1] + 0.250000000000000*x[3][1];
    y[2] = 0.500000000000000*x[0][2] + 0.250000000000000*x[2][2] + 0.250000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[25] = vals[0];
    y[0] = 0.250000000000000*x[0][0] + 0.500000000000000*x[2][0] + 0.250000000000000*x[3][0];
    y[1] = 0.250000000000000*x[0][1] + 0.500000000000000*x[2][1] + 0.250000000000000*x[3][1];
    y[2] = 0.250000000000000*x[0][2] + 0.500000000000000*x[2][2] + 0.250000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[26] = vals[0];
    y[0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[2][0] + 0.500000000000000*x[3][0];
    y[1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[2][1] + 0.500000000000000*x[3][1];
    y[2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[2][2] + 0.500000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[27] = vals[0];
    y[0] = 0.500000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.250000000000000*x[3][0];
    y[1] = 0.500000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.250000000000000*x[3][1];
    y[2] = 0.500000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.250000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[28] = vals[0];
    y[0] = 0.250000000000000*x[0][0] + 0.500000000000000*x[1][0] + 0.250000000000000*x[3][0];
    y[1] = 0.250000000000000*x[0][1] + 0.500000000000000*x[1][1] + 0.250000000000000*x[3][1];
    y[2] = 0.250000000000000*x[0][2] + 0.500000000000000*x[1][2] + 0.250000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[29] = vals[0];
    y[0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.500000000000000*x[3][0];
    y[1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.500000000000000*x[3][1];
    y[2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.500000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[30] = vals[0];
    y[0] = 0.500000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.250000000000000*x[2][0];
    y[1] = 0.500000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.250000000000000*x[2][1];
    y[2] = 0.500000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.250000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[31] = vals[0];
    y[0] = 0.250000000000000*x[0][0] + 0.500000000000000*x[1][0] + 0.250000000000000*x[2][0];
    y[1] = 0.250000000000000*x[0][1] + 0.500000000000000*x[1][1] + 0.250000000000000*x[2][1];
    y[2] = 0.250000000000000*x[0][2] + 0.500000000000000*x[1][2] + 0.250000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[32] = vals[0];
    y[0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.500000000000000*x[2][0];
    y[1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.500000000000000*x[2][1];
    y[2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.500000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[33] = vals[0];
    y[0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.250000000000000*x[2][0] + 0.250000000000000*x[3][0];
    y[1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.250000000000000*x[2][1] + 0.250000000000000*x[3][1];
    y[2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.250000000000000*x[2][2] + 0.250000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[34] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class poisson3d_4_dof_map_0: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  poisson3d_4_dof_map_0() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~poisson3d_4_dof_map_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 4)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    case 3:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 3.000000000000000*m.num_entities[1] + 3.000000000000000*m.num_entities[2] + m.num_entities[3];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 35;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 35;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 15;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    case 3:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
    dofs[4] = offset + 3*c.entity_indices[1][0];
    dofs[5] = offset + 3*c.entity_indices[1][0] + 1;
    dofs[6] = offset + 3*c.entity_indices[1][0] + 2;
    dofs[7] = offset + 3*c.entity_indices[1][1];
    dofs[8] = offset + 3*c.entity_indices[1][1] + 1;
    dofs[9] = offset + 3*c.entity_indices[1][1] + 2;
    dofs[10] = offset + 3*c.entity_indices[1][2];
    dofs[11] = offset + 3*c.entity_indices[1][2] + 1;
    dofs[12] = offset + 3*c.entity_indices[1][2] + 2;
    dofs[13] = offset + 3*c.entity_indices[1][3];
    dofs[14] = offset + 3*c.entity_indices[1][3] + 1;
    dofs[15] = offset + 3*c.entity_indices[1][3] + 2;
    dofs[16] = offset + 3*c.entity_indices[1][4];
    dofs[17] = offset + 3*c.entity_indices[1][4] + 1;
    dofs[18] = offset + 3*c.entity_indices[1][4] + 2;
    dofs[19] = offset + 3*c.entity_indices[1][5];
    dofs[20] = offset + 3*c.entity_indices[1][5] + 1;
    dofs[21] = offset + 3*c.entity_indices[1][5] + 2;
    offset += 3*m.num_entities[1];
    dofs[22] = offset + 3*c.entity_indices[2][0];
    dofs[23] = offset + 3*c.entity_indices[2][0] + 1;
    dofs[24] = offset + 3*c.entity_indices[2][0] + 2;
    dofs[25] = offset + 3*c.entity_indices[2][1];
    dofs[26] = offset + 3*c.entity_indices[2][1] + 1;
    dofs[27] = offset + 3*c.entity_indices[2][1] + 2;
    dofs[28] = offset + 3*c.entity_indices[2][2];
    dofs[29] = offset + 3*c.entity_indices[2][2] + 1;
    dofs[30] = offset + 3*c.entity_indices[2][2] + 2;
    dofs[31] = offset + 3*c.entity_indices[2][3];
    dofs[32] = offset + 3*c.entity_indices[2][3] + 1;
    dofs[33] = offset + 3*c.entity_indices[2][3] + 2;
    offset += 3*m.num_entities[2];
    dofs[34] = offset + c.entity_indices[3][0];
    offset += m.num_entities[3];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 7;
      dofs[7] = 8;
      dofs[8] = 9;
      dofs[9] = 10;
      dofs[10] = 11;
      dofs[11] = 12;
      dofs[12] = 22;
      dofs[13] = 23;
      dofs[14] = 24;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 13;
      dofs[7] = 14;
      dofs[8] = 15;
      dofs[9] = 16;
      dofs[10] = 17;
      dofs[11] = 18;
      dofs[12] = 25;
      dofs[13] = 26;
      dofs[14] = 27;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 7;
      dofs[4] = 8;
      dofs[5] = 9;
      dofs[6] = 13;
      dofs[7] = 14;
      dofs[8] = 15;
      dofs[9] = 19;
      dofs[10] = 20;
      dofs[11] = 21;
      dofs[12] = 28;
      dofs[13] = 29;
      dofs[14] = 30;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 10;
      dofs[4] = 11;
      dofs[5] = 12;
      dofs[6] = 16;
      dofs[7] = 17;
      dofs[8] = 18;
      dofs[9] = 19;
      dofs[10] = 20;
      dofs[11] = 21;
      dofs[12] = 31;
      dofs[13] = 32;
      dofs[14] = 33;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      throw std::runtime_error("i is larger than number of entities (5)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 4;
        dofs[1] = 5;
        dofs[2] = 6;
          break;
        }
      case 1:
        {
          dofs[0] = 7;
        dofs[1] = 8;
        dofs[2] = 9;
          break;
        }
      case 2:
        {
          dofs[0] = 10;
        dofs[1] = 11;
        dofs[2] = 12;
          break;
        }
      case 3:
        {
          dofs[0] = 13;
        dofs[1] = 14;
        dofs[2] = 15;
          break;
        }
      case 4:
        {
          dofs[0] = 16;
        dofs[1] = 17;
        dofs[2] = 18;
          break;
        }
      case 5:
        {
          dofs[0] = 19;
        dofs[1] = 20;
        dofs[2] = 21;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 22;
        dofs[1] = 23;
        dofs[2] = 24;
          break;
        }
      case 1:
        {
          dofs[0] = 25;
        dofs[1] = 26;
        dofs[2] = 27;
          break;
        }
      case 2:
        {
          dofs[0] = 28;
        dofs[1] = 29;
        dofs[2] = 30;
          break;
        }
      case 3:
        {
          dofs[0] = 31;
        dofs[1] = 32;
        dofs[2] = 33;
          break;
        }
      }
      
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 34;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[0][2] = x[0][2];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[1][2] = x[1][2];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[2][2] = x[2][2];
    coordinates[3][0] = x[3][0];
    coordinates[3][1] = x[3][1];
    coordinates[3][2] = x[3][2];
    coordinates[4][0] = 0.750000000000000*x[2][0] + 0.250000000000000*x[3][0];
    coordinates[4][1] = 0.750000000000000*x[2][1] + 0.250000000000000*x[3][1];
    coordinates[4][2] = 0.750000000000000*x[2][2] + 0.250000000000000*x[3][2];
    coordinates[5][0] = 0.500000000000000*x[2][0] + 0.500000000000000*x[3][0];
    coordinates[5][1] = 0.500000000000000*x[2][1] + 0.500000000000000*x[3][1];
    coordinates[5][2] = 0.500000000000000*x[2][2] + 0.500000000000000*x[3][2];
    coordinates[6][0] = 0.250000000000000*x[2][0] + 0.750000000000000*x[3][0];
    coordinates[6][1] = 0.250000000000000*x[2][1] + 0.750000000000000*x[3][1];
    coordinates[6][2] = 0.250000000000000*x[2][2] + 0.750000000000000*x[3][2];
    coordinates[7][0] = 0.750000000000000*x[1][0] + 0.250000000000000*x[3][0];
    coordinates[7][1] = 0.750000000000000*x[1][1] + 0.250000000000000*x[3][1];
    coordinates[7][2] = 0.750000000000000*x[1][2] + 0.250000000000000*x[3][2];
    coordinates[8][0] = 0.500000000000000*x[1][0] + 0.500000000000000*x[3][0];
    coordinates[8][1] = 0.500000000000000*x[1][1] + 0.500000000000000*x[3][1];
    coordinates[8][2] = 0.500000000000000*x[1][2] + 0.500000000000000*x[3][2];
    coordinates[9][0] = 0.250000000000000*x[1][0] + 0.750000000000000*x[3][0];
    coordinates[9][1] = 0.250000000000000*x[1][1] + 0.750000000000000*x[3][1];
    coordinates[9][2] = 0.250000000000000*x[1][2] + 0.750000000000000*x[3][2];
    coordinates[10][0] = 0.750000000000000*x[1][0] + 0.250000000000000*x[2][0];
    coordinates[10][1] = 0.750000000000000*x[1][1] + 0.250000000000000*x[2][1];
    coordinates[10][2] = 0.750000000000000*x[1][2] + 0.250000000000000*x[2][2];
    coordinates[11][0] = 0.500000000000000*x[1][0] + 0.500000000000000*x[2][0];
    coordinates[11][1] = 0.500000000000000*x[1][1] + 0.500000000000000*x[2][1];
    coordinates[11][2] = 0.500000000000000*x[1][2] + 0.500000000000000*x[2][2];
    coordinates[12][0] = 0.250000000000000*x[1][0] + 0.750000000000000*x[2][0];
    coordinates[12][1] = 0.250000000000000*x[1][1] + 0.750000000000000*x[2][1];
    coordinates[12][2] = 0.250000000000000*x[1][2] + 0.750000000000000*x[2][2];
    coordinates[13][0] = 0.750000000000000*x[0][0] + 0.250000000000000*x[3][0];
    coordinates[13][1] = 0.750000000000000*x[0][1] + 0.250000000000000*x[3][1];
    coordinates[13][2] = 0.750000000000000*x[0][2] + 0.250000000000000*x[3][2];
    coordinates[14][0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[3][0];
    coordinates[14][1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[3][1];
    coordinates[14][2] = 0.500000000000000*x[0][2] + 0.500000000000000*x[3][2];
    coordinates[15][0] = 0.250000000000000*x[0][0] + 0.750000000000000*x[3][0];
    coordinates[15][1] = 0.250000000000000*x[0][1] + 0.750000000000000*x[3][1];
    coordinates[15][2] = 0.250000000000000*x[0][2] + 0.750000000000000*x[3][2];
    coordinates[16][0] = 0.750000000000000*x[0][0] + 0.250000000000000*x[2][0];
    coordinates[16][1] = 0.750000000000000*x[0][1] + 0.250000000000000*x[2][1];
    coordinates[16][2] = 0.750000000000000*x[0][2] + 0.250000000000000*x[2][2];
    coordinates[17][0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[2][0];
    coordinates[17][1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[2][1];
    coordinates[17][2] = 0.500000000000000*x[0][2] + 0.500000000000000*x[2][2];
    coordinates[18][0] = 0.250000000000000*x[0][0] + 0.750000000000000*x[2][0];
    coordinates[18][1] = 0.250000000000000*x[0][1] + 0.750000000000000*x[2][1];
    coordinates[18][2] = 0.250000000000000*x[0][2] + 0.750000000000000*x[2][2];
    coordinates[19][0] = 0.750000000000000*x[0][0] + 0.250000000000000*x[1][0];
    coordinates[19][1] = 0.750000000000000*x[0][1] + 0.250000000000000*x[1][1];
    coordinates[19][2] = 0.750000000000000*x[0][2] + 0.250000000000000*x[1][2];
    coordinates[20][0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[1][0];
    coordinates[20][1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[1][1];
    coordinates[20][2] = 0.500000000000000*x[0][2] + 0.500000000000000*x[1][2];
    coordinates[21][0] = 0.250000000000000*x[0][0] + 0.750000000000000*x[1][0];
    coordinates[21][1] = 0.250000000000000*x[0][1] + 0.750000000000000*x[1][1];
    coordinates[21][2] = 0.250000000000000*x[0][2] + 0.750000000000000*x[1][2];
    coordinates[22][0] = 0.500000000000000*x[1][0] + 0.250000000000000*x[2][0] + 0.250000000000000*x[3][0];
    coordinates[22][1] = 0.500000000000000*x[1][1] + 0.250000000000000*x[2][1] + 0.250000000000000*x[3][1];
    coordinates[22][2] = 0.500000000000000*x[1][2] + 0.250000000000000*x[2][2] + 0.250000000000000*x[3][2];
    coordinates[23][0] = 0.250000000000000*x[1][0] + 0.500000000000000*x[2][0] + 0.250000000000000*x[3][0];
    coordinates[23][1] = 0.250000000000000*x[1][1] + 0.500000000000000*x[2][1] + 0.250000000000000*x[3][1];
    coordinates[23][2] = 0.250000000000000*x[1][2] + 0.500000000000000*x[2][2] + 0.250000000000000*x[3][2];
    coordinates[24][0] = 0.250000000000000*x[1][0] + 0.250000000000000*x[2][0] + 0.500000000000000*x[3][0];
    coordinates[24][1] = 0.250000000000000*x[1][1] + 0.250000000000000*x[2][1] + 0.500000000000000*x[3][1];
    coordinates[24][2] = 0.250000000000000*x[1][2] + 0.250000000000000*x[2][2] + 0.500000000000000*x[3][2];
    coordinates[25][0] = 0.500000000000000*x[0][0] + 0.250000000000000*x[2][0] + 0.250000000000000*x[3][0];
    coordinates[25][1] = 0.500000000000000*x[0][1] + 0.250000000000000*x[2][1] + 0.250000000000000*x[3][1];
    coordinates[25][2] = 0.500000000000000*x[0][2] + 0.250000000000000*x[2][2] + 0.250000000000000*x[3][2];
    coordinates[26][0] = 0.250000000000000*x[0][0] + 0.500000000000000*x[2][0] + 0.250000000000000*x[3][0];
    coordinates[26][1] = 0.250000000000000*x[0][1] + 0.500000000000000*x[2][1] + 0.250000000000000*x[3][1];
    coordinates[26][2] = 0.250000000000000*x[0][2] + 0.500000000000000*x[2][2] + 0.250000000000000*x[3][2];
    coordinates[27][0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[2][0] + 0.500000000000000*x[3][0];
    coordinates[27][1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[2][1] + 0.500000000000000*x[3][1];
    coordinates[27][2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[2][2] + 0.500000000000000*x[3][2];
    coordinates[28][0] = 0.500000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.250000000000000*x[3][0];
    coordinates[28][1] = 0.500000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.250000000000000*x[3][1];
    coordinates[28][2] = 0.500000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.250000000000000*x[3][2];
    coordinates[29][0] = 0.250000000000000*x[0][0] + 0.500000000000000*x[1][0] + 0.250000000000000*x[3][0];
    coordinates[29][1] = 0.250000000000000*x[0][1] + 0.500000000000000*x[1][1] + 0.250000000000000*x[3][1];
    coordinates[29][2] = 0.250000000000000*x[0][2] + 0.500000000000000*x[1][2] + 0.250000000000000*x[3][2];
    coordinates[30][0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.500000000000000*x[3][0];
    coordinates[30][1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.500000000000000*x[3][1];
    coordinates[30][2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.500000000000000*x[3][2];
    coordinates[31][0] = 0.500000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.250000000000000*x[2][0];
    coordinates[31][1] = 0.500000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.250000000000000*x[2][1];
    coordinates[31][2] = 0.500000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.250000000000000*x[2][2];
    coordinates[32][0] = 0.250000000000000*x[0][0] + 0.500000000000000*x[1][0] + 0.250000000000000*x[2][0];
    coordinates[32][1] = 0.250000000000000*x[0][1] + 0.500000000000000*x[1][1] + 0.250000000000000*x[2][1];
    coordinates[32][2] = 0.250000000000000*x[0][2] + 0.500000000000000*x[1][2] + 0.250000000000000*x[2][2];
    coordinates[33][0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.500000000000000*x[2][0];
    coordinates[33][1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.500000000000000*x[2][1];
    coordinates[33][2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.500000000000000*x[2][2];
    coordinates[34][0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.250000000000000*x[2][0] + 0.250000000000000*x[3][0];
    coordinates[34][1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.250000000000000*x[2][1] + 0.250000000000000*x[3][1];
    coordinates[34][2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.250000000000000*x[2][2] + 0.250000000000000*x[3][2];
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 0;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class poisson3d_4_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  poisson3d_4_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_4_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      32
    // Number of operations (multiply-add pairs) for geometry tensor:    27
    // Number of operations (multiply-add pairs) for tensor contraction: 6311
    // Total number of operations (multiply-add pairs):                  6370
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K_00*K_00 + K_01*K_01 + K_02*K_02);
    const double G0_0_1 = det*(K_00*K_10 + K_01*K_11 + K_02*K_12);
    const double G0_0_2 = det*(K_00*K_20 + K_01*K_21 + K_02*K_22);
    const double G0_1_0 = det*(K_10*K_00 + K_11*K_01 + K_12*K_02);
    const double G0_1_1 = det*(K_10*K_10 + K_11*K_11 + K_12*K_12);
    const double G0_1_2 = det*(K_10*K_20 + K_11*K_21 + K_12*K_22);
    const double G0_2_0 = det*(K_20*K_00 + K_21*K_01 + K_22*K_02);
    const double G0_2_1 = det*(K_20*K_10 + K_21*K_11 + K_22*K_12);
    const double G0_2_2 = det*(K_20*K_20 + K_21*K_21 + K_22*K_22);
    
    // Compute element tensor
    A[0] = 0.037918871252205*G0_0_0 + 0.037918871252205*G0_0_1 + 0.037918871252205*G0_0_2 + 0.037918871252205*G0_1_0 + 0.037918871252204*G0_1_1 + 0.037918871252204*G0_1_2 + 0.037918871252205*G0_2_0 + 0.037918871252204*G0_2_1 + 0.037918871252205*G0_2_2;
    A[1] = 0.005114638447972*G0_0_0 + 0.005114638447972*G0_1_0 + 0.005114638447972*G0_2_0;
    A[2] = 0.005114638447972*G0_0_1 + 0.005114638447972*G0_1_1 + 0.005114638447972*G0_2_1;
    A[3] = 0.005114638447972*G0_0_2 + 0.005114638447972*G0_1_2 + 0.005114638447972*G0_2_2;
    A[4] = 0.007760141093474*G0_0_1 + 0.007760141093474*G0_0_2 + 0.007760141093474*G0_1_1 + 0.007760141093474*G0_1_2 + 0.007760141093474*G0_2_1 + 0.007760141093474*G0_2_2;
    A[5] = 0.005114638447972*G0_0_1 + 0.005114638447972*G0_0_2 + 0.005114638447972*G0_1_1 + 0.005114638447972*G0_1_2 + 0.005114638447972*G0_2_1 + 0.005114638447972*G0_2_2;
    A[6] = 0.007760141093474*G0_0_1 + 0.007760141093474*G0_0_2 + 0.007760141093474*G0_1_1 + 0.007760141093474*G0_1_2 + 0.007760141093474*G0_2_1 + 0.007760141093474*G0_2_2;
    A[7] = 0.007760141093474*G0_0_0 + 0.007760141093474*G0_0_2 + 0.007760141093474*G0_1_0 + 0.007760141093474*G0_1_2 + 0.007760141093474*G0_2_0 + 0.007760141093474*G0_2_2;
    A[8] = 0.005114638447972*G0_0_0 + 0.005114638447972*G0_0_2 + 0.005114638447972*G0_1_0 + 0.005114638447972*G0_1_2 + 0.005114638447972*G0_2_0 + 0.005114638447972*G0_2_2;
    A[9] = 0.007760141093474*G0_0_0 + 0.007760141093474*G0_0_2 + 0.007760141093474*G0_1_0 + 0.007760141093474*G0_1_2 + 0.007760141093474*G0_2_0 + 0.007760141093474*G0_2_2;
    A[10] = 0.007760141093474*G0_0_0 + 0.007760141093474*G0_0_1 + 0.007760141093474*G0_1_0 + 0.007760141093474*G0_1_1 + 0.007760141093474*G0_2_0 + 0.007760141093474*G0_2_1;
    A[11] = 0.005114638447972*G0_0_0 + 0.005114638447972*G0_0_1 + 0.005114638447972*G0_1_0 + 0.005114638447972*G0_1_1 + 0.005114638447972*G0_2_0 + 0.005114638447972*G0_2_1;
    A[12] = 0.007760141093474*G0_0_0 + 0.007760141093474*G0_0_1 + 0.007760141093474*G0_1_0 + 0.007760141093474*G0_1_1 + 0.007760141093474*G0_2_0 + 0.007760141093474*G0_2_1;
    A[13] = -0.024691358024691*G0_0_0 - 0.024691358024691*G0_0_1 - 0.070546737213404*G0_0_2 - 0.024691358024691*G0_1_0 - 0.024691358024691*G0_1_1 - 0.070546737213404*G0_1_2 - 0.024691358024691*G0_2_0 - 0.024691358024691*G0_2_1 - 0.070546737213404*G0_2_2;
    A[14] = 0.020282186948854*G0_0_0 + 0.020282186948854*G0_0_1 + 0.052910052910053*G0_0_2 + 0.020282186948854*G0_1_0 + 0.020282186948854*G0_1_1 + 0.052910052910053*G0_1_2 + 0.020282186948854*G0_2_0 + 0.020282186948854*G0_2_1 + 0.052910052910053*G0_2_2;
    A[15] = -0.007760141093474*G0_0_0 - 0.007760141093474*G0_0_1 - 0.025396825396825*G0_0_2 - 0.007760141093474*G0_1_0 - 0.007760141093474*G0_1_1 - 0.025396825396825*G0_1_2 - 0.007760141093474*G0_2_0 - 0.007760141093474*G0_2_1 - 0.025396825396825*G0_2_2;
    A[16] = -0.024691358024691*G0_0_0 - 0.070546737213404*G0_0_1 - 0.024691358024691*G0_0_2 - 0.024691358024691*G0_1_0 - 0.070546737213404*G0_1_1 - 0.024691358024691*G0_1_2 - 0.024691358024691*G0_2_0 - 0.070546737213404*G0_2_1 - 0.024691358024691*G0_2_2;
    A[17] = 0.020282186948854*G0_0_0 + 0.052910052910053*G0_0_1 + 0.020282186948854*G0_0_2 + 0.020282186948854*G0_1_0 + 0.052910052910053*G0_1_1 + 0.020282186948854*G0_1_2 + 0.020282186948854*G0_2_0 + 0.052910052910053*G0_2_1 + 0.020282186948854*G0_2_2;
    A[18] = -0.007760141093474*G0_0_0 - 0.025396825396825*G0_0_1 - 0.007760141093474*G0_0_2 - 0.007760141093474*G0_1_0 - 0.025396825396825*G0_1_1 - 0.007760141093474*G0_1_2 - 0.007760141093474*G0_2_0 - 0.025396825396825*G0_2_1 - 0.007760141093474*G0_2_2;
    A[19] = -0.070546737213404*G0_0_0 - 0.024691358024691*G0_0_1 - 0.024691358024691*G0_0_2 - 0.070546737213404*G0_1_0 - 0.024691358024691*G0_1_1 - 0.024691358024691*G0_1_2 - 0.070546737213404*G0_2_0 - 0.024691358024691*G0_2_1 - 0.024691358024691*G0_2_2;
    A[20] = 0.052910052910053*G0_0_0 + 0.020282186948854*G0_0_1 + 0.020282186948854*G0_0_2 + 0.052910052910053*G0_1_0 + 0.020282186948854*G0_1_1 + 0.020282186948854*G0_1_2 + 0.052910052910053*G0_2_0 + 0.020282186948854*G0_2_1 + 0.020282186948854*G0_2_2;
    A[21] = -0.025396825396825*G0_0_0 - 0.007760141093474*G0_0_1 - 0.007760141093474*G0_0_2 - 0.025396825396825*G0_1_0 - 0.007760141093474*G0_1_1 - 0.007760141093474*G0_1_2 - 0.025396825396825*G0_2_0 - 0.007760141093474*G0_2_1 - 0.007760141093474*G0_2_2;
    A[22] = 0.018342151675485*G0_0_0 + 0.018342151675485*G0_0_1 + 0.018342151675485*G0_0_2 + 0.018342151675485*G0_1_0 + 0.018342151675485*G0_1_1 + 0.018342151675485*G0_1_2 + 0.018342151675485*G0_2_0 + 0.018342151675485*G0_2_1 + 0.018342151675485*G0_2_2;
    A[23] = 0.018342151675485*G0_0_0 + 0.018342151675485*G0_0_1 + 0.018342151675485*G0_0_2 + 0.018342151675485*G0_1_0 + 0.018342151675485*G0_1_1 + 0.018342151675485*G0_1_2 + 0.018342151675485*G0_2_0 + 0.018342151675485*G0_2_1 + 0.018342151675485*G0_2_2;
    A[24] = 0.018342151675485*G0_0_0 + 0.018342151675485*G0_0_1 + 0.018342151675485*G0_0_2 + 0.018342151675485*G0_1_0 + 0.018342151675485*G0_1_1 + 0.018342151675485*G0_1_2 + 0.018342151675485*G0_2_0 + 0.018342151675485*G0_2_1 + 0.018342151675485*G0_2_2;
    A[25] = 0.049382716049383*G0_0_0 + 0.042328042328042*G0_0_1 + 0.042328042328042*G0_0_2 + 0.049382716049383*G0_1_0 + 0.042328042328042*G0_1_1 + 0.042328042328042*G0_1_2 + 0.049382716049383*G0_2_0 + 0.042328042328042*G0_2_1 + 0.042328042328042*G0_2_2;
    A[26] = -0.018342151675485*G0_0_0 - 0.025396825396826*G0_0_1 - 0.025396825396825*G0_0_2 - 0.018342151675485*G0_1_0 - 0.025396825396825*G0_1_1 - 0.025396825396825*G0_1_2 - 0.018342151675485*G0_2_0 - 0.025396825396825*G0_2_1 - 0.025396825396826*G0_2_2;
    A[27] = -0.018342151675485*G0_0_0 - 0.025396825396825*G0_0_1 - 0.025396825396825*G0_0_2 - 0.018342151675485*G0_1_0 - 0.025396825396825*G0_1_1 - 0.025396825396825*G0_1_2 - 0.018342151675485*G0_2_0 - 0.025396825396825*G0_2_1 - 0.025396825396825*G0_2_2;
    A[28] = 0.042328042328042*G0_0_0 + 0.049382716049383*G0_0_1 + 0.042328042328042*G0_0_2 + 0.042328042328042*G0_1_0 + 0.049382716049383*G0_1_1 + 0.042328042328042*G0_1_2 + 0.042328042328042*G0_2_0 + 0.049382716049383*G0_2_1 + 0.042328042328042*G0_2_2;
    A[29] = -0.025396825396825*G0_0_0 - 0.018342151675485*G0_0_1 - 0.025396825396825*G0_0_2 - 0.025396825396825*G0_1_0 - 0.018342151675485*G0_1_1 - 0.025396825396825*G0_1_2 - 0.025396825396825*G0_2_0 - 0.018342151675485*G0_2_1 - 0.025396825396825*G0_2_2;
    A[30] = -0.025396825396825*G0_0_0 - 0.018342151675485*G0_0_1 - 0.025396825396825*G0_0_2 - 0.025396825396825*G0_1_0 - 0.018342151675485*G0_1_1 - 0.025396825396825*G0_1_2 - 0.025396825396825*G0_2_0 - 0.018342151675485*G0_2_1 - 0.025396825396825*G0_2_2;
    A[31] = 0.042328042328042*G0_0_0 + 0.042328042328042*G0_0_1 + 0.049382716049383*G0_0_2 + 0.042328042328042*G0_1_0 + 0.042328042328042*G0_1_1 + 0.049382716049383*G0_1_2 + 0.042328042328042*G0_2_0 + 0.042328042328042*G0_2_1 + 0.049382716049383*G0_2_2;
    A[32] = -0.025396825396825*G0_0_0 - 0.025396825396825*G0_0_1 - 0.018342151675485*G0_0_2 - 0.025396825396825*G0_1_0 - 0.025396825396825*G0_1_1 - 0.018342151675485*G0_1_2 - 0.025396825396825*G0_2_0 - 0.025396825396825*G0_2_1 - 0.018342151675485*G0_2_2;
    A[33] = -0.025396825396825*G0_0_0 - 0.025396825396825*G0_0_1 - 0.018342151675485*G0_0_2 - 0.025396825396825*G0_1_0 - 0.025396825396825*G0_1_1 - 0.018342151675485*G0_1_2 - 0.025396825396825*G0_2_0 - 0.025396825396825*G0_2_1 - 0.018342151675485*G0_2_2;
    A[34] = -0.067724867724868*G0_0_0 - 0.067724867724868*G0_0_1 - 0.067724867724868*G0_0_2 - 0.067724867724868*G0_1_0 - 0.067724867724868*G0_1_1 - 0.067724867724868*G0_1_2 - 0.067724867724868*G0_2_0 - 0.067724867724868*G0_2_1 - 0.067724867724868*G0_2_2;
    A[35] = 0.005114638447972*G0_0_0 + 0.005114638447972*G0_0_1 + 0.005114638447972*G0_0_2;
    A[36] = 0.037918871252204*G0_0_0;
    A[37] = -0.005114638447972*G0_0_1;
    A[38] = -0.005114638447972*G0_0_2;
    A[39] = -0.007760141093474*G0_0_1 - 0.007760141093474*G0_0_2;
    A[40] = -0.005114638447972*G0_0_1 - 0.005114638447972*G0_0_2;
    A[41] = -0.007760141093474*G0_0_1 - 0.007760141093474*G0_0_2;
    A[42] = -0.024691358024691*G0_0_0 + 0.045855379188712*G0_0_2;
    A[43] = 0.020282186948854*G0_0_0 - 0.032627865961199*G0_0_2;
    A[44] = -0.007760141093474*G0_0_0 + 0.017636684303351*G0_0_2;
    A[45] = -0.024691358024691*G0_0_0 + 0.045855379188712*G0_0_1;
    A[46] = 0.020282186948854*G0_0_0 - 0.032627865961199*G0_0_1;
    A[47] = -0.007760141093474*G0_0_0 + 0.017636684303351*G0_0_1;
    A[48] = 0.007760141093474*G0_0_0 + 0.007760141093474*G0_0_1;
    A[49] = 0.005114638447972*G0_0_0 + 0.005114638447972*G0_0_1;
    A[50] = 0.007760141093474*G0_0_0 + 0.007760141093474*G0_0_1;
    A[51] = 0.007760141093474*G0_0_0 + 0.007760141093474*G0_0_2;
    A[52] = 0.005114638447972*G0_0_0 + 0.005114638447972*G0_0_2;
    A[53] = 0.007760141093474*G0_0_0 + 0.007760141093474*G0_0_2;
    A[54] = -0.025396825396825*G0_0_0 - 0.017636684303351*G0_0_1 - 0.017636684303351*G0_0_2;
    A[55] = 0.052910052910053*G0_0_0 + 0.032627865961199*G0_0_1 + 0.032627865961199*G0_0_2;
    A[56] = -0.070546737213404*G0_0_0 - 0.045855379188712*G0_0_1 - 0.045855379188712*G0_0_2;
    A[57] = 0.049382716049383*G0_0_0 + 0.007054673721340*G0_0_1 + 0.007054673721340*G0_0_2;
    A[58] = -0.018342151675485*G0_0_0 + 0.007054673721340*G0_0_1 + 0.007054673721340*G0_0_2;
    A[59] = -0.018342151675485*G0_0_0 + 0.007054673721341*G0_0_1 + 0.007054673721341*G0_0_2;
    A[60] = 0.018342151675485*G0_0_0;
    A[61] = 0.018342151675485*G0_0_0;
    A[62] = 0.018342151675485*G0_0_0;
    A[63] = -0.025396825396825*G0_0_0 - 0.007054673721340*G0_0_1;
    A[64] = 0.042328042328042*G0_0_0 - 0.007054673721340*G0_0_1;
    A[65] = -0.025396825396826*G0_0_0 - 0.007054673721341*G0_0_1;
    A[66] = -0.025396825396825*G0_0_0 - 0.007054673721340*G0_0_2;
    A[67] = 0.042328042328042*G0_0_0 - 0.007054673721340*G0_0_2;
    A[68] = -0.025396825396825*G0_0_0 - 0.007054673721340*G0_0_2;
    A[69] = -0.067724867724868*G0_0_0;
    A[70] = 0.005114638447972*G0_1_0 + 0.005114638447972*G0_1_1 + 0.005114638447972*G0_1_2;
    A[71] = -0.005114638447972*G0_1_0;
    A[72] = 0.037918871252205*G0_1_1;
    A[73] = -0.005114638447972*G0_1_2;
    A[74] = -0.024691358024691*G0_1_1 + 0.045855379188713*G0_1_2;
    A[75] = 0.020282186948854*G0_1_1 - 0.032627865961199*G0_1_2;
    A[76] = -0.007760141093474*G0_1_1 + 0.017636684303351*G0_1_2;
    A[77] = -0.007760141093474*G0_1_0 - 0.007760141093474*G0_1_2;
    A[78] = -0.005114638447972*G0_1_0 - 0.005114638447972*G0_1_2;
    A[79] = -0.007760141093474*G0_1_0 - 0.007760141093474*G0_1_2;
    A[80] = 0.017636684303351*G0_1_0 - 0.007760141093474*G0_1_1;
    A[81] = -0.032627865961199*G0_1_0 + 0.020282186948854*G0_1_1;
    A[82] = 0.045855379188713*G0_1_0 - 0.024691358024691*G0_1_1;
    A[83] = 0.007760141093474*G0_1_0 + 0.007760141093474*G0_1_1;
    A[84] = 0.005114638447972*G0_1_0 + 0.005114638447972*G0_1_1;
    A[85] = 0.007760141093474*G0_1_0 + 0.007760141093474*G0_1_1;
    A[86] = -0.017636684303351*G0_1_0 - 0.025396825396825*G0_1_1 - 0.017636684303351*G0_1_2;
    A[87] = 0.032627865961199*G0_1_0 + 0.052910052910053*G0_1_1 + 0.032627865961199*G0_1_2;
    A[88] = -0.045855379188713*G0_1_0 - 0.070546737213404*G0_1_1 - 0.045855379188713*G0_1_2;
    A[89] = 0.007760141093474*G0_1_1 + 0.007760141093474*G0_1_2;
    A[90] = 0.005114638447972*G0_1_1 + 0.005114638447972*G0_1_2;
    A[91] = 0.007760141093474*G0_1_1 + 0.007760141093474*G0_1_2;
    A[92] = 0.007054673721340*G0_1_0 - 0.018342151675485*G0_1_1 + 0.007054673721340*G0_1_2;
    A[93] = 0.007054673721340*G0_1_0 + 0.049382716049383*G0_1_1 + 0.007054673721340*G0_1_2;
    A[94] = 0.007054673721340*G0_1_0 - 0.018342151675485*G0_1_1 + 0.007054673721340*G0_1_2;
    A[95] = -0.007054673721340*G0_1_0 - 0.025396825396825*G0_1_1;
    A[96] = -0.007054673721340*G0_1_0 + 0.042328042328042*G0_1_1;
    A[97] = -0.007054673721340*G0_1_0 - 0.025396825396825*G0_1_1;
    A[98] = 0.018342151675485*G0_1_1;
    A[99] = 0.018342151675485*G0_1_1;
    A[100] = 0.018342151675485*G0_1_1;
    A[101] = -0.025396825396825*G0_1_1 - 0.007054673721340*G0_1_2;
    A[102] = -0.025396825396825*G0_1_1 - 0.007054673721340*G0_1_2;
    A[103] = 0.042328042328042*G0_1_1 - 0.007054673721340*G0_1_2;
    A[104] = -0.067724867724868*G0_1_1;
    A[105] = 0.005114638447972*G0_2_0 + 0.005114638447972*G0_2_1 + 0.005114638447972*G0_2_2;
    A[106] = -0.005114638447972*G0_2_0;
    A[107] = -0.005114638447972*G0_2_1;
    A[108] = 0.037918871252205*G0_2_2;
    A[109] = 0.017636684303351*G0_2_1 - 0.007760141093474*G0_2_2;
    A[110] = -0.032627865961199*G0_2_1 + 0.020282186948854*G0_2_2;
    A[111] = 0.045855379188712*G0_2_1 - 0.024691358024691*G0_2_2;
    A[112] = 0.017636684303351*G0_2_0 - 0.007760141093474*G0_2_2;
    A[113] = -0.032627865961199*G0_2_0 + 0.020282186948854*G0_2_2;
    A[114] = 0.045855379188712*G0_2_0 - 0.024691358024691*G0_2_2;
    A[115] = -0.007760141093474*G0_2_0 - 0.007760141093474*G0_2_1;
    A[116] = -0.005114638447972*G0_2_0 - 0.005114638447972*G0_2_1;
    A[117] = -0.007760141093474*G0_2_0 - 0.007760141093474*G0_2_1;
    A[118] = -0.017636684303351*G0_2_0 - 0.017636684303351*G0_2_1 - 0.025396825396825*G0_2_2;
    A[119] = 0.032627865961199*G0_2_0 + 0.032627865961199*G0_2_1 + 0.052910052910053*G0_2_2;
    A[120] = -0.045855379188712*G0_2_0 - 0.045855379188712*G0_2_1 - 0.070546737213404*G0_2_2;
    A[121] = 0.007760141093474*G0_2_0 + 0.007760141093474*G0_2_2;
    A[122] = 0.005114638447972*G0_2_0 + 0.005114638447972*G0_2_2;
    A[123] = 0.007760141093474*G0_2_0 + 0.007760141093474*G0_2_2;
    A[124] = 0.007760141093474*G0_2_1 + 0.007760141093474*G0_2_2;
    A[125] = 0.005114638447972*G0_2_1 + 0.005114638447972*G0_2_2;
    A[126] = 0.007760141093474*G0_2_1 + 0.007760141093474*G0_2_2;
    A[127] = 0.007054673721340*G0_2_0 + 0.007054673721340*G0_2_1 - 0.018342151675485*G0_2_2;
    A[128] = 0.007054673721340*G0_2_0 + 0.007054673721340*G0_2_1 - 0.018342151675485*G0_2_2;
    A[129] = 0.007054673721340*G0_2_0 + 0.007054673721340*G0_2_1 + 0.049382716049383*G0_2_2;
    A[130] = -0.007054673721340*G0_2_0 - 0.025396825396825*G0_2_2;
    A[131] = -0.007054673721340*G0_2_0 - 0.025396825396825*G0_2_2;
    A[132] = -0.007054673721340*G0_2_0 + 0.042328042328042*G0_2_2;
    A[133] = -0.007054673721340*G0_2_1 - 0.025396825396825*G0_2_2;
    A[134] = -0.007054673721340*G0_2_1 - 0.025396825396825*G0_2_2;
    A[135] = -0.007054673721340*G0_2_1 + 0.042328042328042*G0_2_2;
    A[136] = 0.018342151675485*G0_2_2;
    A[137] = 0.018342151675485*G0_2_2;
    A[138] = 0.018342151675485*G0_2_2;
    A[139] = -0.067724867724867*G0_2_2;
    A[140] = 0.007760141093474*G0_1_0 + 0.007760141093474*G0_1_1 + 0.007760141093474*G0_1_2 + 0.007760141093474*G0_2_0 + 0.007760141093474*G0_2_1 + 0.007760141093474*G0_2_2;
    A[141] = -0.007760141093474*G0_1_0 - 0.007760141093474*G0_2_0;
    A[142] = -0.024691358024691*G0_1_1 + 0.045855379188713*G0_2_1;
    A[143] = 0.017636684303351*G0_1_2 - 0.007760141093474*G0_2_2;
    A[144] = 0.203174603174603*G0_1_1 + 0.079012345679012*G0_1_2 + 0.079012345679012*G0_2_1 + 0.158024691358025*G0_2_2;
    A[145] = -0.118518518518518*G0_1_1 + 0.042328042328042*G0_1_2 - 0.031040564373898*G0_2_1 - 0.090299823633157*G0_2_2;
    A[146] = 0.045149911816578*G0_1_1 - 0.033862433862434*G0_1_2 + 0.011287477954145*G0_2_1 + 0.045149911816578*G0_2_2;
    A[147] = 0.022574955908289*G0_1_0 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_2;
    A[148] = 0.016931216931217*G0_1_0 + 0.014109347442681*G0_1_2 + 0.002821869488536*G0_2_0 + 0.002821869488536*G0_2_2;
    A[149] = 0.045149911816578*G0_1_0 + 0.033862433862434*G0_1_2 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_2;
    A[150] = 0.033862433862434*G0_1_0 + 0.011287477954145*G0_1_1 + 0.045149911816579*G0_2_0 + 0.011287477954145*G0_2_1;
    A[151] = -0.059259259259259*G0_1_0 - 0.042328042328042*G0_1_1 - 0.090299823633157*G0_2_0 - 0.031040564373898*G0_2_1;
    A[152] = 0.079012345679012*G0_1_0 + 0.101587301587302*G0_1_1 + 0.158024691358025*G0_2_0 + 0.079012345679012*G0_2_1;
    A[153] = -0.022574955908289*G0_1_0 - 0.022574955908289*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_1;
    A[154] = -0.016931216931217*G0_1_0 - 0.016931216931217*G0_1_1 - 0.002821869488536*G0_1_2 - 0.002821869488536*G0_2_0 - 0.002821869488536*G0_2_1;
    A[155] = -0.045149911816578*G0_1_0 - 0.045149911816578*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_1;
    A[156] = -0.033862433862434*G0_1_0 - 0.022574955908289*G0_1_1 - 0.033862433862434*G0_1_2 - 0.045149911816579*G0_2_0 - 0.033862433862434*G0_2_1 - 0.045149911816579*G0_2_2;
    A[157] = 0.059259259259259*G0_1_0 + 0.016931216931217*G0_1_1 + 0.059259259259259*G0_1_2 + 0.090299823633157*G0_2_0 + 0.059259259259259*G0_2_1 + 0.090299823633157*G0_2_2;
    A[158] = -0.079012345679012*G0_1_0 + 0.022574955908289*G0_1_1 - 0.079012345679012*G0_1_2 - 0.158024691358025*G0_2_0 - 0.079012345679013*G0_2_1 - 0.158024691358025*G0_2_2;
    A[159] = -0.011287477954145*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1 - 0.011287477954145*G0_2_2;
    A[160] = -0.002821869488536*G0_1_1 - 0.002821869488536*G0_1_2 - 0.002821869488536*G0_2_1 - 0.002821869488536*G0_2_2;
    A[161] = -0.011287477954145*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1 - 0.011287477954145*G0_2_2;
    A[162] = -0.067724867724868*G0_1_0 + 0.022574955908289*G0_1_1 - 0.033862433862434*G0_1_2 - 0.022574955908289*G0_2_0 + 0.011287477954145*G0_2_1 - 0.022574955908289*G0_2_2;
    A[163] = 0.203174603174603*G0_1_0 - 0.067724867724868*G0_1_1 + 0.101587301587301*G0_1_2 + 0.112874779541446*G0_2_0 + 0.011287477954145*G0_2_1 + 0.112874779541446*G0_2_2;
    A[164] = -0.067724867724868*G0_1_0 + 0.067724867724868*G0_1_1 - 0.033862433862434*G0_1_2 - 0.022574955908289*G0_2_0 + 0.011287477954145*G0_2_1 - 0.022574955908289*G0_2_2;
    A[165] = 0.067724867724868*G0_1_0 + 0.090299823633157*G0_1_1 + 0.033862433862434*G0_1_2 + 0.022574955908289*G0_2_0 + 0.033862433862434*G0_2_1;
    A[166] = -0.203174603174603*G0_1_0 - 0.270899470899471*G0_1_1 - 0.101587301587302*G0_1_2 - 0.112874779541446*G0_2_0 - 0.101587301587302*G0_2_1;
    A[167] = 0.067724867724868*G0_1_0 + 0.135449735449735*G0_1_1 + 0.033862433862434*G0_1_2 + 0.022574955908289*G0_2_0 + 0.033862433862434*G0_2_1;
    A[168] = -0.022574955908289*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1;
    A[169] = -0.022574955908289*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1;
    A[170] = -0.067724867724868*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1;
    A[171] = 0.045149911816579*G0_1_1 + 0.033862433862434*G0_1_2 + 0.033862433862434*G0_2_1 + 0.022574955908289*G0_2_2;
    A[172] = 0.045149911816578*G0_1_1 + 0.033862433862434*G0_1_2 + 0.033862433862434*G0_2_1 + 0.022574955908289*G0_2_2;
    A[173] = -0.135449735449735*G0_1_1 - 0.101587301587301*G0_1_2 - 0.101587301587302*G0_2_1 - 0.112874779541446*G0_2_2;
    A[174] = 0.090299823633157*G0_1_1;
    A[175] = 0.005114638447972*G0_1_0 + 0.005114638447972*G0_1_1 + 0.005114638447972*G0_1_2 + 0.005114638447972*G0_2_0 + 0.005114638447972*G0_2_1 + 0.005114638447972*G0_2_2;
    A[176] = -0.005114638447972*G0_1_0 - 0.005114638447972*G0_2_0;
    A[177] = 0.020282186948854*G0_1_1 - 0.032627865961199*G0_2_1;
    A[178] = -0.032627865961199*G0_1_2 + 0.020282186948854*G0_2_2;
    A[179] = -0.118518518518518*G0_1_1 - 0.031040564373898*G0_1_2 + 0.042328042328042*G0_2_1 - 0.090299823633157*G0_2_2;
    A[180] = 0.249735449735449*G0_1_1 + 0.082539682539683*G0_1_2 + 0.082539682539683*G0_2_1 + 0.249735449735450*G0_2_2;
    A[181] = -0.090299823633157*G0_1_1 + 0.042328042328042*G0_1_2 - 0.031040564373898*G0_2_1 - 0.118518518518519*G0_2_2;
    A[182] = 0.016931216931217*G0_1_0 + 0.002821869488536*G0_1_2 + 0.014109347442681*G0_2_0 + 0.002821869488536*G0_2_2;
    A[183] = -0.021164021164021*G0_1_0 - 0.010582010582010*G0_1_2 - 0.010582010582011*G0_2_0 - 0.013403880070547*G0_2_2;
    A[184] = -0.090299823633157*G0_1_0 - 0.059259259259259*G0_1_2 - 0.031040564373898*G0_2_0 - 0.042328042328042*G0_2_2;
    A[185] = 0.014109347442681*G0_1_0 + 0.002821869488536*G0_1_1 + 0.016931216931217*G0_2_0 + 0.002821869488536*G0_2_1;
    A[186] = -0.010582010582010*G0_1_0 - 0.013403880070547*G0_1_1 - 0.021164021164021*G0_2_0 - 0.010582010582011*G0_2_1;
    A[187] = -0.031040564373898*G0_1_0 - 0.042328042328042*G0_1_1 - 0.090299823633157*G0_2_0 - 0.059259259259259*G0_2_1;
    A[188] = -0.016931216931217*G0_1_0 - 0.016931216931217*G0_1_1 - 0.014109347442681*G0_1_2 - 0.014109347442681*G0_2_0 - 0.014109347442681*G0_2_1 - 0.011287477954145*G0_2_2;
    A[189] = 0.021164021164021*G0_1_0 + 0.021164021164021*G0_1_1 + 0.010582010582011*G0_1_2 + 0.010582010582011*G0_2_0 + 0.010582010582011*G0_2_1 - 0.002821869488536*G0_2_2;
    A[190] = 0.090299823633157*G0_1_0 + 0.090299823633157*G0_1_1 + 0.031040564373898*G0_1_2 + 0.031040564373898*G0_2_0 + 0.031040564373898*G0_2_1 - 0.011287477954145*G0_2_2;
    A[191] = -0.014109347442681*G0_1_0 - 0.011287477954145*G0_1_1 - 0.014109347442681*G0_1_2 - 0.016931216931217*G0_2_0 - 0.014109347442681*G0_2_1 - 0.016931216931217*G0_2_2;
    A[192] = 0.010582010582011*G0_1_0 - 0.002821869488536*G0_1_1 + 0.010582010582011*G0_1_2 + 0.021164021164021*G0_2_0 + 0.010582010582010*G0_2_1 + 0.021164021164021*G0_2_2;
    A[193] = 0.031040564373898*G0_1_0 - 0.011287477954145*G0_1_1 + 0.031040564373898*G0_1_2 + 0.090299823633157*G0_2_0 + 0.031040564373898*G0_2_1 + 0.090299823633157*G0_2_2;
    A[194] = -0.002821869488536*G0_1_1 - 0.002821869488536*G0_1_2 - 0.002821869488536*G0_2_1 - 0.002821869488536*G0_2_2;
    A[195] = -0.009171075837743*G0_1_1 - 0.009171075837743*G0_1_2 - 0.009171075837743*G0_2_1 - 0.009171075837743*G0_2_2;
    A[196] = -0.002821869488536*G0_1_1 - 0.002821869488536*G0_1_2 - 0.002821869488536*G0_2_1 - 0.002821869488536*G0_2_2;
    A[197] = -0.084656084656085*G0_1_0 - 0.016931216931217*G0_1_1 - 0.019753086419753*G0_1_2 - 0.084656084656085*G0_2_0 - 0.019753086419753*G0_2_1 - 0.016931216931217*G0_2_2;
    A[198] = 0.050793650793651*G0_1_0 + 0.118518518518518*G0_1_1 - 0.042328042328042*G0_1_2 + 0.186243386243386*G0_2_0 + 0.093121693121693*G0_2_1 - 0.084656084656085*G0_2_2;
    A[199] = 0.186243386243386*G0_1_0 - 0.084656084656085*G0_1_1 + 0.093121693121693*G0_1_2 + 0.050793650793650*G0_2_0 - 0.042328042328043*G0_2_1 + 0.118518518518518*G0_2_2;
    A[200] = 0.084656084656085*G0_1_0 + 0.067724867724868*G0_1_1 + 0.064902998236332*G0_1_2 + 0.084656084656085*G0_2_0 + 0.064902998236332*G0_2_1 + 0.067724867724868*G0_2_2;
    A[201] = -0.050793650793651*G0_1_0 + 0.067724867724867*G0_1_1 - 0.093121693121693*G0_1_2 - 0.186243386243386*G0_2_0 - 0.093121693121693*G0_2_1 - 0.270899470899471*G0_2_2;
    A[202] = -0.186243386243386*G0_1_0 - 0.270899470899471*G0_1_1 - 0.093121693121693*G0_1_2 - 0.050793650793650*G0_2_0 - 0.093121693121693*G0_2_1 + 0.067724867724868*G0_2_2;
    A[203] = 0.016931216931217*G0_1_1 + 0.019753086419753*G0_1_2 + 0.019753086419753*G0_2_1 + 0.022574955908289*G0_2_2;
    A[204] = 0.016931216931217*G0_1_1 + 0.019753086419753*G0_1_2 + 0.019753086419753*G0_2_1 + 0.022574955908289*G0_2_2;
    A[205] = 0.084656084656085*G0_1_1 + 0.042328042328042*G0_1_2 + 0.042328042328043*G0_2_1 + 0.022574955908289*G0_2_2;
    A[206] = 0.022574955908289*G0_1_1 + 0.019753086419753*G0_1_2 + 0.019753086419753*G0_2_1 + 0.016931216931217*G0_2_2;
    A[207] = 0.022574955908289*G0_1_1 + 0.019753086419753*G0_1_2 + 0.019753086419753*G0_2_1 + 0.016931216931217*G0_2_2;
    A[208] = 0.022574955908289*G0_1_1 + 0.042328042328042*G0_1_2 + 0.042328042328042*G0_2_1 + 0.084656084656085*G0_2_2;
    A[209] = -0.135449735449735*G0_1_1 - 0.112874779541446*G0_1_2 - 0.112874779541446*G0_2_1 - 0.135449735449735*G0_2_2;
    A[210] = 0.007760141093474*G0_1_0 + 0.007760141093474*G0_1_1 + 0.007760141093474*G0_1_2 + 0.007760141093474*G0_2_0 + 0.007760141093474*G0_2_1 + 0.007760141093474*G0_2_2;
    A[211] = -0.007760141093474*G0_1_0 - 0.007760141093474*G0_2_0;
    A[212] = -0.007760141093474*G0_1_1 + 0.017636684303351*G0_2_1;
    A[213] = 0.045855379188712*G0_1_2 - 0.024691358024691*G0_2_2;
    A[214] = 0.045149911816578*G0_1_1 + 0.011287477954145*G0_1_2 - 0.033862433862434*G0_2_1 + 0.045149911816578*G0_2_2;
    A[215] = -0.090299823633157*G0_1_1 - 0.031040564373898*G0_1_2 + 0.042328042328042*G0_2_1 - 0.118518518518519*G0_2_2;
    A[216] = 0.158024691358025*G0_1_1 + 0.079012345679012*G0_1_2 + 0.079012345679012*G0_2_1 + 0.203174603174603*G0_2_2;
    A[217] = 0.045149911816578*G0_1_0 + 0.011287477954145*G0_1_2 + 0.033862433862434*G0_2_0 + 0.011287477954145*G0_2_2;
    A[218] = -0.090299823633157*G0_1_0 - 0.031040564373898*G0_1_2 - 0.059259259259259*G0_2_0 - 0.042328042328042*G0_2_2;
    A[219] = 0.158024691358025*G0_1_0 + 0.079012345679012*G0_1_2 + 0.079012345679012*G0_2_0 + 0.101587301587302*G0_2_2;
    A[220] = 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_1 + 0.022574955908289*G0_2_0 + 0.011287477954145*G0_2_1;
    A[221] = 0.002821869488536*G0_1_0 + 0.002821869488536*G0_1_1 + 0.016931216931217*G0_2_0 + 0.014109347442681*G0_2_1;
    A[222] = 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_1 + 0.045149911816579*G0_2_0 + 0.033862433862434*G0_2_1;
    A[223] = -0.045149911816578*G0_1_0 - 0.045149911816579*G0_1_1 - 0.033862433862434*G0_1_2 - 0.033862433862434*G0_2_0 - 0.033862433862434*G0_2_1 - 0.022574955908289*G0_2_2;
    A[224] = 0.090299823633157*G0_1_0 + 0.090299823633157*G0_1_1 + 0.059259259259259*G0_1_2 + 0.059259259259259*G0_2_0 + 0.059259259259259*G0_2_1 + 0.016931216931217*G0_2_2;
    A[225] = -0.158024691358025*G0_1_0 - 0.158024691358025*G0_1_1 - 0.079012345679012*G0_1_2 - 0.079012345679012*G0_2_0 - 0.079012345679012*G0_2_1 + 0.022574955908289*G0_2_2;
    A[226] = -0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_2 - 0.022574955908289*G0_2_0 - 0.011287477954145*G0_2_1 - 0.022574955908289*G0_2_2;
    A[227] = -0.002821869488536*G0_1_0 - 0.002821869488536*G0_1_2 - 0.016931216931217*G0_2_0 - 0.002821869488536*G0_2_1 - 0.016931216931217*G0_2_2;
    A[228] = -0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_2 - 0.045149911816578*G0_2_0 - 0.011287477954145*G0_2_1 - 0.045149911816579*G0_2_2;
    A[229] = -0.011287477954145*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1 - 0.011287477954145*G0_2_2;
    A[230] = -0.002821869488536*G0_1_1 - 0.002821869488536*G0_1_2 - 0.002821869488536*G0_2_1 - 0.002821869488536*G0_2_2;
    A[231] = -0.011287477954145*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1 - 0.011287477954145*G0_2_2;
    A[232] = -0.022574955908289*G0_1_0 - 0.022574955908289*G0_1_1 + 0.011287477954145*G0_1_2 - 0.067724867724867*G0_2_0 - 0.033862433862434*G0_2_1 + 0.022574955908289*G0_2_2;
    A[233] = -0.022574955908289*G0_1_0 - 0.022574955908289*G0_1_1 + 0.011287477954145*G0_1_2 - 0.067724867724868*G0_2_0 - 0.033862433862434*G0_2_1 + 0.067724867724868*G0_2_2;
    A[234] = 0.112874779541446*G0_1_0 + 0.112874779541446*G0_1_1 + 0.011287477954145*G0_1_2 + 0.203174603174603*G0_2_0 + 0.101587301587302*G0_2_1 - 0.067724867724868*G0_2_2;
    A[235] = 0.022574955908289*G0_1_0 + 0.033862433862434*G0_1_2 + 0.067724867724868*G0_2_0 + 0.033862433862434*G0_2_1 + 0.090299823633157*G0_2_2;
    A[236] = 0.022574955908289*G0_1_0 + 0.033862433862434*G0_1_2 + 0.067724867724868*G0_2_0 + 0.033862433862434*G0_2_1 + 0.135449735449735*G0_2_2;
    A[237] = -0.112874779541446*G0_1_0 - 0.101587301587302*G0_1_2 - 0.203174603174603*G0_2_0 - 0.101587301587302*G0_2_1 - 0.270899470899471*G0_2_2;
    A[238] = 0.022574955908289*G0_1_1 + 0.033862433862434*G0_1_2 + 0.033862433862434*G0_2_1 + 0.045149911816578*G0_2_2;
    A[239] = 0.022574955908289*G0_1_1 + 0.033862433862434*G0_1_2 + 0.033862433862434*G0_2_1 + 0.045149911816578*G0_2_2;
    A[240] = -0.112874779541446*G0_1_1 - 0.101587301587302*G0_1_2 - 0.101587301587302*G0_2_1 - 0.135449735449735*G0_2_2;
    A[241] = -0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1 - 0.022574955908289*G0_2_2;
    A[242] = -0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1 - 0.022574955908289*G0_2_2;
    A[243] = -0.011287477954144*G0_1_2 - 0.011287477954145*G0_2_1 - 0.067724867724868*G0_2_2;
    A[244] = 0.090299823633157*G0_2_2;
    A[245] = 0.007760141093474*G0_0_0 + 0.007760141093474*G0_0_1 + 0.007760141093474*G0_0_2 + 0.007760141093474*G0_2_0 + 0.007760141093474*G0_2_1 + 0.007760141093474*G0_2_2;
    A[246] = -0.024691358024691*G0_0_0 + 0.045855379188712*G0_2_0;
    A[247] = -0.007760141093474*G0_0_1 - 0.007760141093474*G0_2_1;
    A[248] = 0.017636684303351*G0_0_2 - 0.007760141093474*G0_2_2;
    A[249] = 0.022574955908289*G0_0_1 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_2_1 + 0.011287477954145*G0_2_2;
    A[250] = 0.016931216931217*G0_0_1 + 0.014109347442681*G0_0_2 + 0.002821869488536*G0_2_1 + 0.002821869488536*G0_2_2;
    A[251] = 0.045149911816578*G0_0_1 + 0.033862433862434*G0_0_2 + 0.011287477954145*G0_2_1 + 0.011287477954145*G0_2_2;
    A[252] = 0.203174603174603*G0_0_0 + 0.079012345679012*G0_0_2 + 0.079012345679012*G0_2_0 + 0.158024691358024*G0_2_2;
    A[253] = -0.118518518518518*G0_0_0 + 0.042328042328042*G0_0_2 - 0.031040564373897*G0_2_0 - 0.090299823633156*G0_2_2;
    A[254] = 0.045149911816578*G0_0_0 - 0.033862433862434*G0_0_2 + 0.011287477954145*G0_2_0 + 0.045149911816578*G0_2_2;
    A[255] = 0.101587301587302*G0_0_0 + 0.079012345679012*G0_0_1 + 0.079012345679012*G0_2_0 + 0.158024691358024*G0_2_1;
    A[256] = -0.042328042328042*G0_0_0 - 0.059259259259259*G0_0_1 - 0.031040564373898*G0_2_0 - 0.090299823633157*G0_2_1;
    A[257] = 0.011287477954145*G0_0_0 + 0.033862433862434*G0_0_1 + 0.011287477954145*G0_2_0 + 0.045149911816578*G0_2_1;
    A[258] = -0.022574955908289*G0_0_0 - 0.022574955908289*G0_0_1 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_1;
    A[259] = -0.016931216931217*G0_0_0 - 0.016931216931217*G0_0_1 - 0.002821869488536*G0_0_2 - 0.002821869488536*G0_2_0 - 0.002821869488536*G0_2_1;
    A[260] = -0.045149911816579*G0_0_0 - 0.045149911816578*G0_0_1 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_1;
    A[261] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_2;
    A[262] = -0.002821869488536*G0_0_0 - 0.002821869488536*G0_0_2 - 0.002821869488536*G0_2_0 - 0.002821869488536*G0_2_2;
    A[263] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_2;
    A[264] = -0.022574955908289*G0_0_0 - 0.033862433862434*G0_0_1 - 0.033862433862434*G0_0_2 - 0.033862433862434*G0_2_0 - 0.045149911816578*G0_2_1 - 0.045149911816578*G0_2_2;
    A[265] = 0.016931216931217*G0_0_0 + 0.059259259259259*G0_0_1 + 0.059259259259259*G0_0_2 + 0.059259259259259*G0_2_0 + 0.090299823633157*G0_2_1 + 0.090299823633157*G0_2_2;
    A[266] = 0.022574955908289*G0_0_0 - 0.079012345679012*G0_0_1 - 0.079012345679012*G0_0_2 - 0.079012345679012*G0_2_0 - 0.158024691358024*G0_2_1 - 0.158024691358024*G0_2_2;
    A[267] = -0.067724867724868*G0_0_0 + 0.203174603174603*G0_0_1 + 0.101587301587301*G0_0_2 + 0.011287477954145*G0_2_0 + 0.112874779541446*G0_2_1 + 0.112874779541446*G0_2_2;
    A[268] = 0.022574955908289*G0_0_0 - 0.067724867724868*G0_0_1 - 0.033862433862434*G0_0_2 + 0.011287477954145*G0_2_0 - 0.022574955908289*G0_2_1 - 0.022574955908289*G0_2_2;
    A[269] = 0.067724867724868*G0_0_0 - 0.067724867724868*G0_0_1 - 0.033862433862434*G0_0_2 + 0.011287477954145*G0_2_0 - 0.022574955908289*G0_2_1 - 0.022574955908289*G0_2_2;
    A[270] = -0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0;
    A[271] = -0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0;
    A[272] = -0.067724867724868*G0_0_0 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0;
    A[273] = 0.090299823633157*G0_0_0 + 0.067724867724868*G0_0_1 + 0.033862433862434*G0_0_2 + 0.033862433862434*G0_2_0 + 0.022574955908289*G0_2_1;
    A[274] = -0.270899470899471*G0_0_0 - 0.203174603174603*G0_0_1 - 0.101587301587301*G0_0_2 - 0.101587301587301*G0_2_0 - 0.112874779541446*G0_2_1;
    A[275] = 0.135449735449735*G0_0_0 + 0.067724867724868*G0_0_1 + 0.033862433862434*G0_0_2 + 0.033862433862433*G0_2_0 + 0.022574955908289*G0_2_1;
    A[276] = 0.045149911816578*G0_0_0 + 0.033862433862434*G0_0_2 + 0.033862433862434*G0_2_0 + 0.022574955908289*G0_2_2;
    A[277] = -0.135449735449735*G0_0_0 - 0.101587301587301*G0_0_2 - 0.101587301587301*G0_2_0 - 0.112874779541446*G0_2_2;
    A[278] = 0.045149911816579*G0_0_0 + 0.033862433862434*G0_0_2 + 0.033862433862434*G0_2_0 + 0.022574955908289*G0_2_2;
    A[279] = 0.090299823633157*G0_0_0;
    A[280] = 0.005114638447972*G0_0_0 + 0.005114638447972*G0_0_1 + 0.005114638447972*G0_0_2 + 0.005114638447972*G0_2_0 + 0.005114638447972*G0_2_1 + 0.005114638447972*G0_2_2;
    A[281] = 0.020282186948854*G0_0_0 - 0.032627865961199*G0_2_0;
    A[282] = -0.005114638447972*G0_0_1 - 0.005114638447972*G0_2_1;
    A[283] = -0.032627865961199*G0_0_2 + 0.020282186948854*G0_2_2;
    A[284] = 0.016931216931217*G0_0_1 + 0.002821869488536*G0_0_2 + 0.014109347442681*G0_2_1 + 0.002821869488536*G0_2_2;
    A[285] = -0.021164021164021*G0_0_1 - 0.010582010582011*G0_0_2 - 0.010582010582010*G0_2_1 - 0.013403880070547*G0_2_2;
    A[286] = -0.090299823633157*G0_0_1 - 0.059259259259259*G0_0_2 - 0.031040564373898*G0_2_1 - 0.042328042328042*G0_2_2;
    A[287] = -0.118518518518518*G0_0_0 - 0.031040564373897*G0_0_2 + 0.042328042328042*G0_2_0 - 0.090299823633156*G0_2_2;
    A[288] = 0.249735449735449*G0_0_0 + 0.082539682539682*G0_0_2 + 0.082539682539682*G0_2_0 + 0.249735449735449*G0_2_2;
    A[289] = -0.090299823633157*G0_0_0 + 0.042328042328042*G0_0_2 - 0.031040564373898*G0_2_0 - 0.118518518518518*G0_2_2;
    A[290] = -0.042328042328042*G0_0_0 - 0.031040564373897*G0_0_1 - 0.059259259259259*G0_2_0 - 0.090299823633156*G0_2_1;
    A[291] = -0.013403880070547*G0_0_0 - 0.010582010582010*G0_0_1 - 0.010582010582010*G0_2_0 - 0.021164021164021*G0_2_1;
    A[292] = 0.002821869488536*G0_0_0 + 0.014109347442681*G0_0_1 + 0.002821869488536*G0_2_0 + 0.016931216931217*G0_2_1;
    A[293] = -0.016931216931217*G0_0_0 - 0.016931216931217*G0_0_1 - 0.014109347442681*G0_0_2 - 0.014109347442681*G0_2_0 - 0.014109347442681*G0_2_1 - 0.011287477954145*G0_2_2;
    A[294] = 0.021164021164021*G0_0_0 + 0.021164021164021*G0_0_1 + 0.010582010582011*G0_0_2 + 0.010582010582010*G0_2_0 + 0.010582010582010*G0_2_1 - 0.002821869488536*G0_2_2;
    A[295] = 0.090299823633157*G0_0_0 + 0.090299823633157*G0_0_1 + 0.031040564373898*G0_0_2 + 0.031040564373898*G0_2_0 + 0.031040564373898*G0_2_1 - 0.011287477954145*G0_2_2;
    A[296] = -0.002821869488536*G0_0_0 - 0.002821869488536*G0_0_2 - 0.002821869488536*G0_2_0 - 0.002821869488536*G0_2_2;
    A[297] = -0.009171075837742*G0_0_0 - 0.009171075837742*G0_0_2 - 0.009171075837742*G0_2_0 - 0.009171075837742*G0_2_2;
    A[298] = -0.002821869488536*G0_0_0 - 0.002821869488536*G0_0_2 - 0.002821869488536*G0_2_0 - 0.002821869488536*G0_2_2;
    A[299] = -0.011287477954145*G0_0_0 - 0.014109347442681*G0_0_1 - 0.014109347442681*G0_0_2 - 0.014109347442681*G0_2_0 - 0.016931216931217*G0_2_1 - 0.016931216931217*G0_2_2;
    A[300] = -0.002821869488536*G0_0_0 + 0.010582010582011*G0_0_1 + 0.010582010582011*G0_0_2 + 0.010582010582011*G0_2_0 + 0.021164021164021*G0_2_1 + 0.021164021164021*G0_2_2;
    A[301] = -0.011287477954145*G0_0_0 + 0.031040564373898*G0_0_1 + 0.031040564373897*G0_0_2 + 0.031040564373897*G0_2_0 + 0.090299823633156*G0_2_1 + 0.090299823633156*G0_2_2;
    A[302] = 0.118518518518518*G0_0_0 + 0.050793650793650*G0_0_1 - 0.042328042328042*G0_0_2 + 0.093121693121693*G0_2_0 + 0.186243386243386*G0_2_1 - 0.084656084656084*G0_2_2;
    A[303] = -0.016931216931217*G0_0_0 - 0.084656084656084*G0_0_1 - 0.019753086419753*G0_0_2 - 0.019753086419753*G0_2_0 - 0.084656084656084*G0_2_1 - 0.016931216931217*G0_2_2;
    A[304] = -0.084656084656084*G0_0_0 + 0.186243386243386*G0_0_1 + 0.093121693121693*G0_0_2 - 0.042328042328042*G0_2_0 + 0.050793650793650*G0_2_1 + 0.118518518518518*G0_2_2;
    A[305] = 0.016931216931217*G0_0_0 + 0.019753086419753*G0_0_2 + 0.019753086419753*G0_2_0 + 0.022574955908289*G0_2_2;
    A[306] = 0.016931216931217*G0_0_0 + 0.019753086419753*G0_0_2 + 0.019753086419753*G0_2_0 + 0.022574955908289*G0_2_2;
    A[307] = 0.084656084656084*G0_0_0 + 0.042328042328043*G0_0_2 + 0.042328042328042*G0_2_0 + 0.022574955908290*G0_2_2;
    A[308] = 0.067724867724867*G0_0_0 + 0.084656084656084*G0_0_1 + 0.064902998236331*G0_0_2 + 0.064902998236331*G0_2_0 + 0.084656084656084*G0_2_1 + 0.067724867724867*G0_2_2;
    A[309] = 0.067724867724868*G0_0_0 - 0.050793650793650*G0_0_1 - 0.093121693121693*G0_0_2 - 0.093121693121693*G0_2_0 - 0.186243386243386*G0_2_1 - 0.270899470899470*G0_2_2;
    A[310] = -0.270899470899470*G0_0_0 - 0.186243386243386*G0_0_1 - 0.093121693121693*G0_0_2 - 0.093121693121692*G0_2_0 - 0.050793650793650*G0_2_1 + 0.067724867724868*G0_2_2;
    A[311] = 0.022574955908289*G0_0_0 + 0.019753086419753*G0_0_2 + 0.019753086419753*G0_2_0 + 0.016931216931217*G0_2_2;
    A[312] = 0.022574955908289*G0_0_0 + 0.042328042328042*G0_0_2 + 0.042328042328042*G0_2_0 + 0.084656084656084*G0_2_2;
    A[313] = 0.022574955908289*G0_0_0 + 0.019753086419753*G0_0_2 + 0.019753086419753*G0_2_0 + 0.016931216931217*G0_2_2;
    A[314] = -0.135449735449735*G0_0_0 - 0.112874779541446*G0_0_2 - 0.112874779541445*G0_2_0 - 0.135449735449735*G0_2_2;
    A[315] = 0.007760141093474*G0_0_0 + 0.007760141093474*G0_0_1 + 0.007760141093474*G0_0_2 + 0.007760141093474*G0_2_0 + 0.007760141093474*G0_2_1 + 0.007760141093474*G0_2_2;
    A[316] = -0.007760141093474*G0_0_0 + 0.017636684303351*G0_2_0;
    A[317] = -0.007760141093474*G0_0_1 - 0.007760141093474*G0_2_1;
    A[318] = 0.045855379188712*G0_0_2 - 0.024691358024691*G0_2_2;
    A[319] = 0.045149911816578*G0_0_1 + 0.011287477954145*G0_0_2 + 0.033862433862434*G0_2_1 + 0.011287477954145*G0_2_2;
    A[320] = -0.090299823633157*G0_0_1 - 0.031040564373898*G0_0_2 - 0.059259259259259*G0_2_1 - 0.042328042328042*G0_2_2;
    A[321] = 0.158024691358025*G0_0_1 + 0.079012345679012*G0_0_2 + 0.079012345679012*G0_2_1 + 0.101587301587302*G0_2_2;
    A[322] = 0.045149911816578*G0_0_0 + 0.011287477954145*G0_0_2 - 0.033862433862434*G0_2_0 + 0.045149911816578*G0_2_2;
    A[323] = -0.090299823633157*G0_0_0 - 0.031040564373898*G0_0_2 + 0.042328042328042*G0_2_0 - 0.118518518518518*G0_2_2;
    A[324] = 0.158024691358024*G0_0_0 + 0.079012345679012*G0_0_2 + 0.079012345679012*G0_2_0 + 0.203174603174603*G0_2_2;
    A[325] = 0.011287477954145*G0_0_0 + 0.011287477954145*G0_0_1 + 0.033862433862434*G0_2_0 + 0.045149911816578*G0_2_1;
    A[326] = 0.002821869488536*G0_0_0 + 0.002821869488536*G0_0_1 + 0.014109347442681*G0_2_0 + 0.016931216931217*G0_2_1;
    A[327] = 0.011287477954145*G0_0_0 + 0.011287477954145*G0_0_1 + 0.011287477954145*G0_2_0 + 0.022574955908289*G0_2_1;
    A[328] = -0.045149911816578*G0_0_0 - 0.045149911816578*G0_0_1 - 0.033862433862434*G0_0_2 - 0.033862433862434*G0_2_0 - 0.033862433862434*G0_2_1 - 0.022574955908289*G0_2_2;
    A[329] = 0.090299823633157*G0_0_0 + 0.090299823633157*G0_0_1 + 0.059259259259259*G0_0_2 + 0.059259259259259*G0_2_0 + 0.059259259259259*G0_2_1 + 0.016931216931217*G0_2_2;
    A[330] = -0.158024691358024*G0_0_0 - 0.158024691358024*G0_0_1 - 0.079012345679012*G0_0_2 - 0.079012345679012*G0_2_0 - 0.079012345679012*G0_2_1 + 0.022574955908289*G0_2_2;
    A[331] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_2;
    A[332] = -0.002821869488536*G0_0_0 - 0.002821869488536*G0_0_2 - 0.002821869488536*G0_2_0 - 0.002821869488536*G0_2_2;
    A[333] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_2;
    A[334] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0 - 0.022574955908289*G0_2_1 - 0.022574955908289*G0_2_2;
    A[335] = -0.002821869488536*G0_0_1 - 0.002821869488536*G0_0_2 - 0.002821869488536*G0_2_0 - 0.016931216931217*G0_2_1 - 0.016931216931217*G0_2_2;
    A[336] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0 - 0.045149911816578*G0_2_1 - 0.045149911816578*G0_2_2;
    A[337] = -0.022574955908289*G0_0_0 - 0.022574955908289*G0_0_1 + 0.011287477954145*G0_0_2 - 0.033862433862434*G0_2_0 - 0.067724867724868*G0_2_1 + 0.067724867724868*G0_2_2;
    A[338] = -0.022574955908289*G0_0_0 - 0.022574955908289*G0_0_1 + 0.011287477954145*G0_0_2 - 0.033862433862434*G0_2_0 - 0.067724867724868*G0_2_1 + 0.022574955908289*G0_2_2;
    A[339] = 0.112874779541446*G0_0_0 + 0.112874779541446*G0_0_1 + 0.011287477954145*G0_0_2 + 0.101587301587302*G0_2_0 + 0.203174603174603*G0_2_1 - 0.067724867724867*G0_2_2;
    A[340] = 0.022574955908289*G0_0_0 + 0.033862433862434*G0_0_2 + 0.033862433862434*G0_2_0 + 0.045149911816578*G0_2_2;
    A[341] = 0.022574955908289*G0_0_0 + 0.033862433862434*G0_0_2 + 0.033862433862434*G0_2_0 + 0.045149911816579*G0_2_2;
    A[342] = -0.112874779541446*G0_0_0 - 0.101587301587302*G0_0_2 - 0.101587301587302*G0_2_0 - 0.135449735449735*G0_2_2;
    A[343] = 0.022574955908289*G0_0_1 + 0.033862433862434*G0_0_2 + 0.033862433862434*G0_2_0 + 0.067724867724868*G0_2_1 + 0.090299823633157*G0_2_2;
    A[344] = 0.022574955908289*G0_0_1 + 0.033862433862434*G0_0_2 + 0.033862433862434*G0_2_0 + 0.067724867724868*G0_2_1 + 0.135449735449735*G0_2_2;
    A[345] = -0.112874779541446*G0_0_1 - 0.101587301587302*G0_0_2 - 0.101587301587302*G0_2_0 - 0.203174603174603*G0_2_1 - 0.270899470899471*G0_2_2;
    A[346] = -0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0 - 0.022574955908289*G0_2_2;
    A[347] = -0.011287477954145*G0_0_2 - 0.011287477954144*G0_2_0 - 0.067724867724868*G0_2_2;
    A[348] = -0.011287477954144*G0_0_2 - 0.011287477954145*G0_2_0 - 0.022574955908289*G0_2_2;
    A[349] = 0.090299823633157*G0_2_2;
    A[350] = 0.007760141093474*G0_0_0 + 0.007760141093474*G0_0_1 + 0.007760141093474*G0_0_2 + 0.007760141093474*G0_1_0 + 0.007760141093474*G0_1_1 + 0.007760141093474*G0_1_2;
    A[351] = -0.024691358024691*G0_0_0 + 0.045855379188712*G0_1_0;
    A[352] = 0.017636684303351*G0_0_1 - 0.007760141093474*G0_1_1;
    A[353] = -0.007760141093474*G0_0_2 - 0.007760141093474*G0_1_2;
    A[354] = 0.033862433862434*G0_0_1 + 0.045149911816579*G0_0_2 + 0.011287477954145*G0_1_1 + 0.011287477954145*G0_1_2;
    A[355] = 0.014109347442681*G0_0_1 + 0.016931216931217*G0_0_2 + 0.002821869488536*G0_1_1 + 0.002821869488536*G0_1_2;
    A[356] = 0.011287477954145*G0_0_1 + 0.022574955908289*G0_0_2 + 0.011287477954145*G0_1_1 + 0.011287477954145*G0_1_2;
    A[357] = 0.101587301587302*G0_0_0 + 0.079012345679012*G0_0_2 + 0.079012345679012*G0_1_0 + 0.158024691358024*G0_1_2;
    A[358] = -0.042328042328042*G0_0_0 - 0.059259259259259*G0_0_2 - 0.031040564373897*G0_1_0 - 0.090299823633156*G0_1_2;
    A[359] = 0.011287477954145*G0_0_0 + 0.033862433862434*G0_0_2 + 0.011287477954145*G0_1_0 + 0.045149911816578*G0_1_2;
    A[360] = 0.203174603174603*G0_0_0 + 0.079012345679012*G0_0_1 + 0.079012345679012*G0_1_0 + 0.158024691358024*G0_1_1;
    A[361] = -0.118518518518519*G0_0_0 + 0.042328042328042*G0_0_1 - 0.031040564373898*G0_1_0 - 0.090299823633157*G0_1_1;
    A[362] = 0.045149911816579*G0_0_0 - 0.033862433862434*G0_0_1 + 0.011287477954145*G0_1_0 + 0.045149911816578*G0_1_1;
    A[363] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_1;
    A[364] = -0.002821869488536*G0_0_0 - 0.002821869488536*G0_0_1 - 0.002821869488536*G0_1_0 - 0.002821869488536*G0_1_1;
    A[365] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_1;
    A[366] = -0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_1 - 0.022574955908289*G0_0_2 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_2;
    A[367] = -0.016931216931217*G0_0_0 - 0.002821869488536*G0_0_1 - 0.016931216931217*G0_0_2 - 0.002821869488536*G0_1_0 - 0.002821869488536*G0_1_2;
    A[368] = -0.045149911816579*G0_0_0 - 0.011287477954145*G0_0_1 - 0.045149911816579*G0_0_2 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_2;
    A[369] = -0.022574955908289*G0_0_0 - 0.033862433862434*G0_0_1 - 0.033862433862434*G0_0_2 - 0.033862433862434*G0_1_0 - 0.045149911816578*G0_1_1 - 0.045149911816578*G0_1_2;
    A[370] = 0.016931216931217*G0_0_0 + 0.059259259259259*G0_0_1 + 0.059259259259259*G0_0_2 + 0.059259259259259*G0_1_0 + 0.090299823633157*G0_1_1 + 0.090299823633157*G0_1_2;
    A[371] = 0.022574955908289*G0_0_0 - 0.079012345679012*G0_0_1 - 0.079012345679012*G0_0_2 - 0.079012345679012*G0_1_0 - 0.158024691358024*G0_1_1 - 0.158024691358024*G0_1_2;
    A[372] = -0.067724867724868*G0_0_0 + 0.101587301587302*G0_0_1 + 0.203174603174603*G0_0_2 + 0.011287477954145*G0_1_0 + 0.112874779541446*G0_1_1 + 0.112874779541446*G0_1_2;
    A[373] = 0.067724867724868*G0_0_0 - 0.033862433862434*G0_0_1 - 0.067724867724868*G0_0_2 + 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_1 - 0.022574955908289*G0_1_2;
    A[374] = 0.022574955908289*G0_0_0 - 0.033862433862434*G0_0_1 - 0.067724867724867*G0_0_2 + 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_1 - 0.022574955908289*G0_1_2;
    A[375] = -0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0;
    A[376] = -0.067724867724868*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0;
    A[377] = -0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0;
    A[378] = 0.045149911816578*G0_0_0 + 0.033862433862434*G0_0_1 + 0.033862433862434*G0_1_0 + 0.022574955908289*G0_1_1;
    A[379] = -0.135449735449735*G0_0_0 - 0.101587301587302*G0_0_1 - 0.101587301587301*G0_1_0 - 0.112874779541446*G0_1_1;
    A[380] = 0.045149911816578*G0_0_0 + 0.033862433862434*G0_0_1 + 0.033862433862433*G0_1_0 + 0.022574955908289*G0_1_1;
    A[381] = 0.090299823633156*G0_0_0 + 0.033862433862434*G0_0_1 + 0.067724867724867*G0_0_2 + 0.033862433862434*G0_1_0 + 0.022574955908289*G0_1_2;
    A[382] = -0.270899470899470*G0_0_0 - 0.101587301587301*G0_0_1 - 0.203174603174603*G0_0_2 - 0.101587301587301*G0_1_0 - 0.112874779541446*G0_1_2;
    A[383] = 0.135449735449735*G0_0_0 + 0.033862433862434*G0_0_1 + 0.067724867724868*G0_0_2 + 0.033862433862434*G0_1_0 + 0.022574955908289*G0_1_2;
    A[384] = 0.090299823633157*G0_0_0;
    A[385] = 0.005114638447972*G0_0_0 + 0.005114638447972*G0_0_1 + 0.005114638447972*G0_0_2 + 0.005114638447972*G0_1_0 + 0.005114638447972*G0_1_1 + 0.005114638447972*G0_1_2;
    A[386] = 0.020282186948854*G0_0_0 - 0.032627865961199*G0_1_0;
    A[387] = -0.032627865961199*G0_0_1 + 0.020282186948854*G0_1_1;
    A[388] = -0.005114638447972*G0_0_2 - 0.005114638447972*G0_1_2;
    A[389] = -0.059259259259259*G0_0_1 - 0.090299823633157*G0_0_2 - 0.042328042328042*G0_1_1 - 0.031040564373898*G0_1_2;
    A[390] = -0.010582010582010*G0_0_1 - 0.021164021164021*G0_0_2 - 0.013403880070547*G0_1_1 - 0.010582010582011*G0_1_2;
    A[391] = 0.002821869488536*G0_0_1 + 0.016931216931217*G0_0_2 + 0.002821869488536*G0_1_1 + 0.014109347442681*G0_1_2;
    A[392] = -0.042328042328042*G0_0_0 - 0.031040564373898*G0_0_2 - 0.059259259259259*G0_1_0 - 0.090299823633157*G0_1_2;
    A[393] = -0.013403880070547*G0_0_0 - 0.010582010582010*G0_0_2 - 0.010582010582010*G0_1_0 - 0.021164021164021*G0_1_2;
    A[394] = 0.002821869488536*G0_0_0 + 0.014109347442681*G0_0_2 + 0.002821869488536*G0_1_0 + 0.016931216931217*G0_1_2;
    A[395] = -0.118518518518519*G0_0_0 - 0.031040564373898*G0_0_1 + 0.042328042328042*G0_1_0 - 0.090299823633157*G0_1_1;
    A[396] = 0.249735449735450*G0_0_0 + 0.082539682539683*G0_0_1 + 0.082539682539683*G0_1_0 + 0.249735449735449*G0_1_1;
    A[397] = -0.090299823633157*G0_0_0 + 0.042328042328042*G0_0_1 - 0.031040564373898*G0_1_0 - 0.118518518518518*G0_1_1;
    A[398] = -0.002821869488536*G0_0_0 - 0.002821869488536*G0_0_1 - 0.002821869488536*G0_1_0 - 0.002821869488536*G0_1_1;
    A[399] = -0.009171075837742*G0_0_0 - 0.009171075837742*G0_0_1 - 0.009171075837743*G0_1_0 - 0.009171075837743*G0_1_1;
    A[400] = -0.002821869488536*G0_0_0 - 0.002821869488536*G0_0_1 - 0.002821869488536*G0_1_0 - 0.002821869488536*G0_1_1;
    A[401] = -0.016931216931217*G0_0_0 - 0.014109347442681*G0_0_1 - 0.016931216931217*G0_0_2 - 0.014109347442681*G0_1_0 - 0.011287477954145*G0_1_1 - 0.014109347442681*G0_1_2;
    A[402] = 0.021164021164021*G0_0_0 + 0.010582010582010*G0_0_1 + 0.021164021164021*G0_0_2 + 0.010582010582010*G0_1_0 - 0.002821869488536*G0_1_1 + 0.010582010582010*G0_1_2;
    A[403] = 0.090299823633157*G0_0_0 + 0.031040564373898*G0_0_1 + 0.090299823633157*G0_0_2 + 0.031040564373898*G0_1_0 - 0.011287477954145*G0_1_1 + 0.031040564373898*G0_1_2;
    A[404] = -0.011287477954145*G0_0_0 - 0.014109347442681*G0_0_1 - 0.014109347442681*G0_0_2 - 0.014109347442681*G0_1_0 - 0.016931216931217*G0_1_1 - 0.016931216931217*G0_1_2;
    A[405] = -0.002821869488536*G0_0_0 + 0.010582010582011*G0_0_1 + 0.010582010582011*G0_0_2 + 0.010582010582011*G0_1_0 + 0.021164021164021*G0_1_1 + 0.021164021164021*G0_1_2;
    A[406] = -0.011287477954145*G0_0_0 + 0.031040564373898*G0_0_1 + 0.031040564373898*G0_0_2 + 0.031040564373898*G0_1_0 + 0.090299823633157*G0_1_1 + 0.090299823633157*G0_1_2;
    A[407] = 0.118518518518518*G0_0_0 - 0.042328042328042*G0_0_1 + 0.050793650793651*G0_0_2 + 0.093121693121693*G0_1_0 - 0.084656084656085*G0_1_1 + 0.186243386243386*G0_1_2;
    A[408] = -0.084656084656085*G0_0_0 + 0.093121693121693*G0_0_1 + 0.186243386243386*G0_0_2 - 0.042328042328043*G0_1_0 + 0.118518518518518*G0_1_1 + 0.050793650793650*G0_1_2;
    A[409] = -0.016931216931217*G0_0_0 - 0.019753086419753*G0_0_1 - 0.084656084656084*G0_0_2 - 0.019753086419753*G0_1_0 - 0.016931216931217*G0_1_1 - 0.084656084656084*G0_1_2;
    A[410] = 0.016931216931217*G0_0_0 + 0.019753086419753*G0_0_1 + 0.019753086419753*G0_1_0 + 0.022574955908289*G0_1_1;
    A[411] = 0.084656084656085*G0_0_0 + 0.042328042328043*G0_0_1 + 0.042328042328043*G0_1_0 + 0.022574955908289*G0_1_1;
    A[412] = 0.016931216931217*G0_0_0 + 0.019753086419753*G0_0_1 + 0.019753086419753*G0_1_0 + 0.022574955908289*G0_1_1;
    A[413] = 0.022574955908289*G0_0_0 + 0.019753086419753*G0_0_1 + 0.019753086419753*G0_1_0 + 0.016931216931217*G0_1_1;
    A[414] = 0.022574955908289*G0_0_0 + 0.042328042328042*G0_0_1 + 0.042328042328042*G0_1_0 + 0.084656084656085*G0_1_1;
    A[415] = 0.022574955908289*G0_0_0 + 0.019753086419753*G0_0_1 + 0.019753086419753*G0_1_0 + 0.016931216931217*G0_1_1;
    A[416] = 0.067724867724868*G0_0_0 + 0.064902998236332*G0_0_1 + 0.084656084656085*G0_0_2 + 0.064902998236331*G0_1_0 + 0.067724867724867*G0_1_1 + 0.084656084656084*G0_1_2;
    A[417] = 0.067724867724868*G0_0_0 - 0.093121693121693*G0_0_1 - 0.050793650793650*G0_0_2 - 0.093121693121693*G0_1_0 - 0.270899470899470*G0_1_1 - 0.186243386243385*G0_1_2;
    A[418] = -0.270899470899470*G0_0_0 - 0.093121693121693*G0_0_1 - 0.186243386243386*G0_0_2 - 0.093121693121693*G0_1_0 + 0.067724867724868*G0_1_1 - 0.050793650793651*G0_1_2;
    A[419] = -0.135449735449735*G0_0_0 - 0.112874779541446*G0_0_1 - 0.112874779541446*G0_1_0 - 0.135449735449735*G0_1_1;
    A[420] = 0.007760141093474*G0_0_0 + 0.007760141093474*G0_0_1 + 0.007760141093474*G0_0_2 + 0.007760141093474*G0_1_0 + 0.007760141093474*G0_1_1 + 0.007760141093474*G0_1_2;
    A[421] = -0.007760141093474*G0_0_0 + 0.017636684303351*G0_1_0;
    A[422] = 0.045855379188713*G0_0_1 - 0.024691358024691*G0_1_1;
    A[423] = -0.007760141093474*G0_0_2 - 0.007760141093474*G0_1_2;
    A[424] = 0.079012345679012*G0_0_1 + 0.158024691358025*G0_0_2 + 0.101587301587302*G0_1_1 + 0.079012345679012*G0_1_2;
    A[425] = -0.031040564373898*G0_0_1 - 0.090299823633157*G0_0_2 - 0.042328042328042*G0_1_1 - 0.059259259259259*G0_1_2;
    A[426] = 0.011287477954145*G0_0_1 + 0.045149911816579*G0_0_2 + 0.011287477954145*G0_1_1 + 0.033862433862434*G0_1_2;
    A[427] = 0.011287477954145*G0_0_0 + 0.011287477954145*G0_0_2 + 0.033862433862434*G0_1_0 + 0.045149911816578*G0_1_2;
    A[428] = 0.002821869488536*G0_0_0 + 0.002821869488536*G0_0_2 + 0.014109347442681*G0_1_0 + 0.016931216931217*G0_1_2;
    A[429] = 0.011287477954145*G0_0_0 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 + 0.022574955908289*G0_1_2;
    A[430] = 0.045149911816579*G0_0_0 + 0.011287477954145*G0_0_1 - 0.033862433862434*G0_1_0 + 0.045149911816578*G0_1_1;
    A[431] = -0.090299823633157*G0_0_0 - 0.031040564373898*G0_0_1 + 0.042328042328042*G0_1_0 - 0.118518518518518*G0_1_1;
    A[432] = 0.158024691358025*G0_0_0 + 0.079012345679012*G0_0_1 + 0.079012345679012*G0_1_0 + 0.203174603174603*G0_1_1;
    A[433] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_1;
    A[434] = -0.002821869488536*G0_0_0 - 0.002821869488536*G0_0_1 - 0.002821869488536*G0_1_0 - 0.002821869488536*G0_1_1;
    A[435] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_1;
    A[436] = -0.045149911816579*G0_0_0 - 0.033862433862434*G0_0_1 - 0.045149911816579*G0_0_2 - 0.033862433862434*G0_1_0 - 0.022574955908289*G0_1_1 - 0.033862433862434*G0_1_2;
    A[437] = 0.090299823633157*G0_0_0 + 0.059259259259259*G0_0_1 + 0.090299823633157*G0_0_2 + 0.059259259259259*G0_1_0 + 0.016931216931217*G0_1_1 + 0.059259259259259*G0_1_2;
    A[438] = -0.158024691358025*G0_0_0 - 0.079012345679012*G0_0_1 - 0.158024691358025*G0_0_2 - 0.079012345679012*G0_1_0 + 0.022574955908289*G0_1_1 - 0.079012345679012*G0_1_2;
    A[439] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_1 - 0.022574955908289*G0_1_2;
    A[440] = -0.002821869488536*G0_0_1 - 0.002821869488536*G0_0_2 - 0.002821869488536*G0_1_0 - 0.016931216931217*G0_1_1 - 0.016931216931217*G0_1_2;
    A[441] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_1_0 - 0.045149911816578*G0_1_1 - 0.045149911816578*G0_1_2;
    A[442] = -0.022574955908289*G0_0_0 + 0.011287477954145*G0_0_1 - 0.022574955908289*G0_0_2 - 0.033862433862434*G0_1_0 + 0.067724867724868*G0_1_1 - 0.067724867724868*G0_1_2;
    A[443] = 0.112874779541446*G0_0_0 + 0.011287477954145*G0_0_1 + 0.112874779541446*G0_0_2 + 0.101587301587302*G0_1_0 - 0.067724867724868*G0_1_1 + 0.203174603174603*G0_1_2;
    A[444] = -0.022574955908289*G0_0_0 + 0.011287477954145*G0_0_1 - 0.022574955908289*G0_0_2 - 0.033862433862434*G0_1_0 + 0.022574955908289*G0_1_1 - 0.067724867724868*G0_1_2;
    A[445] = 0.022574955908289*G0_0_0 + 0.033862433862434*G0_0_1 + 0.033862433862434*G0_1_0 + 0.045149911816579*G0_1_1;
    A[446] = -0.112874779541446*G0_0_0 - 0.101587301587302*G0_0_1 - 0.101587301587302*G0_1_0 - 0.135449735449735*G0_1_1;
    A[447] = 0.022574955908289*G0_0_0 + 0.033862433862434*G0_0_1 + 0.033862433862434*G0_1_0 + 0.045149911816578*G0_1_1;
    A[448] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_1;
    A[449] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.067724867724868*G0_1_1;
    A[450] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_1;
    A[451] = 0.033862433862434*G0_0_1 + 0.022574955908289*G0_0_2 + 0.033862433862434*G0_1_0 + 0.090299823633157*G0_1_1 + 0.067724867724868*G0_1_2;
    A[452] = 0.033862433862434*G0_0_1 + 0.022574955908289*G0_0_2 + 0.033862433862434*G0_1_0 + 0.135449735449735*G0_1_1 + 0.067724867724868*G0_1_2;
    A[453] = -0.101587301587301*G0_0_1 - 0.112874779541446*G0_0_2 - 0.101587301587301*G0_1_0 - 0.270899470899471*G0_1_1 - 0.203174603174603*G0_1_2;
    A[454] = 0.090299823633157*G0_1_1;
    A[455] = -0.024691358024691*G0_0_0 - 0.024691358024691*G0_0_1 - 0.024691358024691*G0_0_2 - 0.024691358024691*G0_1_0 - 0.024691358024691*G0_1_1 - 0.024691358024691*G0_1_2 - 0.070546737213404*G0_2_0 - 0.070546737213404*G0_2_1 - 0.070546737213404*G0_2_2;
    A[456] = 0.007760141093474*G0_0_0 + 0.007760141093474*G0_1_0;
    A[457] = 0.007760141093474*G0_0_1 + 0.007760141093474*G0_1_1;
    A[458] = -0.017636684303351*G0_0_2 - 0.017636684303351*G0_1_2 - 0.025396825396825*G0_2_2;
    A[459] = -0.022574955908289*G0_0_1 - 0.011287477954145*G0_0_2 - 0.022574955908289*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1;
    A[460] = -0.016931216931217*G0_0_1 - 0.014109347442681*G0_0_2 - 0.016931216931217*G0_1_1 - 0.014109347442681*G0_1_2 - 0.014109347442681*G0_2_1 - 0.011287477954145*G0_2_2;
    A[461] = -0.045149911816578*G0_0_1 - 0.033862433862434*G0_0_2 - 0.045149911816579*G0_1_1 - 0.033862433862434*G0_1_2 - 0.033862433862434*G0_2_1 - 0.022574955908289*G0_2_2;
    A[462] = -0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_2 - 0.022574955908289*G0_1_0 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_0;
    A[463] = -0.016931216931217*G0_0_0 - 0.014109347442681*G0_0_2 - 0.016931216931217*G0_1_0 - 0.014109347442681*G0_1_2 - 0.014109347442681*G0_2_0 - 0.011287477954145*G0_2_2;
    A[464] = -0.045149911816578*G0_0_0 - 0.033862433862434*G0_0_2 - 0.045149911816578*G0_1_0 - 0.033862433862434*G0_1_2 - 0.033862433862434*G0_2_0 - 0.022574955908289*G0_2_2;
    A[465] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_1;
    A[466] = -0.002821869488536*G0_0_0 - 0.002821869488536*G0_0_1 - 0.002821869488536*G0_1_0 - 0.002821869488536*G0_1_1;
    A[467] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_1;
    A[468] = 0.203174603174603*G0_0_0 + 0.203174603174603*G0_0_1 + 0.124162257495591*G0_0_2 + 0.203174603174603*G0_1_0 + 0.203174603174603*G0_1_1 + 0.124162257495591*G0_1_2 + 0.124162257495591*G0_2_0 + 0.124162257495591*G0_2_1 + 0.203174603174603*G0_2_2;
    A[469] = -0.118518518518518*G0_0_0 - 0.118518518518518*G0_0_1 - 0.160846560846561*G0_0_2 - 0.118518518518518*G0_1_0 - 0.118518518518518*G0_1_1 - 0.160846560846561*G0_1_2 - 0.087477954144621*G0_2_0 - 0.087477954144621*G0_2_1 - 0.220105820105820*G0_2_2;
    A[470] = 0.045149911816578*G0_0_0 + 0.045149911816578*G0_0_1 + 0.079012345679012*G0_0_2 + 0.045149911816578*G0_1_0 + 0.045149911816578*G0_1_1 + 0.079012345679012*G0_1_2 + 0.033862433862434*G0_2_0 + 0.033862433862434*G0_2_1 + 0.112874779541446*G0_2_2;
    A[471] = 0.101587301587302*G0_0_0 + 0.022574955908289*G0_0_1 + 0.101587301587302*G0_0_2 + 0.101587301587302*G0_1_0 + 0.022574955908289*G0_1_1 + 0.101587301587301*G0_1_2 + 0.022574955908289*G0_2_0 + 0.101587301587301*G0_2_1 + 0.022574955908289*G0_2_2;
    A[472] = -0.042328042328042*G0_0_0 + 0.016931216931217*G0_0_1 - 0.042328042328042*G0_0_2 - 0.042328042328042*G0_1_0 + 0.016931216931217*G0_1_1 - 0.042328042328042*G0_1_2 - 0.011287477954145*G0_2_0 - 0.042328042328042*G0_2_1 - 0.011287477954145*G0_2_2;
    A[473] = 0.011287477954145*G0_0_0 - 0.022574955908289*G0_0_1 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_1 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_1;
    A[474] = 0.022574955908289*G0_0_0 + 0.101587301587302*G0_0_1 + 0.101587301587302*G0_0_2 + 0.022574955908289*G0_1_0 + 0.101587301587302*G0_1_1 + 0.101587301587302*G0_1_2 + 0.101587301587301*G0_2_0 + 0.022574955908289*G0_2_1 + 0.022574955908289*G0_2_2;
    A[475] = 0.016931216931217*G0_0_0 - 0.042328042328042*G0_0_1 - 0.042328042328042*G0_0_2 + 0.016931216931217*G0_1_0 - 0.042328042328042*G0_1_1 - 0.042328042328042*G0_1_2 - 0.042328042328042*G0_2_0 - 0.011287477954145*G0_2_1 - 0.011287477954145*G0_2_2;
    A[476] = -0.022574955908289*G0_0_0 + 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 - 0.022574955908289*G0_1_0 + 0.011287477954145*G0_1_1 + 0.011287477954145*G0_1_2 + 0.011287477954144*G0_2_0;
    A[477] = -0.022574955908289*G0_0_0 - 0.022574955908289*G0_0_1 - 0.011287477954145*G0_0_2 - 0.022574955908289*G0_1_0 - 0.022574955908289*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_1;
    A[478] = -0.022574955908289*G0_0_0 - 0.022574955908289*G0_0_1 - 0.011287477954145*G0_0_2 - 0.022574955908289*G0_1_0 - 0.022574955908289*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_1;
    A[479] = -0.067724867724868*G0_0_0 - 0.067724867724867*G0_0_1 - 0.056437389770723*G0_0_2 - 0.067724867724868*G0_1_0 - 0.067724867724867*G0_1_1 - 0.056437389770723*G0_1_2 - 0.056437389770723*G0_2_0 - 0.056437389770723*G0_2_1 - 0.045149911816578*G0_2_2;
    A[480] = -0.067724867724868*G0_0_0 - 0.270899470899471*G0_0_1 - 0.169312169312169*G0_0_2 - 0.067724867724868*G0_1_0 - 0.270899470899471*G0_1_1 - 0.169312169312169*G0_1_2 - 0.079012345679013*G0_2_0 - 0.169312169312169*G0_2_1 - 0.067724867724868*G0_2_2;
    A[481] = 0.022574955908289*G0_0_0 + 0.090299823633157*G0_0_1 + 0.056437389770723*G0_0_2 + 0.022574955908289*G0_1_0 + 0.090299823633157*G0_1_1 + 0.056437389770723*G0_1_2 + 0.011287477954145*G0_2_0 + 0.056437389770723*G0_2_1 + 0.022574955908289*G0_2_2;
    A[482] = 0.067724867724868*G0_0_0 + 0.135449735449735*G0_0_1 + 0.101587301587302*G0_0_2 + 0.067724867724868*G0_1_0 + 0.135449735449735*G0_1_1 + 0.101587301587302*G0_1_2 + 0.056437389770723*G0_2_0 + 0.101587301587302*G0_2_1 + 0.067724867724868*G0_2_2;
    A[483] = -0.270899470899471*G0_0_0 - 0.067724867724868*G0_0_1 - 0.169312169312169*G0_0_2 - 0.270899470899471*G0_1_0 - 0.067724867724868*G0_1_1 - 0.169312169312169*G0_1_2 - 0.169312169312169*G0_2_0 - 0.079012345679013*G0_2_1 - 0.067724867724868*G0_2_2;
    A[484] = 0.090299823633157*G0_0_0 + 0.022574955908289*G0_0_1 + 0.056437389770723*G0_0_2 + 0.090299823633157*G0_1_0 + 0.022574955908289*G0_1_1 + 0.056437389770723*G0_1_2 + 0.056437389770723*G0_2_0 + 0.011287477954145*G0_2_1 + 0.022574955908289*G0_2_2;
    A[485] = 0.135449735449735*G0_0_0 + 0.067724867724868*G0_0_1 + 0.101587301587302*G0_0_2 + 0.135449735449735*G0_1_0 + 0.067724867724868*G0_1_1 + 0.101587301587302*G0_1_2 + 0.101587301587301*G0_2_0 + 0.056437389770723*G0_2_1 + 0.067724867724868*G0_2_2;
    A[486] = -0.135449735449735*G0_0_0 - 0.135449735449736*G0_0_1 - 0.033862433862434*G0_0_2 - 0.135449735449735*G0_1_0 - 0.135449735449735*G0_1_1 - 0.033862433862434*G0_1_2 - 0.033862433862434*G0_2_0 - 0.033862433862434*G0_2_1 - 0.045149911816579*G0_2_2;
    A[487] = 0.045149911816579*G0_0_0 + 0.045149911816578*G0_0_1 + 0.011287477954145*G0_0_2 + 0.045149911816578*G0_1_0 + 0.045149911816578*G0_1_1 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_1;
    A[488] = 0.045149911816579*G0_0_0 + 0.045149911816579*G0_0_1 + 0.011287477954145*G0_0_2 + 0.045149911816579*G0_1_0 + 0.045149911816579*G0_1_1 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_1;
    A[489] = 0.090299823633157*G0_0_0 + 0.090299823633157*G0_0_1 + 0.090299823633157*G0_0_2 + 0.090299823633157*G0_1_0 + 0.090299823633157*G0_1_1 + 0.090299823633157*G0_1_2 + 0.090299823633157*G0_2_0 + 0.090299823633157*G0_2_1 + 0.090299823633157*G0_2_2;
    A[490] = 0.020282186948854*G0_0_0 + 0.020282186948854*G0_0_1 + 0.020282186948854*G0_0_2 + 0.020282186948854*G0_1_0 + 0.020282186948854*G0_1_1 + 0.020282186948854*G0_1_2 + 0.052910052910053*G0_2_0 + 0.052910052910053*G0_2_1 + 0.052910052910053*G0_2_2;
    A[491] = 0.005114638447972*G0_0_0 + 0.005114638447972*G0_1_0;
    A[492] = 0.005114638447972*G0_0_1 + 0.005114638447972*G0_1_1;
    A[493] = 0.032627865961199*G0_0_2 + 0.032627865961199*G0_1_2 + 0.052910052910053*G0_2_2;
    A[494] = -0.016931216931217*G0_0_1 - 0.002821869488536*G0_0_2 - 0.016931216931217*G0_1_1 - 0.002821869488536*G0_1_2 - 0.002821869488536*G0_2_1;
    A[495] = 0.021164021164021*G0_0_1 + 0.010582010582011*G0_0_2 + 0.021164021164021*G0_1_1 + 0.010582010582011*G0_1_2 + 0.010582010582011*G0_2_1 - 0.002821869488536*G0_2_2;
    A[496] = 0.090299823633157*G0_0_1 + 0.059259259259259*G0_0_2 + 0.090299823633157*G0_1_1 + 0.059259259259259*G0_1_2 + 0.059259259259259*G0_2_1 + 0.016931216931217*G0_2_2;
    A[497] = -0.016931216931217*G0_0_0 - 0.002821869488536*G0_0_2 - 0.016931216931217*G0_1_0 - 0.002821869488536*G0_1_2 - 0.002821869488536*G0_2_0;
    A[498] = 0.021164021164021*G0_0_0 + 0.010582010582010*G0_0_2 + 0.021164021164021*G0_1_0 + 0.010582010582010*G0_1_2 + 0.010582010582011*G0_2_0 - 0.002821869488536*G0_2_2;
    A[499] = 0.090299823633157*G0_0_0 + 0.059259259259259*G0_0_2 + 0.090299823633157*G0_1_0 + 0.059259259259259*G0_1_2 + 0.059259259259259*G0_2_0 + 0.016931216931217*G0_2_2;
    A[500] = -0.002821869488536*G0_0_0 - 0.002821869488536*G0_0_1 - 0.002821869488536*G0_1_0 - 0.002821869488536*G0_1_1;
    A[501] = -0.009171075837742*G0_0_0 - 0.009171075837742*G0_0_1 - 0.009171075837742*G0_1_0 - 0.009171075837743*G0_1_1;
    A[502] = -0.002821869488536*G0_0_0 - 0.002821869488536*G0_0_1 - 0.002821869488536*G0_1_0 - 0.002821869488536*G0_1_1;
    A[503] = -0.118518518518518*G0_0_0 - 0.118518518518518*G0_0_1 - 0.087477954144621*G0_0_2 - 0.118518518518518*G0_1_0 - 0.118518518518518*G0_1_1 - 0.087477954144621*G0_1_2 - 0.160846560846561*G0_2_0 - 0.160846560846561*G0_2_1 - 0.220105820105820*G0_2_2;
    A[504] = 0.249735449735449*G0_0_0 + 0.249735449735449*G0_0_1 + 0.167195767195767*G0_0_2 + 0.249735449735449*G0_1_0 + 0.249735449735449*G0_1_1 + 0.167195767195767*G0_1_2 + 0.167195767195767*G0_2_0 + 0.167195767195767*G0_2_1 + 0.334391534391534*G0_2_2;
    A[505] = -0.090299823633157*G0_0_0 - 0.090299823633157*G0_0_1 - 0.132627865961199*G0_0_2 - 0.090299823633157*G0_1_0 - 0.090299823633157*G0_1_1 - 0.132627865961199*G0_1_2 - 0.059259259259259*G0_2_0 - 0.059259259259259*G0_2_1 - 0.220105820105820*G0_2_2;
    A[506] = -0.042328042328042*G0_0_0 - 0.011287477954145*G0_0_1 - 0.042328042328042*G0_0_2 - 0.042328042328042*G0_1_0 - 0.011287477954145*G0_1_1 - 0.042328042328042*G0_1_2 + 0.016931216931217*G0_2_0 - 0.042328042328042*G0_2_1 + 0.016931216931217*G0_2_2;
    A[507] = -0.013403880070547*G0_0_0 - 0.002821869488536*G0_0_1 - 0.013403880070547*G0_0_2 - 0.013403880070547*G0_1_0 - 0.002821869488536*G0_1_1 - 0.013403880070547*G0_1_2 - 0.002821869488536*G0_2_0 - 0.013403880070547*G0_2_1 - 0.002821869488536*G0_2_2;
    A[508] = 0.002821869488536*G0_0_0 - 0.011287477954145*G0_0_1 + 0.002821869488536*G0_0_2 + 0.002821869488536*G0_1_0 - 0.011287477954145*G0_1_1 + 0.002821869488536*G0_1_2 + 0.002821869488536*G0_2_1;
    A[509] = -0.011287477954145*G0_0_0 - 0.042328042328042*G0_0_1 - 0.042328042328042*G0_0_2 - 0.011287477954145*G0_1_0 - 0.042328042328042*G0_1_1 - 0.042328042328042*G0_1_2 - 0.042328042328042*G0_2_0 + 0.016931216931217*G0_2_1 + 0.016931216931217*G0_2_2;
    A[510] = -0.002821869488536*G0_0_0 - 0.013403880070547*G0_0_1 - 0.013403880070547*G0_0_2 - 0.002821869488536*G0_1_0 - 0.013403880070547*G0_1_1 - 0.013403880070547*G0_1_2 - 0.013403880070547*G0_2_0 - 0.002821869488536*G0_2_1 - 0.002821869488536*G0_2_2;
    A[511] = -0.011287477954145*G0_0_0 + 0.002821869488536*G0_0_1 + 0.002821869488536*G0_0_2 - 0.011287477954145*G0_1_0 + 0.002821869488536*G0_1_1 + 0.002821869488536*G0_1_2 + 0.002821869488536*G0_2_0;
    A[512] = 0.016931216931217*G0_0_0 + 0.016931216931217*G0_0_1 - 0.002821869488536*G0_0_2 + 0.016931216931217*G0_1_0 + 0.016931216931217*G0_1_1 - 0.002821869488536*G0_1_2 - 0.002821869488536*G0_2_0 - 0.002821869488536*G0_2_1;
    A[513] = 0.016931216931217*G0_0_0 + 0.016931216931217*G0_0_1 - 0.002821869488536*G0_0_2 + 0.016931216931217*G0_1_0 + 0.016931216931217*G0_1_1 - 0.002821869488536*G0_1_2 - 0.002821869488536*G0_2_0 - 0.002821869488536*G0_2_1;
    A[514] = 0.084656084656085*G0_0_0 + 0.084656084656084*G0_0_1 + 0.042328042328042*G0_0_2 + 0.084656084656085*G0_1_0 + 0.084656084656084*G0_1_1 + 0.042328042328042*G0_1_2 + 0.042328042328042*G0_2_0 + 0.042328042328042*G0_2_1 + 0.022574955908289*G0_2_2;
    A[515] = 0.118518518518518*G0_0_0 + 0.067724867724868*G0_0_1 + 0.160846560846560*G0_0_2 + 0.118518518518518*G0_1_0 + 0.067724867724868*G0_1_1 + 0.160846560846561*G0_1_2 + 0.025396825396826*G0_2_0 + 0.160846560846561*G0_2_1 - 0.016931216931217*G0_2_2;
    A[516] = -0.016931216931217*G0_0_0 + 0.067724867724868*G0_0_1 + 0.002821869488536*G0_0_2 - 0.016931216931217*G0_1_0 + 0.067724867724868*G0_1_1 + 0.002821869488536*G0_1_2 + 0.002821869488536*G0_2_0 + 0.002821869488536*G0_2_1 + 0.005643738977072*G0_2_2;
    A[517] = -0.084656084656085*G0_0_0 - 0.270899470899471*G0_0_1 - 0.177777777777778*G0_0_2 - 0.084656084656085*G0_1_0 - 0.270899470899471*G0_1_1 - 0.177777777777778*G0_1_2 - 0.042328042328042*G0_2_0 - 0.177777777777778*G0_2_1 - 0.016931216931217*G0_2_2;
    A[518] = 0.067724867724868*G0_0_0 + 0.118518518518518*G0_0_1 + 0.160846560846560*G0_0_2 + 0.067724867724868*G0_1_0 + 0.118518518518518*G0_1_1 + 0.160846560846560*G0_1_2 + 0.160846560846561*G0_2_0 + 0.025396825396826*G0_2_1 - 0.016931216931217*G0_2_2;
    A[519] = 0.067724867724868*G0_0_0 - 0.016931216931217*G0_0_1 + 0.002821869488536*G0_0_2 + 0.067724867724868*G0_1_0 - 0.016931216931217*G0_1_1 + 0.002821869488536*G0_1_2 + 0.002821869488536*G0_2_0 + 0.002821869488536*G0_2_1 + 0.005643738977072*G0_2_2;
    A[520] = -0.270899470899470*G0_0_0 - 0.084656084656084*G0_0_1 - 0.177777777777777*G0_0_2 - 0.270899470899470*G0_1_0 - 0.084656084656084*G0_1_1 - 0.177777777777777*G0_1_2 - 0.177777777777777*G0_2_0 - 0.042328042328042*G0_2_1 - 0.016931216931217*G0_2_2;
    A[521] = 0.022574955908289*G0_0_0 + 0.022574955908289*G0_0_1 - 0.019753086419753*G0_0_2 + 0.022574955908289*G0_1_0 + 0.022574955908289*G0_1_1 - 0.019753086419753*G0_1_2 - 0.019753086419753*G0_2_0 - 0.019753086419753*G0_2_1 + 0.022574955908289*G0_2_2;
    A[522] = 0.022574955908289*G0_0_0 + 0.022574955908289*G0_0_1 + 0.002821869488536*G0_0_2 + 0.022574955908289*G0_1_0 + 0.022574955908289*G0_1_1 + 0.002821869488536*G0_1_2 + 0.002821869488536*G0_2_0 + 0.002821869488536*G0_2_1;
    A[523] = 0.022574955908289*G0_0_0 + 0.022574955908289*G0_0_1 + 0.002821869488536*G0_0_2 + 0.022574955908289*G0_1_0 + 0.022574955908289*G0_1_1 + 0.002821869488536*G0_1_2 + 0.002821869488536*G0_2_0 + 0.002821869488536*G0_2_1;
    A[524] = -0.135449735449735*G0_0_0 - 0.135449735449735*G0_0_1 - 0.022574955908289*G0_0_2 - 0.135449735449735*G0_1_0 - 0.135449735449735*G0_1_1 - 0.022574955908289*G0_1_2 - 0.022574955908290*G0_2_0 - 0.022574955908289*G0_2_1 - 0.045149911816579*G0_2_2;
    A[525] = -0.007760141093474*G0_0_0 - 0.007760141093474*G0_0_1 - 0.007760141093474*G0_0_2 - 0.007760141093474*G0_1_0 - 0.007760141093474*G0_1_1 - 0.007760141093474*G0_1_2 - 0.025396825396825*G0_2_0 - 0.025396825396825*G0_2_1 - 0.025396825396825*G0_2_2;
    A[526] = 0.007760141093474*G0_0_0 + 0.007760141093474*G0_1_0;
    A[527] = 0.007760141093474*G0_0_1 + 0.007760141093474*G0_1_1;
    A[528] = -0.045855379188712*G0_0_2 - 0.045855379188712*G0_1_2 - 0.070546737213404*G0_2_2;
    A[529] = -0.045149911816578*G0_0_1 - 0.011287477954145*G0_0_2 - 0.045149911816578*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1;
    A[530] = 0.090299823633157*G0_0_1 + 0.031040564373898*G0_0_2 + 0.090299823633157*G0_1_1 + 0.031040564373898*G0_1_2 + 0.031040564373898*G0_2_1 - 0.011287477954145*G0_2_2;
    A[531] = -0.158024691358025*G0_0_1 - 0.079012345679012*G0_0_2 - 0.158024691358025*G0_1_1 - 0.079012345679012*G0_1_2 - 0.079012345679012*G0_2_1 + 0.022574955908289*G0_2_2;
    A[532] = -0.045149911816579*G0_0_0 - 0.011287477954145*G0_0_2 - 0.045149911816578*G0_1_0 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_0;
    A[533] = 0.090299823633157*G0_0_0 + 0.031040564373898*G0_0_2 + 0.090299823633157*G0_1_0 + 0.031040564373898*G0_1_2 + 0.031040564373898*G0_2_0 - 0.011287477954145*G0_2_2;
    A[534] = -0.158024691358024*G0_0_0 - 0.079012345679012*G0_0_2 - 0.158024691358024*G0_1_0 - 0.079012345679012*G0_1_2 - 0.079012345679012*G0_2_0 + 0.022574955908289*G0_2_2;
    A[535] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_1;
    A[536] = -0.002821869488536*G0_0_0 - 0.002821869488536*G0_0_1 - 0.002821869488536*G0_1_0 - 0.002821869488536*G0_1_1;
    A[537] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_1;
    A[538] = 0.045149911816578*G0_0_0 + 0.045149911816578*G0_0_1 + 0.033862433862434*G0_0_2 + 0.045149911816578*G0_1_0 + 0.045149911816578*G0_1_1 + 0.033862433862434*G0_1_2 + 0.079012345679012*G0_2_0 + 0.079012345679012*G0_2_1 + 0.112874779541446*G0_2_2;
    A[539] = -0.090299823633157*G0_0_0 - 0.090299823633157*G0_0_1 - 0.059259259259259*G0_0_2 - 0.090299823633157*G0_1_0 - 0.090299823633157*G0_1_1 - 0.059259259259259*G0_1_2 - 0.132627865961199*G0_2_0 - 0.132627865961199*G0_2_1 - 0.220105820105820*G0_2_2;
    A[540] = 0.158024691358024*G0_0_0 + 0.158024691358024*G0_0_1 + 0.079012345679012*G0_0_2 + 0.158024691358024*G0_1_0 + 0.158024691358024*G0_1_1 + 0.079012345679012*G0_1_2 + 0.079012345679012*G0_2_0 + 0.079012345679012*G0_2_1 + 0.203174603174603*G0_2_2;
    A[541] = 0.011287477954145*G0_0_0 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_2 - 0.022574955908289*G0_2_0 + 0.011287477954145*G0_2_1 - 0.022574955908289*G0_2_2;
    A[542] = 0.002821869488536*G0_0_0 + 0.002821869488536*G0_0_2 + 0.002821869488536*G0_1_0 + 0.002821869488536*G0_1_2 - 0.011287477954145*G0_2_0 + 0.002821869488536*G0_2_1 - 0.011287477954145*G0_2_2;
    A[543] = 0.011287477954145*G0_0_0 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_1;
    A[544] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_1 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_0 - 0.022574955908289*G0_2_1 - 0.022574955908289*G0_2_2;
    A[545] = 0.002821869488536*G0_0_1 + 0.002821869488536*G0_0_2 + 0.002821869488536*G0_1_1 + 0.002821869488536*G0_1_2 + 0.002821869488536*G0_2_0 - 0.011287477954145*G0_2_1 - 0.011287477954145*G0_2_2;
    A[546] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_1 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_0;
    A[547] = 0.022574955908289*G0_0_0 + 0.022574955908289*G0_0_1 - 0.011287477954145*G0_0_2 + 0.022574955908289*G0_1_0 + 0.022574955908289*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_1;
    A[548] = 0.022574955908289*G0_0_0 + 0.022574955908289*G0_0_1 - 0.011287477954145*G0_0_2 + 0.022574955908289*G0_1_0 + 0.022574955908289*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_1;
    A[549] = -0.112874779541446*G0_0_0 - 0.112874779541446*G0_0_1 - 0.011287477954145*G0_0_2 - 0.112874779541446*G0_1_0 - 0.112874779541446*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_0 - 0.011287477954144*G0_2_1 - 0.045149911816578*G0_2_2;
    A[550] = -0.022574955908289*G0_0_0 - 0.033862433862434*G0_0_2 - 0.022574955908289*G0_1_0 - 0.033862433862434*G0_1_2 + 0.011287477954145*G0_2_0 - 0.033862433862434*G0_2_1 + 0.067724867724868*G0_2_2;
    A[551] = -0.022574955908289*G0_0_0 - 0.033862433862434*G0_0_2 - 0.022574955908289*G0_1_0 - 0.033862433862434*G0_1_2 + 0.011287477954145*G0_2_0 - 0.033862433862434*G0_2_1 + 0.022574955908289*G0_2_2;
    A[552] = 0.112874779541446*G0_0_0 + 0.101587301587302*G0_0_2 + 0.112874779541446*G0_1_0 + 0.101587301587302*G0_1_2 + 0.011287477954145*G0_2_0 + 0.101587301587301*G0_2_1 - 0.067724867724867*G0_2_2;
    A[553] = -0.022574955908289*G0_0_1 - 0.033862433862434*G0_0_2 - 0.022574955908289*G0_1_1 - 0.033862433862434*G0_1_2 - 0.033862433862434*G0_2_0 + 0.011287477954145*G0_2_1 + 0.067724867724867*G0_2_2;
    A[554] = -0.022574955908289*G0_0_1 - 0.033862433862434*G0_0_2 - 0.022574955908289*G0_1_1 - 0.033862433862434*G0_1_2 - 0.033862433862434*G0_2_0 + 0.011287477954145*G0_2_1 + 0.022574955908289*G0_2_2;
    A[555] = 0.112874779541446*G0_0_1 + 0.101587301587301*G0_0_2 + 0.112874779541446*G0_1_1 + 0.101587301587302*G0_1_2 + 0.101587301587301*G0_2_0 + 0.011287477954144*G0_2_1 - 0.067724867724868*G0_2_2;
    A[556] = 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_2 + 0.011287477954144*G0_2_0 + 0.011287477954145*G0_2_1 - 0.045149911816578*G0_2_2;
    A[557] = 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_1;
    A[558] = 0.011287477954144*G0_0_2 + 0.011287477954144*G0_1_2 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_1;
    A[559] = 0.090299823633157*G0_2_2;
    A[560] = -0.024691358024691*G0_0_0 - 0.024691358024691*G0_0_1 - 0.024691358024691*G0_0_2 - 0.070546737213404*G0_1_0 - 0.070546737213404*G0_1_1 - 0.070546737213404*G0_1_2 - 0.024691358024691*G0_2_0 - 0.024691358024691*G0_2_1 - 0.024691358024691*G0_2_2;
    A[561] = 0.007760141093474*G0_0_0 + 0.007760141093474*G0_2_0;
    A[562] = -0.017636684303351*G0_0_1 - 0.025396825396825*G0_1_1 - 0.017636684303351*G0_2_1;
    A[563] = 0.007760141093474*G0_0_2 + 0.007760141093474*G0_2_2;
    A[564] = -0.033862433862434*G0_0_1 - 0.045149911816579*G0_0_2 - 0.022574955908289*G0_1_1 - 0.033862433862434*G0_1_2 - 0.033862433862434*G0_2_1 - 0.045149911816579*G0_2_2;
    A[565] = -0.014109347442681*G0_0_1 - 0.016931216931217*G0_0_2 - 0.011287477954145*G0_1_1 - 0.014109347442681*G0_1_2 - 0.014109347442681*G0_2_1 - 0.016931216931217*G0_2_2;
    A[566] = -0.011287477954145*G0_0_1 - 0.022574955908289*G0_0_2 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1 - 0.022574955908289*G0_2_2;
    A[567] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_2;
    A[568] = -0.002821869488536*G0_0_0 - 0.002821869488536*G0_0_2 - 0.002821869488536*G0_2_0 - 0.002821869488536*G0_2_2;
    A[569] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_2;
    A[570] = -0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.022574955908289*G0_2_0 - 0.011287477954145*G0_2_1;
    A[571] = -0.016931216931217*G0_0_0 - 0.014109347442681*G0_0_1 - 0.014109347442681*G0_1_0 - 0.011287477954145*G0_1_1 - 0.016931216931217*G0_2_0 - 0.014109347442681*G0_2_1;
    A[572] = -0.045149911816579*G0_0_0 - 0.033862433862434*G0_0_1 - 0.033862433862434*G0_1_0 - 0.022574955908289*G0_1_1 - 0.045149911816579*G0_2_0 - 0.033862433862434*G0_2_1;
    A[573] = 0.101587301587302*G0_0_0 + 0.101587301587302*G0_0_1 + 0.022574955908289*G0_0_2 + 0.022574955908289*G0_1_0 + 0.022574955908289*G0_1_1 + 0.101587301587301*G0_1_2 + 0.101587301587302*G0_2_0 + 0.101587301587301*G0_2_1 + 0.022574955908289*G0_2_2;
    A[574] = -0.042328042328042*G0_0_0 - 0.042328042328042*G0_0_1 + 0.016931216931217*G0_0_2 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_1 - 0.042328042328042*G0_1_2 - 0.042328042328042*G0_2_0 - 0.042328042328042*G0_2_1 + 0.016931216931217*G0_2_2;
    A[575] = 0.011287477954145*G0_0_0 + 0.011287477954145*G0_0_1 - 0.022574955908289*G0_0_2 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_1 - 0.022574955908289*G0_2_2;
    A[576] = 0.203174603174603*G0_0_0 + 0.124162257495591*G0_0_1 + 0.203174603174603*G0_0_2 + 0.124162257495591*G0_1_0 + 0.203174603174603*G0_1_1 + 0.124162257495591*G0_1_2 + 0.203174603174603*G0_2_0 + 0.124162257495591*G0_2_1 + 0.203174603174603*G0_2_2;
    A[577] = -0.118518518518519*G0_0_0 - 0.160846560846561*G0_0_1 - 0.118518518518519*G0_0_2 - 0.087477954144621*G0_1_0 - 0.220105820105820*G0_1_1 - 0.087477954144621*G0_1_2 - 0.118518518518519*G0_2_0 - 0.160846560846561*G0_2_1 - 0.118518518518519*G0_2_2;
    A[578] = 0.045149911816579*G0_0_0 + 0.079012345679012*G0_0_1 + 0.045149911816579*G0_0_2 + 0.033862433862434*G0_1_0 + 0.112874779541446*G0_1_1 + 0.033862433862434*G0_1_2 + 0.045149911816579*G0_2_0 + 0.079012345679012*G0_2_1 + 0.045149911816579*G0_2_2;
    A[579] = 0.022574955908289*G0_0_0 + 0.101587301587302*G0_0_1 + 0.101587301587302*G0_0_2 + 0.101587301587301*G0_1_0 + 0.022574955908289*G0_1_1 + 0.022574955908289*G0_1_2 + 0.022574955908289*G0_2_0 + 0.101587301587302*G0_2_1 + 0.101587301587302*G0_2_2;
    A[580] = 0.016931216931217*G0_0_0 - 0.042328042328042*G0_0_1 - 0.042328042328042*G0_0_2 - 0.042328042328042*G0_1_0 - 0.011287477954145*G0_1_1 - 0.011287477954145*G0_1_2 + 0.016931216931217*G0_2_0 - 0.042328042328042*G0_2_1 - 0.042328042328042*G0_2_2;
    A[581] = -0.022574955908289*G0_0_0 + 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 - 0.022574955908289*G0_2_0 + 0.011287477954145*G0_2_1 + 0.011287477954145*G0_2_2;
    A[582] = -0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_1 - 0.022574955908289*G0_0_2 - 0.011287477954145*G0_1_0 - 0.011287477954144*G0_1_2 - 0.022574955908289*G0_2_0 - 0.011287477954145*G0_2_1 - 0.022574955908289*G0_2_2;
    A[583] = -0.067724867724868*G0_0_0 - 0.056437389770723*G0_0_1 - 0.067724867724868*G0_0_2 - 0.056437389770723*G0_1_0 - 0.045149911816578*G0_1_1 - 0.056437389770723*G0_1_2 - 0.067724867724868*G0_2_0 - 0.056437389770723*G0_2_1 - 0.067724867724868*G0_2_2;
    A[584] = -0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_1 - 0.022574955908289*G0_0_2 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_2 - 0.022574955908289*G0_2_0 - 0.011287477954145*G0_2_1 - 0.022574955908289*G0_2_2;
    A[585] = -0.067724867724868*G0_0_0 - 0.169312169312169*G0_0_1 - 0.270899470899471*G0_0_2 - 0.079012345679013*G0_1_0 - 0.067724867724868*G0_1_1 - 0.169312169312169*G0_1_2 - 0.067724867724868*G0_2_0 - 0.169312169312169*G0_2_1 - 0.270899470899471*G0_2_2;
    A[586] = 0.067724867724868*G0_0_0 + 0.101587301587302*G0_0_1 + 0.135449735449736*G0_0_2 + 0.056437389770723*G0_1_0 + 0.067724867724868*G0_1_1 + 0.101587301587302*G0_1_2 + 0.067724867724868*G0_2_0 + 0.101587301587302*G0_2_1 + 0.135449735449736*G0_2_2;
    A[587] = 0.022574955908289*G0_0_0 + 0.056437389770723*G0_0_1 + 0.090299823633157*G0_0_2 + 0.011287477954145*G0_1_0 + 0.022574955908289*G0_1_1 + 0.056437389770723*G0_1_2 + 0.022574955908289*G0_2_0 + 0.056437389770723*G0_2_1 + 0.090299823633157*G0_2_2;
    A[588] = -0.135449735449735*G0_0_0 - 0.033862433862434*G0_0_1 - 0.135449735449735*G0_0_2 - 0.033862433862434*G0_1_0 - 0.045149911816579*G0_1_1 - 0.033862433862434*G0_1_2 - 0.135449735449735*G0_2_0 - 0.033862433862434*G0_2_1 - 0.135449735449735*G0_2_2;
    A[589] = 0.045149911816578*G0_0_0 + 0.011287477954145*G0_0_1 + 0.045149911816578*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_2 + 0.045149911816578*G0_2_0 + 0.011287477954145*G0_2_1 + 0.045149911816578*G0_2_2;
    A[590] = 0.045149911816578*G0_0_0 + 0.011287477954145*G0_0_1 + 0.045149911816578*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_2 + 0.045149911816578*G0_2_0 + 0.011287477954145*G0_2_1 + 0.045149911816578*G0_2_2;
    A[591] = -0.270899470899471*G0_0_0 - 0.169312169312169*G0_0_1 - 0.067724867724868*G0_0_2 - 0.169312169312169*G0_1_0 - 0.067724867724868*G0_1_1 - 0.079012345679013*G0_1_2 - 0.270899470899471*G0_2_0 - 0.169312169312169*G0_2_1 - 0.067724867724868*G0_2_2;
    A[592] = 0.090299823633157*G0_0_0 + 0.056437389770723*G0_0_1 + 0.022574955908289*G0_0_2 + 0.056437389770723*G0_1_0 + 0.022574955908289*G0_1_1 + 0.011287477954144*G0_1_2 + 0.090299823633157*G0_2_0 + 0.056437389770723*G0_2_1 + 0.022574955908289*G0_2_2;
    A[593] = 0.135449735449736*G0_0_0 + 0.101587301587302*G0_0_1 + 0.067724867724868*G0_0_2 + 0.101587301587302*G0_1_0 + 0.067724867724868*G0_1_1 + 0.056437389770723*G0_1_2 + 0.135449735449735*G0_2_0 + 0.101587301587302*G0_2_1 + 0.067724867724868*G0_2_2;
    A[594] = 0.090299823633157*G0_0_0 + 0.090299823633157*G0_0_1 + 0.090299823633157*G0_0_2 + 0.090299823633157*G0_1_0 + 0.090299823633157*G0_1_1 + 0.090299823633157*G0_1_2 + 0.090299823633157*G0_2_0 + 0.090299823633157*G0_2_1 + 0.090299823633157*G0_2_2;
    A[595] = 0.020282186948854*G0_0_0 + 0.020282186948854*G0_0_1 + 0.020282186948854*G0_0_2 + 0.052910052910053*G0_1_0 + 0.052910052910053*G0_1_1 + 0.052910052910053*G0_1_2 + 0.020282186948854*G0_2_0 + 0.020282186948854*G0_2_1 + 0.020282186948854*G0_2_2;
    A[596] = 0.005114638447972*G0_0_0 + 0.005114638447972*G0_2_0;
    A[597] = 0.032627865961199*G0_0_1 + 0.052910052910053*G0_1_1 + 0.032627865961199*G0_2_1;
    A[598] = 0.005114638447972*G0_0_2 + 0.005114638447972*G0_2_2;
    A[599] = 0.059259259259259*G0_0_1 + 0.090299823633157*G0_0_2 + 0.016931216931217*G0_1_1 + 0.059259259259259*G0_1_2 + 0.059259259259259*G0_2_1 + 0.090299823633157*G0_2_2;
    A[600] = 0.010582010582011*G0_0_1 + 0.021164021164021*G0_0_2 - 0.002821869488536*G0_1_1 + 0.010582010582010*G0_1_2 + 0.010582010582011*G0_2_1 + 0.021164021164021*G0_2_2;
    A[601] = -0.002821869488536*G0_0_1 - 0.016931216931217*G0_0_2 - 0.002821869488536*G0_1_2 - 0.002821869488536*G0_2_1 - 0.016931216931217*G0_2_2;
    A[602] = -0.002821869488536*G0_0_0 - 0.002821869488536*G0_0_2 - 0.002821869488536*G0_2_0 - 0.002821869488536*G0_2_2;
    A[603] = -0.009171075837742*G0_0_0 - 0.009171075837742*G0_0_2 - 0.009171075837742*G0_2_0 - 0.009171075837742*G0_2_2;
    A[604] = -0.002821869488536*G0_0_0 - 0.002821869488536*G0_0_2 - 0.002821869488536*G0_2_0 - 0.002821869488536*G0_2_2;
    A[605] = -0.016931216931217*G0_0_0 - 0.002821869488536*G0_0_1 - 0.002821869488536*G0_1_0 - 0.016931216931217*G0_2_0 - 0.002821869488536*G0_2_1;
    A[606] = 0.021164021164021*G0_0_0 + 0.010582010582010*G0_0_1 + 0.010582010582010*G0_1_0 - 0.002821869488536*G0_1_1 + 0.021164021164021*G0_2_0 + 0.010582010582010*G0_2_1;
    A[607] = 0.090299823633157*G0_0_0 + 0.059259259259259*G0_0_1 + 0.059259259259259*G0_1_0 + 0.016931216931217*G0_1_1 + 0.090299823633157*G0_2_0 + 0.059259259259259*G0_2_1;
    A[608] = -0.042328042328042*G0_0_0 - 0.042328042328042*G0_0_1 - 0.011287477954145*G0_0_2 + 0.016931216931217*G0_1_0 + 0.016931216931217*G0_1_1 - 0.042328042328042*G0_1_2 - 0.042328042328042*G0_2_0 - 0.042328042328042*G0_2_1 - 0.011287477954145*G0_2_2;
    A[609] = -0.013403880070547*G0_0_0 - 0.013403880070547*G0_0_1 - 0.002821869488536*G0_0_2 - 0.002821869488536*G0_1_0 - 0.002821869488536*G0_1_1 - 0.013403880070547*G0_1_2 - 0.013403880070547*G0_2_0 - 0.013403880070547*G0_2_1 - 0.002821869488536*G0_2_2;
    A[610] = 0.002821869488536*G0_0_0 + 0.002821869488536*G0_0_1 - 0.011287477954145*G0_0_2 + 0.002821869488536*G0_1_2 + 0.002821869488536*G0_2_0 + 0.002821869488536*G0_2_1 - 0.011287477954145*G0_2_2;
    A[611] = -0.118518518518519*G0_0_0 - 0.087477954144621*G0_0_1 - 0.118518518518519*G0_0_2 - 0.160846560846561*G0_1_0 - 0.220105820105820*G0_1_1 - 0.160846560846561*G0_1_2 - 0.118518518518519*G0_2_0 - 0.087477954144621*G0_2_1 - 0.118518518518519*G0_2_2;
    A[612] = 0.249735449735450*G0_0_0 + 0.167195767195767*G0_0_1 + 0.249735449735450*G0_0_2 + 0.167195767195767*G0_1_0 + 0.334391534391534*G0_1_1 + 0.167195767195767*G0_1_2 + 0.249735449735450*G0_2_0 + 0.167195767195767*G0_2_1 + 0.249735449735450*G0_2_2;
    A[613] = -0.090299823633157*G0_0_0 - 0.132627865961199*G0_0_1 - 0.090299823633157*G0_0_2 - 0.059259259259259*G0_1_0 - 0.220105820105820*G0_1_1 - 0.059259259259259*G0_1_2 - 0.090299823633157*G0_2_0 - 0.132627865961199*G0_2_1 - 0.090299823633157*G0_2_2;
    A[614] = -0.011287477954145*G0_0_0 - 0.042328042328042*G0_0_1 - 0.042328042328042*G0_0_2 - 0.042328042328042*G0_1_0 + 0.016931216931217*G0_1_1 + 0.016931216931217*G0_1_2 - 0.011287477954145*G0_2_0 - 0.042328042328042*G0_2_1 - 0.042328042328042*G0_2_2;
    A[615] = -0.002821869488536*G0_0_0 - 0.013403880070547*G0_0_1 - 0.013403880070547*G0_0_2 - 0.013403880070547*G0_1_0 - 0.002821869488536*G0_1_1 - 0.002821869488536*G0_1_2 - 0.002821869488536*G0_2_0 - 0.013403880070547*G0_2_1 - 0.013403880070547*G0_2_2;
    A[616] = -0.011287477954145*G0_0_0 + 0.002821869488536*G0_0_1 + 0.002821869488536*G0_0_2 + 0.002821869488536*G0_1_0 - 0.011287477954145*G0_2_0 + 0.002821869488536*G0_2_1 + 0.002821869488536*G0_2_2;
    A[617] = 0.016931216931217*G0_0_0 - 0.002821869488536*G0_0_1 + 0.016931216931217*G0_0_2 - 0.002821869488536*G0_1_0 - 0.002821869488536*G0_1_2 + 0.016931216931217*G0_2_0 - 0.002821869488536*G0_2_1 + 0.016931216931217*G0_2_2;
    A[618] = 0.084656084656085*G0_0_0 + 0.042328042328042*G0_0_1 + 0.084656084656085*G0_0_2 + 0.042328042328042*G0_1_0 + 0.022574955908289*G0_1_1 + 0.042328042328042*G0_1_2 + 0.084656084656085*G0_2_0 + 0.042328042328042*G0_2_1 + 0.084656084656085*G0_2_2;
    A[619] = 0.016931216931217*G0_0_0 - 0.002821869488536*G0_0_1 + 0.016931216931217*G0_0_2 - 0.002821869488536*G0_1_0 - 0.002821869488536*G0_1_2 + 0.016931216931217*G0_2_0 - 0.002821869488536*G0_2_1 + 0.016931216931217*G0_2_2;
    A[620] = 0.118518518518519*G0_0_0 + 0.160846560846561*G0_0_1 + 0.067724867724868*G0_0_2 + 0.025396825396826*G0_1_0 - 0.016931216931217*G0_1_1 + 0.160846560846561*G0_1_2 + 0.118518518518519*G0_2_0 + 0.160846560846561*G0_2_1 + 0.067724867724868*G0_2_2;
    A[621] = -0.084656084656085*G0_0_0 - 0.177777777777778*G0_0_1 - 0.270899470899471*G0_0_2 - 0.042328042328042*G0_1_0 - 0.016931216931217*G0_1_1 - 0.177777777777778*G0_1_2 - 0.084656084656085*G0_2_0 - 0.177777777777778*G0_2_1 - 0.270899470899471*G0_2_2;
    A[622] = -0.016931216931217*G0_0_0 + 0.002821869488536*G0_0_1 + 0.067724867724868*G0_0_2 + 0.002821869488536*G0_1_0 + 0.005643738977072*G0_1_1 + 0.002821869488536*G0_1_2 - 0.016931216931217*G0_2_0 + 0.002821869488536*G0_2_1 + 0.067724867724868*G0_2_2;
    A[623] = 0.022574955908289*G0_0_0 - 0.019753086419753*G0_0_1 + 0.022574955908289*G0_0_2 - 0.019753086419753*G0_1_0 + 0.022574955908289*G0_1_1 - 0.019753086419753*G0_1_2 + 0.022574955908289*G0_2_0 - 0.019753086419753*G0_2_1 + 0.022574955908289*G0_2_2;
    A[624] = 0.022574955908289*G0_0_0 + 0.002821869488536*G0_0_1 + 0.022574955908289*G0_0_2 + 0.002821869488536*G0_1_0 + 0.002821869488536*G0_1_2 + 0.022574955908289*G0_2_0 + 0.002821869488536*G0_2_1 + 0.022574955908289*G0_2_2;
    A[625] = 0.022574955908289*G0_0_0 + 0.002821869488536*G0_0_1 + 0.022574955908289*G0_0_2 + 0.002821869488536*G0_1_0 + 0.002821869488536*G0_1_2 + 0.022574955908289*G0_2_0 + 0.002821869488536*G0_2_1 + 0.022574955908289*G0_2_2;
    A[626] = 0.067724867724868*G0_0_0 + 0.160846560846561*G0_0_1 + 0.118518518518519*G0_0_2 + 0.160846560846561*G0_1_0 - 0.016931216931217*G0_1_1 + 0.025396825396826*G0_1_2 + 0.067724867724868*G0_2_0 + 0.160846560846561*G0_2_1 + 0.118518518518519*G0_2_2;
    A[627] = 0.067724867724868*G0_0_0 + 0.002821869488536*G0_0_1 - 0.016931216931217*G0_0_2 + 0.002821869488536*G0_1_0 + 0.005643738977072*G0_1_1 + 0.002821869488536*G0_1_2 + 0.067724867724868*G0_2_0 + 0.002821869488536*G0_2_1 - 0.016931216931217*G0_2_2;
    A[628] = -0.270899470899470*G0_0_0 - 0.177777777777778*G0_0_1 - 0.084656084656085*G0_0_2 - 0.177777777777778*G0_1_0 - 0.016931216931217*G0_1_1 - 0.042328042328042*G0_1_2 - 0.270899470899470*G0_2_0 - 0.177777777777778*G0_2_1 - 0.084656084656084*G0_2_2;
    A[629] = -0.135449735449735*G0_0_0 - 0.022574955908289*G0_0_1 - 0.135449735449735*G0_0_2 - 0.022574955908290*G0_1_0 - 0.045149911816579*G0_1_1 - 0.022574955908290*G0_1_2 - 0.135449735449735*G0_2_0 - 0.022574955908289*G0_2_1 - 0.135449735449735*G0_2_2;
    A[630] = -0.007760141093474*G0_0_0 - 0.007760141093474*G0_0_1 - 0.007760141093474*G0_0_2 - 0.025396825396825*G0_1_0 - 0.025396825396825*G0_1_1 - 0.025396825396825*G0_1_2 - 0.007760141093474*G0_2_0 - 0.007760141093474*G0_2_1 - 0.007760141093474*G0_2_2;
    A[631] = 0.007760141093474*G0_0_0 + 0.007760141093474*G0_2_0;
    A[632] = -0.045855379188713*G0_0_1 - 0.070546737213404*G0_1_1 - 0.045855379188713*G0_2_1;
    A[633] = 0.007760141093474*G0_0_2 + 0.007760141093474*G0_2_2;
    A[634] = -0.079012345679012*G0_0_1 - 0.158024691358025*G0_0_2 + 0.022574955908289*G0_1_1 - 0.079012345679013*G0_1_2 - 0.079012345679012*G0_2_1 - 0.158024691358025*G0_2_2;
    A[635] = 0.031040564373898*G0_0_1 + 0.090299823633157*G0_0_2 - 0.011287477954145*G0_1_1 + 0.031040564373898*G0_1_2 + 0.031040564373898*G0_2_1 + 0.090299823633157*G0_2_2;
    A[636] = -0.011287477954145*G0_0_1 - 0.045149911816579*G0_0_2 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1 - 0.045149911816579*G0_2_2;
    A[637] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_2;
    A[638] = -0.002821869488536*G0_0_0 - 0.002821869488536*G0_0_2 - 0.002821869488536*G0_2_0 - 0.002821869488536*G0_2_2;
    A[639] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_2;
    A[640] = -0.045149911816579*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.045149911816579*G0_2_0 - 0.011287477954145*G0_2_1;
    A[641] = 0.090299823633157*G0_0_0 + 0.031040564373898*G0_0_1 + 0.031040564373898*G0_1_0 - 0.011287477954145*G0_1_1 + 0.090299823633157*G0_2_0 + 0.031040564373898*G0_2_1;
    A[642] = -0.158024691358025*G0_0_0 - 0.079012345679012*G0_0_1 - 0.079012345679012*G0_1_0 + 0.022574955908289*G0_1_1 - 0.158024691358025*G0_2_0 - 0.079012345679012*G0_2_1;
    A[643] = 0.011287477954145*G0_0_0 + 0.011287477954145*G0_0_1 - 0.022574955908289*G0_1_0 - 0.022574955908289*G0_1_1 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_1;
    A[644] = 0.002821869488536*G0_0_0 + 0.002821869488536*G0_0_1 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_1 + 0.002821869488536*G0_1_2 + 0.002821869488536*G0_2_0 + 0.002821869488536*G0_2_1;
    A[645] = 0.011287477954145*G0_0_0 + 0.011287477954145*G0_0_1 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_1;
    A[646] = 0.045149911816579*G0_0_0 + 0.033862433862434*G0_0_1 + 0.045149911816579*G0_0_2 + 0.079012345679012*G0_1_0 + 0.112874779541446*G0_1_1 + 0.079012345679012*G0_1_2 + 0.045149911816579*G0_2_0 + 0.033862433862434*G0_2_1 + 0.045149911816579*G0_2_2;
    A[647] = -0.090299823633157*G0_0_0 - 0.059259259259259*G0_0_1 - 0.090299823633157*G0_0_2 - 0.132627865961199*G0_1_0 - 0.220105820105820*G0_1_1 - 0.132627865961199*G0_1_2 - 0.090299823633157*G0_2_0 - 0.059259259259259*G0_2_1 - 0.090299823633157*G0_2_2;
    A[648] = 0.158024691358025*G0_0_0 + 0.079012345679013*G0_0_1 + 0.158024691358025*G0_0_2 + 0.079012345679013*G0_1_0 + 0.203174603174603*G0_1_1 + 0.079012345679013*G0_1_2 + 0.158024691358025*G0_2_0 + 0.079012345679013*G0_2_1 + 0.158024691358025*G0_2_2;
    A[649] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_1 - 0.022574955908289*G0_1_2 + 0.011287477954145*G0_2_1 + 0.011287477954145*G0_2_2;
    A[650] = 0.002821869488536*G0_0_1 + 0.002821869488536*G0_0_2 + 0.002821869488536*G0_1_0 - 0.011287477954145*G0_1_1 - 0.011287477954145*G0_1_2 + 0.002821869488536*G0_2_1 + 0.002821869488536*G0_2_2;
    A[651] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_2_1 + 0.011287477954145*G0_2_2;
    A[652] = 0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_1 + 0.022574955908289*G0_0_2 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_2 + 0.022574955908289*G0_2_0 - 0.011287477954145*G0_2_1 + 0.022574955908289*G0_2_2;
    A[653] = -0.112874779541446*G0_0_0 - 0.011287477954145*G0_0_1 - 0.112874779541446*G0_0_2 - 0.011287477954145*G0_1_0 - 0.045149911816578*G0_1_1 - 0.011287477954145*G0_1_2 - 0.112874779541446*G0_2_0 - 0.011287477954145*G0_2_1 - 0.112874779541446*G0_2_2;
    A[654] = 0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_1 + 0.022574955908289*G0_0_2 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_2 + 0.022574955908289*G0_2_0 - 0.011287477954145*G0_2_1 + 0.022574955908289*G0_2_2;
    A[655] = -0.022574955908289*G0_0_0 - 0.033862433862434*G0_0_1 + 0.011287477954144*G0_1_0 + 0.067724867724867*G0_1_1 - 0.033862433862434*G0_1_2 - 0.022574955908289*G0_2_0 - 0.033862433862434*G0_2_1;
    A[656] = 0.112874779541446*G0_0_0 + 0.101587301587302*G0_0_1 + 0.011287477954145*G0_1_0 - 0.067724867724868*G0_1_1 + 0.101587301587302*G0_1_2 + 0.112874779541446*G0_2_0 + 0.101587301587302*G0_2_1;
    A[657] = -0.022574955908289*G0_0_0 - 0.033862433862434*G0_0_1 + 0.011287477954145*G0_1_0 + 0.022574955908289*G0_1_1 - 0.033862433862434*G0_1_2 - 0.022574955908289*G0_2_0 - 0.033862433862434*G0_2_1;
    A[658] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_1_0 - 0.045149911816579*G0_1_1 + 0.011287477954144*G0_1_2 + 0.011287477954145*G0_2_1;
    A[659] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_1;
    A[660] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_1;
    A[661] = -0.033862433862434*G0_0_1 - 0.022574955908289*G0_0_2 - 0.033862433862434*G0_1_0 + 0.067724867724867*G0_1_1 + 0.011287477954144*G0_1_2 - 0.033862433862434*G0_2_1 - 0.022574955908289*G0_2_2;
    A[662] = -0.033862433862434*G0_0_1 - 0.022574955908289*G0_0_2 - 0.033862433862434*G0_1_0 + 0.022574955908289*G0_1_1 + 0.011287477954145*G0_1_2 - 0.033862433862434*G0_2_1 - 0.022574955908289*G0_2_2;
    A[663] = 0.101587301587302*G0_0_1 + 0.112874779541446*G0_0_2 + 0.101587301587302*G0_1_0 - 0.067724867724867*G0_1_1 + 0.011287477954145*G0_1_2 + 0.101587301587302*G0_2_1 + 0.112874779541446*G0_2_2;
    A[664] = 0.090299823633157*G0_1_1;
    A[665] = -0.070546737213404*G0_0_0 - 0.070546737213404*G0_0_1 - 0.070546737213404*G0_0_2 - 0.024691358024691*G0_1_0 - 0.024691358024691*G0_1_1 - 0.024691358024691*G0_1_2 - 0.024691358024691*G0_2_0 - 0.024691358024691*G0_2_1 - 0.024691358024691*G0_2_2;
    A[666] = -0.025396825396825*G0_0_0 - 0.017636684303351*G0_1_0 - 0.017636684303351*G0_2_0;
    A[667] = 0.007760141093474*G0_1_1 + 0.007760141093474*G0_2_1;
    A[668] = 0.007760141093474*G0_1_2 + 0.007760141093474*G0_2_2;
    A[669] = -0.011287477954145*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1 - 0.011287477954145*G0_2_2;
    A[670] = -0.002821869488536*G0_1_1 - 0.002821869488536*G0_1_2 - 0.002821869488536*G0_2_1 - 0.002821869488536*G0_2_2;
    A[671] = -0.011287477954145*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1 - 0.011287477954145*G0_2_2;
    A[672] = -0.022574955908289*G0_0_0 - 0.033862433862434*G0_0_2 - 0.033862433862434*G0_1_0 - 0.045149911816578*G0_1_2 - 0.033862433862434*G0_2_0 - 0.045149911816578*G0_2_2;
    A[673] = -0.011287477954145*G0_0_0 - 0.014109347442681*G0_0_2 - 0.014109347442681*G0_1_0 - 0.016931216931217*G0_1_2 - 0.014109347442681*G0_2_0 - 0.016931216931217*G0_2_2;
    A[674] = -0.011287477954145*G0_0_2 - 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_2 - 0.011287477954145*G0_2_0 - 0.022574955908289*G0_2_2;
    A[675] = -0.022574955908289*G0_0_0 - 0.033862433862434*G0_0_1 - 0.033862433862434*G0_1_0 - 0.045149911816578*G0_1_1 - 0.033862433862434*G0_2_0 - 0.045149911816578*G0_2_1;
    A[676] = -0.011287477954145*G0_0_0 - 0.014109347442681*G0_0_1 - 0.014109347442681*G0_1_0 - 0.016931216931217*G0_1_1 - 0.014109347442681*G0_2_0 - 0.016931216931217*G0_2_1;
    A[677] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_1 - 0.011287477954145*G0_2_0 - 0.022574955908289*G0_2_1;
    A[678] = 0.022574955908289*G0_0_0 + 0.022574955908289*G0_0_1 + 0.101587301587301*G0_0_2 + 0.101587301587302*G0_1_0 + 0.101587301587302*G0_1_1 + 0.022574955908289*G0_1_2 + 0.101587301587302*G0_2_0 + 0.101587301587302*G0_2_1 + 0.022574955908289*G0_2_2;
    A[679] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_1 - 0.042328042328042*G0_0_2 - 0.042328042328042*G0_1_0 - 0.042328042328042*G0_1_1 + 0.016931216931217*G0_1_2 - 0.042328042328042*G0_2_0 - 0.042328042328042*G0_2_1 + 0.016931216931217*G0_2_2;
    A[680] = 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_1 - 0.022574955908289*G0_1_2 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_1 - 0.022574955908289*G0_2_2;
    A[681] = 0.022574955908289*G0_0_0 + 0.101587301587301*G0_0_1 + 0.022574955908289*G0_0_2 + 0.101587301587302*G0_1_0 + 0.022574955908289*G0_1_1 + 0.101587301587302*G0_1_2 + 0.101587301587302*G0_2_0 + 0.022574955908289*G0_2_1 + 0.101587301587302*G0_2_2;
    A[682] = -0.011287477954145*G0_0_0 - 0.042328042328042*G0_0_1 - 0.011287477954145*G0_0_2 - 0.042328042328042*G0_1_0 + 0.016931216931217*G0_1_1 - 0.042328042328042*G0_1_2 - 0.042328042328042*G0_2_0 + 0.016931216931217*G0_2_1 - 0.042328042328042*G0_2_2;
    A[683] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_1 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_0 - 0.022574955908289*G0_2_1 + 0.011287477954145*G0_2_2;
    A[684] = 0.203174603174603*G0_0_0 + 0.124162257495591*G0_0_1 + 0.124162257495591*G0_0_2 + 0.124162257495591*G0_1_0 + 0.203174603174603*G0_1_1 + 0.203174603174603*G0_1_2 + 0.124162257495591*G0_2_0 + 0.203174603174603*G0_2_1 + 0.203174603174603*G0_2_2;
    A[685] = -0.220105820105819*G0_0_0 - 0.087477954144621*G0_0_1 - 0.087477954144621*G0_0_2 - 0.160846560846561*G0_1_0 - 0.118518518518518*G0_1_1 - 0.118518518518518*G0_1_2 - 0.160846560846561*G0_2_0 - 0.118518518518518*G0_2_1 - 0.118518518518518*G0_2_2;
    A[686] = 0.112874779541446*G0_0_0 + 0.033862433862434*G0_0_1 + 0.033862433862434*G0_0_2 + 0.079012345679012*G0_1_0 + 0.045149911816578*G0_1_1 + 0.045149911816578*G0_1_2 + 0.079012345679012*G0_2_0 + 0.045149911816578*G0_2_1 + 0.045149911816578*G0_2_2;
    A[687] = -0.045149911816578*G0_0_0 - 0.056437389770723*G0_0_1 - 0.056437389770723*G0_0_2 - 0.056437389770723*G0_1_0 - 0.067724867724867*G0_1_1 - 0.067724867724867*G0_1_2 - 0.056437389770723*G0_2_0 - 0.067724867724867*G0_2_1 - 0.067724867724867*G0_2_2;
    A[688] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_1 - 0.022574955908289*G0_1_2 - 0.011287477954145*G0_2_0 - 0.022574955908289*G0_2_1 - 0.022574955908289*G0_2_2;
    A[689] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_1 - 0.022574955908289*G0_1_2 - 0.011287477954145*G0_2_0 - 0.022574955908289*G0_2_1 - 0.022574955908289*G0_2_2;
    A[690] = -0.045149911816579*G0_0_0 - 0.033862433862434*G0_0_1 - 0.033862433862434*G0_0_2 - 0.033862433862434*G0_1_0 - 0.135449735449735*G0_1_1 - 0.135449735449735*G0_1_2 - 0.033862433862434*G0_2_0 - 0.135449735449735*G0_2_1 - 0.135449735449735*G0_2_2;
    A[691] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 + 0.045149911816579*G0_1_1 + 0.045149911816578*G0_1_2 + 0.011287477954145*G0_2_0 + 0.045149911816579*G0_2_1 + 0.045149911816578*G0_2_2;
    A[692] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 + 0.045149911816578*G0_1_1 + 0.045149911816578*G0_1_2 + 0.011287477954145*G0_2_0 + 0.045149911816578*G0_2_1 + 0.045149911816578*G0_2_2;
    A[693] = -0.067724867724868*G0_0_0 - 0.079012345679012*G0_0_1 - 0.169312169312169*G0_0_2 - 0.169312169312169*G0_1_0 - 0.067724867724867*G0_1_1 - 0.270899470899470*G0_1_2 - 0.169312169312169*G0_2_0 - 0.067724867724867*G0_2_1 - 0.270899470899470*G0_2_2;
    A[694] = 0.067724867724868*G0_0_0 + 0.056437389770723*G0_0_1 + 0.101587301587302*G0_0_2 + 0.101587301587301*G0_1_0 + 0.067724867724867*G0_1_1 + 0.135449735449735*G0_1_2 + 0.101587301587301*G0_2_0 + 0.067724867724867*G0_2_1 + 0.135449735449735*G0_2_2;
    A[695] = 0.022574955908289*G0_0_0 + 0.011287477954145*G0_0_1 + 0.056437389770723*G0_0_2 + 0.056437389770723*G0_1_0 + 0.022574955908289*G0_1_1 + 0.090299823633157*G0_1_2 + 0.056437389770723*G0_2_0 + 0.022574955908289*G0_2_1 + 0.090299823633157*G0_2_2;
    A[696] = -0.067724867724868*G0_0_0 - 0.169312169312169*G0_0_1 - 0.079012345679012*G0_0_2 - 0.169312169312169*G0_1_0 - 0.270899470899471*G0_1_1 - 0.067724867724867*G0_1_2 - 0.169312169312169*G0_2_0 - 0.270899470899471*G0_2_1 - 0.067724867724867*G0_2_2;
    A[697] = 0.067724867724867*G0_0_0 + 0.101587301587301*G0_0_1 + 0.056437389770723*G0_0_2 + 0.101587301587301*G0_1_0 + 0.135449735449735*G0_1_1 + 0.067724867724867*G0_1_2 + 0.101587301587301*G0_2_0 + 0.135449735449735*G0_2_1 + 0.067724867724867*G0_2_2;
    A[698] = 0.022574955908289*G0_0_0 + 0.056437389770723*G0_0_1 + 0.011287477954145*G0_0_2 + 0.056437389770723*G0_1_0 + 0.090299823633157*G0_1_1 + 0.022574955908289*G0_1_2 + 0.056437389770723*G0_2_0 + 0.090299823633157*G0_2_1 + 0.022574955908289*G0_2_2;
    A[699] = 0.090299823633157*G0_0_0 + 0.090299823633157*G0_0_1 + 0.090299823633157*G0_0_2 + 0.090299823633157*G0_1_0 + 0.090299823633157*G0_1_1 + 0.090299823633157*G0_1_2 + 0.090299823633157*G0_2_0 + 0.090299823633157*G0_2_1 + 0.090299823633157*G0_2_2;
    A[700] = 0.052910052910053*G0_0_0 + 0.052910052910053*G0_0_1 + 0.052910052910053*G0_0_2 + 0.020282186948854*G0_1_0 + 0.020282186948854*G0_1_1 + 0.020282186948854*G0_1_2 + 0.020282186948854*G0_2_0 + 0.020282186948854*G0_2_1 + 0.020282186948854*G0_2_2;
    A[701] = 0.052910052910053*G0_0_0 + 0.032627865961199*G0_1_0 + 0.032627865961199*G0_2_0;
    A[702] = 0.005114638447972*G0_1_1 + 0.005114638447972*G0_2_1;
    A[703] = 0.005114638447972*G0_1_2 + 0.005114638447972*G0_2_2;
    A[704] = -0.002821869488536*G0_1_1 - 0.002821869488536*G0_1_2 - 0.002821869488536*G0_2_1 - 0.002821869488536*G0_2_2;
    A[705] = -0.009171075837743*G0_1_1 - 0.009171075837743*G0_1_2 - 0.009171075837743*G0_2_1 - 0.009171075837743*G0_2_2;
    A[706] = -0.002821869488536*G0_1_1 - 0.002821869488536*G0_1_2 - 0.002821869488536*G0_2_1 - 0.002821869488536*G0_2_2;
    A[707] = 0.016931216931217*G0_0_0 + 0.059259259259259*G0_0_2 + 0.059259259259259*G0_1_0 + 0.090299823633157*G0_1_2 + 0.059259259259259*G0_2_0 + 0.090299823633157*G0_2_2;
    A[708] = -0.002821869488536*G0_0_0 + 0.010582010582011*G0_0_2 + 0.010582010582011*G0_1_0 + 0.021164021164021*G0_1_2 + 0.010582010582011*G0_2_0 + 0.021164021164021*G0_2_2;
    A[709] = -0.002821869488536*G0_0_2 - 0.002821869488536*G0_1_0 - 0.016931216931217*G0_1_2 - 0.002821869488536*G0_2_0 - 0.016931216931217*G0_2_2;
    A[710] = 0.016931216931217*G0_0_0 + 0.059259259259259*G0_0_1 + 0.059259259259259*G0_1_0 + 0.090299823633157*G0_1_1 + 0.059259259259259*G0_2_0 + 0.090299823633157*G0_2_1;
    A[711] = -0.002821869488536*G0_0_0 + 0.010582010582011*G0_0_1 + 0.010582010582011*G0_1_0 + 0.021164021164021*G0_1_1 + 0.010582010582011*G0_2_0 + 0.021164021164021*G0_2_1;
    A[712] = -0.002821869488536*G0_0_1 - 0.002821869488536*G0_1_0 - 0.016931216931217*G0_1_1 - 0.002821869488536*G0_2_0 - 0.016931216931217*G0_2_1;
    A[713] = 0.016931216931217*G0_0_0 + 0.016931216931217*G0_0_1 - 0.042328042328042*G0_0_2 - 0.042328042328042*G0_1_0 - 0.042328042328042*G0_1_1 - 0.011287477954145*G0_1_2 - 0.042328042328042*G0_2_0 - 0.042328042328042*G0_2_1 - 0.011287477954145*G0_2_2;
    A[714] = -0.002821869488536*G0_0_0 - 0.002821869488536*G0_0_1 - 0.013403880070547*G0_0_2 - 0.013403880070547*G0_1_0 - 0.013403880070547*G0_1_1 - 0.002821869488536*G0_1_2 - 0.013403880070547*G0_2_0 - 0.013403880070547*G0_2_1 - 0.002821869488536*G0_2_2;
    A[715] = 0.002821869488536*G0_0_2 + 0.002821869488536*G0_1_0 + 0.002821869488536*G0_1_1 - 0.011287477954145*G0_1_2 + 0.002821869488536*G0_2_0 + 0.002821869488536*G0_2_1 - 0.011287477954145*G0_2_2;
    A[716] = 0.016931216931217*G0_0_0 - 0.042328042328042*G0_0_1 + 0.016931216931217*G0_0_2 - 0.042328042328042*G0_1_0 - 0.011287477954145*G0_1_1 - 0.042328042328042*G0_1_2 - 0.042328042328042*G0_2_0 - 0.011287477954145*G0_2_1 - 0.042328042328042*G0_2_2;
    A[717] = -0.002821869488536*G0_0_0 - 0.013403880070547*G0_0_1 - 0.002821869488536*G0_0_2 - 0.013403880070547*G0_1_0 - 0.002821869488536*G0_1_1 - 0.013403880070547*G0_1_2 - 0.013403880070547*G0_2_0 - 0.002821869488536*G0_2_1 - 0.013403880070547*G0_2_2;
    A[718] = 0.002821869488536*G0_0_1 + 0.002821869488536*G0_1_0 - 0.011287477954145*G0_1_1 + 0.002821869488536*G0_1_2 + 0.002821869488536*G0_2_0 - 0.011287477954145*G0_2_1 + 0.002821869488536*G0_2_2;
    A[719] = -0.220105820105819*G0_0_0 - 0.160846560846561*G0_0_1 - 0.160846560846561*G0_0_2 - 0.087477954144621*G0_1_0 - 0.118518518518518*G0_1_1 - 0.118518518518518*G0_1_2 - 0.087477954144621*G0_2_0 - 0.118518518518518*G0_2_1 - 0.118518518518518*G0_2_2;
    A[720] = 0.334391534391533*G0_0_0 + 0.167195767195767*G0_0_1 + 0.167195767195767*G0_0_2 + 0.167195767195767*G0_1_0 + 0.249735449735449*G0_1_1 + 0.249735449735449*G0_1_2 + 0.167195767195767*G0_2_0 + 0.249735449735449*G0_2_1 + 0.249735449735449*G0_2_2;
    A[721] = -0.220105820105820*G0_0_0 - 0.059259259259259*G0_0_1 - 0.059259259259259*G0_0_2 - 0.132627865961199*G0_1_0 - 0.090299823633157*G0_1_1 - 0.090299823633157*G0_1_2 - 0.132627865961199*G0_2_0 - 0.090299823633157*G0_2_1 - 0.090299823633157*G0_2_2;
    A[722] = 0.022574955908289*G0_0_0 + 0.042328042328042*G0_0_1 + 0.042328042328042*G0_0_2 + 0.042328042328042*G0_1_0 + 0.084656084656084*G0_1_1 + 0.084656084656084*G0_1_2 + 0.042328042328042*G0_2_0 + 0.084656084656084*G0_2_1 + 0.084656084656084*G0_2_2;
    A[723] = -0.002821869488536*G0_0_1 - 0.002821869488536*G0_0_2 - 0.002821869488536*G0_1_0 + 0.016931216931217*G0_1_1 + 0.016931216931217*G0_1_2 - 0.002821869488536*G0_2_0 + 0.016931216931217*G0_2_1 + 0.016931216931217*G0_2_2;
    A[724] = -0.002821869488536*G0_0_1 - 0.002821869488536*G0_0_2 - 0.002821869488536*G0_1_0 + 0.016931216931217*G0_1_1 + 0.016931216931217*G0_1_2 - 0.002821869488536*G0_2_0 + 0.016931216931217*G0_2_1 + 0.016931216931217*G0_2_2;
    A[725] = 0.022574955908289*G0_0_0 - 0.019753086419753*G0_0_1 - 0.019753086419753*G0_0_2 - 0.019753086419753*G0_1_0 + 0.022574955908289*G0_1_1 + 0.022574955908289*G0_1_2 - 0.019753086419753*G0_2_0 + 0.022574955908289*G0_2_1 + 0.022574955908289*G0_2_2;
    A[726] = 0.002821869488536*G0_0_1 + 0.002821869488536*G0_0_2 + 0.002821869488536*G0_1_0 + 0.022574955908289*G0_1_1 + 0.022574955908289*G0_1_2 + 0.002821869488536*G0_2_0 + 0.022574955908289*G0_2_1 + 0.022574955908289*G0_2_2;
    A[727] = 0.002821869488536*G0_0_1 + 0.002821869488536*G0_0_2 + 0.002821869488536*G0_1_0 + 0.022574955908289*G0_1_1 + 0.022574955908289*G0_1_2 + 0.002821869488536*G0_2_0 + 0.022574955908289*G0_2_1 + 0.022574955908289*G0_2_2;
    A[728] = -0.016931216931217*G0_0_0 + 0.025396825396825*G0_0_1 + 0.160846560846561*G0_0_2 + 0.160846560846561*G0_1_0 + 0.118518518518518*G0_1_1 + 0.067724867724868*G0_1_2 + 0.160846560846561*G0_2_0 + 0.118518518518518*G0_2_1 + 0.067724867724868*G0_2_2;
    A[729] = -0.016931216931217*G0_0_0 - 0.042328042328042*G0_0_1 - 0.177777777777778*G0_0_2 - 0.177777777777777*G0_1_0 - 0.084656084656084*G0_1_1 - 0.270899470899470*G0_1_2 - 0.177777777777777*G0_2_0 - 0.084656084656084*G0_2_1 - 0.270899470899470*G0_2_2;
    A[730] = 0.005643738977072*G0_0_0 + 0.002821869488536*G0_0_1 + 0.002821869488536*G0_0_2 + 0.002821869488536*G0_1_0 - 0.016931216931217*G0_1_1 + 0.067724867724867*G0_1_2 + 0.002821869488536*G0_2_0 - 0.016931216931217*G0_2_1 + 0.067724867724867*G0_2_2;
    A[731] = -0.016931216931217*G0_0_0 + 0.160846560846561*G0_0_1 + 0.025396825396825*G0_0_2 + 0.160846560846560*G0_1_0 + 0.067724867724868*G0_1_1 + 0.118518518518518*G0_1_2 + 0.160846560846561*G0_2_0 + 0.067724867724868*G0_2_1 + 0.118518518518518*G0_2_2;
    A[732] = -0.016931216931217*G0_0_0 - 0.177777777777777*G0_0_1 - 0.042328042328042*G0_0_2 - 0.177777777777777*G0_1_0 - 0.270899470899470*G0_1_1 - 0.084656084656084*G0_1_2 - 0.177777777777777*G0_2_0 - 0.270899470899470*G0_2_1 - 0.084656084656084*G0_2_2;
    A[733] = 0.005643738977072*G0_0_0 + 0.002821869488536*G0_0_1 + 0.002821869488536*G0_0_2 + 0.002821869488536*G0_1_0 + 0.067724867724868*G0_1_1 - 0.016931216931217*G0_1_2 + 0.002821869488536*G0_2_0 + 0.067724867724867*G0_2_1 - 0.016931216931217*G0_2_2;
    A[734] = -0.045149911816579*G0_0_0 - 0.022574955908289*G0_0_1 - 0.022574955908289*G0_0_2 - 0.022574955908289*G0_1_0 - 0.135449735449735*G0_1_1 - 0.135449735449735*G0_1_2 - 0.022574955908289*G0_2_0 - 0.135449735449735*G0_2_1 - 0.135449735449735*G0_2_2;
    A[735] = -0.025396825396825*G0_0_0 - 0.025396825396825*G0_0_1 - 0.025396825396825*G0_0_2 - 0.007760141093474*G0_1_0 - 0.007760141093474*G0_1_1 - 0.007760141093474*G0_1_2 - 0.007760141093474*G0_2_0 - 0.007760141093474*G0_2_1 - 0.007760141093474*G0_2_2;
    A[736] = -0.070546737213404*G0_0_0 - 0.045855379188712*G0_1_0 - 0.045855379188712*G0_2_0;
    A[737] = 0.007760141093474*G0_1_1 + 0.007760141093474*G0_2_1;
    A[738] = 0.007760141093474*G0_1_2 + 0.007760141093474*G0_2_2;
    A[739] = -0.011287477954145*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1 - 0.011287477954145*G0_2_2;
    A[740] = -0.002821869488536*G0_1_1 - 0.002821869488536*G0_1_2 - 0.002821869488536*G0_2_1 - 0.002821869488536*G0_2_2;
    A[741] = -0.011287477954145*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1 - 0.011287477954145*G0_2_2;
    A[742] = 0.022574955908289*G0_0_0 - 0.079012345679012*G0_0_2 - 0.079012345679012*G0_1_0 - 0.158024691358024*G0_1_2 - 0.079012345679012*G0_2_0 - 0.158024691358024*G0_2_2;
    A[743] = -0.011287477954145*G0_0_0 + 0.031040564373897*G0_0_2 + 0.031040564373898*G0_1_0 + 0.090299823633156*G0_1_2 + 0.031040564373897*G0_2_0 + 0.090299823633156*G0_2_2;
    A[744] = -0.011287477954145*G0_0_2 - 0.011287477954145*G0_1_0 - 0.045149911816578*G0_1_2 - 0.011287477954145*G0_2_0 - 0.045149911816578*G0_2_2;
    A[745] = 0.022574955908289*G0_0_0 - 0.079012345679012*G0_0_1 - 0.079012345679012*G0_1_0 - 0.158024691358024*G0_1_1 - 0.079012345679012*G0_2_0 - 0.158024691358024*G0_2_1;
    A[746] = -0.011287477954145*G0_0_0 + 0.031040564373898*G0_0_1 + 0.031040564373898*G0_1_0 + 0.090299823633157*G0_1_1 + 0.031040564373898*G0_2_0 + 0.090299823633157*G0_2_1;
    A[747] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.045149911816578*G0_1_1 - 0.011287477954145*G0_2_0 - 0.045149911816578*G0_2_1;
    A[748] = -0.022574955908289*G0_0_0 - 0.022574955908289*G0_0_1 + 0.011287477954144*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_1 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_1;
    A[749] = -0.011287477954145*G0_0_0 - 0.011287477954145*G0_0_1 + 0.002821869488536*G0_0_2 + 0.002821869488536*G0_1_0 + 0.002821869488536*G0_1_1 + 0.002821869488536*G0_2_0 + 0.002821869488536*G0_2_1;
    A[750] = 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_1 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_1;
    A[751] = -0.022574955908289*G0_0_0 + 0.011287477954145*G0_0_1 - 0.022574955908289*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_2;
    A[752] = -0.011287477954145*G0_0_0 + 0.002821869488536*G0_0_1 - 0.011287477954145*G0_0_2 + 0.002821869488536*G0_1_0 + 0.002821869488536*G0_1_2 + 0.002821869488536*G0_2_0 + 0.002821869488536*G0_2_2;
    A[753] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_2;
    A[754] = 0.112874779541446*G0_0_0 + 0.079012345679012*G0_0_1 + 0.079012345679012*G0_0_2 + 0.033862433862434*G0_1_0 + 0.045149911816578*G0_1_1 + 0.045149911816578*G0_1_2 + 0.033862433862434*G0_2_0 + 0.045149911816578*G0_2_1 + 0.045149911816578*G0_2_2;
    A[755] = -0.220105820105820*G0_0_0 - 0.132627865961199*G0_0_1 - 0.132627865961199*G0_0_2 - 0.059259259259259*G0_1_0 - 0.090299823633157*G0_1_1 - 0.090299823633157*G0_1_2 - 0.059259259259259*G0_2_0 - 0.090299823633157*G0_2_1 - 0.090299823633157*G0_2_2;
    A[756] = 0.203174603174603*G0_0_0 + 0.079012345679012*G0_0_1 + 0.079012345679012*G0_0_2 + 0.079012345679012*G0_1_0 + 0.158024691358024*G0_1_1 + 0.158024691358024*G0_1_2 + 0.079012345679012*G0_2_0 + 0.158024691358024*G0_2_1 + 0.158024691358024*G0_2_2;
    A[757] = -0.045149911816579*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954144*G0_0_2 - 0.011287477954145*G0_1_0 - 0.112874779541446*G0_1_1 - 0.112874779541446*G0_1_2 - 0.011287477954145*G0_2_0 - 0.112874779541446*G0_2_1 - 0.112874779541446*G0_2_2;
    A[758] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_1_0 + 0.022574955908289*G0_1_1 + 0.022574955908289*G0_1_2 - 0.011287477954145*G0_2_0 + 0.022574955908289*G0_2_1 + 0.022574955908289*G0_2_2;
    A[759] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_1_0 + 0.022574955908289*G0_1_1 + 0.022574955908289*G0_1_2 - 0.011287477954145*G0_2_0 + 0.022574955908289*G0_2_1 + 0.022574955908289*G0_2_2;
    A[760] = -0.045149911816579*G0_0_0 + 0.011287477954145*G0_0_1 + 0.011287477954144*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_2_0;
    A[761] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_2_0;
    A[762] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_2_0;
    A[763] = 0.067724867724868*G0_0_0 + 0.011287477954145*G0_0_1 - 0.033862433862434*G0_0_2 - 0.033862433862434*G0_1_0 - 0.022574955908289*G0_1_1 - 0.033862433862434*G0_2_0 - 0.022574955908289*G0_2_1;
    A[764] = -0.067724867724868*G0_0_0 + 0.011287477954145*G0_0_1 + 0.101587301587302*G0_0_2 + 0.101587301587301*G0_1_0 + 0.112874779541446*G0_1_1 + 0.101587301587301*G0_2_0 + 0.112874779541446*G0_2_1;
    A[765] = 0.022574955908289*G0_0_0 + 0.011287477954145*G0_0_1 - 0.033862433862434*G0_0_2 - 0.033862433862433*G0_1_0 - 0.022574955908289*G0_1_1 - 0.033862433862433*G0_2_0 - 0.022574955908289*G0_2_1;
    A[766] = 0.067724867724868*G0_0_0 - 0.033862433862434*G0_0_1 + 0.011287477954145*G0_0_2 - 0.033862433862434*G0_1_0 - 0.022574955908289*G0_1_2 - 0.033862433862434*G0_2_0 - 0.022574955908289*G0_2_2;
    A[767] = -0.067724867724868*G0_0_0 + 0.101587301587301*G0_0_1 + 0.011287477954144*G0_0_2 + 0.101587301587301*G0_1_0 + 0.112874779541446*G0_1_2 + 0.101587301587301*G0_2_0 + 0.112874779541446*G0_2_2;
    A[768] = 0.022574955908289*G0_0_0 - 0.033862433862434*G0_0_1 + 0.011287477954145*G0_0_2 - 0.033862433862434*G0_1_0 - 0.022574955908289*G0_1_2 - 0.033862433862434*G0_2_0 - 0.022574955908289*G0_2_2;
    A[769] = 0.090299823633157*G0_0_0;
    A[770] = 0.018342151675485*G0_0_0 + 0.018342151675485*G0_0_1 + 0.018342151675485*G0_0_2 + 0.018342151675485*G0_1_0 + 0.018342151675485*G0_1_1 + 0.018342151675485*G0_1_2 + 0.018342151675485*G0_2_0 + 0.018342151675485*G0_2_1 + 0.018342151675485*G0_2_2;
    A[771] = 0.049382716049383*G0_0_0 + 0.007054673721340*G0_1_0 + 0.007054673721340*G0_2_0;
    A[772] = 0.007054673721340*G0_0_1 - 0.018342151675485*G0_1_1 + 0.007054673721340*G0_2_1;
    A[773] = 0.007054673721340*G0_0_2 + 0.007054673721340*G0_1_2 - 0.018342151675485*G0_2_2;
    A[774] = -0.067724867724868*G0_0_1 - 0.022574955908289*G0_0_2 + 0.022574955908289*G0_1_1 + 0.011287477954145*G0_1_2 - 0.033862433862434*G0_2_1 - 0.022574955908289*G0_2_2;
    A[775] = -0.084656084656085*G0_0_1 - 0.084656084656085*G0_0_2 - 0.016931216931217*G0_1_1 - 0.019753086419753*G0_1_2 - 0.019753086419753*G0_2_1 - 0.016931216931217*G0_2_2;
    A[776] = -0.022574955908289*G0_0_1 - 0.067724867724867*G0_0_2 - 0.022574955908289*G0_1_1 - 0.033862433862434*G0_1_2 + 0.011287477954145*G0_2_1 + 0.022574955908289*G0_2_2;
    A[777] = -0.067724867724868*G0_0_0 + 0.011287477954145*G0_0_2 + 0.203174603174603*G0_1_0 + 0.112874779541446*G0_1_2 + 0.101587301587301*G0_2_0 + 0.112874779541446*G0_2_2;
    A[778] = 0.118518518518518*G0_0_0 + 0.093121693121693*G0_0_2 + 0.050793650793650*G0_1_0 + 0.186243386243386*G0_1_2 - 0.042328042328042*G0_2_0 - 0.084656084656084*G0_2_2;
    A[779] = -0.022574955908289*G0_0_0 - 0.033862433862434*G0_0_2 - 0.022574955908289*G0_1_0 - 0.067724867724868*G0_1_2 + 0.011287477954145*G0_2_0 + 0.067724867724868*G0_2_2;
    A[780] = -0.067724867724868*G0_0_0 + 0.011287477954145*G0_0_1 + 0.101587301587302*G0_1_0 + 0.112874779541446*G0_1_1 + 0.203174603174603*G0_2_0 + 0.112874779541446*G0_2_1;
    A[781] = 0.118518518518518*G0_0_0 + 0.093121693121693*G0_0_1 - 0.042328042328042*G0_1_0 - 0.084656084656085*G0_1_1 + 0.050793650793651*G0_2_0 + 0.186243386243386*G0_2_1;
    A[782] = -0.022574955908289*G0_0_0 - 0.033862433862434*G0_0_1 + 0.011287477954145*G0_1_0 + 0.067724867724868*G0_1_1 - 0.022574955908289*G0_2_0 - 0.067724867724868*G0_2_1;
    A[783] = -0.022574955908289*G0_0_0 - 0.022574955908289*G0_0_1 - 0.011287477954145*G0_0_2 - 0.022574955908289*G0_1_0 - 0.022574955908289*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_1;
    A[784] = 0.016931216931217*G0_0_0 + 0.016931216931217*G0_0_1 - 0.002821869488536*G0_0_2 + 0.016931216931217*G0_1_0 + 0.016931216931217*G0_1_1 - 0.002821869488536*G0_1_2 - 0.002821869488536*G0_2_0 - 0.002821869488536*G0_2_1;
    A[785] = 0.022574955908289*G0_0_0 + 0.022574955908289*G0_0_1 - 0.011287477954145*G0_0_2 + 0.022574955908289*G0_1_0 + 0.022574955908289*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_1;
    A[786] = -0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_1 - 0.022574955908289*G0_0_2 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_2 - 0.022574955908289*G0_2_0 - 0.011287477954144*G0_2_1 - 0.022574955908289*G0_2_2;
    A[787] = 0.016931216931217*G0_0_0 - 0.002821869488536*G0_0_1 + 0.016931216931217*G0_0_2 - 0.002821869488536*G0_1_0 - 0.002821869488536*G0_1_2 + 0.016931216931217*G0_2_0 - 0.002821869488536*G0_2_1 + 0.016931216931217*G0_2_2;
    A[788] = 0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_1 + 0.022574955908289*G0_0_2 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_2 + 0.022574955908289*G0_2_0 - 0.011287477954145*G0_2_1 + 0.022574955908289*G0_2_2;
    A[789] = -0.045149911816578*G0_0_0 - 0.056437389770723*G0_0_1 - 0.056437389770723*G0_0_2 - 0.056437389770723*G0_1_0 - 0.067724867724867*G0_1_1 - 0.067724867724867*G0_1_2 - 0.056437389770723*G0_2_0 - 0.067724867724867*G0_2_1 - 0.067724867724867*G0_2_2;
    A[790] = 0.022574955908289*G0_0_0 + 0.042328042328042*G0_0_1 + 0.042328042328042*G0_0_2 + 0.042328042328042*G0_1_0 + 0.084656084656084*G0_1_1 + 0.084656084656084*G0_1_2 + 0.042328042328042*G0_2_0 + 0.084656084656084*G0_2_1 + 0.084656084656084*G0_2_2;
    A[791] = -0.045149911816579*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_1_0 - 0.112874779541446*G0_1_1 - 0.112874779541446*G0_1_2 - 0.011287477954144*G0_2_0 - 0.112874779541446*G0_2_1 - 0.112874779541446*G0_2_2;
    A[792] = 0.632098765432098*G0_0_0 + 0.270899470899470*G0_0_1 + 0.270899470899470*G0_0_2 + 0.270899470899470*G0_1_0 + 0.541798941798941*G0_1_1 + 0.270899470899470*G0_1_2 + 0.270899470899470*G0_2_0 + 0.270899470899470*G0_2_1 + 0.541798941798940*G0_2_2;
    A[793] = -0.135449735449736*G0_0_0 + 0.225749559082892*G0_0_1 + 0.067724867724867*G0_0_2 - 0.045149911816578*G0_1_0 - 0.135449735449735*G0_1_1 - 0.067724867724868*G0_1_2 - 0.067724867724868*G0_2_0 + 0.067724867724867*G0_2_1;
    A[794] = -0.135449735449735*G0_0_0 + 0.067724867724868*G0_0_1 + 0.225749559082892*G0_0_2 - 0.067724867724867*G0_1_0 + 0.067724867724868*G0_1_2 - 0.045149911816578*G0_2_0 - 0.067724867724867*G0_2_1 - 0.135449735449735*G0_2_2;
    A[795] = 0.090299823633156*G0_0_0 + 0.045149911816578*G0_0_1 + 0.045149911816578*G0_0_2 + 0.045149911816578*G0_1_0 + 0.022574955908289*G0_1_2 + 0.045149911816578*G0_2_0 + 0.022574955908289*G0_2_1;
    A[796] = 0.135449735449736*G0_0_0 + 0.045149911816579*G0_0_1 + 0.067724867724868*G0_0_2 + 0.045149911816578*G0_1_0 + 0.022574955908289*G0_1_2 + 0.067724867724868*G0_2_0 + 0.022574955908290*G0_2_1;
    A[797] = 0.135449735449735*G0_0_0 + 0.067724867724868*G0_0_1 + 0.045149911816579*G0_0_2 + 0.067724867724867*G0_1_0 + 0.022574955908289*G0_1_2 + 0.045149911816578*G0_2_0 + 0.022574955908289*G0_2_1;
    A[798] = 0.045149911816578*G0_0_0 + 0.090299823633156*G0_0_1 + 0.045149911816578*G0_0_2 + 0.090299823633156*G0_1_0 + 0.135449735449735*G0_1_1 + 0.067724867724867*G0_1_2 + 0.045149911816578*G0_2_0 + 0.067724867724867*G0_2_1;
    A[799] = 0.045149911816579*G0_0_0 - 0.270899470899470*G0_0_1 - 0.135449735449735*G0_0_2 - 0.270899470899470*G0_1_0 - 0.541798941798941*G0_1_1 - 0.270899470899470*G0_1_2 - 0.135449735449735*G0_2_0 - 0.270899470899470*G0_2_1;
    A[800] = -0.135449735449735*G0_0_0 - 0.067724867724868*G0_0_1 + 0.045149911816579*G0_0_2 - 0.067724867724867*G0_1_0 + 0.067724867724868*G0_1_2 + 0.045149911816578*G0_2_0 + 0.067724867724867*G0_2_1;
    A[801] = 0.045149911816578*G0_0_0 + 0.045149911816578*G0_0_1 + 0.090299823633156*G0_0_2 + 0.045149911816578*G0_1_0 + 0.067724867724867*G0_1_2 + 0.090299823633156*G0_2_0 + 0.067724867724867*G0_2_1 + 0.135449735449735*G0_2_2;
    A[802] = 0.045149911816579*G0_0_0 - 0.135449735449735*G0_0_1 - 0.270899470899470*G0_0_2 - 0.135449735449735*G0_1_0 - 0.270899470899470*G0_1_2 - 0.270899470899470*G0_2_0 - 0.270899470899470*G0_2_1 - 0.541798941798940*G0_2_2;
    A[803] = -0.135449735449735*G0_0_0 + 0.045149911816579*G0_0_1 - 0.067724867724867*G0_0_2 + 0.045149911816579*G0_1_0 + 0.067724867724868*G0_1_2 - 0.067724867724867*G0_2_0 + 0.067724867724868*G0_2_1;
    A[804] = -0.722398589065254*G0_0_0 - 0.316049382716049*G0_0_1 - 0.316049382716049*G0_0_2 - 0.316049382716048*G0_1_0 - 0.135449735449735*G0_1_2 - 0.316049382716049*G0_2_0 - 0.135449735449735*G0_2_1;
    A[805] = 0.018342151675485*G0_0_0 + 0.018342151675485*G0_0_1 + 0.018342151675485*G0_0_2 + 0.018342151675485*G0_1_0 + 0.018342151675485*G0_1_1 + 0.018342151675485*G0_1_2 + 0.018342151675485*G0_2_0 + 0.018342151675485*G0_2_1 + 0.018342151675485*G0_2_2;
    A[806] = -0.018342151675485*G0_0_0 + 0.007054673721340*G0_1_0 + 0.007054673721340*G0_2_0;
    A[807] = 0.007054673721340*G0_0_1 + 0.049382716049383*G0_1_1 + 0.007054673721340*G0_2_1;
    A[808] = 0.007054673721340*G0_0_2 + 0.007054673721340*G0_1_2 - 0.018342151675485*G0_2_2;
    A[809] = 0.203174603174603*G0_0_1 + 0.112874779541446*G0_0_2 - 0.067724867724868*G0_1_1 + 0.011287477954145*G0_1_2 + 0.101587301587301*G0_2_1 + 0.112874779541446*G0_2_2;
    A[810] = 0.050793650793651*G0_0_1 + 0.186243386243386*G0_0_2 + 0.118518518518518*G0_1_1 + 0.093121693121693*G0_1_2 - 0.042328042328042*G0_2_1 - 0.084656084656085*G0_2_2;
    A[811] = -0.022574955908289*G0_0_1 - 0.067724867724868*G0_0_2 - 0.022574955908289*G0_1_1 - 0.033862433862434*G0_1_2 + 0.011287477954145*G0_2_1 + 0.067724867724868*G0_2_2;
    A[812] = 0.022574955908289*G0_0_0 + 0.011287477954145*G0_0_2 - 0.067724867724868*G0_1_0 - 0.022574955908289*G0_1_2 - 0.033862433862434*G0_2_0 - 0.022574955908289*G0_2_2;
    A[813] = -0.016931216931217*G0_0_0 - 0.019753086419753*G0_0_2 - 0.084656084656084*G0_1_0 - 0.084656084656084*G0_1_2 - 0.019753086419753*G0_2_0 - 0.016931216931217*G0_2_2;
    A[814] = -0.022574955908289*G0_0_0 - 0.033862433862434*G0_0_2 - 0.022574955908289*G0_1_0 - 0.067724867724868*G0_1_2 + 0.011287477954145*G0_2_0 + 0.022574955908289*G0_2_2;
    A[815] = 0.067724867724868*G0_0_0 + 0.011287477954145*G0_0_1 - 0.033862433862434*G0_1_0 - 0.022574955908289*G0_1_1 - 0.067724867724868*G0_2_0 - 0.022574955908289*G0_2_1;
    A[816] = -0.084656084656085*G0_0_0 - 0.042328042328042*G0_0_1 + 0.093121693121693*G0_1_0 + 0.118518518518518*G0_1_1 + 0.186243386243386*G0_2_0 + 0.050793650793650*G0_2_1;
    A[817] = 0.112874779541446*G0_0_0 + 0.101587301587302*G0_0_1 + 0.011287477954145*G0_1_0 - 0.067724867724868*G0_1_1 + 0.112874779541446*G0_2_0 + 0.203174603174603*G0_2_1;
    A[818] = -0.022574955908289*G0_0_0 - 0.022574955908289*G0_0_1 - 0.011287477954145*G0_0_2 - 0.022574955908289*G0_1_0 - 0.022574955908289*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_1;
    A[819] = 0.016931216931217*G0_0_0 + 0.016931216931217*G0_0_1 - 0.002821869488536*G0_0_2 + 0.016931216931217*G0_1_0 + 0.016931216931217*G0_1_1 - 0.002821869488536*G0_1_2 - 0.002821869488536*G0_2_0 - 0.002821869488536*G0_2_1;
    A[820] = 0.022574955908289*G0_0_0 + 0.022574955908289*G0_0_1 - 0.011287477954145*G0_0_2 + 0.022574955908289*G0_1_0 + 0.022574955908289*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_1;
    A[821] = -0.067724867724868*G0_0_0 - 0.056437389770723*G0_0_1 - 0.067724867724868*G0_0_2 - 0.056437389770723*G0_1_0 - 0.045149911816578*G0_1_1 - 0.056437389770723*G0_1_2 - 0.067724867724868*G0_2_0 - 0.056437389770723*G0_2_1 - 0.067724867724868*G0_2_2;
    A[822] = 0.084656084656085*G0_0_0 + 0.042328042328042*G0_0_1 + 0.084656084656085*G0_0_2 + 0.042328042328042*G0_1_0 + 0.022574955908289*G0_1_1 + 0.042328042328042*G0_1_2 + 0.084656084656085*G0_2_0 + 0.042328042328042*G0_2_1 + 0.084656084656085*G0_2_2;
    A[823] = -0.112874779541446*G0_0_0 - 0.011287477954145*G0_0_1 - 0.112874779541446*G0_0_2 - 0.011287477954145*G0_1_0 - 0.045149911816578*G0_1_1 - 0.011287477954145*G0_1_2 - 0.112874779541446*G0_2_0 - 0.011287477954145*G0_2_1 - 0.112874779541446*G0_2_2;
    A[824] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_1 - 0.022574955908289*G0_1_2 - 0.011287477954145*G0_2_0 - 0.022574955908289*G0_2_1 - 0.022574955908289*G0_2_2;
    A[825] = -0.002821869488536*G0_0_1 - 0.002821869488536*G0_0_2 - 0.002821869488536*G0_1_0 + 0.016931216931217*G0_1_1 + 0.016931216931217*G0_1_2 - 0.002821869488536*G0_2_0 + 0.016931216931217*G0_2_1 + 0.016931216931217*G0_2_2;
    A[826] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_1_0 + 0.022574955908289*G0_1_1 + 0.022574955908289*G0_1_2 - 0.011287477954145*G0_2_0 + 0.022574955908289*G0_2_1 + 0.022574955908289*G0_2_2;
    A[827] = -0.135449735449736*G0_0_0 - 0.045149911816578*G0_0_1 - 0.067724867724868*G0_0_2 + 0.225749559082892*G0_1_0 - 0.135449735449735*G0_1_1 + 0.067724867724867*G0_1_2 + 0.067724867724867*G0_2_0 - 0.067724867724868*G0_2_1;
    A[828] = 0.541798941798941*G0_0_0 + 0.270899470899470*G0_0_1 + 0.270899470899470*G0_0_2 + 0.270899470899470*G0_1_0 + 0.632098765432097*G0_1_1 + 0.270899470899470*G0_1_2 + 0.270899470899470*G0_2_0 + 0.270899470899470*G0_2_1 + 0.541798941798941*G0_2_2;
    A[829] = -0.067724867724868*G0_0_1 + 0.067724867724867*G0_0_2 + 0.067724867724867*G0_1_0 - 0.135449735449735*G0_1_1 + 0.225749559082892*G0_1_2 - 0.067724867724868*G0_2_0 - 0.045149911816578*G0_2_1 - 0.135449735449735*G0_2_2;
    A[830] = 0.135449735449735*G0_0_0 + 0.090299823633157*G0_0_1 + 0.067724867724868*G0_0_2 + 0.090299823633157*G0_1_0 + 0.045149911816578*G0_1_1 + 0.045149911816578*G0_1_2 + 0.067724867724867*G0_2_0 + 0.045149911816579*G0_2_1;
    A[831] = -0.541798941798941*G0_0_0 - 0.270899470899471*G0_0_1 - 0.270899470899471*G0_0_2 - 0.270899470899470*G0_1_0 + 0.045149911816579*G0_1_1 - 0.135449735449735*G0_1_2 - 0.270899470899470*G0_2_0 - 0.135449735449735*G0_2_1;
    A[832] = -0.067724867724867*G0_0_1 + 0.067724867724868*G0_0_2 - 0.067724867724867*G0_1_0 - 0.135449735449735*G0_1_1 + 0.045149911816578*G0_1_2 + 0.067724867724868*G0_2_0 + 0.045149911816578*G0_2_1;
    A[833] = 0.045149911816578*G0_0_1 + 0.022574955908289*G0_0_2 + 0.045149911816578*G0_1_0 + 0.090299823633157*G0_1_1 + 0.045149911816578*G0_1_2 + 0.022574955908289*G0_2_0 + 0.045149911816578*G0_2_1;
    A[834] = 0.045149911816578*G0_0_1 + 0.022574955908289*G0_0_2 + 0.045149911816579*G0_1_0 + 0.135449735449735*G0_1_1 + 0.067724867724868*G0_1_2 + 0.022574955908289*G0_2_0 + 0.067724867724868*G0_2_1;
    A[835] = 0.067724867724868*G0_0_1 + 0.022574955908289*G0_0_2 + 0.067724867724867*G0_1_0 + 0.135449735449735*G0_1_1 + 0.045149911816578*G0_1_2 + 0.022574955908289*G0_2_0 + 0.045149911816578*G0_2_1;
    A[836] = 0.045149911816579*G0_0_1 + 0.067724867724868*G0_0_2 + 0.045149911816578*G0_1_0 + 0.045149911816578*G0_1_1 + 0.090299823633157*G0_1_2 + 0.067724867724868*G0_2_0 + 0.090299823633157*G0_2_1 + 0.135449735449735*G0_2_2;
    A[837] = 0.045149911816579*G0_0_1 + 0.067724867724868*G0_0_2 + 0.045149911816578*G0_1_0 - 0.135449735449735*G0_1_1 - 0.067724867724867*G0_1_2 + 0.067724867724868*G0_2_0 - 0.067724867724867*G0_2_1;
    A[838] = -0.135449735449736*G0_0_1 - 0.270899470899470*G0_0_2 - 0.135449735449735*G0_1_0 + 0.045149911816579*G0_1_1 - 0.270899470899470*G0_1_2 - 0.270899470899470*G0_2_0 - 0.270899470899471*G0_2_1 - 0.541798941798941*G0_2_2;
    A[839] = -0.316049382716048*G0_0_1 - 0.135449735449735*G0_0_2 - 0.316049382716049*G0_1_0 - 0.722398589065254*G0_1_1 - 0.316049382716049*G0_1_2 - 0.135449735449735*G0_2_0 - 0.316049382716048*G0_2_1;
    A[840] = 0.018342151675485*G0_0_0 + 0.018342151675485*G0_0_1 + 0.018342151675485*G0_0_2 + 0.018342151675485*G0_1_0 + 0.018342151675485*G0_1_1 + 0.018342151675485*G0_1_2 + 0.018342151675485*G0_2_0 + 0.018342151675485*G0_2_1 + 0.018342151675485*G0_2_2;
    A[841] = -0.018342151675485*G0_0_0 + 0.007054673721341*G0_1_0 + 0.007054673721341*G0_2_0;
    A[842] = 0.007054673721340*G0_0_1 - 0.018342151675485*G0_1_1 + 0.007054673721340*G0_2_1;
    A[843] = 0.007054673721340*G0_0_2 + 0.007054673721340*G0_1_2 + 0.049382716049383*G0_2_2;
    A[844] = -0.067724867724868*G0_0_1 - 0.022574955908289*G0_0_2 + 0.067724867724868*G0_1_1 + 0.011287477954145*G0_1_2 - 0.033862433862434*G0_2_1 - 0.022574955908289*G0_2_2;
    A[845] = 0.186243386243386*G0_0_1 + 0.050793650793650*G0_0_2 - 0.084656084656085*G0_1_1 - 0.042328042328043*G0_1_2 + 0.093121693121693*G0_2_1 + 0.118518518518518*G0_2_2;
    A[846] = 0.112874779541446*G0_0_1 + 0.203174603174603*G0_0_2 + 0.112874779541446*G0_1_1 + 0.101587301587302*G0_1_2 + 0.011287477954145*G0_2_1 - 0.067724867724867*G0_2_2;
    A[847] = 0.067724867724868*G0_0_0 + 0.011287477954145*G0_0_2 - 0.067724867724868*G0_1_0 - 0.022574955908289*G0_1_2 - 0.033862433862434*G0_2_0 - 0.022574955908289*G0_2_2;
    A[848] = -0.084656084656084*G0_0_0 - 0.042328042328042*G0_0_2 + 0.186243386243386*G0_1_0 + 0.050793650793650*G0_1_2 + 0.093121693121693*G0_2_0 + 0.118518518518518*G0_2_2;
    A[849] = 0.112874779541446*G0_0_0 + 0.101587301587302*G0_0_2 + 0.112874779541446*G0_1_0 + 0.203174603174603*G0_1_2 + 0.011287477954145*G0_2_0 - 0.067724867724867*G0_2_2;
    A[850] = 0.022574955908289*G0_0_0 + 0.011287477954145*G0_0_1 - 0.033862433862434*G0_1_0 - 0.022574955908289*G0_1_1 - 0.067724867724867*G0_2_0 - 0.022574955908289*G0_2_1;
    A[851] = -0.016931216931217*G0_0_0 - 0.019753086419753*G0_0_1 - 0.019753086419753*G0_1_0 - 0.016931216931217*G0_1_1 - 0.084656084656084*G0_2_0 - 0.084656084656084*G0_2_1;
    A[852] = -0.022574955908289*G0_0_0 - 0.033862433862434*G0_0_1 + 0.011287477954145*G0_1_0 + 0.022574955908289*G0_1_1 - 0.022574955908289*G0_2_0 - 0.067724867724868*G0_2_1;
    A[853] = -0.067724867724868*G0_0_0 - 0.067724867724868*G0_0_1 - 0.056437389770723*G0_0_2 - 0.067724867724867*G0_1_0 - 0.067724867724867*G0_1_1 - 0.056437389770723*G0_1_2 - 0.056437389770723*G0_2_0 - 0.056437389770723*G0_2_1 - 0.045149911816578*G0_2_2;
    A[854] = 0.084656084656085*G0_0_0 + 0.084656084656085*G0_0_1 + 0.042328042328042*G0_0_2 + 0.084656084656084*G0_1_0 + 0.084656084656084*G0_1_1 + 0.042328042328042*G0_1_2 + 0.042328042328042*G0_2_0 + 0.042328042328042*G0_2_1 + 0.022574955908289*G0_2_2;
    A[855] = -0.112874779541446*G0_0_0 - 0.112874779541446*G0_0_1 - 0.011287477954145*G0_0_2 - 0.112874779541446*G0_1_0 - 0.112874779541446*G0_1_1 - 0.011287477954144*G0_1_2 - 0.011287477954145*G0_2_0 - 0.011287477954145*G0_2_1 - 0.045149911816578*G0_2_2;
    A[856] = -0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_1 - 0.022574955908289*G0_0_2 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_2 - 0.022574955908289*G0_2_0 - 0.011287477954145*G0_2_1 - 0.022574955908289*G0_2_2;
    A[857] = 0.016931216931217*G0_0_0 - 0.002821869488536*G0_0_1 + 0.016931216931217*G0_0_2 - 0.002821869488536*G0_1_0 - 0.002821869488536*G0_1_2 + 0.016931216931217*G0_2_0 - 0.002821869488536*G0_2_1 + 0.016931216931217*G0_2_2;
    A[858] = 0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_1 + 0.022574955908289*G0_0_2 - 0.011287477954145*G0_1_0 - 0.011287477954145*G0_1_2 + 0.022574955908289*G0_2_0 - 0.011287477954145*G0_2_1 + 0.022574955908289*G0_2_2;
    A[859] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_1 - 0.022574955908289*G0_1_2 - 0.011287477954145*G0_2_0 - 0.022574955908289*G0_2_1 - 0.022574955908289*G0_2_2;
    A[860] = -0.002821869488536*G0_0_1 - 0.002821869488536*G0_0_2 - 0.002821869488536*G0_1_0 + 0.016931216931217*G0_1_1 + 0.016931216931217*G0_1_2 - 0.002821869488536*G0_2_0 + 0.016931216931217*G0_2_1 + 0.016931216931217*G0_2_2;
    A[861] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_1_0 + 0.022574955908289*G0_1_1 + 0.022574955908289*G0_1_2 - 0.011287477954145*G0_2_0 + 0.022574955908289*G0_2_1 + 0.022574955908289*G0_2_2;
    A[862] = -0.135449735449735*G0_0_0 - 0.067724867724867*G0_0_1 - 0.045149911816578*G0_0_2 + 0.067724867724868*G0_1_0 - 0.067724867724867*G0_1_2 + 0.225749559082892*G0_2_0 + 0.067724867724868*G0_2_1 - 0.135449735449735*G0_2_2;
    A[863] = 0.067724867724867*G0_0_1 - 0.067724867724868*G0_0_2 - 0.067724867724868*G0_1_0 - 0.135449735449735*G0_1_1 - 0.045149911816578*G0_1_2 + 0.067724867724867*G0_2_0 + 0.225749559082892*G0_2_1 - 0.135449735449735*G0_2_2;
    A[864] = 0.541798941798941*G0_0_0 + 0.270899470899470*G0_0_1 + 0.270899470899470*G0_0_2 + 0.270899470899470*G0_1_0 + 0.541798941798941*G0_1_1 + 0.270899470899470*G0_1_2 + 0.270899470899470*G0_2_0 + 0.270899470899470*G0_2_1 + 0.632098765432097*G0_2_2;
    A[865] = 0.135449735449736*G0_0_0 + 0.067724867724868*G0_0_1 + 0.090299823633157*G0_0_2 + 0.067724867724867*G0_1_0 + 0.045149911816578*G0_1_2 + 0.090299823633157*G0_2_0 + 0.045149911816578*G0_2_1 + 0.045149911816578*G0_2_2;
    A[866] = 0.067724867724867*G0_0_1 - 0.067724867724867*G0_0_2 + 0.067724867724868*G0_1_0 + 0.045149911816579*G0_1_2 - 0.067724867724867*G0_2_0 + 0.045149911816579*G0_2_1 - 0.135449735449735*G0_2_2;
    A[867] = -0.541798941798941*G0_0_0 - 0.270899470899470*G0_0_1 - 0.270899470899471*G0_0_2 - 0.270899470899471*G0_1_0 - 0.135449735449735*G0_1_2 - 0.270899470899470*G0_2_0 - 0.135449735449735*G0_2_1 + 0.045149911816579*G0_2_2;
    A[868] = 0.067724867724868*G0_0_1 + 0.045149911816579*G0_0_2 + 0.067724867724868*G0_1_0 + 0.135449735449735*G0_1_1 + 0.090299823633157*G0_1_2 + 0.045149911816578*G0_2_0 + 0.090299823633157*G0_2_1 + 0.045149911816578*G0_2_2;
    A[869] = 0.067724867724867*G0_0_1 + 0.045149911816578*G0_0_2 + 0.067724867724868*G0_1_0 - 0.067724867724867*G0_1_2 + 0.045149911816578*G0_2_0 - 0.067724867724868*G0_2_1 - 0.135449735449735*G0_2_2;
    A[870] = -0.270899470899470*G0_0_1 - 0.135449735449735*G0_0_2 - 0.270899470899470*G0_1_0 - 0.541798941798941*G0_1_1 - 0.270899470899471*G0_1_2 - 0.135449735449735*G0_2_0 - 0.270899470899470*G0_2_1 + 0.045149911816578*G0_2_2;
    A[871] = 0.022574955908289*G0_0_1 + 0.045149911816579*G0_0_2 + 0.022574955908289*G0_1_0 + 0.045149911816578*G0_1_2 + 0.045149911816578*G0_2_0 + 0.045149911816578*G0_2_1 + 0.090299823633157*G0_2_2;
    A[872] = 0.022574955908289*G0_0_1 + 0.045149911816578*G0_0_2 + 0.022574955908289*G0_1_0 + 0.067724867724867*G0_1_2 + 0.045149911816578*G0_2_0 + 0.067724867724867*G0_2_1 + 0.135449735449735*G0_2_2;
    A[873] = 0.022574955908289*G0_0_1 + 0.067724867724868*G0_0_2 + 0.022574955908289*G0_1_0 + 0.045149911816578*G0_1_2 + 0.067724867724868*G0_2_0 + 0.045149911816579*G0_2_1 + 0.135449735449735*G0_2_2;
    A[874] = -0.135449735449735*G0_0_1 - 0.316049382716048*G0_0_2 - 0.135449735449735*G0_1_0 - 0.316049382716049*G0_1_2 - 0.316049382716049*G0_2_0 - 0.316049382716049*G0_2_1 - 0.722398589065254*G0_2_2;
    A[875] = 0.049382716049383*G0_0_0 + 0.049382716049383*G0_0_1 + 0.049382716049383*G0_0_2 + 0.042328042328042*G0_1_0 + 0.042328042328042*G0_1_1 + 0.042328042328042*G0_1_2 + 0.042328042328042*G0_2_0 + 0.042328042328042*G0_2_1 + 0.042328042328042*G0_2_2;
    A[876] = 0.018342151675485*G0_0_0;
    A[877] = -0.007054673721340*G0_0_1 - 0.025396825396825*G0_1_1;
    A[878] = -0.007054673721340*G0_0_2 - 0.025396825396825*G0_2_2;
    A[879] = 0.067724867724868*G0_0_1 + 0.022574955908289*G0_0_2 + 0.090299823633157*G0_1_1 + 0.033862433862434*G0_1_2 + 0.033862433862434*G0_2_1;
    A[880] = 0.084656084656085*G0_0_1 + 0.084656084656085*G0_0_2 + 0.067724867724868*G0_1_1 + 0.064902998236332*G0_1_2 + 0.064902998236332*G0_2_1 + 0.067724867724868*G0_2_2;
    A[881] = 0.022574955908289*G0_0_1 + 0.067724867724868*G0_0_2 + 0.033862433862434*G0_1_2 + 0.033862433862434*G0_2_1 + 0.090299823633157*G0_2_2;
    A[882] = -0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0;
    A[883] = 0.016931216931217*G0_0_0 + 0.019753086419753*G0_0_2 + 0.019753086419753*G0_2_0 + 0.022574955908289*G0_2_2;
    A[884] = 0.022574955908289*G0_0_0 + 0.033862433862434*G0_0_2 + 0.033862433862434*G0_2_0 + 0.045149911816578*G0_2_2;
    A[885] = -0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0;
    A[886] = 0.016931216931217*G0_0_0 + 0.019753086419753*G0_0_1 + 0.019753086419753*G0_1_0 + 0.022574955908289*G0_1_1;
    A[887] = 0.022574955908289*G0_0_0 + 0.033862433862434*G0_0_1 + 0.033862433862434*G0_1_0 + 0.045149911816579*G0_1_1;
    A[888] = -0.067724867724868*G0_0_0 - 0.067724867724868*G0_0_1 - 0.079012345679013*G0_0_2 - 0.270899470899471*G0_1_0 - 0.270899470899471*G0_1_1 - 0.169312169312169*G0_1_2 - 0.169312169312169*G0_2_0 - 0.169312169312169*G0_2_1 - 0.067724867724868*G0_2_2;
    A[889] = 0.118518518518518*G0_0_0 + 0.118518518518518*G0_0_1 + 0.025396825396826*G0_0_2 + 0.067724867724868*G0_1_0 + 0.067724867724868*G0_1_1 + 0.160846560846561*G0_1_2 + 0.160846560846560*G0_2_0 + 0.160846560846561*G0_2_1 - 0.016931216931217*G0_2_2;
    A[890] = -0.022574955908289*G0_0_0 - 0.022574955908289*G0_0_1 + 0.011287477954145*G0_0_2 - 0.033862433862434*G0_1_2 - 0.033862433862434*G0_2_0 - 0.033862433862434*G0_2_1 + 0.067724867724868*G0_2_2;
    A[891] = -0.067724867724868*G0_0_0 - 0.079012345679013*G0_0_1 - 0.067724867724868*G0_0_2 - 0.169312169312169*G0_1_0 - 0.067724867724868*G0_1_1 - 0.169312169312169*G0_1_2 - 0.270899470899471*G0_2_0 - 0.169312169312169*G0_2_1 - 0.270899470899471*G0_2_2;
    A[892] = 0.118518518518519*G0_0_0 + 0.025396825396826*G0_0_1 + 0.118518518518519*G0_0_2 + 0.160846560846561*G0_1_0 - 0.016931216931217*G0_1_1 + 0.160846560846561*G0_1_2 + 0.067724867724868*G0_2_0 + 0.160846560846561*G0_2_1 + 0.067724867724868*G0_2_2;
    A[893] = -0.022574955908289*G0_0_0 + 0.011287477954144*G0_0_1 - 0.022574955908289*G0_0_2 - 0.033862433862434*G0_1_0 + 0.067724867724867*G0_1_1 - 0.033862433862434*G0_1_2 - 0.033862433862434*G0_2_1;
    A[894] = -0.045149911816579*G0_0_0 - 0.033862433862434*G0_0_1 - 0.033862433862434*G0_0_2 - 0.033862433862434*G0_1_0 - 0.135449735449735*G0_1_1 - 0.135449735449735*G0_1_2 - 0.033862433862434*G0_2_0 - 0.135449735449735*G0_2_1 - 0.135449735449735*G0_2_2;
    A[895] = 0.022574955908289*G0_0_0 - 0.019753086419753*G0_0_1 - 0.019753086419753*G0_0_2 - 0.019753086419753*G0_1_0 + 0.022574955908289*G0_1_1 + 0.022574955908289*G0_1_2 - 0.019753086419753*G0_2_0 + 0.022574955908289*G0_2_1 + 0.022574955908289*G0_2_2;
    A[896] = -0.045149911816579*G0_0_0 + 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954144*G0_2_0;
    A[897] = 0.090299823633156*G0_0_0 + 0.045149911816578*G0_0_1 + 0.045149911816578*G0_0_2 + 0.045149911816578*G0_1_0 + 0.022574955908289*G0_1_2 + 0.045149911816578*G0_2_0 + 0.022574955908289*G0_2_1;
    A[898] = 0.135449735449735*G0_0_0 + 0.090299823633157*G0_0_1 + 0.067724867724867*G0_0_2 + 0.090299823633157*G0_1_0 + 0.045149911816578*G0_1_1 + 0.045149911816579*G0_1_2 + 0.067724867724868*G0_2_0 + 0.045149911816578*G0_2_1;
    A[899] = 0.135449735449736*G0_0_0 + 0.067724867724867*G0_0_1 + 0.090299823633157*G0_0_2 + 0.067724867724868*G0_1_0 + 0.045149911816578*G0_1_2 + 0.090299823633157*G0_2_0 + 0.045149911816578*G0_2_1 + 0.045149911816578*G0_2_2;
    A[900] = 0.632098765432099*G0_0_0 + 0.361199294532628*G0_0_1 + 0.361199294532628*G0_0_2 + 0.361199294532628*G0_1_0 + 0.632098765432099*G0_1_1 + 0.361199294532628*G0_1_2 + 0.361199294532628*G0_2_0 + 0.361199294532628*G0_2_1 + 0.632098765432098*G0_2_2;
    A[901] = -0.135449735449735*G0_0_0 - 0.361199294532628*G0_0_1 - 0.203174603174604*G0_0_2 - 0.090299823633157*G0_1_0 - 0.451499118165785*G0_1_1 - 0.225749559082893*G0_1_2 - 0.067724867724868*G0_2_0 - 0.225749559082893*G0_2_1 - 0.135449735449736*G0_2_2;
    A[902] = -0.135449735449735*G0_0_0 - 0.203174603174603*G0_0_1 - 0.361199294532628*G0_0_2 - 0.067724867724868*G0_1_0 - 0.135449735449735*G0_1_1 - 0.225749559082892*G0_1_2 - 0.090299823633157*G0_2_0 - 0.225749559082892*G0_2_1 - 0.451499118165784*G0_2_2;
    A[903] = 0.045149911816578*G0_0_0 + 0.316049382716049*G0_0_1 + 0.180599647266314*G0_0_2 + 0.316049382716049*G0_1_0 + 0.045149911816579*G0_1_1 + 0.180599647266314*G0_1_2 + 0.180599647266314*G0_2_0 + 0.180599647266313*G0_2_1 + 0.316049382716049*G0_2_2;
    A[904] = 0.045149911816579*G0_0_0 - 0.045149911816578*G0_0_1 - 0.045149911816579*G0_1_0 - 0.022574955908289*G0_1_2 - 0.022574955908289*G0_2_1 - 0.045149911816578*G0_2_2;
    A[905] = -0.135449735449735*G0_0_0 - 0.067724867724867*G0_0_1 - 0.180599647266314*G0_0_2 - 0.067724867724868*G0_1_0 - 0.045149911816579*G0_1_2 - 0.180599647266313*G0_2_0 - 0.045149911816578*G0_2_1 - 0.225749559082892*G0_2_2;
    A[906] = 0.045149911816578*G0_0_0 + 0.180599647266314*G0_0_1 + 0.316049382716049*G0_0_2 + 0.180599647266314*G0_1_0 + 0.316049382716049*G0_1_1 + 0.180599647266314*G0_1_2 + 0.316049382716049*G0_2_0 + 0.180599647266314*G0_2_1 + 0.045149911816579*G0_2_2;
    A[907] = 0.045149911816579*G0_0_0 - 0.045149911816578*G0_0_2 - 0.045149911816578*G0_1_1 - 0.022574955908289*G0_1_2 - 0.045149911816578*G0_2_0 - 0.022574955908289*G0_2_1;
    A[908] = -0.135449735449736*G0_0_0 - 0.180599647266314*G0_0_1 - 0.067724867724867*G0_0_2 - 0.180599647266314*G0_1_0 - 0.225749559082893*G0_1_1 - 0.045149911816578*G0_1_2 - 0.067724867724868*G0_2_0 - 0.045149911816579*G0_2_1;
    A[909] = -0.722398589065255*G0_0_0 - 0.406349206349206*G0_0_1 - 0.406349206349206*G0_0_2 - 0.406349206349206*G0_1_0 - 0.090299823633157*G0_1_1 - 0.225749559082892*G0_1_2 - 0.406349206349206*G0_2_0 - 0.225749559082892*G0_2_1 - 0.090299823633157*G0_2_2;
    A[910] = -0.018342151675485*G0_0_0 - 0.018342151675485*G0_0_1 - 0.018342151675485*G0_0_2 - 0.025396825396826*G0_1_0 - 0.025396825396825*G0_1_1 - 0.025396825396825*G0_1_2 - 0.025396825396825*G0_2_0 - 0.025396825396825*G0_2_1 - 0.025396825396826*G0_2_2;
    A[911] = 0.018342151675485*G0_0_0;
    A[912] = -0.007054673721340*G0_0_1 + 0.042328042328042*G0_1_1;
    A[913] = -0.007054673721340*G0_0_2 - 0.025396825396825*G0_2_2;
    A[914] = -0.203174603174603*G0_0_1 - 0.112874779541446*G0_0_2 - 0.270899470899471*G0_1_1 - 0.101587301587302*G0_1_2 - 0.101587301587302*G0_2_1;
    A[915] = -0.050793650793651*G0_0_1 - 0.186243386243386*G0_0_2 + 0.067724867724867*G0_1_1 - 0.093121693121693*G0_1_2 - 0.093121693121693*G0_2_1 - 0.270899470899471*G0_2_2;
    A[916] = 0.022574955908289*G0_0_1 + 0.067724867724868*G0_0_2 + 0.033862433862434*G0_1_2 + 0.033862433862434*G0_2_1 + 0.135449735449735*G0_2_2;
    A[917] = -0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0;
    A[918] = 0.016931216931217*G0_0_0 + 0.019753086419753*G0_0_2 + 0.019753086419753*G0_2_0 + 0.022574955908289*G0_2_2;
    A[919] = 0.022574955908289*G0_0_0 + 0.033862433862434*G0_0_2 + 0.033862433862434*G0_2_0 + 0.045149911816579*G0_2_2;
    A[920] = -0.067724867724868*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0;
    A[921] = 0.084656084656085*G0_0_0 + 0.042328042328043*G0_0_1 + 0.042328042328043*G0_1_0 + 0.022574955908289*G0_1_1;
    A[922] = -0.112874779541446*G0_0_0 - 0.101587301587302*G0_0_1 - 0.101587301587302*G0_1_0 - 0.135449735449735*G0_1_1;
    A[923] = 0.022574955908289*G0_0_0 + 0.022574955908289*G0_0_1 + 0.011287477954145*G0_0_2 + 0.090299823633157*G0_1_0 + 0.090299823633157*G0_1_1 + 0.056437389770723*G0_1_2 + 0.056437389770723*G0_2_0 + 0.056437389770723*G0_2_1 + 0.022574955908289*G0_2_2;
    A[924] = -0.016931216931217*G0_0_0 - 0.016931216931217*G0_0_1 + 0.002821869488536*G0_0_2 + 0.067724867724868*G0_1_0 + 0.067724867724868*G0_1_1 + 0.002821869488536*G0_1_2 + 0.002821869488536*G0_2_0 + 0.002821869488536*G0_2_1 + 0.005643738977072*G0_2_2;
    A[925] = -0.022574955908289*G0_0_0 - 0.022574955908289*G0_0_1 + 0.011287477954145*G0_0_2 - 0.033862433862434*G0_1_2 - 0.033862433862434*G0_2_0 - 0.033862433862434*G0_2_1 + 0.022574955908289*G0_2_2;
    A[926] = 0.067724867724868*G0_0_0 + 0.056437389770723*G0_0_1 + 0.067724867724868*G0_0_2 + 0.101587301587302*G0_1_0 + 0.067724867724868*G0_1_1 + 0.101587301587302*G0_1_2 + 0.135449735449736*G0_2_0 + 0.101587301587302*G0_2_1 + 0.135449735449736*G0_2_2;
    A[927] = -0.084656084656085*G0_0_0 - 0.042328042328042*G0_0_1 - 0.084656084656085*G0_0_2 - 0.177777777777778*G0_1_0 - 0.016931216931217*G0_1_1 - 0.177777777777778*G0_1_2 - 0.270899470899471*G0_2_0 - 0.177777777777778*G0_2_1 - 0.270899470899471*G0_2_2;
    A[928] = 0.112874779541446*G0_0_0 + 0.011287477954145*G0_0_1 + 0.112874779541446*G0_0_2 + 0.101587301587302*G0_1_0 - 0.067724867724868*G0_1_1 + 0.101587301587302*G0_1_2 + 0.101587301587301*G0_2_1;
    A[929] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 + 0.045149911816579*G0_1_1 + 0.045149911816579*G0_1_2 + 0.011287477954145*G0_2_0 + 0.045149911816578*G0_2_1 + 0.045149911816578*G0_2_2;
    A[930] = 0.002821869488536*G0_0_1 + 0.002821869488536*G0_0_2 + 0.002821869488536*G0_1_0 + 0.022574955908289*G0_1_1 + 0.022574955908289*G0_1_2 + 0.002821869488536*G0_2_0 + 0.022574955908289*G0_2_1 + 0.022574955908289*G0_2_2;
    A[931] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_2_0;
    A[932] = 0.135449735449736*G0_0_0 + 0.045149911816578*G0_0_1 + 0.067724867724868*G0_0_2 + 0.045149911816579*G0_1_0 + 0.022574955908290*G0_1_2 + 0.067724867724868*G0_2_0 + 0.022574955908289*G0_2_1;
    A[933] = -0.541798941798941*G0_0_0 - 0.270899470899470*G0_0_1 - 0.270899470899470*G0_0_2 - 0.270899470899471*G0_1_0 + 0.045149911816579*G0_1_1 - 0.135449735449735*G0_1_2 - 0.270899470899471*G0_2_0 - 0.135449735449735*G0_2_1;
    A[934] = 0.067724867724868*G0_0_1 - 0.067724867724867*G0_0_2 + 0.067724867724867*G0_1_0 + 0.045149911816579*G0_1_2 - 0.067724867724867*G0_2_0 + 0.045149911816579*G0_2_1 - 0.135449735449735*G0_2_2;
    A[935] = -0.135449735449735*G0_0_0 - 0.090299823633157*G0_0_1 - 0.067724867724868*G0_0_2 - 0.361199294532628*G0_1_0 - 0.451499118165785*G0_1_1 - 0.225749559082893*G0_1_2 - 0.203174603174604*G0_2_0 - 0.225749559082893*G0_2_1 - 0.135449735449736*G0_2_2;
    A[936] = 0.541798941798941*G0_0_0 + 0.270899470899471*G0_0_1 + 0.270899470899471*G0_0_2 + 0.270899470899471*G0_1_0 + 0.632098765432099*G0_1_1 + 0.270899470899471*G0_1_2 + 0.270899470899471*G0_2_0 + 0.270899470899471*G0_2_1 + 0.541798941798941*G0_2_2;
    A[937] = 0.067724867724867*G0_0_1 - 0.067724867724868*G0_0_2 - 0.067724867724868*G0_1_0 - 0.135449735449735*G0_1_1 + 0.090299823633157*G0_1_2 + 0.067724867724867*G0_2_0 + 0.090299823633157*G0_2_1 - 0.135449735449735*G0_2_2;
    A[938] = -0.045149911816578*G0_0_1 - 0.022574955908289*G0_0_2 - 0.045149911816579*G0_1_0 + 0.045149911816578*G0_1_1 - 0.022574955908290*G0_2_0 - 0.045149911816579*G0_2_2;
    A[939] = -0.045149911816578*G0_0_1 - 0.022574955908289*G0_0_2 - 0.045149911816578*G0_1_0 - 0.022574955908289*G0_1_2 - 0.022574955908289*G0_2_0 - 0.022574955908289*G0_2_1 - 0.045149911816578*G0_2_2;
    A[940] = -0.067724867724868*G0_0_1 - 0.022574955908289*G0_0_2 - 0.067724867724868*G0_1_0 - 0.045149911816578*G0_1_2 - 0.022574955908289*G0_2_0 - 0.045149911816579*G0_2_1 - 0.045149911816578*G0_2_2;
    A[941] = -0.045149911816579*G0_0_1 - 0.067724867724868*G0_0_2 - 0.045149911816579*G0_1_0 - 0.225749559082893*G0_1_1 - 0.180599647266314*G0_1_2 - 0.067724867724868*G0_2_0 - 0.180599647266314*G0_2_1 - 0.135449735449736*G0_2_2;
    A[942] = -0.045149911816579*G0_0_1 - 0.067724867724867*G0_0_2 - 0.045149911816578*G0_1_0 - 0.045149911816579*G0_1_1 - 0.022574955908289*G0_1_2 - 0.067724867724867*G0_2_0 - 0.022574955908289*G0_2_1;
    A[943] = 0.135449735449735*G0_0_1 + 0.270899470899470*G0_0_2 + 0.135449735449735*G0_1_0 + 0.316049382716049*G0_1_1 + 0.135449735449735*G0_1_2 + 0.270899470899470*G0_2_0 + 0.135449735449736*G0_2_1;
    A[944] = 0.316049382716048*G0_0_1 + 0.135449735449735*G0_0_2 + 0.316049382716049*G0_1_0 - 0.090299823633157*G0_1_1 + 0.135449735449736*G0_1_2 + 0.135449735449736*G0_2_0 + 0.135449735449735*G0_2_1 + 0.270899470899471*G0_2_2;
    A[945] = -0.018342151675485*G0_0_0 - 0.018342151675485*G0_0_1 - 0.018342151675485*G0_0_2 - 0.025396825396825*G0_1_0 - 0.025396825396825*G0_1_1 - 0.025396825396825*G0_1_2 - 0.025396825396825*G0_2_0 - 0.025396825396825*G0_2_1 - 0.025396825396825*G0_2_2;
    A[946] = 0.018342151675485*G0_0_0;
    A[947] = -0.007054673721340*G0_0_1 - 0.025396825396825*G0_1_1;
    A[948] = -0.007054673721340*G0_0_2 + 0.042328042328042*G0_2_2;
    A[949] = 0.067724867724868*G0_0_1 + 0.022574955908289*G0_0_2 + 0.135449735449735*G0_1_1 + 0.033862433862434*G0_1_2 + 0.033862433862434*G0_2_1;
    A[950] = -0.186243386243386*G0_0_1 - 0.050793650793650*G0_0_2 - 0.270899470899471*G0_1_1 - 0.093121693121693*G0_1_2 - 0.093121693121693*G0_2_1 + 0.067724867724868*G0_2_2;
    A[951] = -0.112874779541446*G0_0_1 - 0.203174603174603*G0_0_2 - 0.101587301587302*G0_1_2 - 0.101587301587302*G0_2_1 - 0.270899470899471*G0_2_2;
    A[952] = -0.067724867724868*G0_0_0 - 0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0;
    A[953] = 0.084656084656084*G0_0_0 + 0.042328042328042*G0_0_2 + 0.042328042328042*G0_2_0 + 0.022574955908290*G0_2_2;
    A[954] = -0.112874779541446*G0_0_0 - 0.101587301587302*G0_0_2 - 0.101587301587302*G0_2_0 - 0.135449735449735*G0_2_2;
    A[955] = -0.022574955908289*G0_0_0 - 0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0;
    A[956] = 0.016931216931217*G0_0_0 + 0.019753086419753*G0_0_1 + 0.019753086419753*G0_1_0 + 0.022574955908289*G0_1_1;
    A[957] = 0.022574955908289*G0_0_0 + 0.033862433862434*G0_0_1 + 0.033862433862434*G0_1_0 + 0.045149911816578*G0_1_1;
    A[958] = 0.067724867724868*G0_0_0 + 0.067724867724868*G0_0_1 + 0.056437389770723*G0_0_2 + 0.135449735449735*G0_1_0 + 0.135449735449735*G0_1_1 + 0.101587301587302*G0_1_2 + 0.101587301587302*G0_2_0 + 0.101587301587302*G0_2_1 + 0.067724867724868*G0_2_2;
    A[959] = -0.084656084656085*G0_0_0 - 0.084656084656085*G0_0_1 - 0.042328042328042*G0_0_2 - 0.270899470899471*G0_1_0 - 0.270899470899471*G0_1_1 - 0.177777777777778*G0_1_2 - 0.177777777777778*G0_2_0 - 0.177777777777778*G0_2_1 - 0.016931216931217*G0_2_2;
    A[960] = 0.112874779541446*G0_0_0 + 0.112874779541446*G0_0_1 + 0.011287477954145*G0_0_2 + 0.101587301587301*G0_1_2 + 0.101587301587302*G0_2_0 + 0.101587301587302*G0_2_1 - 0.067724867724868*G0_2_2;
    A[961] = 0.022574955908289*G0_0_0 + 0.011287477954145*G0_0_1 + 0.022574955908289*G0_0_2 + 0.056437389770723*G0_1_0 + 0.022574955908289*G0_1_1 + 0.056437389770723*G0_1_2 + 0.090299823633157*G0_2_0 + 0.056437389770723*G0_2_1 + 0.090299823633157*G0_2_2;
    A[962] = -0.016931216931217*G0_0_0 + 0.002821869488536*G0_0_1 - 0.016931216931217*G0_0_2 + 0.002821869488536*G0_1_0 + 0.005643738977072*G0_1_1 + 0.002821869488536*G0_1_2 + 0.067724867724868*G0_2_0 + 0.002821869488536*G0_2_1 + 0.067724867724868*G0_2_2;
    A[963] = -0.022574955908289*G0_0_0 + 0.011287477954145*G0_0_1 - 0.022574955908289*G0_0_2 - 0.033862433862434*G0_1_0 + 0.022574955908289*G0_1_1 - 0.033862433862434*G0_1_2 - 0.033862433862434*G0_2_1;
    A[964] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 + 0.045149911816578*G0_1_1 + 0.045149911816578*G0_1_2 + 0.011287477954145*G0_2_0 + 0.045149911816578*G0_2_1 + 0.045149911816578*G0_2_2;
    A[965] = 0.002821869488536*G0_0_1 + 0.002821869488536*G0_0_2 + 0.002821869488536*G0_1_0 + 0.022574955908289*G0_1_1 + 0.022574955908289*G0_1_2 + 0.002821869488536*G0_2_0 + 0.022574955908289*G0_2_1 + 0.022574955908289*G0_2_2;
    A[966] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_2_0;
    A[967] = 0.135449735449735*G0_0_0 + 0.067724867724867*G0_0_1 + 0.045149911816578*G0_0_2 + 0.067724867724868*G0_1_0 + 0.022574955908289*G0_1_2 + 0.045149911816579*G0_2_0 + 0.022574955908289*G0_2_1;
    A[968] = -0.067724867724867*G0_0_1 + 0.067724867724868*G0_0_2 - 0.067724867724867*G0_1_0 - 0.135449735449735*G0_1_1 + 0.045149911816578*G0_1_2 + 0.067724867724868*G0_2_0 + 0.045149911816578*G0_2_1;
    A[969] = -0.541798941798941*G0_0_0 - 0.270899470899471*G0_0_1 - 0.270899470899470*G0_0_2 - 0.270899470899470*G0_1_0 - 0.135449735449735*G0_1_2 - 0.270899470899471*G0_2_0 - 0.135449735449735*G0_2_1 + 0.045149911816579*G0_2_2;
    A[970] = -0.135449735449735*G0_0_0 - 0.067724867724868*G0_0_1 - 0.090299823633157*G0_0_2 - 0.203174603174603*G0_1_0 - 0.135449735449735*G0_1_1 - 0.225749559082892*G0_1_2 - 0.361199294532628*G0_2_0 - 0.225749559082892*G0_2_1 - 0.451499118165784*G0_2_2;
    A[971] = -0.067724867724868*G0_0_1 + 0.067724867724867*G0_0_2 + 0.067724867724867*G0_1_0 - 0.135449735449735*G0_1_1 + 0.090299823633157*G0_1_2 - 0.067724867724868*G0_2_0 + 0.090299823633157*G0_2_1 - 0.135449735449735*G0_2_2;
    A[972] = 0.541798941798941*G0_0_0 + 0.270899470899470*G0_0_1 + 0.270899470899471*G0_0_2 + 0.270899470899470*G0_1_0 + 0.541798941798942*G0_1_1 + 0.270899470899471*G0_1_2 + 0.270899470899471*G0_2_0 + 0.270899470899471*G0_2_1 + 0.632098765432098*G0_2_2;
    A[973] = -0.067724867724868*G0_0_1 - 0.045149911816579*G0_0_2 - 0.067724867724868*G0_1_0 - 0.135449735449735*G0_1_1 - 0.180599647266314*G0_1_2 - 0.045149911816578*G0_2_0 - 0.180599647266313*G0_2_1 - 0.225749559082892*G0_2_2;
    A[974] = -0.067724867724867*G0_0_1 - 0.045149911816578*G0_0_2 - 0.067724867724868*G0_1_0 - 0.022574955908289*G0_1_2 - 0.045149911816579*G0_2_0 - 0.022574955908289*G0_2_1 - 0.045149911816579*G0_2_2;
    A[975] = 0.270899470899471*G0_0_1 + 0.135449735449736*G0_0_2 + 0.270899470899470*G0_1_0 + 0.135449735449735*G0_1_2 + 0.135449735449735*G0_2_0 + 0.135449735449735*G0_2_1 + 0.316049382716049*G0_2_2;
    A[976] = -0.022574955908289*G0_0_1 - 0.045149911816578*G0_0_2 - 0.022574955908289*G0_1_0 - 0.045149911816578*G0_1_1 - 0.045149911816578*G0_2_0 + 0.045149911816578*G0_2_2;
    A[977] = -0.022574955908289*G0_0_1 - 0.045149911816578*G0_0_2 - 0.022574955908289*G0_1_0 - 0.045149911816579*G0_1_1 - 0.022574955908289*G0_1_2 - 0.045149911816579*G0_2_0 - 0.022574955908289*G0_2_1;
    A[978] = -0.022574955908289*G0_0_1 - 0.067724867724868*G0_0_2 - 0.022574955908289*G0_1_0 - 0.045149911816578*G0_1_1 - 0.045149911816579*G0_1_2 - 0.067724867724867*G0_2_0 - 0.045149911816579*G0_2_1;
    A[979] = 0.135449735449735*G0_0_1 + 0.316049382716048*G0_0_2 + 0.135449735449735*G0_1_0 + 0.270899470899470*G0_1_1 + 0.135449735449735*G0_1_2 + 0.316049382716049*G0_2_0 + 0.135449735449735*G0_2_1 - 0.090299823633157*G0_2_2;
    A[980] = 0.042328042328042*G0_0_0 + 0.042328042328042*G0_0_1 + 0.042328042328042*G0_0_2 + 0.049382716049383*G0_1_0 + 0.049382716049383*G0_1_1 + 0.049382716049383*G0_1_2 + 0.042328042328042*G0_2_0 + 0.042328042328042*G0_2_1 + 0.042328042328042*G0_2_2;
    A[981] = -0.025396825396825*G0_0_0 - 0.007054673721340*G0_1_0;
    A[982] = 0.018342151675485*G0_1_1;
    A[983] = -0.007054673721340*G0_1_2 - 0.025396825396825*G0_2_2;
    A[984] = -0.022574955908289*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1;
    A[985] = 0.016931216931217*G0_1_1 + 0.019753086419753*G0_1_2 + 0.019753086419753*G0_2_1 + 0.022574955908289*G0_2_2;
    A[986] = 0.022574955908289*G0_1_1 + 0.033862433862434*G0_1_2 + 0.033862433862434*G0_2_1 + 0.045149911816578*G0_2_2;
    A[987] = 0.090299823633157*G0_0_0 + 0.033862433862434*G0_0_2 + 0.067724867724868*G0_1_0 + 0.022574955908289*G0_1_2 + 0.033862433862434*G0_2_0;
    A[988] = 0.067724867724867*G0_0_0 + 0.064902998236331*G0_0_2 + 0.084656084656084*G0_1_0 + 0.084656084656084*G0_1_2 + 0.064902998236331*G0_2_0 + 0.067724867724867*G0_2_2;
    A[989] = 0.033862433862434*G0_0_2 + 0.022574955908289*G0_1_0 + 0.067724867724868*G0_1_2 + 0.033862433862434*G0_2_0 + 0.090299823633157*G0_2_2;
    A[990] = 0.045149911816578*G0_0_0 + 0.033862433862434*G0_0_1 + 0.033862433862434*G0_1_0 + 0.022574955908289*G0_1_1;
    A[991] = 0.022574955908289*G0_0_0 + 0.019753086419753*G0_0_1 + 0.019753086419753*G0_1_0 + 0.016931216931217*G0_1_1;
    A[992] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_1;
    A[993] = -0.270899470899471*G0_0_0 - 0.270899470899471*G0_0_1 - 0.169312169312169*G0_0_2 - 0.067724867724868*G0_1_0 - 0.067724867724868*G0_1_1 - 0.079012345679013*G0_1_2 - 0.169312169312169*G0_2_0 - 0.169312169312169*G0_2_1 - 0.067724867724868*G0_2_2;
    A[994] = 0.067724867724868*G0_0_0 + 0.067724867724868*G0_0_1 + 0.160846560846561*G0_0_2 + 0.118518518518518*G0_1_0 + 0.118518518518518*G0_1_1 + 0.025396825396826*G0_1_2 + 0.160846560846560*G0_2_0 + 0.160846560846560*G0_2_1 - 0.016931216931217*G0_2_2;
    A[995] = -0.033862433862434*G0_0_2 - 0.022574955908289*G0_1_0 - 0.022574955908289*G0_1_1 + 0.011287477954145*G0_1_2 - 0.033862433862434*G0_2_0 - 0.033862433862434*G0_2_1 + 0.067724867724867*G0_2_2;
    A[996] = -0.135449735449735*G0_0_0 - 0.033862433862434*G0_0_1 - 0.135449735449735*G0_0_2 - 0.033862433862434*G0_1_0 - 0.045149911816579*G0_1_1 - 0.033862433862434*G0_1_2 - 0.135449735449735*G0_2_0 - 0.033862433862434*G0_2_1 - 0.135449735449735*G0_2_2;
    A[997] = 0.022574955908289*G0_0_0 - 0.019753086419753*G0_0_1 + 0.022574955908289*G0_0_2 - 0.019753086419753*G0_1_0 + 0.022574955908289*G0_1_1 - 0.019753086419753*G0_1_2 + 0.022574955908289*G0_2_0 - 0.019753086419753*G0_2_1 + 0.022574955908289*G0_2_2;
    A[998] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_1_0 - 0.045149911816579*G0_1_1 + 0.011287477954145*G0_1_2 + 0.011287477954144*G0_2_1;
    A[999] = -0.067724867724868*G0_0_0 - 0.169312169312169*G0_0_1 - 0.169312169312169*G0_0_2 - 0.079012345679012*G0_1_0 - 0.067724867724867*G0_1_1 - 0.067724867724867*G0_1_2 - 0.169312169312169*G0_2_0 - 0.270899470899471*G0_2_1 - 0.270899470899470*G0_2_2;
    A[1000] = -0.016931216931217*G0_0_0 + 0.160846560846561*G0_0_1 + 0.160846560846561*G0_0_2 + 0.025396825396825*G0_1_0 + 0.118518518518518*G0_1_1 + 0.118518518518518*G0_1_2 + 0.160846560846561*G0_2_0 + 0.067724867724868*G0_2_1 + 0.067724867724868*G0_2_2;
    A[1001] = 0.067724867724868*G0_0_0 - 0.033862433862434*G0_0_1 - 0.033862433862434*G0_0_2 + 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_1 - 0.022574955908289*G0_1_2 - 0.033862433862434*G0_2_0;
    A[1002] = 0.045149911816578*G0_0_0 + 0.090299823633156*G0_0_1 + 0.045149911816578*G0_0_2 + 0.090299823633156*G0_1_0 + 0.135449735449735*G0_1_1 + 0.067724867724867*G0_1_2 + 0.045149911816578*G0_2_0 + 0.067724867724867*G0_2_1;
    A[1003] = 0.045149911816578*G0_0_1 + 0.022574955908289*G0_0_2 + 0.045149911816578*G0_1_0 + 0.090299823633157*G0_1_1 + 0.045149911816578*G0_1_2 + 0.022574955908289*G0_2_0 + 0.045149911816578*G0_2_1;
    A[1004] = 0.067724867724868*G0_0_1 + 0.045149911816578*G0_0_2 + 0.067724867724868*G0_1_0 + 0.135449735449735*G0_1_1 + 0.090299823633157*G0_1_2 + 0.045149911816579*G0_2_0 + 0.090299823633157*G0_2_1 + 0.045149911816578*G0_2_2;
    A[1005] = 0.045149911816578*G0_0_0 + 0.316049382716049*G0_0_1 + 0.180599647266314*G0_0_2 + 0.316049382716049*G0_1_0 + 0.045149911816579*G0_1_1 + 0.180599647266313*G0_1_2 + 0.180599647266314*G0_2_0 + 0.180599647266314*G0_2_1 + 0.316049382716049*G0_2_2;
    A[1006] = -0.045149911816579*G0_0_1 - 0.022574955908290*G0_0_2 - 0.045149911816578*G0_1_0 + 0.045149911816578*G0_1_1 - 0.022574955908289*G0_2_0 - 0.045149911816579*G0_2_2;
    A[1007] = -0.067724867724868*G0_0_1 - 0.045149911816578*G0_0_2 - 0.067724867724868*G0_1_0 - 0.135449735449735*G0_1_1 - 0.180599647266313*G0_1_2 - 0.045149911816579*G0_2_0 - 0.180599647266314*G0_2_1 - 0.225749559082892*G0_2_2;
    A[1008] = 0.632098765432099*G0_0_0 + 0.361199294532627*G0_0_1 + 0.361199294532628*G0_0_2 + 0.361199294532627*G0_1_0 + 0.632098765432097*G0_1_1 + 0.361199294532627*G0_1_2 + 0.361199294532627*G0_2_0 + 0.361199294532627*G0_2_1 + 0.632098765432098*G0_2_2;
    A[1009] = -0.451499118165785*G0_0_0 - 0.090299823633156*G0_0_1 - 0.225749559082892*G0_0_2 - 0.361199294532627*G0_1_0 - 0.135449735449735*G0_1_1 - 0.203174603174602*G0_1_2 - 0.225749559082892*G0_2_0 - 0.067724867724867*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1010] = -0.135449735449735*G0_0_0 - 0.067724867724868*G0_0_1 - 0.225749559082892*G0_0_2 - 0.203174603174602*G0_1_0 - 0.135449735449735*G0_1_1 - 0.361199294532627*G0_1_2 - 0.225749559082892*G0_2_0 - 0.090299823633157*G0_2_1 - 0.451499118165784*G0_2_2;
    A[1011] = 0.316049382716049*G0_0_0 + 0.180599647266314*G0_0_1 + 0.180599647266314*G0_0_2 + 0.180599647266314*G0_1_0 + 0.045149911816579*G0_1_1 + 0.316049382716049*G0_1_2 + 0.180599647266314*G0_2_0 + 0.316049382716049*G0_2_1 + 0.045149911816579*G0_2_2;
    A[1012] = -0.225749559082892*G0_0_0 - 0.180599647266314*G0_0_1 - 0.045149911816578*G0_0_2 - 0.180599647266314*G0_1_0 - 0.135449735449735*G0_1_1 - 0.067724867724867*G0_1_2 - 0.045149911816578*G0_2_0 - 0.067724867724868*G0_2_1;
    A[1013] = -0.045149911816579*G0_0_0 - 0.022574955908289*G0_0_2 + 0.045149911816578*G0_1_1 - 0.045149911816578*G0_1_2 - 0.022574955908290*G0_2_0 - 0.045149911816579*G0_2_1;
    A[1014] = -0.090299823633156*G0_0_0 - 0.406349206349206*G0_0_1 - 0.225749559082892*G0_0_2 - 0.406349206349205*G0_1_0 - 0.722398589065254*G0_1_1 - 0.406349206349206*G0_1_2 - 0.225749559082891*G0_2_0 - 0.406349206349205*G0_2_1 - 0.090299823633157*G0_2_2;
    A[1015] = -0.025396825396825*G0_0_0 - 0.025396825396825*G0_0_1 - 0.025396825396825*G0_0_2 - 0.018342151675485*G0_1_0 - 0.018342151675485*G0_1_1 - 0.018342151675485*G0_1_2 - 0.025396825396825*G0_2_0 - 0.025396825396825*G0_2_1 - 0.025396825396825*G0_2_2;
    A[1016] = 0.042328042328042*G0_0_0 - 0.007054673721340*G0_1_0;
    A[1017] = 0.018342151675485*G0_1_1;
    A[1018] = -0.007054673721340*G0_1_2 - 0.025396825396825*G0_2_2;
    A[1019] = -0.022574955908289*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1;
    A[1020] = 0.016931216931217*G0_1_1 + 0.019753086419753*G0_1_2 + 0.019753086419753*G0_2_1 + 0.022574955908289*G0_2_2;
    A[1021] = 0.022574955908289*G0_1_1 + 0.033862433862434*G0_1_2 + 0.033862433862434*G0_2_1 + 0.045149911816578*G0_2_2;
    A[1022] = -0.270899470899471*G0_0_0 - 0.101587301587301*G0_0_2 - 0.203174603174603*G0_1_0 - 0.112874779541446*G0_1_2 - 0.101587301587301*G0_2_0;
    A[1023] = 0.067724867724868*G0_0_0 - 0.093121693121693*G0_0_2 - 0.050793650793650*G0_1_0 - 0.186243386243386*G0_1_2 - 0.093121693121693*G0_2_0 - 0.270899470899470*G0_2_2;
    A[1024] = 0.033862433862434*G0_0_2 + 0.022574955908289*G0_1_0 + 0.067724867724868*G0_1_2 + 0.033862433862434*G0_2_0 + 0.135449735449735*G0_2_2;
    A[1025] = -0.135449735449735*G0_0_0 - 0.101587301587301*G0_0_1 - 0.101587301587302*G0_1_0 - 0.112874779541446*G0_1_1;
    A[1026] = 0.022574955908289*G0_0_0 + 0.042328042328042*G0_0_1 + 0.042328042328042*G0_1_0 + 0.084656084656085*G0_1_1;
    A[1027] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.067724867724868*G0_1_1;
    A[1028] = 0.090299823633157*G0_0_0 + 0.090299823633157*G0_0_1 + 0.056437389770723*G0_0_2 + 0.022574955908289*G0_1_0 + 0.022574955908289*G0_1_1 + 0.011287477954145*G0_1_2 + 0.056437389770723*G0_2_0 + 0.056437389770723*G0_2_1 + 0.022574955908289*G0_2_2;
    A[1029] = 0.067724867724868*G0_0_0 + 0.067724867724868*G0_0_1 + 0.002821869488536*G0_0_2 - 0.016931216931217*G0_1_0 - 0.016931216931217*G0_1_1 + 0.002821869488536*G0_1_2 + 0.002821869488536*G0_2_0 + 0.002821869488536*G0_2_1 + 0.005643738977072*G0_2_2;
    A[1030] = -0.033862433862434*G0_0_2 - 0.022574955908289*G0_1_0 - 0.022574955908289*G0_1_1 + 0.011287477954145*G0_1_2 - 0.033862433862434*G0_2_0 - 0.033862433862434*G0_2_1 + 0.022574955908289*G0_2_2;
    A[1031] = 0.045149911816578*G0_0_0 + 0.011287477954145*G0_0_1 + 0.045149911816578*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_2 + 0.045149911816578*G0_2_0 + 0.011287477954145*G0_2_1 + 0.045149911816578*G0_2_2;
    A[1032] = 0.022574955908289*G0_0_0 + 0.002821869488536*G0_0_1 + 0.022574955908289*G0_0_2 + 0.002821869488536*G0_1_0 + 0.002821869488536*G0_1_2 + 0.022574955908289*G0_2_0 + 0.002821869488536*G0_2_1 + 0.022574955908289*G0_2_2;
    A[1033] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_1;
    A[1034] = 0.067724867724868*G0_0_0 + 0.101587301587301*G0_0_1 + 0.101587301587301*G0_0_2 + 0.056437389770723*G0_1_0 + 0.067724867724867*G0_1_1 + 0.067724867724867*G0_1_2 + 0.101587301587302*G0_2_0 + 0.135449735449735*G0_2_1 + 0.135449735449735*G0_2_2;
    A[1035] = -0.016931216931217*G0_0_0 - 0.177777777777777*G0_0_1 - 0.177777777777777*G0_0_2 - 0.042328042328042*G0_1_0 - 0.084656084656084*G0_1_1 - 0.084656084656084*G0_1_2 - 0.177777777777778*G0_2_0 - 0.270899470899470*G0_2_1 - 0.270899470899470*G0_2_2;
    A[1036] = -0.067724867724868*G0_0_0 + 0.101587301587301*G0_0_1 + 0.101587301587301*G0_0_2 + 0.011287477954145*G0_1_0 + 0.112874779541446*G0_1_1 + 0.112874779541446*G0_1_2 + 0.101587301587302*G0_2_0;
    A[1037] = 0.045149911816579*G0_0_0 - 0.270899470899470*G0_0_1 - 0.135449735449735*G0_0_2 - 0.270899470899470*G0_1_0 - 0.541798941798941*G0_1_1 - 0.270899470899470*G0_1_2 - 0.135449735449735*G0_2_0 - 0.270899470899470*G0_2_1;
    A[1038] = 0.045149911816579*G0_0_1 + 0.022574955908289*G0_0_2 + 0.045149911816578*G0_1_0 + 0.135449735449735*G0_1_1 + 0.067724867724868*G0_1_2 + 0.022574955908289*G0_2_0 + 0.067724867724868*G0_2_1;
    A[1039] = 0.067724867724868*G0_0_1 + 0.045149911816578*G0_0_2 + 0.067724867724867*G0_1_0 - 0.067724867724868*G0_1_2 + 0.045149911816578*G0_2_0 - 0.067724867724867*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1040] = 0.045149911816579*G0_0_0 - 0.045149911816579*G0_0_1 - 0.045149911816578*G0_1_0 - 0.022574955908289*G0_1_2 - 0.022574955908289*G0_2_1 - 0.045149911816578*G0_2_2;
    A[1041] = -0.045149911816578*G0_0_1 - 0.022574955908289*G0_0_2 - 0.045149911816578*G0_1_0 - 0.022574955908289*G0_1_2 - 0.022574955908289*G0_2_0 - 0.022574955908289*G0_2_1 - 0.045149911816578*G0_2_2;
    A[1042] = -0.067724867724868*G0_0_1 - 0.045149911816579*G0_0_2 - 0.067724867724867*G0_1_0 - 0.022574955908289*G0_1_2 - 0.045149911816578*G0_2_0 - 0.022574955908289*G0_2_1 - 0.045149911816579*G0_2_2;
    A[1043] = -0.451499118165785*G0_0_0 - 0.361199294532627*G0_0_1 - 0.225749559082892*G0_0_2 - 0.090299823633156*G0_1_0 - 0.135449735449735*G0_1_1 - 0.067724867724867*G0_1_2 - 0.225749559082892*G0_2_0 - 0.203174603174602*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1044] = 0.632098765432098*G0_0_0 + 0.270899470899470*G0_0_1 + 0.270899470899470*G0_0_2 + 0.270899470899470*G0_1_0 + 0.541798941798941*G0_1_1 + 0.270899470899470*G0_1_2 + 0.270899470899470*G0_2_0 + 0.270899470899470*G0_2_1 + 0.541798941798941*G0_2_2;
    A[1045] = -0.135449735449735*G0_0_0 - 0.067724867724868*G0_0_1 + 0.090299823633157*G0_0_2 + 0.067724867724867*G0_1_0 - 0.067724867724868*G0_1_2 + 0.090299823633156*G0_2_0 + 0.067724867724868*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1046] = -0.225749559082892*G0_0_0 - 0.045149911816579*G0_0_1 - 0.180599647266314*G0_0_2 - 0.045149911816578*G0_1_0 - 0.067724867724867*G0_1_2 - 0.180599647266314*G0_2_0 - 0.067724867724868*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1047] = 0.316049382716049*G0_0_0 + 0.135449735449735*G0_0_1 + 0.135449735449735*G0_0_2 + 0.135449735449735*G0_1_0 + 0.270899470899470*G0_1_2 + 0.135449735449735*G0_2_0 + 0.270899470899470*G0_2_1;
    A[1048] = -0.045149911816578*G0_0_0 - 0.045149911816578*G0_0_1 - 0.022574955908289*G0_0_2 - 0.045149911816579*G0_1_0 - 0.067724867724868*G0_1_2 - 0.022574955908289*G0_2_0 - 0.067724867724867*G0_2_1;
    A[1049] = -0.090299823633158*G0_0_0 + 0.316049382716049*G0_0_1 + 0.135449735449735*G0_0_2 + 0.316049382716048*G0_1_0 + 0.135449735449735*G0_1_2 + 0.135449735449734*G0_2_0 + 0.135449735449735*G0_2_1 + 0.270899470899470*G0_2_2;
    A[1050] = -0.025396825396825*G0_0_0 - 0.025396825396825*G0_0_1 - 0.025396825396825*G0_0_2 - 0.018342151675485*G0_1_0 - 0.018342151675485*G0_1_1 - 0.018342151675485*G0_1_2 - 0.025396825396825*G0_2_0 - 0.025396825396825*G0_2_1 - 0.025396825396825*G0_2_2;
    A[1051] = -0.025396825396826*G0_0_0 - 0.007054673721341*G0_1_0;
    A[1052] = 0.018342151675485*G0_1_1;
    A[1053] = -0.007054673721340*G0_1_2 + 0.042328042328042*G0_2_2;
    A[1054] = -0.067724867724868*G0_1_1 - 0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1;
    A[1055] = 0.084656084656085*G0_1_1 + 0.042328042328043*G0_1_2 + 0.042328042328042*G0_2_1 + 0.022574955908289*G0_2_2;
    A[1056] = -0.112874779541446*G0_1_1 - 0.101587301587302*G0_1_2 - 0.101587301587302*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1057] = 0.135449735449735*G0_0_0 + 0.033862433862433*G0_0_2 + 0.067724867724868*G0_1_0 + 0.022574955908289*G0_1_2 + 0.033862433862434*G0_2_0;
    A[1058] = -0.270899470899470*G0_0_0 - 0.093121693121692*G0_0_2 - 0.186243386243386*G0_1_0 - 0.050793650793650*G0_1_2 - 0.093121693121693*G0_2_0 + 0.067724867724868*G0_2_2;
    A[1059] = -0.101587301587302*G0_0_2 - 0.112874779541446*G0_1_0 - 0.203174603174603*G0_1_2 - 0.101587301587302*G0_2_0 - 0.270899470899471*G0_2_2;
    A[1060] = 0.045149911816578*G0_0_0 + 0.033862433862433*G0_0_1 + 0.033862433862434*G0_1_0 + 0.022574955908289*G0_1_1;
    A[1061] = 0.022574955908289*G0_0_0 + 0.019753086419753*G0_0_1 + 0.019753086419753*G0_1_0 + 0.016931216931217*G0_1_1;
    A[1062] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_1;
    A[1063] = 0.135449735449735*G0_0_0 + 0.135449735449735*G0_0_1 + 0.101587301587301*G0_0_2 + 0.067724867724868*G0_1_0 + 0.067724867724868*G0_1_1 + 0.056437389770723*G0_1_2 + 0.101587301587302*G0_2_0 + 0.101587301587302*G0_2_1 + 0.067724867724868*G0_2_2;
    A[1064] = -0.270899470899470*G0_0_0 - 0.270899470899470*G0_0_1 - 0.177777777777777*G0_0_2 - 0.084656084656084*G0_1_0 - 0.084656084656084*G0_1_1 - 0.042328042328042*G0_1_2 - 0.177777777777777*G0_2_0 - 0.177777777777777*G0_2_1 - 0.016931216931217*G0_2_2;
    A[1065] = 0.101587301587301*G0_0_2 + 0.112874779541446*G0_1_0 + 0.112874779541446*G0_1_1 + 0.011287477954144*G0_1_2 + 0.101587301587301*G0_2_0 + 0.101587301587302*G0_2_1 - 0.067724867724868*G0_2_2;
    A[1066] = 0.045149911816578*G0_0_0 + 0.011287477954145*G0_0_1 + 0.045149911816578*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_2 + 0.045149911816578*G0_2_0 + 0.011287477954145*G0_2_1 + 0.045149911816578*G0_2_2;
    A[1067] = 0.022574955908289*G0_0_0 + 0.002821869488536*G0_0_1 + 0.022574955908289*G0_0_2 + 0.002821869488536*G0_1_0 + 0.002821869488536*G0_1_2 + 0.022574955908289*G0_2_0 + 0.002821869488536*G0_2_1 + 0.022574955908289*G0_2_2;
    A[1068] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_1;
    A[1069] = 0.022574955908289*G0_0_0 + 0.056437389770723*G0_0_1 + 0.056437389770723*G0_0_2 + 0.011287477954145*G0_1_0 + 0.022574955908289*G0_1_1 + 0.022574955908289*G0_1_2 + 0.056437389770723*G0_2_0 + 0.090299823633157*G0_2_1 + 0.090299823633157*G0_2_2;
    A[1070] = 0.005643738977072*G0_0_0 + 0.002821869488536*G0_0_1 + 0.002821869488536*G0_0_2 + 0.002821869488536*G0_1_0 - 0.016931216931217*G0_1_1 - 0.016931216931217*G0_1_2 + 0.002821869488536*G0_2_0 + 0.067724867724867*G0_2_1 + 0.067724867724867*G0_2_2;
    A[1071] = 0.022574955908289*G0_0_0 - 0.033862433862433*G0_0_1 - 0.033862433862433*G0_0_2 + 0.011287477954145*G0_1_0 - 0.022574955908289*G0_1_1 - 0.022574955908289*G0_1_2 - 0.033862433862434*G0_2_0;
    A[1072] = -0.135449735449735*G0_0_0 - 0.067724867724867*G0_0_1 + 0.045149911816578*G0_0_2 - 0.067724867724868*G0_1_0 + 0.067724867724867*G0_1_2 + 0.045149911816579*G0_2_0 + 0.067724867724868*G0_2_1;
    A[1073] = 0.067724867724867*G0_0_1 + 0.022574955908289*G0_0_2 + 0.067724867724868*G0_1_0 + 0.135449735449735*G0_1_1 + 0.045149911816578*G0_1_2 + 0.022574955908289*G0_2_0 + 0.045149911816578*G0_2_1;
    A[1074] = -0.270899470899470*G0_0_1 - 0.135449735449735*G0_0_2 - 0.270899470899470*G0_1_0 - 0.541798941798941*G0_1_1 - 0.270899470899470*G0_1_2 - 0.135449735449735*G0_2_0 - 0.270899470899471*G0_2_1 + 0.045149911816578*G0_2_2;
    A[1075] = -0.135449735449735*G0_0_0 - 0.067724867724868*G0_0_1 - 0.180599647266313*G0_0_2 - 0.067724867724867*G0_1_0 - 0.045149911816578*G0_1_2 - 0.180599647266314*G0_2_0 - 0.045149911816579*G0_2_1 - 0.225749559082892*G0_2_2;
    A[1076] = -0.067724867724868*G0_0_1 - 0.022574955908289*G0_0_2 - 0.067724867724868*G0_1_0 - 0.045149911816579*G0_1_2 - 0.022574955908289*G0_2_0 - 0.045149911816578*G0_2_1 - 0.045149911816578*G0_2_2;
    A[1077] = 0.270899470899470*G0_0_1 + 0.135449735449735*G0_0_2 + 0.270899470899471*G0_1_0 + 0.135449735449735*G0_1_2 + 0.135449735449736*G0_2_0 + 0.135449735449735*G0_2_1 + 0.316049382716049*G0_2_2;
    A[1078] = -0.135449735449735*G0_0_0 - 0.203174603174602*G0_0_1 - 0.225749559082892*G0_0_2 - 0.067724867724868*G0_1_0 - 0.135449735449735*G0_1_1 - 0.090299823633157*G0_1_2 - 0.225749559082892*G0_2_0 - 0.361199294532627*G0_2_1 - 0.451499118165784*G0_2_2;
    A[1079] = -0.135449735449735*G0_0_0 + 0.067724867724867*G0_0_1 + 0.090299823633156*G0_0_2 - 0.067724867724868*G0_1_0 + 0.067724867724868*G0_1_2 + 0.090299823633157*G0_2_0 - 0.067724867724868*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1080] = 0.541798941798940*G0_0_0 + 0.270899470899470*G0_0_1 + 0.270899470899470*G0_0_2 + 0.270899470899470*G0_1_0 + 0.541798941798941*G0_1_1 + 0.270899470899471*G0_1_2 + 0.270899470899470*G0_2_0 + 0.270899470899471*G0_2_1 + 0.632098765432098*G0_2_2;
    A[1081] = -0.045149911816578*G0_0_0 - 0.022574955908289*G0_0_1 - 0.022574955908289*G0_1_0 - 0.045149911816578*G0_1_2 - 0.045149911816579*G0_2_1 + 0.045149911816578*G0_2_2;
    A[1082] = -0.045149911816578*G0_0_0 - 0.022574955908289*G0_0_1 - 0.045149911816578*G0_0_2 - 0.022574955908289*G0_1_0 - 0.067724867724867*G0_1_2 - 0.045149911816578*G0_2_0 - 0.067724867724867*G0_2_1;
    A[1083] = -0.045149911816578*G0_0_0 - 0.022574955908289*G0_0_1 - 0.022574955908289*G0_0_2 - 0.022574955908289*G0_1_0 - 0.045149911816578*G0_1_2 - 0.022574955908289*G0_2_0 - 0.045149911816578*G0_2_1;
    A[1084] = 0.270899470899470*G0_0_0 + 0.135449735449735*G0_0_1 + 0.135449735449735*G0_0_2 + 0.135449735449735*G0_1_0 + 0.316049382716049*G0_1_2 + 0.135449735449735*G0_2_0 + 0.316049382716049*G0_2_1 - 0.090299823633157*G0_2_2;
    A[1085] = 0.042328042328042*G0_0_0 + 0.042328042328042*G0_0_1 + 0.042328042328042*G0_0_2 + 0.042328042328042*G0_1_0 + 0.042328042328042*G0_1_1 + 0.042328042328042*G0_1_2 + 0.049382716049383*G0_2_0 + 0.049382716049383*G0_2_1 + 0.049382716049383*G0_2_2;
    A[1086] = -0.025396825396825*G0_0_0 - 0.007054673721340*G0_2_0;
    A[1087] = -0.025396825396825*G0_1_1 - 0.007054673721340*G0_2_1;
    A[1088] = 0.018342151675485*G0_2_2;
    A[1089] = 0.045149911816579*G0_1_1 + 0.033862433862434*G0_1_2 + 0.033862433862434*G0_2_1 + 0.022574955908289*G0_2_2;
    A[1090] = 0.022574955908289*G0_1_1 + 0.019753086419753*G0_1_2 + 0.019753086419753*G0_2_1 + 0.016931216931217*G0_2_2;
    A[1091] = -0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1 - 0.022574955908289*G0_2_2;
    A[1092] = 0.045149911816578*G0_0_0 + 0.033862433862434*G0_0_2 + 0.033862433862434*G0_2_0 + 0.022574955908289*G0_2_2;
    A[1093] = 0.022574955908289*G0_0_0 + 0.019753086419753*G0_0_2 + 0.019753086419753*G0_2_0 + 0.016931216931217*G0_2_2;
    A[1094] = -0.011287477954145*G0_0_2 - 0.011287477954145*G0_2_0 - 0.022574955908289*G0_2_2;
    A[1095] = 0.090299823633156*G0_0_0 + 0.033862433862434*G0_0_1 + 0.033862433862434*G0_1_0 + 0.067724867724867*G0_2_0 + 0.022574955908289*G0_2_1;
    A[1096] = 0.067724867724868*G0_0_0 + 0.064902998236331*G0_0_1 + 0.064902998236332*G0_1_0 + 0.067724867724867*G0_1_1 + 0.084656084656085*G0_2_0 + 0.084656084656084*G0_2_1;
    A[1097] = 0.033862433862434*G0_0_1 + 0.033862433862434*G0_1_0 + 0.090299823633157*G0_1_1 + 0.022574955908289*G0_2_0 + 0.067724867724868*G0_2_1;
    A[1098] = -0.135449735449735*G0_0_0 - 0.135449735449735*G0_0_1 - 0.033862433862434*G0_0_2 - 0.135449735449736*G0_1_0 - 0.135449735449735*G0_1_1 - 0.033862433862434*G0_1_2 - 0.033862433862434*G0_2_0 - 0.033862433862434*G0_2_1 - 0.045149911816579*G0_2_2;
    A[1099] = 0.022574955908289*G0_0_0 + 0.022574955908289*G0_0_1 - 0.019753086419753*G0_0_2 + 0.022574955908289*G0_1_0 + 0.022574955908289*G0_1_1 - 0.019753086419753*G0_1_2 - 0.019753086419753*G0_2_0 - 0.019753086419753*G0_2_1 + 0.022574955908289*G0_2_2;
    A[1100] = 0.011287477954144*G0_0_2 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_1 - 0.045149911816578*G0_2_2;
    A[1101] = -0.270899470899471*G0_0_0 - 0.169312169312169*G0_0_1 - 0.270899470899471*G0_0_2 - 0.169312169312169*G0_1_0 - 0.067724867724868*G0_1_1 - 0.169312169312169*G0_1_2 - 0.067724867724868*G0_2_0 - 0.079012345679013*G0_2_1 - 0.067724867724868*G0_2_2;
    A[1102] = 0.067724867724868*G0_0_0 + 0.160846560846561*G0_0_1 + 0.067724867724868*G0_0_2 + 0.160846560846561*G0_1_0 - 0.016931216931217*G0_1_1 + 0.160846560846561*G0_1_2 + 0.118518518518519*G0_2_0 + 0.025396825396826*G0_2_1 + 0.118518518518519*G0_2_2;
    A[1103] = -0.033862433862434*G0_0_1 - 0.033862433862434*G0_1_0 + 0.067724867724867*G0_1_1 - 0.033862433862434*G0_1_2 - 0.022574955908289*G0_2_0 + 0.011287477954144*G0_2_1 - 0.022574955908289*G0_2_2;
    A[1104] = -0.067724867724868*G0_0_0 - 0.169312169312169*G0_0_1 - 0.169312169312169*G0_0_2 - 0.169312169312169*G0_1_0 - 0.270899470899471*G0_1_1 - 0.270899470899471*G0_1_2 - 0.079012345679012*G0_2_0 - 0.067724867724867*G0_2_1 - 0.067724867724867*G0_2_2;
    A[1105] = -0.016931216931217*G0_0_0 + 0.160846560846560*G0_0_1 + 0.160846560846561*G0_0_2 + 0.160846560846561*G0_1_0 + 0.067724867724868*G0_1_1 + 0.067724867724868*G0_1_2 + 0.025396825396825*G0_2_0 + 0.118518518518518*G0_2_1 + 0.118518518518518*G0_2_2;
    A[1106] = 0.067724867724868*G0_0_0 - 0.033862433862434*G0_0_1 - 0.033862433862434*G0_0_2 - 0.033862433862434*G0_1_0 + 0.011287477954145*G0_2_0 - 0.022574955908289*G0_2_1 - 0.022574955908289*G0_2_2;
    A[1107] = 0.045149911816578*G0_0_0 + 0.045149911816578*G0_0_1 + 0.090299823633156*G0_0_2 + 0.045149911816578*G0_1_0 + 0.067724867724867*G0_1_2 + 0.090299823633156*G0_2_0 + 0.067724867724867*G0_2_1 + 0.135449735449735*G0_2_2;
    A[1108] = 0.045149911816578*G0_0_1 + 0.067724867724868*G0_0_2 + 0.045149911816579*G0_1_0 + 0.045149911816578*G0_1_1 + 0.090299823633157*G0_1_2 + 0.067724867724868*G0_2_0 + 0.090299823633157*G0_2_1 + 0.135449735449735*G0_2_2;
    A[1109] = 0.022574955908289*G0_0_1 + 0.045149911816578*G0_0_2 + 0.022574955908289*G0_1_0 + 0.045149911816578*G0_1_2 + 0.045149911816579*G0_2_0 + 0.045149911816578*G0_2_1 + 0.090299823633157*G0_2_2;
    A[1110] = 0.045149911816578*G0_0_0 + 0.180599647266314*G0_0_1 + 0.316049382716049*G0_0_2 + 0.180599647266314*G0_1_0 + 0.316049382716049*G0_1_1 + 0.180599647266314*G0_1_2 + 0.316049382716049*G0_2_0 + 0.180599647266314*G0_2_1 + 0.045149911816579*G0_2_2;
    A[1111] = -0.045149911816579*G0_0_1 - 0.067724867724868*G0_0_2 - 0.045149911816579*G0_1_0 - 0.225749559082893*G0_1_1 - 0.180599647266314*G0_1_2 - 0.067724867724868*G0_2_0 - 0.180599647266314*G0_2_1 - 0.135449735449736*G0_2_2;
    A[1112] = -0.022574955908289*G0_0_1 - 0.045149911816578*G0_0_2 - 0.022574955908289*G0_1_0 - 0.045149911816578*G0_1_1 - 0.045149911816578*G0_2_0 + 0.045149911816578*G0_2_2;
    A[1113] = 0.316049382716049*G0_0_0 + 0.180599647266314*G0_0_1 + 0.180599647266314*G0_0_2 + 0.180599647266314*G0_1_0 + 0.045149911816579*G0_1_1 + 0.316049382716049*G0_1_2 + 0.180599647266314*G0_2_0 + 0.316049382716049*G0_2_1 + 0.045149911816579*G0_2_2;
    A[1114] = -0.225749559082892*G0_0_0 - 0.045149911816578*G0_0_1 - 0.180599647266314*G0_0_2 - 0.045149911816579*G0_1_0 - 0.067724867724868*G0_1_2 - 0.180599647266314*G0_2_0 - 0.067724867724867*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1115] = -0.045149911816578*G0_0_0 - 0.022574955908289*G0_0_1 - 0.022574955908289*G0_1_0 - 0.045149911816579*G0_1_2 - 0.045149911816578*G0_2_1 + 0.045149911816578*G0_2_2;
    A[1116] = 0.632098765432098*G0_0_0 + 0.361199294532628*G0_0_1 + 0.361199294532627*G0_0_2 + 0.361199294532628*G0_1_0 + 0.632098765432098*G0_1_1 + 0.361199294532627*G0_1_2 + 0.361199294532627*G0_2_0 + 0.361199294532627*G0_2_1 + 0.632098765432098*G0_2_2;
    A[1117] = -0.451499118165783*G0_0_0 - 0.225749559082892*G0_0_1 - 0.090299823633156*G0_0_2 - 0.225749559082892*G0_1_0 - 0.135449735449735*G0_1_1 - 0.067724867724867*G0_1_2 - 0.361199294532627*G0_2_0 - 0.203174603174602*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1118] = -0.135449735449736*G0_0_0 - 0.225749559082892*G0_0_1 - 0.067724867724868*G0_0_2 - 0.225749559082893*G0_1_0 - 0.451499118165785*G0_1_1 - 0.090299823633157*G0_1_2 - 0.203174603174603*G0_2_0 - 0.361199294532628*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1119] = -0.090299823633157*G0_0_0 - 0.225749559082892*G0_0_1 - 0.406349206349206*G0_0_2 - 0.225749559082892*G0_1_0 - 0.090299823633157*G0_1_1 - 0.406349206349206*G0_1_2 - 0.406349206349206*G0_2_0 - 0.406349206349206*G0_2_1 - 0.722398589065255*G0_2_2;
    A[1120] = -0.025396825396825*G0_0_0 - 0.025396825396825*G0_0_1 - 0.025396825396825*G0_0_2 - 0.025396825396825*G0_1_0 - 0.025396825396825*G0_1_1 - 0.025396825396825*G0_1_2 - 0.018342151675485*G0_2_0 - 0.018342151675485*G0_2_1 - 0.018342151675485*G0_2_2;
    A[1121] = 0.042328042328042*G0_0_0 - 0.007054673721340*G0_2_0;
    A[1122] = -0.025396825396825*G0_1_1 - 0.007054673721340*G0_2_1;
    A[1123] = 0.018342151675485*G0_2_2;
    A[1124] = 0.045149911816578*G0_1_1 + 0.033862433862434*G0_1_2 + 0.033862433862434*G0_2_1 + 0.022574955908289*G0_2_2;
    A[1125] = 0.022574955908289*G0_1_1 + 0.019753086419753*G0_1_2 + 0.019753086419753*G0_2_1 + 0.016931216931217*G0_2_2;
    A[1126] = -0.011287477954145*G0_1_2 - 0.011287477954145*G0_2_1 - 0.022574955908289*G0_2_2;
    A[1127] = -0.135449735449735*G0_0_0 - 0.101587301587301*G0_0_2 - 0.101587301587301*G0_2_0 - 0.112874779541446*G0_2_2;
    A[1128] = 0.022574955908289*G0_0_0 + 0.042328042328042*G0_0_2 + 0.042328042328042*G0_2_0 + 0.084656084656084*G0_2_2;
    A[1129] = -0.011287477954144*G0_0_2 - 0.011287477954145*G0_2_0 - 0.067724867724868*G0_2_2;
    A[1130] = -0.270899470899470*G0_0_0 - 0.101587301587301*G0_0_1 - 0.101587301587301*G0_1_0 - 0.203174603174603*G0_2_0 - 0.112874779541446*G0_2_1;
    A[1131] = 0.067724867724868*G0_0_0 - 0.093121693121693*G0_0_1 - 0.093121693121693*G0_1_0 - 0.270899470899470*G0_1_1 - 0.050793650793650*G0_2_0 - 0.186243386243385*G0_2_1;
    A[1132] = 0.033862433862434*G0_0_1 + 0.033862433862434*G0_1_0 + 0.135449735449735*G0_1_1 + 0.022574955908289*G0_2_0 + 0.067724867724868*G0_2_1;
    A[1133] = 0.045149911816578*G0_0_0 + 0.045149911816578*G0_0_1 + 0.011287477954145*G0_0_2 + 0.045149911816578*G0_1_0 + 0.045149911816578*G0_1_1 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_1;
    A[1134] = 0.022574955908289*G0_0_0 + 0.022574955908289*G0_0_1 + 0.002821869488536*G0_0_2 + 0.022574955908289*G0_1_0 + 0.022574955908289*G0_1_1 + 0.002821869488536*G0_1_2 + 0.002821869488536*G0_2_0 + 0.002821869488536*G0_2_1;
    A[1135] = 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_1;
    A[1136] = 0.090299823633157*G0_0_0 + 0.056437389770723*G0_0_1 + 0.090299823633157*G0_0_2 + 0.056437389770723*G0_1_0 + 0.022574955908289*G0_1_1 + 0.056437389770723*G0_1_2 + 0.022574955908289*G0_2_0 + 0.011287477954144*G0_2_1 + 0.022574955908289*G0_2_2;
    A[1137] = 0.067724867724868*G0_0_0 + 0.002821869488536*G0_0_1 + 0.067724867724868*G0_0_2 + 0.002821869488536*G0_1_0 + 0.005643738977072*G0_1_1 + 0.002821869488536*G0_1_2 - 0.016931216931217*G0_2_0 + 0.002821869488536*G0_2_1 - 0.016931216931217*G0_2_2;
    A[1138] = -0.033862433862434*G0_0_1 - 0.033862433862434*G0_1_0 + 0.022574955908289*G0_1_1 - 0.033862433862434*G0_1_2 - 0.022574955908289*G0_2_0 + 0.011287477954145*G0_2_1 - 0.022574955908289*G0_2_2;
    A[1139] = 0.067724867724867*G0_0_0 + 0.101587301587301*G0_0_1 + 0.101587301587301*G0_0_2 + 0.101587301587301*G0_1_0 + 0.135449735449735*G0_1_1 + 0.135449735449735*G0_1_2 + 0.056437389770723*G0_2_0 + 0.067724867724867*G0_2_1 + 0.067724867724867*G0_2_2;
    A[1140] = -0.016931216931217*G0_0_0 - 0.177777777777777*G0_0_1 - 0.177777777777777*G0_0_2 - 0.177777777777777*G0_1_0 - 0.270899470899470*G0_1_1 - 0.270899470899470*G0_1_2 - 0.042328042328042*G0_2_0 - 0.084656084656084*G0_2_1 - 0.084656084656084*G0_2_2;
    A[1141] = -0.067724867724868*G0_0_0 + 0.101587301587301*G0_0_1 + 0.101587301587301*G0_0_2 + 0.101587301587301*G0_1_0 + 0.011287477954144*G0_2_0 + 0.112874779541446*G0_2_1 + 0.112874779541446*G0_2_2;
    A[1142] = 0.045149911816579*G0_0_0 - 0.135449735449735*G0_0_1 - 0.270899470899470*G0_0_2 - 0.135449735449735*G0_1_0 - 0.270899470899470*G0_1_2 - 0.270899470899470*G0_2_0 - 0.270899470899470*G0_2_1 - 0.541798941798940*G0_2_2;
    A[1143] = 0.045149911816578*G0_0_1 + 0.067724867724868*G0_0_2 + 0.045149911816579*G0_1_0 - 0.135449735449735*G0_1_1 - 0.067724867724867*G0_1_2 + 0.067724867724868*G0_2_0 - 0.067724867724867*G0_2_1;
    A[1144] = 0.022574955908289*G0_0_1 + 0.045149911816578*G0_0_2 + 0.022574955908289*G0_1_0 + 0.067724867724867*G0_1_2 + 0.045149911816578*G0_2_0 + 0.067724867724867*G0_2_1 + 0.135449735449735*G0_2_2;
    A[1145] = 0.045149911816579*G0_0_0 - 0.045149911816578*G0_0_2 - 0.045149911816578*G0_1_1 - 0.022574955908289*G0_1_2 - 0.045149911816578*G0_2_0 - 0.022574955908289*G0_2_1;
    A[1146] = -0.045149911816578*G0_0_1 - 0.067724867724867*G0_0_2 - 0.045149911816579*G0_1_0 - 0.045149911816579*G0_1_1 - 0.022574955908289*G0_1_2 - 0.067724867724867*G0_2_0 - 0.022574955908289*G0_2_1;
    A[1147] = -0.022574955908289*G0_0_1 - 0.045149911816579*G0_0_2 - 0.022574955908289*G0_1_0 - 0.045149911816579*G0_1_1 - 0.022574955908289*G0_1_2 - 0.045149911816578*G0_2_0 - 0.022574955908289*G0_2_1;
    A[1148] = -0.225749559082892*G0_0_0 - 0.180599647266313*G0_0_1 - 0.045149911816578*G0_0_2 - 0.180599647266314*G0_1_0 - 0.135449735449735*G0_1_1 - 0.067724867724868*G0_1_2 - 0.045149911816578*G0_2_0 - 0.067724867724867*G0_2_1;
    A[1149] = 0.316049382716049*G0_0_0 + 0.135449735449735*G0_0_1 + 0.135449735449735*G0_0_2 + 0.135449735449735*G0_1_0 + 0.270899470899470*G0_1_2 + 0.135449735449735*G0_2_0 + 0.270899470899470*G0_2_1;
    A[1150] = -0.045149911816578*G0_0_0 - 0.022574955908289*G0_0_1 - 0.045149911816578*G0_0_2 - 0.022574955908289*G0_1_0 - 0.067724867724867*G0_1_2 - 0.045149911816578*G0_2_0 - 0.067724867724867*G0_2_1;
    A[1151] = -0.451499118165783*G0_0_0 - 0.225749559082892*G0_0_1 - 0.361199294532627*G0_0_2 - 0.225749559082892*G0_1_0 - 0.135449735449735*G0_1_1 - 0.203174603174602*G0_1_2 - 0.090299823633156*G0_2_0 - 0.067724867724867*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1152] = 0.632098765432097*G0_0_0 + 0.270899470899470*G0_0_1 + 0.270899470899470*G0_0_2 + 0.270899470899470*G0_1_0 + 0.541798941798940*G0_1_1 + 0.270899470899470*G0_1_2 + 0.270899470899470*G0_2_0 + 0.270899470899470*G0_2_1 + 0.541798941798940*G0_2_2;
    A[1153] = -0.135449735449735*G0_0_0 + 0.090299823633157*G0_0_1 - 0.067724867724868*G0_0_2 + 0.090299823633157*G0_1_0 - 0.135449735449735*G0_1_1 + 0.067724867724867*G0_1_2 + 0.067724867724867*G0_2_0 - 0.067724867724868*G0_2_1;
    A[1154] = -0.090299823633157*G0_0_0 + 0.135449735449735*G0_0_1 + 0.316049382716049*G0_0_2 + 0.135449735449735*G0_1_0 + 0.270899470899470*G0_1_1 + 0.135449735449735*G0_1_2 + 0.316049382716049*G0_2_0 + 0.135449735449735*G0_2_1;
    A[1155] = -0.025396825396825*G0_0_0 - 0.025396825396825*G0_0_1 - 0.025396825396825*G0_0_2 - 0.025396825396825*G0_1_0 - 0.025396825396825*G0_1_1 - 0.025396825396825*G0_1_2 - 0.018342151675485*G0_2_0 - 0.018342151675485*G0_2_1 - 0.018342151675485*G0_2_2;
    A[1156] = -0.025396825396825*G0_0_0 - 0.007054673721340*G0_2_0;
    A[1157] = 0.042328042328042*G0_1_1 - 0.007054673721340*G0_2_1;
    A[1158] = 0.018342151675485*G0_2_2;
    A[1159] = -0.135449735449735*G0_1_1 - 0.101587301587302*G0_1_2 - 0.101587301587301*G0_2_1 - 0.112874779541446*G0_2_2;
    A[1160] = 0.022574955908289*G0_1_1 + 0.042328042328042*G0_1_2 + 0.042328042328042*G0_2_1 + 0.084656084656085*G0_2_2;
    A[1161] = -0.011287477954145*G0_1_2 - 0.011287477954144*G0_2_1 - 0.067724867724868*G0_2_2;
    A[1162] = 0.045149911816579*G0_0_0 + 0.033862433862434*G0_0_2 + 0.033862433862434*G0_2_0 + 0.022574955908289*G0_2_2;
    A[1163] = 0.022574955908289*G0_0_0 + 0.019753086419753*G0_0_2 + 0.019753086419753*G0_2_0 + 0.016931216931217*G0_2_2;
    A[1164] = -0.011287477954145*G0_0_2 - 0.011287477954144*G0_2_0 - 0.022574955908289*G0_2_2;
    A[1165] = 0.135449735449735*G0_0_0 + 0.033862433862434*G0_0_1 + 0.033862433862434*G0_1_0 + 0.067724867724868*G0_2_0 + 0.022574955908289*G0_2_1;
    A[1166] = -0.270899470899470*G0_0_0 - 0.093121693121693*G0_0_1 - 0.093121693121693*G0_1_0 + 0.067724867724868*G0_1_1 - 0.186243386243386*G0_2_0 - 0.050793650793651*G0_2_1;
    A[1167] = -0.101587301587301*G0_0_1 - 0.101587301587301*G0_1_0 - 0.270899470899471*G0_1_1 - 0.112874779541446*G0_2_0 - 0.203174603174603*G0_2_1;
    A[1168] = 0.045149911816579*G0_0_0 + 0.045149911816579*G0_0_1 + 0.011287477954145*G0_0_2 + 0.045149911816579*G0_1_0 + 0.045149911816579*G0_1_1 + 0.011287477954145*G0_1_2 + 0.011287477954145*G0_2_0 + 0.011287477954145*G0_2_1;
    A[1169] = 0.022574955908289*G0_0_0 + 0.022574955908289*G0_0_1 + 0.002821869488536*G0_0_2 + 0.022574955908289*G0_1_0 + 0.022574955908289*G0_1_1 + 0.002821869488536*G0_1_2 + 0.002821869488536*G0_2_0 + 0.002821869488536*G0_2_1;
    A[1170] = 0.011287477954145*G0_0_2 + 0.011287477954145*G0_1_2 + 0.011287477954144*G0_2_0 + 0.011287477954144*G0_2_1;
    A[1171] = 0.135449735449735*G0_0_0 + 0.101587301587302*G0_0_1 + 0.135449735449735*G0_0_2 + 0.101587301587302*G0_1_0 + 0.067724867724868*G0_1_1 + 0.101587301587302*G0_1_2 + 0.067724867724868*G0_2_0 + 0.056437389770723*G0_2_1 + 0.067724867724868*G0_2_2;
    A[1172] = -0.270899470899470*G0_0_0 - 0.177777777777778*G0_0_1 - 0.270899470899470*G0_0_2 - 0.177777777777778*G0_1_0 - 0.016931216931217*G0_1_1 - 0.177777777777778*G0_1_2 - 0.084656084656085*G0_2_0 - 0.042328042328042*G0_2_1 - 0.084656084656084*G0_2_2;
    A[1173] = 0.101587301587302*G0_0_1 + 0.101587301587302*G0_1_0 - 0.067724867724868*G0_1_1 + 0.101587301587302*G0_1_2 + 0.112874779541446*G0_2_0 + 0.011287477954145*G0_2_1 + 0.112874779541446*G0_2_2;
    A[1174] = 0.022574955908289*G0_0_0 + 0.056437389770723*G0_0_1 + 0.056437389770723*G0_0_2 + 0.056437389770723*G0_1_0 + 0.090299823633157*G0_1_1 + 0.090299823633157*G0_1_2 + 0.011287477954145*G0_2_0 + 0.022574955908289*G0_2_1 + 0.022574955908289*G0_2_2;
    A[1175] = 0.005643738977072*G0_0_0 + 0.002821869488536*G0_0_1 + 0.002821869488536*G0_0_2 + 0.002821869488536*G0_1_0 + 0.067724867724868*G0_1_1 + 0.067724867724867*G0_1_2 + 0.002821869488536*G0_2_0 - 0.016931216931217*G0_2_1 - 0.016931216931217*G0_2_2;
    A[1176] = 0.022574955908289*G0_0_0 - 0.033862433862434*G0_0_1 - 0.033862433862434*G0_0_2 - 0.033862433862434*G0_1_0 + 0.011287477954145*G0_2_0 - 0.022574955908289*G0_2_1 - 0.022574955908289*G0_2_2;
    A[1177] = -0.135449735449735*G0_0_0 + 0.045149911816579*G0_0_1 - 0.067724867724867*G0_0_2 + 0.045149911816579*G0_1_0 + 0.067724867724868*G0_1_2 - 0.067724867724867*G0_2_0 + 0.067724867724868*G0_2_1;
    A[1178] = -0.135449735449735*G0_0_1 - 0.270899470899470*G0_0_2 - 0.135449735449736*G0_1_0 + 0.045149911816579*G0_1_1 - 0.270899470899471*G0_1_2 - 0.270899470899470*G0_2_0 - 0.270899470899470*G0_2_1 - 0.541798941798941*G0_2_2;
    A[1179] = 0.022574955908289*G0_0_1 + 0.067724867724868*G0_0_2 + 0.022574955908289*G0_1_0 + 0.045149911816579*G0_1_2 + 0.067724867724868*G0_2_0 + 0.045149911816578*G0_2_1 + 0.135449735449735*G0_2_2;
    A[1180] = -0.135449735449736*G0_0_0 - 0.180599647266314*G0_0_1 - 0.067724867724868*G0_0_2 - 0.180599647266314*G0_1_0 - 0.225749559082893*G0_1_1 - 0.045149911816579*G0_1_2 - 0.067724867724867*G0_2_0 - 0.045149911816579*G0_2_1;
    A[1181] = 0.135449735449735*G0_0_1 + 0.270899470899471*G0_0_2 + 0.135449735449735*G0_1_0 + 0.316049382716049*G0_1_1 + 0.135449735449736*G0_1_2 + 0.270899470899470*G0_2_0 + 0.135449735449735*G0_2_1;
    A[1182] = -0.022574955908289*G0_0_1 - 0.067724867724867*G0_0_2 - 0.022574955908289*G0_1_0 - 0.045149911816578*G0_1_1 - 0.045149911816579*G0_1_2 - 0.067724867724868*G0_2_0 - 0.045149911816579*G0_2_1;
    A[1183] = -0.045149911816579*G0_0_0 - 0.022574955908290*G0_0_2 + 0.045149911816578*G0_1_1 - 0.045149911816579*G0_1_2 - 0.022574955908289*G0_2_0 - 0.045149911816578*G0_2_1;
    A[1184] = -0.045149911816578*G0_0_0 - 0.045149911816579*G0_0_1 - 0.022574955908289*G0_0_2 - 0.045149911816578*G0_1_0 - 0.067724867724867*G0_1_2 - 0.022574955908289*G0_2_0 - 0.067724867724868*G0_2_1;
    A[1185] = -0.045149911816578*G0_0_0 - 0.022574955908289*G0_0_1 - 0.022574955908289*G0_0_2 - 0.022574955908289*G0_1_0 - 0.045149911816578*G0_1_2 - 0.022574955908289*G0_2_0 - 0.045149911816578*G0_2_1;
    A[1186] = -0.135449735449736*G0_0_0 - 0.225749559082893*G0_0_1 - 0.203174603174603*G0_0_2 - 0.225749559082892*G0_1_0 - 0.451499118165785*G0_1_1 - 0.361199294532628*G0_1_2 - 0.067724867724868*G0_2_0 - 0.090299823633157*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1187] = -0.135449735449735*G0_0_0 + 0.090299823633157*G0_0_1 + 0.067724867724867*G0_0_2 + 0.090299823633157*G0_1_0 - 0.135449735449735*G0_1_1 - 0.067724867724868*G0_1_2 - 0.067724867724868*G0_2_0 + 0.067724867724867*G0_2_1;
    A[1188] = 0.541798941798941*G0_0_0 + 0.270899470899471*G0_0_1 + 0.270899470899470*G0_0_2 + 0.270899470899471*G0_1_0 + 0.632098765432098*G0_1_1 + 0.270899470899471*G0_1_2 + 0.270899470899470*G0_2_0 + 0.270899470899471*G0_2_1 + 0.541798941798941*G0_2_2;
    A[1189] = 0.270899470899470*G0_0_0 + 0.135449735449735*G0_0_1 + 0.135449735449736*G0_0_2 + 0.135449735449735*G0_1_0 - 0.090299823633157*G0_1_1 + 0.316049382716049*G0_1_2 + 0.135449735449735*G0_2_0 + 0.316049382716048*G0_2_1;
    A[1190] = -0.067724867724868*G0_0_0 - 0.067724867724868*G0_0_1 - 0.067724867724868*G0_0_2 - 0.067724867724868*G0_1_0 - 0.067724867724868*G0_1_1 - 0.067724867724868*G0_1_2 - 0.067724867724868*G0_2_0 - 0.067724867724868*G0_2_1 - 0.067724867724868*G0_2_2;
    A[1191] = -0.067724867724868*G0_0_0;
    A[1192] = -0.067724867724868*G0_1_1;
    A[1193] = -0.067724867724867*G0_2_2;
    A[1194] = 0.090299823633157*G0_1_1;
    A[1195] = -0.135449735449735*G0_1_1 - 0.112874779541446*G0_1_2 - 0.112874779541446*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1196] = 0.090299823633157*G0_2_2;
    A[1197] = 0.090299823633157*G0_0_0;
    A[1198] = -0.135449735449735*G0_0_0 - 0.112874779541445*G0_0_2 - 0.112874779541446*G0_2_0 - 0.135449735449735*G0_2_2;
    A[1199] = 0.090299823633157*G0_2_2;
    A[1200] = 0.090299823633157*G0_0_0;
    A[1201] = -0.135449735449735*G0_0_0 - 0.112874779541446*G0_0_1 - 0.112874779541446*G0_1_0 - 0.135449735449735*G0_1_1;
    A[1202] = 0.090299823633157*G0_1_1;
    A[1203] = 0.090299823633157*G0_0_0 + 0.090299823633157*G0_0_1 + 0.090299823633157*G0_0_2 + 0.090299823633157*G0_1_0 + 0.090299823633157*G0_1_1 + 0.090299823633157*G0_1_2 + 0.090299823633157*G0_2_0 + 0.090299823633157*G0_2_1 + 0.090299823633157*G0_2_2;
    A[1204] = -0.135449735449735*G0_0_0 - 0.135449735449735*G0_0_1 - 0.022574955908290*G0_0_2 - 0.135449735449735*G0_1_0 - 0.135449735449735*G0_1_1 - 0.022574955908289*G0_1_2 - 0.022574955908289*G0_2_0 - 0.022574955908289*G0_2_1 - 0.045149911816579*G0_2_2;
    A[1205] = 0.090299823633157*G0_2_2;
    A[1206] = 0.090299823633157*G0_0_0 + 0.090299823633157*G0_0_1 + 0.090299823633157*G0_0_2 + 0.090299823633157*G0_1_0 + 0.090299823633157*G0_1_1 + 0.090299823633157*G0_1_2 + 0.090299823633157*G0_2_0 + 0.090299823633157*G0_2_1 + 0.090299823633157*G0_2_2;
    A[1207] = -0.135449735449735*G0_0_0 - 0.022574955908290*G0_0_1 - 0.135449735449735*G0_0_2 - 0.022574955908289*G0_1_0 - 0.045149911816579*G0_1_1 - 0.022574955908289*G0_1_2 - 0.135449735449735*G0_2_0 - 0.022574955908290*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1208] = 0.090299823633157*G0_1_1;
    A[1209] = 0.090299823633157*G0_0_0 + 0.090299823633157*G0_0_1 + 0.090299823633157*G0_0_2 + 0.090299823633157*G0_1_0 + 0.090299823633157*G0_1_1 + 0.090299823633157*G0_1_2 + 0.090299823633157*G0_2_0 + 0.090299823633157*G0_2_1 + 0.090299823633157*G0_2_2;
    A[1210] = -0.045149911816579*G0_0_0 - 0.022574955908289*G0_0_1 - 0.022574955908289*G0_0_2 - 0.022574955908289*G0_1_0 - 0.135449735449735*G0_1_1 - 0.135449735449735*G0_1_2 - 0.022574955908289*G0_2_0 - 0.135449735449735*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1211] = 0.090299823633157*G0_0_0;
    A[1212] = -0.722398589065254*G0_0_0 - 0.316049382716048*G0_0_1 - 0.316049382716049*G0_0_2 - 0.316049382716049*G0_1_0 - 0.135449735449735*G0_1_2 - 0.316049382716049*G0_2_0 - 0.135449735449735*G0_2_1;
    A[1213] = -0.316049382716049*G0_0_1 - 0.135449735449735*G0_0_2 - 0.316049382716048*G0_1_0 - 0.722398589065254*G0_1_1 - 0.316049382716048*G0_1_2 - 0.135449735449735*G0_2_0 - 0.316049382716049*G0_2_1;
    A[1214] = -0.135449735449735*G0_0_1 - 0.316049382716049*G0_0_2 - 0.135449735449735*G0_1_0 - 0.316049382716049*G0_1_2 - 0.316049382716048*G0_2_0 - 0.316049382716049*G0_2_1 - 0.722398589065254*G0_2_2;
    A[1215] = -0.722398589065255*G0_0_0 - 0.406349206349206*G0_0_1 - 0.406349206349206*G0_0_2 - 0.406349206349206*G0_1_0 - 0.090299823633157*G0_1_1 - 0.225749559082892*G0_1_2 - 0.406349206349206*G0_2_0 - 0.225749559082892*G0_2_1 - 0.090299823633157*G0_2_2;
    A[1216] = 0.316049382716049*G0_0_1 + 0.135449735449736*G0_0_2 + 0.316049382716048*G0_1_0 - 0.090299823633157*G0_1_1 + 0.135449735449735*G0_1_2 + 0.135449735449735*G0_2_0 + 0.135449735449736*G0_2_1 + 0.270899470899471*G0_2_2;
    A[1217] = 0.135449735449735*G0_0_1 + 0.316049382716049*G0_0_2 + 0.135449735449735*G0_1_0 + 0.270899470899470*G0_1_1 + 0.135449735449735*G0_1_2 + 0.316049382716048*G0_2_0 + 0.135449735449735*G0_2_1 - 0.090299823633157*G0_2_2;
    A[1218] = -0.090299823633156*G0_0_0 - 0.406349206349205*G0_0_1 - 0.225749559082891*G0_0_2 - 0.406349206349206*G0_1_0 - 0.722398589065254*G0_1_1 - 0.406349206349205*G0_1_2 - 0.225749559082892*G0_2_0 - 0.406349206349206*G0_2_1 - 0.090299823633157*G0_2_2;
    A[1219] = -0.090299823633158*G0_0_0 + 0.316049382716048*G0_0_1 + 0.135449735449734*G0_0_2 + 0.316049382716049*G0_1_0 + 0.135449735449735*G0_1_2 + 0.135449735449735*G0_2_0 + 0.135449735449735*G0_2_1 + 0.270899470899470*G0_2_2;
    A[1220] = 0.270899470899470*G0_0_0 + 0.135449735449735*G0_0_1 + 0.135449735449735*G0_0_2 + 0.135449735449735*G0_1_0 + 0.316049382716049*G0_1_2 + 0.135449735449735*G0_2_0 + 0.316049382716049*G0_2_1 - 0.090299823633157*G0_2_2;
    A[1221] = -0.090299823633157*G0_0_0 - 0.225749559082892*G0_0_1 - 0.406349206349206*G0_0_2 - 0.225749559082892*G0_1_0 - 0.090299823633157*G0_1_1 - 0.406349206349206*G0_1_2 - 0.406349206349206*G0_2_0 - 0.406349206349206*G0_2_1 - 0.722398589065255*G0_2_2;
    A[1222] = -0.090299823633157*G0_0_0 + 0.135449735449735*G0_0_1 + 0.316049382716049*G0_0_2 + 0.135449735449735*G0_1_0 + 0.270899470899470*G0_1_1 + 0.135449735449735*G0_1_2 + 0.316049382716049*G0_2_0 + 0.135449735449735*G0_2_1;
    A[1223] = 0.270899470899470*G0_0_0 + 0.135449735449735*G0_0_1 + 0.135449735449735*G0_0_2 + 0.135449735449735*G0_1_0 - 0.090299823633157*G0_1_1 + 0.316049382716048*G0_1_2 + 0.135449735449736*G0_2_0 + 0.316049382716049*G0_2_1;
    A[1224] = 1.444797178130510*G0_0_0 + 0.722398589065255*G0_0_1 + 0.722398589065255*G0_0_2 + 0.722398589065255*G0_1_0 + 1.444797178130509*G0_1_1 + 0.722398589065255*G0_1_2 + 0.722398589065255*G0_2_0 + 0.722398589065255*G0_2_1 + 1.444797178130509*G0_2_2;
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class poisson3d_4_cell_integral_1_0: public ufc::cell_integral
{
public:

  /// Constructor
  poisson3d_4_cell_integral_1_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_4_cell_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      18
    // Number of operations (multiply-add pairs) for geometry tensor:    35
    // Number of operations (multiply-add pairs) for tensor contraction: 1207
    // Total number of operations (multiply-add pairs):                  1260
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_20 = J_01*J_12 - J_02*J_11;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    const double G0_3 = det*w[0][3]*(1.0);
    const double G0_4 = det*w[0][4]*(1.0);
    const double G0_5 = det*w[0][5]*(1.0);
    const double G0_6 = det*w[0][6]*(1.0);
    const double G0_7 = det*w[0][7]*(1.0);
    const double G0_8 = det*w[0][8]*(1.0);
    const double G0_9 = det*w[0][9]*(1.0);
    const double G0_10 = det*w[0][10]*(1.0);
    const double G0_11 = det*w[0][11]*(1.0);
    const double G0_12 = det*w[0][12]*(1.0);
    const double G0_13 = det*w[0][13]*(1.0);
    const double G0_14 = det*w[0][14]*(1.0);
    const double G0_15 = det*w[0][15]*(1.0);
    const double G0_16 = det*w[0][16]*(1.0);
    const double G0_17 = det*w[0][17]*(1.0);
    const double G0_18 = det*w[0][18]*(1.0);
    const double G0_19 = det*w[0][19]*(1.0);
    const double G0_20 = det*w[0][20]*(1.0);
    const double G0_21 = det*w[0][21]*(1.0);
    const double G0_22 = det*w[0][22]*(1.0);
    const double G0_23 = det*w[0][23]*(1.0);
    const double G0_24 = det*w[0][24]*(1.0);
    const double G0_25 = det*w[0][25]*(1.0);
    const double G0_26 = det*w[0][26]*(1.0);
    const double G0_27 = det*w[0][27]*(1.0);
    const double G0_28 = det*w[0][28]*(1.0);
    const double G0_29 = det*w[0][29]*(1.0);
    const double G0_30 = det*w[0][30]*(1.0);
    const double G0_31 = det*w[0][31]*(1.0);
    const double G0_32 = det*w[0][32]*(1.0);
    const double G0_33 = det*w[0][33]*(1.0);
    const double G0_34 = det*w[0][34]*(1.0);
    
    // Compute element tensor
    A[0] = 0.000200416867084*G0_0 + 0.000016300571856*G0_1 + 0.000016300571856*G0_2 + 0.000016300571856*G0_3 - 0.000121853455187*G0_4 + 0.000083907861686*G0_5 - 0.000121853455187*G0_6 - 0.000121853455187*G0_7 + 0.000083907861686*G0_8 - 0.000121853455187*G0_9 - 0.000121853455187*G0_10 + 0.000083907861686*G0_11 - 0.000121853455187*G0_12 - 0.000149644594089*G0_13 + 0.000112233445567*G0_14 - 0.000068408957298*G0_15 - 0.000149644594089*G0_16 + 0.000112233445567*G0_17 - 0.000068408957298*G0_18 - 0.000149644594089*G0_19 + 0.000112233445567*G0_20 - 0.000068408957298*G0_21 - 0.000215915771471*G0_22 - 0.000215915771471*G0_23 - 0.000215915771471*G0_24 + 0.000288600288600*G0_25 - 0.000185986852654*G0_26 - 0.000185986852654*G0_27 + 0.000288600288600*G0_28 - 0.000185986852654*G0_29 - 0.000185986852654*G0_30 + 0.000288600288600*G0_31 - 0.000185986852654*G0_32 - 0.000185986852654*G0_33 - 0.000538720538721*G0_34;
    A[1] = 0.000016300571856*G0_0 + 0.000200416867084*G0_1 + 0.000016300571856*G0_2 + 0.000016300571856*G0_3 - 0.000121853455187*G0_4 + 0.000083907861686*G0_5 - 0.000121853455187*G0_6 - 0.000149644594089*G0_7 + 0.000112233445567*G0_8 - 0.000068408957298*G0_9 - 0.000149644594089*G0_10 + 0.000112233445567*G0_11 - 0.000068408957298*G0_12 - 0.000121853455187*G0_13 + 0.000083907861686*G0_14 - 0.000121853455187*G0_15 - 0.000121853455187*G0_16 + 0.000083907861686*G0_17 - 0.000121853455187*G0_18 - 0.000068408957298*G0_19 + 0.000112233445567*G0_20 - 0.000149644594089*G0_21 + 0.000288600288600*G0_22 - 0.000185986852654*G0_23 - 0.000185986852654*G0_24 - 0.000215915771471*G0_25 - 0.000215915771471*G0_26 - 0.000215915771471*G0_27 - 0.000185986852654*G0_28 + 0.000288600288600*G0_29 - 0.000185986852654*G0_30 - 0.000185986852654*G0_31 + 0.000288600288600*G0_32 - 0.000185986852654*G0_33 - 0.000538720538721*G0_34;
    A[2] = 0.000016300571856*G0_0 + 0.000016300571856*G0_1 + 0.000200416867084*G0_2 + 0.000016300571856*G0_3 - 0.000149644594089*G0_4 + 0.000112233445567*G0_5 - 0.000068408957298*G0_6 - 0.000121853455187*G0_7 + 0.000083907861686*G0_8 - 0.000121853455187*G0_9 - 0.000068408957298*G0_10 + 0.000112233445567*G0_11 - 0.000149644594089*G0_12 - 0.000121853455187*G0_13 + 0.000083907861686*G0_14 - 0.000121853455187*G0_15 - 0.000068408957298*G0_16 + 0.000112233445567*G0_17 - 0.000149644594089*G0_18 - 0.000121853455187*G0_19 + 0.000083907861686*G0_20 - 0.000121853455187*G0_21 - 0.000185986852654*G0_22 + 0.000288600288600*G0_23 - 0.000185986852654*G0_24 - 0.000185986852654*G0_25 + 0.000288600288600*G0_26 - 0.000185986852654*G0_27 - 0.000215915771471*G0_28 - 0.000215915771471*G0_29 - 0.000215915771471*G0_30 - 0.000185986852654*G0_31 - 0.000185986852654*G0_32 + 0.000288600288600*G0_33 - 0.000538720538721*G0_34;
    A[3] = 0.000016300571856*G0_0 + 0.000016300571856*G0_1 + 0.000016300571856*G0_2 + 0.000200416867084*G0_3 - 0.000068408957298*G0_4 + 0.000112233445567*G0_5 - 0.000149644594089*G0_6 - 0.000068408957298*G0_7 + 0.000112233445567*G0_8 - 0.000149644594089*G0_9 - 0.000121853455187*G0_10 + 0.000083907861686*G0_11 - 0.000121853455187*G0_12 - 0.000068408957298*G0_13 + 0.000112233445567*G0_14 - 0.000149644594089*G0_15 - 0.000121853455187*G0_16 + 0.000083907861686*G0_17 - 0.000121853455187*G0_18 - 0.000121853455187*G0_19 + 0.000083907861686*G0_20 - 0.000121853455187*G0_21 - 0.000185986852654*G0_22 - 0.000185986852654*G0_23 + 0.000288600288600*G0_24 - 0.000185986852654*G0_25 - 0.000185986852654*G0_26 + 0.000288600288600*G0_27 - 0.000185986852654*G0_28 - 0.000185986852654*G0_29 + 0.000288600288600*G0_30 - 0.000215915771471*G0_31 - 0.000215915771471*G0_32 - 0.000215915771471*G0_33 - 0.000538720538721*G0_34;
    A[4] = -0.000121853455187*G0_0 - 0.000121853455187*G0_1 - 0.000149644594089*G0_2 - 0.000068408957298*G0_3 + 0.001710223932446*G0_4 - 0.001257014590348*G0_5 + 0.000684089572978*G0_6 + 0.000273635829191*G0_7 - 0.000153920153920*G0_8 + 0.000359147025814*G0_9 + 0.000359147025814*G0_10 - 0.000654160654161*G0_11 + 0.000855111966223*G0_12 + 0.000273635829191*G0_13 - 0.000153920153920*G0_14 + 0.000359147025814*G0_15 + 0.000359147025814*G0_16 - 0.000654160654161*G0_17 + 0.000855111966223*G0_18 + 0.000136817914596*G0_19 - 0.000098337876116*G0_20 + 0.000136817914596*G0_21 - 0.000034204478649*G0_22 + 0.000102613435947*G0_23 + 0.000513067179734*G0_24 - 0.000034204478649*G0_25 + 0.000102613435947*G0_26 + 0.000513067179734*G0_27 + 0.000085511196622*G0_28 + 0.000085511196622*G0_29 + 0.000974827641494*G0_30 - 0.000017102239324*G0_31 - 0.000017102239324*G0_32 + 0.000051306717973*G0_33 + 0.001094543316766*G0_34;
    A[5] = 0.000083907861686*G0_0 + 0.000083907861686*G0_1 + 0.000112233445567*G0_2 + 0.000112233445567*G0_3 - 0.001257014590348*G0_4 + 0.002385762385762*G0_5 - 0.001257014590348*G0_6 - 0.000153920153920*G0_7 + 0.000256533589867*G0_8 - 0.000654160654161*G0_9 - 0.000153920153920*G0_10 + 0.000256533589867*G0_11 - 0.000654160654161*G0_12 - 0.000153920153920*G0_13 + 0.000256533589867*G0_14 - 0.000654160654161*G0_15 - 0.000153920153920*G0_16 + 0.000256533589867*G0_17 - 0.000654160654161*G0_18 - 0.000098337876116*G0_19 + 0.000019240019240*G0_20 - 0.000098337876116*G0_21 - 0.000179573512907*G0_22 - 0.000076960076960*G0_23 - 0.000076960076960*G0_24 - 0.000179573512907*G0_25 - 0.000076960076960*G0_26 - 0.000076960076960*G0_27 + 0.000269360269360*G0_28 + 0.000269360269360*G0_29 - 0.001013307679974*G0_30 + 0.000269360269360*G0_31 + 0.000269360269360*G0_32 - 0.001013307679974*G0_33 - 0.001026134359468*G0_34;
    A[6] = -0.000121853455187*G0_0 - 0.000121853455187*G0_1 - 0.000068408957298*G0_2 - 0.000149644594089*G0_3 + 0.000684089572978*G0_4 - 0.001257014590348*G0_5 + 0.001710223932446*G0_6 + 0.000359147025814*G0_7 - 0.000654160654161*G0_8 + 0.000855111966223*G0_9 + 0.000273635829191*G0_10 - 0.000153920153920*G0_11 + 0.000359147025814*G0_12 + 0.000359147025814*G0_13 - 0.000654160654161*G0_14 + 0.000855111966223*G0_15 + 0.000273635829191*G0_16 - 0.000153920153920*G0_17 + 0.000359147025814*G0_18 + 0.000136817914596*G0_19 - 0.000098337876116*G0_20 + 0.000136817914596*G0_21 - 0.000034204478649*G0_22 + 0.000513067179734*G0_23 + 0.000102613435947*G0_24 - 0.000034204478649*G0_25 + 0.000513067179734*G0_26 + 0.000102613435947*G0_27 - 0.000017102239324*G0_28 - 0.000017102239324*G0_29 + 0.000051306717973*G0_30 + 0.000085511196622*G0_31 + 0.000085511196622*G0_32 + 0.000974827641494*G0_33 + 0.001094543316766*G0_34;
    A[7] = -0.000121853455187*G0_0 - 0.000149644594089*G0_1 - 0.000121853455187*G0_2 - 0.000068408957298*G0_3 + 0.000273635829191*G0_4 - 0.000153920153920*G0_5 + 0.000359147025814*G0_6 + 0.001710223932446*G0_7 - 0.001257014590348*G0_8 + 0.000684089572978*G0_9 + 0.000855111966223*G0_10 - 0.000654160654161*G0_11 + 0.000359147025814*G0_12 + 0.000273635829191*G0_13 - 0.000153920153920*G0_14 + 0.000359147025814*G0_15 + 0.000136817914596*G0_16 - 0.000098337876116*G0_17 + 0.000136817914596*G0_18 + 0.000359147025814*G0_19 - 0.000654160654161*G0_20 + 0.000855111966223*G0_21 + 0.000102613435947*G0_22 - 0.000034204478649*G0_23 + 0.000513067179734*G0_24 + 0.000085511196622*G0_25 + 0.000085511196622*G0_26 + 0.000974827641494*G0_27 - 0.000034204478649*G0_28 + 0.000102613435947*G0_29 + 0.000513067179734*G0_30 - 0.000017102239324*G0_31 + 0.000051306717973*G0_32 - 0.000017102239324*G0_33 + 0.001094543316766*G0_34;
    A[8] = 0.000083907861686*G0_0 + 0.000112233445567*G0_1 + 0.000083907861686*G0_2 + 0.000112233445567*G0_3 - 0.000153920153920*G0_4 + 0.000256533589867*G0_5 - 0.000654160654161*G0_6 - 0.001257014590348*G0_7 + 0.002385762385762*G0_8 - 0.001257014590348*G0_9 - 0.000654160654161*G0_10 + 0.000256533589867*G0_11 - 0.000153920153920*G0_12 - 0.000153920153920*G0_13 + 0.000256533589867*G0_14 - 0.000654160654161*G0_15 - 0.000098337876116*G0_16 + 0.000019240019240*G0_17 - 0.000098337876116*G0_18 - 0.000153920153920*G0_19 + 0.000256533589867*G0_20 - 0.000654160654161*G0_21 - 0.000076960076960*G0_22 - 0.000179573512907*G0_23 - 0.000076960076960*G0_24 + 0.000269360269360*G0_25 + 0.000269360269360*G0_26 - 0.001013307679974*G0_27 - 0.000179573512907*G0_28 - 0.000076960076960*G0_29 - 0.000076960076960*G0_30 + 0.000269360269360*G0_31 - 0.001013307679974*G0_32 + 0.000269360269360*G0_33 - 0.001026134359468*G0_34;
    A[9] = -0.000121853455187*G0_0 - 0.000068408957298*G0_1 - 0.000121853455187*G0_2 - 0.000149644594089*G0_3 + 0.000359147025814*G0_4 - 0.000654160654161*G0_5 + 0.000855111966223*G0_6 + 0.000684089572978*G0_7 - 0.001257014590348*G0_8 + 0.001710223932446*G0_9 + 0.000359147025814*G0_10 - 0.000153920153920*G0_11 + 0.000273635829191*G0_12 + 0.000359147025814*G0_13 - 0.000654160654161*G0_14 + 0.000855111966223*G0_15 + 0.000136817914596*G0_16 - 0.000098337876116*G0_17 + 0.000136817914596*G0_18 + 0.000273635829191*G0_19 - 0.000153920153920*G0_20 + 0.000359147025814*G0_21 + 0.000513067179734*G0_22 - 0.000034204478649*G0_23 + 0.000102613435947*G0_24 - 0.000017102239324*G0_25 - 0.000017102239324*G0_26 + 0.000051306717973*G0_27 - 0.000034204478649*G0_28 + 0.000513067179734*G0_29 + 0.000102613435947*G0_30 + 0.000085511196622*G0_31 + 0.000974827641494*G0_32 + 0.000085511196622*G0_33 + 0.001094543316766*G0_34;
    A[10] = -0.000121853455187*G0_0 - 0.000149644594089*G0_1 - 0.000068408957298*G0_2 - 0.000121853455187*G0_3 + 0.000359147025814*G0_4 - 0.000153920153920*G0_5 + 0.000273635829191*G0_6 + 0.000855111966223*G0_7 - 0.000654160654161*G0_8 + 0.000359147025814*G0_9 + 0.001710223932446*G0_10 - 0.001257014590348*G0_11 + 0.000684089572978*G0_12 + 0.000136817914596*G0_13 - 0.000098337876116*G0_14 + 0.000136817914596*G0_15 + 0.000273635829191*G0_16 - 0.000153920153920*G0_17 + 0.000359147025814*G0_18 + 0.000359147025814*G0_19 - 0.000654160654161*G0_20 + 0.000855111966223*G0_21 + 0.000102613435947*G0_22 + 0.000513067179734*G0_23 - 0.000034204478649*G0_24 + 0.000085511196622*G0_25 + 0.000974827641494*G0_26 + 0.000085511196622*G0_27 - 0.000017102239324*G0_28 + 0.000051306717973*G0_29 - 0.000017102239324*G0_30 - 0.000034204478649*G0_31 + 0.000102613435947*G0_32 + 0.000513067179734*G0_33 + 0.001094543316766*G0_34;
    A[11] = 0.000083907861686*G0_0 + 0.000112233445567*G0_1 + 0.000112233445567*G0_2 + 0.000083907861686*G0_3 - 0.000654160654161*G0_4 + 0.000256533589867*G0_5 - 0.000153920153920*G0_6 - 0.000654160654161*G0_7 + 0.000256533589867*G0_8 - 0.000153920153920*G0_9 - 0.001257014590348*G0_10 + 0.002385762385762*G0_11 - 0.001257014590348*G0_12 - 0.000098337876116*G0_13 + 0.000019240019240*G0_14 - 0.000098337876116*G0_15 - 0.000153920153920*G0_16 + 0.000256533589867*G0_17 - 0.000654160654161*G0_18 - 0.000153920153920*G0_19 + 0.000256533589867*G0_20 - 0.000654160654161*G0_21 - 0.000076960076960*G0_22 - 0.000076960076960*G0_23 - 0.000179573512907*G0_24 + 0.000269360269360*G0_25 - 0.001013307679974*G0_26 + 0.000269360269360*G0_27 + 0.000269360269360*G0_28 - 0.001013307679974*G0_29 + 0.000269360269360*G0_30 - 0.000179573512907*G0_31 - 0.000076960076960*G0_32 - 0.000076960076960*G0_33 - 0.001026134359468*G0_34;
    A[12] = -0.000121853455187*G0_0 - 0.000068408957298*G0_1 - 0.000149644594089*G0_2 - 0.000121853455187*G0_3 + 0.000855111966223*G0_4 - 0.000654160654161*G0_5 + 0.000359147025814*G0_6 + 0.000359147025814*G0_7 - 0.000153920153920*G0_8 + 0.000273635829191*G0_9 + 0.000684089572978*G0_10 - 0.001257014590348*G0_11 + 0.001710223932446*G0_12 + 0.000136817914596*G0_13 - 0.000098337876116*G0_14 + 0.000136817914596*G0_15 + 0.000359147025814*G0_16 - 0.000654160654161*G0_17 + 0.000855111966223*G0_18 + 0.000273635829191*G0_19 - 0.000153920153920*G0_20 + 0.000359147025814*G0_21 + 0.000513067179734*G0_22 + 0.000102613435947*G0_23 - 0.000034204478649*G0_24 - 0.000017102239324*G0_25 + 0.000051306717973*G0_26 - 0.000017102239324*G0_27 + 0.000085511196622*G0_28 + 0.000974827641494*G0_29 + 0.000085511196622*G0_30 - 0.000034204478649*G0_31 + 0.000513067179734*G0_32 + 0.000102613435947*G0_33 + 0.001094543316766*G0_34;
    A[13] = -0.000149644594089*G0_0 - 0.000121853455187*G0_1 - 0.000121853455187*G0_2 - 0.000068408957298*G0_3 + 0.000273635829191*G0_4 - 0.000153920153920*G0_5 + 0.000359147025814*G0_6 + 0.000273635829191*G0_7 - 0.000153920153920*G0_8 + 0.000359147025814*G0_9 + 0.000136817914596*G0_10 - 0.000098337876116*G0_11 + 0.000136817914596*G0_12 + 0.001710223932446*G0_13 - 0.001257014590348*G0_14 + 0.000684089572978*G0_15 + 0.000855111966223*G0_16 - 0.000654160654161*G0_17 + 0.000359147025814*G0_18 + 0.000855111966223*G0_19 - 0.000654160654161*G0_20 + 0.000359147025814*G0_21 + 0.000085511196622*G0_22 + 0.000085511196622*G0_23 + 0.000974827641494*G0_24 + 0.000102613435947*G0_25 - 0.000034204478649*G0_26 + 0.000513067179734*G0_27 + 0.000102613435947*G0_28 - 0.000034204478649*G0_29 + 0.000513067179734*G0_30 + 0.000051306717973*G0_31 - 0.000017102239324*G0_32 - 0.000017102239324*G0_33 + 0.001094543316766*G0_34;
    A[14] = 0.000112233445567*G0_0 + 0.000083907861686*G0_1 + 0.000083907861686*G0_2 + 0.000112233445567*G0_3 - 0.000153920153920*G0_4 + 0.000256533589867*G0_5 - 0.000654160654161*G0_6 - 0.000153920153920*G0_7 + 0.000256533589867*G0_8 - 0.000654160654161*G0_9 - 0.000098337876116*G0_10 + 0.000019240019240*G0_11 - 0.000098337876116*G0_12 - 0.001257014590348*G0_13 + 0.002385762385762*G0_14 - 0.001257014590348*G0_15 - 0.000654160654161*G0_16 + 0.000256533589867*G0_17 - 0.000153920153920*G0_18 - 0.000654160654161*G0_19 + 0.000256533589867*G0_20 - 0.000153920153920*G0_21 + 0.000269360269360*G0_22 + 0.000269360269360*G0_23 - 0.001013307679974*G0_24 - 0.000076960076960*G0_25 - 0.000179573512907*G0_26 - 0.000076960076960*G0_27 - 0.000076960076960*G0_28 - 0.000179573512907*G0_29 - 0.000076960076960*G0_30 - 0.001013307679974*G0_31 + 0.000269360269360*G0_32 + 0.000269360269360*G0_33 - 0.001026134359468*G0_34;
    A[15] = -0.000068408957298*G0_0 - 0.000121853455187*G0_1 - 0.000121853455187*G0_2 - 0.000149644594089*G0_3 + 0.000359147025814*G0_4 - 0.000654160654161*G0_5 + 0.000855111966223*G0_6 + 0.000359147025814*G0_7 - 0.000654160654161*G0_8 + 0.000855111966223*G0_9 + 0.000136817914596*G0_10 - 0.000098337876116*G0_11 + 0.000136817914596*G0_12 + 0.000684089572978*G0_13 - 0.001257014590348*G0_14 + 0.001710223932446*G0_15 + 0.000359147025814*G0_16 - 0.000153920153920*G0_17 + 0.000273635829191*G0_18 + 0.000359147025814*G0_19 - 0.000153920153920*G0_20 + 0.000273635829191*G0_21 - 0.000017102239324*G0_22 - 0.000017102239324*G0_23 + 0.000051306717973*G0_24 + 0.000513067179734*G0_25 - 0.000034204478649*G0_26 + 0.000102613435947*G0_27 + 0.000513067179734*G0_28 - 0.000034204478649*G0_29 + 0.000102613435947*G0_30 + 0.000974827641494*G0_31 + 0.000085511196622*G0_32 + 0.000085511196622*G0_33 + 0.001094543316766*G0_34;
    A[16] = -0.000149644594089*G0_0 - 0.000121853455187*G0_1 - 0.000068408957298*G0_2 - 0.000121853455187*G0_3 + 0.000359147025814*G0_4 - 0.000153920153920*G0_5 + 0.000273635829191*G0_6 + 0.000136817914596*G0_7 - 0.000098337876116*G0_8 + 0.000136817914596*G0_9 + 0.000273635829191*G0_10 - 0.000153920153920*G0_11 + 0.000359147025814*G0_12 + 0.000855111966223*G0_13 - 0.000654160654161*G0_14 + 0.000359147025814*G0_15 + 0.001710223932446*G0_16 - 0.001257014590348*G0_17 + 0.000684089572978*G0_18 + 0.000855111966223*G0_19 - 0.000654160654161*G0_20 + 0.000359147025814*G0_21 + 0.000085511196622*G0_22 + 0.000974827641494*G0_23 + 0.000085511196622*G0_24 + 0.000102613435947*G0_25 + 0.000513067179734*G0_26 - 0.000034204478649*G0_27 + 0.000051306717973*G0_28 - 0.000017102239324*G0_29 - 0.000017102239324*G0_30 + 0.000102613435947*G0_31 - 0.000034204478649*G0_32 + 0.000513067179734*G0_33 + 0.001094543316766*G0_34;
    A[17] = 0.000112233445567*G0_0 + 0.000083907861686*G0_1 + 0.000112233445567*G0_2 + 0.000083907861686*G0_3 - 0.000654160654161*G0_4 + 0.000256533589867*G0_5 - 0.000153920153920*G0_6 - 0.000098337876116*G0_7 + 0.000019240019240*G0_8 - 0.000098337876116*G0_9 - 0.000153920153920*G0_10 + 0.000256533589867*G0_11 - 0.000654160654161*G0_12 - 0.000654160654161*G0_13 + 0.000256533589867*G0_14 - 0.000153920153920*G0_15 - 0.001257014590348*G0_16 + 0.002385762385762*G0_17 - 0.001257014590348*G0_18 - 0.000654160654161*G0_19 + 0.000256533589867*G0_20 - 0.000153920153920*G0_21 + 0.000269360269360*G0_22 - 0.001013307679974*G0_23 + 0.000269360269360*G0_24 - 0.000076960076960*G0_25 - 0.000076960076960*G0_26 - 0.000179573512907*G0_27 - 0.001013307679974*G0_28 + 0.000269360269360*G0_29 + 0.000269360269360*G0_30 - 0.000076960076960*G0_31 - 0.000179573512907*G0_32 - 0.000076960076960*G0_33 - 0.001026134359468*G0_34;
    A[18] = -0.000068408957298*G0_0 - 0.000121853455187*G0_1 - 0.000149644594089*G0_2 - 0.000121853455187*G0_3 + 0.000855111966223*G0_4 - 0.000654160654161*G0_5 + 0.000359147025814*G0_6 + 0.000136817914596*G0_7 - 0.000098337876116*G0_8 + 0.000136817914596*G0_9 + 0.000359147025814*G0_10 - 0.000654160654161*G0_11 + 0.000855111966223*G0_12 + 0.000359147025814*G0_13 - 0.000153920153920*G0_14 + 0.000273635829191*G0_15 + 0.000684089572978*G0_16 - 0.001257014590348*G0_17 + 0.001710223932446*G0_18 + 0.000359147025814*G0_19 - 0.000153920153920*G0_20 + 0.000273635829191*G0_21 - 0.000017102239324*G0_22 + 0.000051306717973*G0_23 - 0.000017102239324*G0_24 + 0.000513067179734*G0_25 + 0.000102613435947*G0_26 - 0.000034204478649*G0_27 + 0.000974827641494*G0_28 + 0.000085511196622*G0_29 + 0.000085511196622*G0_30 + 0.000513067179734*G0_31 - 0.000034204478649*G0_32 + 0.000102613435947*G0_33 + 0.001094543316766*G0_34;
    A[19] = -0.000149644594089*G0_0 - 0.000068408957298*G0_1 - 0.000121853455187*G0_2 - 0.000121853455187*G0_3 + 0.000136817914596*G0_4 - 0.000098337876116*G0_5 + 0.000136817914596*G0_6 + 0.000359147025814*G0_7 - 0.000153920153920*G0_8 + 0.000273635829191*G0_9 + 0.000359147025814*G0_10 - 0.000153920153920*G0_11 + 0.000273635829191*G0_12 + 0.000855111966223*G0_13 - 0.000654160654161*G0_14 + 0.000359147025814*G0_15 + 0.000855111966223*G0_16 - 0.000654160654161*G0_17 + 0.000359147025814*G0_18 + 0.001710223932446*G0_19 - 0.001257014590348*G0_20 + 0.000684089572978*G0_21 + 0.000974827641494*G0_22 + 0.000085511196622*G0_23 + 0.000085511196622*G0_24 + 0.000051306717973*G0_25 - 0.000017102239324*G0_26 - 0.000017102239324*G0_27 + 0.000102613435947*G0_28 + 0.000513067179734*G0_29 - 0.000034204478649*G0_30 + 0.000102613435947*G0_31 + 0.000513067179734*G0_32 - 0.000034204478649*G0_33 + 0.001094543316766*G0_34;
    A[20] = 0.000112233445567*G0_0 + 0.000112233445567*G0_1 + 0.000083907861686*G0_2 + 0.000083907861686*G0_3 - 0.000098337876116*G0_4 + 0.000019240019240*G0_5 - 0.000098337876116*G0_6 - 0.000654160654161*G0_7 + 0.000256533589867*G0_8 - 0.000153920153920*G0_9 - 0.000654160654161*G0_10 + 0.000256533589867*G0_11 - 0.000153920153920*G0_12 - 0.000654160654161*G0_13 + 0.000256533589867*G0_14 - 0.000153920153920*G0_15 - 0.000654160654161*G0_16 + 0.000256533589867*G0_17 - 0.000153920153920*G0_18 - 0.001257014590348*G0_19 + 0.002385762385762*G0_20 - 0.001257014590348*G0_21 - 0.001013307679974*G0_22 + 0.000269360269360*G0_23 + 0.000269360269360*G0_24 - 0.001013307679974*G0_25 + 0.000269360269360*G0_26 + 0.000269360269360*G0_27 - 0.000076960076960*G0_28 - 0.000076960076960*G0_29 - 0.000179573512907*G0_30 - 0.000076960076960*G0_31 - 0.000076960076960*G0_32 - 0.000179573512907*G0_33 - 0.001026134359468*G0_34;
    A[21] = -0.000068408957298*G0_0 - 0.000149644594089*G0_1 - 0.000121853455187*G0_2 - 0.000121853455187*G0_3 + 0.000136817914596*G0_4 - 0.000098337876116*G0_5 + 0.000136817914596*G0_6 + 0.000855111966223*G0_7 - 0.000654160654161*G0_8 + 0.000359147025814*G0_9 + 0.000855111966223*G0_10 - 0.000654160654161*G0_11 + 0.000359147025814*G0_12 + 0.000359147025814*G0_13 - 0.000153920153920*G0_14 + 0.000273635829191*G0_15 + 0.000359147025814*G0_16 - 0.000153920153920*G0_17 + 0.000273635829191*G0_18 + 0.000684089572978*G0_19 - 0.001257014590348*G0_20 + 0.001710223932446*G0_21 + 0.000051306717973*G0_22 - 0.000017102239324*G0_23 - 0.000017102239324*G0_24 + 0.000974827641494*G0_25 + 0.000085511196622*G0_26 + 0.000085511196622*G0_27 + 0.000513067179734*G0_28 + 0.000102613435947*G0_29 - 0.000034204478649*G0_30 + 0.000513067179734*G0_31 + 0.000102613435947*G0_32 - 0.000034204478649*G0_33 + 0.001094543316766*G0_34;
    A[22] = -0.000215915771471*G0_0 + 0.000288600288600*G0_1 - 0.000185986852654*G0_2 - 0.000185986852654*G0_3 - 0.000034204478649*G0_4 - 0.000179573512907*G0_5 - 0.000034204478649*G0_6 + 0.000102613435947*G0_7 - 0.000076960076960*G0_8 + 0.000513067179734*G0_9 + 0.000102613435947*G0_10 - 0.000076960076960*G0_11 + 0.000513067179734*G0_12 + 0.000085511196622*G0_13 + 0.000269360269360*G0_14 - 0.000017102239324*G0_15 + 0.000085511196622*G0_16 + 0.000269360269360*G0_17 - 0.000017102239324*G0_18 + 0.000974827641494*G0_19 - 0.001013307679974*G0_20 + 0.000051306717973*G0_21 + 0.007798621131954*G0_22 - 0.002052268718935*G0_23 - 0.002052268718935*G0_24 - 0.000205226871894*G0_25 - 0.001436588103255*G0_26 - 0.001436588103255*G0_27 - 0.001436588103255*G0_28 + 0.003899310565977*G0_29 - 0.001026134359468*G0_30 - 0.001436588103255*G0_31 + 0.003899310565977*G0_32 - 0.001026134359468*G0_33 + 0.001641814975148*G0_34;
    A[23] = -0.000215915771471*G0_0 - 0.000185986852654*G0_1 + 0.000288600288600*G0_2 - 0.000185986852654*G0_3 + 0.000102613435947*G0_4 - 0.000076960076960*G0_5 + 0.000513067179734*G0_6 - 0.000034204478649*G0_7 - 0.000179573512907*G0_8 - 0.000034204478649*G0_9 + 0.000513067179734*G0_10 - 0.000076960076960*G0_11 + 0.000102613435947*G0_12 + 0.000085511196622*G0_13 + 0.000269360269360*G0_14 - 0.000017102239324*G0_15 + 0.000974827641494*G0_16 - 0.001013307679974*G0_17 + 0.000051306717973*G0_18 + 0.000085511196622*G0_19 + 0.000269360269360*G0_20 - 0.000017102239324*G0_21 - 0.002052268718935*G0_22 + 0.007798621131954*G0_23 - 0.002052268718935*G0_24 - 0.001436588103255*G0_25 + 0.003899310565977*G0_26 - 0.001026134359468*G0_27 - 0.000205226871894*G0_28 - 0.001436588103255*G0_29 - 0.001436588103255*G0_30 - 0.001436588103255*G0_31 - 0.001026134359468*G0_32 + 0.003899310565977*G0_33 + 0.001641814975148*G0_34;
    A[24] = -0.000215915771471*G0_0 - 0.000185986852654*G0_1 - 0.000185986852654*G0_2 + 0.000288600288600*G0_3 + 0.000513067179734*G0_4 - 0.000076960076960*G0_5 + 0.000102613435947*G0_6 + 0.000513067179734*G0_7 - 0.000076960076960*G0_8 + 0.000102613435947*G0_9 - 0.000034204478649*G0_10 - 0.000179573512907*G0_11 - 0.000034204478649*G0_12 + 0.000974827641494*G0_13 - 0.001013307679974*G0_14 + 0.000051306717973*G0_15 + 0.000085511196622*G0_16 + 0.000269360269360*G0_17 - 0.000017102239324*G0_18 + 0.000085511196622*G0_19 + 0.000269360269360*G0_20 - 0.000017102239324*G0_21 - 0.002052268718935*G0_22 - 0.002052268718935*G0_23 + 0.007798621131954*G0_24 - 0.001436588103255*G0_25 - 0.001026134359468*G0_26 + 0.003899310565977*G0_27 - 0.001436588103255*G0_28 - 0.001026134359468*G0_29 + 0.003899310565977*G0_30 - 0.000205226871894*G0_31 - 0.001436588103255*G0_32 - 0.001436588103255*G0_33 + 0.001641814975148*G0_34;
    A[25] = 0.000288600288600*G0_0 - 0.000215915771471*G0_1 - 0.000185986852654*G0_2 - 0.000185986852654*G0_3 - 0.000034204478649*G0_4 - 0.000179573512907*G0_5 - 0.000034204478649*G0_6 + 0.000085511196622*G0_7 + 0.000269360269360*G0_8 - 0.000017102239324*G0_9 + 0.000085511196622*G0_10 + 0.000269360269360*G0_11 - 0.000017102239324*G0_12 + 0.000102613435947*G0_13 - 0.000076960076960*G0_14 + 0.000513067179734*G0_15 + 0.000102613435947*G0_16 - 0.000076960076960*G0_17 + 0.000513067179734*G0_18 + 0.000051306717973*G0_19 - 0.001013307679974*G0_20 + 0.000974827641494*G0_21 - 0.000205226871894*G0_22 - 0.001436588103255*G0_23 - 0.001436588103255*G0_24 + 0.007798621131954*G0_25 - 0.002052268718935*G0_26 - 0.002052268718935*G0_27 + 0.003899310565977*G0_28 - 0.001436588103255*G0_29 - 0.001026134359468*G0_30 + 0.003899310565977*G0_31 - 0.001436588103255*G0_32 - 0.001026134359468*G0_33 + 0.001641814975148*G0_34;
    A[26] = -0.000185986852654*G0_0 - 0.000215915771471*G0_1 + 0.000288600288600*G0_2 - 0.000185986852654*G0_3 + 0.000102613435947*G0_4 - 0.000076960076960*G0_5 + 0.000513067179734*G0_6 + 0.000085511196622*G0_7 + 0.000269360269360*G0_8 - 0.000017102239324*G0_9 + 0.000974827641494*G0_10 - 0.001013307679974*G0_11 + 0.000051306717973*G0_12 - 0.000034204478649*G0_13 - 0.000179573512907*G0_14 - 0.000034204478649*G0_15 + 0.000513067179734*G0_16 - 0.000076960076960*G0_17 + 0.000102613435947*G0_18 - 0.000017102239324*G0_19 + 0.000269360269360*G0_20 + 0.000085511196622*G0_21 - 0.001436588103255*G0_22 + 0.003899310565977*G0_23 - 0.001026134359468*G0_24 - 0.002052268718935*G0_25 + 0.007798621131954*G0_26 - 0.002052268718935*G0_27 - 0.001436588103255*G0_28 - 0.000205226871894*G0_29 - 0.001436588103255*G0_30 - 0.001026134359468*G0_31 - 0.001436588103255*G0_32 + 0.003899310565977*G0_33 + 0.001641814975148*G0_34;
    A[27] = -0.000185986852654*G0_0 - 0.000215915771471*G0_1 - 0.000185986852654*G0_2 + 0.000288600288600*G0_3 + 0.000513067179734*G0_4 - 0.000076960076960*G0_5 + 0.000102613435947*G0_6 + 0.000974827641494*G0_7 - 0.001013307679974*G0_8 + 0.000051306717973*G0_9 + 0.000085511196622*G0_10 + 0.000269360269360*G0_11 - 0.000017102239324*G0_12 + 0.000513067179734*G0_13 - 0.000076960076960*G0_14 + 0.000102613435947*G0_15 - 0.000034204478649*G0_16 - 0.000179573512907*G0_17 - 0.000034204478649*G0_18 - 0.000017102239324*G0_19 + 0.000269360269360*G0_20 + 0.000085511196622*G0_21 - 0.001436588103255*G0_22 - 0.001026134359468*G0_23 + 0.003899310565977*G0_24 - 0.002052268718935*G0_25 - 0.002052268718935*G0_26 + 0.007798621131954*G0_27 - 0.001026134359468*G0_28 - 0.001436588103255*G0_29 + 0.003899310565977*G0_30 - 0.001436588103255*G0_31 - 0.000205226871894*G0_32 - 0.001436588103255*G0_33 + 0.001641814975148*G0_34;
    A[28] = 0.000288600288600*G0_0 - 0.000185986852654*G0_1 - 0.000215915771471*G0_2 - 0.000185986852654*G0_3 + 0.000085511196622*G0_4 + 0.000269360269360*G0_5 - 0.000017102239324*G0_6 - 0.000034204478649*G0_7 - 0.000179573512907*G0_8 - 0.000034204478649*G0_9 - 0.000017102239324*G0_10 + 0.000269360269360*G0_11 + 0.000085511196622*G0_12 + 0.000102613435947*G0_13 - 0.000076960076960*G0_14 + 0.000513067179734*G0_15 + 0.000051306717973*G0_16 - 0.001013307679974*G0_17 + 0.000974827641494*G0_18 + 0.000102613435947*G0_19 - 0.000076960076960*G0_20 + 0.000513067179734*G0_21 - 0.001436588103255*G0_22 - 0.000205226871894*G0_23 - 0.001436588103255*G0_24 + 0.003899310565977*G0_25 - 0.001436588103255*G0_26 - 0.001026134359468*G0_27 + 0.007798621131954*G0_28 - 0.002052268718935*G0_29 - 0.002052268718935*G0_30 + 0.003899310565977*G0_31 - 0.001026134359468*G0_32 - 0.001436588103255*G0_33 + 0.001641814975148*G0_34;
    A[29] = -0.000185986852654*G0_0 + 0.000288600288600*G0_1 - 0.000215915771471*G0_2 - 0.000185986852654*G0_3 + 0.000085511196622*G0_4 + 0.000269360269360*G0_5 - 0.000017102239324*G0_6 + 0.000102613435947*G0_7 - 0.000076960076960*G0_8 + 0.000513067179734*G0_9 + 0.000051306717973*G0_10 - 0.001013307679974*G0_11 + 0.000974827641494*G0_12 - 0.000034204478649*G0_13 - 0.000179573512907*G0_14 - 0.000034204478649*G0_15 - 0.000017102239324*G0_16 + 0.000269360269360*G0_17 + 0.000085511196622*G0_18 + 0.000513067179734*G0_19 - 0.000076960076960*G0_20 + 0.000102613435947*G0_21 + 0.003899310565977*G0_22 - 0.001436588103255*G0_23 - 0.001026134359468*G0_24 - 0.001436588103255*G0_25 - 0.000205226871894*G0_26 - 0.001436588103255*G0_27 - 0.002052268718935*G0_28 + 0.007798621131954*G0_29 - 0.002052268718935*G0_30 - 0.001026134359468*G0_31 + 0.003899310565977*G0_32 - 0.001436588103255*G0_33 + 0.001641814975148*G0_34;
    A[30] = -0.000185986852654*G0_0 - 0.000185986852654*G0_1 - 0.000215915771471*G0_2 + 0.000288600288600*G0_3 + 0.000974827641494*G0_4 - 0.001013307679974*G0_5 + 0.000051306717973*G0_6 + 0.000513067179734*G0_7 - 0.000076960076960*G0_8 + 0.000102613435947*G0_9 - 0.000017102239324*G0_10 + 0.000269360269360*G0_11 + 0.000085511196622*G0_12 + 0.000513067179734*G0_13 - 0.000076960076960*G0_14 + 0.000102613435947*G0_15 - 0.000017102239324*G0_16 + 0.000269360269360*G0_17 + 0.000085511196622*G0_18 - 0.000034204478649*G0_19 - 0.000179573512907*G0_20 - 0.000034204478649*G0_21 - 0.001026134359468*G0_22 - 0.001436588103255*G0_23 + 0.003899310565977*G0_24 - 0.001026134359468*G0_25 - 0.001436588103255*G0_26 + 0.003899310565977*G0_27 - 0.002052268718935*G0_28 - 0.002052268718935*G0_29 + 0.007798621131954*G0_30 - 0.001436588103255*G0_31 - 0.001436588103255*G0_32 - 0.000205226871894*G0_33 + 0.001641814975148*G0_34;
    A[31] = 0.000288600288600*G0_0 - 0.000185986852654*G0_1 - 0.000185986852654*G0_2 - 0.000215915771471*G0_3 - 0.000017102239324*G0_4 + 0.000269360269360*G0_5 + 0.000085511196622*G0_6 - 0.000017102239324*G0_7 + 0.000269360269360*G0_8 + 0.000085511196622*G0_9 - 0.000034204478649*G0_10 - 0.000179573512907*G0_11 - 0.000034204478649*G0_12 + 0.000051306717973*G0_13 - 0.001013307679974*G0_14 + 0.000974827641494*G0_15 + 0.000102613435947*G0_16 - 0.000076960076960*G0_17 + 0.000513067179734*G0_18 + 0.000102613435947*G0_19 - 0.000076960076960*G0_20 + 0.000513067179734*G0_21 - 0.001436588103255*G0_22 - 0.001436588103255*G0_23 - 0.000205226871894*G0_24 + 0.003899310565977*G0_25 - 0.001026134359468*G0_26 - 0.001436588103255*G0_27 + 0.003899310565977*G0_28 - 0.001026134359468*G0_29 - 0.001436588103255*G0_30 + 0.007798621131954*G0_31 - 0.002052268718935*G0_32 - 0.002052268718935*G0_33 + 0.001641814975148*G0_34;
    A[32] = -0.000185986852654*G0_0 + 0.000288600288600*G0_1 - 0.000185986852654*G0_2 - 0.000215915771471*G0_3 - 0.000017102239324*G0_4 + 0.000269360269360*G0_5 + 0.000085511196622*G0_6 + 0.000051306717973*G0_7 - 0.001013307679974*G0_8 + 0.000974827641494*G0_9 + 0.000102613435947*G0_10 - 0.000076960076960*G0_11 + 0.000513067179734*G0_12 - 0.000017102239324*G0_13 + 0.000269360269360*G0_14 + 0.000085511196622*G0_15 - 0.000034204478649*G0_16 - 0.000179573512907*G0_17 - 0.000034204478649*G0_18 + 0.000513067179734*G0_19 - 0.000076960076960*G0_20 + 0.000102613435947*G0_21 + 0.003899310565977*G0_22 - 0.001026134359468*G0_23 - 0.001436588103255*G0_24 - 0.001436588103255*G0_25 - 0.001436588103255*G0_26 - 0.000205226871894*G0_27 - 0.001026134359468*G0_28 + 0.003899310565977*G0_29 - 0.001436588103255*G0_30 - 0.002052268718935*G0_31 + 0.007798621131954*G0_32 - 0.002052268718935*G0_33 + 0.001641814975148*G0_34;
    A[33] = -0.000185986852654*G0_0 - 0.000185986852654*G0_1 + 0.000288600288600*G0_2 - 0.000215915771471*G0_3 + 0.000051306717973*G0_4 - 0.001013307679974*G0_5 + 0.000974827641494*G0_6 - 0.000017102239324*G0_7 + 0.000269360269360*G0_8 + 0.000085511196622*G0_9 + 0.000513067179734*G0_10 - 0.000076960076960*G0_11 + 0.000102613435947*G0_12 - 0.000017102239324*G0_13 + 0.000269360269360*G0_14 + 0.000085511196622*G0_15 + 0.000513067179734*G0_16 - 0.000076960076960*G0_17 + 0.000102613435947*G0_18 - 0.000034204478649*G0_19 - 0.000179573512907*G0_20 - 0.000034204478649*G0_21 - 0.001026134359468*G0_22 + 0.003899310565977*G0_23 - 0.001436588103255*G0_24 - 0.001026134359468*G0_25 + 0.003899310565977*G0_26 - 0.001436588103255*G0_27 - 0.001436588103255*G0_28 - 0.001436588103255*G0_29 - 0.000205226871894*G0_30 - 0.002052268718935*G0_31 - 0.002052268718935*G0_32 + 0.007798621131954*G0_33 + 0.001641814975148*G0_34;
    A[34] = -0.000538720538721*G0_0 - 0.000538720538721*G0_1 - 0.000538720538721*G0_2 - 0.000538720538721*G0_3 + 0.001094543316766*G0_4 - 0.001026134359468*G0_5 + 0.001094543316766*G0_6 + 0.001094543316766*G0_7 - 0.001026134359468*G0_8 + 0.001094543316766*G0_9 + 0.001094543316766*G0_10 - 0.001026134359468*G0_11 + 0.001094543316766*G0_12 + 0.001094543316766*G0_13 - 0.001026134359468*G0_14 + 0.001094543316766*G0_15 + 0.001094543316766*G0_16 - 0.001026134359468*G0_17 + 0.001094543316766*G0_18 + 0.001094543316766*G0_19 - 0.001026134359468*G0_20 + 0.001094543316766*G0_21 + 0.001641814975148*G0_22 + 0.001641814975148*G0_23 + 0.001641814975148*G0_24 + 0.001641814975148*G0_25 + 0.001641814975148*G0_26 + 0.001641814975148*G0_27 + 0.001641814975148*G0_28 + 0.001641814975148*G0_29 + 0.001641814975148*G0_30 + 0.001641814975148*G0_31 + 0.001641814975148*G0_32 + 0.001641814975148*G0_33 + 0.026269039602373*G0_34;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class poisson3d_4_form_0: public ufc::form
{
public:

  /// Constructor
  poisson3d_4_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_4_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(IndexSum(Product(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 4), 0), MultiIndex((Index(0),), {Index(0): 3})), SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 4), 1), MultiIndex((Index(0),), {Index(0): 3}))), MultiIndex((Index(0),), {Index(0): 3})), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 1;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 0;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_4_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson3d_4_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_4_dof_map_0();
        break;
      }
    case 1:
      {
        return new poisson3d_4_dof_map_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_4_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class poisson3d_4_form_1: public ufc::form
{
public:

  /// Constructor
  poisson3d_4_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_4_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Argument(FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 4), 0), Coefficient(FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 4), 0)), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 1;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 1;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 0;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_4_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson3d_4_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_4_dof_map_0();
        break;
      }
    case 1:
      {
        return new poisson3d_4_dof_map_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_4_cell_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>

namespace Poisson3D_4
{

class CoefficientSpace_f: public dolfin::FunctionSpace
{
public:

  CoefficientSpace_f(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_4_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_4_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_f(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_4_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_4_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_f(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_4_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_4_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace_f(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_4_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_4_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace_f()
  {
  }

};

class Form_0_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_4_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_4_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_4_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_4_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_4_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_4_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_4_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_4_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_0()
  {
  }

};

class Form_0_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_4_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_4_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_4_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_4_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_4_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_4_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_4_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_4_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_1()
  {
  }

};

class Form_0: public dolfin::Form
{
public:

  // Constructor
  Form_0(const dolfin::FunctionSpace& V0, const dolfin::FunctionSpace& V1):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_4_form_0());
  }

  // Constructor
  Form_0(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::FunctionSpace> V1):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_4_form_0());
  }

  // Destructor
  ~Form_0()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {

    dolfin::error("No coefficients.");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {

    dolfin::error("No coefficients.");
    return "unnamed";
  }

  // Typedefs
  typedef Form_0_FunctionSpace_0 TestSpace;
  typedef Form_0_FunctionSpace_1 TrialSpace;

  // Coefficients
};

class Form_1_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_1_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_4_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_4_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_4_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_4_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_4_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_4_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_4_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_4_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_1_FunctionSpace_0()
  {
  }

};

typedef CoefficientSpace_f Form_1_FunctionSpace_1;

class Form_1: public dolfin::Form
{
public:

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_4_form_1());
  }

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_4_form_1());
  }

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0, boost::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = *f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_4_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_4_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    this->f = f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_4_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    this->f = *f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_4_form_1());
  }

  // Destructor
  ~Form_1()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;

    dolfin::error("Invalid coefficient.");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    }

    dolfin::error("Invalid coefficient.");
    return "unnamed";
  }

  // Typedefs
  typedef Form_1_FunctionSpace_0 TestSpace;
  typedef Form_1_FunctionSpace_1 CoefficientSpace_f;

  // Coefficients
  dolfin::CoefficientAssigner f;
};

// Class typedefs
typedef Form_0 BilinearForm;
typedef Form_1 LinearForm;
typedef Form_0::TestSpace FunctionSpace;

}

#endif
