/*
 *  Remote Network application system for DNAS -- plugin for text display,
 showing the current uplink.
 *  Copyright (C) 2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: rnasmonitor-uplink-text.c,v 1.2 2002/12/01 13:27:24 dancer Exp $
 */

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <pthread.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <pthread.h>
#include <locale.h>
#include "config.h"
#include "dmachinemon/dmachinemon-debug.h"
#include "dmachinemon/dmachinemon.h"
#include "dmachinemon/libsocket.h"
#include "dmachinemon/dmachinemon-libdatabase.h"
#include "dmachinemon/dmachinemon-commandlineparser.h"
#include "rnas-monitor-gtk.h"

int
rnas_monitor_initialize (rnasmonitors * r)
{
  printf("$Id: rnasmonitor-uplink-text.c,v 1.2 2002/12/01 13:27:24 dancer Exp $\n");
  INITIALIZE_RNASMONITOR(r);

  if (require_lisp_params(r->l, 2))
    {
      fprintf(stderr, "This plugin requires: \n"
	      "SO, title dummy");
      return 1;
    }
  return 0;
}

static GtkWidget* 
create_window_new(const char * hostname, GtkWidget * hbox, rnasmonitors* r, rnas_applicationdata *m)
{
  GtkWidget * w = gtk_label_new("None");
  
  gtk_box_pack_start(GTK_BOX(hbox), w, TRUE, TRUE, FALSE);
  gtk_widget_show(w);
  return w;
}

static int
displayfunction(struct rnas_applicationdata* m, dm_machinelist* dm)
{
  const char * gotvalue = dm_get_value_text(dm, "Seen-By");
  char * buf = NULL;
  
  if (gotvalue)
    {
      char * a,*b,*c;
      
      c=dm_get_firstitem(b=dm_get_itemsexceptfirst(a=dm_get_itemsexceptfirst(gotvalue)));
      
      free(a);
      free(b);
      gtk_label_set_text (GTK_LABEL(m->w), c);
    }

  free(buf);

  return 0;
}

