/*
 *  DNAS / a Distributed Network Application System - shell proxy
 *  Copyright (C) 2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You can test this application as:
 *  echo "GET /" | ./dnas-proxy-shell -p 80 -k
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include "config.h"
#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif
#include <dmachinemon/libsocket.h>
static void
printhelp ()
{
  fprintf (stderr, "This application is for internal use only\n");
}

int
main(int ac, char ** av)
{
  int c;
  int clientport = 0;
  int socket;
  int childpid ;
  int parentkill = 0 ;

  while((c = getopt (ac, av, "p:k")) != -1)
    {
      switch (c)
	{
	case 'p':
	  clientport = atoi (optarg);
	  break;
	case 'k':
	  parentkill = 1;
	  break;
	default:
	  printhelp();
	  exit(1);
	  break;
	}
    }
  socket = dm_connect_to_host("localhost", 
		     clientport);
  if (socket == -1 )
    {
      fprintf (stderr, "Proxy connect failed to localhost, %i \n", clientport);
      exit (1);
    }

  if ((childpid = fork()))
    {
      char rwbuf[BUFSIZ+1];
      int len;
      
      while((len = fread(rwbuf, 1, BUFSIZ, stdin)))
	{
	  write (socket, rwbuf, len);
	}
      if (!parentkill)
	kill (childpid, 15);
    }
  else
    {
      char rwbuf[BUFSIZ+1];
      int len;
      while ((len = read  (socket, rwbuf, BUFSIZ))>0)
	{
	  fwrite (rwbuf, 1, len, stdout);
	  fflush (stdout);
	}
      if (parentkill)
	kill (getppid(),15);
    }

  close (socket);
  
  exit (0);
}
