/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include "mainwnd-background-1.xpm"
#include "mainwnd-background-2.xpm"
#include "config.h"
#include "plugins/bitmapbutton/bitmapbutton.h" 
#include "plugins/bitmapslider/bitmapslider.h" 
#include "cfgfile.h"
#include "metatracker.h"

#define DISPLAYSIZE QSize(572, 49)
#define DISPLAYPOS1 QPoint(115, 10)
#define DISPLAYPOS2 QPoint(115, 65)
#define PREVIEW_WIDTH 94
#define PREVIEW_HEIGHT 70

#define ADJUST_POS(x, y) (x)->move((x)->pos()-=QPoint((y), 0))
void MainWnd::init()
{
    ladspa_used=false;
    s_bpm=0.0f;
    bpm_detect=0;
    background=0;
    warn=0;
    tone=0;
    warned=false;
    seeking=0;
    setting_value=false;
    current_position=0;
    seek_timer=NULL;
    pframe=0;
    bend=0;
    bend_down_on=0;
    bend_up_on=0;
    base_pitch=0;
    bend_timer=new QTimer(this);
    connect(bend_timer, SIGNAL(timeout()), this, SLOT(bend_timeout()));
    pView=new DDisplay((QWidget *)parent(), this, 0, WResizeNoErase | WRepaintNoErase);

    setWFlags(0);
    pView->move(DISPLAYPOS1);
    pView->resize(DISPLAYSIZE);
    pView->show();
    
    preview_framebuf=new unsigned char *[PREVIEW_HEIGHT];
    int i;
    for(i=0;i<PREVIEW_HEIGHT;i++)
	preview_framebuf[i]=new unsigned char[3*PREVIEW_WIDTH+4];
    
    video_preview=new QWidget(pView, 0, WResizeNoErase | WRepaintNoErase);
    video_preview->resize(PREVIEW_WIDTH, PREVIEW_HEIGHT);
    video_preview->move(DISPLAYSIZE.width()-PREVIEW_WIDTH, 0);
    video_preview->hide();
    
/*
    current_source=(StreamSource *)new Mp3StreamSource;
    connect(current_source, SIGNAL(frame_changed(unsigned)), this, SLOT(frame_changed(unsigned)));
    connect(current_source, SIGNAL(play_done()), this, SLOT(CueButton_clicked()));
    
    if(((Mp3StreamSource *)current_source)->attach("test.mp3") < 0)
    {
	printf("Attach sound file failed\n");
    }
    current_source->generate_wave();
    
    player->set_stream(current_source);
*/
    current_source=NULL;
    CueButton->setLit(true);
    JogDial=new QJogDial(this);
    QRect rc=Jog->rect();
    QPoint pt=Jog->pos();
    JogDial->setGeometry(QRect(pt.x(), pt.y(), rc.width(), rc.height()));
    delete Jog;
    JogDial->show();
    connect(JogDial, SIGNAL(jogUp()), this, SLOT(jogUp()));
    connect(JogDial, SIGNAL(jogDown()), this, SLOT(jogDown()));
    
    char buf[1024];
    getcwd(buf, sizeof(buf));
    directory=buf;
    pump=new Pump();
    pump->start();
    
}

void MainWnd::destroy()
{
    close_file();
    delete pump;
    delete player;
    delete background;
#ifdef HAVE_LADSPA
    if(tone)
	delete tone;
#endif
    int i;
    for(i=0;i<PREVIEW_HEIGHT;i++)
	delete preview_framebuf[i];
    delete preview_framebuf;
    delete video_preview;
}

void MainWnd::closeEvent( QCloseEvent *ev )
{
    if(current_source)
    {
	current_source->stop();
	delete current_source;
    }
    
    if(player)
	delete player;
    player=NULL;
    emit windowClosed();
}


void MainWnd::Draw3dRect( QPainter *p, const QRect &rcRect, bool bSunken, QColor crTop, QColor crBottom )
{
    QPen penLight(crTop);
    QPen penDark(crBottom);

    if(bSunken)
        p->setPen(penDark);
    else
        p->setPen(penLight);

    p->moveTo(rcRect.left(), rcRect.bottom()-1);
    p->lineTo(rcRect.left(), rcRect.top());
    p->lineTo(rcRect.right(), rcRect.top());

    if(bSunken)
        p->setPen(penLight);
    else
        p->setPen(penDark);

    p->moveTo(rcRect.right(), rcRect.top());
    p->lineTo(rcRect.right(), rcRect.bottom());
    p->lineTo(rcRect.left(), rcRect.bottom());

}


void MainWnd::inflateRect( QRect & rc, int x, int y )
{
    rc.setTop(rc.top()-y);
    rc.setBottom(rc.bottom()+y);
    rc.setLeft(rc.left()-x);
    rc.setRight(rc.right()+x);
}


void MainWnd::PlayButton_clicked()
{
    if(!current_source)
	return;
    
    if(seeking)
    {
	seeking=0;
	video_preview->hide();
	current_source->exit_loop();
	PlayButton->setLit(true);
	CueButton->setLit(false);
	frame->set_led(player_number-1, PLAY_LED, 1);
	frame->set_led(player_number-1, CUE_LED, 0);
	((Frame *)parent())->setVideoMode();
	return;
    }
    seeking=0;
    video_preview->hide();
    if(current_source->is_playing())
    {
	current_source->stop();
	current_position=current_source->frame_position();
	pframe=current_position;
	update_display();
	PlayButton->setLit(false);
	CueButton->setLit(true);
	frame->set_led(player_number-1, PLAY_LED, 0);
	frame->set_led(player_number-1, CUE_LED, 1);
	((Frame *)parent())->setVideoMode();
	return;
    }
    if(!current_source->play(current_position, 0))
    {
	PlayButton->setLit(true);
	CueButton->setLit(false);
	frame->set_led(player_number-1, PLAY_LED, 1);
	frame->set_led(player_number-1, CUE_LED, 0);
	((Frame *)parent())->setVideoMode();
    }
}



void MainWnd::CueButton_clicked()
{
    if(!current_source)
	return;
    if(current_source->is_playing())
    {
	current_source->stop();
    }
    PlayButton->setLit(false);
    CueButton->setLit(true);
	frame->set_led(player_number-1, PLAY_LED, 0);
	frame->set_led(player_number-1, CUE_LED, 1);
    pframe=current_position;
    current_source->set_transport_position(pframe);
    setting_value=true;
    TransportControl->setValue(pframe);
    setting_value=false;
    seeking=0;
    video_preview->hide();
    QThread::postEvent(pView, new QPaintEvent(pView->rect(), false));
	((Frame *)parent())->setVideoMode();
}


void MainWnd::Pitch_valueChanged( int val)
{
    if(current_source)
	current_source->set_pitch((double)val/10.0);
    base_pitch=(double)val/10.0;
    update_display();
}


void MainWnd::ZeroButton_clicked()
{
    Tone->setValue(0);
    Pitch->setValue(0);
    base_pitch=0.0;
    if(current_source)
	current_source->set_pitch(0.0);
}


void MainWnd::frame_changed( unsigned new_frame )
{
    if(seeking)
	return;
    pframe=new_frame;
    setting_value=true;
    QThread::postEvent(this, new QEvent(QEvent::User));
    setting_value=false;
}



unsigned MainWnd::get_frame()
{
    return pframe;
}


void MainWnd::update_display( void )
{
    if(!seeking)
	QThread::postEvent(pView, new QPaintEvent(pView->rect(), false));
    else
    {
	app->lock();
	update_preview();
	app->unlock();
    }
}


void MainWnd::SeekBack_pressed()
{
    if(!current_source)
	return;
    if(current_source->is_playing() && !seeking)
    {
	current_source->stop();
 	current_position=current_source->frame_position();
   }
    if(seeking)
    {
	current_position-=500;
	if((int)current_position < 0)
	    current_position=0;
    }
    PlayButton->setLit(true);
    CueButton->setLit(false);
	frame->set_led(player_number-1, PLAY_LED, 1);
	frame->set_led(player_number-1, CUE_LED, 0);
    pframe=current_position;
    TransportControl->setValue(pframe);
    QThread::postEvent(pView, new QPaintEvent(pView->rect(), false));
    current_source->play(pframe, 5000, true);
    seeking=1;
    if(current_source->has_video())
	video_preview->show();
    seek_timer=new QTimer;
    connect(seek_timer, SIGNAL(timeout()), this, SLOT(seek_back()));
    seek_timer->start(700);
}


void MainWnd::SeekBack_released()
{
    if(seek_timer)
    {
	seek_timer->stop();
	delete seek_timer;
	seek_timer=NULL;
    }
    TransportControl->setValue(pframe);
}


void MainWnd::SeekForward_pressed()
{
    if(!current_source)
	return;
    if(current_source->is_playing() && !seeking)
    {
	current_source->stop();
 	current_position=current_source->frame_position();
   }
    if(seeking)
    {
	current_position+=500;
	if(current_position >= current_source->max_frames)
	    current_position=current_source->max_frames;
    }
    PlayButton->setLit(true);
    CueButton->setLit(false);
	frame->set_led(player_number-1, PLAY_LED, 1);
	frame->set_led(player_number-1, CUE_LED, 0);
    pframe=current_position;
    TransportControl->setValue(pframe);
    QThread::postEvent(pView, new QPaintEvent(pView->rect(), false));
    current_source->play(pframe, 5000, true);
    seeking=1;
    if(current_source->has_video())
	video_preview->show();
    seek_timer=new QTimer;
    connect(seek_timer, SIGNAL(timeout()), this, SLOT(seek_forward()));
    seek_timer->start(700);
}


void MainWnd::SeekForward_released()
{
    if(seek_timer)
    {
	seek_timer->stop();
	delete seek_timer;
	seek_timer=NULL;
    }
    TransportControl->setValue(pframe);
}


void MainWnd::seek_back()
{
    if(!current_source)
	return;
    if(!SeekBack->isDown())
	return;
    if(!seeking)
	return;
    current_position-=500;
    if((int)current_position < 0)
	current_position=0;
    pframe=current_position;
    TransportControl->setValue(pframe);
    current_source->last_start=current_position;
    pView->repaint(false);
    seek_timer->changeInterval(200);
}


void MainWnd::jogDown( void )
{
    if(!current_source)
	return;
    if(current_source->is_playing() && !seeking)
    {
	current_source->stop();
 	current_position=current_source->frame_position();
   }
    if(seeking)
    {
	current_position-=500;
	if((int)current_position < 0)
	    current_position=0;
    }
    PlayButton->setLit(true);
    CueButton->setLit(false);
	frame->set_led(player_number-1, PLAY_LED, 1);
	frame->set_led(player_number-1, CUE_LED, 0);
    pframe=current_position;
    if(!seeking)
	current_source->play(pframe, 5000, true);
    else
	current_source->last_start=current_position;
    pView->repaint(false);
    seeking=1;
    if(current_source->has_video())
	video_preview->show();
    TransportControl->setValue(pframe);
}



void MainWnd::jogUp( void )
{
    if(!current_source)
	return;
    if(current_source->is_playing() && !seeking)
    {
	current_source->stop();
 	current_position=current_source->frame_position();
   }
    if(seeking)
    {
	current_position+=500;
	if(current_position >= current_source->max_frames)
	    current_position=current_source->max_frames;
    }
    PlayButton->setLit(true);
    CueButton->setLit(false);
	frame->set_led(player_number-1, PLAY_LED, 1);
	frame->set_led(player_number-1, CUE_LED, 0);
    pframe=current_position;
    if(!seeking)
	current_source->play(pframe, 5000, true);
    else
	current_source->last_start=current_position;
    pView->repaint(false);
    seeking=1;    
    if(current_source->has_video())
	video_preview->show();
    TransportControl->setValue(pframe);
}


void MainWnd::get_wave_pixmap( QPixmap *pm )
{
    QPainter p;
    p.begin(pm, this);
    
    QPen bgp(QColor(0, 0, 0));
    QBrush bgb(QColor(0, 0, 0));
    
    p.setPen(bgp);
    p.setBrush(bgb);
    
    p.drawRect(pm->rect());
    
    if(current_source)
	current_source->get_wave_pixmap(pm, pm->rect().width()-2);
}


int MainWnd::is_seeking( void )
{
    return seeking;
}


int MainWnd::transport_position( void )
{
    return pframe;
}


unsigned MainWnd::get_total_frames( void )
{
    if(!current_source)
	return 0;
    return current_source->max_frames;
}


void MainWnd::seek_forward( void )
{
    if(!current_source)
	return;
    if(!SeekForward->isDown())
	return;
    if(!seeking)
	return;
    current_position+=500;
    if(current_position >= current_source->max_frames)
	current_position=current_source->max_frames;
    pframe=current_position;
    TransportControl->setValue(pframe);
    current_source->last_start=current_position;
    pView->repaint(false);
    seek_timer->changeInterval(200);
}


void MainWnd::OpenFile_clicked()
{
    QString strFilter="MP2/3 Audio (*.mp3 *.MP3 *.mp2 *.MP2 *.mus *.MUS);;Ogg Vorbis Audio (*.ogg);;AIFF Audio compressed (*.aifc *.AIFC);;AIFF Audio (*.aiff *.AIFF);;MPEG Layer 2 Audio (*.mp2 *.MP2);;MPEG Layer 1 audio (*.mpga *.mp1);;MPEG Movie soundtrack (*.mpg *.MPG *.mpeg *.MPEG);;WAV Audio (*.wav *.WAV)";
    QString file=QFileDialog::getOpenFileName(directory, strFilter, this, "", "Open file");
 
    OpenMediaFile(file);
    playlist->clearCurrentSong(player_number);
}

void MainWnd::OpenMediaFile(QString file)
{
	if(current_source && current_source->is_playing())
		return;
    if(file == QString::null)
	return;
    
    QFileInfo info(file);
    directory=info.dirPath(true);
 
    if(file.left(7) != "cdda://")
    {
	if(!info.exists() || !info.isReadable())
	{
	    QMessageBox::warning(this, "File error", "File cannot be read");
	}
    }
    
    Loader *l=new Loader(file, this);
    l->start();
}



void MainWnd::close_file( void )
{
    if(!current_source)
	return;
	((Frame *)parent())->clear_lock.lock();
    s_bpm=0.0f;
    if(bpm_detect)
    {
	bpm_detect->abort();
	delete bpm_detect;
	bpm_detect=0;
    }
    current_source->stop();
    player->set_stream(NULL);
    pframe=current_position=0;
    TransportControl->setValue(0);
    delete current_source;
    current_source=NULL;
    current_file="";
    current_file_name="";
    update_display();
	((Frame *)parent())->clear_lock.unlock();
}


int MainWnd::get_sample_rate( void )
{
    if(!current_source)
	return 44100;
    
	if(!current_source->sample_rate)
	return 44100;
    return current_source->sample_rate;
}


int MainWnd::init_player( int pl )
{
    pView->raise();
    switch(pl)
    {
    case 1:
	background=new QPixmap((const char **)mainwnd_background_1_xpm);
	break;
    case 2:
	ADJUST_POS(TransportControl, 70);
	ADJUST_POS(Tone, 70);
	ADJUST_POS(ToneOn, 70);
	ADJUST_POS(JogDial, 70);
	ADJUST_POS(PlayButton, 70);
	ADJUST_POS(CueButton, 70);
	ADJUST_POS(PlayMeta, 70);
	ADJUST_POS(OpenFile, 70);
	ADJUST_POS(CloseFile, 70);
	ADJUST_POS(GetFile, 70);
	ADJUST_POS(SeekForward, 70);
	ADJUST_POS(SeekBack, 70);
	ADJUST_POS(SkipBack, 70);
	ADJUST_POS(SkipFwd, 70);
	ADJUST_POS(BendDown, -320);
	ADJUST_POS(BendUp, -320);
	ADJUST_POS(ZeroButton, -320);
	ADJUST_POS(Pitch, -320);
	background=new QPixmap((const char **)mainwnd_background_2_xpm);
	pView->move(DISPLAYPOS2);
	break;
    }
    repaint();
#ifdef HAVE_LIBSOUNDTOUCH
#ifndef USE_LADSPA_PITCH
#endif
#endif
#ifdef HAVE_LADSPA
	if(!tone)
	{
	ladspa_used=true;
	LadspaEffect *t=new LadspaEffect;
    if(!t|| !t->loadEffect(((Frame *)parent())->client()->rate(), 2150, "tap_pitch"))
    {
	if(t)
	{
		delete t;
		t=NULL;
	}
    }
	if(t)
	{
		t->setControl(0, t->portDefault(0));
		t->setControl(1, t->portDefault(1));
		t->setControl(2, t->portMin(2));
		t->setControl(3, t->portDefault(3));
		tone=t;
	}
	}
#endif
	if(!tone)
	{
	Tone->hide();
	ToneOn->hide();
	}
    player=new JackPlayer(((Frame *)parent())->client(), pl);
    player->app_window=this;
    player_number=pl;
	frame->set_led(player_number-1, CUE_LED, 1);
	frame->set_led(player_number-1, PLAY_LED, 0);
    return 0;
}


void MainWnd::BendDown_pressed()
{
    bend_down_on=true;
    if(!current_source)
	return;
    bend=-1;
    current_source->set_pitch(base_pitch+(double)bend/10);
    bend_timer->stop();
    bend_timer->start(15);
}


void MainWnd::BendDown_released()
{
    bend_down_on=false;
    if(!current_source)
	return;

}


void MainWnd::BendUp_pressed()
{
    bend_up_on=true;
    if(!current_source)
	return;
    bend=-1;
    current_source->set_pitch(base_pitch+(double)bend/10);
    bend_timer->stop();
    bend_timer->start(15);
}


void MainWnd::BendUp_released()
{
    bend_up_on=false;
    if(!current_source)
	return;

}


void MainWnd::bend_timeout( void )
{
    if(!current_source)
	return;
    if(bend_down_on)
    {
	if(bend < -80)
	    return;
	bend-=1;
	current_source->set_pitch(base_pitch+(double)bend/10);
	
	return;
    }
    
    if(bend_up_on)
    {
	if(bend > 80)
	    return;
	bend+=1;
	current_source->set_pitch(base_pitch+(double)bend/10);
	
	return;
    }
    
    if(bend < 0)
    {
	bend+=2;
	if(bend > 0)
		bend=0;
	current_source->set_pitch(base_pitch+(double)bend/10);
	return;
    }
    if(bend > 0)
    {
	bend-=2;
	if(bend < 0)
		bend=0;
	current_source->set_pitch(base_pitch+(double)bend/10);
	return;
    }
    bend_timer->stop();
}


void MainWnd::SkipBack_clicked()
{
    if(!current_source)
	return;
    current_source->stop();
    PlayButton->setLit(false);
    CueButton->setLit(true);
	frame->set_led(player_number-1, PLAY_LED, 0);
	frame->set_led(player_number-1, CUE_LED, 1);
    current_position=pframe=0;
    seeking=0;
    video_preview->hide();
    current_source->set_transport_position(0);
    TransportControl->setValue(0);
    update_display();
}


void MainWnd::SkipFwd_clicked()
{
    if(!current_source)
	return;
    bool random=mixer->random();
    load_next(random);
}


void MainWnd::TransportControl_sliderPressed()
{
    if(!current_source)
	return;
    if(current_source->is_playing() && !seeking)
    {
	current_source->stop();
 	current_position=current_source->frame_position();
   }
    if(seeking)
    {
	current_position+=500;
	if(current_position >= current_source->max_frames)
	    current_position=current_source->max_frames;
    }
    PlayButton->setLit(true);
    CueButton->setLit(false);
	frame->set_led(player_number-1, PLAY_LED, 1);
	frame->set_led(player_number-1, CUE_LED, 0);
    pframe=current_position;
    QThread::postEvent(pView, new QPaintEvent(pView->rect(), false));
    current_source->play(pframe, 5000, true);
    seeking=1;
    if(current_source->has_video())
	video_preview->show();
}

void MainWnd::TransportControl_valueChanged( int val)
{
    if(setting_value || !seeking)
	return;
    current_position=val;
    if((int)current_position < 0)
	current_position=0;
    pframe=current_position;
    current_source->last_start=current_position;
    pView->repaint(false);
}

bool MainWnd::event( QEvent *e )
{
    if(e->type() == QEvent::User)
    {
	QThread::postEvent(pView, new QPaintEvent(pView->rect(), false));
	if(TransportControl->value() != (int)pframe)
	    TransportControl->setValue(pframe);
	if(current_source)
	{
	    int secs=(current_source->max_frames-pframe)/current_source->sample_rate;
	    if(!warned)
	    {
		if(secs <= warn)
		{
		    warned=true;
		    emit timeWarning(player_number);
		}
	    }
	    else
	    {
		if(secs > warn)
		    warned=false;
	    }
	}
	return true;
    }
    if(e->type() == QEvent::User+1)
    {
	loaderEvent((QLoaderEvent *)e);
	return true;
    }
    if(e->type() == QEvent::User+2)
    {
	bpmEvent((QBPMEvent *)e);
	return true;
    }
    return QWidget::event(e);
}


int MainWnd::get_peak_value( void )
{
    if(!current_source)
	return 0;
    return current_source->peak_value;
}

int MainWnd::get_max_peak_value( void )
{
    if(!current_source)
	return 0;
    return current_source->max_wavelet_value;
}

double MainWnd::get_base_pitch()
{
    return base_pitch;
}

void MainWnd::set_base_pitch(int base)
{
    base_pitch=(double)base/10.0;
    Pitch->setValue(base);
}

void MainWnd::step_forward(int step)
{
    if(!current_source)
	return;
    if(current_source->is_playing() && !seeking)
    {
	current_source->stop();
 	current_position=current_source->frame_position();
   }
    if(seeking)
    {
	current_position+=step;
	if(current_position >= current_source->max_frames)
	    current_position=current_source->max_frames;
    }
	else
	{
    PlayButton->setLit(true);
    CueButton->setLit(false);
	frame->set_led(player_number-1, PLAY_LED, 1);
	frame->set_led(player_number-1, CUE_LED, 0);
	}
    pframe=current_position;
    if(!seeking)
	current_source->play(pframe, 5000, true);
    else
	current_source->last_start=current_position;
    pView->repaint(false);
    seeking=1;
    if(current_source->has_video())
	video_preview->show();
    TransportControl->setValue(pframe);
}

void MainWnd::step_back(int step)
{
    if(!current_source)
	return;
    if(current_source->is_playing() && !seeking)
    {
	current_source->stop();
 	current_position=current_source->frame_position();
   }
    if(seeking)
    {
	current_position-=step;
	if((int)current_position < 0)
	    current_position=0;
    }
	else
	{
    PlayButton->setLit(true);
    CueButton->setLit(false);
	frame->set_led(player_number-1, PLAY_LED, 1);
	frame->set_led(player_number-1, CUE_LED, 0);
	}
    pframe=current_position;
    if(!seeking)
	current_source->play(pframe, 5000, true);
    else
	current_source->last_start=current_position;
    pView->repaint(false);
    seeking=1;
    if(current_source->has_video())
	video_preview->show();
    TransportControl->setValue(pframe);
}



void MainWnd::GetFile_clicked()
{
    QString path=playlist->getSelectedFile();
    if(path == "" || path == QString::null)
	return;
    OpenMediaFile(path);
    playlist->setCurrentSong(player_number);
}

QString MainWnd::fileName()
{
    return current_file_name;
}

bool MainWnd::isPlaying()
{
    if(!current_source)
	return false;
    
    return(current_source->is_playing());
}

void MainWnd::loaderEvent(QLoaderEvent *e)
{
    
    if(e->error())
    {
	QMessageBox::warning(this, "File error", "File format is not supported");
	delete e->loader();
	return;
    }
    QFileInfo info(e->file());
    
    close_file();
	((Frame *)parent())->metatracker->clearMetadata(player_number-1);
    pframe=0;
    warned=false;
    current_file=e->file();
    char *ext=strrchr(current_file, '.');
    if(!ext)
	ext="";
    current_file_name=info.fileName().left(info.fileName().length()-strlen(ext));
    
    StreamSource *new_source=e->source();
    new_source->set_pitch(base_pitch);
    connect(new_source, SIGNAL(frame_changed(unsigned)), this, SLOT(frame_changed(unsigned)));
    connect(new_source, SIGNAL(play_done()), this, SLOT(CueButton_clicked()));
    
    current_source=new_source;
    current_source->set_preview_framebuffer(PREVIEW_WIDTH, PREVIEW_HEIGHT, preview_framebuf);
    player->set_stream(new_source);
	player->setAgc(1.0);
    current_source=new_source;
    TransportControl->setMaxValue(current_source->max_frames);
    update_display();
    delete e->loader();
	if(current_source->can_do_multiple_reads())
	{
		if(current_source->sample_rate >= 500 && ! config->getValue("AutoBPM", "1").toInt())
		{
			StreamSource *bpm_source=current_source->get_source();
			connect(bpm_source, SIGNAL(agc_change(double)), this, SLOT(agc_change(double)));
			bpm_detect=new BPMDetect(this, bpm_source);
			bpm_detect->start();
			s_bpm=-1.0f;
		}
		else
		{
			s_bpm=0.0f;
		}
	}
	else
	{
		s_bpm=0.0f;
	}
    update_display();
	((Frame *)parent())->new_track(player_number);
}


void MainWnd::CloseFile_clicked()
{
    close_file();
    playlist->clearCurrentSong(player_number);
    update_display();
	((Frame *)parent())->metatracker->clearMetadata(player_number-1);
	((Frame *)parent())->new_track(player_number);
}

Pump *MainWnd::get_pump()
{
    return pump;
}

void MainWnd::setAttenuation(double att)
{
    if(!player)
	return;
    player->setAttenuation(att);
}

double MainWnd::attenuation()
{
    if(!player)
	return 1.0;
    return player->attenuation();
}

void MainWnd::setWarnTime(int w)
{
    warn=w;
    warned=false;
}

bool MainWnd::is_loaded()
{
    if(current_source)
	return true;
    return false;
}

bool MainWnd::load_next(int random)
{
    QString nextSong=playlist->getNextSong(random);
    if(nextSong == QString::null)
	return false;
    OpenMediaFile(nextSong);
    playlist->setCurrentSongAuto(player_number);
    return true;
}


JackPlayer * MainWnd::get_player()
{
    return player;
}


void MainWnd::paintEvent( QPaintEvent *e )
{
    if(background)
	bitBlt(this, 0, 0, background);
}


void MainWnd::ToneOn_toggled( bool on )
{
#ifdef HAVE_LADSPA
    if(!tone)
	return;
	if(ladspa_used)
	{
    if(on)
	player->addEffect(tone);
    else
	player->removeEffect(tone);
	}
#endif
}


void MainWnd::Tone_valueChanged( int val )
{
#ifdef HAVE_LADSPA
    if(!tone)
	return;
    
	if(ladspa_used)
	{
    float adj=0.0f;
	if(val < 0)
		adj=(float)val*0.1f;
	if(val > 0)
		adj=(float)val*0.1f;
    ((LadspaEffect *)tone)->setControl(1, adj);
	}
#endif
}


void MainWnd::bpmEvent( QBPMEvent *e )
{
    s_bpm=e->bpm();
    update_display();
}


float MainWnd::bpm()
{
    return s_bpm;
}


StreamSource * MainWnd::get_source()
{
    return current_source;
}


unsigned char ** MainWnd::get_frame_buffer()
{
    return ((Frame *)parent())->get_frame_buffer(player_number);
}


void MainWnd::update_preview()
{
    if(!current_source->has_video() || !seeking || !video_preview->isVisible())
	return;
    QImage im(PREVIEW_WIDTH, PREVIEW_HEIGHT, 32);
    int i, j;
    
    for(i=0;i<PREVIEW_HEIGHT;i++)
    {
	unsigned char *d=im.scanLine(i);
	unsigned char *s=preview_framebuf[i];
	
	for(j=0;j<PREVIEW_WIDTH;j++)
	{
	    d[j*4]=s[j*3+2];
	    d[j*4+1]=s[j*3+1];
	    d[j*4+2]=s[j*3];
	}
    }
    QPixmap pix;
    pix.convertFromImage(im);
    bitBlt(video_preview, 0, 0, &pix);
}


void MainWnd::PlayMeta_clicked()
{
    if(!current_source)
	return;
    
	if(((Frame *)parent())->metatracker->isMetadataLocked())
	{
    if(!current_source->is_playing())
	PlayButton_clicked();
	return;
	}
    if(current_source->writeMetadata(config->getValue("MetadataFile", "")))
    {
	if(config->getValue("MetadataCommand", "") != "")
	    system(config->getValue("MetadataCommand", ""));
	((Frame *)parent())->metatracker->setMetadataActive(player_number-1);
    }
    if(!current_source->is_playing())
	PlayButton_clicked();
}


void MainWnd::agc_change( double a)
{
    player->setAgc(a);
}
