#
# Misc.py - DITrack miscellaneous functions
#
# Copyright (c) 2006-2007 The DITrack Project, www.ditrack.org.
#
# $Id: Misc.py 1888 2007-08-16 15:07:03Z gli $
# $HeadURL: https://127.0.0.1/ditrack/src/tags/0.7/DITrack/Util/Misc.py $
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

import os

def spawnvp(mode, file, args):
    """ Make the same as os.spawnvp(), available at all platforms."""

    if os.name == "posix":
        return os.spawnvp(mode, file, args)
    elif os.name == "nt":
        if os.path.exists(file):
            return os.spawnv(mode, file, ['"%s"' % args[0]] + args[1:])
        else:
            for dir in os.environ["PATH"].split(";"):
                if os.path.isfile(os.path.join(dir, file)):
                    break
            else:
                # XXX: Possibly use smth like DITrack.Common.ErrCode
                # if there's more then one error values

                # 127 is the error code returned by exec*() functions on POSIX
                # systems when a $PATH lookup has failed.
                return 127

            full_path = os.path.join(dir, file);
            return os.spawnv(mode, full_path, ['"%s"' % full_path] + args[1:])
