#!/usr/bin/env python

import unittest
import sys, os, os.path

def suite():
    allFiles = os.listdir(os.path.abspath(os.path.dirname(__file__)))
    tests = []
    for name in allFiles:
        if name.startswith('Test') and name.endswith('.py'):
            tests.append(name.split('.')[0]) #part before dot
    alltests = unittest.TestSuite()
    for name in tests:
        module = __import__(name)
        alltests.addTest(module.suite())
    return alltests

if __name__ == '__main__':
    unittest.main(defaultTest='suite')
