/* Copyright (C) 2000,2001,2002 Manuel Amador (Rudd-O)
   This file is part of Directory administrator.

   Directory administrator is free software; you can redistribute it
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   Directory administrator is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <libgnomeui/gnome-dialog.h>
#include <string.h>

#include <errno.h>
#include <lber.h>
#include <ldap.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "appglobals.h"
#include "users.h"
#include "groups.h"
#include "appfunctions.h"
#include "prefsdialog.h"
#include "usergrouplists.h"
#include "modifydialogs.h"
#include "newdruids.h"
#include "connect_dialog.h"
#include "prefs.h"
#include "icon_entry.h"
#include "dir_entry.h"
#include "charset.h"
#include "schema.h"

void
on_exit1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_main_quit ();
}


void
on_cut1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
on_copy1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
on_paste1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
on_clear1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
on_preferences1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_widget_show (create_preferences ());

}


void
on_about1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GnomeAbout*w;
  GtkWidget*b,*b2;
  GtkVBox*v;
  gchar *pixmap1_filename;
  GtkWidget *pixmap1;


  w = (GnomeAbout*) create_about ();
  v = GTK_VBOX(w->dialog.vbox);

  b = gnome_href_new ("http://diradmin.open-it.org/", "Go to Web site: http://diradmin.open-it.org/");
  gtk_widget_ref (b);
  gtk_object_set_data_full (GTK_OBJECT (w), "b", b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (b);
  gtk_container_add(GTK_CONTAINER(v),b);

/*
  pixmap1 = gtk_type_new (gnome_pixmap_get_type ());
  pixmap1_filename = gnome_pixmap_file ("directory_administrator/foo.png");
  if (pixmap1_filename)
    gnome_pixmap_load_file (GNOME_PIXMAP (pixmap1), pixmap1_filename);
  else
    g_warning ("Couldn't find pixmap file: %s", "foo.png");
  g_free (pixmap1_filename);
  gtk_widget_ref (pixmap1);
  gtk_object_set_data_full (GTK_OBJECT (w), "pixmap1", pixmap1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pixmap1);
  gtk_box_pack_start (GTK_BOX (v), pixmap1, TRUE, TRUE, 0);

  b2 = gnome_href_new ("http://foo/", "foo");
  gtk_widget_ref (b2);
  gtk_object_set_data_full (GTK_OBJECT (w), "b2", b2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (b2);
  gtk_container_add(GTK_CONTAINER(v),b2);

*/

  gtk_widget_show(GTK_WIDGET(w));
}


void
on_mainwindow_destroy (GtkObject * object, gpointer user_data)
{
  gtk_main_quit ();
}


void
on_button4_clicked (GtkButton * button, gpointer user_data)
{
  if (on_button4_clicked_handler (button, (GtkWidget *) user_data) == TRUE)
    gtk_widget_destroy (lookup_widget ((GtkWidget *) button, "login"));

}


void
on_login_destroy (GtkObject * object, gpointer user_data)
{
  gtk_object_destroy (object);
}






void
on_login_cancel_button_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (lookup_widget ((GtkWidget *) button, "login"));
}


void
on_button_add_profile_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *about = create_druid_new_profile ();

  gtk_object_set_user_data ((GtkObject *) about,
			    lookup_widget ((GtkWidget *) button,
					   "list_profiles"));

/*  gtk_signal_connect (GTK_OBJECT (lookup_widget (about, "finish")),
		      "finish", GTK_SIGNAL_FUNC (on_button4_clicked),
		      lookup_widget ((GtkWidget *) button, "list_profiles"));*/
  gtk_widget_show (about);

}


void
on_button_connect_toggled (GtkToggleButton * togglebutton, gpointer user_data)
{


  if (!app_is_connected() && GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
    app_interactive_connect();

    }
  else
    {
    app_interactive_disconnect();

    }

}



void
on_button_test_connection_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *mesg;
  connection_profile *test;
  int ldap_errors;
  char buf[2048];

  gchar *nombrecitocojudo;

  nombrecitocojudo =
    gtk_entry_get_text ((GtkEntry *)
			lookup_widget ((GtkWidget *) button,
				       "entry_login_server"));
  if (strlen (nombrecitocojudo) == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a server"));
      return;
    }

  test =
    connection_profile_new (gtk_entry_get_text
			    ((GtkEntry *)
			     lookup_widget ((GtkWidget *) button,
					    "entry_profile_name")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_dn")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_pw")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_server")),
			    gtk_toggle_button_get_active ((GtkToggleButton *)
				    		lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_tls")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_treeroot")));
  ldap_errors = connection_profile_connect (test);

  if (ldap_errors)
    {
      g_snprintf (buf, 2048, "Connection failed: %s",
		  ldap_err2string (ldap_errors));
      mesg = create_messagebox_with_message ((char *) &buf);
    }
  ////THIS IS ONLY DEBUG BEHAVIOR!! REMOVE BEFORE SHIPPING!!!!!
  else
    {
      mesg = create_messagebox_with_message ("The connection was successful");
    }

  gtk_widget_show (mesg);
  connection_profile_destroy (test);

}


void
on_list_profiles_map (GtkWidget * widget, gpointer user_data)
{

  list_profiles_fill (widget);

}


void
on_button_remove_profile_clicked (GtkButton * button, gpointer user_data)
{
  gint selected_crap = (gint) user_data;
  gchar *profilename = NULL;
  connection_profile *conprof = NULL;

  GtkWidget *profile_list =
    (GtkWidget *) lookup_widget ((GtkWidget *) button, "list_profiles");

  gtk_clist_get_text ((GtkCList *) profile_list, selected_crap, 0,
		      &profilename);

  //if profilename is null, just return, because it means nothing is selected;
  if (profilename == NULL)
    return;

  // this used to be the handler:  g_assert(profilename);

  conprof =
    connection_profile_list_getbyname (connection_profile_list, profilename);
  if (conprof == NULL)
    {
      g_print ("***ERROR! could not get data about selected profile");
      return;
    }

  connection_profile_list =
    connection_profile_list_remove (connection_profile_list, conprof);

  gtk_clist_remove ((GtkCList *)
		    lookup_widget ((GtkWidget *) button, "list_profiles"),
		    selected_crap);

}

void
on_button_modify_profile_clicked (GtkButton * button, gpointer user_data)
{

  GtkWidget *about = NULL;
  gint selected_crap = (gint) user_data;
  gchar *profilename = NULL;
  GtkWidget *profile_list =
    (GtkWidget *) lookup_widget ((GtkWidget *) button, "list_profiles");

  gtk_clist_get_text ((GtkCList *) profile_list, selected_crap, 0,
		      &profilename);

  //if profilename is null, just return, because it means nothing is selected;
  g_assert (profilename);

  about = create_login ();

  fill_login (about, profilename);
  gtk_signal_connect (GTK_OBJECT (lookup_widget (about, "button4")),
		      "clicked", GTK_SIGNAL_FUNC (on_login_modify_finish),
		      profile_list);

  gtk_widget_show (about);


}


void
on_list_profiles_select_row (GtkCList * clist,
			     gint row,
			     gint column,
			     GdkEvent * event, gpointer user_data)
{

  GtkWidget *button_remove_profile =
    lookup_widget ((GtkWidget *) clist, "button_remove_profile");
  GtkWidget *button_modify_profile =
    lookup_widget ((GtkWidget *) clist, "button_modify_profile");

  printf ("\nSelected row %d\n", row);

  gtk_signal_disconnect (GTK_OBJECT (button_remove_profile),
			 preferences_profile_list_signal_reference);
  gtk_signal_disconnect (GTK_OBJECT (button_modify_profile),
			 preferences_profile_list_signal_reference2);

  preferences_profile_list_signal_reference =
    gtk_signal_connect (GTK_OBJECT (button_remove_profile), "clicked",
			GTK_SIGNAL_FUNC (on_button_remove_profile_clicked),
			(gpointer) row);
  preferences_profile_list_signal_reference2 =
    gtk_signal_connect (GTK_OBJECT (button_modify_profile), "clicked",
			GTK_SIGNAL_FUNC (on_button_modify_profile_clicked),
			(gpointer) row);

}


void
on_client_setup1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *about = create_druid_client_setup ();
  gtk_widget_show (about);

}


void
on_enableperserverlogon_toggled (GtkToggleButton * togglebutton,
				 gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_show (lookup_widget
		       (GTK_WIDGET (togglebutton), "label_serverid"));
      gtk_widget_show (lookup_widget (GTK_WIDGET (togglebutton), "serverid"));
      /* If control reaches here, the toggle button is down */

    }
  else
    {
      gtk_widget_hide (lookup_widget
		       (GTK_WIDGET (togglebutton), "label_serverid"));
      gtk_widget_hide (lookup_widget (GTK_WIDGET (togglebutton), "serverid"));
      /* If control reaches here, the toggle button is up */
    }

}



void
on_button_add_shell_clicked (GtkButton * button, gpointer user_data)
{

}


void
on_button_up_shell_clicked (GtkButton * button, gpointer user_data)
{

}


void
on_button_down_shell_clicked (GtkButton * button, gpointer user_data)
{

}


void
on_button_remove_shell_clicked (GtkButton * button, gpointer user_data)
{

}


void
on_loginshells_map (GtkWidget * widget, gpointer user_data)
{

  fill_loginshells_list (widget);

}


void
on_loginshells_select_row (GtkCList * clist,
			   gint row,
			   gint column, GdkEvent * event, gpointer user_data)
{

  GtkWidget *button_up_shell =
    lookup_widget ((GtkWidget *) clist, "button_up_shell");
  GtkWidget *button_down_shell =
    lookup_widget ((GtkWidget *) clist, "button_down_shell");
  GtkWidget *button_remove_shell =
    lookup_widget ((GtkWidget *) clist, "button_remove_shell");

  printf ("\nSelected row %d\n", row);

  gtk_signal_disconnect (GTK_OBJECT (button_up_shell),
			 preferences_loginshells_signal_reference);
  gtk_signal_disconnect (GTK_OBJECT (button_down_shell),
			 preferences_loginshells_signal_reference2);
  gtk_signal_disconnect (GTK_OBJECT (button_remove_shell),
			 preferences_loginshells_signal_reference3);

  preferences_loginshells_signal_reference =
    gtk_signal_connect (GTK_OBJECT (button_up_shell), "clicked",
			GTK_SIGNAL_FUNC (on_button_up_shell_clicked),
			(gpointer) row);
  preferences_loginshells_signal_reference2 =
    gtk_signal_connect (GTK_OBJECT (button_down_shell), "clicked",
			GTK_SIGNAL_FUNC (on_button_down_shell_clicked),
			(gpointer) row);
  preferences_loginshells_signal_reference3 =
    gtk_signal_connect (GTK_OBJECT (button_remove_shell), "clicked",
			GTK_SIGNAL_FUNC (on_button_remove_shell_clicked),
			(gpointer) row);


}


void
on_minuid_map (GtkWidget * widget, gpointer user_data)
{
  char buf[256];
  g_snprintf (buf, 256, "%d", preferences.logindefaults.VUID_MIN);
  gtk_entry_set_text (GTK_ENTRY (widget), buf);
}


void
on_mingid_map (GtkWidget * widget, gpointer user_data)
{
  char buf[256];
  g_snprintf (buf, 256, "%d", preferences.logindefaults.VGID_MIN);
  gtk_entry_set_text (GTK_ENTRY (widget), buf);

}


void
on_profileselected_map (GtkWidget * widget, gpointer user_data)
{
  profileselected_fill (widget);
}



void
on_selectprofile_okay_clicked (GtkButton * button, gpointer user_data)
{

  if (!profileselected_commit (GTK_WIDGET (button)))
    {
      gtk_widget_destroy (lookup_widget
			  (GTK_WIDGET (button), "connect_selectprofile"));
    }

}


void
  on_connect_selectprofile_cancel_clicked
  (GtkButton * button, gpointer user_data)
{
  gtk_toggle_button_set_active ((GtkToggleButton *)
				lookup_widget (app, "button_connect"), FALSE);
  gtk_widget_destroy (lookup_widget
		      (GTK_WIDGET (button), "connect_selectprofile"));

}


void
on_cancel_clicked (GtkButton * button, gpointer user_data)
{

}


void
on_modifygroup_cancel_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (lookup_widget ((GtkWidget *) button, "modifygroup"));

}


void
on_modifyuser_cancel_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (lookup_widget ((GtkWidget *) button, "modifyuser"));

}


void
on_button_modifyselection_clicked (GtkButton * button, gpointer user_data)
{

  GtkWidget *mainwindow;
  GnomeIconList *itemlist = NULL;
  gint pos;
  dir_entry *entry;
//  GList* selections;
  //GList * iter;
  itemlist =
    (GnomeIconList *) lookup_widget (GTK_WIDGET (button), "itemlist");

  if (itemlist->selection == NULL) return;

  pos = GPOINTER_TO_INT (itemlist->selection->data);
  entry = gnome_icon_list_get_icon_data (itemlist, pos);

  if (entry->type == DENTRY_USER)
    {
      mainwindow = create_modifyuser ();
      gtk_widget_show (mainwindow);
      fill_modifyuser (mainwindow, dir_entry_get_dn(entry));
    }
  if (entry->type == DENTRY_GROUP)
    {
      mainwindow = create_modifygroup ();
      gtk_widget_show (mainwindow);
      fill_modifygroup (mainwindow, dir_entry_get_dn(entry));
    }

}


void
on_logontoallservers_toggled (GtkToggleButton * togglebutton,
			      gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_hide (lookup_widget
		       (GTK_WIDGET (togglebutton), "frame_loginservers"));
      /* If control reaches here, the toggle button is down */

    }
  else
    {
      gtk_widget_show (lookup_widget
		       (GTK_WIDGET (togglebutton), "frame_loginservers"));
      /* If control reaches here, the toggle button is up */
      gtk_widget_grab_focus (lookup_widget
		       (GTK_WIDGET (togglebutton), "selectedserver"));
    }

}


void
on_button_new_clicked (GtkButton * button, gpointer user_data)
{

  GtkWidget *mainwindow = NULL;

  if (connection_profile_is_connected (current_connection_profile))
    {

		if (!cached_dir_entries_has_ous())
			gtk_widget_show(create_messagebox_with_message("Your directory appears empty, or it does not have organizational units.\nPlease initialize your directory with the MigrationTools from PADL.com."));
		else if (!cached_dir_entries_has_groups())
			gtk_widget_show(create_messagebox_with_message("You cannot create a user until you have created\na group. Please create a group first."));
		else {
	  		mainwindow = create_druid_new_user ();
			gtk_widget_show (mainwindow);
		}


    }

}


void
on_druid_new_user_druid_cancel (GnomeDruid * gnomedruid, gpointer user_data)
{
  gtk_widget_destroy (lookup_widget ((GtkWidget *) gnomedruid,
				     "druid_new_user"));
}


void
on_button_passwd_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_show (lookup_widget (GTK_WIDGET (button), "tablepassword"));
  gtk_widget_destroy (GTK_WIDGET (button));

}


void
on_adduser_togroup_clicked (GtkButton * button, gpointer user_data)
{
  GtkCList *memberlist = NULL;
  GtkWidget *about = create_selectuser ();
  memberlist = (GtkCList *) lookup_widget (GTK_WIDGET (button), "members");
  gtk_object_set_user_data (GTK_OBJECT (about), memberlist);
  gtk_widget_show (about);

}


void
on_userselected_map (GtkWidget * widget, gpointer user_data)
{
  fill_users_dropdown (widget);

}


void
on_selectuser_okay_clicked (GtkButton * button, gpointer user_data)
{
	GtkCList *memberlist = NULL;
	GtkCList *parentmemberlist = NULL;
	GtkWidget *mywindow = NULL;
	char *row[3];
	char *broughtrow;
//	GList*selectedrows;
	//GList*loop;
	gint numrows;
	gint n;
	GList*loopix;
	gint confirmadd = 1;
	gchar* asciichar;
	gchar * uid;
	gchar * thisdn;
	dir_entry * dentry;
	gchar * message;
	row[0] = NULL;
	row[1] = NULL;
	row[2] = NULL;

	g_print("Adding selected members to group member C-list...\n");
	mywindow = lookup_widget (GTK_WIDGET (button), "selectuser");
	parentmemberlist = (GtkCList *) gtk_object_get_user_data (GTK_OBJECT (mywindow));
	memberlist =(GtkCList*)lookup_widget (GTK_WIDGET (button), "members");

	for(loopix=memberlist->selection;loopix!=NULL;loopix=loopix->next) {
		confirmadd = 1;
		numrows = (gint)loopix->data;
		thisdn =gtk_clist_get_row_data(memberlist,numrows);
		dentry = cached_dir_entries_getbydn(thisdn);
		uid = NULL;
		if (dentry) uid = dentry->uid;
		if (uid) {
			asciichar = convert_to_ascii(uid);
			if (g_strcasecmp(uid,asciichar) != 0) {
				message = g_strconcat("The user " , dir_entry_get_cn(dentry), " cannot be added because its user ID has non-ASCII\n",
				 "characters (e.g. accented characters).  Please change its user ID and try again.", NULL);
				gtk_widget_show(create_messagebox_with_message(message));
				g_free(message);
				confirmadd = 0;
			}
			g_free(asciichar);
		}
		if (confirmadd) {
			gtk_clist_get_text(memberlist,numrows,0,&broughtrow);
			g_print("  Text in row: %s\n",broughtrow);
			row[0] = g_strdup("Secondary");
			row[1] = broughtrow;
			n=gtk_clist_append (parentmemberlist, row);
			g_print("  DN in row: %s\n",thisdn);
			gtk_clist_set_row_data(parentmemberlist,n,thisdn);
		}
	}

	gtk_clist_columns_autosize(parentmemberlist);
	gtk_widget_destroy(mywindow);

}





void
on_selectuser_cancel_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (lookup_widget (GTK_WIDGET (button), "selectuser"));

}


void
on_deluser_fromgroup_clicked (GtkButton * button, gpointer user_data)
{
  GtkCList *memberlist = NULL;
//  GList*loopix;
  gint mimi;
  gboolean shown = 0;
  gchar*celltext; gchar*message;
  GList*mylist=NULL;

  memberlist = (GtkCList *) lookup_widget (GTK_WIDGET (button), "members");
  if (memberlist->selection)
    {
mylist = memberlist->selection;
		while (mylist) {
			gtk_clist_get_text(memberlist,(int)mylist->data,0,&celltext);
			if (g_strcasecmp(celltext,"Primary") == 0 && shown == 0) {
				message = g_strconcat ("Primary members cannot be deleted directly from this list.\nYou need to directly change the primary member in the user property page", NULL);
				shown = 1;
				gtk_widget_show (create_messagebox_with_message (message));
				g_free(message);
				mylist = mylist->next;
			} else {
				mimi = GPOINTER_TO_INT(mylist->data);
				mylist = mylist->next;
				g_print("Removing member number %d from the list\n",mimi);
				gtk_clist_remove (memberlist,mimi);

//				mylist=g_list_append(mylist, GPOINTER_TO_INT (loopix->data));
			}
		}

		//actually REMOVE the elements from the list
		//for(mylist=g_list_last(mylist);mylist;mylist=mylist->prev) {
		///		g_print("Removing member number %d from the list\n",mylist->data);
		//		gtk_clist_remove (memberlist, GPOINTER_TO_INT (mylist->data));
		//}
		//g_list_free(mylist);
		gtk_widget_grab_focus(GTK_WIDGET(memberlist));
    }

}


void
on_addserver_clicked (GtkButton * button, gpointer user_data)
{

  GtkCList *memberlist = NULL;
  GtkWidget *mywindow = NULL;
  GtkEntry* selectedserver;
  char *row[1];
  row[0] = NULL;


  memberlist =
    (GtkCList *) lookup_widget (GTK_WIDGET (button), "allowedservers");

  selectedserver = GTK_ENTRY
			(lookup_widget
			 (GTK_WIDGET (button), "selectedserver"));

  row[0] =
    gtk_entry_get_text (selectedserver);
  if (strlen (row[0]) == 0)
    {
      mywindow =
	create_messagebox_with_message ("Please supply a server name");
      gtk_widget_show (mywindow);
    }
  else
    {
      gtk_clist_append (memberlist, row);
      gtk_entry_set_text (selectedserver, "");
      gtk_widget_grab_focus(GTK_WIDGET(selectedserver));
    }





}


void
on_delserver_clicked (GtkButton * button, gpointer user_data)
{
  GtkCList *memberlist = NULL;
  memberlist =
    (GtkCList *) lookup_widget (GTK_WIDGET (button), "allowedservers");
  if (memberlist->selection)
    {
      gtk_clist_remove (memberlist,
			GPOINTER_TO_INT (memberlist->selection->data));
    }
  gtk_widget_grab_focus(GTK_WIDGET(memberlist));

}


void
on_addserver_okay_clicked (GtkButton * button, gpointer user_data)
{
  GtkCList *memberlist = NULL;
  GtkWidget *mywindow = NULL;
  char *row[1];
  row[0] = NULL;

  mywindow = lookup_widget (GTK_WIDGET (button), "addserver");
  memberlist = (GtkCList *) gtk_object_get_user_data (GTK_OBJECT (mywindow));

  row[0] =
    gtk_entry_get_text (GTK_ENTRY
			(lookup_widget
			 (GTK_WIDGET (button), "selectedserver")));
  if (strlen (row[0]) == 0)
    {
      mywindow =
	create_messagebox_with_message ("You need to supply a server name");
      gtk_widget_show (mywindow);
    }
  else
    {
      gtk_clist_append (memberlist, row);
      gtk_widget_destroy (mywindow);
    }
}


void
on_addserver_cancel_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (lookup_widget (GTK_WIDGET (button), "addserver"));

}


void
on_druid_new_profile_druid_cancel (GnomeDruid * gnomedruid,
				   gpointer user_data)
{
  gtk_widget_destroy (lookup_widget ((GtkWidget *) gnomedruid,
				     "druid_new_profile"));

}


void
on_druid_client_setup_druid_cancel (GnomeDruid * gnomedruid,
				    gpointer user_data)
{
  gtk_widget_destroy (lookup_widget ((GtkWidget *) gnomedruid,
				     "druid_client_setup"));

}



void
on_modifyuser_okay_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *window = NULL;

  window = lookup_widget (GTK_WIDGET (button), "modifyuser");
  if (modifyuser_check (window) == OK)
    if (modifyuser_commit (window) == OK)
      gtk_widget_destroy (window);

}





void
on_modifygroup_okay_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *window = NULL;

  window = lookup_widget (GTK_WIDGET (button), "modifygroup");
  if (modifygroup_check (window) == OK)
    if (modifygroup_commit (window) == OK)
      gtk_widget_destroy (window);

}



void
on_givenname_changed (GtkEditable * editable, gpointer user_data)
{
  //aqui y en la sig. funcion hay fuga de memoria en el strdelimit
  GtkEntry *cn, *sn, *givenname, *uid;
  gchar *text;
  gchar newdel = '_';

  cn = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "cn"));
  sn = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "sn"));
  givenname = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "givenname"));
  uid = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "uid"));

  gtk_editable_delete_text (GTK_EDITABLE (cn), 0, -1);
  gtk_entry_set_text (cn,
		      gtk_editable_get_chars (GTK_EDITABLE (givenname), 0,
					      -1));
  gtk_entry_append_text (cn, " ");
  gtk_entry_append_text (cn,
			 gtk_editable_get_chars (GTK_EDITABLE (sn), 0, -1));

  gtk_editable_delete_text (GTK_EDITABLE (uid), 0, -1);

  text = g_strdup (gtk_editable_get_chars (GTK_EDITABLE (givenname), 0, 1));
  g_strdown (text);
  gtk_entry_set_text (uid, text);
  g_free (text);
  text = g_strdup (gtk_editable_get_chars (GTK_EDITABLE (sn), 0, -1));
  g_strdown (text);
  text = g_strdelimit (text, G_STR_DELIMITERS, newdel);
  gtk_entry_append_text (uid, text);
  g_free (text);
}


void
on_sn_changed (GtkEditable * editable, gpointer user_data)
{
  GtkEntry *cn, *sn, *givenname, *uid;
  gchar *text;
  gchar newdel = '_';

  cn = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "cn"));
  sn = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "sn"));
  givenname = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "givenname"));
  uid = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "uid"));

  gtk_editable_delete_text (GTK_EDITABLE (cn), 0, -1);
  gtk_entry_set_text (cn,
		      gtk_editable_get_chars (GTK_EDITABLE (givenname), 0,
					      -1));
  gtk_entry_append_text (cn, " ");
  gtk_entry_append_text (cn,
			 gtk_editable_get_chars (GTK_EDITABLE (sn), 0, -1));

  gtk_editable_delete_text (GTK_EDITABLE (uid), 0, -1);

  text = g_strdup (gtk_editable_get_chars (GTK_EDITABLE (givenname), 0, 1));
  g_strdown (text);
  gtk_entry_set_text (uid, text);
  g_free (text);
  text = g_strdup (gtk_editable_get_chars (GTK_EDITABLE (sn), 0, -1));
  g_strdown (text);
  text = g_strdelimit (text, G_STR_DELIMITERS, newdel);
  gtk_entry_append_text (uid, text);
  g_free (text);
}


void
on_uid_changed (GtkEditable * editable, gpointer user_data)
{
  GtkEntry *homedirectory, *uid;

  homedirectory =
    GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "homedirectory"));
  uid = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "uid"));

  gtk_editable_delete_text (GTK_EDITABLE (homedirectory), 0, -1);
  gtk_entry_set_text (homedirectory, "/home/");
  gtk_entry_append_text (homedirectory,
			 gtk_editable_get_chars (GTK_EDITABLE (uid), 0, -1));

}


gboolean
on_druidpageessential_next (GnomeDruidPage * gnomedruidpage,
			    gpointer arg1, gpointer user_data)
{
dir_entry*found;
  GtkWidget *window =
    lookup_widget (GTK_WIDGET (gnomedruidpage), "druid_new_user");
  if (strlen
      (gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "givenname"))))
      == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("Please enter the first name"));
      return (TRUE);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "sn"))))
      == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("Please enter the last name"));
      return (TRUE);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "cn"))))
      == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("Please enter a common name for the user"));
      return (TRUE);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "uid"))))
      == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("Please enter a user ID"));
      return (TRUE);
    }

  if (strlen
      (gtk_entry_get_text
       (GTK_ENTRY (lookup_widget (window, "userpassword")))) == 0
      &&
      strlen (gtk_entry_get_text
	      (GTK_ENTRY (lookup_widget (window, "userpasswordconfirm")))) ==
      0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a password before continuing"));
			   gtk_widget_grab_focus(lookup_widget(window,"userpassword"));
      return (TRUE);
    }
  if (gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "userpassword")))
      &&
      gtk_entry_get_text (GTK_ENTRY
			  (lookup_widget (window, "userpasswordconfirm")))
      &&
      strcmp (gtk_entry_get_text
	      (GTK_ENTRY (lookup_widget (window, "userpassword"))),
	      gtk_entry_get_text (GTK_ENTRY
				  (lookup_widget
				   (window, "userpasswordconfirm")))) != 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("The passwords you entered do not match.  Please check them."));
			   gtk_widget_grab_focus(lookup_widget(window,"userpassword"));
      return (TRUE);
    }

if (preferences.avoidconflicts && preferences.avoidconflictscope == ENTIREDIR) {
found = cached_dir_entries_getbyuid( gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "uid")) ) );
if (found)
	{
      gtk_widget_show (create_messagebox_with_message
		       ("The user ID you typed already exists in the directory.  Please choose another."));
      return (TRUE);
    }
}
      //gtk_widget_grab_focus (lookup_widget
		//       (GTK_WIDGET (gnomedruidpage), "logontoallservers"));


  return (FALSE);


}


gboolean
on_druidpageaccesscontrol_next (GnomeDruidPage * gnomedruidpage,
				gpointer arg1, gpointer user_data)
{
      gtk_widget_grab_focus (lookup_widget
		       (GTK_WIDGET (gnomedruidpage), "o"));

	return FALSE;
}


gboolean
on_druidpageunixaccount_next (GnomeDruidPage * gnomedruidpage,
			      gpointer arg1, gpointer user_data)
{
  GtkWidget *window =
    lookup_widget (GTK_WIDGET (gnomedruidpage), "druid_new_user");
  gdouble test;
  gchar *gidnumber = NULL;

  if (GTK_TOGGLE_BUTTON
      (lookup_widget (GTK_WIDGET (gnomedruidpage), "automaticuid"))->active ==
      FALSE)
    {
      gidnumber =
	gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "uidnumber")));
      test = g_strtod (gidnumber, NULL);
      if (strlen (gidnumber) == 0)
	{
	  gtk_widget_show (create_messagebox_with_message
			   ("Type a number in the UNIX UID number entry"));
	  return (TRUE);
	}
      if (test == 0 && g_strcasecmp ("0", gidnumber) != 0)
	{
	  gtk_widget_show (create_messagebox_with_message
			   ("Invalid UNIX UID number"));
	  return (TRUE);
	}
    }
  if (strlen
      (gtk_entry_get_text
       (GTK_ENTRY (lookup_widget (window, "homedirectory")))) == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a home directory"));
      return (TRUE);
    }

      //gtk_widget_grab_focus (lookup_widget
		//       (GTK_WIDGET (gnomedruidpage), "enablesambaobjectclass"));

  return (FALSE);
}


void
on_druidpagefinish3_finish (GnomeDruidPage * gnomedruidpage,
			    gpointer arg1, gpointer user_data)
{
  GtkWidget *window =
    lookup_widget (GTK_WIDGET (gnomedruidpage), "druid_new_user");
  if (newuser_commit (gnomedruidpage) == OK)
    gtk_widget_destroy (window);
}


void
on_uidnumber_map (GtkWidget * widget, gpointer user_data)
{
}


void
on_button_removeselection_clicked (GtkButton * button, gpointer user_data)
{

  if (objectview_has_selection())
  gtk_widget_show (create_deleteselection ());
}


gboolean
on_druidpagegroupinfo_next (GnomeDruidPage * gnomedruidpage,
			    gpointer arg1, gpointer user_data)
{

dir_entry*found;
  GtkWidget *window =
    lookup_widget (GTK_WIDGET (gnomedruidpage), "druid_new_group");
  gdouble test;
  gchar *gidnumber = NULL;
  if (strlen (gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "cn"))))
      == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("Please enter a group name"));
      return (TRUE);
    }
  if (GTK_TOGGLE_BUTTON
      (lookup_widget (GTK_WIDGET (gnomedruidpage), "automaticgid"))->active ==
      FALSE)
    {
      gidnumber =
	gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "gidnumber")));
      test = g_strtod (gidnumber, NULL);
      if (strlen (gidnumber) == 0)
	{
	  gtk_widget_show (create_messagebox_with_message
			   ("Please type a particular ID"));
	  return (TRUE);
	}
      if (test == 0 && g_strcasecmp ("0", gidnumber) != 0)
	{
	  gtk_widget_show (create_messagebox_with_message
			   ("Invalid UNIX GID number"));
	  return (TRUE);
	}
    }


if (preferences.avoidconflicts && preferences.avoidconflictscope == ENTIREDIR) {
found = cached_dir_entries_getgroupbycn( gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "cn")) ) );
if (found)
	{
      gtk_widget_show (create_messagebox_with_message
		       ("The group name you typed already exists in the directory.  Please choose another."));
      return (TRUE);
    }

  if (GTK_TOGGLE_BUTTON
      (lookup_widget (GTK_WIDGET (gnomedruidpage), "sambaGroupMapping"))->active == TRUE &&
      !lookup_widget (GTK_WIDGET (gnomedruidpage), "sambaDomainName"))
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You have specified that this group is accessible from a Windows domain, but no domain has been chosen, or there are no Windows domains in the LDAP directory."));
    }
}


   //gtk_widget_grab_focus(lookup_widget(gnomedruidpage,"members"));

  return FALSE;
}


void
on_button_new_group_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *mainwindow = NULL;

  if (connection_profile_is_connected (current_connection_profile))
    {

		if (!cached_dir_entries_has_ous())
			gtk_widget_show(create_messagebox_with_message("Your directory appears empty, or it does not have organizational units.\nPlease initialize your directory with the MigrationTools from PADL.com."));
		else {
			mainwindow = create_druid_new_group ();
      		gtk_widget_show (mainwindow);
		}

    }

}


void
on_gidnumber_map (GtkWidget * widget, gpointer user_data)
{

}


void
on_druid_new_group_druid_cancel (GnomeDruid * gnomedruid, gpointer user_data)
{
  gtk_widget_destroy (lookup_widget ((GtkWidget *) gnomedruid,
				     "druid_new_group"));

}


void
on_druidpagefinish4_finish (GnomeDruidPage * gnomedruidpage,
			    gpointer arg1, gpointer user_data)
{
  GtkWidget *window =
    lookup_widget (GTK_WIDGET (gnomedruidpage), "druid_new_group");
  if (newgroup_commit (gnomedruidpage) == OK)
    gtk_widget_destroy (window);

}


void
on_enablemailpolicycontrol_toggled (GtkToggleButton * togglebutton,
				    gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_show (lookup_widget (GTK_WIDGET (togglebutton), "frame6"));
      gtk_widget_grab_focus(lookup_widget
				(GTK_WIDGET (togglebutton), "mailroutingaddressset"));

    }
  else
    {
      gtk_widget_hide (lookup_widget (GTK_WIDGET (togglebutton), "frame6"));
    }

}


void
on_mailroutingaddressset_toggled (GtkToggleButton * togglebutton,
				  gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton),
				 "mailroutingaddress"), TRUE);
      gtk_widget_grab_focus(lookup_widget
				(GTK_WIDGET (togglebutton), "mailroutingaddress"));

    }
  else
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton),
				 "mailroutingaddress"), FALSE);
    }

}


void
on_mailhostset_toggled (GtkToggleButton * togglebutton, gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "mailhost"),
				TRUE);
      gtk_widget_grab_focus(lookup_widget
				(GTK_WIDGET (togglebutton), "mailhost"));

    }
  else
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "mailhost"),
				FALSE);
    }

}


void
on_user_baseoudropdown_map (GtkWidget * widget, gpointer user_data)
{

  gint i;
  GList* j;
  gchar* bestmatch = NULL;
  gchar* b;
  gchar *alternatives[] =  { "People","User",NULL } ;
  GList * dnlist;
  GList*papa;


  g_print ("\ncalled: on_user_baseoudropdown_map\n");

  dnlist = get_orgunit_dn_list_from_cache ();

  b = connection_profile_get_last_user_ou
      (connection_profile_list_getbyname
       (connection_profile_list,
        connection_profile_get_name (current_connection_profile)));


  gtk_combo_set_popdown_strings (GTK_COMBO (widget),dnlist);

  if (b) {
    papa = g_list_find_custom(dnlist,b,(GCompareFunc)g_strcasecmp);
	if (papa != NULL)
		gtk_entry_set_text (GTK_ENTRY(lookup_widget (widget, "baseou")),b);
}

  else {
   // busquemos una buena alternativa
    for (i=0;alternatives[i];i++)
      for (j=dnlist;j;j=j->next)
        if (strstr((char*)j->data,alternatives[i]) != NULL)
 	  bestmatch = (char*)j->data;

  if (bestmatch)
    gtk_entry_set_text (GTK_ENTRY
			(lookup_widget (widget, "baseou")),bestmatch);

  }

}


void
on_group_baseoudropdown_map (GtkWidget * widget, gpointer user_data)
{

  gint i;
  GList* j;
  gchar* bestmatch = NULL;
  gchar* b;
  gchar *alternatives[] =  { "Group",NULL } ;
  GList * dnlist;
  GList* papa;

  g_print ("\ncalled: on_group_baseoudropdown_map\n");

  dnlist = get_orgunit_dn_list_from_cache ();

  b = connection_profile_get_last_group_ou
      (connection_profile_list_getbyname
       (connection_profile_list,
        connection_profile_get_name (current_connection_profile)));

  gtk_combo_set_popdown_strings (GTK_COMBO (widget),dnlist);

  if (b) {
    papa = g_list_find_custom(dnlist,b,(GCompareFunc)g_strcasecmp);
	if (papa != NULL)
    	gtk_entry_set_text (GTK_ENTRY(lookup_widget (widget, "baseou")),b);
}
  else {
   // busquemos una buena alternativa
    for (i=0;alternatives[i];i++)
      for (j=dnlist;j;j=j->next)
        if (strstr((char*)j->data,alternatives[i]) != NULL)
  	  bestmatch = (char*)j->data;

  if (bestmatch)
    gtk_entry_set_text (GTK_ENTRY
			(lookup_widget (widget, "baseou")),bestmatch);
  }


}

void
on_automaticuid_toggled (GtkToggleButton * togglebutton, gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "uidnumber"),
				FALSE);
    }
  else
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "uidnumber"),
				TRUE);
				gtk_widget_grab_focus(lookup_widget
				(GTK_WIDGET (togglebutton), "uidnumber"));
    }

}

void
on_automaticgid_toggled (GtkToggleButton * togglebutton, gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "gidnumber"),
				FALSE);
    }
  else
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "gidnumber"),
				TRUE);
				gtk_widget_grab_focus(lookup_widget
				(GTK_WIDGET (togglebutton), "gidnumber"));
    }

}


void
on_loginshellsdropdown_realize (GtkWidget * widget, gpointer user_data)
{

  gtk_combo_set_popdown_strings (GTK_COMBO (widget),
				 preferences.logindefaults.shells);
}

void
on_gidnumberdropdown_realize (GtkWidget * widget, gpointer user_data)
{

  fill_groups_dropdown (widget);
//setting default group

g_print("Last group used: %s\n" ,preferences.userbox.lastgroup );
if (preferences.userbox.lastgroup && g_strcasecmp(preferences.userbox.lastgroup,"0") != 0) {
  gtk_entry_set_text ( GTK_ENTRY(lookup_widget(widget,"gidnumber")),preferences.userbox.lastgroup);
}


}


gint
on_deleteselection_closed (GnomeDialog * gnomedialog, gpointer user_data)
{
  return (FALSE);
}


void
on_okdeletion_click (GtkButton * button, gpointer user_data)
{
	dir_entry *entry = NULL;
	GnomeIconList *itemlist = NULL;
	GList* dns = NULL;
	GList* sl = NULL;

	if (objectview_has_selection()) {
	itemlist = (GnomeIconList *) lookup_widget (GTK_WIDGET (app),
			"itemlist");

	for (sl = itemlist->selection;sl;sl=sl->next) {
		entry =
		gnome_icon_list_get_icon_data (itemlist,GPOINTER_TO_INT (sl->data));
		g_assert(dir_entry_get_dn(entry));
		if (dir_entry_is_user(entry) ) {
			g_print("\n  Inserting %s first into the delete list",dir_entry_get_dn(entry));
			dns = g_list_prepend(dns,g_strdup(dir_entry_get_dn(entry)));
		} else {
			g_print("\n  Appending %s first to the end of the delete list",dir_entry_get_dn(entry));
			dns = g_list_append(dns,g_strdup(dir_entry_get_dn(entry)));
		}
	}
	if (app_delete_interactive(dns) == LDAP_SUCCESS) {
		gtk_widget_destroy (lookup_widget (GTK_WIDGET (button),
			"deleteselection"));
	}
	g_list_foreach(dns,(GFunc)g_free,NULL);
	g_list_free(dns);
	}
}

void
on_canceldeletion_click (GtkButton * button, gpointer user_data)
{
//
//gtk_signal_emit_by_name(GTK_OBJECT(lookup_widget(GTK_WIDGET(button),"deleteselection")),"close");
  gtk_widget_destroy (lookup_widget (GTK_WIDGET (button), "deleteselection"));
}


void
on_preferences_clicked (GnomeDialog * gnomedialog,
			gint arg1, gpointer user_data)
{
  g_print ("\nClicked preferences - processing and closing dialog\n");

  if (arg1 == 0)
    {
      //returns true in case everything went okay
      if (process_preferences_dialog (gnomedialog))
	{
	  save_prefs ();
	  gtk_widget_destroy (GTK_WIDGET (gnomedialog));
	}
    }
  else
    {
      gtk_widget_destroy (GTK_WIDGET (gnomedialog));
    }

}


gint
on_preferences_close (GnomeDialog * gnomedialog, gpointer user_data)
{
  g_print ("\nClosed preferences\n");
  return (TRUE);
}


gboolean
on_preferences_delete_event (GtkWidget * widget,
			     GdkEvent * event, gpointer user_data)
{
  gtk_widget_destroy (widget);
  return FALSE;
}


void
on_pass_crypt_map (GtkWidget * widget, gpointer user_data)
{
  if (preferences.passwordcrypttype == CRYPT)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);
}


void
on_pass_cleartext_map (GtkWidget * widget, gpointer user_data)
{
  if (preferences.passwordcrypttype == CLEARTEXT)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);

}


void
on_pass_md5_map (GtkWidget * widget, gpointer user_data)
{
  if (preferences.passwordcrypttype == MD5)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);

}

void
on_pass_extended_map                   (GtkWidget       *widget,
                                        gpointer         user_data)
{
  if (preferences.passwordcrypttype == EXTENDED)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);

}

void
on_shadowmin_realize (GtkWidget * widget, gpointer user_data)
{
//pass_min_days
  char buf[32];
  if (preferences.logindefaults.PASS_MIN_DAYS)
    {
      snprintf (buf, sizeof buf, "%d",
		preferences.logindefaults.PASS_MIN_DAYS);
      gtk_entry_set_text (GTK_ENTRY (widget), buf);
    }
}


void
on_shadowmax_realize (GtkWidget * widget, gpointer user_data)
{
//pass_max_days
  char buf[32];
  if (preferences.logindefaults.PASS_MAX_DAYS)
    {
      snprintf (buf, sizeof buf, "%d",
		preferences.logindefaults.PASS_MAX_DAYS);
      gtk_entry_set_text (GTK_ENTRY (widget), buf);
    }
}


void
on_shadowwarning_realize (GtkWidget * widget, gpointer user_data)
{
//pass_warn_age
  char buf[32];
  if (preferences.logindefaults.PASS_WARN_AGE)
    {
      snprintf (buf, sizeof buf, "%d",
		preferences.logindefaults.PASS_WARN_AGE);
      gtk_entry_set_text (GTK_ENTRY (widget), buf);
    }
}


void
on_shadowinactive_realize (GtkWidget * widget, gpointer user_data)
{
//pass_inactive_age
  char buf[32];
  if (preferences.logindefaults.PASS_INACTIVE_AGE)
    {
      snprintf (buf, sizeof buf, "%d",
		preferences.logindefaults.PASS_INACTIVE_AGE);
      gtk_entry_set_text (GTK_ENTRY (widget), buf);
    }
}


void
on_shadowexpirecheck_toggled (GtkToggleButton * togglebutton,
			      gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "shadowexpire"),
				TRUE);
      gtk_widget_grab_focus(lookup_widget
				(GTK_WIDGET (togglebutton), "shadowexpire"));

    }
  else
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "shadowexpire"),
				FALSE);

    }
}



void
on_members_realize (GtkWidget * widget, gpointer user_data)
{
  static GtkTargetEntry drop_types[] = {
    {"x-application/x-directoryadmin-group", 0, TARGET_GROUP_DN}
  };

  g_print ("\nMember list realized - setting up drop properties\n");
  gtk_drag_dest_set (widget,
		     GTK_DEST_DEFAULT_ALL,
		     drop_types, ELEMENTS (drop_types), GDK_ACTION_COPY);



}


void
on_members_drag_data_received (GtkWidget * widget,
			       GdkDragContext * drag_context,
			       gint x,
			       gint y,
			       GtkSelectionData * data,
			       guint info, guint time, gpointer user_data)
{

  GtkCList *memberlist;
  gchar **row;
  gchar** uids;
  gchar* uid;
  int counter;
  gchar *received;

  received = (gchar*) data->data;
  g_print("\nThis data was received from %d: %s",info,received);
  uids = g_strsplit(received,"|",32767);

  memberlist = (GtkCList *) widget;

  for (counter=0;uids[counter];counter++) {
    uid = uids[counter];
    row = g_new0(gchar*,3);
    row[0] = g_strdup(uid);
    if (row[0])
    {
      gtk_clist_append (memberlist, row);
    }
  }

  g_strfreev(uids);

  return;


}


void
focus_me (GtkWidget * widget, gpointer user_data)
{
  gtk_widget_grab_focus (widget);
}


void
on_new_user2_activate (GtkMenuItem * menuitem, gpointer user_data)
{

  gtk_signal_emit_by_name (GTK_OBJECT (lookup_widget (GTK_WIDGET (menuitem),
						      "button_new")),
			   "clicked");
}


void
on_new_group1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_signal_emit_by_name (GTK_OBJECT (lookup_widget (GTK_WIDGET (menuitem),
						      "button_new_group")),
			   "clicked");

}


void
on_modify1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
/*  gtk_signal_emit_by_name (GTK_OBJECT (lookup_widget (GTK_WIDGET (menuitem),
						      "button_modifyselection")),
			   "clicked");*/

}


void
on_remove1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_signal_emit_by_name (GTK_OBJECT (lookup_widget (GTK_WIDGET (menuitem),
						      "button_removeselection")),
			   "clicked");

}


void
on_itemlist_select_icon (GnomeIconList * gnomeiconlist,
			 gint arg1, GdkEvent * event, gpointer user_data)
{
  gboolean found = FALSE;
  GList * wa;
  int duplicatedelement = -1;

  //g_print ("\n\nSelected icon %d",arg1);

  for (wa=gnomeiconlist->selection;wa;wa=wa->next) {
    if (found == TRUE && (int)wa->data == arg1) {
      g_print("\nFound duplicate selection. Killing.");
      duplicatedelement = arg1;
      break;
    }
    if ((int)wa->data == arg1) {
      found = TRUE;
    }

  }

  if (duplicatedelement > -1)
  gnomeiconlist->selection =
g_list_remove(gnomeiconlist->selection,(gpointer)arg1);

  objectview_icon_dump_selections(gnomeiconlist);

//  gnome_icon_list_select_icon(gnomeiconlist,wa->data);


  if (objectview_has_selection())
  app_enable_editing_controls();





}


void
on_itemlist_realize (GtkWidget * widget, gpointer user_data)
{
  static GtkTargetEntry drag_types[] = {
    {"x-application/x-directoryadmin-group", 0, TARGET_GROUP_DN}
  };

  g_print ("\nIcon list realized - setting up drag and drop\n");
  gtk_drag_source_set (widget,
		       GDK_BUTTON1_MASK,
		       drag_types, ELEMENTS (drag_types), GDK_ACTION_COPY);


}

void
on_itemlist_drag_data_get (GtkWidget * widget,
			   GdkDragContext * drag_context,
			   GtkSelectionData * data,
			   guint info, guint time, gpointer user_data)
{
  GnomeIconList *itemlist;
  int pos;
  dir_entry *entry = NULL;
  GList* iter = NULL;
  gchar* ttmp = NULL;
  gchar* tobsent = NULL;

  itemlist = (GnomeIconList *) widget;
  if (objectview_has_selection())
    tobsent = g_strdup("");
    g_print("\nNumber of icons selected: %d     list length: %d",
       itemlist->icons,g_list_length(itemlist->selection)
    );


    for (iter=itemlist->selection;iter;iter=iter->next)
    {
      pos = GPOINTER_TO_INT (iter->data);
      entry = gnome_icon_list_get_icon_data (itemlist, pos);
/*      g_print("\n   Selected position: %d",pos);
      g_print("\n   Selected DN: %s",dir_entry_get_dn(entry));
      g_print("\n   Selected UID: %s",dir_entry_get_uid(entry));
	  */


      if (dir_entry_get_uid(entry)) {
        ttmp = tobsent;
        tobsent = g_strconcat(tobsent,dir_entry_get_uid(entry),"|",NULL);
        g_free(ttmp);
      }

    }

      g_print ("\nFinally sending: %s", tobsent);

      gtk_selection_data_set
         (data,data->target, strlen(tobsent), tobsent, strlen(tobsent));

}

gboolean
on_itemlist_button_press_event (GtkWidget * widget,
				GdkEventButton * event, gpointer user_data)
{
  GtkWidget *scrolledwindow;
 scrolledwindow= lookup_widget(app,"itemlistscrolledwindow");
gtk_widget_grab_focus(scrolledwindow);

  icon_list_click_event ((GnomeIconList *) widget, event, user_data);


  return FALSE;
}

void
on_druid_firsttime_druid_cancel (GnomeDruid * gnomedruid, gpointer user_data)
{
  gtk_widget_destroy (lookup_widget ((GtkWidget *) gnomedruid,
				     "druid_firsttime"));

}



void
on_finish_finish (GnomeDruidPage * gnomedruidpage,
		  gpointer arg1, gpointer user_data)
{
  connection_profile *newone;
  gchar *nombrecitocojudo;
  GtkWidget *button;

  button = (GtkWidget *) gnomedruidpage;

  nombrecitocojudo =
    gtk_entry_get_text ((GtkEntry *)
			lookup_widget ((GtkWidget *) button,
				       "entry_profile_name"));
  if (strlen (nombrecitocojudo) == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a profile name"));
      return;
    }

  nombrecitocojudo =
    gtk_entry_get_text ((GtkEntry *)
			lookup_widget ((GtkWidget *) button,
				       "entry_login_server"));
  if (strlen (nombrecitocojudo) == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a server address"));
      return;
    }

  nombrecitocojudo =
    gtk_entry_get_text ((GtkEntry *)
			lookup_widget ((GtkWidget *) button,
				       "entry_profile_name"));
  if (connection_profile_list_getbyname
      (connection_profile_list, nombrecitocojudo) != NULL)
    {
//    g_print("\nItem was found on the list.  Not admissible.");
      gtk_widget_show (create_messagebox_with_message
		       ("An entry with this name already exists"));
      return;
    }


  newone =
    connection_profile_new (gtk_entry_get_text
			    ((GtkEntry *)
			     lookup_widget ((GtkWidget *) button,
					    "entry_profile_name")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_dn")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_pw")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_server")),
			    gtk_toggle_button_get_active ((GtkToggleButton *)
				    		lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_tls")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_treeroot")));
  connection_profile_list =
    connection_profile_list_add (connection_profile_list, newone);


  while (button->parent != NULL)
    button = button->parent;

/*  button = lookup_widget ((GtkWidget *) button, "druid_new_profile");
  if (button == NULL) 
      button = lookup_widget ((GtkWidget *) button, "druid_firsttime"); */


  if (gtk_object_get_user_data ((GtkObject *) button))
    list_profiles_fill (gtk_object_get_user_data ((GtkObject *) button));

  gtk_widget_destroy (button);

}


void
on_rfc2307bis_map (GtkWidget * widget, gpointer user_data)
{
  if (preferences.rfc2307bis == FALSE)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), FALSE);
}


void
on_enablesambaobjectclass_toggled (GtkToggleButton * togglebutton,
				   gpointer user_data)
{

  if (GTK_TOGGLE_BUTTON ((GtkToggleButton *) togglebutton)->active)
    {
      g_print ("Samba activado\n");
      gtk_widget_show (lookup_widget (GTK_WIDGET (togglebutton),
				      "framesamba"));
					        gtk_widget_grab_focus(lookup_widget
				(GTK_WIDGET (togglebutton), SAMBA_HOME_PATH));

    }
  else
    {
      g_print ("Samba desactivado\n");
      gtk_widget_hide (lookup_widget (GTK_WIDGET (togglebutton),
				      "framesamba"));
    }
}

gboolean
on_itemlist_key_press_event            (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
//  g_print("\nTecla %d (%s) releaseada",event->keyval,event->string);
  return FALSE;
}


gboolean
on_itemlist_key_release_event          (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
//  g_print("\nTecla %d (%s) releaseada",event->keyval,event->string);
  return FALSE;
}


gboolean
on_itemlist_client_event               (GtkWidget       *widget,
                                        GdkEventClient  *event,
                                        gpointer         user_data)
{
  g_print("\nClient event");
  return FALSE;
}


void
on_button_refresh_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  app_refresh();
}


gboolean
on_mainwindow_client_event             (GtkWidget       *widget,
                                        GdkEventClient  *event,
                                        gpointer         user_data)
{
  g_print("\nClient event");
  return FALSE;
}


gboolean
on_mainwindow_key_press_event          (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{

gboolean r;
r =objectview_keypress(event);
if (r) {g_print("Key processed - not allowing it to bubble up into the UI\n\n");return TRUE;
}
  return FALSE;

}


gboolean
on_mainwindow_key_release_event        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
//  g_print("\nTecla %d (%s) releaseada",event->keyval,event->string);
  return FALSE;

}


void
on_itemlist_unselect_icon              (GnomeIconList   *gnomeiconlist,
                                        gint             arg1,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{


//g_print ("\n\nUnselected icon %d",arg1);
objectview_icon_dump_selections(gnomeiconlist);

if (objectview_has_selection() == FALSE) {
 app_disable_editing_controls();
}

}


void
on_invcredok_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
   gchar * name;
   connection_profile * a;

   name = gtk_object_get_user_data((GtkObject*)lookup_widget ((GtkWidget *) button, "invalidcredentials"));
   g_print(name);
   a= connection_profile_list_getbyname (connection_profile_list, name);

    connection_profile_set_dn(a,
      gtk_entry_get_text((GtkEntry*)lookup_widget ((GtkWidget *) button, "userid")));
    connection_profile_set_password(a,
      gtk_entry_get_text((GtkEntry*)lookup_widget ((GtkWidget *) button, "password")));

    gtk_widget_destroy (lookup_widget ((GtkWidget *) button, "invalidcredentials"));


gtk_signal_handler_block_by_func   (
GTK_OBJECT(lookup_widget (app, "button_connect")),
                                             (GtkSignalFunc)on_button_connect_toggled,
                                             NULL);

    gtk_toggle_button_set_active ((GtkToggleButton *)
                                    lookup_widget (app, "button_connect"),
                                    TRUE);
gtk_signal_handler_unblock_by_func   (
GTK_OBJECT(lookup_widget (app, "button_connect")),
                                             (GtkSignalFunc)on_button_connect_toggled,
                                             NULL);

    app_connect(name);




    g_free(name);
}


void
on_button45_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
    gchar * name;

    name = gtk_object_get_user_data((GtkObject*)lookup_widget ((GtkWidget *) button, "invalidcredentials"));

    gtk_toggle_button_set_active ((GtkToggleButton *)
                                    lookup_widget (app, "button_connect"),
                                    FALSE);
    g_free(name);
    gtk_widget_destroy (lookup_widget ((GtkWidget *) button, "invalidcredentials"));

}




void
on_selectuser_members_realize          (GtkWidget       *widget,
                                        gpointer         user_data)
{
	GList* eligibles=NULL;
	GtkCList*d;
	GtkCList*parentlist;
	char* row[2];
	char*name;
	gint currow;
	gboolean found;
	char*dn;
    GList*l=NULL;
	dir_entry* currentry;
	GtkEntry* textbox;
	gchar* filter;
	gchar*tempname;
	//gchar*tempneedle;gchar*temphaystack;
	row[1]=NULL;

	d=(GtkCList*)lookup_widget(widget,"members");
	parentlist=(GtkCList*)lookup_widget(widget,"selectuser");
	parentlist=gtk_object_get_user_data((GtkObject*)parentlist);
	textbox = (GtkEntry*)lookup_widget(widget,"filter");



//collect eligibles
	g_print("\nClearing list...\n");
	gtk_clist_clear(d);
	g_print("\nSelecting eligibles...\n");
	for (l=g_list_first(cached_dir_entries);l;l=l->next) {
		g_assert(l->data);
		currentry = l->data;
		if(dir_entry_is_user(currentry)) {
			g_print("Found user %s\n",dir_entry_get_name(currentry));
			//loop through the list to find out whether there is such item
			found = 0;
			for (currow=parentlist->rows - 1;currow>=0;currow --) {
	//			g_print("    Comparing against %s...",gtk_clist_get_row_data(parentlist,currow));
				if (g_strcasecmp(gtk_clist_get_row_data(parentlist,currow),currentry->dn) == 0) {
					found = 1;
					g_print("   Match! Appending to list since not found yet on current user list\n");
				}
				g_print("\n");
			}
			if (found == 0) eligibles=g_list_append(eligibles,currentry);
		}
	}
//save the eligibles list on the members list of this window
	g_print("Saving the eligibles...\n");
	gtk_object_set_user_data((GtkObject*)d,eligibles);

//fill the list for the first time with eligibles
	filter = gtk_entry_get_text(textbox);
	if (strlen(filter) < 1 ) filter = NULL;
	if (filter) { filter = g_strdup(filter);g_strdown(filter); }
	g_print("Filling list with eligibles...\n");
	for (l=g_list_first(eligibles);l;l=l->next) {
		dn=g_strdup(dir_entry_get_dn(l->data));
		g_assert(dn);
		name=dir_entry_get_name(l->data);
		if (name) name=g_strconcat(name, " (",dn,")",NULL);
		else name=g_strdup(dn);
		tempname = name;
		g_assert(name);
		g_print("Name before lowercasing: %s\n",name);
		tempname = g_strdup(name); g_strdown(tempname);
		g_print("Name after lowercasing: %s\n",tempname);
		if (filter == NULL || strstr(tempname,filter) != NULL) {
			if (filter) g_print("Filter matched: %s\n",filter);
			else g_print("No filter, appending to list anyway\n");
			row[0] = name;
			currow = gtk_clist_append(d,row);
			gtk_clist_set_row_data(d,currow,dn);
		}
		g_free(tempname);
/*		g_free(dn);
		g_free(name);*/
	}
	g_free(filter);


	gtk_clist_columns_autosize(d);


}



void
on_selectuser_combofilter_map (GtkWidget * widget, gpointer user_data)
{

  //gint i;
  GList * dnlist;
  GtkEntry*m;

  dnlist = get_orgunit_dn_list_from_cache ();

  gtk_combo_set_popdown_strings (GTK_COMBO (widget),dnlist);

m=(GtkEntry*)lookup_widget(widget,"filter");
gtk_entry_set_text(m,"");
}


void
on_connect1____activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	  gtk_toggle_button_set_active ((GtkToggleButton*)lookup_widget(app,"button_connect"), TRUE);

}


void
on_disconnect1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	  gtk_toggle_button_set_active ((GtkToggleButton*)lookup_widget(app,"button_connect"), FALSE);

}


void
on_manage_profiles1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
gtk_widget_show (create_preferences ());

}


void
on_refresh1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  app_refresh();
}

void
on_entry_login_tls_released            (GtkButton       *button,
                                        gpointer         user_data)
{
# ifndef HAVE_TLS
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget
			       (button, "entry_login_tls")), FALSE);
  g_print("TLS was not found by configure to be supported by ");
  g_print("your ldap libraries.\n");
  gtk_widget_show (create_messagebox_with_message
    ("TLS was not found by configure to be supported by your ldap libraries."));
# endif

}




gboolean
on_modifyuser_key_press_event          (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{

modifyuser_keypress(widget,event);

  return TRUE;
}


gboolean
on_modifygroup_key_press_event          (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{

  modifygroup_keypress(widget,event);

  return TRUE;
}




gboolean
on_druid_new_group_key_press_event
                                        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
newgroup_keypress(widget,event);

  return FALSE;
}




gboolean
on_druidpagegroupstart_next            (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data)
{
   gtk_widget_grab_focus(lookup_widget((GtkWidget*)gnomedruidpage,"cn"));

  return FALSE;
}


gboolean
on_druid_new_user_key_press_event      (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
newuser_keypress(widget,event);

  return FALSE;
}


void
on_druid_new_user_show                 (GtkWidget       *widget,
                                        gpointer         user_data)
{


/// kill default accelerators
GSList*accel ;
accel = gtk_accel_groups_from_object(GTK_OBJECT(widget));
gtk_accel_group_unref(accel->data);
gtk_window_remove_accel_group((GtkWindow*)widget,accel->data);


}


gboolean
on_druidpagestart3_next                (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data)
{
      gtk_widget_grab_focus (lookup_widget
		       (GTK_WIDGET (gnomedruidpage), "givenname"));

  return FALSE;
}


gboolean
on_druidpageorginfo_next               (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data)
{
      gtk_widget_grab_focus (lookup_widget
		       (GTK_WIDGET (gnomedruidpage), "mail"));

  return FALSE;
}


gboolean
on_druidpagemail_next                  (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data)
{
      gtk_widget_grab_focus (lookup_widget
		       (GTK_WIDGET (gnomedruidpage), "homedirectory"));

  return FALSE;
}


gboolean
on_druidpagesamba_next                 (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data)
{
      gtk_widget_grab_focus (lookup_widget
		       (GTK_WIDGET (gnomedruidpage), "shadowmin"));

  return FALSE;
}


gboolean
on_invalidcredentials_key_press_event  (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
		if (event->keyval == 65293 || event->keyval == 65421) {
			gtk_button_clicked ( (GtkButton*)lookup_widget(widget,"invcredok") );
        }

  return FALSE;
}



void
on_seleccionar_todo_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    objectview_select_all();
}


void
on_deseleccionar_todo_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    objectview_clear_selection();

}


void
on_druid_new_user_druid_realize        (GtkWidget       *widget,
                                        gpointer         user_data)
{


	// now it's time to load defaults for the new user.

	if (preferences.userbox.sambaused) {
	gtk_toggle_button_set_active((GtkToggleButton*)lookup_widget(widget,"enablesambaobjectclass"),TRUE);
	} else {
	gtk_toggle_button_set_active((GtkToggleButton*)lookup_widget(widget,"enablesambaobjectclass"),FALSE);
	}


}


void
on_filterbutton_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
   objectview_fill();
}


void
on_filterclear_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_entry_set_text(GTK_ENTRY(lookup_widget(app,"filter")),"");
  objectview_fill();
}


void
on_avoidconflicts_toggled              (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_set_sensitive (lookup_widget
		       (GTK_WIDGET (togglebutton), "frame_avoidconflictoptions"),TRUE);
      /* If control reaches here, the toggle button is down */

    }
  else
    {
      gtk_widget_set_sensitive (lookup_widget
		       (GTK_WIDGET (togglebutton), "frame_avoidconflictoptions"),FALSE);
      /* If control reaches here, the toggle button is up */
    }


}


void
on_preferences_show                    (GtkWidget       *widget,
                                        gpointer         user_data)
{
//now here we're supposed to load preference values into the dialog box

fill_prefsdialog(widget);

}


void
on_sambaDomainNameDropdown_realize     (GtkWidget       *widget,
                                        gpointer         user_data)
{
  connection_profile *usethisone = NULL;
  gchar *warning = NULL;
  usethisone = current_connection_profile;
    
  gtk_combo_set_popdown_strings (GTK_COMBO (widget),
				 app_get_sambadomains_from_ldap(usethisone, &warning));
  app_handle_ldap_error(LDAP_SUCCESS, &warning);
}


void
on_sambaGroupMapping_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "sambaDomainNameDropdown"),
				TRUE);
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "sambaDomainMappingDropdown"),
				TRUE);
    }
  else
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "sambaDomainNameDropdown"),
				FALSE);
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "sambaDomainMappingDropdown"),
				FALSE);
    }
}



void
on_addalias_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{

  GtkCList *mailLocalAddress = NULL;
  GtkWidget *mywindow = NULL;
  GtkEntry* alias;
  char *row[1];
  row[0] = NULL;


  mailLocalAddress =
    (GtkCList *) lookup_widget (GTK_WIDGET (button), "mailLocalAddress");

  alias = GTK_ENTRY
			(lookup_widget
			 (GTK_WIDGET (button), "alias"));

  row[0] =
    gtk_entry_get_text (alias);
  if (strlen (row[0]) == 0)
    {
      mywindow =
	create_messagebox_with_message ("Please supply an e-mail address");
      gtk_widget_show (mywindow);
    }
  else
    {
      gtk_clist_append (mailLocalAddress, row);
      gtk_entry_set_text (alias, "");
      gtk_widget_grab_focus(GTK_WIDGET(alias));
    }

}


void
on_delalias_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{

  GtkCList *mailLocalAddress = NULL;
  mailLocalAddress =
    (GtkCList *) lookup_widget (GTK_WIDGET (button), "mailLocalAddress");
  if (mailLocalAddress->selection)
    {
      gtk_clist_remove (mailLocalAddress,
			GPOINTER_TO_INT (mailLocalAddress->selection->data));
    }
  gtk_widget_grab_focus(GTK_WIDGET(mailLocalAddress));

}


void
on_jpegPhotoButton_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
g_print("Clicked on jpeg press!!!!");

}


void
on_sambaDomainMappingDropdown_realize  (GtkWidget       *widget,
                                        gpointer         user_data)
{
  gtk_combo_set_popdown_strings (GTK_COMBO (widget),
				 app_get_sambagroupmappingdropdown());
}

