/*
 *========================================================================
 * $Id: dieharder.c 127 2004-11-20 18:17:55Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 *  run_diehard_rank_32x32()
 *========================================================================
 */

#include "dieharder.h"

void run_diehard_rank_32x32()
{

 int i;

 /*
  * Declare the results struct.
  */
 Test **diehard_rank_32x32_test;

 /*
  * First we create the test (to set some values displayed in test header
  * correctly).
  */
 diehard_rank_32x32_test = create_test(&diehard_rank_32x32_dtest,tsamples,psamples,&diehard_rank_32x32);

 /*
  * Set any GLOBAL data used by the test.
  */
 /*
  * Note that this assumes that 8*sizeof(uint) >= 32!
  */
 diehard_rank_32x32_mtx = (uint **)malloc(32*sizeof(uint*));
 for(i=0;i<32;i++)diehard_rank_32x32_mtx[i] = (uint *)malloc(sizeof(uint));


 /*
  * Show the standard test header for this test.
  */
 show_test_header(&diehard_rank_32x32_dtest,diehard_rank_32x32_test);

 /*
  * This is where we can output any test-specific information.
  */

 /*
  * Set any GLOBAL data used by the test.  Then call the test itself
  * This fills in the results in the Test struct.
  */
 std_test(&diehard_rank_32x32_dtest,diehard_rank_32x32_test);

 /*
  * This almost certainly belongs in the show_test_results section,
  * possibly with additional conditionals rejecting test results involving
  * rewinds, period.
  */
 if(strncmp("file_input",gsl_rng_name(rng),10) == 0){
   printf("# %u rands were used in this test\n",file_input_get_rtot(rng));
   printf("# The file %s was rewound %u times\n",gsl_rng_name(rng),file_input_get_rewind_cnt(rng));
 }

 /*
  * Show standard test results, for all statistics generated by a single run.
  */
 show_test_results(&diehard_rank_32x32_dtest,diehard_rank_32x32_test);

 /*
  * Free any allocated globals before exit (or leak).
  */
 for(i=0;i<32;i++){
   if(diehard_rank_32x32_mtx[i]) free(diehard_rank_32x32_mtx[i]);
 }
 free(diehard_rank_32x32_mtx);

}
